// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.14.0
// source: envoy/api/v2/core/protocol.proto

package envoy_api_v2_core

import (
	_ "github.com/cncf/udpa/go/udpa/annotations"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Action to take when Envoy receives client request with header names containing underscore
// characters.
// Underscore character is allowed in header names by the RFC-7230 and this behavior is implemented
// as a security measure due to systems that treat '_' and '-' as interchangeable. Envoy by default allows client request headers with underscore
// characters.
type HttpProtocolOptions_HeadersWithUnderscoresAction int32

const (
	// Allow headers with underscores. This is the default behavior.
	HttpProtocolOptions_ALLOW HttpProtocolOptions_HeadersWithUnderscoresAction = 0
	// Reject client request. HTTP/1 requests are rejected with the 400 status. HTTP/2 requests
	// end with the stream reset. The "httpN.requests_rejected_with_underscores_in_headers" counter
	// is incremented for each rejected request.
	HttpProtocolOptions_REJECT_REQUEST HttpProtocolOptions_HeadersWithUnderscoresAction = 1
	// Drop the header with name containing underscores. The header is dropped before the filter chain is
	// invoked and as such filters will not see dropped headers. The
	// "httpN.dropped_headers_with_underscores" is incremented for each dropped header.
	HttpProtocolOptions_DROP_HEADER HttpProtocolOptions_HeadersWithUnderscoresAction = 2
)

// Enum value maps for HttpProtocolOptions_HeadersWithUnderscoresAction.
var (
	HttpProtocolOptions_HeadersWithUnderscoresAction_name = map[int32]string{
		0: "ALLOW",
		1: "REJECT_REQUEST",
		2: "DROP_HEADER",
	}
	HttpProtocolOptions_HeadersWithUnderscoresAction_value = map[string]int32{
		"ALLOW":          0,
		"REJECT_REQUEST": 1,
		"DROP_HEADER":    2,
	}
)

func (x HttpProtocolOptions_HeadersWithUnderscoresAction) Enum() *HttpProtocolOptions_HeadersWithUnderscoresAction {
	p := new(HttpProtocolOptions_HeadersWithUnderscoresAction)
	*p = x
	return p
}

func (x HttpProtocolOptions_HeadersWithUnderscoresAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpProtocolOptions_HeadersWithUnderscoresAction) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_api_v2_core_protocol_proto_enumTypes[0].Descriptor()
}

func (HttpProtocolOptions_HeadersWithUnderscoresAction) Type() protoreflect.EnumType {
	return &file_envoy_api_v2_core_protocol_proto_enumTypes[0]
}

func (x HttpProtocolOptions_HeadersWithUnderscoresAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpProtocolOptions_HeadersWithUnderscoresAction.Descriptor instead.
func (HttpProtocolOptions_HeadersWithUnderscoresAction) EnumDescriptor() ([]byte, []int) {
	return file_envoy_api_v2_core_protocol_proto_rawDescGZIP(), []int{2, 0}
}

// [#not-implemented-hide:]
type TcpProtocolOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *TcpProtocolOptions) Reset() {
	*x = TcpProtocolOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TcpProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpProtocolOptions) ProtoMessage() {}

func (x *TcpProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpProtocolOptions.ProtoReflect.Descriptor instead.
func (*TcpProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_api_v2_core_protocol_proto_rawDescGZIP(), []int{0}
}

type UpstreamHttpProtocolOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set transport socket `SNI <https://en.wikipedia.org/wiki/Server_Name_Indication>`_ for new
	// upstream connections based on the downstream HTTP host/authority header, as seen by the
	// :ref:`router filter <config_http_filters_router>`.
	AutoSni bool `protobuf:"varint,1,opt,name=auto_sni,json=autoSni,proto3" json:"auto_sni,omitempty"`
	// Automatic validate upstream presented certificate for new upstream connections based on the
	// downstream HTTP host/authority header, as seen by the
	// :ref:`router filter <config_http_filters_router>`.
	// This field is intended to set with `auto_sni` field.
	AutoSanValidation bool `protobuf:"varint,2,opt,name=auto_san_validation,json=autoSanValidation,proto3" json:"auto_san_validation,omitempty"`
}

func (x *UpstreamHttpProtocolOptions) Reset() {
	*x = UpstreamHttpProtocolOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpstreamHttpProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpstreamHttpProtocolOptions) ProtoMessage() {}

func (x *UpstreamHttpProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpstreamHttpProtocolOptions.ProtoReflect.Descriptor instead.
func (*UpstreamHttpProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_api_v2_core_protocol_proto_rawDescGZIP(), []int{1}
}

func (x *UpstreamHttpProtocolOptions) GetAutoSni() bool {
	if x != nil {
		return x.AutoSni
	}
	return false
}

func (x *UpstreamHttpProtocolOptions) GetAutoSanValidation() bool {
	if x != nil {
		return x.AutoSanValidation
	}
	return false
}

// [#next-free-field: 6]
type HttpProtocolOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The idle timeout for connections. The idle timeout is defined as the
	// period in which there are no active requests. When the
	// idle timeout is reached the connection will be closed. If the connection is an HTTP/2
	// downstream connection a drain sequence will occur prior to closing the connection, see
	// :ref:`drain_timeout
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.drain_timeout>`.
	// Note that request based timeouts mean that HTTP/2 PINGs will not keep the connection alive.
	// If not specified, this defaults to 1 hour. To disable idle timeouts explicitly set this to 0.
	//
	// .. warning::
	//   Disabling this timeout has a highly likelihood of yielding connection leaks due to lost TCP
	//   FIN packets, etc.
	IdleTimeout *duration.Duration `protobuf:"bytes,1,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	// The maximum duration of a connection. The duration is defined as a period since a connection
	// was established. If not set, there is no max duration. When max_connection_duration is reached
	// the connection will be closed. Drain sequence will occur prior to closing the connection if
	// if's applicable. See :ref:`drain_timeout
	// <envoy_api_field_config.filter.network.http_connection_manager.v2.HttpConnectionManager.drain_timeout>`.
	// Note: not implemented for upstream connections.
	MaxConnectionDuration *duration.Duration `protobuf:"bytes,3,opt,name=max_connection_duration,json=maxConnectionDuration,proto3" json:"max_connection_duration,omitempty"`
	// The maximum number of headers. If unconfigured, the default
	// maximum number of request headers allowed is 100. Requests that exceed this limit will receive
	// a 431 response for HTTP/1.x and cause a stream reset for HTTP/2.
	MaxHeadersCount *wrappers.UInt32Value `protobuf:"bytes,2,opt,name=max_headers_count,json=maxHeadersCount,proto3" json:"max_headers_count,omitempty"`
	// Total duration to keep alive an HTTP request/response stream. If the time limit is reached the stream will be
	// reset independent of any other timeouts. If not specified, this value is not set.
	MaxStreamDuration *duration.Duration `protobuf:"bytes,4,opt,name=max_stream_duration,json=maxStreamDuration,proto3" json:"max_stream_duration,omitempty"`
	// Action to take when a client request with a header name containing underscore characters is received.
	// If this setting is not specified, the value defaults to ALLOW.
	// Note: upstream responses are not affected by this setting.
	HeadersWithUnderscoresAction HttpProtocolOptions_HeadersWithUnderscoresAction `protobuf:"varint,5,opt,name=headers_with_underscores_action,json=headersWithUnderscoresAction,proto3,enum=envoy.api.v2.core.HttpProtocolOptions_HeadersWithUnderscoresAction" json:"headers_with_underscores_action,omitempty"`
}

func (x *HttpProtocolOptions) Reset() {
	*x = HttpProtocolOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpProtocolOptions) ProtoMessage() {}

func (x *HttpProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpProtocolOptions.ProtoReflect.Descriptor instead.
func (*HttpProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_api_v2_core_protocol_proto_rawDescGZIP(), []int{2}
}

func (x *HttpProtocolOptions) GetIdleTimeout() *duration.Duration {
	if x != nil {
		return x.IdleTimeout
	}
	return nil
}

func (x *HttpProtocolOptions) GetMaxConnectionDuration() *duration.Duration {
	if x != nil {
		return x.MaxConnectionDuration
	}
	return nil
}

func (x *HttpProtocolOptions) GetMaxHeadersCount() *wrappers.UInt32Value {
	if x != nil {
		return x.MaxHeadersCount
	}
	return nil
}

func (x *HttpProtocolOptions) GetMaxStreamDuration() *duration.Duration {
	if x != nil {
		return x.MaxStreamDuration
	}
	return nil
}

func (x *HttpProtocolOptions) GetHeadersWithUnderscoresAction() HttpProtocolOptions_HeadersWithUnderscoresAction {
	if x != nil {
		return x.HeadersWithUnderscoresAction
	}
	return HttpProtocolOptions_ALLOW
}

// [#next-free-field: 6]
type Http1ProtocolOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Handle HTTP requests with absolute URLs in the requests. These requests
	// are generally sent by clients to forward/explicit proxies. This allows clients to configure
	// envoy as their HTTP proxy. In Unix, for example, this is typically done by setting the
	// *http_proxy* environment variable.
	AllowAbsoluteUrl *wrappers.BoolValue `protobuf:"bytes,1,opt,name=allow_absolute_url,json=allowAbsoluteUrl,proto3" json:"allow_absolute_url,omitempty"`
	// Handle incoming HTTP/1.0 and HTTP 0.9 requests.
	// This is off by default, and not fully standards compliant. There is support for pre-HTTP/1.1
	// style connect logic, dechunking, and handling lack of client host iff
	// *default_host_for_http_10* is configured.
	AcceptHttp_10 bool `protobuf:"varint,2,opt,name=accept_http_10,json=acceptHttp10,proto3" json:"accept_http_10,omitempty"`
	// A default host for HTTP/1.0 requests. This is highly suggested if *accept_http_10* is true as
	// Envoy does not otherwise support HTTP/1.0 without a Host header.
	// This is a no-op if *accept_http_10* is not true.
	DefaultHostForHttp_10 string `protobuf:"bytes,3,opt,name=default_host_for_http_10,json=defaultHostForHttp10,proto3" json:"default_host_for_http_10,omitempty"`
	// Describes how the keys for response headers should be formatted. By default, all header keys
	// are lower cased.
	HeaderKeyFormat *Http1ProtocolOptions_HeaderKeyFormat `protobuf:"bytes,4,opt,name=header_key_format,json=headerKeyFormat,proto3" json:"header_key_format,omitempty"`
	// Enables trailers for HTTP/1. By default the HTTP/1 codec drops proxied trailers.
	//
	// .. attention::
	//
	//   Note that this only happens when Envoy is chunk encoding which occurs when:
	//   - The request is HTTP/1.1.
	//   - Is neither a HEAD only request nor a HTTP Upgrade.
	//   - Not a response to a HEAD request.
	//   - The content length header is not present.
	EnableTrailers bool `protobuf:"varint,5,opt,name=enable_trailers,json=enableTrailers,proto3" json:"enable_trailers,omitempty"`
}

func (x *Http1ProtocolOptions) Reset() {
	*x = Http1ProtocolOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Http1ProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http1ProtocolOptions) ProtoMessage() {}

func (x *Http1ProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http1ProtocolOptions.ProtoReflect.Descriptor instead.
func (*Http1ProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_api_v2_core_protocol_proto_rawDescGZIP(), []int{3}
}

func (x *Http1ProtocolOptions) GetAllowAbsoluteUrl() *wrappers.BoolValue {
	if x != nil {
		return x.AllowAbsoluteUrl
	}
	return nil
}

func (x *Http1ProtocolOptions) GetAcceptHttp_10() bool {
	if x != nil {
		return x.AcceptHttp_10
	}
	return false
}

func (x *Http1ProtocolOptions) GetDefaultHostForHttp_10() string {
	if x != nil {
		return x.DefaultHostForHttp_10
	}
	return ""
}

func (x *Http1ProtocolOptions) GetHeaderKeyFormat() *Http1ProtocolOptions_HeaderKeyFormat {
	if x != nil {
		return x.HeaderKeyFormat
	}
	return nil
}

func (x *Http1ProtocolOptions) GetEnableTrailers() bool {
	if x != nil {
		return x.EnableTrailers
	}
	return false
}

// [#next-free-field: 14]
type Http2ProtocolOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `Maximum table size <https://httpwg.org/specs/rfc7541.html#rfc.section.4.2>`_
	// (in octets) that the encoder is permitted to use for the dynamic HPACK table. Valid values
	// range from 0 to 4294967295 (2^32 - 1) and defaults to 4096. 0 effectively disables header
	// compression.
	HpackTableSize *wrappers.UInt32Value `protobuf:"bytes,1,opt,name=hpack_table_size,json=hpackTableSize,proto3" json:"hpack_table_size,omitempty"`
	// `Maximum concurrent streams <https://httpwg.org/specs/rfc7540.html#rfc.section.5.1.2>`_
	// allowed for peer on one HTTP/2 connection. Valid values range from 1 to 2147483647 (2^31 - 1)
	// and defaults to 2147483647.
	//
	// For upstream connections, this also limits how many streams Envoy will initiate concurrently
	// on a single connection. If the limit is reached, Envoy may queue requests or establish
	// additional connections (as allowed per circuit breaker limits).
	MaxConcurrentStreams *wrappers.UInt32Value `protobuf:"bytes,2,opt,name=max_concurrent_streams,json=maxConcurrentStreams,proto3" json:"max_concurrent_streams,omitempty"`
	// `Initial stream-level flow-control window
	// <https://httpwg.org/specs/rfc7540.html#rfc.section.6.9.2>`_ size. Valid values range from 65535
	// (2^16 - 1, HTTP/2 default) to 2147483647 (2^31 - 1, HTTP/2 maximum) and defaults to 268435456
	// (256 * 1024 * 1024).
	//
	// NOTE: 65535 is the initial window size from HTTP/2 spec. We only support increasing the default
	// window size now, so it's also the minimum.
	//
	// This field also acts as a soft limit on the number of bytes Envoy will buffer per-stream in the
	// HTTP/2 codec buffers. Once the buffer reaches this pointer, watermark callbacks will fire to
	// stop the flow of data to the codec buffers.
	InitialStreamWindowSize *wrappers.UInt32Value `protobuf:"bytes,3,opt,name=initial_stream_window_size,json=initialStreamWindowSize,proto3" json:"initial_stream_window_size,omitempty"`
	// Similar to *initial_stream_window_size*, but for connection-level flow-control
	// window. Currently, this has the same minimum/maximum/default as *initial_stream_window_size*.
	InitialConnectionWindowSize *wrappers.UInt32Value `protobuf:"bytes,4,opt,name=initial_connection_window_size,json=initialConnectionWindowSize,proto3" json:"initial_connection_window_size,omitempty"`
	// Allows proxying Websocket and other upgrades over H2 connect.
	AllowConnect bool `protobuf:"varint,5,opt,name=allow_connect,json=allowConnect,proto3" json:"allow_connect,omitempty"`
	// [#not-implemented-hide:] Hiding until envoy has full metadata support.
	// Still under implementation. DO NOT USE.
	//
	// Allows metadata. See [metadata
	// docs](https://github.com/envoyproxy/envoy/blob/main/source/docs/h2_metadata.md) for more
	// information.
	AllowMetadata bool `protobuf:"varint,6,opt,name=allow_metadata,json=allowMetadata,proto3" json:"allow_metadata,omitempty"`
	// Limit the number of pending outbound downstream frames of all types (frames that are waiting to
	// be written into the socket). Exceeding this limit triggers flood mitigation and connection is
	// terminated. The ``http2.outbound_flood`` stat tracks the number of terminated connections due
	// to flood mitigation. The default limit is 10000.
	// [#comment:TODO: implement same limits for upstream outbound frames as well.]
	MaxOutboundFrames *wrappers.UInt32Value `protobuf:"bytes,7,opt,name=max_outbound_frames,json=maxOutboundFrames,proto3" json:"max_outbound_frames,omitempty"`
	// Limit the number of pending outbound downstream frames of types PING, SETTINGS and RST_STREAM,
	// preventing high memory utilization when receiving continuous stream of these frames. Exceeding
	// this limit triggers flood mitigation and connection is terminated. The
	// ``http2.outbound_control_flood`` stat tracks the number of terminated connections due to flood
	// mitigation. The default limit is 1000.
	// [#comment:TODO: implement same limits for upstream outbound frames as well.]
	MaxOutboundControlFrames *wrappers.UInt32Value `protobuf:"bytes,8,opt,name=max_outbound_control_frames,json=maxOutboundControlFrames,proto3" json:"max_outbound_control_frames,omitempty"`
	// Limit the number of consecutive inbound frames of types HEADERS, CONTINUATION and DATA with an
	// empty payload and no end stream flag. Those frames have no legitimate use and are abusive, but
	// might be a result of a broken HTTP/2 implementation. The `http2.inbound_empty_frames_flood``
	// stat tracks the number of connections terminated due to flood mitigation.
	// Setting this to 0 will terminate connection upon receiving first frame with an empty payload
	// and no end stream flag. The default limit is 1.
	// [#comment:TODO: implement same limits for upstream inbound frames as well.]
	MaxConsecutiveInboundFramesWithEmptyPayload *wrappers.UInt32Value `protobuf:"bytes,9,opt,name=max_consecutive_inbound_frames_with_empty_payload,json=maxConsecutiveInboundFramesWithEmptyPayload,proto3" json:"max_consecutive_inbound_frames_with_empty_payload,omitempty"`
	// Limit the number of inbound PRIORITY frames allowed per each opened stream. If the number
	// of PRIORITY frames received over the lifetime of connection exceeds the value calculated
	// using this formula::
	//
	//     max_inbound_priority_frames_per_stream * (1 + inbound_streams)
	//
	// the connection is terminated. The ``http2.inbound_priority_frames_flood`` stat tracks
	// the number of connections terminated due to flood mitigation. The default limit is 100.
	// [#comment:TODO: implement same limits for upstream inbound frames as well.]
	MaxInboundPriorityFramesPerStream *wrappers.UInt32Value `protobuf:"bytes,10,opt,name=max_inbound_priority_frames_per_stream,json=maxInboundPriorityFramesPerStream,proto3" json:"max_inbound_priority_frames_per_stream,omitempty"`
	// Limit the number of inbound WINDOW_UPDATE frames allowed per DATA frame sent. If the number
	// of WINDOW_UPDATE frames received over the lifetime of connection exceeds the value calculated
	// using this formula::
	//
	//     1 + 2 * (inbound_streams +
	//              max_inbound_window_update_frames_per_data_frame_sent * outbound_data_frames)
	//
	// the connection is terminated. The ``http2.inbound_priority_frames_flood`` stat tracks
	// the number of connections terminated due to flood mitigation. The default limit is 10.
	// Setting this to 1 should be enough to support HTTP/2 implementations with basic flow control,
	// but more complex implementations that try to estimate available bandwidth require at least 2.
	// [#comment:TODO: implement same limits for upstream inbound frames as well.]
	MaxInboundWindowUpdateFramesPerDataFrameSent *wrappers.UInt32Value `protobuf:"bytes,11,opt,name=max_inbound_window_update_frames_per_data_frame_sent,json=maxInboundWindowUpdateFramesPerDataFrameSent,proto3" json:"max_inbound_window_update_frames_per_data_frame_sent,omitempty"`
	// Allows invalid HTTP messaging and headers. When this option is disabled (default), then
	// the whole HTTP/2 connection is terminated upon receiving invalid HEADERS frame. However,
	// when this option is enabled, only the offending stream is terminated.
	//
	// See `RFC7540, sec. 8.1 <https://tools.ietf.org/html/rfc7540#section-8.1>`_ for details.
	StreamErrorOnInvalidHttpMessaging bool `protobuf:"varint,12,opt,name=stream_error_on_invalid_http_messaging,json=streamErrorOnInvalidHttpMessaging,proto3" json:"stream_error_on_invalid_http_messaging,omitempty"`
	// [#not-implemented-hide:]
	// Specifies SETTINGS frame parameters to be sent to the peer, with two exceptions:
	//
	// 1. SETTINGS_ENABLE_PUSH (0x2) is not configurable as HTTP/2 server push is not supported by
	// Envoy.
	//
	// 2. SETTINGS_ENABLE_CONNECT_PROTOCOL (0x8) is only configurable through the named field
	// 'allow_connect'.
	//
	// Note that custom parameters specified through this field can not also be set in the
	// corresponding named parameters:
	//
	// .. code-block:: text
	//
	//   ID    Field Name
	//   ----------------
	//   0x1   hpack_table_size
	//   0x3   max_concurrent_streams
	//   0x4   initial_stream_window_size
	//
	// Collisions will trigger config validation failure on load/update. Likewise, inconsistencies
	// between custom parameters with the same identifier will trigger a failure.
	//
	// See `IANA HTTP/2 Settings
	// <https://www.iana.org/assignments/http2-parameters/http2-parameters.xhtml#settings>`_ for
	// standardized identifiers.
	CustomSettingsParameters []*Http2ProtocolOptions_SettingsParameter `protobuf:"bytes,13,rep,name=custom_settings_parameters,json=customSettingsParameters,proto3" json:"custom_settings_parameters,omitempty"`
}

func (x *Http2ProtocolOptions) Reset() {
	*x = Http2ProtocolOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Http2ProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http2ProtocolOptions) ProtoMessage() {}

func (x *Http2ProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http2ProtocolOptions.ProtoReflect.Descriptor instead.
func (*Http2ProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_api_v2_core_protocol_proto_rawDescGZIP(), []int{4}
}

func (x *Http2ProtocolOptions) GetHpackTableSize() *wrappers.UInt32Value {
	if x != nil {
		return x.HpackTableSize
	}
	return nil
}

func (x *Http2ProtocolOptions) GetMaxConcurrentStreams() *wrappers.UInt32Value {
	if x != nil {
		return x.MaxConcurrentStreams
	}
	return nil
}

func (x *Http2ProtocolOptions) GetInitialStreamWindowSize() *wrappers.UInt32Value {
	if x != nil {
		return x.InitialStreamWindowSize
	}
	return nil
}

func (x *Http2ProtocolOptions) GetInitialConnectionWindowSize() *wrappers.UInt32Value {
	if x != nil {
		return x.InitialConnectionWindowSize
	}
	return nil
}

func (x *Http2ProtocolOptions) GetAllowConnect() bool {
	if x != nil {
		return x.AllowConnect
	}
	return false
}

func (x *Http2ProtocolOptions) GetAllowMetadata() bool {
	if x != nil {
		return x.AllowMetadata
	}
	return false
}

func (x *Http2ProtocolOptions) GetMaxOutboundFrames() *wrappers.UInt32Value {
	if x != nil {
		return x.MaxOutboundFrames
	}
	return nil
}

func (x *Http2ProtocolOptions) GetMaxOutboundControlFrames() *wrappers.UInt32Value {
	if x != nil {
		return x.MaxOutboundControlFrames
	}
	return nil
}

func (x *Http2ProtocolOptions) GetMaxConsecutiveInboundFramesWithEmptyPayload() *wrappers.UInt32Value {
	if x != nil {
		return x.MaxConsecutiveInboundFramesWithEmptyPayload
	}
	return nil
}

func (x *Http2ProtocolOptions) GetMaxInboundPriorityFramesPerStream() *wrappers.UInt32Value {
	if x != nil {
		return x.MaxInboundPriorityFramesPerStream
	}
	return nil
}

func (x *Http2ProtocolOptions) GetMaxInboundWindowUpdateFramesPerDataFrameSent() *wrappers.UInt32Value {
	if x != nil {
		return x.MaxInboundWindowUpdateFramesPerDataFrameSent
	}
	return nil
}

func (x *Http2ProtocolOptions) GetStreamErrorOnInvalidHttpMessaging() bool {
	if x != nil {
		return x.StreamErrorOnInvalidHttpMessaging
	}
	return false
}

func (x *Http2ProtocolOptions) GetCustomSettingsParameters() []*Http2ProtocolOptions_SettingsParameter {
	if x != nil {
		return x.CustomSettingsParameters
	}
	return nil
}

// [#not-implemented-hide:]
type GrpcProtocolOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Http2ProtocolOptions *Http2ProtocolOptions `protobuf:"bytes,1,opt,name=http2_protocol_options,json=http2ProtocolOptions,proto3" json:"http2_protocol_options,omitempty"`
}

func (x *GrpcProtocolOptions) Reset() {
	*x = GrpcProtocolOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcProtocolOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcProtocolOptions) ProtoMessage() {}

func (x *GrpcProtocolOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcProtocolOptions.ProtoReflect.Descriptor instead.
func (*GrpcProtocolOptions) Descriptor() ([]byte, []int) {
	return file_envoy_api_v2_core_protocol_proto_rawDescGZIP(), []int{5}
}

func (x *GrpcProtocolOptions) GetHttp2ProtocolOptions() *Http2ProtocolOptions {
	if x != nil {
		return x.Http2ProtocolOptions
	}
	return nil
}

type Http1ProtocolOptions_HeaderKeyFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to HeaderFormat:
	//	*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords_
	HeaderFormat isHttp1ProtocolOptions_HeaderKeyFormat_HeaderFormat `protobuf_oneof:"header_format"`
}

func (x *Http1ProtocolOptions_HeaderKeyFormat) Reset() {
	*x = Http1ProtocolOptions_HeaderKeyFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Http1ProtocolOptions_HeaderKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http1ProtocolOptions_HeaderKeyFormat) ProtoMessage() {}

func (x *Http1ProtocolOptions_HeaderKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http1ProtocolOptions_HeaderKeyFormat.ProtoReflect.Descriptor instead.
func (*Http1ProtocolOptions_HeaderKeyFormat) Descriptor() ([]byte, []int) {
	return file_envoy_api_v2_core_protocol_proto_rawDescGZIP(), []int{3, 0}
}

func (m *Http1ProtocolOptions_HeaderKeyFormat) GetHeaderFormat() isHttp1ProtocolOptions_HeaderKeyFormat_HeaderFormat {
	if m != nil {
		return m.HeaderFormat
	}
	return nil
}

func (x *Http1ProtocolOptions_HeaderKeyFormat) GetProperCaseWords() *Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords {
	if x, ok := x.GetHeaderFormat().(*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords_); ok {
		return x.ProperCaseWords
	}
	return nil
}

type isHttp1ProtocolOptions_HeaderKeyFormat_HeaderFormat interface {
	isHttp1ProtocolOptions_HeaderKeyFormat_HeaderFormat()
}

type Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords_ struct {
	// Formats the header by proper casing words: the first character and any character following
	// a special character will be capitalized if it's an alpha character. For example,
	// "content-type" becomes "Content-Type", and "foo$b#$are" becomes "Foo$B#$Are".
	// Note that while this results in most headers following conventional casing, certain headers
	// are not covered. For example, the "TE" header will be formatted as "Te".
	ProperCaseWords *Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords `protobuf:"bytes,1,opt,name=proper_case_words,json=properCaseWords,proto3,oneof"`
}

func (*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords_) isHttp1ProtocolOptions_HeaderKeyFormat_HeaderFormat() {
}

type Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords) Reset() {
	*x = Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords) ProtoMessage() {}

func (x *Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords.ProtoReflect.Descriptor instead.
func (*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords) Descriptor() ([]byte, []int) {
	return file_envoy_api_v2_core_protocol_proto_rawDescGZIP(), []int{3, 0, 0}
}

// Defines a parameter to be sent in the SETTINGS frame.
// See `RFC7540, sec. 6.5.1 <https://tools.ietf.org/html/rfc7540#section-6.5.1>`_ for details.
type Http2ProtocolOptions_SettingsParameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The 16 bit parameter identifier.
	Identifier *wrappers.UInt32Value `protobuf:"bytes,1,opt,name=identifier,proto3" json:"identifier,omitempty"`
	// The 32 bit parameter value.
	Value *wrappers.UInt32Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Http2ProtocolOptions_SettingsParameter) Reset() {
	*x = Http2ProtocolOptions_SettingsParameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Http2ProtocolOptions_SettingsParameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http2ProtocolOptions_SettingsParameter) ProtoMessage() {}

func (x *Http2ProtocolOptions_SettingsParameter) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_api_v2_core_protocol_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http2ProtocolOptions_SettingsParameter.ProtoReflect.Descriptor instead.
func (*Http2ProtocolOptions_SettingsParameter) Descriptor() ([]byte, []int) {
	return file_envoy_api_v2_core_protocol_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Http2ProtocolOptions_SettingsParameter) GetIdentifier() *wrappers.UInt32Value {
	if x != nil {
		return x.Identifier
	}
	return nil
}

func (x *Http2ProtocolOptions_SettingsParameter) GetValue() *wrappers.UInt32Value {
	if x != nil {
		return x.Value
	}
	return nil
}

var File_envoy_api_v2_core_protocol_proto protoreflect.FileDescriptor

var file_envoy_api_v2_core_protocol_proto_rawDesc = []byte{
	0x0a, 0x20, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x32, 0x2f, 0x63,
	0x6f, 0x72, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x11, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x32,
	0x2e, 0x63, 0x6f, 0x72, 0x65, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x75, 0x64, 0x70, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x75, 0x64, 0x70, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x14, 0x0a,
	0x12, 0x54, 0x63, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0x68, 0x0a, 0x1b, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48,
	0x74, 0x74, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x6e, 0x69, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x61, 0x75, 0x74, 0x6f, 0x53, 0x6e, 0x69, 0x12, 0x2e, 0x0a,
	0x13, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x61, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f,
	0x53, 0x61, 0x6e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa1, 0x04,
	0x0a, 0x13, 0x48, 0x74, 0x74, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3c, 0x0a, 0x0c, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x69, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x12, 0x51, 0x0a, 0x17, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x15, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x28, 0x01, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x13, 0x6d, 0x61, 0x78,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8a, 0x01, 0x0a, 0x1f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x73, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f,
	0x72, 0x65, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x57, 0x69,
	0x74, 0x68, 0x55, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x1c, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x57, 0x69, 0x74, 0x68,
	0x55, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x4e, 0x0a, 0x1c, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x57, 0x69, 0x74, 0x68,
	0x55, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e,
	0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x01,
	0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x52, 0x4f, 0x50, 0x5f, 0x48, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10,
	0x02, 0x22, 0x80, 0x04, 0x0a, 0x14, 0x48, 0x74, 0x74, 0x70, 0x31, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x48, 0x0a, 0x12, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x75, 0x72, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x65, 0x55, 0x72, 0x6c, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x5f, 0x68,
	0x74, 0x74, 0x70, 0x5f, 0x31, 0x30, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x63,
	0x63, 0x65, 0x70, 0x74, 0x48, 0x74, 0x74, 0x70, 0x31, 0x30, 0x12, 0x36, 0x0a, 0x18, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x68,
	0x74, 0x74, 0x70, 0x5f, 0x31, 0x30, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x48, 0x6f, 0x73, 0x74, 0x46, 0x6f, 0x72, 0x48, 0x74, 0x74, 0x70,
	0x31, 0x30, 0x12, 0x63, 0x0a, 0x11, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x72,
	0x65, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x31, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4b, 0x65, 0x79,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4b, 0x65,
	0x79, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x74, 0x72, 0x61, 0x69, 0x6c, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x69, 0x6c, 0x65, 0x72, 0x73,
	0x1a, 0xb1, 0x01, 0x0a, 0x0f, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x12, 0x75, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x5f, 0x63,
	0x61, 0x73, 0x65, 0x5f, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x47, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x76, 0x32, 0x2e, 0x63,
	0x6f, 0x72, 0x65, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x31, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4b,
	0x65, 0x79, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x43,
	0x61, 0x73, 0x65, 0x57, 0x6f, 0x72, 0x64, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x43, 0x61, 0x73, 0x65, 0x57, 0x6f, 0x72, 0x64, 0x73, 0x1a, 0x11, 0x0a, 0x0f, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x43, 0x61, 0x73, 0x65, 0x57, 0x6f, 0x72, 0x64, 0x73, 0x42, 0x14,
	0x0a, 0x0d, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12,
	0x03, 0xf8, 0x42, 0x01, 0x22, 0xa9, 0x0b, 0x0a, 0x14, 0x48, 0x74, 0x74, 0x70, 0x32, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x46, 0x0a,
	0x10, 0x68, 0x70, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x68, 0x70, 0x61, 0x63, 0x6b, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x61, 0x0a, 0x16, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x0d, 0xfa, 0x42, 0x0a, 0x2a, 0x08, 0x18, 0xff, 0xff, 0xff, 0xff, 0x07,
	0x28, 0x01, 0x52, 0x14, 0x6d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x6a, 0x0a, 0x1a, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55,
	0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0f, 0xfa, 0x42, 0x0c, 0x2a,
	0x0a, 0x18, 0xff, 0xff, 0xff, 0xff, 0x07, 0x28, 0xff, 0xff, 0x03, 0x52, 0x17, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x61, 0x6c, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x72, 0x0a, 0x1e, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55,
	0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0f, 0xfa, 0x42, 0x0c, 0x2a,
	0x0a, 0x18, 0xff, 0xff, 0xff, 0xff, 0x07, 0x28, 0xff, 0xff, 0x03, 0x52, 0x1b, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0x25, 0x0a,
	0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x55, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x75, 0x74, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x28, 0x01, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x4f, 0x75, 0x74,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x1b, 0x6d,
	0x61, 0x78, 0x5f, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07,
	0xfa, 0x42, 0x04, 0x2a, 0x02, 0x28, 0x01, 0x52, 0x18, 0x6d, 0x61, 0x78, 0x4f, 0x75, 0x74, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x46, 0x72, 0x61, 0x6d, 0x65,
	0x73, 0x12, 0x84, 0x01, 0x0a, 0x31, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x66, 0x72,
	0x61, 0x6d, 0x65, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x5f,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x2b, 0x6d, 0x61, 0x78,
	0x43, 0x6f, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x74, 0x69, 0x76, 0x65, 0x49, 0x6e, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x57, 0x69, 0x74, 0x68, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x6f, 0x0a, 0x26, 0x6d, 0x61, 0x78, 0x5f,
	0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33,
	0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x21, 0x6d, 0x61, 0x78, 0x49, 0x6e, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73,
	0x50, 0x65, 0x72, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x91, 0x01, 0x0a, 0x34, 0x6d, 0x61,
	0x78, 0x5f, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65,
	0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33,
	0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x2a, 0x02, 0x28, 0x01, 0x52,
	0x2c, 0x6d, 0x61, 0x78, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x50, 0x65, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x0a,
	0x26, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x21, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x4f, 0x6e, 0x49, 0x6e, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x48, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x69, 0x6e, 0x67,
	0x12, 0x77, 0x0a, 0x1a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0d,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x32, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52,
	0x18, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0xa4, 0x01, 0x0a, 0x11, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12,
	0x51, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x13, 0xfa, 0x42, 0x08, 0x2a, 0x06, 0x18, 0x80, 0x80, 0x04, 0x28, 0x01, 0xfa, 0x42,
	0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x12, 0x3c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0x74, 0x0a, 0x13, 0x47, 0x72, 0x70, 0x63, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5d, 0x0a, 0x16, 0x68, 0x74, 0x74, 0x70, 0x32,
	0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x48, 0x74, 0x74, 0x70,
	0x32, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x14, 0x68, 0x74, 0x74, 0x70, 0x32, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x56, 0x0a, 0x1f, 0x69, 0x6f, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0xf2, 0x98, 0xfe, 0x8f, 0x05, 0x16,
	0x12, 0x14, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0xba, 0x80, 0xc8, 0xd1, 0x06, 0x02, 0x10, 0x01, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_envoy_api_v2_core_protocol_proto_rawDescOnce sync.Once
	file_envoy_api_v2_core_protocol_proto_rawDescData = file_envoy_api_v2_core_protocol_proto_rawDesc
)

func file_envoy_api_v2_core_protocol_proto_rawDescGZIP() []byte {
	file_envoy_api_v2_core_protocol_proto_rawDescOnce.Do(func() {
		file_envoy_api_v2_core_protocol_proto_rawDescData = protoimpl.X.CompressGZIP(file_envoy_api_v2_core_protocol_proto_rawDescData)
	})
	return file_envoy_api_v2_core_protocol_proto_rawDescData
}

var file_envoy_api_v2_core_protocol_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_envoy_api_v2_core_protocol_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_envoy_api_v2_core_protocol_proto_goTypes = []interface{}{
	(HttpProtocolOptions_HeadersWithUnderscoresAction)(0),        // 0: envoy.api.v2.core.HttpProtocolOptions.HeadersWithUnderscoresAction
	(*TcpProtocolOptions)(nil),                                   // 1: envoy.api.v2.core.TcpProtocolOptions
	(*UpstreamHttpProtocolOptions)(nil),                          // 2: envoy.api.v2.core.UpstreamHttpProtocolOptions
	(*HttpProtocolOptions)(nil),                                  // 3: envoy.api.v2.core.HttpProtocolOptions
	(*Http1ProtocolOptions)(nil),                                 // 4: envoy.api.v2.core.Http1ProtocolOptions
	(*Http2ProtocolOptions)(nil),                                 // 5: envoy.api.v2.core.Http2ProtocolOptions
	(*GrpcProtocolOptions)(nil),                                  // 6: envoy.api.v2.core.GrpcProtocolOptions
	(*Http1ProtocolOptions_HeaderKeyFormat)(nil),                 // 7: envoy.api.v2.core.Http1ProtocolOptions.HeaderKeyFormat
	(*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords)(nil), // 8: envoy.api.v2.core.Http1ProtocolOptions.HeaderKeyFormat.ProperCaseWords
	(*Http2ProtocolOptions_SettingsParameter)(nil),               // 9: envoy.api.v2.core.Http2ProtocolOptions.SettingsParameter
	(*duration.Duration)(nil),                                    // 10: google.protobuf.Duration
	(*wrappers.UInt32Value)(nil),                                 // 11: google.protobuf.UInt32Value
	(*wrappers.BoolValue)(nil),                                   // 12: google.protobuf.BoolValue
}
var file_envoy_api_v2_core_protocol_proto_depIdxs = []int32{
	10, // 0: envoy.api.v2.core.HttpProtocolOptions.idle_timeout:type_name -> google.protobuf.Duration
	10, // 1: envoy.api.v2.core.HttpProtocolOptions.max_connection_duration:type_name -> google.protobuf.Duration
	11, // 2: envoy.api.v2.core.HttpProtocolOptions.max_headers_count:type_name -> google.protobuf.UInt32Value
	10, // 3: envoy.api.v2.core.HttpProtocolOptions.max_stream_duration:type_name -> google.protobuf.Duration
	0,  // 4: envoy.api.v2.core.HttpProtocolOptions.headers_with_underscores_action:type_name -> envoy.api.v2.core.HttpProtocolOptions.HeadersWithUnderscoresAction
	12, // 5: envoy.api.v2.core.Http1ProtocolOptions.allow_absolute_url:type_name -> google.protobuf.BoolValue
	7,  // 6: envoy.api.v2.core.Http1ProtocolOptions.header_key_format:type_name -> envoy.api.v2.core.Http1ProtocolOptions.HeaderKeyFormat
	11, // 7: envoy.api.v2.core.Http2ProtocolOptions.hpack_table_size:type_name -> google.protobuf.UInt32Value
	11, // 8: envoy.api.v2.core.Http2ProtocolOptions.max_concurrent_streams:type_name -> google.protobuf.UInt32Value
	11, // 9: envoy.api.v2.core.Http2ProtocolOptions.initial_stream_window_size:type_name -> google.protobuf.UInt32Value
	11, // 10: envoy.api.v2.core.Http2ProtocolOptions.initial_connection_window_size:type_name -> google.protobuf.UInt32Value
	11, // 11: envoy.api.v2.core.Http2ProtocolOptions.max_outbound_frames:type_name -> google.protobuf.UInt32Value
	11, // 12: envoy.api.v2.core.Http2ProtocolOptions.max_outbound_control_frames:type_name -> google.protobuf.UInt32Value
	11, // 13: envoy.api.v2.core.Http2ProtocolOptions.max_consecutive_inbound_frames_with_empty_payload:type_name -> google.protobuf.UInt32Value
	11, // 14: envoy.api.v2.core.Http2ProtocolOptions.max_inbound_priority_frames_per_stream:type_name -> google.protobuf.UInt32Value
	11, // 15: envoy.api.v2.core.Http2ProtocolOptions.max_inbound_window_update_frames_per_data_frame_sent:type_name -> google.protobuf.UInt32Value
	9,  // 16: envoy.api.v2.core.Http2ProtocolOptions.custom_settings_parameters:type_name -> envoy.api.v2.core.Http2ProtocolOptions.SettingsParameter
	5,  // 17: envoy.api.v2.core.GrpcProtocolOptions.http2_protocol_options:type_name -> envoy.api.v2.core.Http2ProtocolOptions
	8,  // 18: envoy.api.v2.core.Http1ProtocolOptions.HeaderKeyFormat.proper_case_words:type_name -> envoy.api.v2.core.Http1ProtocolOptions.HeaderKeyFormat.ProperCaseWords
	11, // 19: envoy.api.v2.core.Http2ProtocolOptions.SettingsParameter.identifier:type_name -> google.protobuf.UInt32Value
	11, // 20: envoy.api.v2.core.Http2ProtocolOptions.SettingsParameter.value:type_name -> google.protobuf.UInt32Value
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_envoy_api_v2_core_protocol_proto_init() }
func file_envoy_api_v2_core_protocol_proto_init() {
	if File_envoy_api_v2_core_protocol_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_envoy_api_v2_core_protocol_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TcpProtocolOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_api_v2_core_protocol_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpstreamHttpProtocolOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_api_v2_core_protocol_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpProtocolOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_api_v2_core_protocol_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Http1ProtocolOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_api_v2_core_protocol_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Http2ProtocolOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_api_v2_core_protocol_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcProtocolOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_api_v2_core_protocol_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Http1ProtocolOptions_HeaderKeyFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_api_v2_core_protocol_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_api_v2_core_protocol_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Http2ProtocolOptions_SettingsParameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_envoy_api_v2_core_protocol_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*Http1ProtocolOptions_HeaderKeyFormat_ProperCaseWords_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_envoy_api_v2_core_protocol_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_api_v2_core_protocol_proto_goTypes,
		DependencyIndexes: file_envoy_api_v2_core_protocol_proto_depIdxs,
		EnumInfos:         file_envoy_api_v2_core_protocol_proto_enumTypes,
		MessageInfos:      file_envoy_api_v2_core_protocol_proto_msgTypes,
	}.Build()
	File_envoy_api_v2_core_protocol_proto = out.File
	file_envoy_api_v2_core_protocol_proto_rawDesc = nil
	file_envoy_api_v2_core_protocol_proto_goTypes = nil
	file_envoy_api_v2_core_protocol_proto_depIdxs = nil
}
