// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package settings_test

import (
	"context"

	settings "cloud.google.com/go/securitycenter/settings/apiv1beta1"
	"google.golang.org/api/iterator"
	settingspb "google.golang.org/genproto/googleapis/cloud/securitycenter/settings/v1beta1"
)

func ExampleNewSecurityCenterSettingsClient() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	// TODO: Use client.
	_ = c
}

func ExampleSecurityCenterSettingsClient_GetServiceAccount() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.GetServiceAccountRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.GetServiceAccount(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleSecurityCenterSettingsClient_GetSettings() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.GetSettingsRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.GetSettings(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleSecurityCenterSettingsClient_UpdateSettings() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.UpdateSettingsRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.UpdateSettings(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleSecurityCenterSettingsClient_ResetSettings() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.ResetSettingsRequest{
		// TODO: Fill request struct fields.
	}
	err = c.ResetSettings(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
}

func ExampleSecurityCenterSettingsClient_BatchGetSettings() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.BatchGetSettingsRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.BatchGetSettings(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleSecurityCenterSettingsClient_CalculateEffectiveSettings() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.CalculateEffectiveSettingsRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.CalculateEffectiveSettings(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleSecurityCenterSettingsClient_BatchCalculateEffectiveSettings() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.BatchCalculateEffectiveSettingsRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.BatchCalculateEffectiveSettings(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleSecurityCenterSettingsClient_GetComponentSettings() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.GetComponentSettingsRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.GetComponentSettings(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleSecurityCenterSettingsClient_UpdateComponentSettings() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.UpdateComponentSettingsRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.UpdateComponentSettings(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleSecurityCenterSettingsClient_ResetComponentSettings() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.ResetComponentSettingsRequest{
		// TODO: Fill request struct fields.
	}
	err = c.ResetComponentSettings(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
}

func ExampleSecurityCenterSettingsClient_CalculateEffectiveComponentSettings() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.CalculateEffectiveComponentSettingsRequest{
		// TODO: Fill request struct fields.
	}
	resp, err := c.CalculateEffectiveComponentSettings(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleSecurityCenterSettingsClient_ListDetectors() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.ListDetectorsRequest{
		// TODO: Fill request struct fields.
	}
	it := c.ListDetectors(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleSecurityCenterSettingsClient_ListComponents() {
	ctx := context.Background()
	c, err := settings.NewSecurityCenterSettingsClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &settingspb.ListComponentsRequest{
		// TODO: Fill request struct fields.
	}
	it := c.ListComponents(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}
