// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/bigtable/admin/v2/bigtable_table_admin.proto

package admin

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.CreateTable][google.bigtable.admin.v2.BigtableTableAdmin.CreateTable]
type CreateTableRequest struct {
	// Required. The unique name of the instance in which to create the table.
	// Values are of the form `projects/{project}/instances/{instance}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name by which the new table should be referred to within the parent
	// instance, e.g., `foobar` rather than `{parent}/tables/foobar`.
	// Maximum 50 characters.
	TableId string `protobuf:"bytes,2,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// Required. The Table to create.
	Table *Table `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	// The optional list of row keys that will be used to initially split the
	// table into several tablets (tablets are similar to HBase regions).
	// Given two split keys, `s1` and `s2`, three tablets will be created,
	// spanning the key ranges: `[, s1), [s1, s2), [s2, )`.
	//
	// Example:
	//
	// * Row keys := `["a", "apple", "custom", "customer_1", "customer_2",`
	//                `"other", "zz"]`
	// * initial_split_keys := `["apple", "customer_1", "customer_2", "other"]`
	// * Key assignment:
	//     - Tablet 1 `[, apple)                => {"a"}.`
	//     - Tablet 2 `[apple, customer_1)      => {"apple", "custom"}.`
	//     - Tablet 3 `[customer_1, customer_2) => {"customer_1"}.`
	//     - Tablet 4 `[customer_2, other)      => {"customer_2"}.`
	//     - Tablet 5 `[other, )                => {"other", "zz"}.`
	InitialSplits        []*CreateTableRequest_Split `protobuf:"bytes,4,rep,name=initial_splits,json=initialSplits,proto3" json:"initial_splits,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *CreateTableRequest) Reset()         { *m = CreateTableRequest{} }
func (m *CreateTableRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTableRequest) ProtoMessage()    {}
func (*CreateTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{0}
}

func (m *CreateTableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTableRequest.Unmarshal(m, b)
}
func (m *CreateTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTableRequest.Marshal(b, m, deterministic)
}
func (m *CreateTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTableRequest.Merge(m, src)
}
func (m *CreateTableRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTableRequest.Size(m)
}
func (m *CreateTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTableRequest proto.InternalMessageInfo

func (m *CreateTableRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTableRequest) GetTableId() string {
	if m != nil {
		return m.TableId
	}
	return ""
}

func (m *CreateTableRequest) GetTable() *Table {
	if m != nil {
		return m.Table
	}
	return nil
}

func (m *CreateTableRequest) GetInitialSplits() []*CreateTableRequest_Split {
	if m != nil {
		return m.InitialSplits
	}
	return nil
}

// An initial split point for a newly created table.
type CreateTableRequest_Split struct {
	// Row key to use as an initial tablet boundary.
	Key                  []byte   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTableRequest_Split) Reset()         { *m = CreateTableRequest_Split{} }
func (m *CreateTableRequest_Split) String() string { return proto.CompactTextString(m) }
func (*CreateTableRequest_Split) ProtoMessage()    {}
func (*CreateTableRequest_Split) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{0, 0}
}

func (m *CreateTableRequest_Split) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTableRequest_Split.Unmarshal(m, b)
}
func (m *CreateTableRequest_Split) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTableRequest_Split.Marshal(b, m, deterministic)
}
func (m *CreateTableRequest_Split) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTableRequest_Split.Merge(m, src)
}
func (m *CreateTableRequest_Split) XXX_Size() int {
	return xxx_messageInfo_CreateTableRequest_Split.Size(m)
}
func (m *CreateTableRequest_Split) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTableRequest_Split.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTableRequest_Split proto.InternalMessageInfo

func (m *CreateTableRequest_Split) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.CreateTableFromSnapshot][google.bigtable.admin.v2.BigtableTableAdmin.CreateTableFromSnapshot]
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type CreateTableFromSnapshotRequest struct {
	// Required. The unique name of the instance in which to create the table.
	// Values are of the form `projects/{project}/instances/{instance}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name by which the new table should be referred to within the parent
	// instance, e.g., `foobar` rather than `{parent}/tables/foobar`.
	TableId string `protobuf:"bytes,2,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// Required. The unique name of the snapshot from which to restore the table. The
	// snapshot and the table must be in the same instance.
	// Values are of the form
	// `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
	SourceSnapshot       string   `protobuf:"bytes,3,opt,name=source_snapshot,json=sourceSnapshot,proto3" json:"source_snapshot,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTableFromSnapshotRequest) Reset()         { *m = CreateTableFromSnapshotRequest{} }
func (m *CreateTableFromSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTableFromSnapshotRequest) ProtoMessage()    {}
func (*CreateTableFromSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{1}
}

func (m *CreateTableFromSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTableFromSnapshotRequest.Unmarshal(m, b)
}
func (m *CreateTableFromSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTableFromSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *CreateTableFromSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTableFromSnapshotRequest.Merge(m, src)
}
func (m *CreateTableFromSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTableFromSnapshotRequest.Size(m)
}
func (m *CreateTableFromSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTableFromSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTableFromSnapshotRequest proto.InternalMessageInfo

func (m *CreateTableFromSnapshotRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTableFromSnapshotRequest) GetTableId() string {
	if m != nil {
		return m.TableId
	}
	return ""
}

func (m *CreateTableFromSnapshotRequest) GetSourceSnapshot() string {
	if m != nil {
		return m.SourceSnapshot
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.DropRowRange][google.bigtable.admin.v2.BigtableTableAdmin.DropRowRange]
type DropRowRangeRequest struct {
	// Required. The unique name of the table on which to drop a range of rows.
	// Values are of the form
	// `projects/{project}/instances/{instance}/tables/{table}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Delete all rows or by prefix.
	//
	// Types that are valid to be assigned to Target:
	//	*DropRowRangeRequest_RowKeyPrefix
	//	*DropRowRangeRequest_DeleteAllDataFromTable
	Target               isDropRowRangeRequest_Target `protobuf_oneof:"target"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *DropRowRangeRequest) Reset()         { *m = DropRowRangeRequest{} }
func (m *DropRowRangeRequest) String() string { return proto.CompactTextString(m) }
func (*DropRowRangeRequest) ProtoMessage()    {}
func (*DropRowRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{2}
}

func (m *DropRowRangeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DropRowRangeRequest.Unmarshal(m, b)
}
func (m *DropRowRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DropRowRangeRequest.Marshal(b, m, deterministic)
}
func (m *DropRowRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DropRowRangeRequest.Merge(m, src)
}
func (m *DropRowRangeRequest) XXX_Size() int {
	return xxx_messageInfo_DropRowRangeRequest.Size(m)
}
func (m *DropRowRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DropRowRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DropRowRangeRequest proto.InternalMessageInfo

func (m *DropRowRangeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isDropRowRangeRequest_Target interface {
	isDropRowRangeRequest_Target()
}

type DropRowRangeRequest_RowKeyPrefix struct {
	RowKeyPrefix []byte `protobuf:"bytes,2,opt,name=row_key_prefix,json=rowKeyPrefix,proto3,oneof"`
}

type DropRowRangeRequest_DeleteAllDataFromTable struct {
	DeleteAllDataFromTable bool `protobuf:"varint,3,opt,name=delete_all_data_from_table,json=deleteAllDataFromTable,proto3,oneof"`
}

func (*DropRowRangeRequest_RowKeyPrefix) isDropRowRangeRequest_Target() {}

func (*DropRowRangeRequest_DeleteAllDataFromTable) isDropRowRangeRequest_Target() {}

func (m *DropRowRangeRequest) GetTarget() isDropRowRangeRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *DropRowRangeRequest) GetRowKeyPrefix() []byte {
	if x, ok := m.GetTarget().(*DropRowRangeRequest_RowKeyPrefix); ok {
		return x.RowKeyPrefix
	}
	return nil
}

func (m *DropRowRangeRequest) GetDeleteAllDataFromTable() bool {
	if x, ok := m.GetTarget().(*DropRowRangeRequest_DeleteAllDataFromTable); ok {
		return x.DeleteAllDataFromTable
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*DropRowRangeRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*DropRowRangeRequest_RowKeyPrefix)(nil),
		(*DropRowRangeRequest_DeleteAllDataFromTable)(nil),
	}
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListTables][google.bigtable.admin.v2.BigtableTableAdmin.ListTables]
type ListTablesRequest struct {
	// Required. The unique name of the instance for which tables should be listed.
	// Values are of the form `projects/{project}/instances/{instance}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The view to be applied to the returned tables' fields.
	// Only NAME_ONLY view (default) and REPLICATION_VIEW are supported.
	View Table_View `protobuf:"varint,2,opt,name=view,proto3,enum=google.bigtable.admin.v2.Table_View" json:"view,omitempty"`
	// Maximum number of results per page.
	//
	// A page_size of zero lets the server choose the number of items to return.
	// A page_size which is strictly positive will return at most that many items.
	// A negative page_size will cause an error.
	//
	// Following the first request, subsequent paginated calls are not required
	// to pass a page_size. If a page_size is set in subsequent calls, it must
	// match the page_size given in the first request.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value of `next_page_token` returned by a previous call.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTablesRequest) Reset()         { *m = ListTablesRequest{} }
func (m *ListTablesRequest) String() string { return proto.CompactTextString(m) }
func (*ListTablesRequest) ProtoMessage()    {}
func (*ListTablesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{3}
}

func (m *ListTablesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTablesRequest.Unmarshal(m, b)
}
func (m *ListTablesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTablesRequest.Marshal(b, m, deterministic)
}
func (m *ListTablesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTablesRequest.Merge(m, src)
}
func (m *ListTablesRequest) XXX_Size() int {
	return xxx_messageInfo_ListTablesRequest.Size(m)
}
func (m *ListTablesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTablesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTablesRequest proto.InternalMessageInfo

func (m *ListTablesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTablesRequest) GetView() Table_View {
	if m != nil {
		return m.View
	}
	return Table_VIEW_UNSPECIFIED
}

func (m *ListTablesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTablesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListTables][google.bigtable.admin.v2.BigtableTableAdmin.ListTables]
type ListTablesResponse struct {
	// The tables present in the requested instance.
	Tables []*Table `protobuf:"bytes,1,rep,name=tables,proto3" json:"tables,omitempty"`
	// Set if not all tables could be returned in a single response.
	// Pass this value to `page_token` in another request to get the next
	// page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTablesResponse) Reset()         { *m = ListTablesResponse{} }
func (m *ListTablesResponse) String() string { return proto.CompactTextString(m) }
func (*ListTablesResponse) ProtoMessage()    {}
func (*ListTablesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{4}
}

func (m *ListTablesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTablesResponse.Unmarshal(m, b)
}
func (m *ListTablesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTablesResponse.Marshal(b, m, deterministic)
}
func (m *ListTablesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTablesResponse.Merge(m, src)
}
func (m *ListTablesResponse) XXX_Size() int {
	return xxx_messageInfo_ListTablesResponse.Size(m)
}
func (m *ListTablesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTablesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTablesResponse proto.InternalMessageInfo

func (m *ListTablesResponse) GetTables() []*Table {
	if m != nil {
		return m.Tables
	}
	return nil
}

func (m *ListTablesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GetTable][google.bigtable.admin.v2.BigtableTableAdmin.GetTable]
type GetTableRequest struct {
	// Required. The unique name of the requested table.
	// Values are of the form
	// `projects/{project}/instances/{instance}/tables/{table}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The view to be applied to the returned table's fields.
	// Defaults to `SCHEMA_VIEW` if unspecified.
	View                 Table_View `protobuf:"varint,2,opt,name=view,proto3,enum=google.bigtable.admin.v2.Table_View" json:"view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *GetTableRequest) Reset()         { *m = GetTableRequest{} }
func (m *GetTableRequest) String() string { return proto.CompactTextString(m) }
func (*GetTableRequest) ProtoMessage()    {}
func (*GetTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{5}
}

func (m *GetTableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTableRequest.Unmarshal(m, b)
}
func (m *GetTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTableRequest.Marshal(b, m, deterministic)
}
func (m *GetTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTableRequest.Merge(m, src)
}
func (m *GetTableRequest) XXX_Size() int {
	return xxx_messageInfo_GetTableRequest.Size(m)
}
func (m *GetTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTableRequest proto.InternalMessageInfo

func (m *GetTableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetTableRequest) GetView() Table_View {
	if m != nil {
		return m.View
	}
	return Table_VIEW_UNSPECIFIED
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.DeleteTable][google.bigtable.admin.v2.BigtableTableAdmin.DeleteTable]
type DeleteTableRequest struct {
	// Required. The unique name of the table to be deleted.
	// Values are of the form
	// `projects/{project}/instances/{instance}/tables/{table}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTableRequest) Reset()         { *m = DeleteTableRequest{} }
func (m *DeleteTableRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTableRequest) ProtoMessage()    {}
func (*DeleteTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{6}
}

func (m *DeleteTableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTableRequest.Unmarshal(m, b)
}
func (m *DeleteTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTableRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTableRequest.Merge(m, src)
}
func (m *DeleteTableRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTableRequest.Size(m)
}
func (m *DeleteTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTableRequest proto.InternalMessageInfo

func (m *DeleteTableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies][google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies]
type ModifyColumnFamiliesRequest struct {
	// Required. The unique name of the table whose families should be modified.
	// Values are of the form
	// `projects/{project}/instances/{instance}/tables/{table}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Modifications to be atomically applied to the specified table's families.
	// Entries are applied in order, meaning that earlier modifications can be
	// masked by later ones (in the case of repeated updates to the same family,
	// for example).
	Modifications        []*ModifyColumnFamiliesRequest_Modification `protobuf:"bytes,2,rep,name=modifications,proto3" json:"modifications,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *ModifyColumnFamiliesRequest) Reset()         { *m = ModifyColumnFamiliesRequest{} }
func (m *ModifyColumnFamiliesRequest) String() string { return proto.CompactTextString(m) }
func (*ModifyColumnFamiliesRequest) ProtoMessage()    {}
func (*ModifyColumnFamiliesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{7}
}

func (m *ModifyColumnFamiliesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModifyColumnFamiliesRequest.Unmarshal(m, b)
}
func (m *ModifyColumnFamiliesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModifyColumnFamiliesRequest.Marshal(b, m, deterministic)
}
func (m *ModifyColumnFamiliesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifyColumnFamiliesRequest.Merge(m, src)
}
func (m *ModifyColumnFamiliesRequest) XXX_Size() int {
	return xxx_messageInfo_ModifyColumnFamiliesRequest.Size(m)
}
func (m *ModifyColumnFamiliesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifyColumnFamiliesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ModifyColumnFamiliesRequest proto.InternalMessageInfo

func (m *ModifyColumnFamiliesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ModifyColumnFamiliesRequest) GetModifications() []*ModifyColumnFamiliesRequest_Modification {
	if m != nil {
		return m.Modifications
	}
	return nil
}

// A create, update, or delete of a particular column family.
type ModifyColumnFamiliesRequest_Modification struct {
	// The ID of the column family to be modified.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Column familiy modifications.
	//
	// Types that are valid to be assigned to Mod:
	//	*ModifyColumnFamiliesRequest_Modification_Create
	//	*ModifyColumnFamiliesRequest_Modification_Update
	//	*ModifyColumnFamiliesRequest_Modification_Drop
	Mod                  isModifyColumnFamiliesRequest_Modification_Mod `protobuf_oneof:"mod"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *ModifyColumnFamiliesRequest_Modification) Reset() {
	*m = ModifyColumnFamiliesRequest_Modification{}
}
func (m *ModifyColumnFamiliesRequest_Modification) String() string { return proto.CompactTextString(m) }
func (*ModifyColumnFamiliesRequest_Modification) ProtoMessage()    {}
func (*ModifyColumnFamiliesRequest_Modification) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{7, 0}
}

func (m *ModifyColumnFamiliesRequest_Modification) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModifyColumnFamiliesRequest_Modification.Unmarshal(m, b)
}
func (m *ModifyColumnFamiliesRequest_Modification) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModifyColumnFamiliesRequest_Modification.Marshal(b, m, deterministic)
}
func (m *ModifyColumnFamiliesRequest_Modification) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifyColumnFamiliesRequest_Modification.Merge(m, src)
}
func (m *ModifyColumnFamiliesRequest_Modification) XXX_Size() int {
	return xxx_messageInfo_ModifyColumnFamiliesRequest_Modification.Size(m)
}
func (m *ModifyColumnFamiliesRequest_Modification) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifyColumnFamiliesRequest_Modification.DiscardUnknown(m)
}

var xxx_messageInfo_ModifyColumnFamiliesRequest_Modification proto.InternalMessageInfo

func (m *ModifyColumnFamiliesRequest_Modification) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type isModifyColumnFamiliesRequest_Modification_Mod interface {
	isModifyColumnFamiliesRequest_Modification_Mod()
}

type ModifyColumnFamiliesRequest_Modification_Create struct {
	Create *ColumnFamily `protobuf:"bytes,2,opt,name=create,proto3,oneof"`
}

type ModifyColumnFamiliesRequest_Modification_Update struct {
	Update *ColumnFamily `protobuf:"bytes,3,opt,name=update,proto3,oneof"`
}

type ModifyColumnFamiliesRequest_Modification_Drop struct {
	Drop bool `protobuf:"varint,4,opt,name=drop,proto3,oneof"`
}

func (*ModifyColumnFamiliesRequest_Modification_Create) isModifyColumnFamiliesRequest_Modification_Mod() {
}

func (*ModifyColumnFamiliesRequest_Modification_Update) isModifyColumnFamiliesRequest_Modification_Mod() {
}

func (*ModifyColumnFamiliesRequest_Modification_Drop) isModifyColumnFamiliesRequest_Modification_Mod() {
}

func (m *ModifyColumnFamiliesRequest_Modification) GetMod() isModifyColumnFamiliesRequest_Modification_Mod {
	if m != nil {
		return m.Mod
	}
	return nil
}

func (m *ModifyColumnFamiliesRequest_Modification) GetCreate() *ColumnFamily {
	if x, ok := m.GetMod().(*ModifyColumnFamiliesRequest_Modification_Create); ok {
		return x.Create
	}
	return nil
}

func (m *ModifyColumnFamiliesRequest_Modification) GetUpdate() *ColumnFamily {
	if x, ok := m.GetMod().(*ModifyColumnFamiliesRequest_Modification_Update); ok {
		return x.Update
	}
	return nil
}

func (m *ModifyColumnFamiliesRequest_Modification) GetDrop() bool {
	if x, ok := m.GetMod().(*ModifyColumnFamiliesRequest_Modification_Drop); ok {
		return x.Drop
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ModifyColumnFamiliesRequest_Modification) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ModifyColumnFamiliesRequest_Modification_Create)(nil),
		(*ModifyColumnFamiliesRequest_Modification_Update)(nil),
		(*ModifyColumnFamiliesRequest_Modification_Drop)(nil),
	}
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken][google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken]
type GenerateConsistencyTokenRequest struct {
	// Required. The unique name of the Table for which to create a consistency token.
	// Values are of the form
	// `projects/{project}/instances/{instance}/tables/{table}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GenerateConsistencyTokenRequest) Reset()         { *m = GenerateConsistencyTokenRequest{} }
func (m *GenerateConsistencyTokenRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateConsistencyTokenRequest) ProtoMessage()    {}
func (*GenerateConsistencyTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{8}
}

func (m *GenerateConsistencyTokenRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateConsistencyTokenRequest.Unmarshal(m, b)
}
func (m *GenerateConsistencyTokenRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateConsistencyTokenRequest.Marshal(b, m, deterministic)
}
func (m *GenerateConsistencyTokenRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateConsistencyTokenRequest.Merge(m, src)
}
func (m *GenerateConsistencyTokenRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateConsistencyTokenRequest.Size(m)
}
func (m *GenerateConsistencyTokenRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateConsistencyTokenRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateConsistencyTokenRequest proto.InternalMessageInfo

func (m *GenerateConsistencyTokenRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken][google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken]
type GenerateConsistencyTokenResponse struct {
	// The generated consistency token.
	ConsistencyToken     string   `protobuf:"bytes,1,opt,name=consistency_token,json=consistencyToken,proto3" json:"consistency_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GenerateConsistencyTokenResponse) Reset()         { *m = GenerateConsistencyTokenResponse{} }
func (m *GenerateConsistencyTokenResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateConsistencyTokenResponse) ProtoMessage()    {}
func (*GenerateConsistencyTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{9}
}

func (m *GenerateConsistencyTokenResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateConsistencyTokenResponse.Unmarshal(m, b)
}
func (m *GenerateConsistencyTokenResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateConsistencyTokenResponse.Marshal(b, m, deterministic)
}
func (m *GenerateConsistencyTokenResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateConsistencyTokenResponse.Merge(m, src)
}
func (m *GenerateConsistencyTokenResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateConsistencyTokenResponse.Size(m)
}
func (m *GenerateConsistencyTokenResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateConsistencyTokenResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateConsistencyTokenResponse proto.InternalMessageInfo

func (m *GenerateConsistencyTokenResponse) GetConsistencyToken() string {
	if m != nil {
		return m.ConsistencyToken
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency][google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency]
type CheckConsistencyRequest struct {
	// Required. The unique name of the Table for which to check replication consistency.
	// Values are of the form
	// `projects/{project}/instances/{instance}/tables/{table}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The token created using GenerateConsistencyToken for the Table.
	ConsistencyToken     string   `protobuf:"bytes,2,opt,name=consistency_token,json=consistencyToken,proto3" json:"consistency_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckConsistencyRequest) Reset()         { *m = CheckConsistencyRequest{} }
func (m *CheckConsistencyRequest) String() string { return proto.CompactTextString(m) }
func (*CheckConsistencyRequest) ProtoMessage()    {}
func (*CheckConsistencyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{10}
}

func (m *CheckConsistencyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckConsistencyRequest.Unmarshal(m, b)
}
func (m *CheckConsistencyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckConsistencyRequest.Marshal(b, m, deterministic)
}
func (m *CheckConsistencyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckConsistencyRequest.Merge(m, src)
}
func (m *CheckConsistencyRequest) XXX_Size() int {
	return xxx_messageInfo_CheckConsistencyRequest.Size(m)
}
func (m *CheckConsistencyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckConsistencyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckConsistencyRequest proto.InternalMessageInfo

func (m *CheckConsistencyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CheckConsistencyRequest) GetConsistencyToken() string {
	if m != nil {
		return m.ConsistencyToken
	}
	return ""
}

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency][google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency]
type CheckConsistencyResponse struct {
	// True only if the token is consistent. A token is consistent if replication
	// has caught up with the restrictions specified in the request.
	Consistent           bool     `protobuf:"varint,1,opt,name=consistent,proto3" json:"consistent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckConsistencyResponse) Reset()         { *m = CheckConsistencyResponse{} }
func (m *CheckConsistencyResponse) String() string { return proto.CompactTextString(m) }
func (*CheckConsistencyResponse) ProtoMessage()    {}
func (*CheckConsistencyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{11}
}

func (m *CheckConsistencyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckConsistencyResponse.Unmarshal(m, b)
}
func (m *CheckConsistencyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckConsistencyResponse.Marshal(b, m, deterministic)
}
func (m *CheckConsistencyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckConsistencyResponse.Merge(m, src)
}
func (m *CheckConsistencyResponse) XXX_Size() int {
	return xxx_messageInfo_CheckConsistencyResponse.Size(m)
}
func (m *CheckConsistencyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckConsistencyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckConsistencyResponse proto.InternalMessageInfo

func (m *CheckConsistencyResponse) GetConsistent() bool {
	if m != nil {
		return m.Consistent
	}
	return false
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.SnapshotTable][google.bigtable.admin.v2.BigtableTableAdmin.SnapshotTable]
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type SnapshotTableRequest struct {
	// The unique name of the table to have the snapshot taken.
	// Values are of the form
	// `projects/{project}/instances/{instance}/tables/{table}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the cluster where the snapshot will be created in.
	// Values are of the form
	// `projects/{project}/instances/{instance}/clusters/{cluster}`.
	Cluster string `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// The ID by which the new snapshot should be referred to within the parent
	// cluster, e.g., `mysnapshot` of the form: `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`
	// rather than
	// `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/mysnapshot`.
	SnapshotId string `protobuf:"bytes,3,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// The amount of time that the new snapshot can stay active after it is
	// created. Once 'ttl' expires, the snapshot will get deleted. The maximum
	// amount of time a snapshot can stay active is 7 days. If 'ttl' is not
	// specified, the default value of 24 hours will be used.
	Ttl *duration.Duration `protobuf:"bytes,4,opt,name=ttl,proto3" json:"ttl,omitempty"`
	// Description of the snapshot.
	Description          string   `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SnapshotTableRequest) Reset()         { *m = SnapshotTableRequest{} }
func (m *SnapshotTableRequest) String() string { return proto.CompactTextString(m) }
func (*SnapshotTableRequest) ProtoMessage()    {}
func (*SnapshotTableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{12}
}

func (m *SnapshotTableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SnapshotTableRequest.Unmarshal(m, b)
}
func (m *SnapshotTableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SnapshotTableRequest.Marshal(b, m, deterministic)
}
func (m *SnapshotTableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapshotTableRequest.Merge(m, src)
}
func (m *SnapshotTableRequest) XXX_Size() int {
	return xxx_messageInfo_SnapshotTableRequest.Size(m)
}
func (m *SnapshotTableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapshotTableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SnapshotTableRequest proto.InternalMessageInfo

func (m *SnapshotTableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SnapshotTableRequest) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

func (m *SnapshotTableRequest) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

func (m *SnapshotTableRequest) GetTtl() *duration.Duration {
	if m != nil {
		return m.Ttl
	}
	return nil
}

func (m *SnapshotTableRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GetSnapshot][google.bigtable.admin.v2.BigtableTableAdmin.GetSnapshot]
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type GetSnapshotRequest struct {
	// Required. The unique name of the requested snapshot.
	// Values are of the form
	// `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSnapshotRequest) Reset()         { *m = GetSnapshotRequest{} }
func (m *GetSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*GetSnapshotRequest) ProtoMessage()    {}
func (*GetSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{13}
}

func (m *GetSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSnapshotRequest.Unmarshal(m, b)
}
func (m *GetSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *GetSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSnapshotRequest.Merge(m, src)
}
func (m *GetSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_GetSnapshotRequest.Size(m)
}
func (m *GetSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSnapshotRequest proto.InternalMessageInfo

func (m *GetSnapshotRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots][google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots]
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type ListSnapshotsRequest struct {
	// Required. The unique name of the cluster for which snapshots should be listed.
	// Values are of the form
	// `projects/{project}/instances/{instance}/clusters/{cluster}`.
	// Use `{cluster} = '-'` to list snapshots for all clusters in an instance,
	// e.g., `projects/{project}/instances/{instance}/clusters/-`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of snapshots to return per page.
	// CURRENTLY UNIMPLEMENTED AND IGNORED.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value of `next_page_token` returned by a previous call.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSnapshotsRequest) Reset()         { *m = ListSnapshotsRequest{} }
func (m *ListSnapshotsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsRequest) ProtoMessage()    {}
func (*ListSnapshotsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{14}
}

func (m *ListSnapshotsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotsRequest.Unmarshal(m, b)
}
func (m *ListSnapshotsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotsRequest.Marshal(b, m, deterministic)
}
func (m *ListSnapshotsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsRequest.Merge(m, src)
}
func (m *ListSnapshotsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotsRequest.Size(m)
}
func (m *ListSnapshotsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsRequest proto.InternalMessageInfo

func (m *ListSnapshotsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSnapshotsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSnapshotsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots][google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots]
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type ListSnapshotsResponse struct {
	// The snapshots present in the requested cluster.
	Snapshots []*Snapshot `protobuf:"bytes,1,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
	// Set if not all snapshots could be returned in a single response.
	// Pass this value to `page_token` in another request to get the next
	// page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSnapshotsResponse) Reset()         { *m = ListSnapshotsResponse{} }
func (m *ListSnapshotsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSnapshotsResponse) ProtoMessage()    {}
func (*ListSnapshotsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{15}
}

func (m *ListSnapshotsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSnapshotsResponse.Unmarshal(m, b)
}
func (m *ListSnapshotsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSnapshotsResponse.Marshal(b, m, deterministic)
}
func (m *ListSnapshotsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSnapshotsResponse.Merge(m, src)
}
func (m *ListSnapshotsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSnapshotsResponse.Size(m)
}
func (m *ListSnapshotsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSnapshotsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSnapshotsResponse proto.InternalMessageInfo

func (m *ListSnapshotsResponse) GetSnapshots() []*Snapshot {
	if m != nil {
		return m.Snapshots
	}
	return nil
}

func (m *ListSnapshotsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.DeleteSnapshot][google.bigtable.admin.v2.BigtableTableAdmin.DeleteSnapshot]
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type DeleteSnapshotRequest struct {
	// Required. The unique name of the snapshot to be deleted.
	// Values are of the form
	// `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSnapshotRequest) Reset()         { *m = DeleteSnapshotRequest{} }
func (m *DeleteSnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSnapshotRequest) ProtoMessage()    {}
func (*DeleteSnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{16}
}

func (m *DeleteSnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSnapshotRequest.Unmarshal(m, b)
}
func (m *DeleteSnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSnapshotRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSnapshotRequest.Merge(m, src)
}
func (m *DeleteSnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSnapshotRequest.Size(m)
}
func (m *DeleteSnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSnapshotRequest proto.InternalMessageInfo

func (m *DeleteSnapshotRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The metadata for the Operation returned by SnapshotTable.
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type SnapshotTableMetadata struct {
	// The request that prompted the initiation of this SnapshotTable operation.
	OriginalRequest *SnapshotTableRequest `protobuf:"bytes,1,opt,name=original_request,json=originalRequest,proto3" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SnapshotTableMetadata) Reset()         { *m = SnapshotTableMetadata{} }
func (m *SnapshotTableMetadata) String() string { return proto.CompactTextString(m) }
func (*SnapshotTableMetadata) ProtoMessage()    {}
func (*SnapshotTableMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{17}
}

func (m *SnapshotTableMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SnapshotTableMetadata.Unmarshal(m, b)
}
func (m *SnapshotTableMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SnapshotTableMetadata.Marshal(b, m, deterministic)
}
func (m *SnapshotTableMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapshotTableMetadata.Merge(m, src)
}
func (m *SnapshotTableMetadata) XXX_Size() int {
	return xxx_messageInfo_SnapshotTableMetadata.Size(m)
}
func (m *SnapshotTableMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapshotTableMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_SnapshotTableMetadata proto.InternalMessageInfo

func (m *SnapshotTableMetadata) GetOriginalRequest() *SnapshotTableRequest {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *SnapshotTableMetadata) GetRequestTime() *timestamp.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *SnapshotTableMetadata) GetFinishTime() *timestamp.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

// The metadata for the Operation returned by CreateTableFromSnapshot.
//
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not recommended
// for production use. It is not subject to any SLA or deprecation policy.
type CreateTableFromSnapshotMetadata struct {
	// The request that prompted the initiation of this CreateTableFromSnapshot
	// operation.
	OriginalRequest *CreateTableFromSnapshotRequest `protobuf:"bytes,1,opt,name=original_request,json=originalRequest,proto3" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CreateTableFromSnapshotMetadata) Reset()         { *m = CreateTableFromSnapshotMetadata{} }
func (m *CreateTableFromSnapshotMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateTableFromSnapshotMetadata) ProtoMessage()    {}
func (*CreateTableFromSnapshotMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_43baa00e5f96b1e4, []int{18}
}

func (m *CreateTableFromSnapshotMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTableFromSnapshotMetadata.Unmarshal(m, b)
}
func (m *CreateTableFromSnapshotMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTableFromSnapshotMetadata.Marshal(b, m, deterministic)
}
func (m *CreateTableFromSnapshotMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTableFromSnapshotMetadata.Merge(m, src)
}
func (m *CreateTableFromSnapshotMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateTableFromSnapshotMetadata.Size(m)
}
func (m *CreateTableFromSnapshotMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTableFromSnapshotMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTableFromSnapshotMetadata proto.InternalMessageInfo

func (m *CreateTableFromSnapshotMetadata) GetOriginalRequest() *CreateTableFromSnapshotRequest {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *CreateTableFromSnapshotMetadata) GetRequestTime() *timestamp.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *CreateTableFromSnapshotMetadata) GetFinishTime() *timestamp.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateTableRequest)(nil), "google.bigtable.admin.v2.CreateTableRequest")
	proto.RegisterType((*CreateTableRequest_Split)(nil), "google.bigtable.admin.v2.CreateTableRequest.Split")
	proto.RegisterType((*CreateTableFromSnapshotRequest)(nil), "google.bigtable.admin.v2.CreateTableFromSnapshotRequest")
	proto.RegisterType((*DropRowRangeRequest)(nil), "google.bigtable.admin.v2.DropRowRangeRequest")
	proto.RegisterType((*ListTablesRequest)(nil), "google.bigtable.admin.v2.ListTablesRequest")
	proto.RegisterType((*ListTablesResponse)(nil), "google.bigtable.admin.v2.ListTablesResponse")
	proto.RegisterType((*GetTableRequest)(nil), "google.bigtable.admin.v2.GetTableRequest")
	proto.RegisterType((*DeleteTableRequest)(nil), "google.bigtable.admin.v2.DeleteTableRequest")
	proto.RegisterType((*ModifyColumnFamiliesRequest)(nil), "google.bigtable.admin.v2.ModifyColumnFamiliesRequest")
	proto.RegisterType((*ModifyColumnFamiliesRequest_Modification)(nil), "google.bigtable.admin.v2.ModifyColumnFamiliesRequest.Modification")
	proto.RegisterType((*GenerateConsistencyTokenRequest)(nil), "google.bigtable.admin.v2.GenerateConsistencyTokenRequest")
	proto.RegisterType((*GenerateConsistencyTokenResponse)(nil), "google.bigtable.admin.v2.GenerateConsistencyTokenResponse")
	proto.RegisterType((*CheckConsistencyRequest)(nil), "google.bigtable.admin.v2.CheckConsistencyRequest")
	proto.RegisterType((*CheckConsistencyResponse)(nil), "google.bigtable.admin.v2.CheckConsistencyResponse")
	proto.RegisterType((*SnapshotTableRequest)(nil), "google.bigtable.admin.v2.SnapshotTableRequest")
	proto.RegisterType((*GetSnapshotRequest)(nil), "google.bigtable.admin.v2.GetSnapshotRequest")
	proto.RegisterType((*ListSnapshotsRequest)(nil), "google.bigtable.admin.v2.ListSnapshotsRequest")
	proto.RegisterType((*ListSnapshotsResponse)(nil), "google.bigtable.admin.v2.ListSnapshotsResponse")
	proto.RegisterType((*DeleteSnapshotRequest)(nil), "google.bigtable.admin.v2.DeleteSnapshotRequest")
	proto.RegisterType((*SnapshotTableMetadata)(nil), "google.bigtable.admin.v2.SnapshotTableMetadata")
	proto.RegisterType((*CreateTableFromSnapshotMetadata)(nil), "google.bigtable.admin.v2.CreateTableFromSnapshotMetadata")
}

func init() {
	proto.RegisterFile("google/bigtable/admin/v2/bigtable_table_admin.proto", fileDescriptor_43baa00e5f96b1e4)
}

var fileDescriptor_43baa00e5f96b1e4 = []byte{
	// 1989 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0xcf, 0x6f, 0x1b, 0xc7,
	0xf5, 0xf7, 0x90, 0x92, 0x23, 0x3f, 0xea, 0x87, 0x33, 0x5f, 0xc9, 0xa6, 0x69, 0x5b, 0x52, 0xf6,
	0xeb, 0xba, 0x8a, 0x2c, 0xef, 0xd6, 0x34, 0x8a, 0xd8, 0xb2, 0x8d, 0x78, 0x25, 0x35, 0xb2, 0xd0,
	0x18, 0x56, 0x56, 0x8e, 0x81, 0x04, 0x02, 0x88, 0xd5, 0x72, 0x44, 0x4d, 0xb5, 0xbf, 0xba, 0x3b,
	0x94, 0xc2, 0x14, 0x3e, 0x34, 0x87, 0x02, 0xee, 0x21, 0x40, 0x11, 0xf4, 0xd0, 0xa2, 0xa7, 0x22,
	0x40, 0x83, 0xf6, 0x1f, 0x28, 0x9a, 0x43, 0x7b, 0x76, 0x0f, 0x05, 0x5a, 0xf4, 0xc2, 0x43, 0x91,
	0x43, 0x0f, 0x6d, 0x0f, 0xbd, 0xf4, 0xd6, 0x53, 0x31, 0x33, 0xbb, 0xe4, 0x2e, 0xc9, 0xe5, 0x0f,
	0x59, 0x28, 0x7a, 0x49, 0x96, 0x33, 0xef, 0xbd, 0xf9, 0x7c, 0xde, 0xbc, 0x79, 0xf3, 0x19, 0x0b,
	0x6e, 0xd7, 0x3c, 0xaf, 0x66, 0x13, 0x6d, 0x8f, 0xd6, 0x98, 0xb9, 0x67, 0x13, 0xcd, 0xac, 0x3a,
	0xd4, 0xd5, 0x8e, 0xca, 0xad, 0x91, 0x8a, 0xfc, 0xaf, 0x18, 0x57, 0xfd, 0xc0, 0x63, 0x1e, 0x2e,
	0x4a, 0x27, 0x35, 0x36, 0x51, 0xe5, 0xe4, 0x51, 0xb9, 0x74, 0x25, 0x0a, 0x67, 0xfa, 0x54, 0x33,
	0x5d, 0xd7, 0x63, 0x26, 0xa3, 0x9e, 0x1b, 0x4a, 0xbf, 0xd2, 0xc5, 0xc4, 0xac, 0x65, 0x53, 0xe2,
	0xb2, 0x68, 0x62, 0x21, 0x31, 0xb1, 0x4f, 0x89, 0x5d, 0xad, 0xec, 0x91, 0x03, 0xf3, 0x88, 0x7a,
	0x41, 0x64, 0x70, 0x29, 0x61, 0x10, 0x90, 0xd0, 0xab, 0x07, 0x16, 0x89, 0xa6, 0xae, 0x65, 0x32,
	0x90, 0xd8, 0xa4, 0xd5, 0x7c, 0x64, 0x45, 0x4d, 0x47, 0x3b, 0xba, 0xc5, 0xff, 0x57, 0xf1, 0x3d,
	0x9b, 0x5a, 0x8d, 0x68, 0xbe, 0x94, 0x9e, 0x4f, 0xcd, 0xfd, 0x7f, 0x34, 0x67, 0x7b, 0x6e, 0x2d,
	0xa8, 0xbb, 0x2e, 0x75, 0x6b, 0x9a, 0xe7, 0x93, 0x20, 0xc5, 0x2d, 0x5e, 0x40, 0xfc, 0xda, 0xab,
	0xef, 0x6b, 0xd5, 0xba, 0x34, 0x88, 0xe6, 0x2f, 0x77, 0xce, 0x13, 0xc7, 0x67, 0x8d, 0x0e, 0xfe,
	0xad, 0x49, 0x46, 0x1d, 0x12, 0x32, 0xd3, 0xf1, 0xa5, 0x81, 0xf2, 0x45, 0x0e, 0xf0, 0x7a, 0x40,
	0x4c, 0x46, 0x9e, 0x72, 0x52, 0x06, 0xf9, 0x6e, 0x9d, 0x84, 0x0c, 0x3f, 0x84, 0xb3, 0xbe, 0x19,
	0x10, 0x97, 0x15, 0xd1, 0x22, 0x5a, 0x3a, 0xb7, 0xb6, 0xf4, 0x95, 0x9e, 0xfb, 0xb7, 0xae, 0xc0,
	0x62, 0x6b, 0x67, 0x64, 0x60, 0xd3, 0xa7, 0xa1, 0x6a, 0x79, 0x8e, 0xb6, 0xe5, 0x86, 0xcc, 0x74,
	0x2d, 0x62, 0x44, 0x7e, 0x78, 0x1e, 0x26, 0xe4, 0xfe, 0xd2, 0x6a, 0x31, 0x27, 0x62, 0xe4, 0xbf,
	0xd2, 0x73, 0xc6, 0x6b, 0x62, 0x70, 0xab, 0x8a, 0x57, 0x61, 0x5c, 0x7c, 0x16, 0xf3, 0x8b, 0x68,
	0xa9, 0x50, 0x5e, 0x50, 0xb3, 0xb6, 0x5e, 0x15, 0xc0, 0xa4, 0xb7, 0x74, 0xc1, 0x1f, 0xc0, 0x34,
	0x75, 0x29, 0xa3, 0xa6, 0x5d, 0x09, 0x7d, 0x9b, 0xb2, 0xb0, 0x38, 0xb6, 0x98, 0x5f, 0x2a, 0x94,
	0xcb, 0xd9, 0x41, 0xba, 0x39, 0xaa, 0x3b, 0xdc, 0xd5, 0x98, 0x8a, 0x22, 0x89, 0x5f, 0x61, 0xe9,
	0x12, 0x8c, 0x8b, 0x2f, 0x7c, 0x1e, 0xf2, 0x87, 0xa4, 0x21, 0xe8, 0x4f, 0x1a, 0xfc, 0x53, 0xf9,
	0x33, 0x82, 0xf9, 0x44, 0x98, 0x77, 0x02, 0xcf, 0xd9, 0x71, 0x4d, 0x3f, 0x3c, 0xf0, 0xd8, 0x7f,
	0x2f, 0x6d, 0xef, 0xc1, 0x8c, 0x2c, 0xd2, 0x4a, 0x18, 0xad, 0x2d, 0x12, 0x38, 0xc4, 0x52, 0x2d,
	0xac, 0xd3, 0x32, 0x40, 0xfc, 0x5b, 0xf9, 0x1d, 0x82, 0xff, 0xdb, 0x08, 0x3c, 0xdf, 0xf0, 0x8e,
	0x0d, 0xd3, 0xad, 0xb5, 0x6a, 0xe0, 0x2e, 0x8c, 0xb9, 0xa6, 0x43, 0x22, 0x2a, 0x5f, 0x13, 0xf1,
	0x17, 0xe0, 0x6a, 0x56, 0x7c, 0x99, 0x5b, 0xe1, 0x82, 0xaf, 0xc3, 0x74, 0xe0, 0x1d, 0x57, 0x0e,
	0x49, 0xa3, 0xe2, 0x07, 0x64, 0x9f, 0x7e, 0x24, 0xb8, 0x4c, 0x3e, 0x3a, 0x63, 0x4c, 0x06, 0xde,
	0xf1, 0xb7, 0x49, 0x63, 0x5b, 0x8c, 0xe2, 0xfb, 0x50, 0xaa, 0x12, 0x9b, 0x30, 0x52, 0x31, 0x6d,
	0xbb, 0x52, 0x35, 0x99, 0x59, 0xd9, 0x0f, 0x3c, 0xa7, 0xd2, 0xae, 0x8c, 0x89, 0x47, 0x67, 0x8c,
	0x0b, 0xd2, 0x46, 0xb7, 0xed, 0x0d, 0x93, 0x99, 0x3c, 0xef, 0xb2, 0x24, 0x26, 0xe0, 0x2c, 0x33,
	0x83, 0x1a, 0x61, 0xca, 0xef, 0x11, 0xbc, 0xfe, 0x2e, 0x0d, 0x99, 0x18, 0x0f, 0x4f, 0x6f, 0x37,
	0xee, 0xc0, 0xd8, 0x11, 0x25, 0xc7, 0x02, 0xfd, 0x74, 0xf9, 0xda, 0x80, 0x1a, 0x55, 0x9f, 0x51,
	0x72, 0x6c, 0x08, 0x0f, 0x7c, 0x19, 0xce, 0xf9, 0x66, 0x8d, 0x54, 0x42, 0xfa, 0x31, 0x29, 0x8e,
	0x2d, 0xa2, 0xa5, 0x71, 0x63, 0x82, 0x0f, 0xec, 0xd0, 0x8f, 0x09, 0xbe, 0x0a, 0x20, 0x26, 0x99,
	0x77, 0x48, 0x5c, 0xb9, 0x7f, 0x86, 0x30, 0x7f, 0xca, 0x07, 0x94, 0x3a, 0xe0, 0x24, 0x99, 0xd0,
	0xf7, 0xdc, 0x90, 0xe0, 0xb7, 0x38, 0x5b, 0x3e, 0x52, 0x44, 0xa2, 0xd8, 0x07, 0x9d, 0x18, 0x23,
	0x32, 0xc7, 0xd7, 0x61, 0xc6, 0x25, 0x1f, 0xb1, 0x4a, 0x62, 0x49, 0x51, 0x59, 0xc6, 0x14, 0x1f,
	0xde, 0x6e, 0x2d, 0xfb, 0x03, 0x04, 0x33, 0x9b, 0x84, 0xa5, 0xfa, 0xc0, 0x2b, 0xd4, 0xc0, 0x89,
	0x73, 0xa7, 0x3c, 0x01, 0xbc, 0x21, 0x76, 0xfc, 0x94, 0xa0, 0x28, 0x2f, 0xf2, 0x70, 0xf9, 0xb1,
	0x57, 0xa5, 0xfb, 0x8d, 0x75, 0xcf, 0xae, 0x3b, 0xee, 0x3b, 0xa6, 0x43, 0x6d, 0xda, 0x2e, 0x94,
	0x57, 0x60, 0xe9, 0xc0, 0x94, 0xc3, 0x23, 0x53, 0x4b, 0x36, 0xed, 0x62, 0x4e, 0x6c, 0xce, 0x5a,
	0x36, 0xdd, 0x3e, 0x40, 0xe4, 0x5c, 0x14, 0x4a, 0x1e, 0xfc, 0x74, 0xf4, 0xd2, 0x6f, 0x11, 0x4c,
	0x26, 0x8d, 0xf0, 0x34, 0xe4, 0x68, 0x55, 0x02, 0x37, 0x72, 0xb4, 0xca, 0x6b, 0xde, 0x12, 0x3d,
	0x4a, 0xe4, 0xbd, 0x50, 0xbe, 0xde, 0xa7, 0x25, 0xb6, 0x21, 0x34, 0x1e, 0x9d, 0x31, 0x22, 0x3f,
	0x1e, 0xa1, 0xee, 0x57, 0x79, 0x84, 0xfc, 0xa8, 0x11, 0xa4, 0x1f, 0x9e, 0x85, 0xb1, 0x6a, 0xe0,
	0xf9, 0xa2, 0xec, 0xf9, 0xf9, 0x15, 0xbf, 0xd6, 0xc6, 0x21, 0xef, 0x78, 0x55, 0x65, 0x17, 0x16,
	0x36, 0x89, 0xcb, 0xef, 0x38, 0xb2, 0xee, 0xb9, 0x21, 0x0d, 0x19, 0x71, 0xad, 0x86, 0xa8, 0xc0,
	0x53, 0xd8, 0xe9, 0x27, 0xb0, 0x98, 0x1d, 0x3d, 0x3a, 0x48, 0x37, 0xe0, 0x75, 0xab, 0x3d, 0x17,
	0x9d, 0x08, 0x99, 0xc1, 0xf3, 0x56, 0x87, 0x13, 0x3f, 0x14, 0x17, 0xd7, 0x0f, 0x88, 0x75, 0x98,
	0x08, 0x77, 0x0a, 0x65, 0xf3, 0x8d, 0x5e, 0x18, 0x12, 0xfd, 0xbe, 0x1b, 0xc8, 0x2a, 0x14, 0xbb,
	0x71, 0x44, 0x8c, 0xe6, 0x01, 0x5a, 0xf6, 0xb2, 0xd9, 0x4d, 0x18, 0x89, 0x11, 0xe5, 0x45, 0x0e,
	0x66, 0xe3, 0x76, 0x7f, 0x5a, 0xc7, 0x5b, 0x87, 0xd7, 0x2c, 0xbb, 0x1e, 0x32, 0x12, 0x44, 0xb8,
	0xbf, 0x2e, 0xbc, 0xdf, 0x80, 0x85, 0x2c, 0xef, 0x75, 0x69, 0x6e, 0xc4, 0x7e, 0xf8, 0x1a, 0x14,
	0xe2, 0x4b, 0x8c, 0x5f, 0x77, 0xf9, 0x36, 0x7d, 0x88, 0xc7, 0xb7, 0xaa, 0xf8, 0x06, 0xe4, 0x19,
	0xb3, 0x45, 0x31, 0x15, 0xca, 0x97, 0xe2, 0x62, 0x8c, 0x05, 0x8d, 0xba, 0x11, 0xa9, 0x21, 0x83,
	0x5b, 0xe1, 0x45, 0x28, 0x54, 0x49, 0x68, 0x05, 0xd4, 0xe7, 0x63, 0xc5, 0x71, 0xb1, 0xab, 0xc9,
	0x21, 0xc5, 0x00, 0xbc, 0x49, 0x58, 0xe7, 0xc5, 0x7d, 0x3f, 0x95, 0x88, 0xe1, 0xef, 0x52, 0x59,
	0x75, 0x9f, 0x21, 0x98, 0xe5, 0x1d, 0x3b, 0x1e, 0x6e, 0x35, 0x96, 0xb7, 0x3b, 0x6e, 0xa0, 0xa1,
	0x73, 0x14, 0x5f, 0x40, 0xa9, 0x6b, 0x24, 0x37, 0xda, 0x35, 0xf2, 0x7d, 0x04, 0x73, 0x1d, 0xa8,
	0xa2, 0x7a, 0x79, 0x08, 0xe7, 0xe2, 0x04, 0xc7, 0xb7, 0x89, 0x92, 0x7d, 0xca, 0x5b, 0x64, 0xdb,
	0x4e, 0x43, 0xdf, 0x29, 0xef, 0xc3, 0x9c, 0x6c, 0xe5, 0xa7, 0x9b, 0xf0, 0x7f, 0x22, 0x98, 0x4b,
	0x15, 0xf4, 0x63, 0xc2, 0x4c, 0x2e, 0x1f, 0xf0, 0x07, 0x70, 0xde, 0x0b, 0x68, 0x8d, 0xba, 0xa6,
	0x5d, 0x09, 0xe4, 0x5a, 0x62, 0x8d, 0x42, 0x59, 0x1d, 0xcc, 0x30, 0x79, 0x36, 0x8c, 0x99, 0x38,
	0x4e, 0x0c, 0xf9, 0x01, 0x4c, 0x46, 0x11, 0x2b, 0x5c, 0x45, 0x47, 0x0d, 0xb6, 0xd4, 0x55, 0x91,
	0x4f, 0x63, 0x89, 0x6d, 0x14, 0x22, 0x7b, 0x3e, 0x82, 0xef, 0x41, 0x61, 0x9f, 0xba, 0x34, 0x3c,
	0x90, 0xde, 0xf9, 0x81, 0xde, 0x20, 0xcd, 0xf9, 0x80, 0xf2, 0x49, 0x0e, 0x16, 0x32, 0xb4, 0x67,
	0x8b, 0xba, 0x95, 0x49, 0xfd, 0xce, 0x50, 0xba, 0xb8, 0x87, 0xa0, 0xfd, 0x9f, 0x4a, 0x42, 0xf9,
	0xef, 0x97, 0x01, 0xaf, 0x45, 0x0c, 0x04, 0x62, 0x9d, 0xb3, 0xc0, 0xbf, 0x42, 0x50, 0x48, 0xd0,
	0xc0, 0x2b, 0xa3, 0xbc, 0x02, 0x4a, 0x83, 0x64, 0x94, 0xf2, 0xb8, 0xa9, 0xcf, 0xc9, 0xd3, 0xb8,
	0x12, 0x2b, 0x73, 0xf9, 0xf1, 0xc9, 0x9f, 0xfe, 0xfa, 0x59, 0x4e, 0x53, 0x96, 0xf9, 0x8b, 0xf0,
	0x7b, 0xd2, 0xe2, 0x81, 0x1f, 0x78, 0xdf, 0x21, 0x16, 0x0b, 0xb5, 0x65, 0x8d, 0x46, 0x62, 0x32,
	0xd4, 0x96, 0x9f, 0xcb, 0x17, 0x63, 0xb8, 0x8a, 0x96, 0xf1, 0x0f, 0x73, 0x70, 0x31, 0x23, 0xe9,
	0xf8, 0xc4, 0xfb, 0x54, 0xba, 0x1a, 0x7b, 0x26, 0x9e, 0x92, 0xea, 0x93, 0xf8, 0x29, 0xa9, 0xfc,
	0x18, 0xbd, 0xd4, 0x97, 0x60, 0x5c, 0xe6, 0x67, 0x50, 0x21, 0x35, 0xf5, 0x85, 0x4e, 0xbe, 0x1d,
	0x4f, 0x0e, 0xc1, 0x7c, 0x4d, 0x79, 0x30, 0x02, 0x73, 0x29, 0x2e, 0x92, 0xcb, 0xf1, 0x64, 0x7c,
	0x8e, 0x00, 0xda, 0x52, 0x17, 0xdf, 0xc8, 0xe6, 0xdf, 0xa5, 0xee, 0x4b, 0x2b, 0xc3, 0x19, 0xcb,
	0x96, 0xa7, 0xdc, 0x6b, 0xea, 0x51, 0x4f, 0x15, 0xe0, 0x57, 0xf0, 0x08, 0xdb, 0x86, 0x7f, 0x84,
	0x60, 0x22, 0x56, 0xc6, 0xf8, 0xcd, 0xec, 0x75, 0x3b, 0xd4, 0xf3, 0xe0, 0xda, 0xba, 0xdb, 0xd4,
	0x45, 0x43, 0x4b, 0x61, 0xe2, 0x03, 0x19, 0x88, 0x22, 0x40, 0xda, 0xf2, 0x73, 0xfc, 0x29, 0x82,
	0x42, 0x42, 0x25, 0xf7, 0xab, 0xfa, 0x6e, 0x31, 0x5d, 0xba, 0xd0, 0x75, 0xe4, 0xbe, 0xe5, 0xf8,
	0xac, 0xd1, 0x01, 0x68, 0x79, 0x14, 0x40, 0x7f, 0x40, 0x30, 0xdb, 0x4b, 0xdb, 0xe2, 0x6f, 0x9e,
	0x48, 0x0b, 0x0f, 0x4e, 0x5e, 0xa5, 0xa9, 0x63, 0x0e, 0x6d, 0x25, 0x25, 0x91, 0x05, 0xf2, 0x0d,
	0xe5, 0xed, 0xe1, 0x91, 0xaf, 0x3a, 0x3d, 0x50, 0xf0, 0xea, 0xfc, 0x09, 0x82, 0xc9, 0xe4, 0xc3,
	0x18, 0xdf, 0xec, 0x93, 0xe3, 0xee, 0x07, 0x74, 0x66, 0x92, 0xd7, 0x04, 0xc6, 0xfb, 0xca, 0x5b,
	0x23, 0x60, 0xac, 0x26, 0xe2, 0x73, 0x6c, 0x7f, 0x43, 0x50, 0xcc, 0x52, 0xba, 0xf8, 0x6e, 0xbf,
	0x12, 0xed, 0xab, 0xbd, 0x4b, 0xab, 0x27, 0x71, 0x8d, 0xce, 0xd8, 0xfb, 0xc9, 0xe2, 0x79, 0xa4,
	0xac, 0x8f, 0x40, 0xaf, 0x96, 0x11, 0x9b, 0x53, 0x6d, 0x22, 0x38, 0xdf, 0x29, 0x7d, 0xf1, 0xad,
	0x3e, 0xad, 0xb2, 0xb7, 0x5c, 0x2f, 0x95, 0x47, 0x71, 0x89, 0x28, 0x55, 0x9a, 0xfa, 0x05, 0x51,
	0x63, 0x5d, 0x6a, 0x5d, 0x90, 0x7c, 0xa8, 0xdc, 0x1b, 0x81, 0xa4, 0xd5, 0xb1, 0x0a, 0x27, 0xf7,
	0x0f, 0x04, 0x53, 0x29, 0xf9, 0x81, 0x47, 0xd4, 0x29, 0x83, 0x5a, 0xff, 0x0b, 0xf4, 0x52, 0x7f,
	0x03, 0x26, 0x5a, 0x77, 0x4c, 0x6f, 0xdd, 0xd4, 0xd4, 0xaf, 0x49, 0x9a, 0x52, 0x7f, 0xae, 0x24,
	0x74, 0xf9, 0x4a, 0x42, 0x3d, 0x0b, 0xd2, 0x77, 0x94, 0xdb, 0x23, 0x90, 0x0e, 0x13, 0xed, 0xfe,
	0x0b, 0x04, 0x85, 0x84, 0xf8, 0xee, 0xd7, 0xb3, 0xba, 0x35, 0x7a, 0x69, 0x08, 0x89, 0xaa, 0x6c,
	0x26, 0x4b, 0x70, 0x15, 0xdf, 0x19, 0x08, 0x34, 0x22, 0xcc, 0x3f, 0x5b, 0xea, 0x96, 0x77, 0xb3,
	0x2f, 0x11, 0x4c, 0xa5, 0xc4, 0x73, 0xbf, 0x7d, 0xe9, 0xa5, 0xfd, 0x4b, 0xda, 0xd0, 0xf6, 0x51,
	0xad, 0x6d, 0xa5, 0xaf, 0xa8, 0x18, 0x7d, 0xdf, 0x2b, 0x2a, 0x81, 0xff, 0x79, 0x9b, 0x00, 0xfe,
	0x39, 0x82, 0xe9, 0xb4, 0xee, 0xc6, 0xda, 0xa0, 0xfb, 0xa1, 0x33, 0xdd, 0x59, 0xdd, 0x2b, 0x9d,
	0xe2, 0xe5, 0x93, 0xa7, 0xf8, 0x67, 0x08, 0x26, 0x37, 0x09, 0xdb, 0x32, 0x9d, 0x6d, 0xf1, 0x8f,
	0xe2, 0xb8, 0xb5, 0xc1, 0xd4, 0x74, 0xd4, 0xa3, 0x5b, 0x6a, 0x72, 0x32, 0x46, 0x35, 0xd7, 0x61,
	0x23, 0x67, 0x95, 0xf7, 0x9a, 0xfa, 0x44, 0xfc, 0xcf, 0xf7, 0xa9, 0x93, 0x19, 0x0f, 0x0e, 0xd3,
	0x82, 0xda, 0xab, 0xf1, 0x62, 0xfd, 0x17, 0x82, 0xc9, 0x9d, 0x7e, 0xf0, 0x76, 0x86, 0x87, 0xf7,
	0x0b, 0xd4, 0xd4, 0x67, 0x62, 0x28, 0x2b, 0xf2, 0x6f, 0x00, 0x02, 0xe6, 0xa7, 0x68, 0x64, 0x9c,
	0x61, 0x1a, 0xe7, 0x87, 0xef, 0x2a, 0x9b, 0x43, 0x45, 0x48, 0x6c, 0xc3, 0x9e, 0x69, 0x1d, 0xd6,
	0xfd, 0x5e, 0xd1, 0xf0, 0xe7, 0x39, 0xc0, 0x4f, 0x49, 0x28, 0x06, 0x49, 0xe0, 0xd0, 0x30, 0xe4,
	0x97, 0x2a, 0x5e, 0xea, 0xe0, 0xd5, 0x6d, 0x12, 0x67, 0xe0, 0xcd, 0x21, 0x2c, 0xa3, 0x82, 0xff,
	0x35, 0x6a, 0xea, 0xb3, 0xed, 0xac, 0xb4, 0x2d, 0x44, 0x6a, 0x7e, 0x8a, 0x14, 0x7d, 0xc4, 0xd4,
	0xb0, 0xae, 0xb5, 0x78, 0x82, 0x0c, 0xe5, 0xf1, 0x2b, 0x24, 0xa8, 0x67, 0xcc, 0xd2, 0x5f, 0x72,
	0x2f, 0xf5, 0x2b, 0xf1, 0x49, 0x92, 0x07, 0x29, 0xfd, 0x62, 0xfd, 0xa3, 0xfe, 0x65, 0xee, 0x80,
	0x31, 0x3f, 0x5c, 0xd5, 0xb4, 0xe3, 0xe3, 0xe3, 0xce, 0xf7, 0xac, 0x59, 0x67, 0x07, 0x5a, 0xfa,
	0x24, 0xae, 0x8c, 0x66, 0xae, 0x8a, 0xef, 0x81, 0x4e, 0x96, 0xed, 0xd5, 0xab, 0x37, 0x47, 0x5c,
	0xa9, 0x97, 0xd3, 0x48, 0xeb, 0xf9, 0xb6, 0xc9, 0xf6, 0xbd, 0xc0, 0x19, 0xd1, 0x5c, 0x0d, 0x88,
	0x59, 0xbd, 0xe9, 0xb9, 0x76, 0x63, 0xed, 0x37, 0x08, 0xae, 0x58, 0x9e, 0x93, 0xd9, 0xb4, 0xd6,
	0x2e, 0x76, 0xbf, 0x04, 0xb7, 0x79, 0xa3, 0xda, 0x46, 0x1f, 0x3e, 0x88, 0x9c, 0x6a, 0x9e, 0x6d,
	0xba, 0x35, 0xd5, 0x0b, 0x6a, 0x5a, 0x8d, 0xb8, 0xa2, 0x8d, 0x69, 0x6d, 0x10, 0xdd, 0x7f, 0xd7,
	0xbb, 0x27, 0x3e, 0x7e, 0x99, 0x9b, 0xdf, 0x94, 0xfe, 0xeb, 0x1c, 0x9c, 0x1a, 0xaf, 0xa3, 0x8a,
	0x35, 0xd4, 0x67, 0xe5, 0x97, 0xb1, 0xc1, 0xae, 0x30, 0xd8, 0x8d, 0x0d, 0x76, 0x85, 0xc1, 0xee,
	0xb3, 0xf2, 0xde, 0x59, 0xb1, 0xd6, 0xed, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0x77, 0x58, 0xff,
	0xe6, 0x04, 0x1d, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BigtableTableAdminClient is the client API for BigtableTableAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BigtableTableAdminClient interface {
	// Creates a new table in the specified instance.
	// The table can be created with a full set of initial column families,
	// specified in the request.
	CreateTable(ctx context.Context, in *CreateTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Creates a new table from the specified snapshot. The target table must
	// not exist. The snapshot and the table must be in the same instance.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	CreateTableFromSnapshot(ctx context.Context, in *CreateTableFromSnapshotRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists all tables served from a specified instance.
	ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error)
	// Gets metadata information about the specified table.
	GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Permanently deletes a specified table and all of its data.
	DeleteTable(ctx context.Context, in *DeleteTableRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Performs a series of column family modifications on the specified table.
	// Either all or none of the modifications will occur before this method
	// returns, but data requests received prior to that point may see a table
	// where only some modifications have taken effect.
	ModifyColumnFamilies(ctx context.Context, in *ModifyColumnFamiliesRequest, opts ...grpc.CallOption) (*Table, error)
	// Permanently drop/delete a row range from a specified table. The request can
	// specify whether to delete all rows in a table, or only those that match a
	// particular prefix.
	DropRowRange(ctx context.Context, in *DropRowRangeRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Generates a consistency token for a Table, which can be used in
	// CheckConsistency to check whether mutations to the table that finished
	// before this call started have been replicated. The tokens will be available
	// for 90 days.
	GenerateConsistencyToken(ctx context.Context, in *GenerateConsistencyTokenRequest, opts ...grpc.CallOption) (*GenerateConsistencyTokenResponse, error)
	// Checks replication consistency based on a consistency token, that is, if
	// replication has caught up based on the conditions specified in the token
	// and the check request.
	CheckConsistency(ctx context.Context, in *CheckConsistencyRequest, opts ...grpc.CallOption) (*CheckConsistencyResponse, error)
	// Creates a new snapshot in the specified cluster from the specified
	// source table. The cluster and the table must be in the same instance.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	SnapshotTable(ctx context.Context, in *SnapshotTableRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets metadata information about the specified snapshot.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Lists all snapshots associated with the specified cluster.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error)
	// Permanently deletes the specified snapshot.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists but does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the access control policy on a Table or Backup resource.
	// Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that the caller has on the specified table resource.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type bigtableTableAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewBigtableTableAdminClient(cc grpc.ClientConnInterface) BigtableTableAdminClient {
	return &bigtableTableAdminClient{cc}
}

func (c *bigtableTableAdminClient) CreateTable(ctx context.Context, in *CreateTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/CreateTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) CreateTableFromSnapshot(ctx context.Context, in *CreateTableFromSnapshotRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/CreateTableFromSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error) {
	out := new(ListTablesResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/ListTables", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/GetTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) DeleteTable(ctx context.Context, in *DeleteTableRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) ModifyColumnFamilies(ctx context.Context, in *ModifyColumnFamiliesRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/ModifyColumnFamilies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) DropRowRange(ctx context.Context, in *DropRowRangeRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/DropRowRange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GenerateConsistencyToken(ctx context.Context, in *GenerateConsistencyTokenRequest, opts ...grpc.CallOption) (*GenerateConsistencyTokenResponse, error) {
	out := new(GenerateConsistencyTokenResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/GenerateConsistencyToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) CheckConsistency(ctx context.Context, in *CheckConsistencyRequest, opts ...grpc.CallOption) (*CheckConsistencyResponse, error) {
	out := new(CheckConsistencyResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/CheckConsistency", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) SnapshotTable(ctx context.Context, in *SnapshotTableRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/SnapshotTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/GetSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error) {
	out := new(ListSnapshotsResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/ListSnapshots", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableAdminClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableTableAdmin/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigtableTableAdminServer is the server API for BigtableTableAdmin service.
type BigtableTableAdminServer interface {
	// Creates a new table in the specified instance.
	// The table can be created with a full set of initial column families,
	// specified in the request.
	CreateTable(context.Context, *CreateTableRequest) (*Table, error)
	// Creates a new table from the specified snapshot. The target table must
	// not exist. The snapshot and the table must be in the same instance.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	CreateTableFromSnapshot(context.Context, *CreateTableFromSnapshotRequest) (*longrunning.Operation, error)
	// Lists all tables served from a specified instance.
	ListTables(context.Context, *ListTablesRequest) (*ListTablesResponse, error)
	// Gets metadata information about the specified table.
	GetTable(context.Context, *GetTableRequest) (*Table, error)
	// Permanently deletes a specified table and all of its data.
	DeleteTable(context.Context, *DeleteTableRequest) (*empty.Empty, error)
	// Performs a series of column family modifications on the specified table.
	// Either all or none of the modifications will occur before this method
	// returns, but data requests received prior to that point may see a table
	// where only some modifications have taken effect.
	ModifyColumnFamilies(context.Context, *ModifyColumnFamiliesRequest) (*Table, error)
	// Permanently drop/delete a row range from a specified table. The request can
	// specify whether to delete all rows in a table, or only those that match a
	// particular prefix.
	DropRowRange(context.Context, *DropRowRangeRequest) (*empty.Empty, error)
	// Generates a consistency token for a Table, which can be used in
	// CheckConsistency to check whether mutations to the table that finished
	// before this call started have been replicated. The tokens will be available
	// for 90 days.
	GenerateConsistencyToken(context.Context, *GenerateConsistencyTokenRequest) (*GenerateConsistencyTokenResponse, error)
	// Checks replication consistency based on a consistency token, that is, if
	// replication has caught up based on the conditions specified in the token
	// and the check request.
	CheckConsistency(context.Context, *CheckConsistencyRequest) (*CheckConsistencyResponse, error)
	// Creates a new snapshot in the specified cluster from the specified
	// source table. The cluster and the table must be in the same instance.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	SnapshotTable(context.Context, *SnapshotTableRequest) (*longrunning.Operation, error)
	// Gets metadata information about the specified snapshot.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error)
	// Lists all snapshots associated with the specified cluster.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error)
	// Permanently deletes the specified snapshot.
	//
	// Note: This is a private alpha release of Cloud Bigtable snapshots. This
	// feature is not currently available to most Cloud Bigtable customers. This
	// feature might be changed in backward-incompatible ways and is not
	// recommended for production use. It is not subject to any SLA or deprecation
	// policy.
	DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*empty.Empty, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists but does not have a policy
	// set.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the access control policy on a Table or Backup resource.
	// Replaces any existing policy.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that the caller has on the specified table resource.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedBigtableTableAdminServer can be embedded to have forward compatible implementations.
type UnimplementedBigtableTableAdminServer struct {
}

func (*UnimplementedBigtableTableAdminServer) CreateTable(ctx context.Context, req *CreateTableRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTable not implemented")
}
func (*UnimplementedBigtableTableAdminServer) CreateTableFromSnapshot(ctx context.Context, req *CreateTableFromSnapshotRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTableFromSnapshot not implemented")
}
func (*UnimplementedBigtableTableAdminServer) ListTables(ctx context.Context, req *ListTablesRequest) (*ListTablesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTables not implemented")
}
func (*UnimplementedBigtableTableAdminServer) GetTable(ctx context.Context, req *GetTableRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTable not implemented")
}
func (*UnimplementedBigtableTableAdminServer) DeleteTable(ctx context.Context, req *DeleteTableRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTable not implemented")
}
func (*UnimplementedBigtableTableAdminServer) ModifyColumnFamilies(ctx context.Context, req *ModifyColumnFamiliesRequest) (*Table, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyColumnFamilies not implemented")
}
func (*UnimplementedBigtableTableAdminServer) DropRowRange(ctx context.Context, req *DropRowRangeRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DropRowRange not implemented")
}
func (*UnimplementedBigtableTableAdminServer) GenerateConsistencyToken(ctx context.Context, req *GenerateConsistencyTokenRequest) (*GenerateConsistencyTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateConsistencyToken not implemented")
}
func (*UnimplementedBigtableTableAdminServer) CheckConsistency(ctx context.Context, req *CheckConsistencyRequest) (*CheckConsistencyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckConsistency not implemented")
}
func (*UnimplementedBigtableTableAdminServer) SnapshotTable(ctx context.Context, req *SnapshotTableRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SnapshotTable not implemented")
}
func (*UnimplementedBigtableTableAdminServer) GetSnapshot(ctx context.Context, req *GetSnapshotRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSnapshot not implemented")
}
func (*UnimplementedBigtableTableAdminServer) ListSnapshots(ctx context.Context, req *ListSnapshotsRequest) (*ListSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSnapshots not implemented")
}
func (*UnimplementedBigtableTableAdminServer) DeleteSnapshot(ctx context.Context, req *DeleteSnapshotRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSnapshot not implemented")
}
func (*UnimplementedBigtableTableAdminServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedBigtableTableAdminServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedBigtableTableAdminServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterBigtableTableAdminServer(s *grpc.Server, srv BigtableTableAdminServer) {
	s.RegisterService(&_BigtableTableAdmin_serviceDesc, srv)
}

func _BigtableTableAdmin_CreateTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CreateTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/CreateTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CreateTable(ctx, req.(*CreateTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_CreateTableFromSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTableFromSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CreateTableFromSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/CreateTableFromSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CreateTableFromSnapshot(ctx, req.(*CreateTableFromSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_ListTables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).ListTables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/ListTables",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).ListTables(ctx, req.(*ListTablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GetTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GetTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/GetTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GetTable(ctx, req.(*GetTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_DeleteTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).DeleteTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).DeleteTable(ctx, req.(*DeleteTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_ModifyColumnFamilies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyColumnFamiliesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).ModifyColumnFamilies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/ModifyColumnFamilies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).ModifyColumnFamilies(ctx, req.(*ModifyColumnFamiliesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_DropRowRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DropRowRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).DropRowRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/DropRowRange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).DropRowRange(ctx, req.(*DropRowRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GenerateConsistencyToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateConsistencyTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GenerateConsistencyToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/GenerateConsistencyToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GenerateConsistencyToken(ctx, req.(*GenerateConsistencyTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_CheckConsistency_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckConsistencyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).CheckConsistency(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/CheckConsistency",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).CheckConsistency(ctx, req.(*CheckConsistencyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_SnapshotTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SnapshotTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).SnapshotTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/SnapshotTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).SnapshotTable(ctx, req.(*SnapshotTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GetSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GetSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/GetSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GetSnapshot(ctx, req.(*GetSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_ListSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).ListSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/ListSnapshots",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).ListSnapshots(ctx, req.(*ListSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_DeleteSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).DeleteSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/DeleteSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).DeleteSnapshot(ctx, req.(*DeleteSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableAdmin_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableAdminServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableTableAdmin/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableAdminServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigtableTableAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.bigtable.admin.v2.BigtableTableAdmin",
	HandlerType: (*BigtableTableAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTable",
			Handler:    _BigtableTableAdmin_CreateTable_Handler,
		},
		{
			MethodName: "CreateTableFromSnapshot",
			Handler:    _BigtableTableAdmin_CreateTableFromSnapshot_Handler,
		},
		{
			MethodName: "ListTables",
			Handler:    _BigtableTableAdmin_ListTables_Handler,
		},
		{
			MethodName: "GetTable",
			Handler:    _BigtableTableAdmin_GetTable_Handler,
		},
		{
			MethodName: "DeleteTable",
			Handler:    _BigtableTableAdmin_DeleteTable_Handler,
		},
		{
			MethodName: "ModifyColumnFamilies",
			Handler:    _BigtableTableAdmin_ModifyColumnFamilies_Handler,
		},
		{
			MethodName: "DropRowRange",
			Handler:    _BigtableTableAdmin_DropRowRange_Handler,
		},
		{
			MethodName: "GenerateConsistencyToken",
			Handler:    _BigtableTableAdmin_GenerateConsistencyToken_Handler,
		},
		{
			MethodName: "CheckConsistency",
			Handler:    _BigtableTableAdmin_CheckConsistency_Handler,
		},
		{
			MethodName: "SnapshotTable",
			Handler:    _BigtableTableAdmin_SnapshotTable_Handler,
		},
		{
			MethodName: "GetSnapshot",
			Handler:    _BigtableTableAdmin_GetSnapshot_Handler,
		},
		{
			MethodName: "ListSnapshots",
			Handler:    _BigtableTableAdmin_ListSnapshots_Handler,
		},
		{
			MethodName: "DeleteSnapshot",
			Handler:    _BigtableTableAdmin_DeleteSnapshot_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _BigtableTableAdmin_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _BigtableTableAdmin_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _BigtableTableAdmin_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/bigtable/admin/v2/bigtable_table_admin.proto",
}
