// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/ads/googleads/v6/common/segments.proto

package common

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v6/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Segment only fields.
type Segments struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ad Destination type.
	AdDestinationType enums.AdDestinationTypeEnum_AdDestinationType `protobuf:"varint,136,opt,name=ad_destination_type,json=adDestinationType,proto3,enum=google.ads.googleads.v6.enums.AdDestinationTypeEnum_AdDestinationType" json:"ad_destination_type,omitempty"`
	// Ad network type.
	AdNetworkType enums.AdNetworkTypeEnum_AdNetworkType `protobuf:"varint,3,opt,name=ad_network_type,json=adNetworkType,proto3,enum=google.ads.googleads.v6.enums.AdNetworkTypeEnum_AdNetworkType" json:"ad_network_type,omitempty"`
	// Budget campaign association status.
	BudgetCampaignAssociationStatus *BudgetCampaignAssociationStatus `protobuf:"bytes,134,opt,name=budget_campaign_association_status,json=budgetCampaignAssociationStatus,proto3" json:"budget_campaign_association_status,omitempty"`
	// Click type.
	ClickType enums.ClickTypeEnum_ClickType `protobuf:"varint,26,opt,name=click_type,json=clickType,proto3,enum=google.ads.googleads.v6.enums.ClickTypeEnum_ClickType" json:"click_type,omitempty"`
	// Resource name of the conversion action.
	ConversionAction *string `protobuf:"bytes,113,opt,name=conversion_action,json=conversionAction,proto3,oneof" json:"conversion_action,omitempty"`
	// Conversion action category.
	ConversionActionCategory enums.ConversionActionCategoryEnum_ConversionActionCategory `protobuf:"varint,53,opt,name=conversion_action_category,json=conversionActionCategory,proto3,enum=google.ads.googleads.v6.enums.ConversionActionCategoryEnum_ConversionActionCategory" json:"conversion_action_category,omitempty"`
	// Conversion action name.
	ConversionActionName *string `protobuf:"bytes,114,opt,name=conversion_action_name,json=conversionActionName,proto3,oneof" json:"conversion_action_name,omitempty"`
	// This segments your conversion columns by the original conversion and
	// conversion value vs. the delta if conversions were adjusted. False row has
	// the data as originally stated; While true row has the delta between data
	// now and the data as originally stated. Summing the two together results
	// post-adjustment data.
	ConversionAdjustment *bool `protobuf:"varint,115,opt,name=conversion_adjustment,json=conversionAdjustment,proto3,oneof" json:"conversion_adjustment,omitempty"`
	// Conversion attribution event type.
	ConversionAttributionEventType enums.ConversionAttributionEventTypeEnum_ConversionAttributionEventType `protobuf:"varint,2,opt,name=conversion_attribution_event_type,json=conversionAttributionEventType,proto3,enum=google.ads.googleads.v6.enums.ConversionAttributionEventTypeEnum_ConversionAttributionEventType" json:"conversion_attribution_event_type,omitempty"`
	// An enum value representing the number of days between the impression and
	// the conversion.
	ConversionLagBucket enums.ConversionLagBucketEnum_ConversionLagBucket `protobuf:"varint,50,opt,name=conversion_lag_bucket,json=conversionLagBucket,proto3,enum=google.ads.googleads.v6.enums.ConversionLagBucketEnum_ConversionLagBucket" json:"conversion_lag_bucket,omitempty"`
	// An enum value representing the number of days between the impression and
	// the conversion or between the impression and adjustments to the conversion.
	ConversionOrAdjustmentLagBucket enums.ConversionOrAdjustmentLagBucketEnum_ConversionOrAdjustmentLagBucket `protobuf:"varint,51,opt,name=conversion_or_adjustment_lag_bucket,json=conversionOrAdjustmentLagBucket,proto3,enum=google.ads.googleads.v6.enums.ConversionOrAdjustmentLagBucketEnum_ConversionOrAdjustmentLagBucket" json:"conversion_or_adjustment_lag_bucket,omitempty"`
	// Date to which metrics apply.
	// yyyy-MM-dd format, e.g., 2018-04-17.
	Date *string `protobuf:"bytes,79,opt,name=date,proto3,oneof" json:"date,omitempty"`
	// Day of the week, e.g., MONDAY.
	DayOfWeek enums.DayOfWeekEnum_DayOfWeek `protobuf:"varint,5,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.ads.googleads.v6.enums.DayOfWeekEnum_DayOfWeek" json:"day_of_week,omitempty"`
	// Device to which metrics apply.
	Device enums.DeviceEnum_Device `protobuf:"varint,1,opt,name=device,proto3,enum=google.ads.googleads.v6.enums.DeviceEnum_Device" json:"device,omitempty"`
	// External conversion source.
	ExternalConversionSource enums.ExternalConversionSourceEnum_ExternalConversionSource `protobuf:"varint,55,opt,name=external_conversion_source,json=externalConversionSource,proto3,enum=google.ads.googleads.v6.enums.ExternalConversionSourceEnum_ExternalConversionSource" json:"external_conversion_source,omitempty"`
	// Resource name of the geo target constant that represents an airport.
	GeoTargetAirport *string `protobuf:"bytes,116,opt,name=geo_target_airport,json=geoTargetAirport,proto3,oneof" json:"geo_target_airport,omitempty"`
	// Resource name of the geo target constant that represents a canton.
	GeoTargetCanton *string `protobuf:"bytes,117,opt,name=geo_target_canton,json=geoTargetCanton,proto3,oneof" json:"geo_target_canton,omitempty"`
	// Resource name of the geo target constant that represents a city.
	GeoTargetCity *string `protobuf:"bytes,118,opt,name=geo_target_city,json=geoTargetCity,proto3,oneof" json:"geo_target_city,omitempty"`
	// Resource name of the geo target constant that represents a country.
	GeoTargetCountry *string `protobuf:"bytes,119,opt,name=geo_target_country,json=geoTargetCountry,proto3,oneof" json:"geo_target_country,omitempty"`
	// Resource name of the geo target constant that represents a county.
	GeoTargetCounty *string `protobuf:"bytes,120,opt,name=geo_target_county,json=geoTargetCounty,proto3,oneof" json:"geo_target_county,omitempty"`
	// Resource name of the geo target constant that represents a district.
	GeoTargetDistrict *string `protobuf:"bytes,121,opt,name=geo_target_district,json=geoTargetDistrict,proto3,oneof" json:"geo_target_district,omitempty"`
	// Resource name of the geo target constant that represents a metro.
	GeoTargetMetro *string `protobuf:"bytes,122,opt,name=geo_target_metro,json=geoTargetMetro,proto3,oneof" json:"geo_target_metro,omitempty"`
	// Resource name of the geo target constant that represents the most
	// specific location.
	GeoTargetMostSpecificLocation *string `protobuf:"bytes,123,opt,name=geo_target_most_specific_location,json=geoTargetMostSpecificLocation,proto3,oneof" json:"geo_target_most_specific_location,omitempty"`
	// Resource name of the geo target constant that represents a postal code.
	GeoTargetPostalCode *string `protobuf:"bytes,124,opt,name=geo_target_postal_code,json=geoTargetPostalCode,proto3,oneof" json:"geo_target_postal_code,omitempty"`
	// Resource name of the geo target constant that represents a province.
	GeoTargetProvince *string `protobuf:"bytes,125,opt,name=geo_target_province,json=geoTargetProvince,proto3,oneof" json:"geo_target_province,omitempty"`
	// Resource name of the geo target constant that represents a region.
	GeoTargetRegion *string `protobuf:"bytes,126,opt,name=geo_target_region,json=geoTargetRegion,proto3,oneof" json:"geo_target_region,omitempty"`
	// Resource name of the geo target constant that represents a state.
	GeoTargetState *string `protobuf:"bytes,127,opt,name=geo_target_state,json=geoTargetState,proto3,oneof" json:"geo_target_state,omitempty"`
	// Hotel booking window in days.
	HotelBookingWindowDays *int64 `protobuf:"varint,135,opt,name=hotel_booking_window_days,json=hotelBookingWindowDays,proto3,oneof" json:"hotel_booking_window_days,omitempty"`
	// Hotel center ID.
	HotelCenterId *int64 `protobuf:"varint,80,opt,name=hotel_center_id,json=hotelCenterId,proto3,oneof" json:"hotel_center_id,omitempty"`
	// Hotel check-in date. Formatted as yyyy-MM-dd.
	HotelCheckInDate *string `protobuf:"bytes,81,opt,name=hotel_check_in_date,json=hotelCheckInDate,proto3,oneof" json:"hotel_check_in_date,omitempty"`
	// Hotel check-in day of week.
	HotelCheckInDayOfWeek enums.DayOfWeekEnum_DayOfWeek `protobuf:"varint,9,opt,name=hotel_check_in_day_of_week,json=hotelCheckInDayOfWeek,proto3,enum=google.ads.googleads.v6.enums.DayOfWeekEnum_DayOfWeek" json:"hotel_check_in_day_of_week,omitempty"`
	// Hotel city.
	HotelCity *string `protobuf:"bytes,82,opt,name=hotel_city,json=hotelCity,proto3,oneof" json:"hotel_city,omitempty"`
	// Hotel class.
	HotelClass *int32 `protobuf:"varint,83,opt,name=hotel_class,json=hotelClass,proto3,oneof" json:"hotel_class,omitempty"`
	// Hotel country.
	HotelCountry *string `protobuf:"bytes,84,opt,name=hotel_country,json=hotelCountry,proto3,oneof" json:"hotel_country,omitempty"`
	// Hotel date selection type.
	HotelDateSelectionType enums.HotelDateSelectionTypeEnum_HotelDateSelectionType `protobuf:"varint,13,opt,name=hotel_date_selection_type,json=hotelDateSelectionType,proto3,enum=google.ads.googleads.v6.enums.HotelDateSelectionTypeEnum_HotelDateSelectionType" json:"hotel_date_selection_type,omitempty"`
	// Hotel length of stay.
	HotelLengthOfStay *int32 `protobuf:"varint,85,opt,name=hotel_length_of_stay,json=hotelLengthOfStay,proto3,oneof" json:"hotel_length_of_stay,omitempty"`
	// Hotel rate rule ID.
	HotelRateRuleId *string `protobuf:"bytes,86,opt,name=hotel_rate_rule_id,json=hotelRateRuleId,proto3,oneof" json:"hotel_rate_rule_id,omitempty"`
	// Hotel rate type.
	HotelRateType enums.HotelRateTypeEnum_HotelRateType `protobuf:"varint,74,opt,name=hotel_rate_type,json=hotelRateType,proto3,enum=google.ads.googleads.v6.enums.HotelRateTypeEnum_HotelRateType" json:"hotel_rate_type,omitempty"`
	// Hotel price bucket.
	HotelPriceBucket enums.HotelPriceBucketEnum_HotelPriceBucket `protobuf:"varint,78,opt,name=hotel_price_bucket,json=hotelPriceBucket,proto3,enum=google.ads.googleads.v6.enums.HotelPriceBucketEnum_HotelPriceBucket" json:"hotel_price_bucket,omitempty"`
	// Hotel state.
	HotelState *string `protobuf:"bytes,87,opt,name=hotel_state,json=hotelState,proto3,oneof" json:"hotel_state,omitempty"`
	// Hour of day as a number between 0 and 23, inclusive.
	Hour *int32 `protobuf:"varint,88,opt,name=hour,proto3,oneof" json:"hour,omitempty"`
	// Only used with feed item metrics.
	// Indicates whether the interaction metrics occurred on the feed item itself
	// or a different extension or ad unit.
	InteractionOnThisExtension *bool `protobuf:"varint,89,opt,name=interaction_on_this_extension,json=interactionOnThisExtension,proto3,oneof" json:"interaction_on_this_extension,omitempty"`
	// Keyword criterion.
	Keyword *Keyword `protobuf:"bytes,61,opt,name=keyword,proto3" json:"keyword,omitempty"`
	// Month as represented by the date of the first day of a month. Formatted as
	// yyyy-MM-dd.
	Month *string `protobuf:"bytes,90,opt,name=month,proto3,oneof" json:"month,omitempty"`
	// Month of the year, e.g., January.
	MonthOfYear enums.MonthOfYearEnum_MonthOfYear `protobuf:"varint,18,opt,name=month_of_year,json=monthOfYear,proto3,enum=google.ads.googleads.v6.enums.MonthOfYearEnum_MonthOfYear" json:"month_of_year,omitempty"`
	// Partner hotel ID.
	PartnerHotelId *string `protobuf:"bytes,91,opt,name=partner_hotel_id,json=partnerHotelId,proto3,oneof" json:"partner_hotel_id,omitempty"`
	// Placeholder type. This is only used with feed item metrics.
	PlaceholderType enums.PlaceholderTypeEnum_PlaceholderType `protobuf:"varint,20,opt,name=placeholder_type,json=placeholderType,proto3,enum=google.ads.googleads.v6.enums.PlaceholderTypeEnum_PlaceholderType" json:"placeholder_type,omitempty"`
	// Aggregator ID of the product.
	ProductAggregatorId *int64 `protobuf:"varint,132,opt,name=product_aggregator_id,json=productAggregatorId,proto3,oneof" json:"product_aggregator_id,omitempty"`
	// Bidding category (level 1) of the product.
	ProductBiddingCategoryLevel1 *string `protobuf:"bytes,92,opt,name=product_bidding_category_level1,json=productBiddingCategoryLevel1,proto3,oneof" json:"product_bidding_category_level1,omitempty"`
	// Bidding category (level 2) of the product.
	ProductBiddingCategoryLevel2 *string `protobuf:"bytes,93,opt,name=product_bidding_category_level2,json=productBiddingCategoryLevel2,proto3,oneof" json:"product_bidding_category_level2,omitempty"`
	// Bidding category (level 3) of the product.
	ProductBiddingCategoryLevel3 *string `protobuf:"bytes,94,opt,name=product_bidding_category_level3,json=productBiddingCategoryLevel3,proto3,oneof" json:"product_bidding_category_level3,omitempty"`
	// Bidding category (level 4) of the product.
	ProductBiddingCategoryLevel4 *string `protobuf:"bytes,95,opt,name=product_bidding_category_level4,json=productBiddingCategoryLevel4,proto3,oneof" json:"product_bidding_category_level4,omitempty"`
	// Bidding category (level 5) of the product.
	ProductBiddingCategoryLevel5 *string `protobuf:"bytes,96,opt,name=product_bidding_category_level5,json=productBiddingCategoryLevel5,proto3,oneof" json:"product_bidding_category_level5,omitempty"`
	// Brand of the product.
	ProductBrand *string `protobuf:"bytes,97,opt,name=product_brand,json=productBrand,proto3,oneof" json:"product_brand,omitempty"`
	// Channel of the product.
	ProductChannel enums.ProductChannelEnum_ProductChannel `protobuf:"varint,30,opt,name=product_channel,json=productChannel,proto3,enum=google.ads.googleads.v6.enums.ProductChannelEnum_ProductChannel" json:"product_channel,omitempty"`
	// Channel exclusivity of the product.
	ProductChannelExclusivity enums.ProductChannelExclusivityEnum_ProductChannelExclusivity `protobuf:"varint,31,opt,name=product_channel_exclusivity,json=productChannelExclusivity,proto3,enum=google.ads.googleads.v6.enums.ProductChannelExclusivityEnum_ProductChannelExclusivity" json:"product_channel_exclusivity,omitempty"`
	// Condition of the product.
	ProductCondition enums.ProductConditionEnum_ProductCondition `protobuf:"varint,32,opt,name=product_condition,json=productCondition,proto3,enum=google.ads.googleads.v6.enums.ProductConditionEnum_ProductCondition" json:"product_condition,omitempty"`
	// Resource name of the geo target constant for the country of sale of the
	// product.
	ProductCountry *string `protobuf:"bytes,98,opt,name=product_country,json=productCountry,proto3,oneof" json:"product_country,omitempty"`
	// Custom attribute 0 of the product.
	ProductCustomAttribute0 *string `protobuf:"bytes,99,opt,name=product_custom_attribute0,json=productCustomAttribute0,proto3,oneof" json:"product_custom_attribute0,omitempty"`
	// Custom attribute 1 of the product.
	ProductCustomAttribute1 *string `protobuf:"bytes,100,opt,name=product_custom_attribute1,json=productCustomAttribute1,proto3,oneof" json:"product_custom_attribute1,omitempty"`
	// Custom attribute 2 of the product.
	ProductCustomAttribute2 *string `protobuf:"bytes,101,opt,name=product_custom_attribute2,json=productCustomAttribute2,proto3,oneof" json:"product_custom_attribute2,omitempty"`
	// Custom attribute 3 of the product.
	ProductCustomAttribute3 *string `protobuf:"bytes,102,opt,name=product_custom_attribute3,json=productCustomAttribute3,proto3,oneof" json:"product_custom_attribute3,omitempty"`
	// Custom attribute 4 of the product.
	ProductCustomAttribute4 *string `protobuf:"bytes,103,opt,name=product_custom_attribute4,json=productCustomAttribute4,proto3,oneof" json:"product_custom_attribute4,omitempty"`
	// Item ID of the product.
	ProductItemId *string `protobuf:"bytes,104,opt,name=product_item_id,json=productItemId,proto3,oneof" json:"product_item_id,omitempty"`
	// Resource name of the language constant for the language of the product.
	ProductLanguage *string `protobuf:"bytes,105,opt,name=product_language,json=productLanguage,proto3,oneof" json:"product_language,omitempty"`
	// Merchant ID of the product.
	ProductMerchantId *int64 `protobuf:"varint,133,opt,name=product_merchant_id,json=productMerchantId,proto3,oneof" json:"product_merchant_id,omitempty"`
	// Store ID of the product.
	ProductStoreId *string `protobuf:"bytes,106,opt,name=product_store_id,json=productStoreId,proto3,oneof" json:"product_store_id,omitempty"`
	// Title of the product.
	ProductTitle *string `protobuf:"bytes,107,opt,name=product_title,json=productTitle,proto3,oneof" json:"product_title,omitempty"`
	// Type (level 1) of the product.
	ProductTypeL1 *string `protobuf:"bytes,108,opt,name=product_type_l1,json=productTypeL1,proto3,oneof" json:"product_type_l1,omitempty"`
	// Type (level 2) of the product.
	ProductTypeL2 *string `protobuf:"bytes,109,opt,name=product_type_l2,json=productTypeL2,proto3,oneof" json:"product_type_l2,omitempty"`
	// Type (level 3) of the product.
	ProductTypeL3 *string `protobuf:"bytes,110,opt,name=product_type_l3,json=productTypeL3,proto3,oneof" json:"product_type_l3,omitempty"`
	// Type (level 4) of the product.
	ProductTypeL4 *string `protobuf:"bytes,111,opt,name=product_type_l4,json=productTypeL4,proto3,oneof" json:"product_type_l4,omitempty"`
	// Type (level 5) of the product.
	ProductTypeL5 *string `protobuf:"bytes,112,opt,name=product_type_l5,json=productTypeL5,proto3,oneof" json:"product_type_l5,omitempty"`
	// Quarter as represented by the date of the first day of a quarter.
	// Uses the calendar year for quarters, e.g., the second quarter of 2018
	// starts on 2018-04-01. Formatted as yyyy-MM-dd.
	Quarter *string `protobuf:"bytes,128,opt,name=quarter,proto3,oneof" json:"quarter,omitempty"`
	// Type of the search engine results page.
	SearchEngineResultsPageType enums.SearchEngineResultsPageTypeEnum_SearchEngineResultsPageType `protobuf:"varint,70,opt,name=search_engine_results_page_type,json=searchEngineResultsPageType,proto3,enum=google.ads.googleads.v6.enums.SearchEngineResultsPageTypeEnum_SearchEngineResultsPageType" json:"search_engine_results_page_type,omitempty"`
	// Match type of the keyword that triggered the ad, including variants.
	SearchTermMatchType enums.SearchTermMatchTypeEnum_SearchTermMatchType `protobuf:"varint,22,opt,name=search_term_match_type,json=searchTermMatchType,proto3,enum=google.ads.googleads.v6.enums.SearchTermMatchTypeEnum_SearchTermMatchType" json:"search_term_match_type,omitempty"`
	// Position of the ad.
	Slot enums.SlotEnum_Slot `protobuf:"varint,23,opt,name=slot,proto3,enum=google.ads.googleads.v6.enums.SlotEnum_Slot" json:"slot,omitempty"`
	// Resource name of the ad group criterion that represents webpage criterion.
	Webpage *string `protobuf:"bytes,129,opt,name=webpage,proto3,oneof" json:"webpage,omitempty"`
	// Week as defined as Monday through Sunday, and represented by the date of
	// Monday. Formatted as yyyy-MM-dd.
	Week *string `protobuf:"bytes,130,opt,name=week,proto3,oneof" json:"week,omitempty"`
	// Year, formatted as yyyy.
	Year *int32 `protobuf:"varint,131,opt,name=year,proto3,oneof" json:"year,omitempty"`
}

func (x *Segments) Reset() {
	*x = Segments{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_segments_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Segments) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Segments) ProtoMessage() {}

func (x *Segments) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_segments_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Segments.ProtoReflect.Descriptor instead.
func (*Segments) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_segments_proto_rawDescGZIP(), []int{0}
}

func (x *Segments) GetAdDestinationType() enums.AdDestinationTypeEnum_AdDestinationType {
	if x != nil {
		return x.AdDestinationType
	}
	return enums.AdDestinationTypeEnum_UNSPECIFIED
}

func (x *Segments) GetAdNetworkType() enums.AdNetworkTypeEnum_AdNetworkType {
	if x != nil {
		return x.AdNetworkType
	}
	return enums.AdNetworkTypeEnum_UNSPECIFIED
}

func (x *Segments) GetBudgetCampaignAssociationStatus() *BudgetCampaignAssociationStatus {
	if x != nil {
		return x.BudgetCampaignAssociationStatus
	}
	return nil
}

func (x *Segments) GetClickType() enums.ClickTypeEnum_ClickType {
	if x != nil {
		return x.ClickType
	}
	return enums.ClickTypeEnum_UNSPECIFIED
}

func (x *Segments) GetConversionAction() string {
	if x != nil && x.ConversionAction != nil {
		return *x.ConversionAction
	}
	return ""
}

func (x *Segments) GetConversionActionCategory() enums.ConversionActionCategoryEnum_ConversionActionCategory {
	if x != nil {
		return x.ConversionActionCategory
	}
	return enums.ConversionActionCategoryEnum_UNSPECIFIED
}

func (x *Segments) GetConversionActionName() string {
	if x != nil && x.ConversionActionName != nil {
		return *x.ConversionActionName
	}
	return ""
}

func (x *Segments) GetConversionAdjustment() bool {
	if x != nil && x.ConversionAdjustment != nil {
		return *x.ConversionAdjustment
	}
	return false
}

func (x *Segments) GetConversionAttributionEventType() enums.ConversionAttributionEventTypeEnum_ConversionAttributionEventType {
	if x != nil {
		return x.ConversionAttributionEventType
	}
	return enums.ConversionAttributionEventTypeEnum_UNSPECIFIED
}

func (x *Segments) GetConversionLagBucket() enums.ConversionLagBucketEnum_ConversionLagBucket {
	if x != nil {
		return x.ConversionLagBucket
	}
	return enums.ConversionLagBucketEnum_UNSPECIFIED
}

func (x *Segments) GetConversionOrAdjustmentLagBucket() enums.ConversionOrAdjustmentLagBucketEnum_ConversionOrAdjustmentLagBucket {
	if x != nil {
		return x.ConversionOrAdjustmentLagBucket
	}
	return enums.ConversionOrAdjustmentLagBucketEnum_UNSPECIFIED
}

func (x *Segments) GetDate() string {
	if x != nil && x.Date != nil {
		return *x.Date
	}
	return ""
}

func (x *Segments) GetDayOfWeek() enums.DayOfWeekEnum_DayOfWeek {
	if x != nil {
		return x.DayOfWeek
	}
	return enums.DayOfWeekEnum_UNSPECIFIED
}

func (x *Segments) GetDevice() enums.DeviceEnum_Device {
	if x != nil {
		return x.Device
	}
	return enums.DeviceEnum_UNSPECIFIED
}

func (x *Segments) GetExternalConversionSource() enums.ExternalConversionSourceEnum_ExternalConversionSource {
	if x != nil {
		return x.ExternalConversionSource
	}
	return enums.ExternalConversionSourceEnum_UNSPECIFIED
}

func (x *Segments) GetGeoTargetAirport() string {
	if x != nil && x.GeoTargetAirport != nil {
		return *x.GeoTargetAirport
	}
	return ""
}

func (x *Segments) GetGeoTargetCanton() string {
	if x != nil && x.GeoTargetCanton != nil {
		return *x.GeoTargetCanton
	}
	return ""
}

func (x *Segments) GetGeoTargetCity() string {
	if x != nil && x.GeoTargetCity != nil {
		return *x.GeoTargetCity
	}
	return ""
}

func (x *Segments) GetGeoTargetCountry() string {
	if x != nil && x.GeoTargetCountry != nil {
		return *x.GeoTargetCountry
	}
	return ""
}

func (x *Segments) GetGeoTargetCounty() string {
	if x != nil && x.GeoTargetCounty != nil {
		return *x.GeoTargetCounty
	}
	return ""
}

func (x *Segments) GetGeoTargetDistrict() string {
	if x != nil && x.GeoTargetDistrict != nil {
		return *x.GeoTargetDistrict
	}
	return ""
}

func (x *Segments) GetGeoTargetMetro() string {
	if x != nil && x.GeoTargetMetro != nil {
		return *x.GeoTargetMetro
	}
	return ""
}

func (x *Segments) GetGeoTargetMostSpecificLocation() string {
	if x != nil && x.GeoTargetMostSpecificLocation != nil {
		return *x.GeoTargetMostSpecificLocation
	}
	return ""
}

func (x *Segments) GetGeoTargetPostalCode() string {
	if x != nil && x.GeoTargetPostalCode != nil {
		return *x.GeoTargetPostalCode
	}
	return ""
}

func (x *Segments) GetGeoTargetProvince() string {
	if x != nil && x.GeoTargetProvince != nil {
		return *x.GeoTargetProvince
	}
	return ""
}

func (x *Segments) GetGeoTargetRegion() string {
	if x != nil && x.GeoTargetRegion != nil {
		return *x.GeoTargetRegion
	}
	return ""
}

func (x *Segments) GetGeoTargetState() string {
	if x != nil && x.GeoTargetState != nil {
		return *x.GeoTargetState
	}
	return ""
}

func (x *Segments) GetHotelBookingWindowDays() int64 {
	if x != nil && x.HotelBookingWindowDays != nil {
		return *x.HotelBookingWindowDays
	}
	return 0
}

func (x *Segments) GetHotelCenterId() int64 {
	if x != nil && x.HotelCenterId != nil {
		return *x.HotelCenterId
	}
	return 0
}

func (x *Segments) GetHotelCheckInDate() string {
	if x != nil && x.HotelCheckInDate != nil {
		return *x.HotelCheckInDate
	}
	return ""
}

func (x *Segments) GetHotelCheckInDayOfWeek() enums.DayOfWeekEnum_DayOfWeek {
	if x != nil {
		return x.HotelCheckInDayOfWeek
	}
	return enums.DayOfWeekEnum_UNSPECIFIED
}

func (x *Segments) GetHotelCity() string {
	if x != nil && x.HotelCity != nil {
		return *x.HotelCity
	}
	return ""
}

func (x *Segments) GetHotelClass() int32 {
	if x != nil && x.HotelClass != nil {
		return *x.HotelClass
	}
	return 0
}

func (x *Segments) GetHotelCountry() string {
	if x != nil && x.HotelCountry != nil {
		return *x.HotelCountry
	}
	return ""
}

func (x *Segments) GetHotelDateSelectionType() enums.HotelDateSelectionTypeEnum_HotelDateSelectionType {
	if x != nil {
		return x.HotelDateSelectionType
	}
	return enums.HotelDateSelectionTypeEnum_UNSPECIFIED
}

func (x *Segments) GetHotelLengthOfStay() int32 {
	if x != nil && x.HotelLengthOfStay != nil {
		return *x.HotelLengthOfStay
	}
	return 0
}

func (x *Segments) GetHotelRateRuleId() string {
	if x != nil && x.HotelRateRuleId != nil {
		return *x.HotelRateRuleId
	}
	return ""
}

func (x *Segments) GetHotelRateType() enums.HotelRateTypeEnum_HotelRateType {
	if x != nil {
		return x.HotelRateType
	}
	return enums.HotelRateTypeEnum_UNSPECIFIED
}

func (x *Segments) GetHotelPriceBucket() enums.HotelPriceBucketEnum_HotelPriceBucket {
	if x != nil {
		return x.HotelPriceBucket
	}
	return enums.HotelPriceBucketEnum_UNSPECIFIED
}

func (x *Segments) GetHotelState() string {
	if x != nil && x.HotelState != nil {
		return *x.HotelState
	}
	return ""
}

func (x *Segments) GetHour() int32 {
	if x != nil && x.Hour != nil {
		return *x.Hour
	}
	return 0
}

func (x *Segments) GetInteractionOnThisExtension() bool {
	if x != nil && x.InteractionOnThisExtension != nil {
		return *x.InteractionOnThisExtension
	}
	return false
}

func (x *Segments) GetKeyword() *Keyword {
	if x != nil {
		return x.Keyword
	}
	return nil
}

func (x *Segments) GetMonth() string {
	if x != nil && x.Month != nil {
		return *x.Month
	}
	return ""
}

func (x *Segments) GetMonthOfYear() enums.MonthOfYearEnum_MonthOfYear {
	if x != nil {
		return x.MonthOfYear
	}
	return enums.MonthOfYearEnum_UNSPECIFIED
}

func (x *Segments) GetPartnerHotelId() string {
	if x != nil && x.PartnerHotelId != nil {
		return *x.PartnerHotelId
	}
	return ""
}

func (x *Segments) GetPlaceholderType() enums.PlaceholderTypeEnum_PlaceholderType {
	if x != nil {
		return x.PlaceholderType
	}
	return enums.PlaceholderTypeEnum_UNSPECIFIED
}

func (x *Segments) GetProductAggregatorId() int64 {
	if x != nil && x.ProductAggregatorId != nil {
		return *x.ProductAggregatorId
	}
	return 0
}

func (x *Segments) GetProductBiddingCategoryLevel1() string {
	if x != nil && x.ProductBiddingCategoryLevel1 != nil {
		return *x.ProductBiddingCategoryLevel1
	}
	return ""
}

func (x *Segments) GetProductBiddingCategoryLevel2() string {
	if x != nil && x.ProductBiddingCategoryLevel2 != nil {
		return *x.ProductBiddingCategoryLevel2
	}
	return ""
}

func (x *Segments) GetProductBiddingCategoryLevel3() string {
	if x != nil && x.ProductBiddingCategoryLevel3 != nil {
		return *x.ProductBiddingCategoryLevel3
	}
	return ""
}

func (x *Segments) GetProductBiddingCategoryLevel4() string {
	if x != nil && x.ProductBiddingCategoryLevel4 != nil {
		return *x.ProductBiddingCategoryLevel4
	}
	return ""
}

func (x *Segments) GetProductBiddingCategoryLevel5() string {
	if x != nil && x.ProductBiddingCategoryLevel5 != nil {
		return *x.ProductBiddingCategoryLevel5
	}
	return ""
}

func (x *Segments) GetProductBrand() string {
	if x != nil && x.ProductBrand != nil {
		return *x.ProductBrand
	}
	return ""
}

func (x *Segments) GetProductChannel() enums.ProductChannelEnum_ProductChannel {
	if x != nil {
		return x.ProductChannel
	}
	return enums.ProductChannelEnum_UNSPECIFIED
}

func (x *Segments) GetProductChannelExclusivity() enums.ProductChannelExclusivityEnum_ProductChannelExclusivity {
	if x != nil {
		return x.ProductChannelExclusivity
	}
	return enums.ProductChannelExclusivityEnum_UNSPECIFIED
}

func (x *Segments) GetProductCondition() enums.ProductConditionEnum_ProductCondition {
	if x != nil {
		return x.ProductCondition
	}
	return enums.ProductConditionEnum_UNSPECIFIED
}

func (x *Segments) GetProductCountry() string {
	if x != nil && x.ProductCountry != nil {
		return *x.ProductCountry
	}
	return ""
}

func (x *Segments) GetProductCustomAttribute0() string {
	if x != nil && x.ProductCustomAttribute0 != nil {
		return *x.ProductCustomAttribute0
	}
	return ""
}

func (x *Segments) GetProductCustomAttribute1() string {
	if x != nil && x.ProductCustomAttribute1 != nil {
		return *x.ProductCustomAttribute1
	}
	return ""
}

func (x *Segments) GetProductCustomAttribute2() string {
	if x != nil && x.ProductCustomAttribute2 != nil {
		return *x.ProductCustomAttribute2
	}
	return ""
}

func (x *Segments) GetProductCustomAttribute3() string {
	if x != nil && x.ProductCustomAttribute3 != nil {
		return *x.ProductCustomAttribute3
	}
	return ""
}

func (x *Segments) GetProductCustomAttribute4() string {
	if x != nil && x.ProductCustomAttribute4 != nil {
		return *x.ProductCustomAttribute4
	}
	return ""
}

func (x *Segments) GetProductItemId() string {
	if x != nil && x.ProductItemId != nil {
		return *x.ProductItemId
	}
	return ""
}

func (x *Segments) GetProductLanguage() string {
	if x != nil && x.ProductLanguage != nil {
		return *x.ProductLanguage
	}
	return ""
}

func (x *Segments) GetProductMerchantId() int64 {
	if x != nil && x.ProductMerchantId != nil {
		return *x.ProductMerchantId
	}
	return 0
}

func (x *Segments) GetProductStoreId() string {
	if x != nil && x.ProductStoreId != nil {
		return *x.ProductStoreId
	}
	return ""
}

func (x *Segments) GetProductTitle() string {
	if x != nil && x.ProductTitle != nil {
		return *x.ProductTitle
	}
	return ""
}

func (x *Segments) GetProductTypeL1() string {
	if x != nil && x.ProductTypeL1 != nil {
		return *x.ProductTypeL1
	}
	return ""
}

func (x *Segments) GetProductTypeL2() string {
	if x != nil && x.ProductTypeL2 != nil {
		return *x.ProductTypeL2
	}
	return ""
}

func (x *Segments) GetProductTypeL3() string {
	if x != nil && x.ProductTypeL3 != nil {
		return *x.ProductTypeL3
	}
	return ""
}

func (x *Segments) GetProductTypeL4() string {
	if x != nil && x.ProductTypeL4 != nil {
		return *x.ProductTypeL4
	}
	return ""
}

func (x *Segments) GetProductTypeL5() string {
	if x != nil && x.ProductTypeL5 != nil {
		return *x.ProductTypeL5
	}
	return ""
}

func (x *Segments) GetQuarter() string {
	if x != nil && x.Quarter != nil {
		return *x.Quarter
	}
	return ""
}

func (x *Segments) GetSearchEngineResultsPageType() enums.SearchEngineResultsPageTypeEnum_SearchEngineResultsPageType {
	if x != nil {
		return x.SearchEngineResultsPageType
	}
	return enums.SearchEngineResultsPageTypeEnum_UNSPECIFIED
}

func (x *Segments) GetSearchTermMatchType() enums.SearchTermMatchTypeEnum_SearchTermMatchType {
	if x != nil {
		return x.SearchTermMatchType
	}
	return enums.SearchTermMatchTypeEnum_UNSPECIFIED
}

func (x *Segments) GetSlot() enums.SlotEnum_Slot {
	if x != nil {
		return x.Slot
	}
	return enums.SlotEnum_UNSPECIFIED
}

func (x *Segments) GetWebpage() string {
	if x != nil && x.Webpage != nil {
		return *x.Webpage
	}
	return ""
}

func (x *Segments) GetWeek() string {
	if x != nil && x.Week != nil {
		return *x.Week
	}
	return ""
}

func (x *Segments) GetYear() int32 {
	if x != nil && x.Year != nil {
		return *x.Year
	}
	return 0
}

// A Keyword criterion segment.
type Keyword struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The AdGroupCriterion resource name.
	AdGroupCriterion *string `protobuf:"bytes,3,opt,name=ad_group_criterion,json=adGroupCriterion,proto3,oneof" json:"ad_group_criterion,omitempty"`
	// Keyword info.
	Info *KeywordInfo `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
}

func (x *Keyword) Reset() {
	*x = Keyword{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_segments_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Keyword) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Keyword) ProtoMessage() {}

func (x *Keyword) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_segments_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Keyword.ProtoReflect.Descriptor instead.
func (*Keyword) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_segments_proto_rawDescGZIP(), []int{1}
}

func (x *Keyword) GetAdGroupCriterion() string {
	if x != nil && x.AdGroupCriterion != nil {
		return *x.AdGroupCriterion
	}
	return ""
}

func (x *Keyword) GetInfo() *KeywordInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

// A BudgetCampaignAssociationStatus segment.
type BudgetCampaignAssociationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The campaign resource name.
	Campaign *string `protobuf:"bytes,1,opt,name=campaign,proto3,oneof" json:"campaign,omitempty"`
	// Budget campaign association status.
	Status enums.BudgetCampaignAssociationStatusEnum_BudgetCampaignAssociationStatus `protobuf:"varint,2,opt,name=status,proto3,enum=google.ads.googleads.v6.enums.BudgetCampaignAssociationStatusEnum_BudgetCampaignAssociationStatus" json:"status,omitempty"`
}

func (x *BudgetCampaignAssociationStatus) Reset() {
	*x = BudgetCampaignAssociationStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_segments_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BudgetCampaignAssociationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BudgetCampaignAssociationStatus) ProtoMessage() {}

func (x *BudgetCampaignAssociationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_segments_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BudgetCampaignAssociationStatus.ProtoReflect.Descriptor instead.
func (*BudgetCampaignAssociationStatus) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_segments_proto_rawDescGZIP(), []int{2}
}

func (x *BudgetCampaignAssociationStatus) GetCampaign() string {
	if x != nil && x.Campaign != nil {
		return *x.Campaign
	}
	return ""
}

func (x *BudgetCampaignAssociationStatus) GetStatus() enums.BudgetCampaignAssociationStatusEnum_BudgetCampaignAssociationStatus {
	if x != nil {
		return x.Status
	}
	return enums.BudgetCampaignAssociationStatusEnum_UNSPECIFIED
}

var File_google_ads_googleads_v6_common_segments_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v6_common_segments_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x1a,
	0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f,
	0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x64,
	0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36,
	0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x46, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x62, 0x75, 0x64, 0x67,
	0x65, 0x74, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x61, 0x73, 0x73, 0x6f,
	0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x6f, 0x72, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c,
	0x61, 0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x64,
	0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x68, 0x6f, 0x74, 0x65,
	0x6c, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x68, 0x6f, 0x74, 0x65, 0x6c,
	0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x5f, 0x6f, 0x66,
	0x5f, 0x79, 0x65, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36,
	0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x43,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x73,
	0x6c, 0x6f, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xdd, 0x36, 0x0a, 0x08, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x77, 0x0a, 0x13, 0x61, 0x64, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x88, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x64,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x41, 0x64, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x11, 0x61, 0x64, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x66, 0x0a, 0x0f, 0x61, 0x64, 0x5f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x41, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0d, 0x61, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x8d, 0x01, 0x0a, 0x22, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x5f, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x86, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x41, 0x73,
	0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x1f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x41,
	0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x55, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x1a,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e,
	0x75, 0x6d, 0x2e, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x63, 0x6c,
	0x69, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x71, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x92, 0x01, 0x0a, 0x1a, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x35, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x54,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x52, 0x18, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x39,
	0x0a, 0x16, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x72, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01,
	0x52, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x15, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x73, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x88, 0x01, 0x01, 0x12, 0xab, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e,
	0x75, 0x6d, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x1e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x7e, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x6c, 0x61, 0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x32, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x67, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x67, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x13, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x67, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x12, 0xb0, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x6f, 0x72, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c,
	0x61, 0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x33, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x41, 0x64, 0x6a, 0x75,
	0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x67, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x72,
	0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x67, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x52, 0x1f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4f,
	0x72, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x67, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x4f, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x03, 0x52, 0x04, 0x64, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x56, 0x0a,
	0x0b, 0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x52, 0x09, 0x64, 0x61, 0x79, 0x4f,
	0x66, 0x57, 0x65, 0x65, 0x6b, 0x12, 0x48, 0x0a, 0x06, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x06, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x92, 0x01, 0x0a, 0x1a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x37,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x75,
	0x6d, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x18, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x31, 0x0a, 0x12, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x61, 0x69, 0x72, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x74, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x04, 0x52, 0x10, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x69, 0x72,
	0x70, 0x6f, 0x72, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x11, 0x67, 0x65, 0x6f, 0x5f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x61, 0x6e, 0x74, 0x6f, 0x6e, 0x18, 0x75, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x05, 0x52, 0x0f, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43,
	0x61, 0x6e, 0x74, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x67, 0x65, 0x6f, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x69, 0x74, 0x79, 0x18, 0x76, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x06, 0x52, 0x0d, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x69,
	0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x77, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x07, 0x52, 0x10, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x11, 0x67, 0x65, 0x6f, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x79, 0x18, 0x78, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x08, 0x52, 0x0f, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x67, 0x65, 0x6f,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74,
	0x18, 0x79, 0x20, 0x01, 0x28, 0x09, 0x48, 0x09, 0x52, 0x11, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2d,
	0x0a, 0x10, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x6f, 0x18, 0x7a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0a, 0x52, 0x0e, 0x67, 0x65, 0x6f, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x6f, 0x88, 0x01, 0x01, 0x12, 0x4d, 0x0a,
	0x21, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x6f, 0x73, 0x74,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x7b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0b, 0x52, 0x1d, 0x67, 0x65, 0x6f, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x4d, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
	0x63, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x16,
	0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x61,
	0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x7c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0c, 0x52, 0x13,
	0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x43,
	0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x6e, 0x63, 0x65, 0x18, 0x7d, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x0d, 0x52, 0x11, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x11, 0x67,
	0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x18, 0x7e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0e, 0x52, 0x0f, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x10,
	0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x7f, 0x20, 0x01, 0x28, 0x09, 0x48, 0x0f, 0x52, 0x0e, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3f, 0x0a, 0x19, 0x68,
	0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x62, 0x6f, 0x6f, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x87, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x10, 0x52, 0x16, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x42, 0x6f, 0x6f, 0x6b, 0x69, 0x6e, 0x67, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x44, 0x61, 0x79, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f,
	0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x50, 0x20, 0x01, 0x28, 0x03, 0x48, 0x11, 0x52, 0x0d, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x43, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x13, 0x68, 0x6f, 0x74,
	0x65, 0x6c, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65,
	0x18, 0x51, 0x20, 0x01, 0x28, 0x09, 0x48, 0x12, 0x52, 0x10, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x49, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x71, 0x0a,
	0x1a, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x5f,
	0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x52, 0x15, 0x68, 0x6f, 0x74, 0x65, 0x6c,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x6e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b,
	0x12, 0x22, 0x0a, 0x0a, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x69, 0x74, 0x79, 0x18, 0x52,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x13, 0x52, 0x09, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x43, 0x69, 0x74,
	0x79, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x18, 0x53, 0x20, 0x01, 0x28, 0x05, 0x48, 0x14, 0x52, 0x0a, 0x68, 0x6f, 0x74,
	0x65, 0x6c, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x68, 0x6f,
	0x74, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x54, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x15, 0x52, 0x0c, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72,
	0x79, 0x88, 0x01, 0x01, 0x12, 0x8b, 0x01, 0x0a, 0x19, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x44, 0x61,
	0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x44, 0x61, 0x74, 0x65, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x16, 0x68, 0x6f, 0x74, 0x65,
	0x6c, 0x44, 0x61, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x34, 0x0a, 0x14, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x6c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x74, 0x61, 0x79, 0x18, 0x55, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x16, 0x52, 0x11, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x4f,
	0x66, 0x53, 0x74, 0x61, 0x79, 0x88, 0x01, 0x01, 0x12, 0x30, 0x0a, 0x12, 0x68, 0x6f, 0x74, 0x65,
	0x6c, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x56,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x17, 0x52, 0x0f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x52, 0x61, 0x74,
	0x65, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x66, 0x0a, 0x0f, 0x68, 0x6f,
	0x74, 0x65, 0x6c, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x4a, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x52, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x52, 0x61, 0x74, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0d, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x52, 0x61, 0x74, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x72, 0x0a, 0x12, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x70, 0x72, 0x69, 0x63,
	0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x4e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x48,
	0x6f, 0x74, 0x65, 0x6c, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x52, 0x10, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x50, 0x72, 0x69, 0x63, 0x65,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x57, 0x20, 0x01, 0x28, 0x09, 0x48, 0x18, 0x52, 0x0a, 0x68,
	0x6f, 0x74, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04,
	0x68, 0x6f, 0x75, 0x72, 0x18, 0x58, 0x20, 0x01, 0x28, 0x05, 0x48, 0x19, 0x52, 0x04, 0x68, 0x6f,
	0x75, 0x72, 0x88, 0x01, 0x01, 0x12, 0x46, 0x0a, 0x1d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x6e, 0x5f, 0x74, 0x68, 0x69, 0x73, 0x5f, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x59, 0x20, 0x01, 0x28, 0x08, 0x48, 0x1a, 0x52, 0x1a,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x6e, 0x54, 0x68, 0x69,
	0x73, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x41, 0x0a,
	0x07, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x3d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64,
	0x12, 0x19, 0x0a, 0x05, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x18, 0x5a, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x1b, 0x52, 0x05, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a, 0x0d, 0x6d,
	0x6f, 0x6e, 0x74, 0x68, 0x5f, 0x6f, 0x66, 0x5f, 0x79, 0x65, 0x61, 0x72, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x4f, 0x66, 0x59, 0x65, 0x61, 0x72, 0x45, 0x6e,
	0x75, 0x6d, 0x2e, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x4f, 0x66, 0x59, 0x65, 0x61, 0x72, 0x52, 0x0b,
	0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x4f, 0x66, 0x59, 0x65, 0x61, 0x72, 0x12, 0x2d, 0x0a, 0x10, 0x70,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18,
	0x5b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x1c, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x48, 0x6f, 0x74, 0x65, 0x6c, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x6d, 0x0a, 0x10, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x38, 0x0a, 0x15, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x84, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x1d, 0x52, 0x13, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x49, 0x64,
	0x88, 0x01, 0x01, 0x12, 0x4a, 0x0a, 0x1f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62,
	0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x31, 0x18, 0x5c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x1e, 0x52, 0x1c,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x31, 0x88, 0x01, 0x01, 0x12,
	0x4a, 0x0a, 0x1f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x32, 0x18, 0x5d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x1f, 0x52, 0x1c, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x32, 0x88, 0x01, 0x01, 0x12, 0x4a, 0x0a, 0x1f, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x33, 0x18, 0x5e,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x20, 0x52, 0x1c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42,
	0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x33, 0x88, 0x01, 0x01, 0x12, 0x4a, 0x0a, 0x1f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x34, 0x18, 0x5f, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x21, 0x52, 0x1c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x69, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x34,
	0x88, 0x01, 0x01, 0x12, 0x4a, 0x0a, 0x1f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62,
	0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x35, 0x18, 0x60, 0x20, 0x01, 0x28, 0x09, 0x48, 0x22, 0x52, 0x1c,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x35, 0x88, 0x01, 0x01, 0x12,
	0x28, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x18, 0x61, 0x20, 0x01, 0x28, 0x09, 0x48, 0x23, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x69, 0x0a, 0x0f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x1e, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x96, 0x01, 0x0a, 0x1b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x52, 0x19, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x71, 0x0a,
	0x11, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x72, 0x79, 0x18, 0x62, 0x20, 0x01, 0x28, 0x09, 0x48, 0x24, 0x52, 0x0e, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x3f,
	0x0a, 0x19, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x30, 0x18, 0x63, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x25, 0x52, 0x17, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x30, 0x88, 0x01, 0x01, 0x12,
	0x3f, 0x0a, 0x19, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x31, 0x18, 0x64, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x26, 0x52, 0x17, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x31, 0x88, 0x01, 0x01,
	0x12, 0x3f, 0x0a, 0x19, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x32, 0x18, 0x65, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x27, 0x52, 0x17, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x32, 0x88, 0x01,
	0x01, 0x12, 0x3f, 0x0a, 0x19, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x33, 0x18, 0x66,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x28, 0x52, 0x17, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x33, 0x88,
	0x01, 0x01, 0x12, 0x3f, 0x0a, 0x19, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x34, 0x18,
	0x67, 0x20, 0x01, 0x28, 0x09, 0x48, 0x29, 0x52, 0x17, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x34,
	0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x69,
	0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x68, 0x20, 0x01, 0x28, 0x09, 0x48, 0x2a, 0x52, 0x0d,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x88, 0x01, 0x01,
	0x12, 0x2e, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x18, 0x69, 0x20, 0x01, 0x28, 0x09, 0x48, 0x2b, 0x52, 0x0f, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x34, 0x0a, 0x13, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x85, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x2c,
	0x52, 0x11, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x6a, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x2d, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x6b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x2e, 0x52, 0x0c,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x6c, 0x31, 0x18, 0x6c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x2f, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x31, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x32, 0x18,
	0x6d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x30, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x4c, 0x32, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x33, 0x18, 0x6e, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x31, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x4c, 0x33, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x34, 0x18, 0x6f, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x32, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x34,
	0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x5f, 0x6c, 0x35, 0x18, 0x70, 0x20, 0x01, 0x28, 0x09, 0x48, 0x33, 0x52, 0x0d,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x35, 0x88, 0x01, 0x01,
	0x12, 0x1e, 0x0a, 0x07, 0x71, 0x75, 0x61, 0x72, 0x74, 0x65, 0x72, 0x18, 0x80, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x34, 0x52, 0x07, 0x71, 0x75, 0x61, 0x72, 0x74, 0x65, 0x72, 0x88, 0x01, 0x01,
	0x12, 0xa0, 0x01, 0x0a, 0x1f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x46, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x1b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x7f, 0x0a, 0x16, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x65,
	0x72, 0x6d, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x16, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x72, 0x6d, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x54, 0x65, 0x72, 0x6d, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x13, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x72, 0x6d, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x04, 0x73, 0x6c, 0x6f, 0x74, 0x18, 0x17, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x53, 0x6c, 0x6f, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x53, 0x6c, 0x6f, 0x74,
	0x52, 0x04, 0x73, 0x6c, 0x6f, 0x74, 0x12, 0x1e, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x70, 0x61, 0x67,
	0x65, 0x18, 0x81, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x35, 0x52, 0x07, 0x77, 0x65, 0x62, 0x70,
	0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x18, 0x0a, 0x04, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x82,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x36, 0x52, 0x04, 0x77, 0x65, 0x65, 0x6b, 0x88, 0x01, 0x01,
	0x12, 0x18, 0x0a, 0x04, 0x79, 0x65, 0x61, 0x72, 0x18, 0x83, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x37, 0x52, 0x04, 0x79, 0x65, 0x61, 0x72, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x19, 0x0a, 0x17, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x18, 0x0a, 0x16, 0x5f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x42, 0x15,
	0x0a, 0x13, 0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x69,
	0x72, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x61, 0x6e, 0x74, 0x6f, 0x6e, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x69, 0x74, 0x79, 0x42,
	0x15, 0x0a, 0x13, 0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x79, 0x42, 0x16, 0x0a, 0x14,
	0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x74,
	0x72, 0x69, 0x63, 0x74, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x6f, 0x42, 0x24, 0x0a, 0x22, 0x5f, 0x67, 0x65,
	0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x19, 0x0a, 0x17, 0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70,
	0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x67,
	0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x6e,
	0x63, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x67, 0x65, 0x6f,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x1c, 0x0a,
	0x1a, 0x5f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x62, 0x6f, 0x6f, 0x6b, 0x69, 0x6e, 0x67, 0x5f,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x42,
	0x16, 0x0a, 0x14, 0x5f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f,
	0x69, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x68, 0x6f, 0x74, 0x65,
	0x6c, 0x5f, 0x63, 0x69, 0x74, 0x79, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x68, 0x6f, 0x74, 0x65, 0x6c,
	0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x68, 0x6f, 0x74, 0x65, 0x6c,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x68, 0x6f, 0x74,
	0x65, 0x6c, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x74, 0x61,
	0x79, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x68, 0x6f, 0x74,
	0x65, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x68, 0x6f, 0x75,
	0x72, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6f, 0x6e, 0x5f, 0x74, 0x68, 0x69, 0x73, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x42, 0x13, 0x0a,
	0x11, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f,
	0x69, 0x64, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x61,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x42, 0x22, 0x0a, 0x20,
	0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x31,
	0x42, 0x22, 0x0a, 0x20, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62, 0x69, 0x64,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x32, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x33, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x34, 0x42, 0x22, 0x0a, 0x20,
	0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x35,
	0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62, 0x72, 0x61,
	0x6e, 0x64, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x30, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x31, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x32,
	0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x33, 0x42, 0x1c,
	0x0a, 0x1a, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x34, 0x42, 0x12, 0x0a, 0x10,
	0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64,
	0x42, 0x13, 0x0a, 0x11, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x5f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x42, 0x13, 0x0a,
	0x11, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x69, 0x64, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x31, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x32, 0x42, 0x12, 0x0a, 0x10,
	0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x33,
	0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x6c, 0x34, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x35, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x71, 0x75, 0x61,
	0x72, 0x74, 0x65, 0x72, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x77, 0x65, 0x62, 0x70, 0x61, 0x67, 0x65,
	0x42, 0x07, 0x0a, 0x05, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x79, 0x65,
	0x61, 0x72, 0x22, 0x94, 0x01, 0x0a, 0x07, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x31,
	0x0a, 0x12, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x10, 0x61, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x88, 0x01,
	0x01, 0x12, 0x3f, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x04, 0x69, 0x6e,
	0x66, 0x6f, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x22, 0xf3, 0x01, 0x0a, 0x1f, 0x42, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x41, 0x73, 0x73, 0x6f,
	0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x47, 0x0a,
	0x08, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x48, 0x00, 0x52, 0x08, 0x63, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x7a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36,
	0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x43, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x42, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42,
	0xe8, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x42, 0x0d, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xa2, 0x02, 0x03,
	0x47, 0x41, 0x41, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73,
	0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x36, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64,
	0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x36, 0x5c, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a,
	0x56, 0x36, 0x3a, 0x3a, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_ads_googleads_v6_common_segments_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v6_common_segments_proto_rawDescData = file_google_ads_googleads_v6_common_segments_proto_rawDesc
)

func file_google_ads_googleads_v6_common_segments_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v6_common_segments_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v6_common_segments_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v6_common_segments_proto_rawDescData)
	})
	return file_google_ads_googleads_v6_common_segments_proto_rawDescData
}

var file_google_ads_googleads_v6_common_segments_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_ads_googleads_v6_common_segments_proto_goTypes = []interface{}{
	(*Segments)(nil),                                                               // 0: google.ads.googleads.v6.common.Segments
	(*Keyword)(nil),                                                                // 1: google.ads.googleads.v6.common.Keyword
	(*BudgetCampaignAssociationStatus)(nil),                                        // 2: google.ads.googleads.v6.common.BudgetCampaignAssociationStatus
	(enums.AdDestinationTypeEnum_AdDestinationType)(0),                             // 3: google.ads.googleads.v6.enums.AdDestinationTypeEnum.AdDestinationType
	(enums.AdNetworkTypeEnum_AdNetworkType)(0),                                     // 4: google.ads.googleads.v6.enums.AdNetworkTypeEnum.AdNetworkType
	(enums.ClickTypeEnum_ClickType)(0),                                             // 5: google.ads.googleads.v6.enums.ClickTypeEnum.ClickType
	(enums.ConversionActionCategoryEnum_ConversionActionCategory)(0),               // 6: google.ads.googleads.v6.enums.ConversionActionCategoryEnum.ConversionActionCategory
	(enums.ConversionAttributionEventTypeEnum_ConversionAttributionEventType)(0),   // 7: google.ads.googleads.v6.enums.ConversionAttributionEventTypeEnum.ConversionAttributionEventType
	(enums.ConversionLagBucketEnum_ConversionLagBucket)(0),                         // 8: google.ads.googleads.v6.enums.ConversionLagBucketEnum.ConversionLagBucket
	(enums.ConversionOrAdjustmentLagBucketEnum_ConversionOrAdjustmentLagBucket)(0), // 9: google.ads.googleads.v6.enums.ConversionOrAdjustmentLagBucketEnum.ConversionOrAdjustmentLagBucket
	(enums.DayOfWeekEnum_DayOfWeek)(0),                                             // 10: google.ads.googleads.v6.enums.DayOfWeekEnum.DayOfWeek
	(enums.DeviceEnum_Device)(0),                                                   // 11: google.ads.googleads.v6.enums.DeviceEnum.Device
	(enums.ExternalConversionSourceEnum_ExternalConversionSource)(0),               // 12: google.ads.googleads.v6.enums.ExternalConversionSourceEnum.ExternalConversionSource
	(enums.HotelDateSelectionTypeEnum_HotelDateSelectionType)(0),                   // 13: google.ads.googleads.v6.enums.HotelDateSelectionTypeEnum.HotelDateSelectionType
	(enums.HotelRateTypeEnum_HotelRateType)(0),                                     // 14: google.ads.googleads.v6.enums.HotelRateTypeEnum.HotelRateType
	(enums.HotelPriceBucketEnum_HotelPriceBucket)(0),                               // 15: google.ads.googleads.v6.enums.HotelPriceBucketEnum.HotelPriceBucket
	(enums.MonthOfYearEnum_MonthOfYear)(0),                                         // 16: google.ads.googleads.v6.enums.MonthOfYearEnum.MonthOfYear
	(enums.PlaceholderTypeEnum_PlaceholderType)(0),                                 // 17: google.ads.googleads.v6.enums.PlaceholderTypeEnum.PlaceholderType
	(enums.ProductChannelEnum_ProductChannel)(0),                                   // 18: google.ads.googleads.v6.enums.ProductChannelEnum.ProductChannel
	(enums.ProductChannelExclusivityEnum_ProductChannelExclusivity)(0),             // 19: google.ads.googleads.v6.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity
	(enums.ProductConditionEnum_ProductCondition)(0),                               // 20: google.ads.googleads.v6.enums.ProductConditionEnum.ProductCondition
	(enums.SearchEngineResultsPageTypeEnum_SearchEngineResultsPageType)(0),         // 21: google.ads.googleads.v6.enums.SearchEngineResultsPageTypeEnum.SearchEngineResultsPageType
	(enums.SearchTermMatchTypeEnum_SearchTermMatchType)(0),                         // 22: google.ads.googleads.v6.enums.SearchTermMatchTypeEnum.SearchTermMatchType
	(enums.SlotEnum_Slot)(0),                                                       // 23: google.ads.googleads.v6.enums.SlotEnum.Slot
	(*KeywordInfo)(nil),                                                            // 24: google.ads.googleads.v6.common.KeywordInfo
	(enums.BudgetCampaignAssociationStatusEnum_BudgetCampaignAssociationStatus)(0), // 25: google.ads.googleads.v6.enums.BudgetCampaignAssociationStatusEnum.BudgetCampaignAssociationStatus
}
var file_google_ads_googleads_v6_common_segments_proto_depIdxs = []int32{
	3,  // 0: google.ads.googleads.v6.common.Segments.ad_destination_type:type_name -> google.ads.googleads.v6.enums.AdDestinationTypeEnum.AdDestinationType
	4,  // 1: google.ads.googleads.v6.common.Segments.ad_network_type:type_name -> google.ads.googleads.v6.enums.AdNetworkTypeEnum.AdNetworkType
	2,  // 2: google.ads.googleads.v6.common.Segments.budget_campaign_association_status:type_name -> google.ads.googleads.v6.common.BudgetCampaignAssociationStatus
	5,  // 3: google.ads.googleads.v6.common.Segments.click_type:type_name -> google.ads.googleads.v6.enums.ClickTypeEnum.ClickType
	6,  // 4: google.ads.googleads.v6.common.Segments.conversion_action_category:type_name -> google.ads.googleads.v6.enums.ConversionActionCategoryEnum.ConversionActionCategory
	7,  // 5: google.ads.googleads.v6.common.Segments.conversion_attribution_event_type:type_name -> google.ads.googleads.v6.enums.ConversionAttributionEventTypeEnum.ConversionAttributionEventType
	8,  // 6: google.ads.googleads.v6.common.Segments.conversion_lag_bucket:type_name -> google.ads.googleads.v6.enums.ConversionLagBucketEnum.ConversionLagBucket
	9,  // 7: google.ads.googleads.v6.common.Segments.conversion_or_adjustment_lag_bucket:type_name -> google.ads.googleads.v6.enums.ConversionOrAdjustmentLagBucketEnum.ConversionOrAdjustmentLagBucket
	10, // 8: google.ads.googleads.v6.common.Segments.day_of_week:type_name -> google.ads.googleads.v6.enums.DayOfWeekEnum.DayOfWeek
	11, // 9: google.ads.googleads.v6.common.Segments.device:type_name -> google.ads.googleads.v6.enums.DeviceEnum.Device
	12, // 10: google.ads.googleads.v6.common.Segments.external_conversion_source:type_name -> google.ads.googleads.v6.enums.ExternalConversionSourceEnum.ExternalConversionSource
	10, // 11: google.ads.googleads.v6.common.Segments.hotel_check_in_day_of_week:type_name -> google.ads.googleads.v6.enums.DayOfWeekEnum.DayOfWeek
	13, // 12: google.ads.googleads.v6.common.Segments.hotel_date_selection_type:type_name -> google.ads.googleads.v6.enums.HotelDateSelectionTypeEnum.HotelDateSelectionType
	14, // 13: google.ads.googleads.v6.common.Segments.hotel_rate_type:type_name -> google.ads.googleads.v6.enums.HotelRateTypeEnum.HotelRateType
	15, // 14: google.ads.googleads.v6.common.Segments.hotel_price_bucket:type_name -> google.ads.googleads.v6.enums.HotelPriceBucketEnum.HotelPriceBucket
	1,  // 15: google.ads.googleads.v6.common.Segments.keyword:type_name -> google.ads.googleads.v6.common.Keyword
	16, // 16: google.ads.googleads.v6.common.Segments.month_of_year:type_name -> google.ads.googleads.v6.enums.MonthOfYearEnum.MonthOfYear
	17, // 17: google.ads.googleads.v6.common.Segments.placeholder_type:type_name -> google.ads.googleads.v6.enums.PlaceholderTypeEnum.PlaceholderType
	18, // 18: google.ads.googleads.v6.common.Segments.product_channel:type_name -> google.ads.googleads.v6.enums.ProductChannelEnum.ProductChannel
	19, // 19: google.ads.googleads.v6.common.Segments.product_channel_exclusivity:type_name -> google.ads.googleads.v6.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity
	20, // 20: google.ads.googleads.v6.common.Segments.product_condition:type_name -> google.ads.googleads.v6.enums.ProductConditionEnum.ProductCondition
	21, // 21: google.ads.googleads.v6.common.Segments.search_engine_results_page_type:type_name -> google.ads.googleads.v6.enums.SearchEngineResultsPageTypeEnum.SearchEngineResultsPageType
	22, // 22: google.ads.googleads.v6.common.Segments.search_term_match_type:type_name -> google.ads.googleads.v6.enums.SearchTermMatchTypeEnum.SearchTermMatchType
	23, // 23: google.ads.googleads.v6.common.Segments.slot:type_name -> google.ads.googleads.v6.enums.SlotEnum.Slot
	24, // 24: google.ads.googleads.v6.common.Keyword.info:type_name -> google.ads.googleads.v6.common.KeywordInfo
	25, // 25: google.ads.googleads.v6.common.BudgetCampaignAssociationStatus.status:type_name -> google.ads.googleads.v6.enums.BudgetCampaignAssociationStatusEnum.BudgetCampaignAssociationStatus
	26, // [26:26] is the sub-list for method output_type
	26, // [26:26] is the sub-list for method input_type
	26, // [26:26] is the sub-list for extension type_name
	26, // [26:26] is the sub-list for extension extendee
	0,  // [0:26] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v6_common_segments_proto_init() }
func file_google_ads_googleads_v6_common_segments_proto_init() {
	if File_google_ads_googleads_v6_common_segments_proto != nil {
		return
	}
	file_google_ads_googleads_v6_common_criteria_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v6_common_segments_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Segments); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_segments_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Keyword); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_segments_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BudgetCampaignAssociationStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v6_common_segments_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_segments_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_segments_proto_msgTypes[2].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v6_common_segments_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v6_common_segments_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v6_common_segments_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v6_common_segments_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v6_common_segments_proto = out.File
	file_google_ads_googleads_v6_common_segments_proto_rawDesc = nil
	file_google_ads_googleads_v6_common_segments_proto_goTypes = nil
	file_google_ads_googleads_v6_common_segments_proto_depIdxs = nil
}
