// Code generated by protoc-gen-go. DO NOT EDIT.
// source: protoc-gen-swagger/options/openapiv2.proto

package options

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	_struct "github.com/golang/protobuf/ptypes/struct"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Swagger_SwaggerScheme int32

const (
	Swagger_UNKNOWN Swagger_SwaggerScheme = 0
	Swagger_HTTP    Swagger_SwaggerScheme = 1
	Swagger_HTTPS   Swagger_SwaggerScheme = 2
	Swagger_WS      Swagger_SwaggerScheme = 3
	Swagger_WSS     Swagger_SwaggerScheme = 4
)

var Swagger_SwaggerScheme_name = map[int32]string{
	0: "UNKNOWN",
	1: "HTTP",
	2: "HTTPS",
	3: "WS",
	4: "WSS",
}

var Swagger_SwaggerScheme_value = map[string]int32{
	"UNKNOWN": 0,
	"HTTP":    1,
	"HTTPS":   2,
	"WS":      3,
	"WSS":     4,
}

func (x Swagger_SwaggerScheme) String() string {
	return proto.EnumName(Swagger_SwaggerScheme_name, int32(x))
}

func (Swagger_SwaggerScheme) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{0, 0}
}

type JSONSchema_JSONSchemaSimpleTypes int32

const (
	JSONSchema_UNKNOWN JSONSchema_JSONSchemaSimpleTypes = 0
	JSONSchema_ARRAY   JSONSchema_JSONSchemaSimpleTypes = 1
	JSONSchema_BOOLEAN JSONSchema_JSONSchemaSimpleTypes = 2
	JSONSchema_INTEGER JSONSchema_JSONSchemaSimpleTypes = 3
	JSONSchema_NULL    JSONSchema_JSONSchemaSimpleTypes = 4
	JSONSchema_NUMBER  JSONSchema_JSONSchemaSimpleTypes = 5
	JSONSchema_OBJECT  JSONSchema_JSONSchemaSimpleTypes = 6
	JSONSchema_STRING  JSONSchema_JSONSchemaSimpleTypes = 7
)

var JSONSchema_JSONSchemaSimpleTypes_name = map[int32]string{
	0: "UNKNOWN",
	1: "ARRAY",
	2: "BOOLEAN",
	3: "INTEGER",
	4: "NULL",
	5: "NUMBER",
	6: "OBJECT",
	7: "STRING",
}

var JSONSchema_JSONSchemaSimpleTypes_value = map[string]int32{
	"UNKNOWN": 0,
	"ARRAY":   1,
	"BOOLEAN": 2,
	"INTEGER": 3,
	"NULL":    4,
	"NUMBER":  5,
	"OBJECT":  6,
	"STRING":  7,
}

func (x JSONSchema_JSONSchemaSimpleTypes) String() string {
	return proto.EnumName(JSONSchema_JSONSchemaSimpleTypes_name, int32(x))
}

func (JSONSchema_JSONSchemaSimpleTypes) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{8, 0}
}

// The type of the security scheme. Valid values are "basic",
// "apiKey" or "oauth2".
type SecurityScheme_Type int32

const (
	SecurityScheme_TYPE_INVALID SecurityScheme_Type = 0
	SecurityScheme_TYPE_BASIC   SecurityScheme_Type = 1
	SecurityScheme_TYPE_API_KEY SecurityScheme_Type = 2
	SecurityScheme_TYPE_OAUTH2  SecurityScheme_Type = 3
)

var SecurityScheme_Type_name = map[int32]string{
	0: "TYPE_INVALID",
	1: "TYPE_BASIC",
	2: "TYPE_API_KEY",
	3: "TYPE_OAUTH2",
}

var SecurityScheme_Type_value = map[string]int32{
	"TYPE_INVALID": 0,
	"TYPE_BASIC":   1,
	"TYPE_API_KEY": 2,
	"TYPE_OAUTH2":  3,
}

func (x SecurityScheme_Type) String() string {
	return proto.EnumName(SecurityScheme_Type_name, int32(x))
}

func (SecurityScheme_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{11, 0}
}

// The location of the API key. Valid values are "query" or "header".
type SecurityScheme_In int32

const (
	SecurityScheme_IN_INVALID SecurityScheme_In = 0
	SecurityScheme_IN_QUERY   SecurityScheme_In = 1
	SecurityScheme_IN_HEADER  SecurityScheme_In = 2
)

var SecurityScheme_In_name = map[int32]string{
	0: "IN_INVALID",
	1: "IN_QUERY",
	2: "IN_HEADER",
}

var SecurityScheme_In_value = map[string]int32{
	"IN_INVALID": 0,
	"IN_QUERY":   1,
	"IN_HEADER":  2,
}

func (x SecurityScheme_In) String() string {
	return proto.EnumName(SecurityScheme_In_name, int32(x))
}

func (SecurityScheme_In) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{11, 1}
}

// The flow used by the OAuth2 security scheme. Valid values are
// "implicit", "password", "application" or "accessCode".
type SecurityScheme_Flow int32

const (
	SecurityScheme_FLOW_INVALID     SecurityScheme_Flow = 0
	SecurityScheme_FLOW_IMPLICIT    SecurityScheme_Flow = 1
	SecurityScheme_FLOW_PASSWORD    SecurityScheme_Flow = 2
	SecurityScheme_FLOW_APPLICATION SecurityScheme_Flow = 3
	SecurityScheme_FLOW_ACCESS_CODE SecurityScheme_Flow = 4
)

var SecurityScheme_Flow_name = map[int32]string{
	0: "FLOW_INVALID",
	1: "FLOW_IMPLICIT",
	2: "FLOW_PASSWORD",
	3: "FLOW_APPLICATION",
	4: "FLOW_ACCESS_CODE",
}

var SecurityScheme_Flow_value = map[string]int32{
	"FLOW_INVALID":     0,
	"FLOW_IMPLICIT":    1,
	"FLOW_PASSWORD":    2,
	"FLOW_APPLICATION": 3,
	"FLOW_ACCESS_CODE": 4,
}

func (x SecurityScheme_Flow) String() string {
	return proto.EnumName(SecurityScheme_Flow_name, int32(x))
}

func (SecurityScheme_Flow) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{11, 2}
}

// `Swagger` is a representation of OpenAPI v2 specification's Swagger object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#swaggerObject
//
type Swagger struct {
	// Specifies the Swagger Specification version being used. It can be
	// used by the Swagger UI and other clients to interpret the API listing. The
	// value MUST be "2.0".
	Swagger string `protobuf:"bytes,1,opt,name=swagger,proto3" json:"swagger,omitempty"`
	// Provides metadata about the API. The metadata can be used by the
	// clients if needed.
	Info *Info `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	// The host (name or ip) serving the API. This MUST be the host only and does
	// not include the scheme nor sub-paths. It MAY include a port. If the host is
	// not included, the host serving the documentation is to be used (including
	// the port). The host does not support path templating.
	Host string `protobuf:"bytes,3,opt,name=host,proto3" json:"host,omitempty"`
	// The base path on which the API is served, which is relative to the host. If
	// it is not included, the API is served directly under the host. The value
	// MUST start with a leading slash (/). The basePath does not support path
	// templating.
	// Note that using `base_path` does not change the endpoint paths that are
	// generated in the resulting Swagger file. If you wish to use `base_path`
	// with relatively generated Swagger paths, the `base_path` prefix must be
	// manually removed from your `google.api.http` paths and your code changed to
	// serve the API from the `base_path`.
	BasePath string `protobuf:"bytes,4,opt,name=base_path,json=basePath,proto3" json:"base_path,omitempty"`
	// The transfer protocol of the API. Values MUST be from the list: "http",
	// "https", "ws", "wss". If the schemes is not included, the default scheme to
	// be used is the one used to access the Swagger definition itself.
	Schemes []Swagger_SwaggerScheme `protobuf:"varint,5,rep,packed,name=schemes,proto3,enum=grpc.gateway.protoc_gen_swagger.options.Swagger_SwaggerScheme" json:"schemes,omitempty"`
	// A list of MIME types the APIs can consume. This is global to all APIs but
	// can be overridden on specific API calls. Value MUST be as described under
	// Mime Types.
	Consumes []string `protobuf:"bytes,6,rep,name=consumes,proto3" json:"consumes,omitempty"`
	// A list of MIME types the APIs can produce. This is global to all APIs but
	// can be overridden on specific API calls. Value MUST be as described under
	// Mime Types.
	Produces []string `protobuf:"bytes,7,rep,name=produces,proto3" json:"produces,omitempty"`
	// An object to hold responses that can be used across operations. This
	// property does not define global responses for all operations.
	Responses map[string]*Response `protobuf:"bytes,10,rep,name=responses,proto3" json:"responses,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Security scheme definitions that can be used across the specification.
	SecurityDefinitions *SecurityDefinitions `protobuf:"bytes,11,opt,name=security_definitions,json=securityDefinitions,proto3" json:"security_definitions,omitempty"`
	// A declaration of which security schemes are applied for the API as a whole.
	// The list of values describes alternative security schemes that can be used
	// (that is, there is a logical OR between the security requirements).
	// Individual operations can override this definition.
	Security []*SecurityRequirement `protobuf:"bytes,12,rep,name=security,proto3" json:"security,omitempty"`
	// Additional external documentation.
	ExternalDocs         *ExternalDocumentation    `protobuf:"bytes,14,opt,name=external_docs,json=externalDocs,proto3" json:"external_docs,omitempty"`
	Extensions           map[string]*_struct.Value `protobuf:"bytes,15,rep,name=extensions,proto3" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *Swagger) Reset()         { *m = Swagger{} }
func (m *Swagger) String() string { return proto.CompactTextString(m) }
func (*Swagger) ProtoMessage()    {}
func (*Swagger) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{0}
}

func (m *Swagger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Swagger.Unmarshal(m, b)
}
func (m *Swagger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Swagger.Marshal(b, m, deterministic)
}
func (m *Swagger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Swagger.Merge(m, src)
}
func (m *Swagger) XXX_Size() int {
	return xxx_messageInfo_Swagger.Size(m)
}
func (m *Swagger) XXX_DiscardUnknown() {
	xxx_messageInfo_Swagger.DiscardUnknown(m)
}

var xxx_messageInfo_Swagger proto.InternalMessageInfo

func (m *Swagger) GetSwagger() string {
	if m != nil {
		return m.Swagger
	}
	return ""
}

func (m *Swagger) GetInfo() *Info {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Swagger) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Swagger) GetBasePath() string {
	if m != nil {
		return m.BasePath
	}
	return ""
}

func (m *Swagger) GetSchemes() []Swagger_SwaggerScheme {
	if m != nil {
		return m.Schemes
	}
	return nil
}

func (m *Swagger) GetConsumes() []string {
	if m != nil {
		return m.Consumes
	}
	return nil
}

func (m *Swagger) GetProduces() []string {
	if m != nil {
		return m.Produces
	}
	return nil
}

func (m *Swagger) GetResponses() map[string]*Response {
	if m != nil {
		return m.Responses
	}
	return nil
}

func (m *Swagger) GetSecurityDefinitions() *SecurityDefinitions {
	if m != nil {
		return m.SecurityDefinitions
	}
	return nil
}

func (m *Swagger) GetSecurity() []*SecurityRequirement {
	if m != nil {
		return m.Security
	}
	return nil
}

func (m *Swagger) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

func (m *Swagger) GetExtensions() map[string]*_struct.Value {
	if m != nil {
		return m.Extensions
	}
	return nil
}

// `Operation` is a representation of OpenAPI v2 specification's Operation object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#operationObject
//
type Operation struct {
	// A list of tags for API documentation control. Tags can be used for logical
	// grouping of operations by resources or any other qualifier.
	Tags []string `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
	// A short summary of what the operation does. For maximum readability in the
	// swagger-ui, this field SHOULD be less than 120 characters.
	Summary string `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
	// A verbose explanation of the operation behavior. GFM syntax can be used for
	// rich text representation.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Additional external documentation for this operation.
	ExternalDocs *ExternalDocumentation `protobuf:"bytes,4,opt,name=external_docs,json=externalDocs,proto3" json:"external_docs,omitempty"`
	// Unique string used to identify the operation. The id MUST be unique among
	// all operations described in the API. Tools and libraries MAY use the
	// operationId to uniquely identify an operation, therefore, it is recommended
	// to follow common programming naming conventions.
	OperationId string `protobuf:"bytes,5,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// A list of MIME types the operation can consume. This overrides the consumes
	// definition at the Swagger Object. An empty value MAY be used to clear the
	// global definition. Value MUST be as described under Mime Types.
	Consumes []string `protobuf:"bytes,6,rep,name=consumes,proto3" json:"consumes,omitempty"`
	// A list of MIME types the operation can produce. This overrides the produces
	// definition at the Swagger Object. An empty value MAY be used to clear the
	// global definition. Value MUST be as described under Mime Types.
	Produces []string `protobuf:"bytes,7,rep,name=produces,proto3" json:"produces,omitempty"`
	// The list of possible responses as they are returned from executing this
	// operation.
	Responses map[string]*Response `protobuf:"bytes,9,rep,name=responses,proto3" json:"responses,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The transfer protocol for the operation. Values MUST be from the list:
	// "http", "https", "ws", "wss". The value overrides the Swagger Object
	// schemes definition.
	Schemes []string `protobuf:"bytes,10,rep,name=schemes,proto3" json:"schemes,omitempty"`
	// Declares this operation to be deprecated. Usage of the declared operation
	// should be refrained. Default value is false.
	Deprecated bool `protobuf:"varint,11,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// A declaration of which security schemes are applied for this operation. The
	// list of values describes alternative security schemes that can be used
	// (that is, there is a logical OR between the security requirements). This
	// definition overrides any declared top-level security. To remove a top-level
	// security declaration, an empty array can be used.
	Security             []*SecurityRequirement    `protobuf:"bytes,12,rep,name=security,proto3" json:"security,omitempty"`
	Extensions           map[string]*_struct.Value `protobuf:"bytes,13,rep,name=extensions,proto3" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *Operation) Reset()         { *m = Operation{} }
func (m *Operation) String() string { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()    {}
func (*Operation) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{1}
}

func (m *Operation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Operation.Unmarshal(m, b)
}
func (m *Operation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Operation.Marshal(b, m, deterministic)
}
func (m *Operation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Operation.Merge(m, src)
}
func (m *Operation) XXX_Size() int {
	return xxx_messageInfo_Operation.Size(m)
}
func (m *Operation) XXX_DiscardUnknown() {
	xxx_messageInfo_Operation.DiscardUnknown(m)
}

var xxx_messageInfo_Operation proto.InternalMessageInfo

func (m *Operation) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Operation) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

func (m *Operation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Operation) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

func (m *Operation) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *Operation) GetConsumes() []string {
	if m != nil {
		return m.Consumes
	}
	return nil
}

func (m *Operation) GetProduces() []string {
	if m != nil {
		return m.Produces
	}
	return nil
}

func (m *Operation) GetResponses() map[string]*Response {
	if m != nil {
		return m.Responses
	}
	return nil
}

func (m *Operation) GetSchemes() []string {
	if m != nil {
		return m.Schemes
	}
	return nil
}

func (m *Operation) GetDeprecated() bool {
	if m != nil {
		return m.Deprecated
	}
	return false
}

func (m *Operation) GetSecurity() []*SecurityRequirement {
	if m != nil {
		return m.Security
	}
	return nil
}

func (m *Operation) GetExtensions() map[string]*_struct.Value {
	if m != nil {
		return m.Extensions
	}
	return nil
}

// `Response` is a representation of OpenAPI v2 specification's Response object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#responseObject
//
type Response struct {
	// `Description` is a short description of the response.
	// GFM syntax can be used for rich text representation.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// `Schema` optionally defines the structure of the response.
	// If `Schema` is not provided, it means there is no content to the response.
	Schema *Schema `protobuf:"bytes,2,opt,name=schema,proto3" json:"schema,omitempty"`
	// `Examples` gives per-mimetype response examples.
	// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#example-object
	Examples             map[string]string         `protobuf:"bytes,4,rep,name=examples,proto3" json:"examples,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Extensions           map[string]*_struct.Value `protobuf:"bytes,5,rep,name=extensions,proto3" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *Response) Reset()         { *m = Response{} }
func (m *Response) String() string { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()    {}
func (*Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{2}
}

func (m *Response) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Response.Unmarshal(m, b)
}
func (m *Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Response.Marshal(b, m, deterministic)
}
func (m *Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Response.Merge(m, src)
}
func (m *Response) XXX_Size() int {
	return xxx_messageInfo_Response.Size(m)
}
func (m *Response) XXX_DiscardUnknown() {
	xxx_messageInfo_Response.DiscardUnknown(m)
}

var xxx_messageInfo_Response proto.InternalMessageInfo

func (m *Response) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Response) GetSchema() *Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *Response) GetExamples() map[string]string {
	if m != nil {
		return m.Examples
	}
	return nil
}

func (m *Response) GetExtensions() map[string]*_struct.Value {
	if m != nil {
		return m.Extensions
	}
	return nil
}

// `Info` is a representation of OpenAPI v2 specification's Info object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#infoObject
//
type Info struct {
	// The title of the application.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// A short description of the application. GFM syntax can be used for rich
	// text representation.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The Terms of Service for the API.
	TermsOfService string `protobuf:"bytes,3,opt,name=terms_of_service,json=termsOfService,proto3" json:"terms_of_service,omitempty"`
	// The contact information for the exposed API.
	Contact *Contact `protobuf:"bytes,4,opt,name=contact,proto3" json:"contact,omitempty"`
	// The license information for the exposed API.
	License *License `protobuf:"bytes,5,opt,name=license,proto3" json:"license,omitempty"`
	// Provides the version of the application API (not to be confused
	// with the specification version).
	Version              string                    `protobuf:"bytes,6,opt,name=version,proto3" json:"version,omitempty"`
	Extensions           map[string]*_struct.Value `protobuf:"bytes,7,rep,name=extensions,proto3" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *Info) Reset()         { *m = Info{} }
func (m *Info) String() string { return proto.CompactTextString(m) }
func (*Info) ProtoMessage()    {}
func (*Info) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{3}
}

func (m *Info) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Info.Unmarshal(m, b)
}
func (m *Info) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Info.Marshal(b, m, deterministic)
}
func (m *Info) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Info.Merge(m, src)
}
func (m *Info) XXX_Size() int {
	return xxx_messageInfo_Info.Size(m)
}
func (m *Info) XXX_DiscardUnknown() {
	xxx_messageInfo_Info.DiscardUnknown(m)
}

var xxx_messageInfo_Info proto.InternalMessageInfo

func (m *Info) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Info) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Info) GetTermsOfService() string {
	if m != nil {
		return m.TermsOfService
	}
	return ""
}

func (m *Info) GetContact() *Contact {
	if m != nil {
		return m.Contact
	}
	return nil
}

func (m *Info) GetLicense() *License {
	if m != nil {
		return m.License
	}
	return nil
}

func (m *Info) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Info) GetExtensions() map[string]*_struct.Value {
	if m != nil {
		return m.Extensions
	}
	return nil
}

// `Contact` is a representation of OpenAPI v2 specification's Contact object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#contactObject
//
type Contact struct {
	// The identifying name of the contact person/organization.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The URL pointing to the contact information. MUST be in the format of a
	// URL.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// The email address of the contact person/organization. MUST be in the format
	// of an email address.
	Email                string   `protobuf:"bytes,3,opt,name=email,proto3" json:"email,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Contact) Reset()         { *m = Contact{} }
func (m *Contact) String() string { return proto.CompactTextString(m) }
func (*Contact) ProtoMessage()    {}
func (*Contact) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{4}
}

func (m *Contact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Contact.Unmarshal(m, b)
}
func (m *Contact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Contact.Marshal(b, m, deterministic)
}
func (m *Contact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Contact.Merge(m, src)
}
func (m *Contact) XXX_Size() int {
	return xxx_messageInfo_Contact.Size(m)
}
func (m *Contact) XXX_DiscardUnknown() {
	xxx_messageInfo_Contact.DiscardUnknown(m)
}

var xxx_messageInfo_Contact proto.InternalMessageInfo

func (m *Contact) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Contact) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Contact) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

// `License` is a representation of OpenAPI v2 specification's License object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#licenseObject
//
type License struct {
	// The license name used for the API.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A URL to the license used for the API. MUST be in the format of a URL.
	Url                  string   `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *License) Reset()         { *m = License{} }
func (m *License) String() string { return proto.CompactTextString(m) }
func (*License) ProtoMessage()    {}
func (*License) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{5}
}

func (m *License) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_License.Unmarshal(m, b)
}
func (m *License) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_License.Marshal(b, m, deterministic)
}
func (m *License) XXX_Merge(src proto.Message) {
	xxx_messageInfo_License.Merge(m, src)
}
func (m *License) XXX_Size() int {
	return xxx_messageInfo_License.Size(m)
}
func (m *License) XXX_DiscardUnknown() {
	xxx_messageInfo_License.DiscardUnknown(m)
}

var xxx_messageInfo_License proto.InternalMessageInfo

func (m *License) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *License) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// `ExternalDocumentation` is a representation of OpenAPI v2 specification's
// ExternalDocumentation object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#externalDocumentationObject
//
type ExternalDocumentation struct {
	// A short description of the target documentation. GFM syntax can be used for
	// rich text representation.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// The URL for the target documentation. Value MUST be in the format
	// of a URL.
	Url                  string   `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExternalDocumentation) Reset()         { *m = ExternalDocumentation{} }
func (m *ExternalDocumentation) String() string { return proto.CompactTextString(m) }
func (*ExternalDocumentation) ProtoMessage()    {}
func (*ExternalDocumentation) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{6}
}

func (m *ExternalDocumentation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExternalDocumentation.Unmarshal(m, b)
}
func (m *ExternalDocumentation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExternalDocumentation.Marshal(b, m, deterministic)
}
func (m *ExternalDocumentation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalDocumentation.Merge(m, src)
}
func (m *ExternalDocumentation) XXX_Size() int {
	return xxx_messageInfo_ExternalDocumentation.Size(m)
}
func (m *ExternalDocumentation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalDocumentation.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalDocumentation proto.InternalMessageInfo

func (m *ExternalDocumentation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ExternalDocumentation) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// `Schema` is a representation of OpenAPI v2 specification's Schema object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject
//
type Schema struct {
	JsonSchema *JSONSchema `protobuf:"bytes,1,opt,name=json_schema,json=jsonSchema,proto3" json:"json_schema,omitempty"`
	// Adds support for polymorphism. The discriminator is the schema property
	// name that is used to differentiate between other schema that inherit this
	// schema. The property name used MUST be defined at this schema and it MUST
	// be in the required property list. When used, the value MUST be the name of
	// this schema or any schema that inherits it.
	Discriminator string `protobuf:"bytes,2,opt,name=discriminator,proto3" json:"discriminator,omitempty"`
	// Relevant only for Schema "properties" definitions. Declares the property as
	// "read only". This means that it MAY be sent as part of a response but MUST
	// NOT be sent as part of the request. Properties marked as readOnly being
	// true SHOULD NOT be in the required list of the defined schema. Default
	// value is false.
	ReadOnly bool `protobuf:"varint,3,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	// Additional external documentation for this schema.
	ExternalDocs *ExternalDocumentation `protobuf:"bytes,5,opt,name=external_docs,json=externalDocs,proto3" json:"external_docs,omitempty"`
	// A free-form property to include an example of an instance for this schema.
	Example              *any.Any `protobuf:"bytes,6,opt,name=example,proto3" json:"example,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Schema) Reset()         { *m = Schema{} }
func (m *Schema) String() string { return proto.CompactTextString(m) }
func (*Schema) ProtoMessage()    {}
func (*Schema) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{7}
}

func (m *Schema) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Schema.Unmarshal(m, b)
}
func (m *Schema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Schema.Marshal(b, m, deterministic)
}
func (m *Schema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Schema.Merge(m, src)
}
func (m *Schema) XXX_Size() int {
	return xxx_messageInfo_Schema.Size(m)
}
func (m *Schema) XXX_DiscardUnknown() {
	xxx_messageInfo_Schema.DiscardUnknown(m)
}

var xxx_messageInfo_Schema proto.InternalMessageInfo

func (m *Schema) GetJsonSchema() *JSONSchema {
	if m != nil {
		return m.JsonSchema
	}
	return nil
}

func (m *Schema) GetDiscriminator() string {
	if m != nil {
		return m.Discriminator
	}
	return ""
}

func (m *Schema) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *Schema) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

func (m *Schema) GetExample() *any.Any {
	if m != nil {
		return m.Example
	}
	return nil
}

// `JSONSchema` represents properties from JSON Schema taken, and as used, in
// the OpenAPI v2 spec.
//
// This includes changes made by OpenAPI v2.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject
//
// See also: https://cswr.github.io/JsonSchema/spec/basic_types/,
// https://github.com/json-schema-org/json-schema-spec/blob/master/schema.json
//
// TODO(ivucica): document fields
type JSONSchema struct {
	// Ref is used to define an external reference to include in the message.
	// This could be a fully qualified proto message reference, and that type must
	// be imported into the protofile. If no message is identified, the Ref will
	// be used verbatim in the output.
	// For example:
	//  `ref: ".google.protobuf.Timestamp"`.
	Ref string `protobuf:"bytes,3,opt,name=ref,proto3" json:"ref,omitempty"`
	// The title of the schema.
	Title string `protobuf:"bytes,5,opt,name=title,proto3" json:"title,omitempty"`
	// A short description of the schema.
	Description string  `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	Default     string  `protobuf:"bytes,7,opt,name=default,proto3" json:"default,omitempty"`
	ReadOnly    bool    `protobuf:"varint,8,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	MultipleOf  float64 `protobuf:"fixed64,10,opt,name=multiple_of,json=multipleOf,proto3" json:"multiple_of,omitempty"`
	// Maximum represents an inclusive upper limit for a numeric instance. The
	// value of MUST be a number,
	Maximum          float64 `protobuf:"fixed64,11,opt,name=maximum,proto3" json:"maximum,omitempty"`
	ExclusiveMaximum bool    `protobuf:"varint,12,opt,name=exclusive_maximum,json=exclusiveMaximum,proto3" json:"exclusive_maximum,omitempty"`
	// minimum represents an inclusive lower limit for a numeric instance. The
	// value of MUST be a number,
	Minimum          float64  `protobuf:"fixed64,13,opt,name=minimum,proto3" json:"minimum,omitempty"`
	ExclusiveMinimum bool     `protobuf:"varint,14,opt,name=exclusive_minimum,json=exclusiveMinimum,proto3" json:"exclusive_minimum,omitempty"`
	MaxLength        uint64   `protobuf:"varint,15,opt,name=max_length,json=maxLength,proto3" json:"max_length,omitempty"`
	MinLength        uint64   `protobuf:"varint,16,opt,name=min_length,json=minLength,proto3" json:"min_length,omitempty"`
	Pattern          string   `protobuf:"bytes,17,opt,name=pattern,proto3" json:"pattern,omitempty"`
	MaxItems         uint64   `protobuf:"varint,20,opt,name=max_items,json=maxItems,proto3" json:"max_items,omitempty"`
	MinItems         uint64   `protobuf:"varint,21,opt,name=min_items,json=minItems,proto3" json:"min_items,omitempty"`
	UniqueItems      bool     `protobuf:"varint,22,opt,name=unique_items,json=uniqueItems,proto3" json:"unique_items,omitempty"`
	MaxProperties    uint64   `protobuf:"varint,24,opt,name=max_properties,json=maxProperties,proto3" json:"max_properties,omitempty"`
	MinProperties    uint64   `protobuf:"varint,25,opt,name=min_properties,json=minProperties,proto3" json:"min_properties,omitempty"`
	Required         []string `protobuf:"bytes,26,rep,name=required,proto3" json:"required,omitempty"`
	// Items in 'array' must be unique.
	Array                []string                           `protobuf:"bytes,34,rep,name=array,proto3" json:"array,omitempty"`
	Type                 []JSONSchema_JSONSchemaSimpleTypes `protobuf:"varint,35,rep,packed,name=type,proto3,enum=grpc.gateway.protoc_gen_swagger.options.JSONSchema_JSONSchemaSimpleTypes" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *JSONSchema) Reset()         { *m = JSONSchema{} }
func (m *JSONSchema) String() string { return proto.CompactTextString(m) }
func (*JSONSchema) ProtoMessage()    {}
func (*JSONSchema) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{8}
}

func (m *JSONSchema) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JSONSchema.Unmarshal(m, b)
}
func (m *JSONSchema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JSONSchema.Marshal(b, m, deterministic)
}
func (m *JSONSchema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JSONSchema.Merge(m, src)
}
func (m *JSONSchema) XXX_Size() int {
	return xxx_messageInfo_JSONSchema.Size(m)
}
func (m *JSONSchema) XXX_DiscardUnknown() {
	xxx_messageInfo_JSONSchema.DiscardUnknown(m)
}

var xxx_messageInfo_JSONSchema proto.InternalMessageInfo

func (m *JSONSchema) GetRef() string {
	if m != nil {
		return m.Ref
	}
	return ""
}

func (m *JSONSchema) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *JSONSchema) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *JSONSchema) GetDefault() string {
	if m != nil {
		return m.Default
	}
	return ""
}

func (m *JSONSchema) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *JSONSchema) GetMultipleOf() float64 {
	if m != nil {
		return m.MultipleOf
	}
	return 0
}

func (m *JSONSchema) GetMaximum() float64 {
	if m != nil {
		return m.Maximum
	}
	return 0
}

func (m *JSONSchema) GetExclusiveMaximum() bool {
	if m != nil {
		return m.ExclusiveMaximum
	}
	return false
}

func (m *JSONSchema) GetMinimum() float64 {
	if m != nil {
		return m.Minimum
	}
	return 0
}

func (m *JSONSchema) GetExclusiveMinimum() bool {
	if m != nil {
		return m.ExclusiveMinimum
	}
	return false
}

func (m *JSONSchema) GetMaxLength() uint64 {
	if m != nil {
		return m.MaxLength
	}
	return 0
}

func (m *JSONSchema) GetMinLength() uint64 {
	if m != nil {
		return m.MinLength
	}
	return 0
}

func (m *JSONSchema) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

func (m *JSONSchema) GetMaxItems() uint64 {
	if m != nil {
		return m.MaxItems
	}
	return 0
}

func (m *JSONSchema) GetMinItems() uint64 {
	if m != nil {
		return m.MinItems
	}
	return 0
}

func (m *JSONSchema) GetUniqueItems() bool {
	if m != nil {
		return m.UniqueItems
	}
	return false
}

func (m *JSONSchema) GetMaxProperties() uint64 {
	if m != nil {
		return m.MaxProperties
	}
	return 0
}

func (m *JSONSchema) GetMinProperties() uint64 {
	if m != nil {
		return m.MinProperties
	}
	return 0
}

func (m *JSONSchema) GetRequired() []string {
	if m != nil {
		return m.Required
	}
	return nil
}

func (m *JSONSchema) GetArray() []string {
	if m != nil {
		return m.Array
	}
	return nil
}

func (m *JSONSchema) GetType() []JSONSchema_JSONSchemaSimpleTypes {
	if m != nil {
		return m.Type
	}
	return nil
}

// `Tag` is a representation of OpenAPI v2 specification's Tag object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#tagObject
//
type Tag struct {
	// A short description for the tag. GFM syntax can be used for rich text
	// representation.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Additional external documentation for this tag.
	ExternalDocs         *ExternalDocumentation `protobuf:"bytes,3,opt,name=external_docs,json=externalDocs,proto3" json:"external_docs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Tag) Reset()         { *m = Tag{} }
func (m *Tag) String() string { return proto.CompactTextString(m) }
func (*Tag) ProtoMessage()    {}
func (*Tag) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{9}
}

func (m *Tag) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Tag.Unmarshal(m, b)
}
func (m *Tag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Tag.Marshal(b, m, deterministic)
}
func (m *Tag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tag.Merge(m, src)
}
func (m *Tag) XXX_Size() int {
	return xxx_messageInfo_Tag.Size(m)
}
func (m *Tag) XXX_DiscardUnknown() {
	xxx_messageInfo_Tag.DiscardUnknown(m)
}

var xxx_messageInfo_Tag proto.InternalMessageInfo

func (m *Tag) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Tag) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

// `SecurityDefinitions` is a representation of OpenAPI v2 specification's
// Security Definitions object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securityDefinitionsObject
//
// A declaration of the security schemes available to be used in the
// specification. This does not enforce the security schemes on the operations
// and only serves to provide the relevant details for each scheme.
type SecurityDefinitions struct {
	// A single security scheme definition, mapping a "name" to the scheme it
	// defines.
	Security             map[string]*SecurityScheme `protobuf:"bytes,1,rep,name=security,proto3" json:"security,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *SecurityDefinitions) Reset()         { *m = SecurityDefinitions{} }
func (m *SecurityDefinitions) String() string { return proto.CompactTextString(m) }
func (*SecurityDefinitions) ProtoMessage()    {}
func (*SecurityDefinitions) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{10}
}

func (m *SecurityDefinitions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityDefinitions.Unmarshal(m, b)
}
func (m *SecurityDefinitions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityDefinitions.Marshal(b, m, deterministic)
}
func (m *SecurityDefinitions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityDefinitions.Merge(m, src)
}
func (m *SecurityDefinitions) XXX_Size() int {
	return xxx_messageInfo_SecurityDefinitions.Size(m)
}
func (m *SecurityDefinitions) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityDefinitions.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityDefinitions proto.InternalMessageInfo

func (m *SecurityDefinitions) GetSecurity() map[string]*SecurityScheme {
	if m != nil {
		return m.Security
	}
	return nil
}

// `SecurityScheme` is a representation of OpenAPI v2 specification's
// Security Scheme object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securitySchemeObject
//
// Allows the definition of a security scheme that can be used by the
// operations. Supported schemes are basic authentication, an API key (either as
// a header or as a query parameter) and OAuth2's common flows (implicit,
// password, application and access code).
type SecurityScheme struct {
	// The type of the security scheme. Valid values are "basic",
	// "apiKey" or "oauth2".
	Type SecurityScheme_Type `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.gateway.protoc_gen_swagger.options.SecurityScheme_Type" json:"type,omitempty"`
	// A short description for security scheme.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The name of the header or query parameter to be used.
	// Valid for apiKey.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The location of the API key. Valid values are "query" or
	// "header".
	// Valid for apiKey.
	In SecurityScheme_In `protobuf:"varint,4,opt,name=in,proto3,enum=grpc.gateway.protoc_gen_swagger.options.SecurityScheme_In" json:"in,omitempty"`
	// The flow used by the OAuth2 security scheme. Valid values are
	// "implicit", "password", "application" or "accessCode".
	// Valid for oauth2.
	Flow SecurityScheme_Flow `protobuf:"varint,5,opt,name=flow,proto3,enum=grpc.gateway.protoc_gen_swagger.options.SecurityScheme_Flow" json:"flow,omitempty"`
	// The authorization URL to be used for this flow. This SHOULD be in
	// the form of a URL.
	// Valid for oauth2/implicit and oauth2/accessCode.
	AuthorizationUrl string `protobuf:"bytes,6,opt,name=authorization_url,json=authorizationUrl,proto3" json:"authorization_url,omitempty"`
	// The token URL to be used for this flow. This SHOULD be in the
	// form of a URL.
	// Valid for oauth2/password, oauth2/application and oauth2/accessCode.
	TokenUrl string `protobuf:"bytes,7,opt,name=token_url,json=tokenUrl,proto3" json:"token_url,omitempty"`
	// The available scopes for the OAuth2 security scheme.
	// Valid for oauth2.
	Scopes               *Scopes                   `protobuf:"bytes,8,opt,name=scopes,proto3" json:"scopes,omitempty"`
	Extensions           map[string]*_struct.Value `protobuf:"bytes,9,rep,name=extensions,proto3" json:"extensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *SecurityScheme) Reset()         { *m = SecurityScheme{} }
func (m *SecurityScheme) String() string { return proto.CompactTextString(m) }
func (*SecurityScheme) ProtoMessage()    {}
func (*SecurityScheme) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{11}
}

func (m *SecurityScheme) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityScheme.Unmarshal(m, b)
}
func (m *SecurityScheme) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityScheme.Marshal(b, m, deterministic)
}
func (m *SecurityScheme) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityScheme.Merge(m, src)
}
func (m *SecurityScheme) XXX_Size() int {
	return xxx_messageInfo_SecurityScheme.Size(m)
}
func (m *SecurityScheme) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityScheme.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityScheme proto.InternalMessageInfo

func (m *SecurityScheme) GetType() SecurityScheme_Type {
	if m != nil {
		return m.Type
	}
	return SecurityScheme_TYPE_INVALID
}

func (m *SecurityScheme) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *SecurityScheme) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SecurityScheme) GetIn() SecurityScheme_In {
	if m != nil {
		return m.In
	}
	return SecurityScheme_IN_INVALID
}

func (m *SecurityScheme) GetFlow() SecurityScheme_Flow {
	if m != nil {
		return m.Flow
	}
	return SecurityScheme_FLOW_INVALID
}

func (m *SecurityScheme) GetAuthorizationUrl() string {
	if m != nil {
		return m.AuthorizationUrl
	}
	return ""
}

func (m *SecurityScheme) GetTokenUrl() string {
	if m != nil {
		return m.TokenUrl
	}
	return ""
}

func (m *SecurityScheme) GetScopes() *Scopes {
	if m != nil {
		return m.Scopes
	}
	return nil
}

func (m *SecurityScheme) GetExtensions() map[string]*_struct.Value {
	if m != nil {
		return m.Extensions
	}
	return nil
}

// `SecurityRequirement` is a representation of OpenAPI v2 specification's
// Security Requirement object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securityRequirementObject
//
// Lists the required security schemes to execute this operation. The object can
// have multiple security schemes declared in it which are all required (that
// is, there is a logical AND between the schemes).
//
// The name used for each property MUST correspond to a security scheme
// declared in the Security Definitions.
type SecurityRequirement struct {
	// Each name must correspond to a security scheme which is declared in
	// the Security Definitions. If the security scheme is of type "oauth2",
	// then the value is a list of scope names required for the execution.
	// For other security scheme types, the array MUST be empty.
	SecurityRequirement  map[string]*SecurityRequirement_SecurityRequirementValue `protobuf:"bytes,1,rep,name=security_requirement,json=securityRequirement,proto3" json:"security_requirement,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                                                 `json:"-"`
	XXX_unrecognized     []byte                                                   `json:"-"`
	XXX_sizecache        int32                                                    `json:"-"`
}

func (m *SecurityRequirement) Reset()         { *m = SecurityRequirement{} }
func (m *SecurityRequirement) String() string { return proto.CompactTextString(m) }
func (*SecurityRequirement) ProtoMessage()    {}
func (*SecurityRequirement) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{12}
}

func (m *SecurityRequirement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityRequirement.Unmarshal(m, b)
}
func (m *SecurityRequirement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityRequirement.Marshal(b, m, deterministic)
}
func (m *SecurityRequirement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityRequirement.Merge(m, src)
}
func (m *SecurityRequirement) XXX_Size() int {
	return xxx_messageInfo_SecurityRequirement.Size(m)
}
func (m *SecurityRequirement) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityRequirement.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityRequirement proto.InternalMessageInfo

func (m *SecurityRequirement) GetSecurityRequirement() map[string]*SecurityRequirement_SecurityRequirementValue {
	if m != nil {
		return m.SecurityRequirement
	}
	return nil
}

// If the security scheme is of type "oauth2", then the value is a list of
// scope names required for the execution. For other security scheme types,
// the array MUST be empty.
type SecurityRequirement_SecurityRequirementValue struct {
	Scope                []string `protobuf:"bytes,1,rep,name=scope,proto3" json:"scope,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SecurityRequirement_SecurityRequirementValue) Reset() {
	*m = SecurityRequirement_SecurityRequirementValue{}
}
func (m *SecurityRequirement_SecurityRequirementValue) String() string {
	return proto.CompactTextString(m)
}
func (*SecurityRequirement_SecurityRequirementValue) ProtoMessage() {}
func (*SecurityRequirement_SecurityRequirementValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{12, 0}
}

func (m *SecurityRequirement_SecurityRequirementValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.Unmarshal(m, b)
}
func (m *SecurityRequirement_SecurityRequirementValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.Marshal(b, m, deterministic)
}
func (m *SecurityRequirement_SecurityRequirementValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.Merge(m, src)
}
func (m *SecurityRequirement_SecurityRequirementValue) XXX_Size() int {
	return xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.Size(m)
}
func (m *SecurityRequirement_SecurityRequirementValue) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityRequirement_SecurityRequirementValue proto.InternalMessageInfo

func (m *SecurityRequirement_SecurityRequirementValue) GetScope() []string {
	if m != nil {
		return m.Scope
	}
	return nil
}

// `Scopes` is a representation of OpenAPI v2 specification's Scopes object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#scopesObject
//
// Lists the available scopes for an OAuth2 security scheme.
type Scopes struct {
	// Maps between a name of a scope to a short description of it (as the value
	// of the property).
	Scope                map[string]string `protobuf:"bytes,1,rep,name=scope,proto3" json:"scope,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Scopes) Reset()         { *m = Scopes{} }
func (m *Scopes) String() string { return proto.CompactTextString(m) }
func (*Scopes) ProtoMessage()    {}
func (*Scopes) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba35ad8af024fb48, []int{13}
}

func (m *Scopes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Scopes.Unmarshal(m, b)
}
func (m *Scopes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Scopes.Marshal(b, m, deterministic)
}
func (m *Scopes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Scopes.Merge(m, src)
}
func (m *Scopes) XXX_Size() int {
	return xxx_messageInfo_Scopes.Size(m)
}
func (m *Scopes) XXX_DiscardUnknown() {
	xxx_messageInfo_Scopes.DiscardUnknown(m)
}

var xxx_messageInfo_Scopes proto.InternalMessageInfo

func (m *Scopes) GetScope() map[string]string {
	if m != nil {
		return m.Scope
	}
	return nil
}

func init() {
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.Swagger_SwaggerScheme", Swagger_SwaggerScheme_name, Swagger_SwaggerScheme_value)
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.JSONSchema_JSONSchemaSimpleTypes", JSONSchema_JSONSchemaSimpleTypes_name, JSONSchema_JSONSchemaSimpleTypes_value)
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.SecurityScheme_Type", SecurityScheme_Type_name, SecurityScheme_Type_value)
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.SecurityScheme_In", SecurityScheme_In_name, SecurityScheme_In_value)
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.SecurityScheme_Flow", SecurityScheme_Flow_name, SecurityScheme_Flow_value)
	proto.RegisterType((*Swagger)(nil), "grpc.gateway.protoc_gen_swagger.options.Swagger")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "grpc.gateway.protoc_gen_swagger.options.Swagger.ExtensionsEntry")
	proto.RegisterMapType((map[string]*Response)(nil), "grpc.gateway.protoc_gen_swagger.options.Swagger.ResponsesEntry")
	proto.RegisterType((*Operation)(nil), "grpc.gateway.protoc_gen_swagger.options.Operation")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "grpc.gateway.protoc_gen_swagger.options.Operation.ExtensionsEntry")
	proto.RegisterMapType((map[string]*Response)(nil), "grpc.gateway.protoc_gen_swagger.options.Operation.ResponsesEntry")
	proto.RegisterType((*Response)(nil), "grpc.gateway.protoc_gen_swagger.options.Response")
	proto.RegisterMapType((map[string]string)(nil), "grpc.gateway.protoc_gen_swagger.options.Response.ExamplesEntry")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "grpc.gateway.protoc_gen_swagger.options.Response.ExtensionsEntry")
	proto.RegisterType((*Info)(nil), "grpc.gateway.protoc_gen_swagger.options.Info")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "grpc.gateway.protoc_gen_swagger.options.Info.ExtensionsEntry")
	proto.RegisterType((*Contact)(nil), "grpc.gateway.protoc_gen_swagger.options.Contact")
	proto.RegisterType((*License)(nil), "grpc.gateway.protoc_gen_swagger.options.License")
	proto.RegisterType((*ExternalDocumentation)(nil), "grpc.gateway.protoc_gen_swagger.options.ExternalDocumentation")
	proto.RegisterType((*Schema)(nil), "grpc.gateway.protoc_gen_swagger.options.Schema")
	proto.RegisterType((*JSONSchema)(nil), "grpc.gateway.protoc_gen_swagger.options.JSONSchema")
	proto.RegisterType((*Tag)(nil), "grpc.gateway.protoc_gen_swagger.options.Tag")
	proto.RegisterType((*SecurityDefinitions)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityDefinitions")
	proto.RegisterMapType((map[string]*SecurityScheme)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityDefinitions.SecurityEntry")
	proto.RegisterType((*SecurityScheme)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityScheme")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityScheme.ExtensionsEntry")
	proto.RegisterType((*SecurityRequirement)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityRequirement")
	proto.RegisterMapType((map[string]*SecurityRequirement_SecurityRequirementValue)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityRequirement.SecurityRequirementEntry")
	proto.RegisterType((*SecurityRequirement_SecurityRequirementValue)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityRequirement.SecurityRequirementValue")
	proto.RegisterType((*Scopes)(nil), "grpc.gateway.protoc_gen_swagger.options.Scopes")
	proto.RegisterMapType((map[string]string)(nil), "grpc.gateway.protoc_gen_swagger.options.Scopes.ScopeEntry")
}

func init() {
	proto.RegisterFile("protoc-gen-swagger/options/openapiv2.proto", fileDescriptor_ba35ad8af024fb48)
}

var fileDescriptor_ba35ad8af024fb48 = []byte{
	// 1910 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x59, 0x5b, 0x73, 0x1a, 0xd7,
	0x1d, 0xcf, 0xc2, 0x02, 0xcb, 0x1f, 0x81, 0x8f, 0x8f, 0xe5, 0x74, 0x43, 0x6c, 0x57, 0xa1, 0xe9,
	0x54, 0x63, 0xd7, 0x28, 0x51, 0x1e, 0x9a, 0x49, 0xaf, 0x48, 0x22, 0xf2, 0xae, 0x65, 0xa0, 0x0b,
	0x8a, 0xe2, 0x76, 0x3c, 0xdb, 0xd5, 0x72, 0x40, 0x1b, 0xef, 0x85, 0xec, 0x45, 0x12, 0xfd, 0x04,
	0x7d, 0xee, 0xf4, 0x35, 0xdf, 0xa3, 0x0f, 0x7d, 0xea, 0x17, 0x68, 0x3f, 0x4b, 0x3b, 0x7d, 0xef,
	0x9c, 0xcb, 0xc2, 0x22, 0x61, 0x0f, 0xc8, 0x76, 0xfb, 0x90, 0x27, 0xce, 0xff, 0xf6, 0x3b, 0x97,
	0xff, 0xed, 0x9c, 0x05, 0x1e, 0x4e, 0xc2, 0x20, 0x0e, 0xec, 0xc7, 0x63, 0xe2, 0x3f, 0x8e, 0x2e,
	0xac, 0xf1, 0x98, 0x84, 0x3b, 0xc1, 0x24, 0x76, 0x02, 0x3f, 0xda, 0x09, 0x26, 0xc4, 0xb7, 0x26,
	0xce, 0xf9, 0x6e, 0x93, 0x29, 0xe1, 0x9f, 0x8c, 0xc3, 0x89, 0xdd, 0x1c, 0x5b, 0x31, 0xb9, 0xb0,
	0xa6, 0x9c, 0x67, 0x9b, 0x63, 0xe2, 0x9b, 0xc2, 0xb0, 0x29, 0x0c, 0xeb, 0x1f, 0x8c, 0x83, 0x60,
	0xec, 0x92, 0x1d, 0xa6, 0x72, 0x9a, 0x8c, 0x76, 0x2c, 0x5f, 0xe8, 0xd7, 0xef, 0x5d, 0x15, 0x45,
	0x71, 0x98, 0xd8, 0x31, 0x97, 0x36, 0xfe, 0xaa, 0x40, 0xa9, 0xcf, 0xc1, 0xb0, 0x0a, 0x25, 0x81,
	0xab, 0x4a, 0x5b, 0xd2, 0x76, 0xd9, 0x48, 0x49, 0xdc, 0x02, 0xd9, 0xf1, 0x47, 0x81, 0x9a, 0xdb,
	0x92, 0xb6, 0x2b, 0xbb, 0x8f, 0x9b, 0x2b, 0x2e, 0xab, 0xa9, 0xf9, 0xa3, 0xc0, 0x60, 0xa6, 0x18,
	0x83, 0x7c, 0x16, 0x44, 0xb1, 0x9a, 0x67, 0xc8, 0x6c, 0x8c, 0x3f, 0x84, 0xf2, 0xa9, 0x15, 0x11,
	0x73, 0x62, 0xc5, 0x67, 0xaa, 0xcc, 0x04, 0x0a, 0x65, 0xf4, 0xac, 0xf8, 0x0c, 0x7f, 0x0d, 0xa5,
	0xc8, 0x3e, 0x23, 0x1e, 0x89, 0xd4, 0xc2, 0x56, 0x7e, 0xbb, 0xb6, 0xfb, 0xab, 0x95, 0xa7, 0x15,
	0x1b, 0x4a, 0x7f, 0xfb, 0x0c, 0xc6, 0x48, 0xe1, 0x70, 0x1d, 0x14, 0x3b, 0xf0, 0xa3, 0x84, 0x42,
	0x17, 0xb7, 0xf2, 0x74, 0xd6, 0x94, 0xa6, 0xb2, 0x49, 0x18, 0x0c, 0x13, 0x9b, 0x44, 0x6a, 0x89,
	0xcb, 0x52, 0x1a, 0xbf, 0x80, 0x72, 0x48, 0xa2, 0x49, 0xe0, 0x47, 0x24, 0x52, 0x61, 0x2b, 0xbf,
	0x5d, 0xd9, 0xfd, 0xf5, 0xda, 0x6b, 0x32, 0x52, 0x84, 0xb6, 0x1f, 0x87, 0x53, 0x63, 0x8e, 0x88,
	0x03, 0xd8, 0x8c, 0x88, 0x9d, 0x84, 0x4e, 0x3c, 0x35, 0x87, 0x64, 0xe4, 0xf8, 0x0e, 0xb3, 0x54,
	0x2b, 0xec, 0xd0, 0x7f, 0xb1, 0xfa, 0x4c, 0x02, 0xe4, 0x60, 0x8e, 0x61, 0xdc, 0x89, 0xae, 0x33,
	0xf1, 0xd7, 0xa0, 0xa4, 0x6c, 0x75, 0x83, 0x6d, 0x67, 0xfd, 0x49, 0x0c, 0xf2, 0x6d, 0xe2, 0x84,
	0xc4, 0x23, 0x7e, 0x6c, 0xcc, 0xd0, 0xb0, 0x0d, 0x55, 0x72, 0x19, 0x93, 0xd0, 0xb7, 0x5c, 0x73,
	0x18, 0xd8, 0x91, 0x5a, 0x63, 0x7b, 0x58, 0xdd, 0x83, 0x6d, 0x61, 0x7d, 0x10, 0xd8, 0x09, 0xc5,
	0xb6, 0x28, 0xdb, 0xd8, 0x20, 0x73, 0x76, 0x84, 0xff, 0x00, 0x40, 0x69, 0x3f, 0x62, 0xa7, 0x74,
	0x8b, 0x6d, 0xe0, 0x37, 0x6b, 0xfb, 0xa3, 0x3d, 0x83, 0xe0, 0x0e, 0xc9, 0x60, 0xd6, 0x03, 0xa8,
	0x2d, 0xba, 0x0b, 0x23, 0xc8, 0xbf, 0x24, 0x53, 0x91, 0x1e, 0x74, 0x88, 0x0f, 0xa1, 0x70, 0x6e,
	0xb9, 0x09, 0x11, 0xb9, 0xf1, 0xe9, 0xca, 0x0b, 0x48, 0x91, 0x0d, 0x6e, 0xff, 0x45, 0xee, 0x73,
	0xa9, 0x7e, 0x0c, 0xb7, 0xae, 0xac, 0x67, 0xc9, 0x8c, 0x3f, 0x5d, 0x9c, 0xf1, 0xfd, 0x26, 0x4f,
	0xf0, 0x66, 0x9a, 0xe0, 0xcd, 0xaf, 0xa8, 0x34, 0x03, 0xdb, 0xd8, 0x83, 0xea, 0x42, 0x2a, 0xe0,
	0x0a, 0x94, 0x8e, 0x3b, 0x4f, 0x3b, 0xdd, 0x93, 0x0e, 0x7a, 0x0f, 0x2b, 0x20, 0x3f, 0x19, 0x0c,
	0x7a, 0x48, 0xc2, 0x65, 0x28, 0xd0, 0x51, 0x1f, 0xe5, 0x70, 0x11, 0x72, 0x27, 0x7d, 0x94, 0xc7,
	0x25, 0xc8, 0x9f, 0xf4, 0xfb, 0x48, 0xd6, 0x65, 0x45, 0x41, 0x65, 0x5d, 0x56, 0xca, 0x08, 0x74,
	0x59, 0xa9, 0xa2, 0x5a, 0xe3, 0xef, 0x45, 0x28, 0x77, 0x27, 0x24, 0x64, 0xbe, 0xa1, 0xf9, 0x1d,
	0x5b, 0xe3, 0x48, 0x95, 0x58, 0xd2, 0xb0, 0x31, 0x2b, 0x28, 0x89, 0xe7, 0x59, 0xe1, 0x94, 0xad,
	0x95, 0x16, 0x14, 0x4e, 0xe2, 0x2d, 0xa8, 0x0c, 0x49, 0x64, 0x87, 0x0e, 0x3b, 0x0c, 0x51, 0x14,
	0xb2, 0xac, 0xeb, 0x21, 0x24, 0xbf, 0x83, 0x10, 0xfa, 0x08, 0x36, 0x82, 0x74, 0x07, 0xa6, 0x33,
	0x54, 0x0b, 0x7c, 0x1d, 0x33, 0x9e, 0x36, 0xbc, 0x71, 0xb1, 0x30, 0xb3, 0xc5, 0xa2, 0xcc, 0x82,
	0xb3, 0xb5, 0xf2, 0xda, 0x67, 0xc7, 0xfa, 0x9a, 0x72, 0xa1, 0xce, 0xeb, 0x23, 0xb0, 0xb9, 0x67,
	0xf5, 0xed, 0x01, 0xc0, 0x90, 0x4c, 0x42, 0x62, 0x5b, 0x31, 0x19, 0xb2, 0xf2, 0xa1, 0x18, 0x19,
	0xce, 0x3b, 0xcc, 0xfb, 0xd3, 0x85, 0x94, 0xac, 0x32, 0xec, 0xbd, 0x1b, 0xec, 0xfa, 0x7b, 0x90,
	0x94, 0x3c, 0xa1, 0x1a, 0xff, 0xc8, 0x83, 0x92, 0x4e, 0x7a, 0x35, 0x2b, 0xa4, 0xeb, 0x59, 0x71,
	0x08, 0x45, 0xe6, 0x65, 0x4b, 0xcc, 0xb3, 0xb3, 0xba, 0xe3, 0x98, 0x99, 0x21, 0xcc, 0xf1, 0xef,
	0x41, 0x21, 0x97, 0x96, 0x37, 0x71, 0x09, 0xcd, 0xac, 0xf5, 0x5a, 0x59, 0xba, 0xde, 0x66, 0x5b,
	0x20, 0x70, 0x27, 0xcd, 0x00, 0xb1, 0xb5, 0x10, 0x06, 0x85, 0x35, 0x83, 0x3f, 0x03, 0xff, 0xea,
	0x28, 0xf8, 0x39, 0x54, 0x17, 0x66, 0x5f, 0xe2, 0x92, 0xcd, 0xac, 0x4b, 0xca, 0xff, 0x13, 0x8f,
	0xe6, 0x91, 0xdc, 0xf8, 0x67, 0x1e, 0x64, 0x7a, 0xef, 0xa1, 0xf3, 0xc7, 0x4e, 0xec, 0x12, 0x01,
	0xca, 0x89, 0xab, 0x3e, 0xce, 0x5d, 0xf7, 0xf1, 0x36, 0xa0, 0x98, 0x84, 0x5e, 0x64, 0x06, 0x23,
	0x33, 0x22, 0xe1, 0xb9, 0x63, 0x13, 0x51, 0x20, 0x6b, 0x8c, 0xdf, 0x1d, 0xf5, 0x39, 0x17, 0xeb,
	0x50, 0xb2, 0x03, 0x3f, 0xb6, 0xec, 0x58, 0x54, 0xc7, 0x4f, 0x56, 0x3e, 0xe4, 0x7d, 0x6e, 0x67,
	0xa4, 0x00, 0x14, 0xcb, 0x75, 0x6c, 0xe2, 0x47, 0x84, 0x55, 0xc1, 0x75, 0xb0, 0x8e, 0xb8, 0x9d,
	0x91, 0x02, 0xd0, 0xd2, 0x74, 0x4e, 0x42, 0x7a, 0xba, 0x6a, 0x91, 0xd7, 0x7d, 0x41, 0xe2, 0x17,
	0x0b, 0x91, 0x51, 0x62, 0x91, 0xf1, 0xcb, 0xb5, 0xae, 0x93, 0xaf, 0x8d, 0x8a, 0x77, 0xd4, 0x3f,
	0xdb, 0x50, 0x12, 0xe7, 0x45, 0xdb, 0x9c, 0x6f, 0x79, 0xa9, 0x4f, 0xd9, 0x98, 0x4e, 0x91, 0x84,
	0xae, 0x70, 0x25, 0x1d, 0x52, 0xd7, 0x13, 0xcf, 0x72, 0x5c, 0xe1, 0x37, 0x4e, 0x34, 0x76, 0xa0,
	0x24, 0x8e, 0x6a, 0x35, 0x98, 0xc6, 0x53, 0xb8, 0xbb, 0xb4, 0x8b, 0xad, 0x50, 0x28, 0xae, 0x83,
	0xfd, 0x2d, 0x07, 0x45, 0x5e, 0x04, 0xf0, 0x00, 0x2a, 0xdf, 0x44, 0x81, 0x6f, 0x8a, 0x52, 0x22,
	0xb1, 0x73, 0xf8, 0x6c, 0x65, 0x37, 0xe8, 0xfd, 0x6e, 0x47, 0x94, 0x13, 0xa0, 0x38, 0x02, 0xf5,
	0x63, 0xa8, 0x0e, 0x1d, 0xba, 0x02, 0xcf, 0xf1, 0xad, 0x38, 0x08, 0xc5, 0xe4, 0x8b, 0x4c, 0x7a,
	0xe7, 0x0f, 0x89, 0x35, 0x34, 0x03, 0xdf, 0x9d, 0xb2, 0xe3, 0x51, 0x0c, 0x85, 0x32, 0xba, 0xbe,
	0xbb, 0xe4, 0xde, 0x58, 0x78, 0x07, 0x4d, 0xbf, 0x09, 0x25, 0x51, 0xa9, 0x58, 0x74, 0x56, 0x76,
	0x37, 0xaf, 0x45, 0x40, 0xcb, 0x9f, 0x1a, 0xa9, 0x92, 0x2e, 0x2b, 0x32, 0x2a, 0x34, 0xbe, 0x2b,
	0x01, 0xcc, 0x37, 0x4e, 0xcf, 0x37, 0x24, 0x23, 0xe1, 0x5f, 0x3a, 0x9c, 0xa7, 0x7b, 0xe1, 0x35,
	0xe9, 0x5e, 0xbc, 0xee, 0x29, 0x15, 0x4a, 0x43, 0x32, 0xb2, 0x12, 0x37, 0x56, 0x4b, 0x3c, 0x59,
	0x04, 0xb9, 0x78, 0x54, 0xca, 0x95, 0xa3, 0xfa, 0x21, 0x54, 0xbc, 0xc4, 0x8d, 0x9d, 0x89, 0x4b,
	0xcc, 0x60, 0xa4, 0xc2, 0x96, 0xb4, 0x2d, 0x19, 0x90, 0xb2, 0xba, 0x23, 0x8a, 0xeb, 0x59, 0x97,
	0x8e, 0x97, 0x78, 0xec, 0x0a, 0x20, 0x19, 0x29, 0x89, 0x1f, 0xc1, 0x6d, 0x72, 0x69, 0xbb, 0x49,
	0xe4, 0x9c, 0x13, 0x33, 0xd5, 0xd9, 0x60, 0xf8, 0x68, 0x26, 0x78, 0x26, 0x94, 0x29, 0x8c, 0xe3,
	0x33, 0x95, 0xaa, 0x80, 0xe1, 0xe4, 0x15, 0x18, 0xa1, 0x53, 0xbb, 0x0a, 0x23, 0x94, 0xef, 0x03,
	0x78, 0xd6, 0xa5, 0xe9, 0x12, 0x7f, 0x1c, 0x9f, 0xa9, 0xb7, 0xb6, 0xa4, 0x6d, 0xd9, 0x28, 0x7b,
	0xd6, 0xe5, 0x11, 0x63, 0x30, 0xb1, 0xe3, 0xa7, 0x62, 0x24, 0xc4, 0x8e, 0x2f, 0xc4, 0x2a, 0x94,
	0x26, 0x56, 0x4c, 0x7d, 0xa8, 0xde, 0xe6, 0x67, 0x24, 0x48, 0x7a, 0x46, 0x14, 0xd7, 0x89, 0x89,
	0x17, 0xa9, 0x9b, 0xcc, 0x4e, 0xf1, 0xac, 0x4b, 0x8d, 0xd2, 0x4c, 0xe8, 0xf8, 0x42, 0x78, 0x57,
	0x08, 0x1d, 0x9f, 0x0b, 0x3f, 0x82, 0x8d, 0xc4, 0x77, 0xbe, 0x4d, 0x88, 0x90, 0xbf, 0xcf, 0x56,
	0x5e, 0xe1, 0x3c, 0xae, 0xf2, 0x63, 0xa8, 0x51, 0xf0, 0x49, 0x48, 0x2f, 0x84, 0xb1, 0x43, 0x22,
	0x55, 0x65, 0x20, 0x55, 0xcf, 0xba, 0xec, 0xcd, 0x98, 0x4c, 0xcd, 0xf1, 0xb3, 0x6a, 0x1f, 0x08,
	0x35, 0xc7, 0xcf, 0xa8, 0xd5, 0x41, 0x09, 0xf9, 0xad, 0x69, 0xa8, 0xd6, 0xf9, 0x6d, 0x31, 0xa5,
	0x69, 0xf0, 0x58, 0x61, 0x68, 0x4d, 0xd5, 0x06, 0x13, 0x70, 0x02, 0xbf, 0x00, 0x39, 0x9e, 0x4e,
	0x88, 0xfa, 0x23, 0xf6, 0xfe, 0xd5, 0x6e, 0x90, 0xa0, 0x99, 0x61, 0xdf, 0xa1, 0xd1, 0x3c, 0x98,
	0x4e, 0x48, 0x64, 0x30, 0xd8, 0xc6, 0x05, 0xdc, 0x5d, 0x2a, 0x5e, 0x7c, 0x1e, 0x94, 0xa1, 0xd0,
	0x32, 0x8c, 0xd6, 0x73, 0x24, 0x51, 0xfe, 0x5e, 0xb7, 0x7b, 0xd4, 0x6e, 0x75, 0x50, 0x8e, 0x12,
	0x5a, 0x67, 0xd0, 0x3e, 0x6c, 0x1b, 0x28, 0x4f, 0xdf, 0x10, 0x9d, 0xe3, 0xa3, 0x23, 0x24, 0x63,
	0x80, 0x62, 0xe7, 0xf8, 0xd9, 0x5e, 0xdb, 0x40, 0x05, 0x3a, 0xee, 0xee, 0xe9, 0xed, 0xfd, 0x01,
	0x2a, 0xd2, 0x71, 0x7f, 0x60, 0x68, 0x9d, 0x43, 0x54, 0xd2, 0x65, 0x45, 0x42, 0x39, 0x5d, 0x56,
	0x72, 0x28, 0xcf, 0xb3, 0x6b, 0xf6, 0xae, 0xc0, 0xe8, 0x8e, 0x2e, 0x2b, 0x77, 0xd0, 0xa6, 0x2e,
	0x2b, 0x3f, 0x40, 0xaa, 0x2e, 0x2b, 0x1f, 0xa2, 0x7b, 0xba, 0xac, 0xdc, 0x43, 0xf7, 0x75, 0x59,
	0xb9, 0x8f, 0x1e, 0xe8, 0xb2, 0xf2, 0x00, 0x35, 0x74, 0x59, 0xf9, 0x18, 0x3d, 0xd4, 0x65, 0xe5,
	0x21, 0x7a, 0xa4, 0xcb, 0xca, 0x23, 0xd4, 0x6c, 0xfc, 0x59, 0x82, 0xfc, 0xc0, 0x1a, 0xaf, 0xd0,
	0x5f, 0xaf, 0x15, 0x99, 0xfc, 0xdb, 0x2f, 0x32, 0x7c, 0x8b, 0x8d, 0x7f, 0x4b, 0x70, 0x67, 0xc9,
	0x73, 0x1c, 0x8f, 0x32, 0x37, 0x70, 0x89, 0x35, 0x41, 0xfd, 0x4d, 0x9e, 0xf7, 0x33, 0x9e, 0xb8,
	0x88, 0xa5, 0xd8, 0xf5, 0x18, 0xaa, 0x0b, 0xa2, 0x25, 0xdd, 0xf0, 0xd9, 0x62, 0x37, 0xfc, 0xd9,
	0xda, 0xeb, 0x10, 0x5f, 0x57, 0x32, 0xed, 0xf2, 0x3f, 0x45, 0xa8, 0x2d, 0x4a, 0x71, 0x4f, 0x44,
	0x32, 0x9d, 0xb8, 0x76, 0x83, 0xe7, 0x06, 0x87, 0x69, 0xd2, 0xf0, 0xe4, 0xc1, 0xbb, 0x82, 0x9f,
	0xd3, 0x1e, 0x9b, 0xcf, 0xf4, 0x58, 0x1d, 0x72, 0x8e, 0xcf, 0x2e, 0x4b, 0xb5, 0xdd, 0x2f, 0x6e,
	0xba, 0x0a, 0xcd, 0x37, 0x72, 0x8e, 0x4f, 0xf7, 0x34, 0x72, 0x83, 0x0b, 0x56, 0xef, 0xdf, 0x60,
	0x4f, 0x5f, 0xba, 0xc1, 0x85, 0xc1, 0x90, 0x68, 0x45, 0xb5, 0x92, 0xf8, 0x2c, 0x08, 0x9d, 0x3f,
	0xf2, 0x27, 0x29, 0x6d, 0xe1, 0xbc, 0x65, 0xa0, 0x05, 0xc1, 0x71, 0xe8, 0xd2, 0xe2, 0x16, 0x07,
	0x2f, 0x09, 0x57, 0xe2, 0x9d, 0x43, 0x61, 0x0c, 0x2a, 0x64, 0xef, 0x84, 0x60, 0x42, 0x22, 0xd6,
	0x37, 0xd6, 0x7b, 0x27, 0x50, 0x33, 0x43, 0x98, 0xe3, 0xf1, 0xc2, 0x85, 0x8d, 0xbf, 0x63, 0x0f,
	0x6f, 0xba, 0xd5, 0xff, 0xc3, 0xd5, 0xed, 0x29, 0xc8, 0x34, 0x68, 0x30, 0x82, 0x8d, 0xc1, 0xf3,
	0x5e, 0xdb, 0xd4, 0x3a, 0x5f, 0xb5, 0x8e, 0xb4, 0x03, 0xf4, 0x1e, 0xae, 0x01, 0x30, 0xce, 0x5e,
	0xab, 0xaf, 0xed, 0x23, 0x69, 0xa6, 0xd1, 0xea, 0x69, 0xe6, 0xd3, 0xf6, 0x73, 0x94, 0xc3, 0xb7,
	0xa0, 0xc2, 0x38, 0xdd, 0xd6, 0xf1, 0xe0, 0xc9, 0x2e, 0xca, 0x37, 0x3e, 0x85, 0x9c, 0xe6, 0x53,
	0x43, 0xad, 0x93, 0x01, 0xda, 0x00, 0x45, 0xeb, 0x98, 0xbf, 0x3d, 0x6e, 0x1b, 0xb4, 0x46, 0x56,
	0xa1, 0xac, 0x75, 0xcc, 0x27, 0xed, 0xd6, 0x41, 0xdb, 0x40, 0xb9, 0xc6, 0x37, 0x20, 0x53, 0x07,
	0x53, 0xf4, 0x2f, 0x8f, 0xba, 0x27, 0x19, 0xb3, 0xdb, 0x50, 0xe5, 0x9c, 0x67, 0xbd, 0x23, 0x6d,
	0x5f, 0x1b, 0x20, 0x69, 0xc6, 0xea, 0xb5, 0xfa, 0xfd, 0x93, 0xae, 0x71, 0x80, 0x72, 0x78, 0x13,
	0x10, 0x63, 0xb5, 0x7a, 0x54, 0xab, 0x35, 0xd0, 0xba, 0x1d, 0x94, 0x9f, 0x73, 0xf7, 0xf7, 0xdb,
	0xfd, 0xbe, 0xb9, 0xdf, 0x3d, 0x68, 0x23, 0xb9, 0xf1, 0xaf, 0xdc, 0xbc, 0xda, 0x64, 0xde, 0xe7,
	0xf8, 0x4f, 0x52, 0xe6, 0xcb, 0x62, 0x38, 0x17, 0x88, 0xd2, 0x73, 0xfc, 0x26, 0x8f, 0xff, 0x65,
	0x3c, 0xee, 0xdc, 0xd9, 0x27, 0xc7, 0x8c, 0xa4, 0xfe, 0x09, 0xa8, 0x4b, 0x0c, 0x98, 0xd7, 0x68,
	0x0f, 0x64, 0x41, 0x27, 0x3e, 0x21, 0x71, 0xa2, 0xfe, 0x9d, 0xb4, 0xd4, 0xe4, 0x55, 0x11, 0xf2,
	0x72, 0x31, 0x42, 0xde, 0xfa, 0xde, 0xae, 0x05, 0xd8, 0x5f, 0x24, 0x7a, 0xad, 0x66, 0xb9, 0xd2,
	0xcb, 0x6e, 0xa0, 0xb2, 0x4e, 0x7d, 0x61, 0xf6, 0xfc, 0x87, 0x1f, 0x9e, 0xd8, 0xfc, 0xe7, 0x00,
	0x73, 0xe6, 0x3a, 0x4f, 0xdc, 0xbd, 0xfd, 0xdf, 0xb5, 0xc6, 0x4e, 0x7c, 0x96, 0x9c, 0x36, 0xed,
	0xc0, 0xdb, 0xa1, 0x0b, 0x79, 0x4c, 0xec, 0x20, 0x9a, 0x46, 0x31, 0x11, 0xa4, 0x58, 0xd7, 0xce,
	0xab, 0xff, 0x8e, 0x38, 0x2d, 0x32, 0xd9, 0x67, 0xff, 0x0d, 0x00, 0x00, 0xff, 0xff, 0xe3, 0xbc,
	0xdd, 0xdd, 0xb3, 0x18, 0x00, 0x00,
}
