package templatespecs

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VersionsClient is the the APIs listed in this specification can be used to manage Template Spec resources through
// the Azure Resource Manager.
type VersionsClient struct {
	BaseClient
}

// NewVersionsClient creates an instance of the VersionsClient client.
func NewVersionsClient(subscriptionID string) VersionsClient {
	return NewVersionsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVersionsClientWithBaseURI creates an instance of the VersionsClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewVersionsClientWithBaseURI(baseURI string, subscriptionID string) VersionsClient {
	return VersionsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates or updates a Template Spec version.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// templateSpecName - name of the Template Spec.
// templateSpecVersion - the version of the Template Spec.
// templateSpecVersionModel - template Spec Version supplied to the operation.
func (client VersionsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpecVersion string, templateSpecVersionModel VersionTemplatespecs) (result VersionTemplatespecs, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VersionsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: templateSpecName,
			Constraints: []validation.Constraint{{Target: "templateSpecName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "templateSpecName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "templateSpecName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: templateSpecVersion,
			Constraints: []validation.Constraint{{Target: "templateSpecVersion", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "templateSpecVersion", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "templateSpecVersion", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: templateSpecVersionModel,
			Constraints: []validation.Constraint{{Target: "templateSpecVersionModel.Location", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "templateSpecVersionModel.VersionProperties", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "templateSpecVersionModel.VersionProperties.Description", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "templateSpecVersionModel.VersionProperties.Description", Name: validation.MaxLength, Rule: 4096, Chain: nil}}},
					}}}}}); err != nil {
		return result, validation.NewError("templatespecs.VersionsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, templateSpecName, templateSpecVersion, templateSpecVersionModel)
	if err != nil {
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client VersionsClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpecVersion string, templateSpecVersionModel VersionTemplatespecs) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
		"templateSpecName":    autorest.Encode("path", templateSpecName),
		"templateSpecVersion": autorest.Encode("path", templateSpecVersion),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/templateSpecs/{templateSpecName}/versions/{templateSpecVersion}", pathParameters),
		autorest.WithJSON(templateSpecVersionModel),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client VersionsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client VersionsClient) CreateOrUpdateResponder(resp *http.Response) (result VersionTemplatespecs, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a specific version from a Template Spec. When operation completes, status code 200 returned without
// content.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// templateSpecName - name of the Template Spec.
// templateSpecVersion - the version of the Template Spec.
func (client VersionsClient) Delete(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpecVersion string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VersionsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: templateSpecName,
			Constraints: []validation.Constraint{{Target: "templateSpecName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "templateSpecName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "templateSpecName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: templateSpecVersion,
			Constraints: []validation.Constraint{{Target: "templateSpecVersion", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "templateSpecVersion", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "templateSpecVersion", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("templatespecs.VersionsClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, templateSpecName, templateSpecVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client VersionsClient) DeletePreparer(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpecVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
		"templateSpecName":    autorest.Encode("path", templateSpecName),
		"templateSpecVersion": autorest.Encode("path", templateSpecVersion),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/templateSpecs/{templateSpecName}/versions/{templateSpecVersion}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client VersionsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client VersionsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets a Template Spec version from a specific Template Spec.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// templateSpecName - name of the Template Spec.
// templateSpecVersion - the version of the Template Spec.
func (client VersionsClient) Get(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpecVersion string) (result VersionTemplatespecs, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VersionsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: templateSpecName,
			Constraints: []validation.Constraint{{Target: "templateSpecName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "templateSpecName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "templateSpecName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: templateSpecVersion,
			Constraints: []validation.Constraint{{Target: "templateSpecVersion", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "templateSpecVersion", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "templateSpecVersion", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("templatespecs.VersionsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, templateSpecName, templateSpecVersion)
	if err != nil {
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client VersionsClient) GetPreparer(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpecVersion string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
		"templateSpecName":    autorest.Encode("path", templateSpecName),
		"templateSpecVersion": autorest.Encode("path", templateSpecVersion),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/templateSpecs/{templateSpecName}/versions/{templateSpecVersion}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client VersionsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client VersionsClient) GetResponder(resp *http.Response) (result VersionTemplatespecs, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List lists all the Template Spec versions in the specified Template Spec.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// templateSpecName - name of the Template Spec.
func (client VersionsClient) List(ctx context.Context, resourceGroupName string, templateSpecName string) (result VersionsListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VersionsClient.List")
		defer func() {
			sc := -1
			if result.vlr.Response.Response != nil {
				sc = result.vlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: templateSpecName,
			Constraints: []validation.Constraint{{Target: "templateSpecName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "templateSpecName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "templateSpecName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("templatespecs.VersionsClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, resourceGroupName, templateSpecName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.vlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "List", resp, "Failure sending request")
		return
	}

	result.vlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "List", resp, "Failure responding to request")
		return
	}
	if result.vlr.hasNextLink() && result.vlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client VersionsClient) ListPreparer(ctx context.Context, resourceGroupName string, templateSpecName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"templateSpecName":  autorest.Encode("path", templateSpecName),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/templateSpecs/{templateSpecName}/versions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client VersionsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client VersionsClient) ListResponder(resp *http.Response) (result VersionsListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client VersionsClient) listNextResults(ctx context.Context, lastResults VersionsListResult) (result VersionsListResult, err error) {
	req, err := lastResults.versionsListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client VersionsClient) ListComplete(ctx context.Context, resourceGroupName string, templateSpecName string) (result VersionsListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VersionsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, resourceGroupName, templateSpecName)
	return
}

// Update updates Template Spec Version tags with specified values.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// templateSpecName - name of the Template Spec.
// templateSpecVersion - the version of the Template Spec.
// templateSpecVersionUpdateModel - template Spec Version resource with the tags to be updated.
func (client VersionsClient) Update(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpecVersion string, templateSpecVersionUpdateModel *VersionUpdateModel) (result VersionTemplatespecs, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VersionsClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: templateSpecName,
			Constraints: []validation.Constraint{{Target: "templateSpecName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "templateSpecName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "templateSpecName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: templateSpecVersion,
			Constraints: []validation.Constraint{{Target: "templateSpecVersion", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "templateSpecVersion", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "templateSpecVersion", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("templatespecs.VersionsClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, resourceGroupName, templateSpecName, templateSpecVersion, templateSpecVersionUpdateModel)
	if err != nil {
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "templatespecs.VersionsClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client VersionsClient) UpdatePreparer(ctx context.Context, resourceGroupName string, templateSpecName string, templateSpecVersion string, templateSpecVersionUpdateModel *VersionUpdateModel) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":   autorest.Encode("path", resourceGroupName),
		"subscriptionId":      autorest.Encode("path", client.SubscriptionID),
		"templateSpecName":    autorest.Encode("path", templateSpecName),
		"templateSpecVersion": autorest.Encode("path", templateSpecVersion),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/templateSpecs/{templateSpecName}/versions/{templateSpecVersion}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if templateSpecVersionUpdateModel != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(templateSpecVersionUpdateModel))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client VersionsClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client VersionsClient) UpdateResponder(resp *http.Response) (result VersionTemplatespecs, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
