package healthbotapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/healthbot/mgmt/2020-12-08/healthbot"
)

// BotsClientAPI contains the set of methods on the BotsClient type.
type BotsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, botName string, parameters healthbot.HealthBot) (result healthbot.BotsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, botName string) (result healthbot.BotsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, botName string) (result healthbot.HealthBot, err error)
	List(ctx context.Context) (result healthbot.BotResponseListPage, err error)
	ListComplete(ctx context.Context) (result healthbot.BotResponseListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result healthbot.BotResponseListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result healthbot.BotResponseListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, botName string, parameters healthbot.UpdateParameters) (result healthbot.HealthBot, err error)
}

var _ BotsClientAPI = (*healthbot.BotsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result healthbot.AvailableOperationsPage, err error)
	ListComplete(ctx context.Context) (result healthbot.AvailableOperationsIterator, err error)
}

var _ OperationsClientAPI = (*healthbot.OperationsClient)(nil)
