package guestconfiguration

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// HCRPAssignmentReportsClient is the guest Configuration Client
type HCRPAssignmentReportsClient struct {
	BaseClient
}

// NewHCRPAssignmentReportsClient creates an instance of the HCRPAssignmentReportsClient client.
func NewHCRPAssignmentReportsClient(subscriptionID string) HCRPAssignmentReportsClient {
	return NewHCRPAssignmentReportsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewHCRPAssignmentReportsClientWithBaseURI creates an instance of the HCRPAssignmentReportsClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewHCRPAssignmentReportsClientWithBaseURI(baseURI string, subscriptionID string) HCRPAssignmentReportsClient {
	return HCRPAssignmentReportsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get a report for the guest configuration assignment, by reportId.
// Parameters:
// resourceGroupName - the resource group name.
// guestConfigurationAssignmentName - the guest configuration assignment name.
// reportID - the GUID for the guest configuration assignment report.
// machineName - the name of the ARC machine.
func (client HCRPAssignmentReportsClient) Get(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, reportID string, machineName string) (result AssignmentReportType, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HCRPAssignmentReportsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("guestconfiguration.HCRPAssignmentReportsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, guestConfigurationAssignmentName, reportID, machineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentReportsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentReportsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentReportsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client HCRPAssignmentReportsClient) GetPreparer(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, reportID string, machineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"guestConfigurationAssignmentName": autorest.Encode("path", guestConfigurationAssignmentName),
		"machineName":                      autorest.Encode("path", machineName),
		"reportId":                         autorest.Encode("path", reportID),
		"resourceGroupName":                autorest.Encode("path", resourceGroupName),
		"subscriptionId":                   autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-06-25"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/{guestConfigurationAssignmentName}/reports/{reportId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client HCRPAssignmentReportsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client HCRPAssignmentReportsClient) GetResponder(resp *http.Response) (result AssignmentReportType, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List list all reports for the guest configuration assignment, latest report first.
// Parameters:
// resourceGroupName - the resource group name.
// guestConfigurationAssignmentName - the guest configuration assignment name.
// machineName - the name of the ARC machine.
func (client HCRPAssignmentReportsClient) List(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, machineName string) (result AssignmentReportList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HCRPAssignmentReportsClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("guestconfiguration.HCRPAssignmentReportsClient", "List", err.Error())
	}

	req, err := client.ListPreparer(ctx, resourceGroupName, guestConfigurationAssignmentName, machineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentReportsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentReportsClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "guestconfiguration.HCRPAssignmentReportsClient", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client HCRPAssignmentReportsClient) ListPreparer(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, machineName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"guestConfigurationAssignmentName": autorest.Encode("path", guestConfigurationAssignmentName),
		"machineName":                      autorest.Encode("path", machineName),
		"resourceGroupName":                autorest.Encode("path", resourceGroupName),
		"subscriptionId":                   autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-06-25"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/{guestConfigurationAssignmentName}/reports", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client HCRPAssignmentReportsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client HCRPAssignmentReportsClient) ListResponder(resp *http.Response) (result AssignmentReportList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
