package guestconfigurationapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/guestconfiguration/mgmt/2020-06-25/guestconfiguration"
)

// AssignmentsClientAPI contains the set of methods on the AssignmentsClient type.
type AssignmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, guestConfigurationAssignmentName string, parameters guestconfiguration.Assignment, resourceGroupName string, VMName string) (result guestconfiguration.AssignmentsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, VMName string) (result guestconfiguration.AssignmentsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, VMName string) (result guestconfiguration.Assignment, err error)
	List(ctx context.Context, resourceGroupName string, VMName string) (result guestconfiguration.AssignmentList, err error)
}

var _ AssignmentsClientAPI = (*guestconfiguration.AssignmentsClient)(nil)

// AssignmentReportsClientAPI contains the set of methods on the AssignmentReportsClient type.
type AssignmentReportsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, reportID string, VMName string) (result guestconfiguration.AssignmentReportType, err error)
	List(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, VMName string) (result guestconfiguration.AssignmentReportList, err error)
}

var _ AssignmentReportsClientAPI = (*guestconfiguration.AssignmentReportsClient)(nil)

// HCRPAssignmentsClientAPI contains the set of methods on the HCRPAssignmentsClient type.
type HCRPAssignmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, guestConfigurationAssignmentName string, parameters guestconfiguration.Assignment, resourceGroupName string, machineName string) (result guestconfiguration.HCRPAssignmentsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, machineName string) (result guestconfiguration.HCRPAssignmentsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, machineName string) (result guestconfiguration.Assignment, err error)
	List(ctx context.Context, resourceGroupName string, machineName string) (result guestconfiguration.AssignmentList, err error)
}

var _ HCRPAssignmentsClientAPI = (*guestconfiguration.HCRPAssignmentsClient)(nil)

// HCRPAssignmentReportsClientAPI contains the set of methods on the HCRPAssignmentReportsClient type.
type HCRPAssignmentReportsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, reportID string, machineName string) (result guestconfiguration.AssignmentReportType, err error)
	List(ctx context.Context, resourceGroupName string, guestConfigurationAssignmentName string, machineName string) (result guestconfiguration.AssignmentReportList, err error)
}

var _ HCRPAssignmentReportsClientAPI = (*guestconfiguration.HCRPAssignmentReportsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result guestconfiguration.OperationList, err error)
}

var _ OperationsClientAPI = (*guestconfiguration.OperationsClient)(nil)
