package datashare

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ShareSubscriptionsClient is the creates a Microsoft.DataShare management client.
type ShareSubscriptionsClient struct {
	BaseClient
}

// NewShareSubscriptionsClient creates an instance of the ShareSubscriptionsClient client.
func NewShareSubscriptionsClient(subscriptionID string) ShareSubscriptionsClient {
	return NewShareSubscriptionsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewShareSubscriptionsClientWithBaseURI creates an instance of the ShareSubscriptionsClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewShareSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) ShareSubscriptionsClient {
	return ShareSubscriptionsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CancelSynchronization request to cancel a synchronization.
// Parameters:
// resourceGroupName - the resource group name.
// accountName - the name of the share account.
// shareSubscriptionName - the name of the shareSubscription.
// shareSubscriptionSynchronization - share Subscription Synchronization payload.
func (client ShareSubscriptionsClient) CancelSynchronization(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscriptionSynchronization ShareSubscriptionSynchronization) (result ShareSubscriptionsCancelSynchronizationFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.CancelSynchronization")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: shareSubscriptionSynchronization,
			Constraints: []validation.Constraint{{Target: "shareSubscriptionSynchronization.SynchronizationID", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("datashare.ShareSubscriptionsClient", "CancelSynchronization", err.Error())
	}

	req, err := client.CancelSynchronizationPreparer(ctx, resourceGroupName, accountName, shareSubscriptionName, shareSubscriptionSynchronization)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "CancelSynchronization", nil, "Failure preparing request")
		return
	}

	result, err = client.CancelSynchronizationSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "CancelSynchronization", nil, "Failure sending request")
		return
	}

	return
}

// CancelSynchronizationPreparer prepares the CancelSynchronization request.
func (client ShareSubscriptionsClient) CancelSynchronizationPreparer(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscriptionSynchronization ShareSubscriptionSynchronization) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":           autorest.Encode("path", accountName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"shareSubscriptionName": autorest.Encode("path", shareSubscriptionName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	shareSubscriptionSynchronization.DurationMs = nil
	shareSubscriptionSynchronization.EndTime = nil
	shareSubscriptionSynchronization.Message = nil
	shareSubscriptionSynchronization.StartTime = nil
	shareSubscriptionSynchronization.Status = nil
	shareSubscriptionSynchronization.SynchronizationMode = ""
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/cancelSynchronization", pathParameters),
		autorest.WithJSON(shareSubscriptionSynchronization),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CancelSynchronizationSender sends the CancelSynchronization request. The method will close the
// http.Response Body if it receives an error.
func (client ShareSubscriptionsClient) CancelSynchronizationSender(req *http.Request) (future ShareSubscriptionsCancelSynchronizationFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client ShareSubscriptionsClient) (sss ShareSubscriptionSynchronization, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsCancelSynchronizationFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("datashare.ShareSubscriptionsCancelSynchronizationFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		if sss.Response.Response, err = future.GetResult(sender); err == nil && sss.Response.Response.StatusCode != http.StatusNoContent {
			sss, err = client.CancelSynchronizationResponder(sss.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsCancelSynchronizationFuture", "Result", sss.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// CancelSynchronizationResponder handles the response to the CancelSynchronization request. The method always
// closes the http.Response Body.
func (client ShareSubscriptionsClient) CancelSynchronizationResponder(resp *http.Response) (result ShareSubscriptionSynchronization, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Create create a shareSubscription in an account
// Parameters:
// resourceGroupName - the resource group name.
// accountName - the name of the share account.
// shareSubscriptionName - the name of the shareSubscription.
// shareSubscription - create parameters for shareSubscription
func (client ShareSubscriptionsClient) Create(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscription ShareSubscription) (result ShareSubscription, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.Create")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: shareSubscription,
			Constraints: []validation.Constraint{{Target: "shareSubscription.ShareSubscriptionProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "shareSubscription.ShareSubscriptionProperties.InvitationID", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "shareSubscription.ShareSubscriptionProperties.SourceShareLocation", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("datashare.ShareSubscriptionsClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, resourceGroupName, accountName, shareSubscriptionName, shareSubscription)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "Create", resp, "Failure responding to request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client ShareSubscriptionsClient) CreatePreparer(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscription ShareSubscription) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":           autorest.Encode("path", accountName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"shareSubscriptionName": autorest.Encode("path", shareSubscriptionName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}", pathParameters),
		autorest.WithJSON(shareSubscription),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client ShareSubscriptionsClient) CreateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client ShareSubscriptionsClient) CreateResponder(resp *http.Response) (result ShareSubscription, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete a shareSubscription in an account
// Parameters:
// resourceGroupName - the resource group name.
// accountName - the name of the share account.
// shareSubscriptionName - the name of the shareSubscription.
func (client ShareSubscriptionsClient) Delete(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string) (result ShareSubscriptionsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.Delete")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, resourceGroupName, accountName, shareSubscriptionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "Delete", nil, "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ShareSubscriptionsClient) DeletePreparer(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":           autorest.Encode("path", accountName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"shareSubscriptionName": autorest.Encode("path", shareSubscriptionName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ShareSubscriptionsClient) DeleteSender(req *http.Request) (future ShareSubscriptionsDeleteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client ShareSubscriptionsClient) (or OperationResponse, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsDeleteFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("datashare.ShareSubscriptionsDeleteFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		if or.Response.Response, err = future.GetResult(sender); err == nil && or.Response.Response.StatusCode != http.StatusNoContent {
			or, err = client.DeleteResponder(or.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsDeleteFuture", "Result", or.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ShareSubscriptionsClient) DeleteResponder(resp *http.Response) (result OperationResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get get a shareSubscription in an account
// Parameters:
// resourceGroupName - the resource group name.
// accountName - the name of the share account.
// shareSubscriptionName - the name of the shareSubscription.
func (client ShareSubscriptionsClient) Get(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string) (result ShareSubscription, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, accountName, shareSubscriptionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client ShareSubscriptionsClient) GetPreparer(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":           autorest.Encode("path", accountName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"shareSubscriptionName": autorest.Encode("path", shareSubscriptionName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ShareSubscriptionsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ShareSubscriptionsClient) GetResponder(resp *http.Response) (result ShareSubscription, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByAccount list share subscriptions in an account
// Parameters:
// resourceGroupName - the resource group name.
// accountName - the name of the share account.
// skipToken - continuation Token
// filter - filters the results using OData syntax.
// orderby - sorts the results using OData syntax.
func (client ShareSubscriptionsClient) ListByAccount(ctx context.Context, resourceGroupName string, accountName string, skipToken string, filter string, orderby string) (result ShareSubscriptionListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.ListByAccount")
		defer func() {
			sc := -1
			if result.ssl.Response.Response != nil {
				sc = result.ssl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByAccountNextResults
	req, err := client.ListByAccountPreparer(ctx, resourceGroupName, accountName, skipToken, filter, orderby)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "ListByAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByAccountSender(req)
	if err != nil {
		result.ssl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "ListByAccount", resp, "Failure sending request")
		return
	}

	result.ssl, err = client.ListByAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "ListByAccount", resp, "Failure responding to request")
		return
	}
	if result.ssl.hasNextLink() && result.ssl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByAccountPreparer prepares the ListByAccount request.
func (client ShareSubscriptionsClient) ListByAccountPreparer(ctx context.Context, resourceGroupName string, accountName string, skipToken string, filter string, orderby string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByAccountSender sends the ListByAccount request. The method will close the
// http.Response Body if it receives an error.
func (client ShareSubscriptionsClient) ListByAccountSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByAccountResponder handles the response to the ListByAccount request. The method always
// closes the http.Response Body.
func (client ShareSubscriptionsClient) ListByAccountResponder(resp *http.Response) (result ShareSubscriptionList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByAccountNextResults retrieves the next set of results, if any.
func (client ShareSubscriptionsClient) listByAccountNextResults(ctx context.Context, lastResults ShareSubscriptionList) (result ShareSubscriptionList, err error) {
	req, err := lastResults.shareSubscriptionListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "listByAccountNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "listByAccountNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "listByAccountNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByAccountComplete enumerates all values, automatically crossing page boundaries as required.
func (client ShareSubscriptionsClient) ListByAccountComplete(ctx context.Context, resourceGroupName string, accountName string, skipToken string, filter string, orderby string) (result ShareSubscriptionListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.ListByAccount")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByAccount(ctx, resourceGroupName, accountName, skipToken, filter, orderby)
	return
}

// ListSourceShareSynchronizationSettings get synchronization settings set on a share
// Parameters:
// resourceGroupName - the resource group name.
// accountName - the name of the share account.
// shareSubscriptionName - the name of the shareSubscription.
// skipToken - continuation token
func (client ShareSubscriptionsClient) ListSourceShareSynchronizationSettings(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, skipToken string) (result SourceShareSynchronizationSettingListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.ListSourceShareSynchronizationSettings")
		defer func() {
			sc := -1
			if result.ssssl.Response.Response != nil {
				sc = result.ssssl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listSourceShareSynchronizationSettingsNextResults
	req, err := client.ListSourceShareSynchronizationSettingsPreparer(ctx, resourceGroupName, accountName, shareSubscriptionName, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "ListSourceShareSynchronizationSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSourceShareSynchronizationSettingsSender(req)
	if err != nil {
		result.ssssl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "ListSourceShareSynchronizationSettings", resp, "Failure sending request")
		return
	}

	result.ssssl, err = client.ListSourceShareSynchronizationSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "ListSourceShareSynchronizationSettings", resp, "Failure responding to request")
		return
	}
	if result.ssssl.hasNextLink() && result.ssssl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListSourceShareSynchronizationSettingsPreparer prepares the ListSourceShareSynchronizationSettings request.
func (client ShareSubscriptionsClient) ListSourceShareSynchronizationSettingsPreparer(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":           autorest.Encode("path", accountName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"shareSubscriptionName": autorest.Encode("path", shareSubscriptionName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/listSourceShareSynchronizationSettings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSourceShareSynchronizationSettingsSender sends the ListSourceShareSynchronizationSettings request. The method will close the
// http.Response Body if it receives an error.
func (client ShareSubscriptionsClient) ListSourceShareSynchronizationSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSourceShareSynchronizationSettingsResponder handles the response to the ListSourceShareSynchronizationSettings request. The method always
// closes the http.Response Body.
func (client ShareSubscriptionsClient) ListSourceShareSynchronizationSettingsResponder(resp *http.Response) (result SourceShareSynchronizationSettingList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSourceShareSynchronizationSettingsNextResults retrieves the next set of results, if any.
func (client ShareSubscriptionsClient) listSourceShareSynchronizationSettingsNextResults(ctx context.Context, lastResults SourceShareSynchronizationSettingList) (result SourceShareSynchronizationSettingList, err error) {
	req, err := lastResults.sourceShareSynchronizationSettingListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "listSourceShareSynchronizationSettingsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSourceShareSynchronizationSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "listSourceShareSynchronizationSettingsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSourceShareSynchronizationSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "listSourceShareSynchronizationSettingsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSourceShareSynchronizationSettingsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ShareSubscriptionsClient) ListSourceShareSynchronizationSettingsComplete(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, skipToken string) (result SourceShareSynchronizationSettingListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.ListSourceShareSynchronizationSettings")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSourceShareSynchronizationSettings(ctx, resourceGroupName, accountName, shareSubscriptionName, skipToken)
	return
}

// ListSynchronizationDetails list synchronization details
// Parameters:
// resourceGroupName - the resource group name.
// accountName - the name of the share account.
// shareSubscriptionName - the name of the share subscription.
// shareSubscriptionSynchronization - share Subscription Synchronization payload.
// skipToken - continuation token
// filter - filters the results using OData syntax.
// orderby - sorts the results using OData syntax.
func (client ShareSubscriptionsClient) ListSynchronizationDetails(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscriptionSynchronization ShareSubscriptionSynchronization, skipToken string, filter string, orderby string) (result SynchronizationDetailsListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.ListSynchronizationDetails")
		defer func() {
			sc := -1
			if result.sdl.Response.Response != nil {
				sc = result.sdl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: shareSubscriptionSynchronization,
			Constraints: []validation.Constraint{{Target: "shareSubscriptionSynchronization.SynchronizationID", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("datashare.ShareSubscriptionsClient", "ListSynchronizationDetails", err.Error())
	}

	result.fn = client.listSynchronizationDetailsNextResults
	req, err := client.ListSynchronizationDetailsPreparer(ctx, resourceGroupName, accountName, shareSubscriptionName, shareSubscriptionSynchronization, skipToken, filter, orderby)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "ListSynchronizationDetails", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSynchronizationDetailsSender(req)
	if err != nil {
		result.sdl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "ListSynchronizationDetails", resp, "Failure sending request")
		return
	}

	result.sdl, err = client.ListSynchronizationDetailsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "ListSynchronizationDetails", resp, "Failure responding to request")
		return
	}
	if result.sdl.hasNextLink() && result.sdl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListSynchronizationDetailsPreparer prepares the ListSynchronizationDetails request.
func (client ShareSubscriptionsClient) ListSynchronizationDetailsPreparer(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscriptionSynchronization ShareSubscriptionSynchronization, skipToken string, filter string, orderby string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":           autorest.Encode("path", accountName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"shareSubscriptionName": autorest.Encode("path", shareSubscriptionName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}

	shareSubscriptionSynchronization.DurationMs = nil
	shareSubscriptionSynchronization.EndTime = nil
	shareSubscriptionSynchronization.Message = nil
	shareSubscriptionSynchronization.StartTime = nil
	shareSubscriptionSynchronization.Status = nil
	shareSubscriptionSynchronization.SynchronizationMode = ""
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/listSynchronizationDetails", pathParameters),
		autorest.WithJSON(shareSubscriptionSynchronization),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSynchronizationDetailsSender sends the ListSynchronizationDetails request. The method will close the
// http.Response Body if it receives an error.
func (client ShareSubscriptionsClient) ListSynchronizationDetailsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSynchronizationDetailsResponder handles the response to the ListSynchronizationDetails request. The method always
// closes the http.Response Body.
func (client ShareSubscriptionsClient) ListSynchronizationDetailsResponder(resp *http.Response) (result SynchronizationDetailsList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSynchronizationDetailsNextResults retrieves the next set of results, if any.
func (client ShareSubscriptionsClient) listSynchronizationDetailsNextResults(ctx context.Context, lastResults SynchronizationDetailsList) (result SynchronizationDetailsList, err error) {
	req, err := lastResults.synchronizationDetailsListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "listSynchronizationDetailsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSynchronizationDetailsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "listSynchronizationDetailsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSynchronizationDetailsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "listSynchronizationDetailsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSynchronizationDetailsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ShareSubscriptionsClient) ListSynchronizationDetailsComplete(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, shareSubscriptionSynchronization ShareSubscriptionSynchronization, skipToken string, filter string, orderby string) (result SynchronizationDetailsListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.ListSynchronizationDetails")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSynchronizationDetails(ctx, resourceGroupName, accountName, shareSubscriptionName, shareSubscriptionSynchronization, skipToken, filter, orderby)
	return
}

// ListSynchronizations list synchronizations of a share subscription
// Parameters:
// resourceGroupName - the resource group name.
// accountName - the name of the share account.
// shareSubscriptionName - the name of the share subscription.
// skipToken - continuation token
// filter - filters the results using OData syntax.
// orderby - sorts the results using OData syntax.
func (client ShareSubscriptionsClient) ListSynchronizations(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, skipToken string, filter string, orderby string) (result ShareSubscriptionSynchronizationListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.ListSynchronizations")
		defer func() {
			sc := -1
			if result.sssl.Response.Response != nil {
				sc = result.sssl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listSynchronizationsNextResults
	req, err := client.ListSynchronizationsPreparer(ctx, resourceGroupName, accountName, shareSubscriptionName, skipToken, filter, orderby)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "ListSynchronizations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSynchronizationsSender(req)
	if err != nil {
		result.sssl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "ListSynchronizations", resp, "Failure sending request")
		return
	}

	result.sssl, err = client.ListSynchronizationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "ListSynchronizations", resp, "Failure responding to request")
		return
	}
	if result.sssl.hasNextLink() && result.sssl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListSynchronizationsPreparer prepares the ListSynchronizations request.
func (client ShareSubscriptionsClient) ListSynchronizationsPreparer(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, skipToken string, filter string, orderby string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":           autorest.Encode("path", accountName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"shareSubscriptionName": autorest.Encode("path", shareSubscriptionName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/listSynchronizations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSynchronizationsSender sends the ListSynchronizations request. The method will close the
// http.Response Body if it receives an error.
func (client ShareSubscriptionsClient) ListSynchronizationsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSynchronizationsResponder handles the response to the ListSynchronizations request. The method always
// closes the http.Response Body.
func (client ShareSubscriptionsClient) ListSynchronizationsResponder(resp *http.Response) (result ShareSubscriptionSynchronizationList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSynchronizationsNextResults retrieves the next set of results, if any.
func (client ShareSubscriptionsClient) listSynchronizationsNextResults(ctx context.Context, lastResults ShareSubscriptionSynchronizationList) (result ShareSubscriptionSynchronizationList, err error) {
	req, err := lastResults.shareSubscriptionSynchronizationListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "listSynchronizationsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSynchronizationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "listSynchronizationsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSynchronizationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "listSynchronizationsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSynchronizationsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ShareSubscriptionsClient) ListSynchronizationsComplete(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, skipToken string, filter string, orderby string) (result ShareSubscriptionSynchronizationListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.ListSynchronizations")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSynchronizations(ctx, resourceGroupName, accountName, shareSubscriptionName, skipToken, filter, orderby)
	return
}

// SynchronizeMethod initiate a copy
// Parameters:
// resourceGroupName - the resource group name.
// accountName - the name of the share account.
// shareSubscriptionName - the name of share subscription
// synchronize - synchronize payload
func (client ShareSubscriptionsClient) SynchronizeMethod(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, synchronize Synchronize) (result ShareSubscriptionsSynchronizeMethodFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ShareSubscriptionsClient.SynchronizeMethod")
		defer func() {
			sc := -1
			if result.Response() != nil {
				sc = result.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SynchronizeMethodPreparer(ctx, resourceGroupName, accountName, shareSubscriptionName, synchronize)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "SynchronizeMethod", nil, "Failure preparing request")
		return
	}

	result, err = client.SynchronizeMethodSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsClient", "SynchronizeMethod", nil, "Failure sending request")
		return
	}

	return
}

// SynchronizeMethodPreparer prepares the SynchronizeMethod request.
func (client ShareSubscriptionsClient) SynchronizeMethodPreparer(ctx context.Context, resourceGroupName string, accountName string, shareSubscriptionName string, synchronize Synchronize) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":           autorest.Encode("path", accountName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"shareSubscriptionName": autorest.Encode("path", shareSubscriptionName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-11-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/Synchronize", pathParameters),
		autorest.WithJSON(synchronize),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SynchronizeMethodSender sends the SynchronizeMethod request. The method will close the
// http.Response Body if it receives an error.
func (client ShareSubscriptionsClient) SynchronizeMethodSender(req *http.Request) (future ShareSubscriptionsSynchronizeMethodFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client ShareSubscriptionsClient) (sss ShareSubscriptionSynchronization, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsSynchronizeMethodFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("datashare.ShareSubscriptionsSynchronizeMethodFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		if sss.Response.Response, err = future.GetResult(sender); err == nil && sss.Response.Response.StatusCode != http.StatusNoContent {
			sss, err = client.SynchronizeMethodResponder(sss.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "datashare.ShareSubscriptionsSynchronizeMethodFuture", "Result", sss.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// SynchronizeMethodResponder handles the response to the SynchronizeMethod request. The method always
// closes the http.Response Body.
func (client ShareSubscriptionsClient) SynchronizeMethodResponder(resp *http.Response) (result ShareSubscriptionSynchronization, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
