package communicationapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/communication/mgmt/2020-08-20-preview/communication"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result communication.OperationListPage, err error)
	ListComplete(ctx context.Context) (result communication.OperationListIterator, err error)
}

var _ OperationsClientAPI = (*communication.OperationsClient)(nil)

// ServiceClientAPI contains the set of methods on the ServiceClient type.
type ServiceClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, communicationServiceName string, parameters *communication.ServiceResource) (result communication.ServiceCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, communicationServiceName string) (result communication.ServiceDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, communicationServiceName string) (result communication.ServiceResource, err error)
	LinkNotificationHub(ctx context.Context, resourceGroupName string, communicationServiceName string, linkNotificationHubParameters *communication.LinkNotificationHubParameters) (result communication.LinkedNotificationHub, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result communication.ServiceResourceListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result communication.ServiceResourceListIterator, err error)
	ListBySubscription(ctx context.Context) (result communication.ServiceResourceListPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result communication.ServiceResourceListIterator, err error)
	ListKeys(ctx context.Context, resourceGroupName string, communicationServiceName string) (result communication.ServiceKeys, err error)
	RegenerateKey(ctx context.Context, resourceGroupName string, communicationServiceName string, parameters *communication.RegenerateKeyParameters) (result communication.ServiceKeys, err error)
	Update(ctx context.Context, resourceGroupName string, communicationServiceName string, parameters *communication.TaggedResource) (result communication.ServiceResource, err error)
}

var _ ServiceClientAPI = (*communication.ServiceClient)(nil)

// OperationStatusesClientAPI contains the set of methods on the OperationStatusesClient type.
type OperationStatusesClientAPI interface {
	Get(ctx context.Context, location string, operationID string) (result communication.OperationStatus, err error)
}

var _ OperationStatusesClientAPI = (*communication.OperationStatusesClient)(nil)
