// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package policy

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2020-03-01-preview/policy"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type CreatedByType = original.CreatedByType

const (
	Application     CreatedByType = original.Application
	Key             CreatedByType = original.Key
	ManagedIdentity CreatedByType = original.ManagedIdentity
	User            CreatedByType = original.User
)

type EnforcementMode = original.EnforcementMode

const (
	Default      EnforcementMode = original.Default
	DoNotEnforce EnforcementMode = original.DoNotEnforce
)

type ExemptionCategory = original.ExemptionCategory

const (
	Mitigated ExemptionCategory = original.Mitigated
	Waiver    ExemptionCategory = original.Waiver
)

type ParameterType = original.ParameterType

const (
	Array    ParameterType = original.Array
	Boolean  ParameterType = original.Boolean
	DateTime ParameterType = original.DateTime
	Float    ParameterType = original.Float
	Integer  ParameterType = original.Integer
	Object   ParameterType = original.Object
	String   ParameterType = original.String
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	None           ResourceIdentityType = original.None
	SystemAssigned ResourceIdentityType = original.SystemAssigned
)

type Type = original.Type

const (
	BuiltIn      Type = original.BuiltIn
	Custom       Type = original.Custom
	NotSpecified Type = original.NotSpecified
	Static       Type = original.Static
)

type Assignment = original.Assignment
type AssignmentListResult = original.AssignmentListResult
type AssignmentListResultIterator = original.AssignmentListResultIterator
type AssignmentListResultPage = original.AssignmentListResultPage
type AssignmentProperties = original.AssignmentProperties
type AssignmentsClient = original.AssignmentsClient
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type CloudError = original.CloudError
type CloudErrorError = original.CloudErrorError
type Definition = original.Definition
type DefinitionGroup = original.DefinitionGroup
type DefinitionListResult = original.DefinitionListResult
type DefinitionListResultIterator = original.DefinitionListResultIterator
type DefinitionListResultPage = original.DefinitionListResultPage
type DefinitionProperties = original.DefinitionProperties
type DefinitionReference = original.DefinitionReference
type DefinitionsClient = original.DefinitionsClient
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type Exemption = original.Exemption
type ExemptionListResult = original.ExemptionListResult
type ExemptionListResultIterator = original.ExemptionListResultIterator
type ExemptionListResultPage = original.ExemptionListResultPage
type ExemptionProperties = original.ExemptionProperties
type ExemptionsClient = original.ExemptionsClient
type Identity = original.Identity
type ParameterDefinitionsValue = original.ParameterDefinitionsValue
type ParameterDefinitionsValueMetadata = original.ParameterDefinitionsValueMetadata
type ParameterValuesValue = original.ParameterValuesValue
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type SetDefinition = original.SetDefinition
type SetDefinitionListResult = original.SetDefinitionListResult
type SetDefinitionListResultIterator = original.SetDefinitionListResultIterator
type SetDefinitionListResultPage = original.SetDefinitionListResultPage
type SetDefinitionProperties = original.SetDefinitionProperties
type SetDefinitionsClient = original.SetDefinitionsClient
type Sku = original.Sku
type SystemData = original.SystemData
type TrackedResource = original.TrackedResource

func New() BaseClient {
	return original.New()
}
func NewAssignmentListResultIterator(page AssignmentListResultPage) AssignmentListResultIterator {
	return original.NewAssignmentListResultIterator(page)
}
func NewAssignmentListResultPage(getNextPage func(context.Context, AssignmentListResult) (AssignmentListResult, error)) AssignmentListResultPage {
	return original.NewAssignmentListResultPage(getNextPage)
}
func NewAssignmentsClient() AssignmentsClient {
	return original.NewAssignmentsClient()
}
func NewAssignmentsClientWithBaseURI(baseURI string) AssignmentsClient {
	return original.NewAssignmentsClientWithBaseURI(baseURI)
}
func NewDefinitionListResultIterator(page DefinitionListResultPage) DefinitionListResultIterator {
	return original.NewDefinitionListResultIterator(page)
}
func NewDefinitionListResultPage(getNextPage func(context.Context, DefinitionListResult) (DefinitionListResult, error)) DefinitionListResultPage {
	return original.NewDefinitionListResultPage(getNextPage)
}
func NewDefinitionsClient() DefinitionsClient {
	return original.NewDefinitionsClient()
}
func NewDefinitionsClientWithBaseURI(baseURI string) DefinitionsClient {
	return original.NewDefinitionsClientWithBaseURI(baseURI)
}
func NewExemptionListResultIterator(page ExemptionListResultPage) ExemptionListResultIterator {
	return original.NewExemptionListResultIterator(page)
}
func NewExemptionListResultPage(getNextPage func(context.Context, ExemptionListResult) (ExemptionListResult, error)) ExemptionListResultPage {
	return original.NewExemptionListResultPage(getNextPage)
}
func NewExemptionsClient() ExemptionsClient {
	return original.NewExemptionsClient()
}
func NewExemptionsClientWithBaseURI(baseURI string) ExemptionsClient {
	return original.NewExemptionsClientWithBaseURI(baseURI)
}
func NewSetDefinitionListResultIterator(page SetDefinitionListResultPage) SetDefinitionListResultIterator {
	return original.NewSetDefinitionListResultIterator(page)
}
func NewSetDefinitionListResultPage(getNextPage func(context.Context, SetDefinitionListResult) (SetDefinitionListResult, error)) SetDefinitionListResultPage {
	return original.NewSetDefinitionListResultPage(getNextPage)
}
func NewSetDefinitionsClient() SetDefinitionsClient {
	return original.NewSetDefinitionsClient()
}
func NewSetDefinitionsClientWithBaseURI(baseURI string) SetDefinitionsClient {
	return original.NewSetDefinitionsClientWithBaseURI(baseURI)
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleEnforcementModeValues() []EnforcementMode {
	return original.PossibleEnforcementModeValues()
}
func PossibleExemptionCategoryValues() []ExemptionCategory {
	return original.PossibleExemptionCategoryValues()
}
func PossibleParameterTypeValues() []ParameterType {
	return original.PossibleParameterTypeValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
