// Code generated by protoc-gen-go. DO NOT EDIT.
// source: protoc-gen-swagger/options/openapiv2.proto

package options // import "github.com/grpc-ecosystem/grpc-gateway/protoc-gen-swagger/options"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import any "github.com/golang/protobuf/ptypes/any"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Swagger_SwaggerScheme int32

const (
	Swagger_UNKNOWN Swagger_SwaggerScheme = 0
	Swagger_HTTP    Swagger_SwaggerScheme = 1
	Swagger_HTTPS   Swagger_SwaggerScheme = 2
	Swagger_WS      Swagger_SwaggerScheme = 3
	Swagger_WSS     Swagger_SwaggerScheme = 4
)

var Swagger_SwaggerScheme_name = map[int32]string{
	0: "UNKNOWN",
	1: "HTTP",
	2: "HTTPS",
	3: "WS",
	4: "WSS",
}
var Swagger_SwaggerScheme_value = map[string]int32{
	"UNKNOWN": 0,
	"HTTP":    1,
	"HTTPS":   2,
	"WS":      3,
	"WSS":     4,
}

func (x Swagger_SwaggerScheme) String() string {
	return proto.EnumName(Swagger_SwaggerScheme_name, int32(x))
}
func (Swagger_SwaggerScheme) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{0, 0}
}

type JSONSchema_JSONSchemaSimpleTypes int32

const (
	JSONSchema_UNKNOWN JSONSchema_JSONSchemaSimpleTypes = 0
	JSONSchema_ARRAY   JSONSchema_JSONSchemaSimpleTypes = 1
	JSONSchema_BOOLEAN JSONSchema_JSONSchemaSimpleTypes = 2
	JSONSchema_INTEGER JSONSchema_JSONSchemaSimpleTypes = 3
	JSONSchema_NULL    JSONSchema_JSONSchemaSimpleTypes = 4
	JSONSchema_NUMBER  JSONSchema_JSONSchemaSimpleTypes = 5
	JSONSchema_OBJECT  JSONSchema_JSONSchemaSimpleTypes = 6
	JSONSchema_STRING  JSONSchema_JSONSchemaSimpleTypes = 7
)

var JSONSchema_JSONSchemaSimpleTypes_name = map[int32]string{
	0: "UNKNOWN",
	1: "ARRAY",
	2: "BOOLEAN",
	3: "INTEGER",
	4: "NULL",
	5: "NUMBER",
	6: "OBJECT",
	7: "STRING",
}
var JSONSchema_JSONSchemaSimpleTypes_value = map[string]int32{
	"UNKNOWN": 0,
	"ARRAY":   1,
	"BOOLEAN": 2,
	"INTEGER": 3,
	"NULL":    4,
	"NUMBER":  5,
	"OBJECT":  6,
	"STRING":  7,
}

func (x JSONSchema_JSONSchemaSimpleTypes) String() string {
	return proto.EnumName(JSONSchema_JSONSchemaSimpleTypes_name, int32(x))
}
func (JSONSchema_JSONSchemaSimpleTypes) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{6, 0}
}

// Required. The type of the security scheme. Valid values are "basic",
// "apiKey" or "oauth2".
type SecurityScheme_Type int32

const (
	SecurityScheme_TYPE_INVALID SecurityScheme_Type = 0
	SecurityScheme_TYPE_BASIC   SecurityScheme_Type = 1
	SecurityScheme_TYPE_API_KEY SecurityScheme_Type = 2
	SecurityScheme_TYPE_OAUTH2  SecurityScheme_Type = 3
)

var SecurityScheme_Type_name = map[int32]string{
	0: "TYPE_INVALID",
	1: "TYPE_BASIC",
	2: "TYPE_API_KEY",
	3: "TYPE_OAUTH2",
}
var SecurityScheme_Type_value = map[string]int32{
	"TYPE_INVALID": 0,
	"TYPE_BASIC":   1,
	"TYPE_API_KEY": 2,
	"TYPE_OAUTH2":  3,
}

func (x SecurityScheme_Type) String() string {
	return proto.EnumName(SecurityScheme_Type_name, int32(x))
}
func (SecurityScheme_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{9, 0}
}

// Required. The location of the API key. Valid values are "query" or "header".
type SecurityScheme_In int32

const (
	SecurityScheme_IN_INVALID SecurityScheme_In = 0
	SecurityScheme_IN_QUERY   SecurityScheme_In = 1
	SecurityScheme_IN_HEADER  SecurityScheme_In = 2
)

var SecurityScheme_In_name = map[int32]string{
	0: "IN_INVALID",
	1: "IN_QUERY",
	2: "IN_HEADER",
}
var SecurityScheme_In_value = map[string]int32{
	"IN_INVALID": 0,
	"IN_QUERY":   1,
	"IN_HEADER":  2,
}

func (x SecurityScheme_In) String() string {
	return proto.EnumName(SecurityScheme_In_name, int32(x))
}
func (SecurityScheme_In) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{9, 1}
}

// Required. The flow used by the OAuth2 security scheme. Valid values are
// "implicit", "password", "application" or "accessCode".
type SecurityScheme_Flow int32

const (
	SecurityScheme_FLOW_INVALID     SecurityScheme_Flow = 0
	SecurityScheme_FLOW_IMPLICIT    SecurityScheme_Flow = 1
	SecurityScheme_FLOW_PASSWORD    SecurityScheme_Flow = 2
	SecurityScheme_FLOW_APPLICATION SecurityScheme_Flow = 3
	SecurityScheme_FLOW_ACCESS_CODE SecurityScheme_Flow = 4
)

var SecurityScheme_Flow_name = map[int32]string{
	0: "FLOW_INVALID",
	1: "FLOW_IMPLICIT",
	2: "FLOW_PASSWORD",
	3: "FLOW_APPLICATION",
	4: "FLOW_ACCESS_CODE",
}
var SecurityScheme_Flow_value = map[string]int32{
	"FLOW_INVALID":     0,
	"FLOW_IMPLICIT":    1,
	"FLOW_PASSWORD":    2,
	"FLOW_APPLICATION": 3,
	"FLOW_ACCESS_CODE": 4,
}

func (x SecurityScheme_Flow) String() string {
	return proto.EnumName(SecurityScheme_Flow_name, int32(x))
}
func (SecurityScheme_Flow) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{9, 2}
}

// `Swagger` is a representation of OpenAPI v2 specification's Swagger object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#swaggerObject
//
// TODO(ivucica): document fields
type Swagger struct {
	Swagger              string                  `protobuf:"bytes,1,opt,name=swagger" json:"swagger,omitempty"`
	Info                 *Info                   `protobuf:"bytes,2,opt,name=info" json:"info,omitempty"`
	Host                 string                  `protobuf:"bytes,3,opt,name=host" json:"host,omitempty"`
	BasePath             string                  `protobuf:"bytes,4,opt,name=base_path,json=basePath" json:"base_path,omitempty"`
	Schemes              []Swagger_SwaggerScheme `protobuf:"varint,5,rep,packed,name=schemes,enum=grpc.gateway.protoc_gen_swagger.options.Swagger_SwaggerScheme" json:"schemes,omitempty"`
	Consumes             []string                `protobuf:"bytes,6,rep,name=consumes" json:"consumes,omitempty"`
	Produces             []string                `protobuf:"bytes,7,rep,name=produces" json:"produces,omitempty"`
	SecurityDefinitions  *SecurityDefinitions    `protobuf:"bytes,11,opt,name=security_definitions,json=securityDefinitions" json:"security_definitions,omitempty"`
	Security             []*SecurityRequirement  `protobuf:"bytes,12,rep,name=security" json:"security,omitempty"`
	ExternalDocs         *ExternalDocumentation  `protobuf:"bytes,14,opt,name=external_docs,json=externalDocs" json:"external_docs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Swagger) Reset()         { *m = Swagger{} }
func (m *Swagger) String() string { return proto.CompactTextString(m) }
func (*Swagger) ProtoMessage()    {}
func (*Swagger) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{0}
}
func (m *Swagger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Swagger.Unmarshal(m, b)
}
func (m *Swagger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Swagger.Marshal(b, m, deterministic)
}
func (dst *Swagger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Swagger.Merge(dst, src)
}
func (m *Swagger) XXX_Size() int {
	return xxx_messageInfo_Swagger.Size(m)
}
func (m *Swagger) XXX_DiscardUnknown() {
	xxx_messageInfo_Swagger.DiscardUnknown(m)
}

var xxx_messageInfo_Swagger proto.InternalMessageInfo

func (m *Swagger) GetSwagger() string {
	if m != nil {
		return m.Swagger
	}
	return ""
}

func (m *Swagger) GetInfo() *Info {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Swagger) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Swagger) GetBasePath() string {
	if m != nil {
		return m.BasePath
	}
	return ""
}

func (m *Swagger) GetSchemes() []Swagger_SwaggerScheme {
	if m != nil {
		return m.Schemes
	}
	return nil
}

func (m *Swagger) GetConsumes() []string {
	if m != nil {
		return m.Consumes
	}
	return nil
}

func (m *Swagger) GetProduces() []string {
	if m != nil {
		return m.Produces
	}
	return nil
}

func (m *Swagger) GetSecurityDefinitions() *SecurityDefinitions {
	if m != nil {
		return m.SecurityDefinitions
	}
	return nil
}

func (m *Swagger) GetSecurity() []*SecurityRequirement {
	if m != nil {
		return m.Security
	}
	return nil
}

func (m *Swagger) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

// `Operation` is a representation of OpenAPI v2 specification's Operation object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#operationObject
//
// TODO(ivucica): document fields
type Operation struct {
	Tags                 []string               `protobuf:"bytes,1,rep,name=tags" json:"tags,omitempty"`
	Summary              string                 `protobuf:"bytes,2,opt,name=summary" json:"summary,omitempty"`
	Description          string                 `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	ExternalDocs         *ExternalDocumentation `protobuf:"bytes,4,opt,name=external_docs,json=externalDocs" json:"external_docs,omitempty"`
	OperationId          string                 `protobuf:"bytes,5,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	Consumes             []string               `protobuf:"bytes,6,rep,name=consumes" json:"consumes,omitempty"`
	Produces             []string               `protobuf:"bytes,7,rep,name=produces" json:"produces,omitempty"`
	Schemes              []string               `protobuf:"bytes,10,rep,name=schemes" json:"schemes,omitempty"`
	Deprecated           bool                   `protobuf:"varint,11,opt,name=deprecated" json:"deprecated,omitempty"`
	Security             []*SecurityRequirement `protobuf:"bytes,12,rep,name=security" json:"security,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Operation) Reset()         { *m = Operation{} }
func (m *Operation) String() string { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()    {}
func (*Operation) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{1}
}
func (m *Operation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Operation.Unmarshal(m, b)
}
func (m *Operation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Operation.Marshal(b, m, deterministic)
}
func (dst *Operation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Operation.Merge(dst, src)
}
func (m *Operation) XXX_Size() int {
	return xxx_messageInfo_Operation.Size(m)
}
func (m *Operation) XXX_DiscardUnknown() {
	xxx_messageInfo_Operation.DiscardUnknown(m)
}

var xxx_messageInfo_Operation proto.InternalMessageInfo

func (m *Operation) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Operation) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

func (m *Operation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Operation) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

func (m *Operation) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *Operation) GetConsumes() []string {
	if m != nil {
		return m.Consumes
	}
	return nil
}

func (m *Operation) GetProduces() []string {
	if m != nil {
		return m.Produces
	}
	return nil
}

func (m *Operation) GetSchemes() []string {
	if m != nil {
		return m.Schemes
	}
	return nil
}

func (m *Operation) GetDeprecated() bool {
	if m != nil {
		return m.Deprecated
	}
	return false
}

func (m *Operation) GetSecurity() []*SecurityRequirement {
	if m != nil {
		return m.Security
	}
	return nil
}

// `Info` is a representation of OpenAPI v2 specification's Info object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#infoObject
//
// TODO(ivucica): document fields
type Info struct {
	Title                string   `protobuf:"bytes,1,opt,name=title" json:"title,omitempty"`
	Description          string   `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	TermsOfService       string   `protobuf:"bytes,3,opt,name=terms_of_service,json=termsOfService" json:"terms_of_service,omitempty"`
	Contact              *Contact `protobuf:"bytes,4,opt,name=contact" json:"contact,omitempty"`
	Version              string   `protobuf:"bytes,6,opt,name=version" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Info) Reset()         { *m = Info{} }
func (m *Info) String() string { return proto.CompactTextString(m) }
func (*Info) ProtoMessage()    {}
func (*Info) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{2}
}
func (m *Info) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Info.Unmarshal(m, b)
}
func (m *Info) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Info.Marshal(b, m, deterministic)
}
func (dst *Info) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Info.Merge(dst, src)
}
func (m *Info) XXX_Size() int {
	return xxx_messageInfo_Info.Size(m)
}
func (m *Info) XXX_DiscardUnknown() {
	xxx_messageInfo_Info.DiscardUnknown(m)
}

var xxx_messageInfo_Info proto.InternalMessageInfo

func (m *Info) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Info) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Info) GetTermsOfService() string {
	if m != nil {
		return m.TermsOfService
	}
	return ""
}

func (m *Info) GetContact() *Contact {
	if m != nil {
		return m.Contact
	}
	return nil
}

func (m *Info) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

// `Contact` is a representation of OpenAPI v2 specification's Contact object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#contactObject
//
// TODO(ivucica): document fields
type Contact struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Url                  string   `protobuf:"bytes,2,opt,name=url" json:"url,omitempty"`
	Email                string   `protobuf:"bytes,3,opt,name=email" json:"email,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Contact) Reset()         { *m = Contact{} }
func (m *Contact) String() string { return proto.CompactTextString(m) }
func (*Contact) ProtoMessage()    {}
func (*Contact) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{3}
}
func (m *Contact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Contact.Unmarshal(m, b)
}
func (m *Contact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Contact.Marshal(b, m, deterministic)
}
func (dst *Contact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Contact.Merge(dst, src)
}
func (m *Contact) XXX_Size() int {
	return xxx_messageInfo_Contact.Size(m)
}
func (m *Contact) XXX_DiscardUnknown() {
	xxx_messageInfo_Contact.DiscardUnknown(m)
}

var xxx_messageInfo_Contact proto.InternalMessageInfo

func (m *Contact) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Contact) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Contact) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

// `ExternalDocumentation` is a representation of OpenAPI v2 specification's
// ExternalDocumentation object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#externalDocumentationObject
//
// TODO(ivucica): document fields
type ExternalDocumentation struct {
	Description          string   `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
	Url                  string   `protobuf:"bytes,2,opt,name=url" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExternalDocumentation) Reset()         { *m = ExternalDocumentation{} }
func (m *ExternalDocumentation) String() string { return proto.CompactTextString(m) }
func (*ExternalDocumentation) ProtoMessage()    {}
func (*ExternalDocumentation) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{4}
}
func (m *ExternalDocumentation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExternalDocumentation.Unmarshal(m, b)
}
func (m *ExternalDocumentation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExternalDocumentation.Marshal(b, m, deterministic)
}
func (dst *ExternalDocumentation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalDocumentation.Merge(dst, src)
}
func (m *ExternalDocumentation) XXX_Size() int {
	return xxx_messageInfo_ExternalDocumentation.Size(m)
}
func (m *ExternalDocumentation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalDocumentation.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalDocumentation proto.InternalMessageInfo

func (m *ExternalDocumentation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ExternalDocumentation) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// `Schema` is a representation of OpenAPI v2 specification's Schema object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject
//
// TODO(ivucica): document fields
type Schema struct {
	JsonSchema           *JSONSchema            `protobuf:"bytes,1,opt,name=json_schema,json=jsonSchema" json:"json_schema,omitempty"`
	Discriminator        string                 `protobuf:"bytes,2,opt,name=discriminator" json:"discriminator,omitempty"`
	ReadOnly             bool                   `protobuf:"varint,3,opt,name=read_only,json=readOnly" json:"read_only,omitempty"`
	ExternalDocs         *ExternalDocumentation `protobuf:"bytes,5,opt,name=external_docs,json=externalDocs" json:"external_docs,omitempty"`
	Example              *any.Any               `protobuf:"bytes,6,opt,name=example" json:"example,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Schema) Reset()         { *m = Schema{} }
func (m *Schema) String() string { return proto.CompactTextString(m) }
func (*Schema) ProtoMessage()    {}
func (*Schema) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{5}
}
func (m *Schema) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Schema.Unmarshal(m, b)
}
func (m *Schema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Schema.Marshal(b, m, deterministic)
}
func (dst *Schema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Schema.Merge(dst, src)
}
func (m *Schema) XXX_Size() int {
	return xxx_messageInfo_Schema.Size(m)
}
func (m *Schema) XXX_DiscardUnknown() {
	xxx_messageInfo_Schema.DiscardUnknown(m)
}

var xxx_messageInfo_Schema proto.InternalMessageInfo

func (m *Schema) GetJsonSchema() *JSONSchema {
	if m != nil {
		return m.JsonSchema
	}
	return nil
}

func (m *Schema) GetDiscriminator() string {
	if m != nil {
		return m.Discriminator
	}
	return ""
}

func (m *Schema) GetReadOnly() bool {
	if m != nil {
		return m.ReadOnly
	}
	return false
}

func (m *Schema) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

func (m *Schema) GetExample() *any.Any {
	if m != nil {
		return m.Example
	}
	return nil
}

// `JSONSchema` represents properties from JSON Schema taken, and as used, in
// the OpenAPI v2 spec.
//
// This includes changes made by OpenAPI v2.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#schemaObject
//
// See also: https://cswr.github.io/JsonSchema/spec/basic_types/,
// https://github.com/json-schema-org/json-schema-spec/blob/master/schema.json
//
// TODO(ivucica): document fields
type JSONSchema struct {
	Title            string   `protobuf:"bytes,5,opt,name=title" json:"title,omitempty"`
	Description      string   `protobuf:"bytes,6,opt,name=description" json:"description,omitempty"`
	Default          string   `protobuf:"bytes,7,opt,name=default" json:"default,omitempty"`
	MultipleOf       float64  `protobuf:"fixed64,10,opt,name=multiple_of,json=multipleOf" json:"multiple_of,omitempty"`
	Maximum          float64  `protobuf:"fixed64,11,opt,name=maximum" json:"maximum,omitempty"`
	ExclusiveMaximum bool     `protobuf:"varint,12,opt,name=exclusive_maximum,json=exclusiveMaximum" json:"exclusive_maximum,omitempty"`
	Minimum          float64  `protobuf:"fixed64,13,opt,name=minimum" json:"minimum,omitempty"`
	ExclusiveMinimum bool     `protobuf:"varint,14,opt,name=exclusive_minimum,json=exclusiveMinimum" json:"exclusive_minimum,omitempty"`
	MaxLength        uint64   `protobuf:"varint,15,opt,name=max_length,json=maxLength" json:"max_length,omitempty"`
	MinLength        uint64   `protobuf:"varint,16,opt,name=min_length,json=minLength" json:"min_length,omitempty"`
	Pattern          string   `protobuf:"bytes,17,opt,name=pattern" json:"pattern,omitempty"`
	MaxItems         uint64   `protobuf:"varint,20,opt,name=max_items,json=maxItems" json:"max_items,omitempty"`
	MinItems         uint64   `protobuf:"varint,21,opt,name=min_items,json=minItems" json:"min_items,omitempty"`
	UniqueItems      bool     `protobuf:"varint,22,opt,name=unique_items,json=uniqueItems" json:"unique_items,omitempty"`
	MaxProperties    uint64   `protobuf:"varint,24,opt,name=max_properties,json=maxProperties" json:"max_properties,omitempty"`
	MinProperties    uint64   `protobuf:"varint,25,opt,name=min_properties,json=minProperties" json:"min_properties,omitempty"`
	Required         []string `protobuf:"bytes,26,rep,name=required" json:"required,omitempty"`
	// Items in 'array' must be unique.
	Array                []string                           `protobuf:"bytes,34,rep,name=array" json:"array,omitempty"`
	Type                 []JSONSchema_JSONSchemaSimpleTypes `protobuf:"varint,35,rep,packed,name=type,enum=grpc.gateway.protoc_gen_swagger.options.JSONSchema_JSONSchemaSimpleTypes" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *JSONSchema) Reset()         { *m = JSONSchema{} }
func (m *JSONSchema) String() string { return proto.CompactTextString(m) }
func (*JSONSchema) ProtoMessage()    {}
func (*JSONSchema) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{6}
}
func (m *JSONSchema) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JSONSchema.Unmarshal(m, b)
}
func (m *JSONSchema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JSONSchema.Marshal(b, m, deterministic)
}
func (dst *JSONSchema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JSONSchema.Merge(dst, src)
}
func (m *JSONSchema) XXX_Size() int {
	return xxx_messageInfo_JSONSchema.Size(m)
}
func (m *JSONSchema) XXX_DiscardUnknown() {
	xxx_messageInfo_JSONSchema.DiscardUnknown(m)
}

var xxx_messageInfo_JSONSchema proto.InternalMessageInfo

func (m *JSONSchema) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *JSONSchema) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *JSONSchema) GetDefault() string {
	if m != nil {
		return m.Default
	}
	return ""
}

func (m *JSONSchema) GetMultipleOf() float64 {
	if m != nil {
		return m.MultipleOf
	}
	return 0
}

func (m *JSONSchema) GetMaximum() float64 {
	if m != nil {
		return m.Maximum
	}
	return 0
}

func (m *JSONSchema) GetExclusiveMaximum() bool {
	if m != nil {
		return m.ExclusiveMaximum
	}
	return false
}

func (m *JSONSchema) GetMinimum() float64 {
	if m != nil {
		return m.Minimum
	}
	return 0
}

func (m *JSONSchema) GetExclusiveMinimum() bool {
	if m != nil {
		return m.ExclusiveMinimum
	}
	return false
}

func (m *JSONSchema) GetMaxLength() uint64 {
	if m != nil {
		return m.MaxLength
	}
	return 0
}

func (m *JSONSchema) GetMinLength() uint64 {
	if m != nil {
		return m.MinLength
	}
	return 0
}

func (m *JSONSchema) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

func (m *JSONSchema) GetMaxItems() uint64 {
	if m != nil {
		return m.MaxItems
	}
	return 0
}

func (m *JSONSchema) GetMinItems() uint64 {
	if m != nil {
		return m.MinItems
	}
	return 0
}

func (m *JSONSchema) GetUniqueItems() bool {
	if m != nil {
		return m.UniqueItems
	}
	return false
}

func (m *JSONSchema) GetMaxProperties() uint64 {
	if m != nil {
		return m.MaxProperties
	}
	return 0
}

func (m *JSONSchema) GetMinProperties() uint64 {
	if m != nil {
		return m.MinProperties
	}
	return 0
}

func (m *JSONSchema) GetRequired() []string {
	if m != nil {
		return m.Required
	}
	return nil
}

func (m *JSONSchema) GetArray() []string {
	if m != nil {
		return m.Array
	}
	return nil
}

func (m *JSONSchema) GetType() []JSONSchema_JSONSchemaSimpleTypes {
	if m != nil {
		return m.Type
	}
	return nil
}

// `Tag` is a representation of OpenAPI v2 specification's Tag object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#tagObject
//
// TODO(ivucica): document fields
type Tag struct {
	// TODO(ivucica): Description should be extracted from comments on the proto
	// service object.
	Description          string                 `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	ExternalDocs         *ExternalDocumentation `protobuf:"bytes,3,opt,name=external_docs,json=externalDocs" json:"external_docs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Tag) Reset()         { *m = Tag{} }
func (m *Tag) String() string { return proto.CompactTextString(m) }
func (*Tag) ProtoMessage()    {}
func (*Tag) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{7}
}
func (m *Tag) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Tag.Unmarshal(m, b)
}
func (m *Tag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Tag.Marshal(b, m, deterministic)
}
func (dst *Tag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tag.Merge(dst, src)
}
func (m *Tag) XXX_Size() int {
	return xxx_messageInfo_Tag.Size(m)
}
func (m *Tag) XXX_DiscardUnknown() {
	xxx_messageInfo_Tag.DiscardUnknown(m)
}

var xxx_messageInfo_Tag proto.InternalMessageInfo

func (m *Tag) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Tag) GetExternalDocs() *ExternalDocumentation {
	if m != nil {
		return m.ExternalDocs
	}
	return nil
}

// `SecurityDefinitions` is a representation of OpenAPI v2 specification's
// Security Definitions object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securityDefinitionsObject
//
// A declaration of the security schemes available to be used in the
// specification. This does not enforce the security schemes on the operations
// and only serves to provide the relevant details for each scheme.
type SecurityDefinitions struct {
	// A single security scheme definition, mapping a "name" to the scheme it defines.
	Security             map[string]*SecurityScheme `protobuf:"bytes,1,rep,name=security" json:"security,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *SecurityDefinitions) Reset()         { *m = SecurityDefinitions{} }
func (m *SecurityDefinitions) String() string { return proto.CompactTextString(m) }
func (*SecurityDefinitions) ProtoMessage()    {}
func (*SecurityDefinitions) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{8}
}
func (m *SecurityDefinitions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityDefinitions.Unmarshal(m, b)
}
func (m *SecurityDefinitions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityDefinitions.Marshal(b, m, deterministic)
}
func (dst *SecurityDefinitions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityDefinitions.Merge(dst, src)
}
func (m *SecurityDefinitions) XXX_Size() int {
	return xxx_messageInfo_SecurityDefinitions.Size(m)
}
func (m *SecurityDefinitions) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityDefinitions.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityDefinitions proto.InternalMessageInfo

func (m *SecurityDefinitions) GetSecurity() map[string]*SecurityScheme {
	if m != nil {
		return m.Security
	}
	return nil
}

// `SecurityScheme` is a representation of OpenAPI v2 specification's
// Security Scheme object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securitySchemeObject
//
// Allows the definition of a security scheme that can be used by the
// operations. Supported schemes are basic authentication, an API key (either as
// a header or as a query parameter) and OAuth2's common flows (implicit,
// password, application and access code).
type SecurityScheme struct {
	// Required. The type of the security scheme. Valid values are "basic",
	// "apiKey" or "oauth2".
	Type SecurityScheme_Type `protobuf:"varint,1,opt,name=type,enum=grpc.gateway.protoc_gen_swagger.options.SecurityScheme_Type" json:"type,omitempty"`
	// A short description for security scheme.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// Required. The name of the header or query parameter to be used.
	//
	// Valid for apiKey.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// Required. The location of the API key. Valid values are "query" or "header".
	//
	// Valid for apiKey.
	In SecurityScheme_In `protobuf:"varint,4,opt,name=in,enum=grpc.gateway.protoc_gen_swagger.options.SecurityScheme_In" json:"in,omitempty"`
	// Required. The flow used by the OAuth2 security scheme. Valid values are
	// "implicit", "password", "application" or "accessCode".
	//
	// Valid for oauth2.
	Flow SecurityScheme_Flow `protobuf:"varint,5,opt,name=flow,enum=grpc.gateway.protoc_gen_swagger.options.SecurityScheme_Flow" json:"flow,omitempty"`
	// Required. The authorization URL to be used for this flow. This SHOULD be in
	// the form of a URL.
	//
	// Valid for oauth2/implicit and oauth2/accessCode.
	AuthorizationUrl string `protobuf:"bytes,6,opt,name=authorization_url,json=authorizationUrl" json:"authorization_url,omitempty"`
	// Required. The token URL to be used for this flow. This SHOULD be in the
	// form of a URL.
	//
	// Valid for oauth2/password, oauth2/application and oauth2/accessCode.
	TokenUrl string `protobuf:"bytes,7,opt,name=token_url,json=tokenUrl" json:"token_url,omitempty"`
	// Required. The available scopes for the OAuth2 security scheme.
	//
	// Valid for oauth2.
	Scopes               *Scopes  `protobuf:"bytes,8,opt,name=scopes" json:"scopes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SecurityScheme) Reset()         { *m = SecurityScheme{} }
func (m *SecurityScheme) String() string { return proto.CompactTextString(m) }
func (*SecurityScheme) ProtoMessage()    {}
func (*SecurityScheme) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{9}
}
func (m *SecurityScheme) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityScheme.Unmarshal(m, b)
}
func (m *SecurityScheme) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityScheme.Marshal(b, m, deterministic)
}
func (dst *SecurityScheme) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityScheme.Merge(dst, src)
}
func (m *SecurityScheme) XXX_Size() int {
	return xxx_messageInfo_SecurityScheme.Size(m)
}
func (m *SecurityScheme) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityScheme.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityScheme proto.InternalMessageInfo

func (m *SecurityScheme) GetType() SecurityScheme_Type {
	if m != nil {
		return m.Type
	}
	return SecurityScheme_TYPE_INVALID
}

func (m *SecurityScheme) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *SecurityScheme) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SecurityScheme) GetIn() SecurityScheme_In {
	if m != nil {
		return m.In
	}
	return SecurityScheme_IN_INVALID
}

func (m *SecurityScheme) GetFlow() SecurityScheme_Flow {
	if m != nil {
		return m.Flow
	}
	return SecurityScheme_FLOW_INVALID
}

func (m *SecurityScheme) GetAuthorizationUrl() string {
	if m != nil {
		return m.AuthorizationUrl
	}
	return ""
}

func (m *SecurityScheme) GetTokenUrl() string {
	if m != nil {
		return m.TokenUrl
	}
	return ""
}

func (m *SecurityScheme) GetScopes() *Scopes {
	if m != nil {
		return m.Scopes
	}
	return nil
}

// `SecurityRequirement` is a representation of OpenAPI v2 specification's
// Security Requirement object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#securityRequirementObject
//
// Lists the required security schemes to execute this operation. The object can
// have multiple security schemes declared in it which are all required (that
// is, there is a logical AND between the schemes).
//
// The name used for each property MUST correspond to a security scheme
// declared in the Security Definitions.
type SecurityRequirement struct {
	// Each name must correspond to a security scheme which is declared in
	// the Security Definitions. If the security scheme is of type "oauth2",
	// then the value is a list of scope names required for the execution.
	// For other security scheme types, the array MUST be empty.
	SecurityRequirement  map[string]*SecurityRequirement_SecurityRequirementValue `protobuf:"bytes,1,rep,name=security_requirement,json=securityRequirement" json:"security_requirement,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}                                                 `json:"-"`
	XXX_unrecognized     []byte                                                   `json:"-"`
	XXX_sizecache        int32                                                    `json:"-"`
}

func (m *SecurityRequirement) Reset()         { *m = SecurityRequirement{} }
func (m *SecurityRequirement) String() string { return proto.CompactTextString(m) }
func (*SecurityRequirement) ProtoMessage()    {}
func (*SecurityRequirement) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{10}
}
func (m *SecurityRequirement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityRequirement.Unmarshal(m, b)
}
func (m *SecurityRequirement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityRequirement.Marshal(b, m, deterministic)
}
func (dst *SecurityRequirement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityRequirement.Merge(dst, src)
}
func (m *SecurityRequirement) XXX_Size() int {
	return xxx_messageInfo_SecurityRequirement.Size(m)
}
func (m *SecurityRequirement) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityRequirement.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityRequirement proto.InternalMessageInfo

func (m *SecurityRequirement) GetSecurityRequirement() map[string]*SecurityRequirement_SecurityRequirementValue {
	if m != nil {
		return m.SecurityRequirement
	}
	return nil
}

// If the security scheme is of type "oauth2", then the value is a list of
// scope names required for the execution. For other security scheme types,
// the array MUST be empty.
type SecurityRequirement_SecurityRequirementValue struct {
	Scope                []string `protobuf:"bytes,1,rep,name=scope" json:"scope,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SecurityRequirement_SecurityRequirementValue) Reset() {
	*m = SecurityRequirement_SecurityRequirementValue{}
}
func (m *SecurityRequirement_SecurityRequirementValue) String() string {
	return proto.CompactTextString(m)
}
func (*SecurityRequirement_SecurityRequirementValue) ProtoMessage() {}
func (*SecurityRequirement_SecurityRequirementValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{10, 0}
}
func (m *SecurityRequirement_SecurityRequirementValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.Unmarshal(m, b)
}
func (m *SecurityRequirement_SecurityRequirementValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.Marshal(b, m, deterministic)
}
func (dst *SecurityRequirement_SecurityRequirementValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.Merge(dst, src)
}
func (m *SecurityRequirement_SecurityRequirementValue) XXX_Size() int {
	return xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.Size(m)
}
func (m *SecurityRequirement_SecurityRequirementValue) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityRequirement_SecurityRequirementValue.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityRequirement_SecurityRequirementValue proto.InternalMessageInfo

func (m *SecurityRequirement_SecurityRequirementValue) GetScope() []string {
	if m != nil {
		return m.Scope
	}
	return nil
}

// `Scopes` is a representation of OpenAPI v2 specification's Scopes object.
//
// See: https://github.com/OAI/OpenAPI-Specification/blob/3.0.0/versions/2.0.md#scopesObject
//
// Lists the available scopes for an OAuth2 security scheme.
type Scopes struct {
	// Maps between a name of a scope to a short description of it (as the value
	// of the property).
	Scope                map[string]string `protobuf:"bytes,1,rep,name=scope" json:"scope,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Scopes) Reset()         { *m = Scopes{} }
func (m *Scopes) String() string { return proto.CompactTextString(m) }
func (*Scopes) ProtoMessage()    {}
func (*Scopes) Descriptor() ([]byte, []int) {
	return fileDescriptor_openapiv2_4346354ad6fc20e0, []int{11}
}
func (m *Scopes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Scopes.Unmarshal(m, b)
}
func (m *Scopes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Scopes.Marshal(b, m, deterministic)
}
func (dst *Scopes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Scopes.Merge(dst, src)
}
func (m *Scopes) XXX_Size() int {
	return xxx_messageInfo_Scopes.Size(m)
}
func (m *Scopes) XXX_DiscardUnknown() {
	xxx_messageInfo_Scopes.DiscardUnknown(m)
}

var xxx_messageInfo_Scopes proto.InternalMessageInfo

func (m *Scopes) GetScope() map[string]string {
	if m != nil {
		return m.Scope
	}
	return nil
}

func init() {
	proto.RegisterType((*Swagger)(nil), "grpc.gateway.protoc_gen_swagger.options.Swagger")
	proto.RegisterType((*Operation)(nil), "grpc.gateway.protoc_gen_swagger.options.Operation")
	proto.RegisterType((*Info)(nil), "grpc.gateway.protoc_gen_swagger.options.Info")
	proto.RegisterType((*Contact)(nil), "grpc.gateway.protoc_gen_swagger.options.Contact")
	proto.RegisterType((*ExternalDocumentation)(nil), "grpc.gateway.protoc_gen_swagger.options.ExternalDocumentation")
	proto.RegisterType((*Schema)(nil), "grpc.gateway.protoc_gen_swagger.options.Schema")
	proto.RegisterType((*JSONSchema)(nil), "grpc.gateway.protoc_gen_swagger.options.JSONSchema")
	proto.RegisterType((*Tag)(nil), "grpc.gateway.protoc_gen_swagger.options.Tag")
	proto.RegisterType((*SecurityDefinitions)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityDefinitions")
	proto.RegisterMapType((map[string]*SecurityScheme)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityDefinitions.SecurityEntry")
	proto.RegisterType((*SecurityScheme)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityScheme")
	proto.RegisterType((*SecurityRequirement)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityRequirement")
	proto.RegisterMapType((map[string]*SecurityRequirement_SecurityRequirementValue)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityRequirement.SecurityRequirementEntry")
	proto.RegisterType((*SecurityRequirement_SecurityRequirementValue)(nil), "grpc.gateway.protoc_gen_swagger.options.SecurityRequirement.SecurityRequirementValue")
	proto.RegisterType((*Scopes)(nil), "grpc.gateway.protoc_gen_swagger.options.Scopes")
	proto.RegisterMapType((map[string]string)(nil), "grpc.gateway.protoc_gen_swagger.options.Scopes.ScopeEntry")
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.Swagger_SwaggerScheme", Swagger_SwaggerScheme_name, Swagger_SwaggerScheme_value)
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.JSONSchema_JSONSchemaSimpleTypes", JSONSchema_JSONSchemaSimpleTypes_name, JSONSchema_JSONSchemaSimpleTypes_value)
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.SecurityScheme_Type", SecurityScheme_Type_name, SecurityScheme_Type_value)
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.SecurityScheme_In", SecurityScheme_In_name, SecurityScheme_In_value)
	proto.RegisterEnum("grpc.gateway.protoc_gen_swagger.options.SecurityScheme_Flow", SecurityScheme_Flow_name, SecurityScheme_Flow_value)
}

func init() {
	proto.RegisterFile("protoc-gen-swagger/options/openapiv2.proto", fileDescriptor_openapiv2_4346354ad6fc20e0)
}

var fileDescriptor_openapiv2_4346354ad6fc20e0 = []byte{
	// 1664 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0x5b, 0x73, 0xdb, 0xc6,
	0x15, 0x0e, 0xc8, 0x25, 0x09, 0x1e, 0x4a, 0xcc, 0x7a, 0x2d, 0xb7, 0x88, 0x12, 0xbb, 0x0a, 0x9a,
	0x4e, 0x35, 0xf6, 0x98, 0x4a, 0x95, 0x87, 0x66, 0x32, 0x9d, 0xce, 0x50, 0x12, 0x63, 0x03, 0x96,
	0x49, 0x16, 0xa4, 0xa2, 0xb8, 0x33, 0x1d, 0xcc, 0x1a, 0x5c, 0x52, 0x88, 0x71, 0x61, 0x70, 0x91,
	0xc4, 0xfe, 0x82, 0x3e, 0x77, 0xfa, 0xda, 0x9f, 0xd1, 0xa7, 0xf6, 0x67, 0xf4, 0x97, 0xb4, 0x6f,
	0x7d, 0xea, 0xec, 0x05, 0x24, 0x74, 0x49, 0x86, 0x91, 0xed, 0x27, 0xee, 0xf9, 0xce, 0x65, 0xf7,
	0x5c, 0xf6, 0x9c, 0x05, 0xe1, 0xf1, 0x3c, 0x89, 0xb3, 0xd8, 0x7b, 0x3a, 0x63, 0xd1, 0xd3, 0xf4,
	0x82, 0xce, 0x66, 0x2c, 0xd9, 0x8b, 0xe7, 0x99, 0x1f, 0x47, 0xe9, 0x5e, 0x3c, 0x67, 0x11, 0x9d,
	0xfb, 0xe7, 0xfb, 0x1d, 0x21, 0x44, 0x7e, 0x3d, 0x4b, 0xe6, 0x5e, 0x67, 0x46, 0x33, 0x76, 0x41,
	0x17, 0x12, 0xf3, 0xdc, 0x19, 0x8b, 0x5c, 0xa5, 0xd8, 0x51, 0x8a, 0xdb, 0x1f, 0xcd, 0xe2, 0x78,
	0x16, 0xb0, 0x3d, 0x21, 0xf2, 0x3a, 0x9f, 0xee, 0xd1, 0x48, 0xc9, 0x9b, 0xff, 0xa8, 0x41, 0x63,
	0x24, 0xc5, 0x89, 0x01, 0x0d, 0xa5, 0x69, 0x68, 0x3b, 0xda, 0x6e, 0xd3, 0x29, 0x48, 0xd2, 0x05,
	0xe4, 0x47, 0xd3, 0xd8, 0xa8, 0xec, 0x68, 0xbb, 0xad, 0xfd, 0xa7, 0x9d, 0x35, 0x37, 0xee, 0x58,
	0xd1, 0x34, 0x76, 0x84, 0x2a, 0x21, 0x80, 0xce, 0xe2, 0x34, 0x33, 0xaa, 0xc2, 0xb2, 0x58, 0x93,
	0x8f, 0xa1, 0xf9, 0x9a, 0xa6, 0xcc, 0x9d, 0xd3, 0xec, 0xcc, 0x40, 0x82, 0xa1, 0x73, 0x60, 0x48,
	0xb3, 0x33, 0xf2, 0x2d, 0x34, 0x52, 0xef, 0x8c, 0x85, 0x2c, 0x35, 0x6a, 0x3b, 0xd5, 0xdd, 0xf6,
	0xfe, 0xef, 0xd7, 0xde, 0x56, 0x39, 0x54, 0xfc, 0x8e, 0x84, 0x19, 0xa7, 0x30, 0x47, 0xb6, 0x41,
	0xf7, 0xe2, 0x28, 0xcd, 0xb9, 0xe9, 0xfa, 0x4e, 0x95, 0xef, 0x5a, 0xd0, 0x9c, 0x37, 0x4f, 0xe2,
	0x49, 0xee, 0xb1, 0xd4, 0x68, 0x48, 0x5e, 0x41, 0x93, 0x18, 0xb6, 0x52, 0xe6, 0xe5, 0x89, 0x9f,
	0x2d, 0xdc, 0x09, 0x9b, 0xfa, 0x91, 0x2f, 0xb6, 0x33, 0x5a, 0x22, 0x2a, 0xbf, 0x5b, 0xff, 0x78,
	0xca, 0xc8, 0xd1, 0xca, 0x86, 0x73, 0x3f, 0xbd, 0x09, 0x92, 0x6f, 0x41, 0x2f, 0x60, 0x63, 0x63,
	0xa7, 0x7a, 0xa7, 0x4d, 0x1c, 0xf6, 0x7d, 0xee, 0x27, 0x2c, 0x64, 0x51, 0xe6, 0x2c, 0xad, 0x11,
	0x0f, 0x36, 0xd9, 0x65, 0xc6, 0x92, 0x88, 0x06, 0xee, 0x24, 0xf6, 0x52, 0xa3, 0x2d, 0x7c, 0x58,
	0x3f, 0xc4, 0x3d, 0xa5, 0x7d, 0x14, 0x7b, 0x39, 0xb7, 0x4d, 0x39, 0xec, 0x6c, 0xb0, 0x15, 0x9c,
	0x9a, 0x07, 0xb0, 0x79, 0x25, 0x03, 0xa4, 0x05, 0x8d, 0x93, 0xfe, 0x8b, 0xfe, 0xe0, 0xb4, 0x8f,
	0x3f, 0x20, 0x3a, 0xa0, 0xe7, 0xe3, 0xf1, 0x10, 0x6b, 0xa4, 0x09, 0x35, 0xbe, 0x1a, 0xe1, 0x0a,
	0xa9, 0x43, 0xe5, 0x74, 0x84, 0xab, 0xa4, 0x01, 0xd5, 0xd3, 0xd1, 0x08, 0x23, 0x1b, 0xe9, 0x3a,
	0x6e, 0xda, 0x48, 0x6f, 0x62, 0xb0, 0x91, 0x0e, 0xb8, 0x65, 0x23, 0x7d, 0x13, 0xb7, 0xcd, 0x7f,
	0x56, 0xa1, 0x39, 0x98, 0xb3, 0x44, 0xec, 0xcb, 0x8b, 0x2b, 0xa3, 0xb3, 0xd4, 0xd0, 0x44, 0xc6,
	0xc4, 0x5a, 0x54, 0x73, 0x1e, 0x86, 0x34, 0x59, 0x88, 0xb2, 0xe5, 0xd5, 0x2c, 0x49, 0xb2, 0x03,
	0xad, 0x09, 0x4b, 0xbd, 0xc4, 0x17, 0xbe, 0xa8, 0x8a, 0x2c, 0x43, 0x37, 0xc3, 0x83, 0xde, 0x7d,
	0x78, 0xc8, 0xa7, 0xb0, 0x11, 0x17, 0x1e, 0xb8, 0xfe, 0xc4, 0xa8, 0xc9, 0x73, 0x2c, 0x31, 0x6b,
	0x72, 0xe7, 0x4a, 0x35, 0x56, 0x77, 0x07, 0x04, 0x6b, 0x59, 0xfb, 0x8f, 0x00, 0x26, 0x6c, 0x9e,
	0x30, 0x8f, 0x66, 0x6c, 0x22, 0x2a, 0x57, 0x77, 0x4a, 0xc8, 0xfb, 0x2b, 0xb9, 0x72, 0x26, 0xcd,
	0x7f, 0x6b, 0x80, 0x78, 0x6f, 0x20, 0x5b, 0x50, 0xcb, 0xfc, 0x2c, 0x60, 0xaa, 0xe1, 0x48, 0xe2,
	0x7a, 0x82, 0x2a, 0x37, 0x13, 0xb4, 0x0b, 0x38, 0x63, 0x49, 0x98, 0xba, 0xf1, 0xd4, 0x4d, 0x59,
	0x72, 0xee, 0x7b, 0x4c, 0xe5, 0xb1, 0x2d, 0xf0, 0xc1, 0x74, 0x24, 0x51, 0x62, 0x43, 0xc3, 0x8b,
	0xa3, 0x8c, 0x7a, 0x99, 0x4a, 0xe2, 0xe7, 0x6b, 0xfb, 0x73, 0x28, 0xf5, 0x9c, 0xc2, 0x00, 0x0f,
	0xeb, 0x39, 0x4b, 0x52, 0x7e, 0xa6, 0xba, 0x2c, 0x29, 0x45, 0xda, 0x48, 0xaf, 0xe1, 0xba, 0xd9,
	0x83, 0x86, 0xd2, 0xe1, 0x15, 0x19, 0xd1, 0xb0, 0xf0, 0x4b, 0xac, 0x09, 0x86, 0x6a, 0x9e, 0x04,
	0xca, 0x1d, 0xbe, 0xe4, 0xee, 0xb3, 0x90, 0xfa, 0x81, 0x3a, 0xbb, 0x24, 0xcc, 0x17, 0xf0, 0xe0,
	0xd6, 0xfa, 0xb9, 0x1e, 0x17, 0xed, 0x66, 0x5c, 0x6e, 0x6c, 0x61, 0xfe, 0xab, 0x02, 0x75, 0x71,
	0xfd, 0x28, 0x19, 0x43, 0xeb, 0xbb, 0x34, 0x8e, 0x5c, 0x51, 0x0b, 0x54, 0xa8, 0xb7, 0xf6, 0xbf,
	0x58, 0x3b, 0x1c, 0xf6, 0x68, 0xd0, 0x97, 0x96, 0x1c, 0xe0, 0x76, 0x94, 0xd5, 0xcf, 0x60, 0x73,
	0xe2, 0xf3, 0x13, 0x84, 0x7e, 0x44, 0xb3, 0x38, 0x51, 0x9b, 0x5f, 0x05, 0x79, 0xab, 0x4f, 0x18,
	0x9d, 0xb8, 0x71, 0x14, 0x2c, 0x84, 0xb7, 0xba, 0xa3, 0x73, 0x60, 0x10, 0x05, 0xb7, 0x74, 0xa3,
	0xda, 0x7b, 0xb8, 0x6e, 0x1d, 0x68, 0xb0, 0x4b, 0x1a, 0xce, 0x03, 0x26, 0x92, 0xd7, 0xda, 0xdf,
	0xea, 0xc8, 0xb1, 0xd8, 0x29, 0xc6, 0x62, 0xa7, 0x1b, 0x2d, 0x9c, 0x42, 0xc8, 0x46, 0x3a, 0xc2,
	0x35, 0xf3, 0x7f, 0x75, 0x80, 0x95, 0xe3, 0xab, 0x7a, 0xad, 0xfd, 0x48, 0xbd, 0xd6, 0x6f, 0xe6,
	0xc5, 0x80, 0xc6, 0x84, 0x4d, 0x69, 0x1e, 0x64, 0x46, 0x43, 0x56, 0x8e, 0x22, 0xc9, 0x2f, 0xa0,
	0x15, 0xe6, 0x41, 0xe6, 0xcf, 0x03, 0xe6, 0xc6, 0x53, 0x03, 0x76, 0xb4, 0x5d, 0xcd, 0x81, 0x02,
	0x1a, 0x4c, 0xb9, 0x6a, 0x48, 0x2f, 0xfd, 0x30, 0x0f, 0xc5, 0x75, 0xd5, 0x9c, 0x82, 0x24, 0x4f,
	0xe0, 0x1e, 0xbb, 0xf4, 0x82, 0x3c, 0xf5, 0xcf, 0x99, 0x5b, 0xc8, 0x6c, 0x88, 0xd8, 0xe2, 0x25,
	0xe3, 0xa5, 0x12, 0xe6, 0x66, 0xfc, 0x48, 0x88, 0x6c, 0x2a, 0x33, 0x92, 0xbc, 0x66, 0x46, 0xc9,
	0xb4, 0xaf, 0x9b, 0x51, 0xc2, 0x0f, 0x01, 0x42, 0x7a, 0xe9, 0x06, 0x2c, 0x9a, 0x65, 0x67, 0xc6,
	0x87, 0x3b, 0xda, 0x2e, 0x72, 0x9a, 0x21, 0xbd, 0x3c, 0x16, 0x80, 0x60, 0xfb, 0x51, 0xc1, 0xc6,
	0x8a, 0xed, 0x47, 0x8a, 0x6d, 0x40, 0x63, 0x4e, 0x33, 0x9e, 0x14, 0xe3, 0x9e, 0x0c, 0x83, 0x22,
	0x79, 0x7d, 0x70, 0xbb, 0x7e, 0xc6, 0xc2, 0xd4, 0xd8, 0x12, 0x7a, 0x7a, 0x48, 0x2f, 0x2d, 0x4e,
	0x0b, 0xa6, 0x1f, 0x29, 0xe6, 0x03, 0xc5, 0xf4, 0x23, 0xc9, 0xfc, 0x14, 0x36, 0xf2, 0xc8, 0xff,
	0x3e, 0x67, 0x8a, 0xff, 0x33, 0x71, 0xf2, 0x96, 0xc4, 0xa4, 0xc8, 0xaf, 0xa0, 0xcd, 0x8d, 0xcf,
	0x13, 0xde, 0x5b, 0x33, 0x9f, 0xa5, 0x86, 0x21, 0x8c, 0x6c, 0x86, 0xf4, 0x72, 0xb8, 0x04, 0x85,
	0x98, 0x1f, 0x95, 0xc5, 0x3e, 0x52, 0x62, 0x7e, 0x54, 0x12, 0xdb, 0x06, 0x3d, 0x91, 0x1d, 0x6e,
	0x62, 0x6c, 0xcb, 0xc6, 0x5b, 0xd0, 0xbc, 0x3e, 0x68, 0x92, 0xd0, 0x85, 0x61, 0x0a, 0x86, 0x24,
	0xc8, 0x9f, 0x00, 0x65, 0x8b, 0x39, 0x33, 0x7e, 0x29, 0xde, 0x31, 0xd6, 0x1d, 0x6e, 0x5c, 0x69,
	0x39, 0xf2, 0x79, 0x79, 0x8e, 0x17, 0x73, 0x96, 0x3a, 0xc2, 0xac, 0x79, 0x01, 0x0f, 0x6e, 0x65,
	0x5f, 0x9d, 0xb7, 0x4d, 0xa8, 0x75, 0x1d, 0xa7, 0xfb, 0x0a, 0x6b, 0x1c, 0x3f, 0x18, 0x0c, 0x8e,
	0x7b, 0xdd, 0x3e, 0xae, 0x70, 0xc2, 0xea, 0x8f, 0x7b, 0xcf, 0x7a, 0x0e, 0xae, 0xf2, 0xa1, 0xdc,
	0x3f, 0x39, 0x3e, 0xc6, 0x88, 0x00, 0xd4, 0xfb, 0x27, 0x2f, 0x0f, 0x7a, 0x0e, 0xae, 0xf1, 0xf5,
	0xe0, 0xc0, 0xee, 0x1d, 0x8e, 0x71, 0x9d, 0xaf, 0x47, 0x63, 0xc7, 0xea, 0x3f, 0xc3, 0x0d, 0x1b,
	0xe9, 0x1a, 0xae, 0xd8, 0x48, 0xaf, 0xe0, 0xaa, 0x8d, 0xf4, 0xaa, 0x18, 0xd7, 0x08, 0xd7, 0xae,
	0x0d, 0x6d, 0x82, 0xef, 0xdb, 0x48, 0xbf, 0x8f, 0xb7, 0x6c, 0xa4, 0xff, 0x1c, 0x1b, 0x36, 0xd2,
	0x3f, 0xc6, 0x9f, 0xd8, 0x48, 0xff, 0x04, 0x3f, 0xb4, 0x91, 0xfe, 0x10, 0x3f, 0xb2, 0x91, 0xfe,
	0x08, 0x9b, 0x36, 0xd2, 0x3f, 0xc3, 0x8f, 0x6d, 0xa4, 0x3f, 0xc6, 0x4f, 0x6c, 0xa4, 0x3f, 0xc1,
	0x1d, 0xf3, 0xaf, 0x1a, 0x54, 0xc7, 0x74, 0xb6, 0xc6, 0x3c, 0xb8, 0xd1, 0x41, 0xaa, 0xef, 0xbe,
	0x83, 0x48, 0x77, 0xcd, 0xff, 0x6a, 0x70, 0xff, 0x96, 0x17, 0x1c, 0x99, 0x96, 0x26, 0xa7, 0x26,
	0x26, 0xa7, 0xfd, 0x36, 0x2f, 0xc2, 0x25, 0xd6, 0x8b, 0xb2, 0x64, 0xb1, 0x9a, 0xa3, 0xdb, 0x19,
	0x6c, 0x5e, 0x61, 0xf1, 0x9e, 0xff, 0x86, 0x2d, 0xd4, 0x34, 0xe0, 0x4b, 0xf2, 0x12, 0x6a, 0xe7,
	0x34, 0xc8, 0x99, 0x7a, 0xaf, 0xff, 0xf6, 0x27, 0x9f, 0x43, 0xbd, 0x98, 0xa5, 0x95, 0xaf, 0x2a,
	0x5f, 0x6a, 0xfc, 0x3b, 0xa1, 0x7d, 0x95, 0x4b, 0x86, 0xaa, 0xaa, 0xf9, 0xc6, 0xed, 0x3b, 0x3c,
	0x13, 0xa4, 0x99, 0x0e, 0x2f, 0x55, 0x59, 0xc8, 0x6b, 0xe4, 0xb9, 0x18, 0xab, 0xd5, 0xd2, 0x58,
	0xb5, 0xa1, 0xe2, 0x47, 0x62, 0xb8, 0xb7, 0xf7, 0xbf, 0xba, 0xeb, 0x29, 0xac, 0xc8, 0xa9, 0xf8,
	0x11, 0xf7, 0x69, 0x1a, 0xc4, 0x17, 0xa2, 0xbd, 0xbf, 0x85, 0x4f, 0x5f, 0x07, 0xf1, 0x85, 0x23,
	0x2c, 0xf1, 0xee, 0x4a, 0xf3, 0xec, 0x2c, 0x4e, 0xfc, 0x3f, 0xcb, 0x97, 0x1e, 0x9f, 0xcf, 0x72,
	0x42, 0xe0, 0x2b, 0x8c, 0x93, 0x24, 0xe0, 0x8d, 0x2e, 0x8b, 0xdf, 0x30, 0x29, 0x24, 0x07, 0x85,
	0x2e, 0x00, 0xce, 0x7c, 0x06, 0xf5, 0xd4, 0x8b, 0xe7, 0x2c, 0x35, 0x74, 0x91, 0xd6, 0xbd, 0xf5,
	0x4f, 0x27, 0xd4, 0x1c, 0xa5, 0x6e, 0xbe, 0x00, 0xc4, 0x83, 0x4e, 0x30, 0x6c, 0x8c, 0x5f, 0x0d,
	0x7b, 0xae, 0xd5, 0xff, 0xa6, 0x7b, 0x6c, 0x1d, 0xe1, 0x0f, 0x48, 0x1b, 0x40, 0x20, 0x07, 0xdd,
	0x91, 0x75, 0x88, 0xb5, 0xa5, 0x44, 0x77, 0x68, 0xb9, 0x2f, 0x7a, 0xaf, 0x70, 0x85, 0x7c, 0x08,
	0x2d, 0x81, 0x0c, 0xba, 0x27, 0xe3, 0xe7, 0xfb, 0xb8, 0x6a, 0xfe, 0x06, 0x2a, 0x56, 0xc4, 0x15,
	0xad, 0x7e, 0xc9, 0xd0, 0x06, 0xe8, 0x56, 0xdf, 0xfd, 0xc3, 0x49, 0xcf, 0xe1, 0xfd, 0x66, 0x13,
	0x9a, 0x56, 0xdf, 0x7d, 0xde, 0xeb, 0x1e, 0xf5, 0x1c, 0x5c, 0x31, 0xbf, 0x03, 0xc4, 0x03, 0xc4,
	0xad, 0x7f, 0x7d, 0x3c, 0x38, 0x2d, 0xa9, 0xdd, 0x83, 0x4d, 0x89, 0xbc, 0x1c, 0x1e, 0x5b, 0x87,
	0xd6, 0x18, 0x6b, 0x4b, 0x68, 0xd8, 0x1d, 0x8d, 0x4e, 0x07, 0xce, 0x11, 0xae, 0x90, 0x2d, 0xc0,
	0x02, 0xea, 0x0e, 0xb9, 0x54, 0x77, 0x6c, 0x0d, 0xfa, 0xb8, 0xba, 0x42, 0x0f, 0x0f, 0x7b, 0xa3,
	0x91, 0x7b, 0x38, 0x38, 0xea, 0x61, 0x64, 0xfe, 0xa7, 0xb2, 0xba, 0xad, 0xa5, 0x77, 0x29, 0xf9,
	0x8b, 0x56, 0xfa, 0x98, 0x4b, 0x56, 0x0c, 0x75, 0x75, 0x4f, 0xde, 0xe6, 0xd1, 0x7b, 0x1b, 0x26,
	0x6f, 0xf1, 0xf2, 0x2b, 0xaf, 0xc4, 0xd9, 0xfe, 0x1c, 0x8c, 0x5b, 0x14, 0xbe, 0xe1, 0x57, 0x8f,
	0xcf, 0x13, 0x91, 0x34, 0xf5, 0x65, 0x23, 0x89, 0xed, 0xbf, 0x6b, 0xb7, 0xaa, 0xfc, 0x50, 0x3b,
	0x78, 0x73, 0xb5, 0x1d, 0xbc, 0x73, 0xdf, 0xc4, 0x51, 0xcb, 0xcd, 0xe2, 0x6f, 0x1a, 0x7f, 0x73,
	0xf2, 0x5a, 0x23, 0xc3, 0xb2, 0x03, 0xad, 0x9f, 0x72, 0x3f, 0x85, 0xbe, 0xfc, 0x91, 0xc1, 0x53,
	0xce, 0x7f, 0x09, 0xb0, 0x02, 0x6f, 0xf1, 0x76, 0xab, 0xec, 0x6d, 0xb3, 0x74, 0xac, 0x83, 0xc3,
	0x3f, 0x76, 0x67, 0x7e, 0x76, 0x96, 0xbf, 0xee, 0x78, 0x71, 0xb8, 0xc7, 0x0f, 0xf2, 0x94, 0x79,
	0x71, 0xba, 0x48, 0x33, 0xa6, 0x48, 0x75, 0xae, 0xbd, 0x1f, 0xfe, 0x13, 0xe6, 0x75, 0x5d, 0xf0,
	0xbe, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xdc, 0xb7, 0xe4, 0x3d, 0xa9, 0x11, 0x00, 0x00,
}
