/*
Copyright 2017 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package main

import "testing"

func TestTagsToWhere(t *testing.T) {
	tests := []struct {
		tags map[string]string
		want string
	}{
		{
			tags: map[string]string{},
			want: "",
		},
		{
			tags: map[string]string{
				"key1": "value1",
			},
			want: `WHERE "key1" = 'value1'`,
		},
		{
			tags: map[string]string{
				"key1": "value1",
				"key2": "value2",
			},
			want: `WHERE "key1" = 'value1' AND "key2" = 'value2'`,
		},
	}

	for _, test := range tests {
		if got := tagsToWhere(test.tags); got != test.want {
			t.Errorf("tagsToWhere(%+v) = %+v, want %+v", test.tags, got, test.want)
		}
	}
}
