/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	prowjobsv1 "k8s.io/test-infra/prow/apis/prowjobs/v1"
)

// FakeProwJobs implements ProwJobInterface
type FakeProwJobs struct {
	Fake *FakeProwV1
	ns   string
}

var prowjobsResource = schema.GroupVersionResource{Group: "prow.k8s.io", Version: "v1", Resource: "prowjobs"}

var prowjobsKind = schema.GroupVersionKind{Group: "prow.k8s.io", Version: "v1", Kind: "ProwJob"}

// Get takes name of the prowJob, and returns the corresponding prowJob object, and an error if there is any.
func (c *FakeProwJobs) Get(name string, options v1.GetOptions) (result *prowjobsv1.ProwJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(prowjobsResource, c.ns, name), &prowjobsv1.ProwJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*prowjobsv1.ProwJob), err
}

// List takes label and field selectors, and returns the list of ProwJobs that match those selectors.
func (c *FakeProwJobs) List(opts v1.ListOptions) (result *prowjobsv1.ProwJobList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(prowjobsResource, prowjobsKind, c.ns, opts), &prowjobsv1.ProwJobList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &prowjobsv1.ProwJobList{ListMeta: obj.(*prowjobsv1.ProwJobList).ListMeta}
	for _, item := range obj.(*prowjobsv1.ProwJobList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested prowJobs.
func (c *FakeProwJobs) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(prowjobsResource, c.ns, opts))

}

// Create takes the representation of a prowJob and creates it.  Returns the server's representation of the prowJob, and an error, if there is any.
func (c *FakeProwJobs) Create(prowJob *prowjobsv1.ProwJob) (result *prowjobsv1.ProwJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(prowjobsResource, c.ns, prowJob), &prowjobsv1.ProwJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*prowjobsv1.ProwJob), err
}

// Update takes the representation of a prowJob and updates it. Returns the server's representation of the prowJob, and an error, if there is any.
func (c *FakeProwJobs) Update(prowJob *prowjobsv1.ProwJob) (result *prowjobsv1.ProwJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(prowjobsResource, c.ns, prowJob), &prowjobsv1.ProwJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*prowjobsv1.ProwJob), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeProwJobs) UpdateStatus(prowJob *prowjobsv1.ProwJob) (*prowjobsv1.ProwJob, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(prowjobsResource, "status", c.ns, prowJob), &prowjobsv1.ProwJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*prowjobsv1.ProwJob), err
}

// Delete takes name of the prowJob and deletes it. Returns an error if one occurs.
func (c *FakeProwJobs) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(prowjobsResource, c.ns, name), &prowjobsv1.ProwJob{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeProwJobs) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(prowjobsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &prowjobsv1.ProwJobList{})
	return err
}

// Patch applies the patch and returns the patched prowJob.
func (c *FakeProwJobs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *prowjobsv1.ProwJob, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(prowjobsResource, c.ns, name, pt, data, subresources...), &prowjobsv1.ProwJob{})

	if obj == nil {
		return nil, err
	}
	return obj.(*prowjobsv1.ProwJob), err
}
