package documentdb

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// DatabaseAccountKind enumerates the values for database account kind.
type DatabaseAccountKind string

const (
	// GlobalDocumentDB ...
	GlobalDocumentDB DatabaseAccountKind = "GlobalDocumentDB"
	// MongoDB ...
	MongoDB DatabaseAccountKind = "MongoDB"
	// Parse ...
	Parse DatabaseAccountKind = "Parse"
)

// PossibleDatabaseAccountKindValues returns an array of possible values for the DatabaseAccountKind const type.
func PossibleDatabaseAccountKindValues() []DatabaseAccountKind {
	return []DatabaseAccountKind{GlobalDocumentDB, MongoDB, Parse}
}

// DatabaseAccountOfferType enumerates the values for database account offer type.
type DatabaseAccountOfferType string

const (
	// Standard ...
	Standard DatabaseAccountOfferType = "Standard"
)

// PossibleDatabaseAccountOfferTypeValues returns an array of possible values for the DatabaseAccountOfferType const type.
func PossibleDatabaseAccountOfferTypeValues() []DatabaseAccountOfferType {
	return []DatabaseAccountOfferType{Standard}
}

// DefaultConsistencyLevel enumerates the values for default consistency level.
type DefaultConsistencyLevel string

const (
	// BoundedStaleness ...
	BoundedStaleness DefaultConsistencyLevel = "BoundedStaleness"
	// ConsistentPrefix ...
	ConsistentPrefix DefaultConsistencyLevel = "ConsistentPrefix"
	// Eventual ...
	Eventual DefaultConsistencyLevel = "Eventual"
	// Session ...
	Session DefaultConsistencyLevel = "Session"
	// Strong ...
	Strong DefaultConsistencyLevel = "Strong"
)

// PossibleDefaultConsistencyLevelValues returns an array of possible values for the DefaultConsistencyLevel const type.
func PossibleDefaultConsistencyLevelValues() []DefaultConsistencyLevel {
	return []DefaultConsistencyLevel{BoundedStaleness, ConsistentPrefix, Eventual, Session, Strong}
}

// KeyKind enumerates the values for key kind.
type KeyKind string

const (
	// Primary ...
	Primary KeyKind = "primary"
	// PrimaryReadonly ...
	PrimaryReadonly KeyKind = "primaryReadonly"
	// Secondary ...
	Secondary KeyKind = "secondary"
	// SecondaryReadonly ...
	SecondaryReadonly KeyKind = "secondaryReadonly"
)

// PossibleKeyKindValues returns an array of possible values for the KeyKind const type.
func PossibleKeyKindValues() []KeyKind {
	return []KeyKind{Primary, PrimaryReadonly, Secondary, SecondaryReadonly}
}

// PrimaryAggregationType enumerates the values for primary aggregation type.
type PrimaryAggregationType string

const (
	// Average ...
	Average PrimaryAggregationType = "Average"
	// Last ...
	Last PrimaryAggregationType = "Last"
	// Maximum ...
	Maximum PrimaryAggregationType = "Maximum"
	// Minimimum ...
	Minimimum PrimaryAggregationType = "Minimimum"
	// None ...
	None PrimaryAggregationType = "None"
	// Total ...
	Total PrimaryAggregationType = "Total"
)

// PossiblePrimaryAggregationTypeValues returns an array of possible values for the PrimaryAggregationType const type.
func PossiblePrimaryAggregationTypeValues() []PrimaryAggregationType {
	return []PrimaryAggregationType{Average, Last, Maximum, Minimimum, None, Total}
}

// UnitType enumerates the values for unit type.
type UnitType string

const (
	// Bytes ...
	Bytes UnitType = "Bytes"
	// BytesPerSecond ...
	BytesPerSecond UnitType = "BytesPerSecond"
	// Count ...
	Count UnitType = "Count"
	// CountPerSecond ...
	CountPerSecond UnitType = "CountPerSecond"
	// Milliseconds ...
	Milliseconds UnitType = "Milliseconds"
	// Percent ...
	Percent UnitType = "Percent"
	// Seconds ...
	Seconds UnitType = "Seconds"
)

// PossibleUnitTypeValues returns an array of possible values for the UnitType const type.
func PossibleUnitTypeValues() []UnitType {
	return []UnitType{Bytes, BytesPerSecond, Count, CountPerSecond, Milliseconds, Percent, Seconds}
}

// Capability cosmos DB capability object
type Capability struct {
	// Name - Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
	Name *string `json:"name,omitempty"`
}

// ConsistencyPolicy the consistency policy for the Cosmos DB database account.
type ConsistencyPolicy struct {
	// DefaultConsistencyLevel - The default consistency level and configuration settings of the Cosmos DB account. Possible values include: 'Eventual', 'Session', 'BoundedStaleness', 'Strong', 'ConsistentPrefix'
	DefaultConsistencyLevel DefaultConsistencyLevel `json:"defaultConsistencyLevel,omitempty"`
	// MaxStalenessPrefix - When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
	MaxStalenessPrefix *int64 `json:"maxStalenessPrefix,omitempty"`
	// MaxIntervalInSeconds - When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
	MaxIntervalInSeconds *int32 `json:"maxIntervalInSeconds,omitempty"`
}

// DatabaseAccount an Azure Cosmos DB database account.
type DatabaseAccount struct {
	autorest.Response `json:"-"`
	// Kind - Indicates the type of database account. This can only be set at database account creation. Possible values include: 'GlobalDocumentDB', 'MongoDB', 'Parse'
	Kind                       DatabaseAccountKind `json:"kind,omitempty"`
	*DatabaseAccountProperties `json:"properties,omitempty"`
	// ID - The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DatabaseAccount.
func (da DatabaseAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if da.Kind != "" {
		objectMap["kind"] = da.Kind
	}
	if da.DatabaseAccountProperties != nil {
		objectMap["properties"] = da.DatabaseAccountProperties
	}
	if da.ID != nil {
		objectMap["id"] = da.ID
	}
	if da.Name != nil {
		objectMap["name"] = da.Name
	}
	if da.Type != nil {
		objectMap["type"] = da.Type
	}
	if da.Location != nil {
		objectMap["location"] = da.Location
	}
	if da.Tags != nil {
		objectMap["tags"] = da.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccount struct.
func (da *DatabaseAccount) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind DatabaseAccountKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				da.Kind = kind
			}
		case "properties":
			if v != nil {
				var databaseAccountProperties DatabaseAccountProperties
				err = json.Unmarshal(*v, &databaseAccountProperties)
				if err != nil {
					return err
				}
				da.DatabaseAccountProperties = &databaseAccountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				da.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				da.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				da.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				da.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				da.Tags = tags
			}
		}
	}

	return nil
}

// DatabaseAccountConnectionString connection string for the Cosmos DB account
type DatabaseAccountConnectionString struct {
	// ConnectionString - Value of the connection string
	ConnectionString *string `json:"connectionString,omitempty"`
	// Description - Description of the connection string
	Description *string `json:"description,omitempty"`
}

// DatabaseAccountCreateUpdateParameters parameters to create and update Cosmos DB database accounts.
type DatabaseAccountCreateUpdateParameters struct {
	// Kind - Indicates the type of database account. This can only be set at database account creation. Possible values include: 'GlobalDocumentDB', 'MongoDB', 'Parse'
	Kind                                   DatabaseAccountKind `json:"kind,omitempty"`
	*DatabaseAccountCreateUpdateProperties `json:"properties,omitempty"`
	// ID - The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountCreateUpdateParameters.
func (dacup DatabaseAccountCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dacup.Kind != "" {
		objectMap["kind"] = dacup.Kind
	}
	if dacup.DatabaseAccountCreateUpdateProperties != nil {
		objectMap["properties"] = dacup.DatabaseAccountCreateUpdateProperties
	}
	if dacup.ID != nil {
		objectMap["id"] = dacup.ID
	}
	if dacup.Name != nil {
		objectMap["name"] = dacup.Name
	}
	if dacup.Type != nil {
		objectMap["type"] = dacup.Type
	}
	if dacup.Location != nil {
		objectMap["location"] = dacup.Location
	}
	if dacup.Tags != nil {
		objectMap["tags"] = dacup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountCreateUpdateParameters struct.
func (dacup *DatabaseAccountCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind DatabaseAccountKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dacup.Kind = kind
			}
		case "properties":
			if v != nil {
				var databaseAccountCreateUpdateProperties DatabaseAccountCreateUpdateProperties
				err = json.Unmarshal(*v, &databaseAccountCreateUpdateProperties)
				if err != nil {
					return err
				}
				dacup.DatabaseAccountCreateUpdateProperties = &databaseAccountCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dacup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dacup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dacup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dacup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dacup.Tags = tags
			}
		}
	}

	return nil
}

// DatabaseAccountCreateUpdateProperties properties to create and update Azure Cosmos DB database accounts.
type DatabaseAccountCreateUpdateProperties struct {
	// ConsistencyPolicy - The consistency policy for the Cosmos DB account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`
	// Locations - An array that contains the georeplication locations enabled for the Cosmos DB account.
	Locations                *[]Location `json:"locations,omitempty"`
	DatabaseAccountOfferType *string     `json:"databaseAccountOfferType,omitempty"`
	// IPRangeFilter - Cosmos DB Firewall Support: This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account. IP addresses/ranges must be comma separated and must not contain any spaces.
	IPRangeFilter *string `json:"ipRangeFilter,omitempty"`
	// IsVirtualNetworkFilterEnabled - Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`
	// EnableAutomaticFailover - Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
	// VirtualNetworkRules - List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// DatabaseAccountListConnectionStringsResult the connection strings for the given database account.
type DatabaseAccountListConnectionStringsResult struct {
	autorest.Response `json:"-"`
	// ConnectionStrings - An array that contains the connection strings for the Cosmos DB account.
	ConnectionStrings *[]DatabaseAccountConnectionString `json:"connectionStrings,omitempty"`
}

// DatabaseAccountListKeysResult the access keys for the given database account.
type DatabaseAccountListKeysResult struct {
	autorest.Response `json:"-"`
	// PrimaryMasterKey - Base 64 encoded value of the primary read-write key.
	PrimaryMasterKey *string `json:"primaryMasterKey,omitempty"`
	// SecondaryMasterKey - Base 64 encoded value of the secondary read-write key.
	SecondaryMasterKey                     *string `json:"secondaryMasterKey,omitempty"`
	*DatabaseAccountListReadOnlyKeysResult `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountListKeysResult.
func (dalkr DatabaseAccountListKeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dalkr.PrimaryMasterKey != nil {
		objectMap["primaryMasterKey"] = dalkr.PrimaryMasterKey
	}
	if dalkr.SecondaryMasterKey != nil {
		objectMap["secondaryMasterKey"] = dalkr.SecondaryMasterKey
	}
	if dalkr.DatabaseAccountListReadOnlyKeysResult != nil {
		objectMap["properties"] = dalkr.DatabaseAccountListReadOnlyKeysResult
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountListKeysResult struct.
func (dalkr *DatabaseAccountListKeysResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "primaryMasterKey":
			if v != nil {
				var primaryMasterKey string
				err = json.Unmarshal(*v, &primaryMasterKey)
				if err != nil {
					return err
				}
				dalkr.PrimaryMasterKey = &primaryMasterKey
			}
		case "secondaryMasterKey":
			if v != nil {
				var secondaryMasterKey string
				err = json.Unmarshal(*v, &secondaryMasterKey)
				if err != nil {
					return err
				}
				dalkr.SecondaryMasterKey = &secondaryMasterKey
			}
		case "properties":
			if v != nil {
				var databaseAccountListReadOnlyKeysResult DatabaseAccountListReadOnlyKeysResult
				err = json.Unmarshal(*v, &databaseAccountListReadOnlyKeysResult)
				if err != nil {
					return err
				}
				dalkr.DatabaseAccountListReadOnlyKeysResult = &databaseAccountListReadOnlyKeysResult
			}
		}
	}

	return nil
}

// DatabaseAccountListReadOnlyKeysResult the read-only access keys for the given database account.
type DatabaseAccountListReadOnlyKeysResult struct {
	autorest.Response `json:"-"`
	// PrimaryReadonlyMasterKey - Base 64 encoded value of the primary read-only key.
	PrimaryReadonlyMasterKey *string `json:"primaryReadonlyMasterKey,omitempty"`
	// SecondaryReadonlyMasterKey - Base 64 encoded value of the secondary read-only key.
	SecondaryReadonlyMasterKey *string `json:"secondaryReadonlyMasterKey,omitempty"`
}

// DatabaseAccountPatchParameters parameters for patching Azure Cosmos DB database account properties.
type DatabaseAccountPatchParameters struct {
	Tags                            map[string]*string `json:"tags"`
	*DatabaseAccountPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountPatchParameters.
func (dapp DatabaseAccountPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dapp.Tags != nil {
		objectMap["tags"] = dapp.Tags
	}
	if dapp.DatabaseAccountPatchProperties != nil {
		objectMap["properties"] = dapp.DatabaseAccountPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountPatchParameters struct.
func (dapp *DatabaseAccountPatchParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dapp.Tags = tags
			}
		case "properties":
			if v != nil {
				var databaseAccountPatchProperties DatabaseAccountPatchProperties
				err = json.Unmarshal(*v, &databaseAccountPatchProperties)
				if err != nil {
					return err
				}
				dapp.DatabaseAccountPatchProperties = &databaseAccountPatchProperties
			}
		}
	}

	return nil
}

// DatabaseAccountPatchProperties properties to update Azure Cosmos DB database accounts.
type DatabaseAccountPatchProperties struct {
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
}

// DatabaseAccountProperties properties for the database account.
type DatabaseAccountProperties struct {
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// DocumentEndpoint - The connection endpoint for the Cosmos DB database account.
	DocumentEndpoint *string `json:"documentEndpoint,omitempty"`
	// DatabaseAccountOfferType - The offer type for the Cosmos DB database account. Default value: Standard. Possible values include: 'Standard'
	DatabaseAccountOfferType DatabaseAccountOfferType `json:"databaseAccountOfferType,omitempty"`
	// IPRangeFilter - Cosmos DB Firewall Support: This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account. IP addresses/ranges must be comma separated and must not contain any spaces.
	IPRangeFilter *string `json:"ipRangeFilter,omitempty"`
	// IsVirtualNetworkFilterEnabled - Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`
	// EnableAutomaticFailover - Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`
	// ConsistencyPolicy - The consistency policy for the Cosmos DB database account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
	// WriteLocations - An array that contains the write location for the Cosmos DB account.
	WriteLocations *[]Location `json:"writeLocations,omitempty"`
	// ReadLocations - An array that contains of the read locations enabled for the Cosmos DB account.
	ReadLocations *[]Location `json:"readLocations,omitempty"`
	// FailoverPolicies - An array that contains the regions ordered by their failover priorities.
	FailoverPolicies *[]FailoverPolicy `json:"failoverPolicies,omitempty"`
	// VirtualNetworkRules - List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// DatabaseAccountRegenerateKeyParameters parameters to regenerate the keys within the database account.
type DatabaseAccountRegenerateKeyParameters struct {
	// KeyKind - The access key to regenerate. Possible values include: 'Primary', 'Secondary', 'PrimaryReadonly', 'SecondaryReadonly'
	KeyKind KeyKind `json:"keyKind,omitempty"`
}

// DatabaseAccountsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabaseAccountsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsCreateOrUpdateFuture) Result(client DatabaseAccountsClient) (da DatabaseAccount, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if da.Response.Response, err = future.GetResult(sender); err == nil && da.Response.Response.StatusCode != http.StatusNoContent {
		da, err = client.CreateOrUpdateResponder(da.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateOrUpdateFuture", "Result", da.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabaseAccountsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsDeleteFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsFailoverPriorityChangeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsFailoverPriorityChangeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsFailoverPriorityChangeFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsFailoverPriorityChangeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsFailoverPriorityChangeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsListResult the List operation response, that contains the database accounts and their
// properties.
type DatabaseAccountsListResult struct {
	autorest.Response `json:"-"`
	// Value - List of database account and their properties.
	Value *[]DatabaseAccount `json:"value,omitempty"`
}

// DatabaseAccountsOfflineRegionFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabaseAccountsOfflineRegionFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsOfflineRegionFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsOfflineRegionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsOfflineRegionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsOnlineRegionFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabaseAccountsOnlineRegionFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsOnlineRegionFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsOnlineRegionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsOnlineRegionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsPatchFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabaseAccountsPatchFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsPatchFuture) Result(client DatabaseAccountsClient) (da DatabaseAccount, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsPatchFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsPatchFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if da.Response.Response, err = future.GetResult(sender); err == nil && da.Response.Response.StatusCode != http.StatusNoContent {
		da, err = client.PatchResponder(da.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsPatchFuture", "Result", da.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsRegenerateKeyFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabaseAccountsRegenerateKeyFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsRegenerateKeyFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsRegenerateKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsRegenerateKeyFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ErrorResponse error Response.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// FailoverPolicies the list of new failover policies for the failover priority change.
type FailoverPolicies struct {
	// FailoverPolicies - List of failover policies.
	FailoverPolicies *[]FailoverPolicy `json:"failoverPolicies,omitempty"`
}

// FailoverPolicy the failover policy for a given region of a database account.
type FailoverPolicy struct {
	// ID - The unique identifier of the region in which the database account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;.
	ID *string `json:"id,omitempty"`
	// LocationName - The name of the region in which the database account exists.
	LocationName *string `json:"locationName,omitempty"`
	// FailoverPriority - The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
	FailoverPriority *int32 `json:"failoverPriority,omitempty"`
}

// Location a region in which the Azure Cosmos DB database account is deployed.
type Location struct {
	// ID - The unique identifier of the region within the database account. Example: &lt;accountName&gt;-&lt;locationName&gt;.
	ID *string `json:"id,omitempty"`
	// LocationName - The name of the region.
	LocationName *string `json:"locationName,omitempty"`
	// DocumentEndpoint - The connection endpoint for the specific region. Example: https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/
	DocumentEndpoint  *string `json:"documentEndpoint,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// FailoverPriority - The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
	FailoverPriority *int32 `json:"failoverPriority,omitempty"`
}

// Metric metric data
type Metric struct {
	// StartTime - The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// MetricAvailability the availability of the metric.
type MetricAvailability struct {
	// TimeGrain - The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - The retention for the metric values.
	Retention *string `json:"retention,omitempty"`
}

// MetricDefinition the definition of a metric.
type MetricDefinition struct {
	// MetricAvailabilities - The list of metric availabilities for the account.
	MetricAvailabilities *[]MetricAvailability `json:"metricAvailabilities,omitempty"`
	// PrimaryAggregationType - The primary aggregation type of the metric. Possible values include: 'None', 'Average', 'Total', 'Minimimum', 'Maximum', 'Last'
	PrimaryAggregationType PrimaryAggregationType `json:"primaryAggregationType,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// ResourceURI - The resource uri of the database.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// Name - The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
}

// MetricDefinitionsListResult the response to a list metric definitions request.
type MetricDefinitionsListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of metric definitions for the account.
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricListResult the response to a list metrics request.
type MetricListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of metrics for the account.
	Value *[]Metric `json:"value,omitempty"`
}

// MetricName a metric name.
type MetricName struct {
	// Value - The name of the metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - The friendly name of the metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricValue represents metrics values.
type MetricValue struct {
	// Count - The number of values for the metric.
	Count *float64 `json:"_count,omitempty"`
	// Average - The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// Operation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.ResourceProvider
	Provider *string `json:"Provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"Resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"Operation,omitempty"`
	// Description - Description of operation
	Description *string `json:"Description,omitempty"`
}

// OperationListResult result of the request to list Resource Provider operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the Resource Provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// PartitionMetric the metric values for a single partition.
type PartitionMetric struct {
	// PartitionID - The parition id (GUID identifier) of the metric values.
	PartitionID *string `json:"partitionId,omitempty"`
	// PartitionKeyRangeID - The partition key range id (integer identifier) of the metric values.
	PartitionKeyRangeID *string `json:"partitionKeyRangeId,omitempty"`
	// StartTime - The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// PartitionMetricListResult the response to a list partition metrics request.
type PartitionMetricListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of partition-level metrics for the account.
	Value *[]PartitionMetric `json:"value,omitempty"`
}

// PartitionUsage the partition level usage data for a usage request.
type PartitionUsage struct {
	// PartitionID - The parition id (GUID identifier) of the usages.
	PartitionID *string `json:"partitionId,omitempty"`
	// PartitionKeyRangeID - The partition key range id (integer identifier) of the usages.
	PartitionKeyRangeID *string `json:"partitionKeyRangeId,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// QuotaPeriod - The quota period used to summarize the usage values.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// Limit - Maximum value for this metric
	Limit *int32 `json:"limit,omitempty"`
	// CurrentValue - Current value for this metric
	CurrentValue *int32 `json:"currentValue,omitempty"`
}

// PartitionUsagesResult the response to a list partition level usage request.
type PartitionUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - The list of partition-level usages for the database. A usage is a point in time metric
	Value *[]PartitionUsage `json:"value,omitempty"`
}

// PercentileMetric percentile Metric data
type PercentileMetric struct {
	// StartTime - The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - The percentile metric values for the specified time window and timestep.
	MetricValues *[]PercentileMetricValue `json:"metricValues,omitempty"`
}

// PercentileMetricListResult the response to a list percentile metrics request.
type PercentileMetricListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of percentile metrics for the account.
	Value *[]PercentileMetric `json:"value,omitempty"`
}

// PercentileMetricValue represents percentile metrics values.
type PercentileMetricValue struct {
	// P10 - The 10th percentile value for the metric.
	P10 *float64 `json:"P10,omitempty"`
	// P25 - The 25th percentile value for the metric.
	P25 *float64 `json:"P25,omitempty"`
	// P50 - The 50th percentile value for the metric.
	P50 *float64 `json:"P50,omitempty"`
	// P75 - The 75th percentile value for the metric.
	P75 *float64 `json:"P75,omitempty"`
	// P90 - The 90th percentile value for the metric.
	P90 *float64 `json:"P90,omitempty"`
	// P95 - The 95th percentile value for the metric.
	P95 *float64 `json:"P95,omitempty"`
	// P99 - The 99th percentile value for the metric.
	P99 *float64 `json:"P99,omitempty"`
	// Count - The number of values for the metric.
	Count *float64 `json:"_count,omitempty"`
	// Average - The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// RegionForOnlineOffline cosmos DB region to online or offline.
type RegionForOnlineOffline struct {
	// Region - Cosmos DB region, with spaces between words and each word capitalized.
	Region *string `json:"region,omitempty"`
}

// Resource a database account resource.
type Resource struct {
	// ID - The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// Usage the usage data for a usage request.
type Usage struct {
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// QuotaPeriod - The quota period used to summarize the usage values.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// Limit - Maximum value for this metric
	Limit *int32 `json:"limit,omitempty"`
	// CurrentValue - Current value for this metric
	CurrentValue *int32 `json:"currentValue,omitempty"`
}

// UsagesResult the response to a list usage request.
type UsagesResult struct {
	autorest.Response `json:"-"`
	// Value - The list of usages for the database. A usage is a point in time metric
	Value *[]Usage `json:"value,omitempty"`
}

// VirtualNetworkRule virtual Network ACL Rule object
type VirtualNetworkRule struct {
	// ID - Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
	ID *string `json:"id,omitempty"`
}
