/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	"encoding/json"
)

// RequestTarget struct for RequestTarget
type RequestTarget struct {
	Target *ResourceReference `json:"target,omitempty"`
	Status *string `json:"status,omitempty"`
}



// GetTarget returns the Target field value
// If the value is explicit nil, the zero value for ResourceReference will be returned
func (o *RequestTarget) GetTarget() *ResourceReference {
	if o == nil {
		return nil
	}

	return o.Target
}

// GetTargetOk returns a tuple with the Target field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RequestTarget) GetTargetOk() (*ResourceReference, bool) {
	if o == nil {
		return nil, false
	}
	return o.Target, true
}

// SetTarget sets field value
func (o *RequestTarget) SetTarget(v ResourceReference) {
	o.Target = &v
}

// HasTarget returns a boolean if a field has been set.
func (o *RequestTarget) HasTarget() bool {
	if o != nil && o.Target != nil {
		return true
	}

	return false
}



// GetStatus returns the Status field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RequestTarget) GetStatus() *string {
	if o == nil {
		return nil
	}

	return o.Status
}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RequestTarget) GetStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Status, true
}

// SetStatus sets field value
func (o *RequestTarget) SetStatus(v string) {
	o.Status = &v
}

// HasStatus returns a boolean if a field has been set.
func (o *RequestTarget) HasStatus() bool {
	if o != nil && o.Status != nil {
		return true
	}

	return false
}


func (o RequestTarget) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}

	if o.Target != nil {
		toSerialize["target"] = o.Target
	}
	

	if o.Status != nil {
		toSerialize["status"] = o.Status
	}
	
	return json.Marshal(toSerialize)
}

type NullableRequestTarget struct {
	value *RequestTarget
	isSet bool
}

func (v NullableRequestTarget) Get() *RequestTarget {
	return v.value
}

func (v *NullableRequestTarget) Set(val *RequestTarget) {
	v.value = val
	v.isSet = true
}

func (v NullableRequestTarget) IsSet() bool {
	return v.isSet
}

func (v *NullableRequestTarget) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRequestTarget(val *RequestTarget) *NullableRequestTarget {
	return &NullableRequestTarget{value: val, isSet: true}
}

func (v NullableRequestTarget) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRequestTarget) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


