/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	_context "context"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

// LoadBalancerApiService LoadBalancerApi service
type LoadBalancerApiService service

type ApiDatacentersLoadbalancersBalancednicsDeleteRequest struct {
	ctx _context.Context
	ApiService *LoadBalancerApiService
	datacenterId string
	loadbalancerId string
	nicId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLoadbalancersBalancednicsDeleteRequest) Pretty(pretty bool) ApiDatacentersLoadbalancersBalancednicsDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLoadbalancersBalancednicsDeleteRequest) Depth(depth int32) ApiDatacentersLoadbalancersBalancednicsDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLoadbalancersBalancednicsDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersLoadbalancersBalancednicsDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLoadbalancersBalancednicsDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.DatacentersLoadbalancersBalancednicsDeleteExecute(r)
}

/*
 * DatacentersLoadbalancersBalancednicsDelete Detach a nic from loadbalancer
 * This will remove a nic from Load Balancer
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param loadbalancerId The unique ID of the Load Balancer
 * @param nicId The unique ID of the NIC
 * @return ApiDatacentersLoadbalancersBalancednicsDeleteRequest
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersBalancednicsDelete(ctx _context.Context, datacenterId string, loadbalancerId string, nicId string) ApiDatacentersLoadbalancersBalancednicsDeleteRequest {
	return ApiDatacentersLoadbalancersBalancednicsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		loadbalancerId: loadbalancerId,
		nicId: nicId,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersBalancednicsDeleteExecute(r ApiDatacentersLoadbalancersBalancednicsDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LoadBalancerApiService.DatacentersLoadbalancersBalancednicsDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/loadbalancers/{loadbalancerId}/balancednics/{nicId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"loadbalancerId"+"}", _neturl.PathEscape(parameterToString(r.loadbalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLoadbalancersBalancednicsDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLoadbalancersBalancednicsFindByNicRequest struct {
	ctx _context.Context
	ApiService *LoadBalancerApiService
	datacenterId string
	loadbalancerId string
	nicId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLoadbalancersBalancednicsFindByNicRequest) Pretty(pretty bool) ApiDatacentersLoadbalancersBalancednicsFindByNicRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLoadbalancersBalancednicsFindByNicRequest) Depth(depth int32) ApiDatacentersLoadbalancersBalancednicsFindByNicRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLoadbalancersBalancednicsFindByNicRequest) XContractNumber(xContractNumber int32) ApiDatacentersLoadbalancersBalancednicsFindByNicRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLoadbalancersBalancednicsFindByNicRequest) Execute() (Nic, *APIResponse, error) {
	return r.ApiService.DatacentersLoadbalancersBalancednicsFindByNicExecute(r)
}

/*
 * DatacentersLoadbalancersBalancednicsFindByNic Retrieve a nic attached to Load Balancer
 * This will retrieve the properties of an attached nic.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param loadbalancerId The unique ID of the Load Balancer
 * @param nicId The unique ID of the NIC
 * @return ApiDatacentersLoadbalancersBalancednicsFindByNicRequest
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersBalancednicsFindByNic(ctx _context.Context, datacenterId string, loadbalancerId string, nicId string) ApiDatacentersLoadbalancersBalancednicsFindByNicRequest {
	return ApiDatacentersLoadbalancersBalancednicsFindByNicRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		loadbalancerId: loadbalancerId,
		nicId: nicId,
	}
}

/*
 * Execute executes the request
 * @return Nic
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersBalancednicsFindByNicExecute(r ApiDatacentersLoadbalancersBalancednicsFindByNicRequest) (Nic, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Nic
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LoadBalancerApiService.DatacentersLoadbalancersBalancednicsFindByNic")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/loadbalancers/{loadbalancerId}/balancednics/{nicId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"loadbalancerId"+"}", _neturl.PathEscape(parameterToString(r.loadbalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLoadbalancersBalancednicsFindByNic",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLoadbalancersBalancednicsGetRequest struct {
	ctx _context.Context
	ApiService *LoadBalancerApiService
	datacenterId string
	loadbalancerId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLoadbalancersBalancednicsGetRequest) Pretty(pretty bool) ApiDatacentersLoadbalancersBalancednicsGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLoadbalancersBalancednicsGetRequest) Depth(depth int32) ApiDatacentersLoadbalancersBalancednicsGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLoadbalancersBalancednicsGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersLoadbalancersBalancednicsGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLoadbalancersBalancednicsGetRequest) Execute() (BalancedNics, *APIResponse, error) {
	return r.ApiService.DatacentersLoadbalancersBalancednicsGetExecute(r)
}

/*
 * DatacentersLoadbalancersBalancednicsGet List Load Balancer Members 
 * You can retrieve a list of nics attached to a Load Balancer
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param loadbalancerId The unique ID of the Load Balancer
 * @return ApiDatacentersLoadbalancersBalancednicsGetRequest
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersBalancednicsGet(ctx _context.Context, datacenterId string, loadbalancerId string) ApiDatacentersLoadbalancersBalancednicsGetRequest {
	return ApiDatacentersLoadbalancersBalancednicsGetRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		loadbalancerId: loadbalancerId,
	}
}

/*
 * Execute executes the request
 * @return BalancedNics
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersBalancednicsGetExecute(r ApiDatacentersLoadbalancersBalancednicsGetRequest) (BalancedNics, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  BalancedNics
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LoadBalancerApiService.DatacentersLoadbalancersBalancednicsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/loadbalancers/{loadbalancerId}/balancednics"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"loadbalancerId"+"}", _neturl.PathEscape(parameterToString(r.loadbalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLoadbalancersBalancednicsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLoadbalancersBalancednicsPostRequest struct {
	ctx _context.Context
	ApiService *LoadBalancerApiService
	datacenterId string
	loadbalancerId string
	nic *Nic
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLoadbalancersBalancednicsPostRequest) Nic(nic Nic) ApiDatacentersLoadbalancersBalancednicsPostRequest {
	r.nic = &nic
	return r
}
func (r ApiDatacentersLoadbalancersBalancednicsPostRequest) Pretty(pretty bool) ApiDatacentersLoadbalancersBalancednicsPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLoadbalancersBalancednicsPostRequest) Depth(depth int32) ApiDatacentersLoadbalancersBalancednicsPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLoadbalancersBalancednicsPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersLoadbalancersBalancednicsPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLoadbalancersBalancednicsPostRequest) Execute() (Nic, *APIResponse, error) {
	return r.ApiService.DatacentersLoadbalancersBalancednicsPostExecute(r)
}

/*
 * DatacentersLoadbalancersBalancednicsPost Attach a nic to Load Balancer
 * This will attach a pre-existing nic to a Load Balancer. 
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param loadbalancerId The unique ID of the Load Balancer
 * @return ApiDatacentersLoadbalancersBalancednicsPostRequest
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersBalancednicsPost(ctx _context.Context, datacenterId string, loadbalancerId string) ApiDatacentersLoadbalancersBalancednicsPostRequest {
	return ApiDatacentersLoadbalancersBalancednicsPostRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		loadbalancerId: loadbalancerId,
	}
}

/*
 * Execute executes the request
 * @return Nic
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersBalancednicsPostExecute(r ApiDatacentersLoadbalancersBalancednicsPostRequest) (Nic, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Nic
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LoadBalancerApiService.DatacentersLoadbalancersBalancednicsPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/loadbalancers/{loadbalancerId}/balancednics"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"loadbalancerId"+"}", _neturl.PathEscape(parameterToString(r.loadbalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.nic == nil {
		return localVarReturnValue, nil, reportError("nic is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.nic
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLoadbalancersBalancednicsPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLoadbalancersDeleteRequest struct {
	ctx _context.Context
	ApiService *LoadBalancerApiService
	datacenterId string
	loadbalancerId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLoadbalancersDeleteRequest) Pretty(pretty bool) ApiDatacentersLoadbalancersDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLoadbalancersDeleteRequest) Depth(depth int32) ApiDatacentersLoadbalancersDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLoadbalancersDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersLoadbalancersDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLoadbalancersDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.DatacentersLoadbalancersDeleteExecute(r)
}

/*
 * DatacentersLoadbalancersDelete Delete a Loadbalancer.
 * Removes the specific Loadbalancer
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param loadbalancerId The unique ID of the Load Balancer
 * @return ApiDatacentersLoadbalancersDeleteRequest
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersDelete(ctx _context.Context, datacenterId string, loadbalancerId string) ApiDatacentersLoadbalancersDeleteRequest {
	return ApiDatacentersLoadbalancersDeleteRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		loadbalancerId: loadbalancerId,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersDeleteExecute(r ApiDatacentersLoadbalancersDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LoadBalancerApiService.DatacentersLoadbalancersDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/loadbalancers/{loadbalancerId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"loadbalancerId"+"}", _neturl.PathEscape(parameterToString(r.loadbalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLoadbalancersDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLoadbalancersFindByIdRequest struct {
	ctx _context.Context
	ApiService *LoadBalancerApiService
	datacenterId string
	loadbalancerId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLoadbalancersFindByIdRequest) Pretty(pretty bool) ApiDatacentersLoadbalancersFindByIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLoadbalancersFindByIdRequest) Depth(depth int32) ApiDatacentersLoadbalancersFindByIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLoadbalancersFindByIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersLoadbalancersFindByIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLoadbalancersFindByIdRequest) Execute() (Loadbalancer, *APIResponse, error) {
	return r.ApiService.DatacentersLoadbalancersFindByIdExecute(r)
}

/*
 * DatacentersLoadbalancersFindById Retrieve a loadbalancer
 * Retrieves the attributes of a given Loadbalancer
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param loadbalancerId The unique ID of the Load Balancer
 * @return ApiDatacentersLoadbalancersFindByIdRequest
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersFindById(ctx _context.Context, datacenterId string, loadbalancerId string) ApiDatacentersLoadbalancersFindByIdRequest {
	return ApiDatacentersLoadbalancersFindByIdRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		loadbalancerId: loadbalancerId,
	}
}

/*
 * Execute executes the request
 * @return Loadbalancer
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersFindByIdExecute(r ApiDatacentersLoadbalancersFindByIdRequest) (Loadbalancer, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Loadbalancer
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LoadBalancerApiService.DatacentersLoadbalancersFindById")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/loadbalancers/{loadbalancerId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"loadbalancerId"+"}", _neturl.PathEscape(parameterToString(r.loadbalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLoadbalancersFindById",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLoadbalancersGetRequest struct {
	ctx _context.Context
	ApiService *LoadBalancerApiService
	datacenterId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLoadbalancersGetRequest) Pretty(pretty bool) ApiDatacentersLoadbalancersGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLoadbalancersGetRequest) Depth(depth int32) ApiDatacentersLoadbalancersGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLoadbalancersGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersLoadbalancersGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLoadbalancersGetRequest) Execute() (Loadbalancers, *APIResponse, error) {
	return r.ApiService.DatacentersLoadbalancersGetExecute(r)
}

/*
 * DatacentersLoadbalancersGet List Load Balancers
 * Retrieve a list of Load Balancers within the datacenter
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @return ApiDatacentersLoadbalancersGetRequest
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersGet(ctx _context.Context, datacenterId string) ApiDatacentersLoadbalancersGetRequest {
	return ApiDatacentersLoadbalancersGetRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
	}
}

/*
 * Execute executes the request
 * @return Loadbalancers
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersGetExecute(r ApiDatacentersLoadbalancersGetRequest) (Loadbalancers, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Loadbalancers
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LoadBalancerApiService.DatacentersLoadbalancersGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/loadbalancers"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLoadbalancersGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLoadbalancersPatchRequest struct {
	ctx _context.Context
	ApiService *LoadBalancerApiService
	datacenterId string
	loadbalancerId string
	loadbalancer *LoadbalancerProperties
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLoadbalancersPatchRequest) Loadbalancer(loadbalancer LoadbalancerProperties) ApiDatacentersLoadbalancersPatchRequest {
	r.loadbalancer = &loadbalancer
	return r
}
func (r ApiDatacentersLoadbalancersPatchRequest) Pretty(pretty bool) ApiDatacentersLoadbalancersPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLoadbalancersPatchRequest) Depth(depth int32) ApiDatacentersLoadbalancersPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLoadbalancersPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersLoadbalancersPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLoadbalancersPatchRequest) Execute() (Loadbalancer, *APIResponse, error) {
	return r.ApiService.DatacentersLoadbalancersPatchExecute(r)
}

/*
 * DatacentersLoadbalancersPatch Partially modify a Loadbalancer
 * You can use update attributes of a resource
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param loadbalancerId The unique ID of the Load Balancer
 * @return ApiDatacentersLoadbalancersPatchRequest
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersPatch(ctx _context.Context, datacenterId string, loadbalancerId string) ApiDatacentersLoadbalancersPatchRequest {
	return ApiDatacentersLoadbalancersPatchRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		loadbalancerId: loadbalancerId,
	}
}

/*
 * Execute executes the request
 * @return Loadbalancer
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersPatchExecute(r ApiDatacentersLoadbalancersPatchRequest) (Loadbalancer, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Loadbalancer
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LoadBalancerApiService.DatacentersLoadbalancersPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/loadbalancers/{loadbalancerId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"loadbalancerId"+"}", _neturl.PathEscape(parameterToString(r.loadbalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.loadbalancer == nil {
		return localVarReturnValue, nil, reportError("loadbalancer is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.loadbalancer
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLoadbalancersPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLoadbalancersPostRequest struct {
	ctx _context.Context
	ApiService *LoadBalancerApiService
	datacenterId string
	loadbalancer *Loadbalancer
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLoadbalancersPostRequest) Loadbalancer(loadbalancer Loadbalancer) ApiDatacentersLoadbalancersPostRequest {
	r.loadbalancer = &loadbalancer
	return r
}
func (r ApiDatacentersLoadbalancersPostRequest) Pretty(pretty bool) ApiDatacentersLoadbalancersPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLoadbalancersPostRequest) Depth(depth int32) ApiDatacentersLoadbalancersPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLoadbalancersPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersLoadbalancersPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLoadbalancersPostRequest) Execute() (Loadbalancer, *APIResponse, error) {
	return r.ApiService.DatacentersLoadbalancersPostExecute(r)
}

/*
 * DatacentersLoadbalancersPost Create a Load Balancer
 * Creates a Loadbalancer within the datacenter
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @return ApiDatacentersLoadbalancersPostRequest
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersPost(ctx _context.Context, datacenterId string) ApiDatacentersLoadbalancersPostRequest {
	return ApiDatacentersLoadbalancersPostRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
	}
}

/*
 * Execute executes the request
 * @return Loadbalancer
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersPostExecute(r ApiDatacentersLoadbalancersPostRequest) (Loadbalancer, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Loadbalancer
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LoadBalancerApiService.DatacentersLoadbalancersPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/loadbalancers"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.loadbalancer == nil {
		return localVarReturnValue, nil, reportError("loadbalancer is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.loadbalancer
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLoadbalancersPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLoadbalancersPutRequest struct {
	ctx _context.Context
	ApiService *LoadBalancerApiService
	datacenterId string
	loadbalancerId string
	loadbalancer *Loadbalancer
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLoadbalancersPutRequest) Loadbalancer(loadbalancer Loadbalancer) ApiDatacentersLoadbalancersPutRequest {
	r.loadbalancer = &loadbalancer
	return r
}
func (r ApiDatacentersLoadbalancersPutRequest) Pretty(pretty bool) ApiDatacentersLoadbalancersPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLoadbalancersPutRequest) Depth(depth int32) ApiDatacentersLoadbalancersPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLoadbalancersPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersLoadbalancersPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLoadbalancersPutRequest) Execute() (Loadbalancer, *APIResponse, error) {
	return r.ApiService.DatacentersLoadbalancersPutExecute(r)
}

/*
 * DatacentersLoadbalancersPut Modify a Load Balancer
 * You can use update attributes of a resource
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param loadbalancerId The unique ID of the Load Balancer
 * @return ApiDatacentersLoadbalancersPutRequest
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersPut(ctx _context.Context, datacenterId string, loadbalancerId string) ApiDatacentersLoadbalancersPutRequest {
	return ApiDatacentersLoadbalancersPutRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		loadbalancerId: loadbalancerId,
	}
}

/*
 * Execute executes the request
 * @return Loadbalancer
 */
func (a *LoadBalancerApiService) DatacentersLoadbalancersPutExecute(r ApiDatacentersLoadbalancersPutRequest) (Loadbalancer, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Loadbalancer
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LoadBalancerApiService.DatacentersLoadbalancersPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/loadbalancers/{loadbalancerId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"loadbalancerId"+"}", _neturl.PathEscape(parameterToString(r.loadbalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.loadbalancer == nil {
		return localVarReturnValue, nil, reportError("loadbalancer is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.loadbalancer
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLoadbalancersPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}
