// Code generated by go-swagger; DO NOT EDIT.

package restapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http",
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "Assisted installation",
    "title": "AssistedInstall",
    "version": "1.0.0"
  },
  "host": "api.openshift.com",
  "basePath": "/api/assisted-install/v1",
  "paths": {
    "/clusters": {
      "get": {
        "tags": [
          "installer"
        ],
        "summary": "Retrieves the list of OpenShift bare metal clusters.",
        "operationId": "ListClusters",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "installer"
        ],
        "summary": "Creates a new OpenShift bare metal cluster definition.",
        "operationId": "RegisterCluster",
        "parameters": [
          {
            "name": "new-cluster-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cluster-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}": {
      "get": {
        "security": [
          {
            "userAuth": []
          },
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Retrieves the details of the OpenShift bare metal cluster.",
        "operationId": "GetCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "installer"
        ],
        "summary": "Deletes an OpenShift bare metal cluster definition.",
        "operationId": "DeregisterCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "tags": [
          "installer"
        ],
        "summary": "Updates an OpenShift bare metal cluster definition.",
        "operationId": "UpdateCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "name": "cluster-update-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cluster-update-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/actions/cancel": {
      "post": {
        "tags": [
          "installer"
        ],
        "summary": "Cancels an ongoing installation.",
        "operationId": "CancelInstallation",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/actions/complete_installation": {
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Agent API to mark a finalizing installation as complete.",
        "operationId": "CompleteInstallation",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "name": "completion-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/completion-params"
            }
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/actions/install": {
      "post": {
        "tags": [
          "installer"
        ],
        "summary": "Installs the OpenShift bare metal cluster.",
        "operationId": "InstallCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/actions/reset": {
      "post": {
        "tags": [
          "installer"
        ],
        "summary": "Resets a failed installation.",
        "operationId": "ResetCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/credentials": {
      "get": {
        "tags": [
          "installer"
        ],
        "summary": "Get the the cluster admin credentials.",
        "operationId": "GetCredentials",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/credentials"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/downloads/files": {
      "get": {
        "security": [
          {
            "userAuth": []
          },
          {
            "agentAuth": []
          }
        ],
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "summary": "Downloads files relating to the installed/installing cluster.",
        "operationId": "DownloadClusterFiles",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "bootstrap.ign",
              "master.ign",
              "metadata.json",
              "worker.ign",
              "kubeadmin-password",
              "kubeconfig",
              "kubeconfig-noingress",
              "install-config.yaml"
            ],
            "type": "string",
            "name": "file_name",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/downloads/files-presigned": {
      "get": {
        "security": [
          {
            "userAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Retrieves a presigned S3 URL for downloading cluster files.",
        "operationId": "GetPresignedForClusterFiles",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "bootstrap.ign",
              "master.ign",
              "metadata.json",
              "worker.ign",
              "kubeadmin-password",
              "kubeconfig",
              "kubeconfig-noingress",
              "install-config.yaml",
              "logs"
            ],
            "type": "string",
            "name": "file_name",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/presigned"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/downloads/image": {
      "get": {
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "summary": "Downloads the OpenShift per-cluster discovery ISO.",
        "operationId": "DownloadClusterISO",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed."
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "installer"
        ],
        "summary": "Creates a new OpenShift per-cluster discovery ISO.",
        "operationId": "GenerateClusterISO",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "name": "image-create-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/image-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/downloads/kubeconfig": {
      "get": {
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "summary": "Downloads the kubeconfig file for this cluster.",
        "operationId": "DownloadClusterKubeconfig",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/events": {
      "get": {
        "tags": [
          "events"
        ],
        "summary": "Lists events for a cluster",
        "operationId": "ListEvents",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/event-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/free_addresses": {
      "get": {
        "tags": [
          "installer"
        ],
        "summary": "Retrieves the free address list for a network.",
        "operationId": "GetFreeAddresses",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$",
            "type": "string",
            "name": "network",
            "in": "query",
            "required": true
          },
          {
            "maximum": 8000,
            "minimum": 1,
            "type": "integer",
            "default": 8000,
            "name": "limit",
            "in": "query"
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/free-addresses-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/hosts": {
      "get": {
        "security": [
          {
            "userAuth": []
          },
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Retrieves the list of OpenShift bare metal hosts.",
        "operationId": "ListHosts",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Registers a new OpenShift bare metal host.",
        "operationId": "RegisterHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "name": "new-host-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-create-params"
            }
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/hosts/{host_id}": {
      "get": {
        "tags": [
          "installer"
        ],
        "summary": "Retrieves the details of the OpenShift bare metal host.",
        "operationId": "GetHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "installer"
        ],
        "summary": "Deregisters an OpenShift bare metal host.",
        "operationId": "DeregisterHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/hosts/{host_id}/actions/enable": {
      "post": {
        "tags": [
          "installer"
        ],
        "summary": "Enables a host for inclusion in the cluster.",
        "operationId": "EnableHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "installer"
        ],
        "summary": "Disables a host for inclusion in the cluster.",
        "operationId": "DisableHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/hosts/{host_id}/instructions": {
      "get": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Retrieves the next operations that the host agent needs to perform.",
        "operationId": "GetNextSteps",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/steps"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Posts the result of the operations from the host agent.",
        "operationId": "PostStepReply",
        "parameters": [
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "name": "reply",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/step-reply"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/hosts/{host_id}/logs": {
      "get": {
        "security": [
          {
            "userAuth": []
          }
        ],
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "summary": "Download host logs",
        "operationId": "DownloadHostLogs",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "installer"
        ],
        "summary": "Agent API to upload logs.",
        "operationId": "UploadHostLogs",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "type": "file",
            "name": "upfile",
            "in": "formData"
          },
          {
            "type": "string",
            "x-mimetype": "application/zip",
            "description": "The file to upload.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/hosts/{host_id}/progress": {
      "put": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Update installation progress",
        "operationId": "UpdateHostInstallProgress",
        "parameters": [
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the cluster to retrieve",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the host to retrieve",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "New progress value",
            "name": "host-progress",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-progress"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Update install progress"
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/install-config": {
      "get": {
        "tags": [
          "installer"
        ],
        "summary": "Get the cluster install config yaml",
        "operationId": "GetClusterInstallConfig",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "tags": [
          "installer"
        ],
        "summary": "Override values in the install config",
        "operationId": "UpdateClusterInstallConfig",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "name": "install-config-params",
            "in": "body",
            "required": true,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/logs": {
      "get": {
        "security": [
          {
            "userAuth": []
          }
        ],
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "summary": "Download cluster logs",
        "operationId": "DownloadClusterLogs",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/uploads/ingress-cert": {
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Transfer the ingress certificate for the cluster.",
        "operationId": "UploadClusterIngressCert",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "name": "ingress-cert-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ingress-cert-params"
            }
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/component_versions": {
      "get": {
        "tags": [
          "versions"
        ],
        "summary": "List of componenets versions",
        "operationId": "ListComponentVersions",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/list-versions"
            }
          }
        }
      }
    },
    "/domains": {
      "get": {
        "tags": [
          "managed_domains"
        ],
        "summary": "List of managed DNS domains",
        "operationId": "ListManagedDomains",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/list-managed-domains"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/host_requirements": {
      "get": {
        "tags": [
          "installer"
        ],
        "summary": "Get minimum host requirements",
        "operationId": "GetHostRequirements",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host-requirements"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "boot": {
      "type": "object",
      "properties": {
        "current_boot_mode": {
          "type": "string"
        },
        "pxe_interface": {
          "type": "string"
        }
      }
    },
    "cluster": {
      "type": "object",
      "required": [
        "kind",
        "id",
        "href",
        "image_info",
        "status",
        "status_info"
      ],
      "properties": {
        "api_vip": {
          "description": "Virtual IP used to reach the OpenShift cluster API.",
          "type": "string",
          "pattern": "^(([0-9]{1,3}\\.){3}[0-9]{1,3})?$"
        },
        "base_dns_domain": {
          "description": "Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.",
          "type": "string"
        },
        "cluster_network_cidr": {
          "description": "IP address block from which Pod IPs are allocated This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        },
        "cluster_network_host_prefix": {
          "description": "The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.",
          "type": "integer",
          "maximum": 32,
          "minimum": 1
        },
        "created_at": {
          "description": "The time that this cluster was created.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "host_networks": {
          "description": "List of host networks to be filled during query.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/host_network"
          },
          "x-go-custom-tag": "gorm:\"-\""
        },
        "hosts": {
          "description": "Hosts that are associated with this cluster.",
          "type": "array",
          "items": {
            "type": "object",
            "$ref": "#/definitions/host"
          },
          "x-go-custom-tag": "gorm:\"foreignkey:ClusterID;association_foreignkey:ID\""
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string"
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-go-custom-tag": "gorm:\"column:https_proxy\""
        },
        "id": {
          "description": "Unique identifier of the object.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key\""
        },
        "ignition_generator_version": {
          "type": "string"
        },
        "image_info": {
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:image_\"",
          "$ref": "#/definitions/image_info"
        },
        "ingress_vip": {
          "description": "Virtual IP used for cluster ingress traffic.",
          "type": "string",
          "pattern": "^(([0-9]{1,3}\\.){3}[0-9]{1,3})?$"
        },
        "install_completed_at": {
          "description": "The time that this cluster completed installation.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone;default:'2000-01-01 00:00:00z'\""
        },
        "install_config_overrides": {
          "description": "Json formatted string containing the user overrides for the install-config.yaml file",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\"",
          "example": "{\"networking\":{\"networkType\": \"OVN-Kubernetes\"},\"fips\":true}"
        },
        "install_started_at": {
          "description": "The time that this cluster began installation.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone;default:'2000-01-01 00:00:00z'\""
        },
        "kind": {
          "description": "Indicates the type of this object. Will be 'Cluster' if this is a complete object or 'ClusterLink' if it is just a link.",
          "type": "string",
          "enum": [
            "Cluster"
          ]
        },
        "machine_network_cidr": {
          "description": "A CIDR that all hosts belonging to the cluster should have an interfaces with IP address that belongs to this CIDR. The api_vip belongs to this CIDR.",
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        },
        "name": {
          "description": "Name of the OpenShift cluster.",
          "type": "string"
        },
        "no_proxy": {
          "description": "A comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude proxying.",
          "type": "string"
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster.",
          "type": "string",
          "enum": [
            "4.5",
            "4.6"
          ]
        },
        "org_id": {
          "type": "string"
        },
        "pull_secret_set": {
          "description": "True if the pull-secret has been added to the cluster",
          "type": "boolean"
        },
        "service_network_cidr": {
          "description": "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging OpenShift nodes.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(1024)\""
        },
        "status": {
          "description": "Status of the OpenShift cluster.",
          "type": "string",
          "enum": [
            "insufficient",
            "ready",
            "error",
            "preparing-for-installation",
            "pending-for-input",
            "installing",
            "finalizing",
            "installed"
          ]
        },
        "status_info": {
          "description": "Additional information pertaining to the status of the OpenShift cluster.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "status_updated_at": {
          "description": "The last time that the cluster status has been updated",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "updated_at": {
          "description": "The last time that this cluster was updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "user_name": {
          "type": "string"
        },
        "validations_info": {
          "description": "Json formatted string containing the validations results for each validation id grouped by category (network, hosts-data, etc.)",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "vip_dhcp_allocation": {
          "description": "Indicate if VIP DHCP allocation mode is enabled.",
          "type": "boolean",
          "x-nullable": true
        }
      }
    },
    "cluster-create-params": {
      "type": "object",
      "required": [
        "name",
        "openshift_version"
      ],
      "properties": {
        "base_dns_domain": {
          "description": "Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.",
          "type": "string"
        },
        "cluster_network_cidr": {
          "description": "IP address block from which Pod IPs are allocated This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "default": "10.128.0.0/14",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        },
        "cluster_network_host_prefix": {
          "description": "The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.",
          "type": "integer",
          "default": 23,
          "maximum": 32,
          "minimum": 1
        },
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "ingress_vip": {
          "description": "Virtual IP used for cluster ingress traffic.",
          "type": "string",
          "pattern": "^(([0-9]{1,3}\\.){3}[0-9]{1,3})?$"
        },
        "name": {
          "description": "Name of the OpenShift cluster.",
          "type": "string"
        },
        "no_proxy": {
          "description": "A comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude proxying.",
          "type": "string",
          "x-nullable": true
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster.",
          "type": "string",
          "enum": [
            "4.5",
            "4.6"
          ]
        },
        "pull_secret": {
          "description": "The pull secret that obtained from the Pull Secret page on the Red Hat OpenShift Cluster Manager site.",
          "type": "string"
        },
        "service_network_cidr": {
          "description": "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "default": "172.30.0.0/16",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging OpenShift nodes.",
          "type": "string"
        },
        "vip_dhcp_allocation": {
          "description": "Indicate if VIP DHCP allocation mode is enabled.",
          "type": "boolean",
          "default": false,
          "x-nullable": true
        }
      }
    },
    "cluster-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/cluster"
      }
    },
    "cluster-update-params": {
      "type": "object",
      "properties": {
        "api_vip": {
          "description": "Virtual IP used to reach the OpenShift cluster API.",
          "type": "string",
          "pattern": "^(([0-9]{1,3}\\.){3}[0-9]{1,3})?$",
          "x-nullable": true
        },
        "base_dns_domain": {
          "description": "Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.",
          "type": "string",
          "x-nullable": true
        },
        "cluster_network_cidr": {
          "description": "IP address block from which Pod IPs are allocated This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$",
          "x-nullable": true
        },
        "cluster_network_host_prefix": {
          "description": "The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.",
          "type": "integer",
          "maximum": 32,
          "minimum": 1,
          "x-nullable": true
        },
        "hosts_names": {
          "description": "The desired hostname for hosts associated with the cluster.",
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "hostname": {
                "type": "string"
              },
              "id": {
                "type": "string",
                "format": "uuid"
              }
            }
          },
          "x-go-custom-tag": "gorm:\"type:varchar(64)[]\"",
          "x-nullable": true
        },
        "hosts_roles": {
          "description": "The desired role for hosts associated with the cluster.",
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "id": {
                "type": "string",
                "format": "uuid"
              },
              "role": {
                "$ref": "#/definitions/host-role-update-params"
              }
            }
          },
          "x-go-custom-tag": "gorm:\"type:varchar(64)[]\"",
          "x-nullable": true
        },
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "ingress_vip": {
          "description": "Virtual IP used for cluster ingress traffic.",
          "type": "string",
          "pattern": "^(([0-9]{1,3}\\.){3}[0-9]{1,3})?$",
          "x-nullable": true
        },
        "machine_network_cidr": {
          "description": "A CIDR that all hosts belonging to the cluster should have an interfaces with IP address that belongs to this CIDR. The api_vip belongs to this CIDR.",
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$",
          "x-nullable": true
        },
        "name": {
          "description": "OpenShift cluster name",
          "type": "string",
          "x-nullable": true
        },
        "no_proxy": {
          "description": "A comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude proxying.",
          "type": "string",
          "x-nullable": true
        },
        "pull_secret": {
          "description": "The pull secret that obtained from the Pull Secret page on the Red Hat OpenShift Cluster Manager site.",
          "type": "string",
          "x-nullable": true
        },
        "service_network_cidr": {
          "description": "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$",
          "x-nullable": true
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging OpenShift nodes.",
          "type": "string",
          "x-nullable": true
        },
        "vip_dhcp_allocation": {
          "description": "Indicate if VIP DHCP allocation mode is enabled.",
          "type": "boolean",
          "x-nullable": true
        }
      }
    },
    "cluster-validation-id": {
      "type": "string",
      "enum": [
        "machine-cidr-defined",
        "cluster-cidr-defined",
        "service-cidr-defined",
        "no-cidrs-overlapping",
        "network-prefix-valid",
        "machine-cidr-equals-to-calculated-cidr",
        "api-vip-defined",
        "api-vip-valid",
        "ingress-vip-defined",
        "ingress-vip-valid",
        "all-hosts-are-ready-to-install",
        "sufficient-masters-count",
        "dns-domain-defined",
        "pull-secret-set"
      ]
    },
    "completion-params": {
      "type": "object",
      "required": [
        "is_success"
      ],
      "properties": {
        "error_info": {
          "type": "string"
        },
        "is_success": {
          "type": "boolean"
        }
      }
    },
    "connectivity-check-host": {
      "type": "object",
      "properties": {
        "host_id": {
          "type": "string",
          "format": "uuid"
        },
        "nics": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/connectivity-check-nic"
          }
        }
      }
    },
    "connectivity-check-nic": {
      "type": "object",
      "properties": {
        "ip_addresses": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "mac": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "connectivity-check-params": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/connectivity-check-host"
      }
    },
    "connectivity-remote-host": {
      "type": "object",
      "properties": {
        "host_id": {
          "type": "string",
          "format": "uuid"
        },
        "l2_connectivity": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/l2-connectivity"
          }
        },
        "l3_connectivity": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/l3-connectivity"
          }
        }
      }
    },
    "connectivity-report": {
      "type": "object",
      "properties": {
        "remote_hosts": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/connectivity-remote-host"
          }
        }
      }
    },
    "cpu": {
      "type": "object",
      "properties": {
        "architecture": {
          "type": "string"
        },
        "count": {
          "type": "integer"
        },
        "flags": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "frequency": {
          "type": "number"
        },
        "model_name": {
          "type": "string"
        }
      }
    },
    "credentials": {
      "type": "object",
      "properties": {
        "console_url": {
          "type": "string"
        },
        "password": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "dhcp_allocation_request": {
      "type": "object",
      "required": [
        "interface",
        "api_vip_mac",
        "ingress_vip_mac"
      ],
      "properties": {
        "api_vip_mac": {
          "description": "MAC address for API VIP.",
          "type": "string",
          "format": "mac"
        },
        "ingress_vip_mac": {
          "description": "MAC address for Ingress VIP.",
          "type": "string",
          "format": "mac"
        },
        "interface": {
          "description": "The interface (NIC) to run the DHCP requests on.",
          "type": "string"
        }
      }
    },
    "dhcp_allocation_response": {
      "type": "object",
      "required": [
        "api_vip_address",
        "ingress_vip_address"
      ],
      "properties": {
        "api_vip_address": {
          "description": "The IPv4 address that was allocated by DHCP for API VIP.",
          "type": "string",
          "format": "ipv4"
        },
        "ingress_vip_address": {
          "description": "The IPv4 address that was allocated by DHCP for Ingress VIP.",
          "type": "string",
          "format": "ipv4"
        }
      }
    },
    "disk": {
      "type": "object",
      "properties": {
        "by_path": {
          "type": "string"
        },
        "drive_type": {
          "type": "string"
        },
        "hctl": {
          "type": "string"
        },
        "model": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "path": {
          "type": "string"
        },
        "serial": {
          "type": "string"
        },
        "size_bytes": {
          "type": "integer"
        },
        "vendor": {
          "type": "string"
        },
        "wwn": {
          "type": "string"
        }
      }
    },
    "error": {
      "type": "object",
      "required": [
        "kind",
        "id",
        "href",
        "code",
        "reason"
      ],
      "properties": {
        "code": {
          "description": "Globally unique code of the error, composed of the unique identifier of the API and the numeric identifier of the error. For example, for if the numeric identifier of the error is 93 and the identifier of the API is assisted_install then the code will be ASSISTED-INSTALL-93.",
          "type": "string"
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "id": {
          "description": "Numeric identifier of the error.",
          "type": "integer",
          "format": "int32",
          "maximum": 504,
          "minimum": 400
        },
        "kind": {
          "description": "Indicates the type of this object. Will always be 'Error'.",
          "type": "string",
          "enum": [
            "Error"
          ]
        },
        "reason": {
          "description": "Human readable description of the error.",
          "type": "string"
        }
      }
    },
    "event": {
      "type": "object",
      "required": [
        "cluster_id",
        "severity",
        "message",
        "event_time"
      ],
      "properties": {
        "cluster_id": {
          "description": "Unique identifier of the cluster this event relates to.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"index\""
        },
        "event_time": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "host_id": {
          "description": "Unique identifier of the host this event relates to.",
          "type": "string",
          "format": "uuid"
        },
        "message": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(4096)\""
        },
        "request_id": {
          "description": "Unique identifier for the request that caused this event to occure",
          "type": "string",
          "format": "uuid"
        },
        "severity": {
          "type": "string",
          "enum": [
            "info",
            "warning",
            "error",
            "critical"
          ]
        }
      }
    },
    "event-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/event"
      }
    },
    "free-addresses-list": {
      "type": "array",
      "items": {
        "type": "string",
        "format": "ipv4"
      }
    },
    "free_addresses_request": {
      "type": "array",
      "items": {
        "type": "string",
        "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
      }
    },
    "free_network_addresses": {
      "type": "object",
      "properties": {
        "free_addresses": {
          "type": "array",
          "items": {
            "type": "string",
            "format": "ipv4"
          }
        },
        "network": {
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        }
      }
    },
    "free_networks_addresses": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/free_network_addresses"
      }
    },
    "host": {
      "type": "object",
      "required": [
        "kind",
        "id",
        "href",
        "status",
        "status_info"
      ],
      "properties": {
        "bootstrap": {
          "type": "boolean"
        },
        "checked_in_at": {
          "description": "The last time the host's agent communicated with the service.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "cluster_id": {
          "description": "The cluster that this host is associated with.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key;foreignkey:Cluster\""
        },
        "connectivity": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "created_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "discovery_agent_version": {
          "type": "string"
        },
        "free_addresses": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "id": {
          "description": "Unique identifier of the object.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key\""
        },
        "installation_disk_path": {
          "description": "Host installation path",
          "type": "string"
        },
        "installer_version": {
          "description": "Installer version",
          "type": "string"
        },
        "inventory": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "kind": {
          "description": "Indicates the type of this object. Will be 'Host' if this is a complete object or 'HostLink' if it is just a link.",
          "type": "string",
          "enum": [
            "Host"
          ]
        },
        "logs_collected_at": {
          "type": "string",
          "format": "datetime",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "progress": {
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:progress_\"",
          "$ref": "#/definitions/host-progress-info"
        },
        "progress_stages": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/host-stage"
          },
          "x-go-custom-tag": "gorm:\"-\""
        },
        "requested_hostname": {
          "type": "string"
        },
        "role": {
          "$ref": "#/definitions/host-role"
        },
        "stage_started_at": {
          "description": "Time at which the current progress stage started",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "stage_updated_at": {
          "description": "Time at which the current progress stage was last updated",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "status": {
          "type": "string",
          "enum": [
            "discovering",
            "known",
            "disconnected",
            "insufficient",
            "disabled",
            "preparing-for-installation",
            "pending-for-input",
            "installing",
            "installing-in-progress",
            "installing-pending-user-action",
            "resetting-pending-user-action",
            "installed",
            "error",
            "resetting"
          ]
        },
        "status_info": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "status_updated_at": {
          "description": "The last time that the host status has been updated",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "updated_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "user_name": {
          "type": "string"
        },
        "validations_info": {
          "description": "Json formatted string containing the validations results for each validation id grouped by category (network, hardware, etc.)",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        }
      }
    },
    "host-create-params": {
      "type": "object",
      "required": [
        "host_id"
      ],
      "properties": {
        "discovery_agent_version": {
          "type": "string"
        },
        "host_id": {
          "type": "string",
          "format": "uuid"
        }
      }
    },
    "host-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/host"
      }
    },
    "host-progress": {
      "type": "object",
      "required": [
        "current_stage"
      ],
      "properties": {
        "current_stage": {
          "type": "string",
          "$ref": "#/definitions/host-stage"
        },
        "progress_info": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        }
      }
    },
    "host-progress-info": {
      "type": "object",
      "required": [
        "current_stage"
      ],
      "properties": {
        "current_stage": {
          "type": "string",
          "$ref": "#/definitions/host-stage"
        },
        "progress_info": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "stage_started_at": {
          "description": "Time at which the current progress stage started",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "stage_updated_at": {
          "description": "Time at which the current progress stage was last updated",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        }
      }
    },
    "host-requirements": {
      "type": "object",
      "properties": {
        "master": {
          "$ref": "#/definitions/host-requirements-role"
        },
        "worker": {
          "$ref": "#/definitions/host-requirements-role"
        }
      }
    },
    "host-requirements-role": {
      "type": "object",
      "properties": {
        "cpu_cores": {
          "type": "integer"
        },
        "disk_size_gb": {
          "type": "integer"
        },
        "ram_gib": {
          "type": "integer"
        }
      }
    },
    "host-role": {
      "type": "string",
      "enum": [
        "auto-assign",
        "master",
        "worker",
        "bootstrap"
      ]
    },
    "host-role-update-params": {
      "type": "string",
      "enum": [
        "auto-assign",
        "master",
        "worker"
      ]
    },
    "host-stage": {
      "type": "string",
      "enum": [
        "Starting installation",
        "Waiting for control plane",
        "Start Waiting for control plane",
        "Installing",
        "Writing image to disk",
        "Rebooting",
        "Waiting for ignition",
        "Configuring",
        "Joined",
        "Done",
        "Failed"
      ]
    },
    "host-validation-id": {
      "type": "string",
      "enum": [
        "connected",
        "has-inventory",
        "has-min-cpu-cores",
        "has-min-valid-disks",
        "has-min-memory",
        "machine-cidr-defined",
        "role-defined",
        "has-cpu-cores-for-role",
        "has-memory-for-role",
        "hostname-unique",
        "hostname-valid",
        "belongs-to-machine-cidr"
      ]
    },
    "host_network": {
      "type": "object",
      "properties": {
        "cidr": {
          "type": "string"
        },
        "host_ids": {
          "type": "array",
          "items": {
            "type": "string",
            "format": "uuid"
          }
        }
      }
    },
    "image-create-params": {
      "type": "object",
      "properties": {
        "ssh_public_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string"
        }
      }
    },
    "image_info": {
      "type": "object",
      "properties": {
        "created_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "download_url": {
          "type": "string"
        },
        "expires_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "generator_version": {
          "description": "Image generator version",
          "type": "string"
        },
        "size_bytes": {
          "type": "integer"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging the installation",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(1024)\""
        }
      }
    },
    "infra_error": {
      "type": "object",
      "required": [
        "code",
        "message"
      ],
      "properties": {
        "code": {
          "description": "Numeric identifier of the error.",
          "type": "integer",
          "format": "int32",
          "maximum": 403,
          "minimum": 401
        },
        "message": {
          "description": "Human readable description of the error.",
          "type": "string"
        }
      }
    },
    "ingress-cert-params": {
      "type": "string"
    },
    "interface": {
      "type": "object",
      "properties": {
        "biosdevname": {
          "type": "string"
        },
        "client_id": {
          "type": "string"
        },
        "flags": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "has_carrier": {
          "type": "boolean"
        },
        "ipv4_addresses": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "ipv6_addresses": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "mac_address": {
          "type": "string"
        },
        "mtu": {
          "type": "integer"
        },
        "name": {
          "type": "string"
        },
        "product": {
          "type": "string"
        },
        "speed_mbps": {
          "type": "integer"
        },
        "vendor": {
          "type": "string"
        }
      }
    },
    "inventory": {
      "type": "object",
      "properties": {
        "bmc_address": {
          "type": "string"
        },
        "bmc_v6address": {
          "type": "string"
        },
        "boot": {
          "$ref": "#/definitions/boot"
        },
        "cpu": {
          "$ref": "#/definitions/cpu"
        },
        "disks": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/disk"
          }
        },
        "hostname": {
          "type": "string"
        },
        "interfaces": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/interface"
          }
        },
        "memory": {
          "$ref": "#/definitions/memory"
        },
        "system_vendor": {
          "$ref": "#/definitions/system_vendor"
        }
      }
    },
    "l2-connectivity": {
      "type": "object",
      "properties": {
        "outgoing_ip_address": {
          "type": "string"
        },
        "outgoing_nic": {
          "type": "string"
        },
        "remote_ip_address": {
          "type": "string"
        },
        "remote_mac": {
          "type": "string"
        },
        "successful": {
          "type": "boolean"
        }
      }
    },
    "l3-connectivity": {
      "type": "object",
      "properties": {
        "outgoing_nic": {
          "type": "string"
        },
        "remote_ip_address": {
          "type": "string"
        },
        "successful": {
          "type": "boolean"
        }
      }
    },
    "list-managed-domains": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/managed-domain"
      }
    },
    "list-versions": {
      "type": "object",
      "properties": {
        "release_tag": {
          "type": "string"
        },
        "versions": {
          "$ref": "#/definitions/versions"
        }
      }
    },
    "managed-domain": {
      "type": "object",
      "properties": {
        "domain": {
          "type": "string"
        },
        "provider": {
          "type": "string",
          "enum": [
            "route53"
          ]
        }
      }
    },
    "memory": {
      "type": "object",
      "properties": {
        "physical_bytes": {
          "type": "integer"
        },
        "usable_bytes": {
          "type": "integer"
        }
      }
    },
    "presigned": {
      "type": "object",
      "required": [
        "url"
      ],
      "properties": {
        "url": {
          "type": "string"
        }
      }
    },
    "step": {
      "type": "object",
      "properties": {
        "args": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "command": {
          "type": "string"
        },
        "step_id": {
          "type": "string"
        },
        "step_type": {
          "$ref": "#/definitions/step-type"
        }
      }
    },
    "step-reply": {
      "type": "object",
      "properties": {
        "error": {
          "type": "string"
        },
        "exit_code": {
          "type": "integer"
        },
        "output": {
          "type": "string"
        },
        "step_id": {
          "type": "string"
        },
        "step_type": {
          "$ref": "#/definitions/step-type"
        }
      }
    },
    "step-type": {
      "type": "string",
      "enum": [
        "connectivity-check",
        "execute",
        "inventory",
        "install",
        "free-network-addresses",
        "reset-installation",
        "dhcp-lease-allocate"
      ]
    },
    "steps": {
      "type": "object",
      "properties": {
        "instructions": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/step"
          }
        },
        "next_instruction_seconds": {
          "type": "integer"
        }
      }
    },
    "steps-reply": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/step-reply"
      }
    },
    "system_vendor": {
      "type": "object",
      "properties": {
        "manufacturer": {
          "type": "string"
        },
        "product_name": {
          "type": "string"
        },
        "serial_number": {
          "type": "string"
        }
      }
    },
    "versions": {
      "type": "object",
      "additionalProperties": {
        "type": "string"
      }
    }
  },
  "securityDefinitions": {
    "agentAuth": {
      "type": "apiKey",
      "name": "X-Secret-Key",
      "in": "header"
    },
    "userAuth": {
      "type": "apiKey",
      "name": "Authorization",
      "in": "header"
    }
  },
  "security": [
    {
      "userAuth": []
    }
  ],
  "tags": [
    {
      "description": "Assisted bare metal installation",
      "name": "Assisted installation"
    }
  ]
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "http",
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "Assisted installation",
    "title": "AssistedInstall",
    "version": "1.0.0"
  },
  "host": "api.openshift.com",
  "basePath": "/api/assisted-install/v1",
  "paths": {
    "/clusters": {
      "get": {
        "tags": [
          "installer"
        ],
        "summary": "Retrieves the list of OpenShift bare metal clusters.",
        "operationId": "ListClusters",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "installer"
        ],
        "summary": "Creates a new OpenShift bare metal cluster definition.",
        "operationId": "RegisterCluster",
        "parameters": [
          {
            "name": "new-cluster-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cluster-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}": {
      "get": {
        "security": [
          {
            "userAuth": []
          },
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Retrieves the details of the OpenShift bare metal cluster.",
        "operationId": "GetCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "installer"
        ],
        "summary": "Deletes an OpenShift bare metal cluster definition.",
        "operationId": "DeregisterCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "tags": [
          "installer"
        ],
        "summary": "Updates an OpenShift bare metal cluster definition.",
        "operationId": "UpdateCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "name": "cluster-update-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/cluster-update-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/actions/cancel": {
      "post": {
        "tags": [
          "installer"
        ],
        "summary": "Cancels an ongoing installation.",
        "operationId": "CancelInstallation",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/actions/complete_installation": {
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Agent API to mark a finalizing installation as complete.",
        "operationId": "CompleteInstallation",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "name": "completion-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/completion-params"
            }
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/actions/install": {
      "post": {
        "tags": [
          "installer"
        ],
        "summary": "Installs the OpenShift bare metal cluster.",
        "operationId": "InstallCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/actions/reset": {
      "post": {
        "tags": [
          "installer"
        ],
        "summary": "Resets a failed installation.",
        "operationId": "ResetCluster",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "202": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/credentials": {
      "get": {
        "tags": [
          "installer"
        ],
        "summary": "Get the the cluster admin credentials.",
        "operationId": "GetCredentials",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/credentials"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/downloads/files": {
      "get": {
        "security": [
          {
            "userAuth": []
          },
          {
            "agentAuth": []
          }
        ],
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "summary": "Downloads files relating to the installed/installing cluster.",
        "operationId": "DownloadClusterFiles",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "bootstrap.ign",
              "master.ign",
              "metadata.json",
              "worker.ign",
              "kubeadmin-password",
              "kubeconfig",
              "kubeconfig-noingress",
              "install-config.yaml"
            ],
            "type": "string",
            "name": "file_name",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/downloads/files-presigned": {
      "get": {
        "security": [
          {
            "userAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Retrieves a presigned S3 URL for downloading cluster files.",
        "operationId": "GetPresignedForClusterFiles",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "enum": [
              "bootstrap.ign",
              "master.ign",
              "metadata.json",
              "worker.ign",
              "kubeadmin-password",
              "kubeconfig",
              "kubeconfig-noingress",
              "install-config.yaml",
              "logs"
            ],
            "type": "string",
            "name": "file_name",
            "in": "query",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/presigned"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/downloads/image": {
      "get": {
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "summary": "Downloads the OpenShift per-cluster discovery ISO.",
        "operationId": "DownloadClusterISO",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed."
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "tags": [
          "installer"
        ],
        "summary": "Creates a new OpenShift per-cluster discovery ISO.",
        "operationId": "GenerateClusterISO",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "name": "image-create-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/image-create-params"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/downloads/kubeconfig": {
      "get": {
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "summary": "Downloads the kubeconfig file for this cluster.",
        "operationId": "DownloadClusterKubeconfig",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string",
              "format": "binary"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/events": {
      "get": {
        "tags": [
          "events"
        ],
        "summary": "Lists events for a cluster",
        "operationId": "ListEvents",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/event-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/free_addresses": {
      "get": {
        "tags": [
          "installer"
        ],
        "summary": "Retrieves the free address list for a network.",
        "operationId": "GetFreeAddresses",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$",
            "type": "string",
            "name": "network",
            "in": "query",
            "required": true
          },
          {
            "maximum": 8000,
            "minimum": 1,
            "type": "integer",
            "default": 8000,
            "name": "limit",
            "in": "query"
          },
          {
            "type": "string",
            "name": "prefix",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Success",
            "schema": {
              "$ref": "#/definitions/free-addresses-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/hosts": {
      "get": {
        "security": [
          {
            "userAuth": []
          },
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Retrieves the list of OpenShift bare metal hosts.",
        "operationId": "ListHosts",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host-list"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Registers a new OpenShift bare metal host.",
        "operationId": "RegisterHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "name": "new-host-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-create-params"
            }
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "201": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/hosts/{host_id}": {
      "get": {
        "tags": [
          "installer"
        ],
        "summary": "Retrieves the details of the OpenShift bare metal host.",
        "operationId": "GetHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "installer"
        ],
        "summary": "Deregisters an OpenShift bare metal host.",
        "operationId": "DeregisterHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/hosts/{host_id}/actions/enable": {
      "post": {
        "tags": [
          "installer"
        ],
        "summary": "Enables a host for inclusion in the cluster.",
        "operationId": "EnableHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "delete": {
        "tags": [
          "installer"
        ],
        "summary": "Disables a host for inclusion in the cluster.",
        "operationId": "DisableHost",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/cluster"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/hosts/{host_id}/instructions": {
      "get": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Retrieves the next operations that the host agent needs to perform.",
        "operationId": "GetNextSteps",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/steps"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Posts the result of the operations from the host agent.",
        "operationId": "PostStepReply",
        "parameters": [
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "name": "reply",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/step-reply"
            }
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/hosts/{host_id}/logs": {
      "get": {
        "security": [
          {
            "userAuth": []
          }
        ],
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "summary": "Download host logs",
        "operationId": "DownloadHostLogs",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "consumes": [
          "multipart/form-data"
        ],
        "tags": [
          "installer"
        ],
        "summary": "Agent API to upload logs.",
        "operationId": "UploadHostLogs",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "type": "file",
            "name": "upfile",
            "in": "formData"
          },
          {
            "type": "string",
            "x-mimetype": "application/zip",
            "description": "The file to upload.",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "204": {
            "description": "Success."
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/hosts/{host_id}/progress": {
      "put": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Update installation progress",
        "operationId": "UpdateHostInstallProgress",
        "parameters": [
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the cluster to retrieve",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The ID of the host to retrieve",
            "name": "host_id",
            "in": "path",
            "required": true
          },
          {
            "description": "New progress value",
            "name": "host-progress",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/host-progress"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Update install progress"
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/install-config": {
      "get": {
        "tags": [
          "installer"
        ],
        "summary": "Get the cluster install config yaml",
        "operationId": "GetClusterInstallConfig",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "string"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      },
      "patch": {
        "tags": [
          "installer"
        ],
        "summary": "Override values in the install config",
        "operationId": "UpdateClusterInstallConfig",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "name": "install-config-params",
            "in": "body",
            "required": true,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/logs": {
      "get": {
        "security": [
          {
            "userAuth": []
          }
        ],
        "produces": [
          "application/octet-stream"
        ],
        "tags": [
          "installer"
        ],
        "summary": "Download cluster logs",
        "operationId": "DownloadClusterLogs",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "type": "file"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "409": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/clusters/{cluster_id}/uploads/ingress-cert": {
      "post": {
        "security": [
          {
            "agentAuth": []
          }
        ],
        "tags": [
          "installer"
        ],
        "summary": "Transfer the ingress certificate for the cluster.",
        "operationId": "UploadClusterIngressCert",
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "name": "cluster_id",
            "in": "path",
            "required": true
          },
          {
            "name": "ingress-cert-params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ingress-cert-params"
            }
          },
          {
            "type": "string",
            "name": "discovery_agent_version",
            "in": "header"
          }
        ],
        "responses": {
          "201": {
            "description": "Success."
          },
          "400": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/infra_error"
            }
          },
          "404": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "503": {
            "description": "Unavailable.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/component_versions": {
      "get": {
        "tags": [
          "versions"
        ],
        "summary": "List of componenets versions",
        "operationId": "ListComponentVersions",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/list-versions"
            }
          }
        }
      }
    },
    "/domains": {
      "get": {
        "tags": [
          "managed_domains"
        ],
        "summary": "List of managed DNS domains",
        "operationId": "ListManagedDomains",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/list-managed-domains"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    },
    "/host_requirements": {
      "get": {
        "tags": [
          "installer"
        ],
        "summary": "Get minimum host requirements",
        "operationId": "GetHostRequirements",
        "responses": {
          "200": {
            "description": "Success.",
            "schema": {
              "$ref": "#/definitions/host-requirements"
            }
          },
          "401": {
            "description": "Unauthorized.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "403": {
            "description": "Forbidden.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "405": {
            "description": "Method Not Allowed.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          },
          "500": {
            "description": "Error.",
            "schema": {
              "$ref": "#/definitions/error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "ClusterUpdateParamsHostsNamesItems0": {
      "type": "object",
      "properties": {
        "hostname": {
          "type": "string"
        },
        "id": {
          "type": "string",
          "format": "uuid"
        }
      }
    },
    "ClusterUpdateParamsHostsRolesItems0": {
      "type": "object",
      "properties": {
        "id": {
          "type": "string",
          "format": "uuid"
        },
        "role": {
          "$ref": "#/definitions/host-role-update-params"
        }
      }
    },
    "boot": {
      "type": "object",
      "properties": {
        "current_boot_mode": {
          "type": "string"
        },
        "pxe_interface": {
          "type": "string"
        }
      }
    },
    "cluster": {
      "type": "object",
      "required": [
        "kind",
        "id",
        "href",
        "image_info",
        "status",
        "status_info"
      ],
      "properties": {
        "api_vip": {
          "description": "Virtual IP used to reach the OpenShift cluster API.",
          "type": "string",
          "pattern": "^(([0-9]{1,3}\\.){3}[0-9]{1,3})?$"
        },
        "base_dns_domain": {
          "description": "Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.",
          "type": "string"
        },
        "cluster_network_cidr": {
          "description": "IP address block from which Pod IPs are allocated This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        },
        "cluster_network_host_prefix": {
          "description": "The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.",
          "type": "integer",
          "maximum": 32,
          "minimum": 1
        },
        "created_at": {
          "description": "The time that this cluster was created.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "host_networks": {
          "description": "List of host networks to be filled during query.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/host_network"
          },
          "x-go-custom-tag": "gorm:\"-\""
        },
        "hosts": {
          "description": "Hosts that are associated with this cluster.",
          "type": "array",
          "items": {
            "type": "object",
            "$ref": "#/definitions/host"
          },
          "x-go-custom-tag": "gorm:\"foreignkey:ClusterID;association_foreignkey:ID\""
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string"
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-go-custom-tag": "gorm:\"column:https_proxy\""
        },
        "id": {
          "description": "Unique identifier of the object.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key\""
        },
        "ignition_generator_version": {
          "type": "string"
        },
        "image_info": {
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:image_\"",
          "$ref": "#/definitions/image_info"
        },
        "ingress_vip": {
          "description": "Virtual IP used for cluster ingress traffic.",
          "type": "string",
          "pattern": "^(([0-9]{1,3}\\.){3}[0-9]{1,3})?$"
        },
        "install_completed_at": {
          "description": "The time that this cluster completed installation.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone;default:'2000-01-01 00:00:00z'\""
        },
        "install_config_overrides": {
          "description": "Json formatted string containing the user overrides for the install-config.yaml file",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\"",
          "example": "{\"networking\":{\"networkType\": \"OVN-Kubernetes\"},\"fips\":true}"
        },
        "install_started_at": {
          "description": "The time that this cluster began installation.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone;default:'2000-01-01 00:00:00z'\""
        },
        "kind": {
          "description": "Indicates the type of this object. Will be 'Cluster' if this is a complete object or 'ClusterLink' if it is just a link.",
          "type": "string",
          "enum": [
            "Cluster"
          ]
        },
        "machine_network_cidr": {
          "description": "A CIDR that all hosts belonging to the cluster should have an interfaces with IP address that belongs to this CIDR. The api_vip belongs to this CIDR.",
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        },
        "name": {
          "description": "Name of the OpenShift cluster.",
          "type": "string"
        },
        "no_proxy": {
          "description": "A comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude proxying.",
          "type": "string"
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster.",
          "type": "string",
          "enum": [
            "4.5",
            "4.6"
          ]
        },
        "org_id": {
          "type": "string"
        },
        "pull_secret_set": {
          "description": "True if the pull-secret has been added to the cluster",
          "type": "boolean"
        },
        "service_network_cidr": {
          "description": "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging OpenShift nodes.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(1024)\""
        },
        "status": {
          "description": "Status of the OpenShift cluster.",
          "type": "string",
          "enum": [
            "insufficient",
            "ready",
            "error",
            "preparing-for-installation",
            "pending-for-input",
            "installing",
            "finalizing",
            "installed"
          ]
        },
        "status_info": {
          "description": "Additional information pertaining to the status of the OpenShift cluster.",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "status_updated_at": {
          "description": "The last time that the cluster status has been updated",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "updated_at": {
          "description": "The last time that this cluster was updated.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "user_name": {
          "type": "string"
        },
        "validations_info": {
          "description": "Json formatted string containing the validations results for each validation id grouped by category (network, hosts-data, etc.)",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "vip_dhcp_allocation": {
          "description": "Indicate if VIP DHCP allocation mode is enabled.",
          "type": "boolean",
          "x-nullable": true
        }
      }
    },
    "cluster-create-params": {
      "type": "object",
      "required": [
        "name",
        "openshift_version"
      ],
      "properties": {
        "base_dns_domain": {
          "description": "Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.",
          "type": "string"
        },
        "cluster_network_cidr": {
          "description": "IP address block from which Pod IPs are allocated This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "default": "10.128.0.0/14",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        },
        "cluster_network_host_prefix": {
          "description": "The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.",
          "type": "integer",
          "default": 23,
          "maximum": 32,
          "minimum": 1
        },
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "ingress_vip": {
          "description": "Virtual IP used for cluster ingress traffic.",
          "type": "string",
          "pattern": "^(([0-9]{1,3}\\.){3}[0-9]{1,3})?$"
        },
        "name": {
          "description": "Name of the OpenShift cluster.",
          "type": "string"
        },
        "no_proxy": {
          "description": "A comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude proxying.",
          "type": "string",
          "x-nullable": true
        },
        "openshift_version": {
          "description": "Version of the OpenShift cluster.",
          "type": "string",
          "enum": [
            "4.5",
            "4.6"
          ]
        },
        "pull_secret": {
          "description": "The pull secret that obtained from the Pull Secret page on the Red Hat OpenShift Cluster Manager site.",
          "type": "string"
        },
        "service_network_cidr": {
          "description": "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "default": "172.30.0.0/16",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging OpenShift nodes.",
          "type": "string"
        },
        "vip_dhcp_allocation": {
          "description": "Indicate if VIP DHCP allocation mode is enabled.",
          "type": "boolean",
          "default": false,
          "x-nullable": true
        }
      }
    },
    "cluster-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/cluster"
      }
    },
    "cluster-update-params": {
      "type": "object",
      "properties": {
        "api_vip": {
          "description": "Virtual IP used to reach the OpenShift cluster API.",
          "type": "string",
          "pattern": "^(([0-9]{1,3}\\.){3}[0-9]{1,3})?$",
          "x-nullable": true
        },
        "base_dns_domain": {
          "description": "Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.",
          "type": "string",
          "x-nullable": true
        },
        "cluster_network_cidr": {
          "description": "IP address block from which Pod IPs are allocated This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$",
          "x-nullable": true
        },
        "cluster_network_host_prefix": {
          "description": "The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.",
          "type": "integer",
          "maximum": 32,
          "minimum": 1,
          "x-nullable": true
        },
        "hosts_names": {
          "description": "The desired hostname for hosts associated with the cluster.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/ClusterUpdateParamsHostsNamesItems0"
          },
          "x-go-custom-tag": "gorm:\"type:varchar(64)[]\"",
          "x-nullable": true
        },
        "hosts_roles": {
          "description": "The desired role for hosts associated with the cluster.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/ClusterUpdateParamsHostsRolesItems0"
          },
          "x-go-custom-tag": "gorm:\"type:varchar(64)[]\"",
          "x-nullable": true
        },
        "http_proxy": {
          "description": "A proxy URL to use for creating HTTP connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "https_proxy": {
          "description": "A proxy URL to use for creating HTTPS connections outside the cluster.\nhttp://\\\u003cusername\\\u003e:\\\u003cpswd\\\u003e@\\\u003cip\\\u003e:\\\u003cport\\\u003e\n",
          "type": "string",
          "x-nullable": true
        },
        "ingress_vip": {
          "description": "Virtual IP used for cluster ingress traffic.",
          "type": "string",
          "pattern": "^(([0-9]{1,3}\\.){3}[0-9]{1,3})?$",
          "x-nullable": true
        },
        "machine_network_cidr": {
          "description": "A CIDR that all hosts belonging to the cluster should have an interfaces with IP address that belongs to this CIDR. The api_vip belongs to this CIDR.",
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$",
          "x-nullable": true
        },
        "name": {
          "description": "OpenShift cluster name",
          "type": "string",
          "x-nullable": true
        },
        "no_proxy": {
          "description": "A comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude proxying.",
          "type": "string",
          "x-nullable": true
        },
        "pull_secret": {
          "description": "The pull secret that obtained from the Pull Secret page on the Red Hat OpenShift Cluster Manager site.",
          "type": "string",
          "x-nullable": true
        },
        "service_network_cidr": {
          "description": "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$",
          "x-nullable": true
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging OpenShift nodes.",
          "type": "string",
          "x-nullable": true
        },
        "vip_dhcp_allocation": {
          "description": "Indicate if VIP DHCP allocation mode is enabled.",
          "type": "boolean",
          "x-nullable": true
        }
      }
    },
    "cluster-validation-id": {
      "type": "string",
      "enum": [
        "machine-cidr-defined",
        "cluster-cidr-defined",
        "service-cidr-defined",
        "no-cidrs-overlapping",
        "network-prefix-valid",
        "machine-cidr-equals-to-calculated-cidr",
        "api-vip-defined",
        "api-vip-valid",
        "ingress-vip-defined",
        "ingress-vip-valid",
        "all-hosts-are-ready-to-install",
        "sufficient-masters-count",
        "dns-domain-defined",
        "pull-secret-set"
      ]
    },
    "completion-params": {
      "type": "object",
      "required": [
        "is_success"
      ],
      "properties": {
        "error_info": {
          "type": "string"
        },
        "is_success": {
          "type": "boolean"
        }
      }
    },
    "connectivity-check-host": {
      "type": "object",
      "properties": {
        "host_id": {
          "type": "string",
          "format": "uuid"
        },
        "nics": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/connectivity-check-nic"
          }
        }
      }
    },
    "connectivity-check-nic": {
      "type": "object",
      "properties": {
        "ip_addresses": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "mac": {
          "type": "string"
        },
        "name": {
          "type": "string"
        }
      }
    },
    "connectivity-check-params": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/connectivity-check-host"
      }
    },
    "connectivity-remote-host": {
      "type": "object",
      "properties": {
        "host_id": {
          "type": "string",
          "format": "uuid"
        },
        "l2_connectivity": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/l2-connectivity"
          }
        },
        "l3_connectivity": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/l3-connectivity"
          }
        }
      }
    },
    "connectivity-report": {
      "type": "object",
      "properties": {
        "remote_hosts": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/connectivity-remote-host"
          }
        }
      }
    },
    "cpu": {
      "type": "object",
      "properties": {
        "architecture": {
          "type": "string"
        },
        "count": {
          "type": "integer"
        },
        "flags": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "frequency": {
          "type": "number"
        },
        "model_name": {
          "type": "string"
        }
      }
    },
    "credentials": {
      "type": "object",
      "properties": {
        "console_url": {
          "type": "string"
        },
        "password": {
          "type": "string"
        },
        "username": {
          "type": "string"
        }
      }
    },
    "dhcp_allocation_request": {
      "type": "object",
      "required": [
        "interface",
        "api_vip_mac",
        "ingress_vip_mac"
      ],
      "properties": {
        "api_vip_mac": {
          "description": "MAC address for API VIP.",
          "type": "string",
          "format": "mac"
        },
        "ingress_vip_mac": {
          "description": "MAC address for Ingress VIP.",
          "type": "string",
          "format": "mac"
        },
        "interface": {
          "description": "The interface (NIC) to run the DHCP requests on.",
          "type": "string"
        }
      }
    },
    "dhcp_allocation_response": {
      "type": "object",
      "required": [
        "api_vip_address",
        "ingress_vip_address"
      ],
      "properties": {
        "api_vip_address": {
          "description": "The IPv4 address that was allocated by DHCP for API VIP.",
          "type": "string",
          "format": "ipv4"
        },
        "ingress_vip_address": {
          "description": "The IPv4 address that was allocated by DHCP for Ingress VIP.",
          "type": "string",
          "format": "ipv4"
        }
      }
    },
    "disk": {
      "type": "object",
      "properties": {
        "by_path": {
          "type": "string"
        },
        "drive_type": {
          "type": "string"
        },
        "hctl": {
          "type": "string"
        },
        "model": {
          "type": "string"
        },
        "name": {
          "type": "string"
        },
        "path": {
          "type": "string"
        },
        "serial": {
          "type": "string"
        },
        "size_bytes": {
          "type": "integer"
        },
        "vendor": {
          "type": "string"
        },
        "wwn": {
          "type": "string"
        }
      }
    },
    "error": {
      "type": "object",
      "required": [
        "kind",
        "id",
        "href",
        "code",
        "reason"
      ],
      "properties": {
        "code": {
          "description": "Globally unique code of the error, composed of the unique identifier of the API and the numeric identifier of the error. For example, for if the numeric identifier of the error is 93 and the identifier of the API is assisted_install then the code will be ASSISTED-INSTALL-93.",
          "type": "string"
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "id": {
          "description": "Numeric identifier of the error.",
          "type": "integer",
          "format": "int32",
          "maximum": 504,
          "minimum": 400
        },
        "kind": {
          "description": "Indicates the type of this object. Will always be 'Error'.",
          "type": "string",
          "enum": [
            "Error"
          ]
        },
        "reason": {
          "description": "Human readable description of the error.",
          "type": "string"
        }
      }
    },
    "event": {
      "type": "object",
      "required": [
        "cluster_id",
        "severity",
        "message",
        "event_time"
      ],
      "properties": {
        "cluster_id": {
          "description": "Unique identifier of the cluster this event relates to.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"index\""
        },
        "event_time": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "host_id": {
          "description": "Unique identifier of the host this event relates to.",
          "type": "string",
          "format": "uuid"
        },
        "message": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(4096)\""
        },
        "request_id": {
          "description": "Unique identifier for the request that caused this event to occure",
          "type": "string",
          "format": "uuid"
        },
        "severity": {
          "type": "string",
          "enum": [
            "info",
            "warning",
            "error",
            "critical"
          ]
        }
      }
    },
    "event-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/event"
      }
    },
    "free-addresses-list": {
      "type": "array",
      "items": {
        "type": "string",
        "format": "ipv4"
      }
    },
    "free_addresses_request": {
      "type": "array",
      "items": {
        "type": "string",
        "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
      }
    },
    "free_network_addresses": {
      "type": "object",
      "properties": {
        "free_addresses": {
          "type": "array",
          "items": {
            "type": "string",
            "format": "ipv4"
          }
        },
        "network": {
          "type": "string",
          "pattern": "^([0-9]{1,3}\\.){3}[0-9]{1,3}\\/[0-9]|[1-2][0-9]|3[0-2]?$"
        }
      }
    },
    "free_networks_addresses": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/free_network_addresses"
      }
    },
    "host": {
      "type": "object",
      "required": [
        "kind",
        "id",
        "href",
        "status",
        "status_info"
      ],
      "properties": {
        "bootstrap": {
          "type": "boolean"
        },
        "checked_in_at": {
          "description": "The last time the host's agent communicated with the service.",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "cluster_id": {
          "description": "The cluster that this host is associated with.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key;foreignkey:Cluster\""
        },
        "connectivity": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "created_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "discovery_agent_version": {
          "type": "string"
        },
        "free_addresses": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "href": {
          "description": "Self link.",
          "type": "string"
        },
        "id": {
          "description": "Unique identifier of the object.",
          "type": "string",
          "format": "uuid",
          "x-go-custom-tag": "gorm:\"primary_key\""
        },
        "installation_disk_path": {
          "description": "Host installation path",
          "type": "string"
        },
        "installer_version": {
          "description": "Installer version",
          "type": "string"
        },
        "inventory": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:text\""
        },
        "kind": {
          "description": "Indicates the type of this object. Will be 'Host' if this is a complete object or 'HostLink' if it is just a link.",
          "type": "string",
          "enum": [
            "Host"
          ]
        },
        "logs_collected_at": {
          "type": "string",
          "format": "datetime",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "progress": {
          "x-go-custom-tag": "gorm:\"embedded;embedded_prefix:progress_\"",
          "$ref": "#/definitions/host-progress-info"
        },
        "progress_stages": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/host-stage"
          },
          "x-go-custom-tag": "gorm:\"-\""
        },
        "requested_hostname": {
          "type": "string"
        },
        "role": {
          "$ref": "#/definitions/host-role"
        },
        "stage_started_at": {
          "description": "Time at which the current progress stage started",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "stage_updated_at": {
          "description": "Time at which the current progress stage was last updated",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "status": {
          "type": "string",
          "enum": [
            "discovering",
            "known",
            "disconnected",
            "insufficient",
            "disabled",
            "preparing-for-installation",
            "pending-for-input",
            "installing",
            "installing-in-progress",
            "installing-pending-user-action",
            "resetting-pending-user-action",
            "installed",
            "error",
            "resetting"
          ]
        },
        "status_info": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "status_updated_at": {
          "description": "The last time that the host status has been updated",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "updated_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "user_name": {
          "type": "string"
        },
        "validations_info": {
          "description": "Json formatted string containing the validations results for each validation id grouped by category (network, hardware, etc.)",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        }
      }
    },
    "host-create-params": {
      "type": "object",
      "required": [
        "host_id"
      ],
      "properties": {
        "discovery_agent_version": {
          "type": "string"
        },
        "host_id": {
          "type": "string",
          "format": "uuid"
        }
      }
    },
    "host-list": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/host"
      }
    },
    "host-progress": {
      "type": "object",
      "required": [
        "current_stage"
      ],
      "properties": {
        "current_stage": {
          "type": "string",
          "$ref": "#/definitions/host-stage"
        },
        "progress_info": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        }
      }
    },
    "host-progress-info": {
      "type": "object",
      "required": [
        "current_stage"
      ],
      "properties": {
        "current_stage": {
          "type": "string",
          "$ref": "#/definitions/host-stage"
        },
        "progress_info": {
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(2048)\""
        },
        "stage_started_at": {
          "description": "Time at which the current progress stage started",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "stage_updated_at": {
          "description": "Time at which the current progress stage was last updated",
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        }
      }
    },
    "host-requirements": {
      "type": "object",
      "properties": {
        "master": {
          "$ref": "#/definitions/host-requirements-role"
        },
        "worker": {
          "$ref": "#/definitions/host-requirements-role"
        }
      }
    },
    "host-requirements-role": {
      "type": "object",
      "properties": {
        "cpu_cores": {
          "type": "integer"
        },
        "disk_size_gb": {
          "type": "integer"
        },
        "ram_gib": {
          "type": "integer"
        }
      }
    },
    "host-role": {
      "type": "string",
      "enum": [
        "auto-assign",
        "master",
        "worker",
        "bootstrap"
      ]
    },
    "host-role-update-params": {
      "type": "string",
      "enum": [
        "auto-assign",
        "master",
        "worker"
      ]
    },
    "host-stage": {
      "type": "string",
      "enum": [
        "Starting installation",
        "Waiting for control plane",
        "Start Waiting for control plane",
        "Installing",
        "Writing image to disk",
        "Rebooting",
        "Waiting for ignition",
        "Configuring",
        "Joined",
        "Done",
        "Failed"
      ]
    },
    "host-validation-id": {
      "type": "string",
      "enum": [
        "connected",
        "has-inventory",
        "has-min-cpu-cores",
        "has-min-valid-disks",
        "has-min-memory",
        "machine-cidr-defined",
        "role-defined",
        "has-cpu-cores-for-role",
        "has-memory-for-role",
        "hostname-unique",
        "hostname-valid",
        "belongs-to-machine-cidr"
      ]
    },
    "host_network": {
      "type": "object",
      "properties": {
        "cidr": {
          "type": "string"
        },
        "host_ids": {
          "type": "array",
          "items": {
            "type": "string",
            "format": "uuid"
          }
        }
      }
    },
    "image-create-params": {
      "type": "object",
      "properties": {
        "ssh_public_key": {
          "description": "SSH public key for debugging the installation.",
          "type": "string"
        }
      }
    },
    "image_info": {
      "type": "object",
      "properties": {
        "created_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "download_url": {
          "type": "string"
        },
        "expires_at": {
          "type": "string",
          "format": "date-time",
          "x-go-custom-tag": "gorm:\"type:timestamp with time zone\""
        },
        "generator_version": {
          "description": "Image generator version",
          "type": "string"
        },
        "size_bytes": {
          "type": "integer",
          "minimum": 0
        },
        "ssh_public_key": {
          "description": "SSH public key for debugging the installation",
          "type": "string",
          "x-go-custom-tag": "gorm:\"type:varchar(1024)\""
        }
      }
    },
    "infra_error": {
      "type": "object",
      "required": [
        "code",
        "message"
      ],
      "properties": {
        "code": {
          "description": "Numeric identifier of the error.",
          "type": "integer",
          "format": "int32",
          "maximum": 403,
          "minimum": 401
        },
        "message": {
          "description": "Human readable description of the error.",
          "type": "string"
        }
      }
    },
    "ingress-cert-params": {
      "type": "string"
    },
    "interface": {
      "type": "object",
      "properties": {
        "biosdevname": {
          "type": "string"
        },
        "client_id": {
          "type": "string"
        },
        "flags": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "has_carrier": {
          "type": "boolean"
        },
        "ipv4_addresses": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "ipv6_addresses": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "mac_address": {
          "type": "string"
        },
        "mtu": {
          "type": "integer"
        },
        "name": {
          "type": "string"
        },
        "product": {
          "type": "string"
        },
        "speed_mbps": {
          "type": "integer"
        },
        "vendor": {
          "type": "string"
        }
      }
    },
    "inventory": {
      "type": "object",
      "properties": {
        "bmc_address": {
          "type": "string"
        },
        "bmc_v6address": {
          "type": "string"
        },
        "boot": {
          "$ref": "#/definitions/boot"
        },
        "cpu": {
          "$ref": "#/definitions/cpu"
        },
        "disks": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/disk"
          }
        },
        "hostname": {
          "type": "string"
        },
        "interfaces": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/interface"
          }
        },
        "memory": {
          "$ref": "#/definitions/memory"
        },
        "system_vendor": {
          "$ref": "#/definitions/system_vendor"
        }
      }
    },
    "l2-connectivity": {
      "type": "object",
      "properties": {
        "outgoing_ip_address": {
          "type": "string"
        },
        "outgoing_nic": {
          "type": "string"
        },
        "remote_ip_address": {
          "type": "string"
        },
        "remote_mac": {
          "type": "string"
        },
        "successful": {
          "type": "boolean"
        }
      }
    },
    "l3-connectivity": {
      "type": "object",
      "properties": {
        "outgoing_nic": {
          "type": "string"
        },
        "remote_ip_address": {
          "type": "string"
        },
        "successful": {
          "type": "boolean"
        }
      }
    },
    "list-managed-domains": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/managed-domain"
      }
    },
    "list-versions": {
      "type": "object",
      "properties": {
        "release_tag": {
          "type": "string"
        },
        "versions": {
          "$ref": "#/definitions/versions"
        }
      }
    },
    "managed-domain": {
      "type": "object",
      "properties": {
        "domain": {
          "type": "string"
        },
        "provider": {
          "type": "string",
          "enum": [
            "route53"
          ]
        }
      }
    },
    "memory": {
      "type": "object",
      "properties": {
        "physical_bytes": {
          "type": "integer"
        },
        "usable_bytes": {
          "type": "integer"
        }
      }
    },
    "presigned": {
      "type": "object",
      "required": [
        "url"
      ],
      "properties": {
        "url": {
          "type": "string"
        }
      }
    },
    "step": {
      "type": "object",
      "properties": {
        "args": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "command": {
          "type": "string"
        },
        "step_id": {
          "type": "string"
        },
        "step_type": {
          "$ref": "#/definitions/step-type"
        }
      }
    },
    "step-reply": {
      "type": "object",
      "properties": {
        "error": {
          "type": "string"
        },
        "exit_code": {
          "type": "integer"
        },
        "output": {
          "type": "string"
        },
        "step_id": {
          "type": "string"
        },
        "step_type": {
          "$ref": "#/definitions/step-type"
        }
      }
    },
    "step-type": {
      "type": "string",
      "enum": [
        "connectivity-check",
        "execute",
        "inventory",
        "install",
        "free-network-addresses",
        "reset-installation",
        "dhcp-lease-allocate"
      ]
    },
    "steps": {
      "type": "object",
      "properties": {
        "instructions": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/step"
          }
        },
        "next_instruction_seconds": {
          "type": "integer"
        }
      }
    },
    "steps-reply": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/step-reply"
      }
    },
    "system_vendor": {
      "type": "object",
      "properties": {
        "manufacturer": {
          "type": "string"
        },
        "product_name": {
          "type": "string"
        },
        "serial_number": {
          "type": "string"
        }
      }
    },
    "versions": {
      "type": "object",
      "additionalProperties": {
        "type": "string"
      }
    }
  },
  "securityDefinitions": {
    "agentAuth": {
      "type": "apiKey",
      "name": "X-Secret-Key",
      "in": "header"
    },
    "userAuth": {
      "type": "apiKey",
      "name": "Authorization",
      "in": "header"
    }
  },
  "security": [
    {
      "userAuth": []
    }
  ],
  "tags": [
    {
      "description": "Assisted bare metal installation",
      "name": "Assisted installation"
    }
  ]
}`))
}
