/// Module data provides constants which contain the JSON in `&str` format to be consumed by the #
/// `gen_corpora_switch` function. Each JSON is taken from the [Corpora Project](https://github.com/dariusk/corpora)
/// and then cleaned-up to have only one filed named `data` which contains an array of strings.




/// Contains cat breeds
pub const DATA_CATS: &str = r#"
{
  "data":[
"Abyssinian",
"Aegean",
"American Bobtail",
"American Curl",
"American Shorthair",
"American Wirehair",
"Arabian Mau",
"Asian",
"Asian Semi-longhair",
"Australian Mist",
"Balinese",
"Bambino",
"Bengal",
"Birman",
"Bombay",
"Brazilian Shorthair",
"British Longhair",
"British Semi-longhair",
"British Shorthair",
"Burmese",
"Burmilla",
"California Spangled",
"Chantilly-Tiffany",
"Chartreux",
"Chausie",
"Cheetoh",
"Colorpoint Shorthair",
"Cornish Rex",
"Cymric",
"Cyprus",
"Devon Rex",
"Donskoy",
"Dragon Li",
"Dwarf cat",
"Egyptian Mau",
"European Shorthair",
"Exotic Shorthair",
"Foldex",
"German Rex",
"Havana Brown",
"Highlander",
"Himalayan",
"Japanese Bobtail",
"Javanese",
"Khao Manee",
"Korat",
"Korean Bobtail",
"Korn Ja",
"Kurilian Bobtail",
"LaPerm",
"Lykoi",
"Maine Coon",
"Manx",
"Mekong Bobtail",
"Minskin",
"Munchkin",
"Napoleon",
"Nebelung",
"Norwegian Forest cat",
"Ocicat",
"Ojos Azules",
"Oregon Rex",
"Oriental Bicolor",
"Oriental Longhair",
"Oriental Shorthair",
"PerFold",
"Persian (Modern)",
"Persian (Traditional)",
"Peterbald",
"Pixie-bob",
"Raas",
"Ragamuffin",
"Ragdoll",
"Russian Blue",
"Russian White, Black and Tabby",
"Sam Sawet",
"Savannah",
"Scottish Fold",
"Selkirk Rex",
"Serengeti",
"Serrade Petit",
"Siamese",
"Siberian",
"Singapura",
"Snowshoe",
"Sokoke",
"Somali",
"Sphynx",
"Suphalak",
"Thai",
"Thai Lilac",
"Tonkinese",
"Toyger",
"Turkish Angora",
"Turkish Van",
"Ukrainian Levkoy"
]
}
"#;

/// Contains dog breeds
pub const DATA_DOGS: &str = r#"
{
  "data":
    [
      "Affenpinscher",
      "Afghan Hound",
      "Aidi",
      "Airedale Terrier",
      "Akbash Dog",
      "Akita",
      "Alano Español",
      "Alaskan Klee Kai",
      "Alaskan Malamute",
      "Alpine Dachsbracke",
      "Alpine Spaniel",
      "American Bulldog",
      "American Cocker Spaniel",
      "American Eskimo Dog",
      "American Foxhound",
      "American Hairless Terrier",
      "American Pit Bull Terrier",
      "American Staffordshire Terrier",
      "American Water Spaniel",
      "Anglo-Français de Petite Vénerie",
      "Appenzeller Sennenhund",
      "Ariege Pointer",
      "Ariegeois",
      "Armant",
      "Armenian Gampr dog",
      "Artois Hound",
      "Australian Cattle Dog",
      "Australian Kelpie",
      "Australian Shepherd",
      "Australian Silky Terrier",
      "Australian Stumpy Tail Cattle Dog",
      "Australian Terrier",
      "Azawakh",
      "Bakharwal Dog",
      "Barbet",
      "Basenji",
      "Basque Shepherd Dog",
      "Basset Artésien Normand",
      "Basset Bleu de Gascogne",
      "Basset Fauve de Bretagne",
      "Basset Hound",
      "Bavarian Mountain Hound",
      "Beagle",
      "Beagle-Harrier",
      "Bearded Collie",
      "Beauceron",
      "Bedlington Terrier",
      "Belgian Shepherd Dog (Groenendael)",
      "Belgian Shepherd Dog (Laekenois)",
      "Belgian Shepherd Dog (Malinois)",
      "Bergamasco Shepherd",
      "Berger Blanc Suisse",
      "Berger Picard",
      "Berner Laufhund",
      "Bernese Mountain Dog",
      "Billy",
      "Black and Tan Coonhound",
      "Black and Tan Virginia Foxhound",
      "Black Norwegian Elkhound",
      "Black Russian Terrier",
      "Bloodhound",
      "Blue Lacy",
      "Blue Paul Terrier",
      "Boerboel",
      "Bohemian Shepherd",
      "Bolognese",
      "Border Collie",
      "Border Terrier",
      "Borzoi",
      "Boston Terrier",
      "Bouvier des Ardennes",
      "Bouvier des Flandres",
      "Boxer",
      "Boykin Spaniel",
      "Bracco Italiano",
      "Braque d'Auvergne",
      "Braque du Bourbonnais",
      "Braque du Puy",
      "Braque Francais",
      "Braque Saint-Germain",
      "Brazilian Terrier",
      "Briard",
      "Briquet Griffon Vendéen",
      "Brittany",
      "Broholmer",
      "Bruno Jura Hound",
      "Bucovina Shepherd Dog",
      "Bull and Terrier",
      "Bull Terrier (Miniature)",
      "Bull Terrier",
      "Bulldog",
      "Bullenbeisser",
      "Bullmastiff",
      "Bully Kutta",
      "Burgos Pointer",
      "Cairn Terrier",
      "Canaan Dog",
      "Canadian Eskimo Dog",
      "Cane Corso",
      "Cardigan Welsh Corgi",
      "Carolina Dog",
      "Carpathian Shepherd Dog",
      "Catahoula Cur",
      "Catalan Sheepdog",
      "Caucasian Shepherd Dog",
      "Cavalier King Charles Spaniel",
      "Central Asian Shepherd Dog",
      "Cesky Fousek",
      "Cesky Terrier",
      "Chesapeake Bay Retriever",
      "Chien Français Blanc et Noir",
      "Chien Français Blanc et Orange",
      "Chien Français Tricolore",
      "Chien-gris",
      "Chihuahua",
      "Chilean Fox Terrier",
      "Chinese Chongqing Dog",
      "Chinese Crested Dog",
      "Chinese Imperial Dog",
      "Chinook",
      "Chippiparai",
      "Chow Chow",
      "Cierny Sery",
      "Cimarrón Uruguayo",
      "Cirneco dell'Etna",
      "Clumber Spaniel",
      "Combai",
      "Cordoba Fighting Dog",
      "Coton de Tulear",
      "Cretan Hound",
      "Croatian Sheepdog",
      "Cumberland Sheepdog",
      "Curly Coated Retriever",
      "Cursinu",
      "Cão da Serra de Aires",
      "Cão de Castro Laboreiro",
      "Cão Fila de São Miguel",
      "Dachshund",
      "Dalmatian",
      "Dandie Dinmont Terrier",
      "Danish Swedish Farmdog",
      "Deutsche Bracke",
      "Doberman Pinscher",
      "Dogo Argentino",
      "Dogo Cubano",
      "Dogue de Bordeaux",
      "Drentse Patrijshond",
      "Drever",
      "Dunker",
      "Dutch Shepherd Dog",
      "Dutch Smoushond",
      "East Siberian Laika",
      "East-European Shepherd",
      "Elo",
      "English Cocker Spaniel",
      "English Foxhound",
      "English Mastiff",
      "English Setter",
      "English Shepherd",
      "English Springer Spaniel",
      "English Toy Terrier (Black &amp; Tan)",
      "English Water Spaniel",
      "English White Terrier",
      "Entlebucher Mountain Dog",
      "Estonian Hound",
      "Estrela Mountain Dog",
      "Eurasier",
      "Field Spaniel",
      "Fila Brasileiro",
      "Finnish Hound",
      "Finnish Lapphund",
      "Finnish Spitz",
      "Flat-Coated Retriever",
      "Formosan Mountain Dog",
      "Fox Terrier (Smooth)",
      "French Bulldog",
      "French Spaniel",
      "Galgo Español",
      "Gascon Saintongeois",
      "German Longhaired Pointer",
      "German Pinscher",
      "German Shepherd",
      "German Shorthaired Pointer",
      "German Spaniel",
      "German Spitz",
      "German Wirehaired Pointer",
      "Giant Schnauzer",
      "Glen of Imaal Terrier",
      "Golden Retriever",
      "Gordon Setter",
      "Gran Mastín de Borínquen",
      "Grand Anglo-Français Blanc et Noir",
      "Grand Anglo-Français Blanc et Orange",
      "Grand Anglo-Français Tricolore",
      "Grand Basset Griffon Vendéen",
      "Grand Bleu de Gascogne",
      "Grand Griffon Vendéen",
      "Great Dane",
      "Great Pyrenees",
      "Greater Swiss Mountain Dog",
      "Greek Harehound",
      "Greenland Dog",
      "Greyhound",
      "Griffon Bleu de Gascogne",
      "Griffon Bruxellois",
      "Griffon Fauve de Bretagne",
      "Griffon Nivernais",
      "Hamiltonstövare",
      "Hanover Hound",
      "Hare Indian Dog",
      "Harrier",
      "Havanese",
      "Hawaiian Poi Dog",
      "Himalayan Sheepdog",
      "Hokkaido",
      "Hovawart",
      "Huntaway",
      "Hygenhund",
      "Ibizan Hound",
      "Icelandic Sheepdog",
      "Indian pariah dog",
      "Indian Spitz",
      "Irish Red and White Setter",
      "Irish Setter",
      "Irish Terrier",
      "Irish Water Spaniel",
      "Irish Wolfhound",
      "Istrian Coarse-haired Hound",
      "Istrian Shorthaired Hound",
      "Italian Greyhound",
      "Jack Russell Terrier",
      "Jagdterrier",
      "Jämthund",
      "Kai Ken",
      "Kaikadi",
      "Kanni",
      "Karelian Bear Dog",
      "Karst Shepherd",
      "Keeshond",
      "Kerry Beagle",
      "Kerry Blue Terrier",
      "King Charles Spaniel",
      "King Shepherd",
      "Kintamani",
      "Kishu",
      "Komondor",
      "Kooikerhondje",
      "Koolie",
      "Korean Jindo Dog",
      "Kromfohrländer",
      "Kumaon Mastiff",
      "Kurī",
      "Kuvasz",
      "Kyi-Leo",
      "Labrador Husky",
      "Labrador Retriever",
      "Lagotto Romagnolo",
      "Lakeland Terrier",
      "Lancashire Heeler",
      "Landseer",
      "Lapponian Herder",
      "Large Münsterländer",
      "Leonberger",
      "Lhasa Apso",
      "Lithuanian Hound",
      "Longhaired Whippet",
      "Löwchen",
      "Mahratta Greyhound",
      "Maltese",
      "Manchester Terrier",
      "Maremma Sheepdog",
      "McNab",
      "Mexican Hairless Dog",
      "Miniature American Shepherd",
      "Miniature Australian Shepherd",
      "Miniature Fox Terrier",
      "Miniature Pinscher",
      "Miniature Schnauzer",
      "Miniature Shar Pei",
      "Molossus",
      "Montenegrin Mountain Hound",
      "Moscow Watchdog",
      "Moscow Water Dog",
      "Mountain Cur",
      "Mucuchies",
      "Mudhol Hound",
      "Mudi",
      "Neapolitan Mastiff",
      "New Zealand Heading Dog",
      "Newfoundland",
      "Norfolk Spaniel",
      "Norfolk Terrier",
      "Norrbottenspets",
      "North Country Beagle",
      "Northern Inuit Dog",
      "Norwegian Buhund",
      "Norwegian Elkhound",
      "Norwegian Lundehund",
      "Norwich Terrier",
      "Old Croatian Sighthound",
      "Old Danish Pointer",
      "Old English Sheepdog",
      "Old English Terrier",
      "Old German Shepherd Dog",
      "Olde English Bulldogge",
      "Otterhound",
      "Pachon Navarro",
      "Paisley Terrier",
      "Pandikona",
      "Papillon",
      "Parson Russell Terrier",
      "Patterdale Terrier",
      "Pekingese",
      "Pembroke Welsh Corgi",
      "Perro de Presa Canario",
      "Perro de Presa Mallorquin",
      "Peruvian Hairless Dog",
      "Petit Basset Griffon Vendéen",
      "Petit Bleu de Gascogne",
      "Phalène",
      "Pharaoh Hound",
      "Phu Quoc ridgeback dog",
      "Picardy Spaniel",
      "Plott Hound",
      "Podenco Canario",
      "Pointer (dog breed)",
      "Polish Greyhound",
      "Polish Hound",
      "Polish Hunting Dog",
      "Polish Lowland Sheepdog",
      "Polish Tatra Sheepdog",
      "Pomeranian",
      "Pont-Audemer Spaniel",
      "Poodle",
      "Porcelaine",
      "Portuguese Podengo",
      "Portuguese Pointer",
      "Portuguese Water Dog",
      "Posavac Hound",
      "Pražský Krysařík",
      "Pudelpointer",
      "Pug",
      "Puli",
      "Pumi",
      "Pungsan Dog",
      "Pyrenean Mastiff",
      "Pyrenean Shepherd",
      "Rafeiro do Alentejo",
      "Rajapalayam",
      "Rampur Greyhound",
      "Rastreador Brasileiro",
      "Rat Terrier",
      "Ratonero Bodeguero Andaluz",
      "Redbone Coonhound",
      "Rhodesian Ridgeback",
      "Rottweiler",
      "Rough Collie",
      "Russell Terrier",
      "Russian Spaniel",
      "Russian tracker",
      "Russo-European Laika",
      "Sabueso Español",
      "Saint-Usuge Spaniel",
      "Sakhalin Husky",
      "Saluki",
      "Samoyed",
      "Sapsali",
      "Schapendoes",
      "Schillerstövare",
      "Schipperke",
      "Schweizer Laufhund",
      "Schweizerischer Niederlaufhund",
      "Scotch Collie",
      "Scottish Deerhound",
      "Scottish Terrier",
      "Sealyham Terrier",
      "Segugio Italiano",
      "Seppala Siberian Sleddog",
      "Serbian Hound",
      "Serbian Tricolour Hound",
      "Shar Pei",
      "Shetland Sheepdog",
      "Shiba Inu",
      "Shih Tzu",
      "Shikoku",
      "Shiloh Shepherd Dog",
      "Siberian Husky",
      "Silken Windhound",
      "Sinhala Hound",
      "Skye Terrier",
      "Sloughi",
      "Slovak Cuvac",
      "Slovakian Rough-haired Pointer",
      "Small Greek Domestic Dog",
      "Small Münsterländer",
      "Smooth Collie",
      "South Russian Ovcharka",
      "Southern Hound",
      "Spanish Mastiff",
      "Spanish Water Dog",
      "Spinone Italiano",
      "Sporting Lucas Terrier",
      "St. Bernard",
      "St. John's water dog",
      "Stabyhoun",
      "Staffordshire Bull Terrier",
      "Standard Schnauzer",
      "Stephens Cur",
      "Styrian Coarse-haired Hound",
      "Sussex Spaniel",
      "Swedish Lapphund",
      "Swedish Vallhund",
      "Tahltan Bear Dog",
      "Taigan",
      "Talbot",
      "Tamaskan Dog",
      "Teddy Roosevelt Terrier",
      "Telomian",
      "Tenterfield Terrier",
      "Thai Bangkaew Dog",
      "Thai Ridgeback",
      "Tibetan Mastiff",
      "Tibetan Spaniel",
      "Tibetan Terrier",
      "Tornjak",
      "Tosa",
      "Toy Bulldog",
      "Toy Fox Terrier",
      "Toy Manchester Terrier",
      "Toy Trawler Spaniel",
      "Transylvanian Hound",
      "Treeing Cur",
      "Treeing Walker Coonhound",
      "Trigg Hound",
      "Tweed Water Spaniel",
      "Tyrolean Hound",
      "Vizsla",
      "Volpino Italiano",
      "Weimaraner",
      "Welsh Sheepdog",
      "Welsh Springer Spaniel",
      "Welsh Terrier",
      "West Highland White Terrier",
      "West Siberian Laika",
      "Westphalian Dachsbracke",
      "Wetterhoun",
      "Whippet",
      "White Shepherd",
      "Wire Fox Terrier",
      "Wirehaired Pointing Griffon",
      "Wirehaired Vizsla",
      "Yorkshire Terrier",
      "Šarplaninac"
    ]
}
"#;

/// Contains donkey breeds
pub const DATA_DONKEY: &str = r#"
{
   "data":[
      "Abkhazskaya",
      "Abyssinian Donkey",
      "Algerian",
      "American Mammoth Jack",
      "Amiatina",
      "Anatolian",
      "Andalusian Donkey",
      "Âne Africain",
      "Âne du Gourma",
      "Âne du Miankala",
      "Âne du plateau Dogon",
      "Âne du Sahel",
      "Âne du Yatenga",
      "Âne locale",
      "Âne wallon",
      "Ânes",
      "Anger",
      "Armyanskaya",
      "Asin",
      "Asinara Donkey",
      "Asino Argentato di Sologno",
      "Asino Baio Lucano",
      "Asino dell'Irpinia",
      "Asino di Sant'Alberto",
      "Asino Emiliano",
      "Asino Pugliese",
      "Asino Sardo Grigio Crociato",
      "Asnal Criolin'",
      "Asno",
      "Asno Americana",
      "Asno Balear",
      "Asno Criollo",
      "Asno de las Encartaciones",
      "Australian Donkey",
      "Austrian-Hungarian white Donkey",
      "Azerbaidzhanskaya",
      "Balkan Donkey",
      "Benderi",
      "Berry Black",
      "Berry Grey",
      "Biyang",
      "Black",
      "Bourbonnais Donkey",
      "Bourik",
      "Brasil",
      "Bulgarian Donkey",
      "Bulgaro",
      "Burro",
      "Burro Criollo",
      "Burro Kentucky",
      "Caninde",
      "Cardao",
      "Cariovilli",
      "Castel Morrone Donkey",
      "Catalan Donkey",
      "Chigetai",
      "China North",
      "Comune",
      "Corsican Donkey",
      "Cotentin Donkey",
      "Creole",
      "Criollo",
      "Cyprus Donkey",
      "Dagestanskaya",
      "Damascus",
      "Dezhou",
      "Dongolawl",
      "Dwarf Donkey of Graciosa",
      "Egypt Baladi",
      "Egyptian",
      "English Donkey",
      "Etbai",
      "Ezel",
      "Georgian Ass",
      "Green",
      "Grey",
      "Grigio Siciliano",
      "Guangling",
      "Guanzhong",
      "Hamadan",
      "Hassawi",
      "Huaibei",
      "Indian",
      "Iranian",
      "Irish Donkey",
      "Istarski Magarac",
      "Italian",
      "Jack Norteamericano",
      "Jiami",
      "Jinnan",
      "Jirnrna",
      "Kakhetinskaya",
      "Kara-Kalpakskaya",
      "Karakaçan",
      "Kashan",
      "Kassala",
      "Kazakhskaya",
      "Kirgizskaya",
      "Kulun",
      "Liangzhou",
      "Libyan",
      "Linxian",
      "Magyar Parlagi Szamár",
      "Majorera Donkey",
      "Maltese Donkey",
      "Mannar",
      "Martina Franca Donkey",
      "Maryisltaya",
      "Masai",
      "Masri",
      "Merzifon",
      "Meskhet-Dzhavakhetskaya",
      "Miniature Donkey",
      "Miranda Donkey",
      "Moldavian Local",
      "Moroccan",
      "Mula",
      "Muscat",
      "National Genatic",
      "Native of North Africa",
      "Nordestina",
      "Norman Donkey",
      "Ogaden",
      "Pantesco",
      "Paulista",
      "Pega",
      "Peruano",
      "Poitevin",
      "Poitou Donkey",
      "Ponui Donkey",
      "Primorsko Dinarski Magarac",
      "Provence Donkey",
      "Puttalam Buruwa",
      "Pyrenean Donkey",
      "Qinghai",
      "Qinqyang",
      "Qirmani",
      "Qubressy",
      "Ragusano Donkey",
      "Riffawi",
      "Romagnolo Donkey",
      "Romanian Donkey",
      "Saidi",
      "Sardinian Donkey",
      "Sennar",
      "Shanbei",
      "Sibbianl",
      "Sjeverno Jadranski Magarac",
      "Somali",
      "South-West",
      "Sperki",
      "Spotted",
      "Standard",
      "Subei",
      "Sudanese Pack",
      "Syrian",
      "Tadzhikskaya",
      "Taihang",
      "Thuringian Forest Donkey",
      "Tibetan",
      "Toposa",
      "Tswana",
      "Tunisian",
      "Turkmenskaya",
      "Uzbekskaya",
      "Viterbese",
      "Xinjiang",
      "Yangyuan",
      "Yunnan",
      "Zamorano-Leonés"
   ]
}
"#;

/// Contains horse breeds
pub const DATA_HORSES: &str = r#"
{
   "data":[
      "American Albino",
      "Abaco Barb",
      "Abtenauer",
      "Abyssinian",
      "Aegidienberger",
      "Akhal-Teke",
      "Albanian Horse",
      "Altai Horse",
      "Altèr Real",
      "American Cream Draft",
      "American Indian Horse",
      "American Paint Horse",
      "American Quarter Horse",
      "American Saddlebred",
      "American Warmblood",
      "Andalusian Horse",
      "Andravida Horse",
      "Anglo-Arabian",
      "Anglo-Arabo-Sardo",
      "Anglo-Kabarda",
      "Appaloosa",
      "AraAppaloosa",
      "Arabian Horse",
      "Ardennes Horse",
      "Arenberg-Nordkirchen",
      "Argentine Criollo",
      "Asian wild Horse",
      "Assateague Horse",
      "Asturcón",
      "Augeron",
      "Australian Brumby",
      "Australian Draught Horse",
      "Australian Stock Horse",
      "Austrian Warmblood",
      "Auvergne Horse",
      "Auxois",
      "Azerbaijan Horse",
      "Azteca Horse",
      "Baise Horse",
      "Bale",
      "Balearic Horse",
      "Balikun Horse",
      "Baluchi Horse",
      "Banker Horse",
      "Barb Horse",
      "Bardigiano",
      "Bashkir Curly",
      "Basque Mountain Horse",
      "Bavarian Warmblood",
      "Belgian Half-blood",
      "Belgian Horse",
      "Belgian Warmblood ",
      "Bhutia Horse",
      "Black Forest Horse",
      "Blazer Horse",
      "Boerperd",
      "Borana",
      "Boulonnais Horse",
      "Brabant",
      "Brandenburger",
      "Brazilian Sport Horse",
      "Breton Horse",
      "Brumby",
      "Budyonny Horse",
      "Burguete Horse",
      "Burmese Horse",
      "Byelorussian Harness Horse",
      "Calabrese Horse",
      "Camargue Horse",
      "Camarillo White Horse",
      "Campeiro",
      "Campolina",
      "Canadian Horse",
      "Canadian Pacer",
      "Carolina Marsh Tacky",
      "Carthusian Horse",
      "Caspian Horse",
      "Castilian Horse",
      "Castillonnais",
      "Catria Horse",
      "Cavallo Romano della Maremma Laziale",
      "Cerbat Mustang",
      "Chickasaw Horse",
      "Chilean Corralero",
      "Choctaw Horse",
      "Cleveland Bay",
      "Clydesdale Horse",
      "Cob",
      "Coldblood Trotter",
      "Colonial Spanish Horse",
      "Colorado Ranger",
      "Comtois Horse",
      "Corsican Horse",
      "Costa Rican Saddle Horse",
      "Cretan Horse",
      "Criollo Horse",
      "Croatian Coldblood",
      "Cuban Criollo",
      "Cumberland Island Horse",
      "Curly Horse",
      "Czech Warmblood",
      "Daliboz",
      "Danish Warmblood",
      "Danube Delta Horse",
      "Dole Gudbrandsdal",
      "Don",
      "Dongola Horse",
      "Draft Trotter",
      "Dutch Harness Horse",
      "Dutch Heavy Draft",
      "Dutch Warmblood",
      "Dzungarian Horse",
      "East Bulgarian",
      "East Friesian Horse",
      "Estonian Draft",
      "Estonian Horse",
      "Falabella",
      "Faroese",
      "Finnhorse",
      "Fjord Horse",
      "Fleuve",
      "Florida Cracker Horse",
      "Foutanké",
      "Frederiksborg Horse",
      "Freiberger",
      "French Trotter",
      "Friesian Cross",
      "Friesian Horse",
      "Friesian Sporthorse",
      "Furioso-North Star",
      "Galiceño",
      "Galician Pony",
      "Gelderland Horse",
      "Georgian Grande Horse",
      "German Warmblood",
      "Giara Horse",
      "Gidran",
      "Groningen Horse",
      "Gypsy Horse",
      "Hackney Horse",
      "Haflinger",
      "Hanoverian Horse",
      "Heck Horse",
      "Heihe Horse",
      "Henson Horse",
      "Hequ Horse",
      "Hirzai",
      "Hispano-Bretón",
      "Holsteiner Horse",
      "Horro",
      "Hungarian Warmblood",
      "Icelandic Horse",
      "Iomud",
      "Irish Draught",
      "Irish Sport Horse sometimes called Irish Hunter",
      "Italian Heavy Draft",
      "Italian Trotter",
      "Jaca Navarra",
      "Jeju Horse",
      "Jutland Horse",
      "Kabarda Horse",
      "Kafa",
      "Kaimanawa Horses",
      "Kalmyk Horse",
      "Karabair",
      "Karabakh Horse",
      "Karachai Horse",
      "Karossier",
      "Kathiawari",
      "Kazakh Horse",
      "Kentucky Mountain Saddle Horse",
      "Kiger Mustang",
      "Kinsky Horse",
      "Kisber Felver",
      "Kiso Horse",
      "Kladruber",
      "Knabstrupper",
      "Konik",
      "Kundudo",
      "Kustanair",
      "Kyrgyz Horse",
      "Latvian Horse",
      "Lipizzan",
      "Lithuanian Heavy Draught",
      "Lokai",
      "Losino Horse",
      "Lusitano",
      "Lyngshest",
      "M'Bayar",
      "M'Par",
      "Mallorquín",
      "Malopolski",
      "Mangalarga",
      "Mangalarga Marchador",
      "Maremmano",
      "Marismeño Horse",
      "Marsh Tacky",
      "Marwari Horse",
      "Mecklenburger",
      "Međimurje Horse",
      "Menorquín",
      "Mérens Horse",
      "Messara Horse",
      "Metis Trotter",
      "Mezőhegyesi Sport Horse",
      "Miniature Horse",
      "Misaki Horse",
      "Missouri Fox Trotter",
      "Monchina",
      "Mongolian Horse",
      "Mongolian Wild Horse",
      "Monterufolino",
      "Morab",
      "Morgan Horse",
      "Mountain Pleasure Horse",
      "Moyle Horse",
      "Murakoz Horse",
      "Murgese",
      "Mustang Horse",
      "Namib Desert Horse",
      "Nangchen Horse",
      "National Show Horse",
      "Nez Perce Horse",
      "Nivernais Horse",
      "Nokota Horse",
      "Noma",
      "Nonius Horse",
      "Nooitgedachter",
      "Nordlandshest",
      "Noriker Horse",
      "Norman Cob",
      "North American Single-Footer Horse",
      "North Swedish Horse",
      "Norwegian Coldblood Trotter",
      "Norwegian Fjord",
      "Novokirghiz",
      "Oberlander Horse",
      "Ogaden",
      "Oldenburg Horse",
      "Orlov trotter",
      "Ostfriesen",
      "Paint",
      "Pampa Horse",
      "Paso Fino",
      "Pentro Horse",
      "Percheron",
      "Persano Horse",
      "Peruvian Paso",
      "Pintabian",
      "Pleven Horse",
      "Poitevin Horse",
      "Posavac Horse",
      "Pottok",
      "Pryor Mountain Mustang",
      "Przewalski's Horse",
      "Pura Raza Española",
      "Purosangue Orientale",
      "Qatgani",
      "Quarab",
      "Quarter Horse",
      "Racking Horse",
      "Retuerta Horse",
      "Rhenish German Coldblood",
      "Rhinelander Horse",
      "Riwoche Horse",
      "Rocky Mountain Horse",
      "Romanian Sporthorse",
      "Rottaler",
      "Russian Don",
      "Russian Heavy Draft",
      "Russian Trotter",
      "Saddlebred",
      "Salerno Horse",
      "Samolaco Horse",
      "San Fratello Horse",
      "Sarcidano Horse",
      "Sardinian Anglo-Arab",
      "Schleswig Coldblood",
      "Schwarzwälder Kaltblut",
      "Selale",
      "Sella Italiano",
      "Selle Français",
      "Shagya Arabian",
      "Shan Horse",
      "Shire Horse",
      "Siciliano Indigeno",
      "Silesian Horse",
      "Sokolsky Horse",
      "Sorraia",
      "South German Coldblood",
      "Soviet Heavy Draft",
      "Spanish Anglo-Arab",
      "Spanish Barb",
      "Spanish Jennet Horse",
      "Spanish Mustang",
      "Spanish Tarpan",
      "Spanish-Norman Horse",
      "Spiti Horse",
      "Spotted Saddle Horse",
      "Standardbred Horse",
      "Suffolk Punch",
      "Swedish Ardennes",
      "Swedish coldblood trotter",
      "Swedish Warmblood",
      "Swiss Warmblood",
      "Taishū Horse",
      "Takhi",
      "Tawleed",
      "Tchernomor",
      "Tennessee Walking Horse",
      "Tersk Horse",
      "Thoroughbred",
      "Tiger Horse",
      "Tinker Horse",
      "Tolfetano",
      "Tori Horse",
      "Trait Du Nord",
      "Trakehner",
      "Tsushima",
      "Tuigpaard",
      "Ukrainian Riding Horse",
      "Unmol Horse",
      "Uzunyayla",
      "Ventasso Horse",
      "Virginia Highlander",
      "Vlaamperd",
      "Vladimir Heavy Draft",
      "Vyatka",
      "Waler",
      "Waler Horse",
      "Walkaloosa",
      "Warlander",
      "Warmblood",
      "Welsh Cob",
      "Westphalian Horse",
      "Wielkopolski",
      "Württemberger",
      "Xilingol Horse",
      "Yakutian Horse",
      "Yili Horse",
      "Yonaguni Horse",
      "Zaniskari",
      "Žemaitukas",
      "Zhemaichu",
      "Zweibrücker"
   ]
}
"#;

/// Contains dinosaur breeds
pub const DATA_DINOSAURS: &str = r#"
{
  "data":
    [
      "Kangnasaurus",
      "Lophostropheus",
      "Spinophorosaurus",
      "Epachthosaurus",
      "Coelurosauria",
      "Lycorhinus",
      "Adasaurus",
      "Draconyx",
      "Ceratops",
      "Lagerpeton",
      "Qiaowanlong",
      "Rhynchosaur",
      "Ningyuansaurus",
      "Palaeolimnornis",
      "Anabisetia",
      "Talarurus",
      "Sphenodontia",
      "Tianyulong",
      "Aepisaurus",
      "Neuquenraptor",
      "Galesaurus",
      "Pachysuchus",
      "Auroraceratops",
      "Hecatasaurus",
      "Barapasaurus",
      "Asiatosaurus",
      "Daanosaurus",
      "Luoyanggia",
      "Eobrontosaurus",
      "Wellnhoferia",
      "Zuolong",
      "Tenchisaurus",
      "Centrosaurus",
      "Falcarius",
      "Ojoraptorsaurus",
      "Lufengocephalus",
      "Vulcanodon",
      "Mollusc",
      "Shunosaurus",
      "Empaterias",
      "Issasaurus",
      "Jiangxisaurus",
      "Laplatasaurus",
      "Aublysodon",
      "Embasaurus",
      "Blikanasaurus",
      "Bonapartenykus",
      "Asiamericana",
      "Arizonasaurus",
      "Cryptoraptor",
      "Morosaurus",
      "Mapusaurus",
      "Buitreraptor",
      "Gravitholus",
      "Vitakrisaurus",
      "Nurosaurus",
      "Cetiosauriscus",
      "Kukufeldia",
      "Propanoplosaurus",
      "Suchoprion",
      "Umarsaurus",
      "Likhoelesaurus",
      "Dasygnathoides",
      "Dubreuillosaurus",
      "Shenzhouraptor",
      "Atrociraptor",
      "Amurosaurus",
      "Latirhinus",
      "Albisaurus",
      "Zupaysaurus",
      "Venenosaurus",
      "Syrmosaurus",
      "Arkharavia",
      "Yueosaurus",
      "Tianchungosaurus",
      "Dyslocosaurus",
      "Sinraptor",
      "Owenodon",
      "Pelycosaur",
      "Duriavenator",
      "Haplocheirus",
      "Epidendrosaurus",
      "Nyasasaurus",
      "Tawasaurus",
      "Lisboasaurus",
      "Ahshislepelta",
      "Magnirostris",
      "Psittacosaurus",
      "Orodromeus",
      "Ostafrikasaurus",
      "Nemegtomaia",
      "Dracorex",
      "Ovoraptor",
      "Amazonsaurus",
      "Leyesaurus",
      "Dollodon",
      "Cryptosaurus",
      "Coahuilaceratops",
      "Variraptor",
      "Panamericansaurus",
      "Nodocephalosaurus",
      "Nasutoceratops",
      "Prosaurolophus",
      "Jingshanosaurus",
      "Teleocrater",
      "Tribelesodon",
      "Mochlodon",
      "Eohadrosaurus",
      "Comanchesaurus",
      "Limnornis",
      "Gigantspinosaurus",
      "Oxalaia",
      "Wuerhosaurus",
      "Mtapaiasaurus",
      "Longisquama",
      "Velocisaurus",
      "Aorun",
      "Sinopliosaurus",
      "Gigantosaurus",
      "Sphenospondylus",
      "Dinotyrannus",
      "Rhabdodon",
      "Kritosaurus",
      "Lamplughsaura",
      "Notohypsilophodon",
      "Tsagantegia",
      "Brontoraptor",
      "Argyrosaurus",
      "Lambeosaurus",
      "Heterosaurus",
      "Tazoudasaurus",
      "Valdoraptor",
      "Microhadrosaurus",
      "Pycnonemosaurus",
      "Manidens",
      "Coelophysis",
      "Hulsanpes",
      "Losillasaurus",
      "Polacanthoides",
      "Lanzhousaurus",
      "Walgettosuchus",
      "Sauroniops",
      "Magulodon",
      "Pneumatoraptor",
      "Altispinax",
      "Alnashetri",
      "Hoplitosaurus",
      "Rahiolisaurus",
      "Luanpingosaurus",
      "Abrosaurus",
      "Palaeosaurus",
      "Iguanoides",
      "Abydosaurus",
      "Riodevasaurus",
      "Stormbergia",
      "Bihariosaurus",
      "Yuanmousaurus",
      "Sphenosuchus",
      "Dashanpusaurus",
      "Crocodilia",
      "Enigmosaurus",
      "Montanoceratops",
      "Frenguellisaurus",
      "Segnosaurus",
      "Kryptops",
      "Labocania",
      "Sinocalliopteryx",
      "Dromiceiomimus",
      "Isisaurus",
      "Archaeornithoides",
      "Deinonychus",
      "Allosaurus",
      "Stephanosaurus",
      "Sinornithoides",
      "Incisivosaurus",
      "Ornitholestes",
      "Ankylosaurus",
      "Plateosaurus",
      "Shidaisaurus",
      "Platyceratops",
      "Agnosphitys",
      "Changdusaurus",
      "Nothosaur",
      "Orthogoniosaurus",
      "Titanoceratops",
      "Dysganus",
      "Lamaceratops",
      "Helioceratops",
      "Nanyangosaurus",
      "Khaan",
      "Cryptodraco",
      "Chasmosaurus",
      "Rileyasuchus",
      "Aeolosaurus",
      "Yizhousaurus",
      "Echinodon",
      "Omnivoropteryx",
      "Lengosaurus",
      "Megadactylus",
      "Mamenchisaurus",
      "Notoceratops",
      "Pachysaurus",
      "Tianzhenosaurus",
      "Zhuchengceratops",
      "Tyreophorus",
      "Nedcolbertia",
      "Shixinggia",
      "Jeholosaurus",
      "Ornithosuchus",
      "Veterupristisaurus",
      "Rayososaurus",
      "Velafrons",
      "Lapparentosaurus",
      "Seismosaurus",
      "Tsuchikurasaurus",
      "Styracosaurus",
      "Dilophosaurus",
      "Gasparinisaura",
      "Xiaotingia",
      "Dromaeosaurus",
      "Scansoriopteryx",
      "Eurolimnornis",
      "Proterosuchid",
      "Nipponosaurus",
      "Brachiosaurus",
      "Vitaridrinda",
      "Mantellodon",
      "Sphaerotholus",
      "Shuosaurus",
      "Koutalisaurus",
      "Cardiodon",
      "Yixianosaurus",
      "Jurassosaurus",
      "Jiutaisaurus",
      "Gryphognathus",
      "Archaeornithomimus",
      "Griphornis",
      "Szechuanosaurus",
      "Pneumatoarthrus",
      "Basutodon",
      "Aletopelta",
      "Tendaguria",
      "Riojasaurus",
      "Creosaurus",
      "Harpymimus",
      "Huaxiagnathus",
      "Carnotaurus",
      "Beipiaosaurus",
      "Teratophoneus",
      "Cedarosaurus",
      "Omosaurus",
      "Wyleyia",
      "Aachenosaurus",
      "Atlantosaurus",
      "Bilbeyhallorum",
      "Balochisaurus",
      "Ouranosaurus",
      "Fukuititan",
      "Sarcolestes",
      "Alocodon",
      "Amphisaurus",
      "Lametasaurus",
      "Raptorex",
      "Sinosaurus",
      "Doratodon",
      "Ankistrodon",
      "Chuanjiesaurus",
      "Parasaurolophus",
      "Albertonykus",
      "Efraasia",
      "Alaskacephale",
      "Torilion",
      "Rapator",
      "Sauroplites",
      "Thecocoelurus",
      "Lirainosaurus",
      "Xixiasaurus",
      "Conchoraptor",
      "Paralititan",
      "Arcusaurus",
      "Becklespinax",
      "Thecodontosaurus",
      "Taveirosaurus",
      "Daemonosaurus",
      "Suuwassea",
      "Albertosaurus",
      "Nouerosaurus",
      "Marshosaurus",
      "Xuanhuasaurus",
      "Algoasaurus",
      "Capitalsaurus",
      "Xenoposeidon",
      "Cryolophosaurus",
      "Gobipteryx",
      "Stereosaurus",
      "Nemegtia",
      "Proyandusaurus",
      "Thyreophora",
      "Xiaosaurus",
      "Tatankaceratops",
      "Hanwulosaurus",
      "Gryphoceratops",
      "Linheraptor",
      "Ornithomimoides",
      "Edmontonia",
      "Aerosteon",
      "Ninghsiasaurus",
      "Prenoceratops",
      "Vagaceratops",
      "Sinucerasaurus",
      "Hongshanosaurus",
      "Hexinlusaurus",
      "Indosuchus",
      "Moshisaurus",
      "Alashansaurus",
      "Berberosaurus",
      "Elaltitan",
      "Marisaurus",
      "Rhoetosaurus",
      "Tatankacephalus",
      "Bienosaurus",
      "Dracopelta",
      "Chiayusaurus",
      "Pseudosuchia",
      "Sarcosaurus",
      "Shuvuuia",
      "Unaysaurus",
      "Amtosaurus",
      "Nqwebasaurus",
      "Claorhynchus",
      "Prolacertiform",
      "Honghesaurus",
      "Ugrosaurus",
      "Aegyptosaurus",
      "Gallimimus",
      "Clasmodosaurus",
      "Hypacrosaurus",
      "Caenagnathus",
      "Velocipes",
      "Lessemsaurus",
      "Agrosaurus",
      "Paronychodon",
      "Maleevosaurus",
      "Leipsanosaurus",
      "Clevelanotyrannus",
      "Dynamosaurus",
      "Megacervixosaurus",
      "Protohadros",
      "Polyonax",
      "Daxiatitan",
      "Spondylosoma",
      "Ichthyovenator",
      "Demandasaurus",
      "Dimodosaurus",
      "Torvosaurus",
      "Gwyneddosaurus",
      "Cystosaurus",
      "Irritator",
      "Zanclodon",
      "Rugops",
      "Ignavusaurus",
      "Chinshakiangosaurus",
      "Zhejiangosaurus",
      "Pachyrhinosaurus",
      "Stenotholus",
      "Iuticosaurus",
      "Tyrannotitan",
      "Xixianykus",
      "Palaeopteryx",
      "Vitakridrinda",
      "Planicoxa",
      "Jianchangosaurus",
      "Sinovenator",
      "Ohmdenosaurus",
      "Protecovasaurus",
      "Eoceratops",
      "Laevisuchus",
      "Cumnoria",
      "Ratchasimasaurus",
      "Elaphrosaurus",
      "Dracovenator",
      "Abelisaurus",
      "Sangonghesaurus",
      "Austrocheirus",
      "Calamosaurus",
      "Vectensia",
      "Elosaurus",
      "Termatosaurus",
      "Pleuropeltus",
      "Chubutisaurus",
      "Macrophalangia",
      "Futalongkosaurus",
      "Acristavus",
      "Wintonotitan",
      "Diclonius",
      "Nanosaurus",
      "Tonganosaurus",
      "Tarascosaurus",
      "Amphicoelicaudia",
      "Achillesaurus",
      "Delapparentia",
      "Argentinosaurus",
      "Sulaimansaurus",
      "Koparion",
      "Brachytrachelopan",
      "Bakesaurus",
      "Rahona",
      "Oryctodromeus",
      "Campylodon",
      "Stygivenator",
      "Wangonisaurus",
      "Genyodectes",
      "Acrocanthosaurus",
      "Danubiosaurus",
      "Deltadromeus",
      "Rileya",
      "Borealosaurus",
      "Rioarribasaurus",
      "Gondwanatitan",
      "Lophorhothon",
      "Talenkauen",
      "Diracodon",
      "Nanshiungosaurus",
      "Bradycneme",
      "Ferganocephale",
      "Cheneosaurus",
      "Wulagasaurus",
      "Tanystrosuchus",
      "Comahuesaurus",
      "Actiosaurus",
      "Jiangjunmiaosaurus",
      "Xinjiangovenator",
      "Gadolosaurus",
      "Clarencea",
      "Avemetatarsalia",
      "Dakotadon",
      "Diapsid",
      "Albinykus",
      "Pectinodon",
      "Protorosaurus",
      "Ginnareemimus",
      "Doryphorosaurus",
      "Dalianraptor",
      "Megapnosaurus",
      "Scelidosaurus",
      "Metriorhynchid",
      "Piatnitzkysaurus",
      "Haplocanthosaurus",
      "Phytosaur",
      "Manospondylus",
      "Gansutitan",
      "Neovenator",
      "Brasileosaurus",
      "Judiceratops",
      "Khetranisaurus",
      "Fish",
      "Proceratosaurus",
      "Zatomus",
      "Ceratosaurus",
      "Unescoceratops",
      "Telmatosaurus",
      "Segisaurus",
      "Pachyspondylus",
      "Caseosaurus",
      "Ultrasauros",
      "Dongbeititan",
      "Galvesaurus",
      "Crocodylomorph",
      "Ephoenosaurus",
      "Fossil",
      "Crosbysaurus",
      "Coelosaurus",
      "Unenlagia",
      "Strenusaurus",
      "Concavenator",
      "Fukuiraptor",
      "Camarasaurus",
      "Iliosuchus",
      "Huayangosaurus",
      "Kileskus",
      "Clepsysaurus",
      "Richardoestesia",
      "Sphenosaurus",
      "Scutellosaurus",
      "Garudimimus",
      "Hexing",
      "Nanningosaurus",
      "Sonorasaurus",
      "Pradhania",
      "Orosaurus",
      "Andesaurus",
      "Genusaurus",
      "Huxleysaurus",
      "Elopteryx",
      "Alectrosaurus",
      "Tecovasaurus",
      "Parksosaurus",
      "Paranthodon",
      "Airakoraptor",
      "Jobaria",
      "Ichabodcraniosaurus",
      "Muyelensaurus",
      "Sacisaurus",
      "Deinodon",
      "Patricosaurus",
      "Maleevus",
      "Tylocephale",
      "Sugiyamasaurus",
      "Nodosaurus",
      "Aliwalia",
      "Kerberosaurus",
      "Kazaklambia",
      "Eolambia",
      "Dongyangosaurus",
      "Citipati",
      "Euskelosaurus",
      "Trigonosaurus",
      "Epidexipteryx",
      "Dolichosuchus",
      "Walkeria",
      "Labrosaurus",
      "Condorraptor",
      "Tichosteus",
      "Uberabatitan",
      "Magnosaurus",
      "Janenschia",
      "Anasazisaurus",
      "Macrogryphosaurus",
      "Erliansaurus",
      "Ornithotarsus",
      "Bayosaurus",
      "Santanaraptor",
      "Zhuchengtyrannus",
      "Lukousaurus",
      "Sauroposeidon",
      "Ampelosaurus",
      "Pampadromaeus",
      "Erectopus",
      "Glyptodontopelta",
      "Drinker",
      "Leaellynasaura",
      "Magyarosaurus",
      "Postosuchus",
      "Szechuanoraptor",
      "Yubasaurus",
      "Brachyrophus",
      "Cionodon",
      "Sellacoxa",
      "Elachistosuchus",
      "Shuvosaurus",
      "Sauraechmodon",
      "Microdontosaurus",
      "Carcharodontosaurus",
      "Brachylophosaurus",
      "Theropoda",
      "Tapinocephalus",
      "Changchunsaurus",
      "Cladeiodon",
      "Pareiasaurus",
      "Heishansaurus",
      "Aristosuchus",
      "Protiguanodon",
      "Brohisaurus",
      "Eupodosaurus",
      "Datousaurus",
      "Giraffatitan",
      "Jaklapallisaurus",
      "Tugulusaurus",
      "Compsognathus",
      "Ilokelesia",
      "Revueltoraptor",
      "Tuojiangosaurus",
      "Huaxiasaurus",
      "Palaeocursornis",
      "Onychosaurus",
      "Ceratonykus",
      "Amargatitanis",
      "Albalophosaurus",
      "Byronosaurus",
      "Cryptovolans",
      "Shenzhousaurus",
      "Rapetosaurus",
      "Altirhinus",
      "Sanjuansaurus",
      "Dysalotosaurus",
      "Archaeopteryx",
      "Liliensternus",
      "Beelemodon",
      "Xuanhuaceratops",
      "Protrachodon",
      "Caenagnathasia",
      "Willinakaqe",
      "Atacamatitan",
      "Lourinhanosaurus",
      "Yaverlandia",
      "Ligomasaurus",
      "Suchomimus",
      "Brasilotitan",
      "Jenghizkhan",
      "Aggiosaurus",
      "Elrhazosaurus",
      "Yingshanosaurus",
      "Australovenator",
      "Ichthyornis",
      "Valdosaurus",
      "Yuanmouraptor",
      "Prolacertiformes",
      "Tarchia",
      "Hesperosaurus",
      "Azendohsaurus",
      "Eucentrosaurus",
      "Scipionyx",
      "Petrobrasaurus",
      "Hudiesaurus",
      "Sinornithosaurus",
      "Shuangmiaosaurus",
      "Tianchisaurus",
      "Araucanoraptor",
      "Poposaurus",
      "Pararhabdodon",
      "Osmakasaurus",
      "Siamotyrannus",
      "Galveosaurus",
      "Yangchuanosaurus",
      "Microcephale",
      "Mirischia",
      "Probactrosaurus",
      "Yunxiansaurus",
      "Enantiornithine",
      "Cedrorestes",
      "Chaoyangsaurus",
      "Loricatosaurus",
      "Stygimoloch",
      "Venaticosuchus",
      "Gorgosaurus",
      "Anchiornis",
      "Ischisaurus",
      "Bactrosaurus",
      "Quilmesaurus",
      "Fukuisaurus",
      "Stegosaurus",
      "Griphosaurus",
      "Graciliceratops",
      "Oligosaurus",
      "Baotianmansaurus",
      "Eocursor",
      "Turtle",
      "Macelognathus",
      "Arctosaurus",
      "Streptospondylus",
      "Texasetes",
      "Dianchungosaurus",
      "Birds",
      "Nomingia",
      "Sinornithomimus",
      "Hierosaurus",
      "Abdallahsaurus",
      "Jaxartosaurus",
      "Sanchusaurus",
      "Tarbosaurus",
      "Sinocoelurus",
      "Timimus",
      "Herrerasaurus",
      "Giganotosaurus",
      "Tsaagan",
      "Anthracothere",
      "Yezosaurus",
      "Chihuahuasaurus",
      "Cathartesaura",
      "Domeykosaurus",
      "Loncosaurus",
      "Archaeoceratops",
      "Udanoceratops",
      "Gojirasaurus",
      "Dongyangopelta",
      "Duriatitan",
      "Chondrosteus",
      "Arkanosaurus",
      "Lusotitan",
      "Diceratus",
      "Nuoersaurus",
      "Wadhurstia",
      "Sauropelta",
      "Ultrasaurus",
      "Indosaurus",
      "Kotasaurus",
      "Urbacodon",
      "Zhongyuansaurus",
      "Tanystropheus",
      "Mifunesaurus",
      "Pegomastax",
      "Gobititan",
      "Lusitanosaurus",
      "Caulodon",
      "Baryonyx",
      "Tataouinea",
      "Longosaurus",
      "Pareiasaur",
      "Leshansaurus",
      "Machairasaurus",
      "Colossosaurus",
      "Arstanosaurus",
      "Wakinosaurus",
      "Lanasaurus",
      "Dryosaurus",
      "Sterrholophus",
      "Dachungosaurus",
      "Chialingosaurus",
      "Jiangjunosaurus",
      "Klamelisaurus",
      "Rauisuchia",
      "Caudipteryx",
      "Jinfengopteryx",
      "Leptoceratops",
      "Sinotyrannus",
      "Poekilopleuron",
      "Gobisaurus",
      "Angaturama",
      "Pterosaur",
      "Aetonyx",
      "Angolatitan",
      "Tanius",
      "Therizinosaurus",
      "Tastavinsaurus",
      "Lancangosaurus",
      "Dinheirosaurus",
      "Brachypodosaurus",
      "Gobiceratops",
      "Fruitadens",
      "Monkonosaurus",
      "Spinostropheus",
      "Cristatusaurus",
      "Bolong",
      "Rebbachisaurus",
      "Monolophosaurus",
      "Alioramus",
      "Hypsirophus",
      "Olorotitan",
      "Euoplocephalus",
      "Juravenator",
      "Euhelopus",
      "Epanterias",
      "Lancanjiangosaurus",
      "Xianshanosaurus",
      "Ekrixinatosaurus",
      "Achillobator",
      "Hesperonychus",
      "Pachysauriscus",
      "Ruyangosaurus",
      "Gongbusaurus",
      "Teratosaurus",
      "Ruehleia",
      "Yaleosaurus",
      "Canardia",
      "Brachyceratops",
      "Pantydraco",
      "Afrovenator",
      "Mendozasaurus",
      "Pedopenna",
      "Blasisaurus",
      "Astrodon",
      "Mandschurosaurus",
      "Drusilasaura",
      "Libycosaurus",
      "Eucamerotus",
      "Tonouchisaurus",
      "Didanodon",
      "Proplanicoxa",
      "Kentrurosaurus",
      "Trinisaura",
      "Fusuisaurus",
      "Kentrosaurus",
      "Eocarcharia",
      "Albertaceratops",
      "Rutellum",
      "Saltasaurus",
      "Majungatholus",
      "Mussaurus",
      "Zigongosaurus",
      "Euacanthus",
      "Craspedodon",
      "Ingenia",
      "Priodontognathus",
      "Rubeosaurus",
      "Gyposaurus",
      "Utahraptor",
      "Pukyongosaurus",
      "Coelurosaur",
      "Silvisaurus",
      "Troodon",
      "Jixiangornis",
      "Pawpawsaurus",
      "Oohkotokia",
      "Hadrosauravus",
      "Shaochilong",
      "Ponerosteus",
      "Ischyrosaurus",
      "Hadrosaurus",
      "Gryposaurus",
      "Spinops",
      "Peloroplites",
      "Daspletosaurus",
      "Dravidosaurus",
      "Hagryphus",
      "Sphenosuchia",
      "Ligabueino",
      "Mymoorapelta",
      "Tatisaurus",
      "Trimucrodon",
      "Cathetosaurus",
      "Teinurosaurus",
      "Antetonitrus",
      "Rajasaurus",
      "Fabrosaurus",
      "Angloposeidon",
      "Levnesovia",
      "Mongolosaurus",
      "Asiaceratops",
      "Avipes",
      "Turiasaurus",
      "Eucnemesaurus",
      "Otogosaurus",
      "Martharaptor",
      "Tsintaosaurus",
      "Hypsilophodon",
      "Gigantoscelus",
      "Palaeosauriscus",
      "Hironosaurus",
      "Paludititan",
      "Anatosaurus",
      "Kaatedocus",
      "Linhevenator",
      "Pellegrinisaurus",
      "Sanpasaurus",
      "Lapampasaurus",
      "Inosaurus",
      "Eomamenchisaurus",
      "Liassaurus",
      "Jinzhousaurus",
      "Equijubus",
      "Dryptosaurus",
      "Nopcsaspondylus",
      "Changtusaurus",
      "Tapuiasaurus",
      "Diabloceratops",
      "Dakosaurus",
      "Chassternbergia",
      "Limaysaurus",
      "Huaxiaosaurus",
      "Minotaurasaurus",
      "Uteodon",
      "Micropachycephalosaurus",
      "Avisaurus",
      "Siamodon",
      "Ornithomerus",
      "Eodromaeus",
      "Turanoceratops",
      "Nambalia",
      "Cruxicheiros",
      "Riojasuchus",
      "Stokesosaurus",
      "Amygdalodon",
      "Linhenykus",
      "Heterodontosaurus",
      "Dromicosaurus",
      "Bahariasaurus",
      "Xiongguanlong",
      "Jeyawati",
      "Polyodontosaurus",
      "Morinosaurus",
      "Campylodoniscus",
      "Aralosaurus",
      "Pentaceratops",
      "Squalodon",
      "Saurornitholestes",
      "Yandusaurus",
      "Bruhathkayosaurus",
      "Kinnareemimus",
      "Tornieria",
      "Scaphonyx",
      "Barosaurus",
      "Titanosaurus",
      "Volkheimeria",
      "Brontomerus",
      "Megalosaurus",
      "Rhopalodon",
      "Huanghetitan",
      "Ngexisaurus",
      "Jiangshanosaurus",
      "Archosaur",
      "Sciurumimus",
      "Histriasaurus",
      "Spinosaurus",
      "Eoraptor",
      "Phaedrolosaurus",
      "Betasuchus",
      "Belodon",
      "Bagaraatan",
      "Protognathus",
      "Marmarospondylus",
      "Dinosaur",
      "Darwinsaurus",
      "Apatodon",
      "Eotyrannus",
      "Struthiomimus",
      "Pelecanimimus",
      "Gideonmantellia",
      "Appalachiosaurus",
      "Edmontosaurus",
      "Acracanthus",
      "Machimosaurus",
      "Razanandrongobe",
      "Uintasaurus",
      "Magnapaulia",
      "Moabosaurus",
      "Ojoceratops",
      "Yaxartosaurus",
      "Macroscelosaurus",
      "Aniksosaurus",
      "Guanlong",
      "Futabasaurus",
      "Proceratops",
      "Xuwulong",
      "Ricardoestesia",
      "Symphyrophus",
      "Pleurocoelus",
      "Damalasaurus",
      "Naashoibitosaurus",
      "Panphagia",
      "Graciliraptor",
      "Ornithoides",
      "Futalognkosaurus",
      "Pachycephalosaurus",
      "Plesiosaur",
      "Astrophocaudia",
      "Gilmoreosaurus",
      "Diamantinasaurus",
      "Eucercosaurus",
      "Gavinosaurus",
      "Suchosaurus",
      "Eugongbusaurus",
      "Camelotia",
      "Shanxia",
      "Antarctopelta",
      "Traukutitan",
      "Saurornithoides",
      "Hippodraco",
      "Nteregosaurus",
      "Sauropodus",
      "Coelurosauravus",
      "Stereocephalus",
      "Adeopapposaurus",
      "Ctenosauriscid",
      "Paraiguanodon",
      "Eosinopteryx",
      "Archaeornis",
      "Bambiraptor",
      "Isanosaurus",
      "Stegosaurides",
      "Avaceratops",
      "Gannansaurus",
      "Triceratops",
      "Paluxysaurus",
      "Denversaurus",
      "Bathygnathus",
      "Katsuyamasaurus",
      "Barsboldia",
      "Mojoceratops",
      "Eucoelophysis",
      "Microraptor",
      "Calamospondylus",
      "Fusinasus",
      "Agathaumas",
      "Protoceratops",
      "Eustreptospondylus",
      "Macrurosaurus",
      "Atlascopcosaurus",
      "Claosaurus",
      "Avicephala",
      "Tochisaurus",
      "Protognathosaurus",
      "Kakuru",
      "Neuquensaurus",
      "Chilantaisaurus",
      "Chindesaurus",
      "Parvicursor",
      "Phuwiangosaurus",
      "Saltriosaurus",
      "Edmarka",
      "Chingkankousaurus",
      "Bicentenaria",
      "Kemkemia",
      "Microceratus",
      "Chaoyangosaurus",
      "Atlasaurus",
      "Eotriceratops",
      "Neimongosaurus",
      "Unicerosaurus",
      "Qinlingosaurus",
      "Laosaurus",
      "Craterosaurus",
      "Dacentrurus",
      "Geminiraptor",
      "Erlikosaurus",
      "Bonitasaura",
      "Arrhinoceratops",
      "Triassolestes",
      "Hisanohamasaurus",
      "Oplosaurus",
      "Supersaurus",
      "Achelousaurus",
      "Rinconsaurus",
      "Serendipaceratops",
      "Eoabelisaurus",
      "Dystrophaeus",
      "Thotobolosaurus",
      "Blancocerosaurus",
      "Cetiosaurus",
      "Roccosaurus",
      "Chondrosteosaurus",
      "Fulengia",
      "Mohammadisaurus",
      "Halticosaurus",
      "Lancangjiangosaurus",
      "Teyuwasu",
      "Breviceratops",
      "Rhodanosaurus",
      "Metriacanthosaurus",
      "Overosaurus",
      "Newtonsaurus",
      "Gracilisuchus",
      "Pseudolagosuchus",
      "Sellosaurus",
      "Ajkaceratops",
      "Lufengosaurus",
      "Yamaceratops",
      "Bagaceratops",
      "Apatosaurus",
      "Khateranisaurus",
      "Batyrosaurus",
      "Cinizasaurus",
      "Tanycolagreus",
      "Bainoceratops",
      "Silesaurid",
      "Byranjaffia",
      "Shamosaurus",
      "Austrosaurus",
      "Amtocephale",
      "Cylindricodon",
      "Huabeisaurus",
      "Regnosaurus",
      "Callovosaurus",
      "Heptasteornis",
      "Gryponyx",
      "Tylosteus",
      "Gargoyleosaurus",
      "Kundurosaurus",
      "Mononykus",
      "Secernosaurus",
      "Puertasaurus",
      "Bellusaurus",
      "Archosauriform",
      "Qiupalong",
      "Alamosaurus",
      "Dystylosaurus",
      "Tethyshadros",
      "Selimanosaurus",
      "Albertadromeus",
      "Karongasaurus",
      "Kaijiangosaurus",
      "Microvenator",
      "Amphicoelias",
      "Eshanosaurus",
      "Salimosaurus",
      "Avimimus",
      "Elvisaurus",
      "Bonatitan",
      "Procheneosaurus",
      "Tetragonosaurus",
      "Mammal",
      "Oshanosaurus",
      "Jurapteryx",
      "Paleosaurus",
      "Dinosauromorph",
      "Plateosauravus",
      "Hungarosaurus",
      "Chromogisaurus",
      "Anoplosaurus",
      "Amargasaurus",
      "Merosaurus",
      "Alwalkeria",
      "Macrodontophion",
      "Shanshanosaurus",
      "Gongxianosaurus",
      "Vectisaurus",
      "Kitadanisaurus",
      "Agustinia",
      "Sulaimanisaurus",
      "Thescelosaurus",
      "Zephyrosaurus",
      "Arenysaurus",
      "Patagosaurus",
      "Laornis",
      "Protoavis",
      "Tenantosaurus",
      "Yinlong",
      "Bravoceratops",
      "Saurophaganax",
      "Coeluroides",
      "Seitaad",
      "Trialestes",
      "Glishades",
      "Cedarpelta",
      "Rinchenia",
      "Lesothosaurus",
      "Dromaeosaur",
      "Nuoerosaurus",
      "Hallopus",
      "Yanornis",
      "Tomodon",
      "Juratyrant",
      "Shanyangosaurus",
      "Deuterosaurus",
      "Coelurus",
      "Zizhongosaurus",
      "Hypselospinus",
      "Austroraptor",
      "Brachytaenius",
      "Orcomimus",
      "Acrotholus",
      "Chirostenotes",
      "Emausaurus",
      "Nigersaurus",
      "Animantarx",
      "Luanchuanraptor",
      "Zuniceratops",
      "Wannanosaurus",
      "Abrictosaurus",
      "Heyuannia",
      "Synapsid",
      "Struthiosaurus",
      "Yunnanosaurus",
      "Noasaurus",
      "Tyrannosaurid",
      "Yibinosaurus",
      "Thespesius",
      "Priconodon",
      "Marasuchus",
      "Anchisaurus",
      "Iguanacolossus",
      "Patagonykus",
      "Haplocanthus",
      "Corythosaurus",
      "Limusaurus",
      "Coloradisaurus",
      "Similicaudipteryx",
      "Leptospondylus",
      "Aviatyrannis",
      "Hortalotarsus",
      "Tienshanosaurus",
      "Pamparaptor",
      "Peishansaurus",
      "Succinodon",
      "Dinosaurus",
      "Rachitrema",
      "Dachongosaurus",
      "Therapsida",
      "Saurolophus",
      "Pekinosaurus",
      "Skorpiovenator",
      "Microsaurops",
      "Ammosaurus",
      "Ichthyosaur",
      "Antarctosaurus",
      "Liaoningosaurus",
      "Nothronychus",
      "Spinosuchus",
      "Iguanosaurus",
      "Anchiceratops",
      "Orkoraptor",
      "Microcoelus",
      "Xuanhanosaurus",
      "Geranosaurus",
      "Goyocephale",
      "Ankylosauria",
      "Dahalokely",
      "Daptosaurus",
      "Loricosaurus",
      "Australodocus",
      "Pterospondylus",
      "Gigantoraptor",
      "Hylaeosaurus",
      "Caudocoelus",
      "Opisthocoelicaudia",
      "Rhadinosaurus",
      "Ligabuesaurus",
      "Aragosaurus",
      "Rocasaurus",
      "Parrosaurus",
      "Sahaliyania",
      "Agilisaurus",
      "Orthomerus",
      "Penelopognathus",
      "Liaoceratops",
      "Dyoplosaurus",
      "Stenonychosaurus",
      "Walkersaurus",
      "Narambuenatitan",
      "Pitekunsaurus",
      "Camarillasaurus",
      "Procolophonid",
      "Epichirostenotes",
      "Beishanlong",
      "Gasosaurus",
      "Coronosaurus",
      "Zapalasaurus",
      "Sauraechinodon",
      "Glacialisaurus",
      "Therapsid",
      "Gravisaurus",
      "Lewisuchus",
      "Jainosaurus",
      "Centemodon",
      "Arkansaurus",
      "Einiosaurus",
      "Palaeoscincus",
      "Cerasinops",
      "Microceratops",
      "Pteropelyx",
      "Sigilmassasaurus",
      "Staurikosaurus",
      "Pyroraptor",
      "Ornithodesmus",
      "Asylosaurus",
      "Anodontosaurus",
      "Siluosaurus",
      "Carnosauria",
      "Qantassaurus",
      "Ornithomimus",
      "Dinodocus",
      "Chuxiongosaurus",
      "Anserimimus",
      "Camptonotus",
      "Lagosuchus",
      "Anatotitan",
      "Dryptosauroides",
      "Silesaurus",
      "Pachysaurops",
      "Saichania",
      "Procerosaurus",
      "Lucianosaurus",
      "Koreasaurus",
      "Lurdusaurus",
      "Piveteausaurus",
      "Jeholornis",
      "Angulomastacator",
      "Hoplosaurus",
      "Saltopus",
      "Shanag",
      "Homalocephale",
      "Torosaurus",
      "Fenestrosaurus",
      "Jubbulpuria",
      "Mtotosaurus",
      "Nemegtosaurus",
      "Maiasaura",
      "Yutyrannus",
      "Ozraptor",
      "Lariosaurus",
      "Bugenasaura",
      "Ornatotholus",
      "Aardonyx",
      "Herbstosaurus",
      "Tianyuraptor",
      "Diplodocus",
      "Kosmoceratops",
      "Muttaburrasaurus",
      "Kagasaurus",
      "Atsinganosaurus",
      "Massospondylus",
      "Utahceratops",
      "Nanotyrannus",
      "Qingxiusaurus",
      "Avalonianus",
      "Erketu",
      "Fulgurotherium",
      "Kayentavenator",
      "Protarchaeopteryx",
      "Chungkingosaurus",
      "Krzyzanowskisaurus",
      "Yimenosaurus",
      "Aurornis",
      "Ganzhousaurus",
      "Pinacosaurus",
      "Archosauromorph",
      "Niobrarasaurus",
      "Melanorosaurus",
      "Baurutitan",
      "Elmisaurus",
      "Euronychodon",
      "Tehuelchesaurus",
      "Sinusonasus",
      "Omeisaurus",
      "Agujaceratops",
      "Aucasaurus",
      "Wulatelong",
      "Stegopelta",
      "Europasaurus",
      "Alxasaurus",
      "Stegosauroides",
      "Tangvayosaurus",
      "Pliosaur",
      "Unquillosaurus",
      "Xixiposaurus",
      "Ornithopsis",
      "Crataeomus",
      "Madsenius",
      "Diplotomodon",
      "Kulceratops",
      "Adamantisaurus",
      "Nyororosaurus",
      "Monoclonius",
      "Kuszholia",
      "Jintasaurus",
      "Camptosaurus",
      "Masiakasaurus",
      "Parhabdodon",
      "Prodeinodon",
      "Saurophagus",
      "Alvarezsaurus",
      "Mantellisaurus",
      "Aristosaurus",
      "Suzhousaurus",
      "Limnosaurus",
      "Dromaeosauroides",
      "Augustia",
      "Spinosaurid",
      "Othnielia",
      "Thecospondylus",
      "Cetacea",
      "Medusaceratops",
      "Zalmoxes",
      "Koreaceratops",
      "Syngonosaurus",
      "Dicraeosaurus",
      "Xenoceratops",
      "Scleromochlus",
      "Deinocheirus",
      "Chuandongocoelurus",
      "Itemirus",
      "Phyllodon",
      "Megaraptor",
      "Philovenator",
      "Ferganasaurus",
      "Pelorosaurus",
      "Nebulasaurus",
      "Barilium",
      "Nedoceratops",
      "Acanthopholis",
      "Nuthetes",
      "Panoplosaurus",
      "Quaesitosaurus",
      "Crocodile",
      "Archaeoraptor",
      "Charonosaurus",
      "Eureodon",
      "Hanssuesia",
      "Guaibasaurus",
      "Camposaurus",
      "Hylosaurus",
      "Zapsalis",
      "Bistahieversor",
      "Erlicosaurus",
      "Procompsognathus",
      "Hypselosaurus",
      "Prenocephale",
      "Malarguesaurus",
      "Tenontosaurus",
      "Kittysaurus",
      "Iguanodon",
      "Palaeoctonus",
      "Trachodon",
      "Wyomingraptor",
      "Huehuecanauhtlus",
      "Theiophytalia",
      "Nectosaurus",
      "Scolosaurus",
      "Pisanosaurus",
      "Kunmingosaurus",
      "Liubangosaurus",
      "Malawisaurus",
      "Pakisaurus",
      "Carnosaur",
      "Leonerasaurus",
      "Oviraptor",
      "Texacephale",
      "Shantungosaurus",
      "Zhuchengosaurus",
      "Gripposaurus",
      "Polacanthus",
      "Xenotarsosaurus",
      "Dinosauriform",
      "Hypsibema",
      "Podokesaurus",
      "Sonidosaurus",
      "Colepiocephale",
      "Kelmayisaurus",
      "Crichtonsaurus",
      "Stegoceras",
      "Borogovia",
      "Lourinhasaurus",
      "Picrodon",
      "Mononychus",
      "Bothriospondylus",
      "Siamosaurus",
      "Technosaurus",
      "Theropod",
      "Neosodon",
      "Velociraptor",
      "Eolosaurus",
      "Archaeovolans",
      "Chebsaurus",
      "Compsosuchus",
      "Othnielosaurus",
      "Banji",
      "Proiguanodon",
      "Rahonavis",
      "Majungasaurus",
      "Nanotyrannosaurus",
      "Bissektipelta",
      "Revueltosaurus",
      "Lexovisaurus",
      "Antrodemus",
      "Hikanodon",
      "Tyrannosaurus",
      "Barrosasaurus",
      "Sinoceratops",
      "Megadontosaurus",
      "Sinosauropteryx",
      "Heilongjiangosaurus",
      "Maxakalisaurus",
      "Jensenosaurus",
      "Dandakosaurus",
      "Therosaurus",
      "Sarahsaurus",
      "Hypselorhachis",
      "Archaeodontosaurus",
      "Gresslyosaurus",
      "Stenopelix"
    ]
}
"#;

/// Contains various fabric types
pub const DATA_FABRIC: &str = r#"
{
  "data": [
    "acrylic",
    "aertex",
    "airdura",
    "airguard",
    "alpaca",
    "angora",
    "argyle",
    "baize",
    "ballistic nylon",
    "ban-lon",
    "barathea",
    "barkcloth",
    "batiste",
    "bedford cord",
    "bengaline silk",
    "beta cloth",
    "bizarre silk",
    "bobbinet",
    "boiled wool",
    "bombazine",
    "brilliantine",
    "broadcloth",
    "brocade",
    "buckram",
    "bunting",
    "burlap",
    "c change",
    "calico",
    "cambric",
    "camlet",
    "canvas",
    "capilene",
    "carbon fiber",
    "cashmere",
    "cedar bark",
    "challis",
    "chambray",
    "char cloth",
    "charmeuse",
    "charvet",
    "cheesecloth",
    "chenille",
    "chiffon",
    "chiné",
    "chino",
    "chintz",
    "cloqué",
    "cloth of gold",
    "coir",
    "conductive",
    "coolmax",
    "cordura",
    "corduroy",
    "cotton",
    "coutil",
    "crape",
    "crêpe",
    "cretonne",
    "crimplene",
    "damask",
    "darlexx",
    "dazzle",
    "denim",
    "dimity",
    "donegal tweed",
    "dornix",
    "dowlas",
    "drill",
    "drugget",
    "duck",
    "e-textiles",
    "eolienne",
    "felt",
    "fishnet",
    "flannel",
    "foulard",
    "fustian",
    "gabardine",
    "gannex",
    "gauze",
    "gazar",
    "georgette",
    "ghalamkar",
    "gingham",
    "gore-tex",
    "grenadine",
    "grenfell cloth",
    "grosgrain",
    "habutai",
    "haircloth",
    "harris tweed",
    "hemp",
    "herringbone",
    "himroo",
    "hodden",
    "houndstooth",
    "irish linen",
    "jamdani",
    "jersey",
    "jute",
    "kente cloth",
    "kerseymere",
    "kevlar",
    "khādī",
    "khaki drill",
    "lace",
    "lamé",
    "lampas",
    "lawn",
    "linen",
    "linsey-woolsey",
    "loden",
    "longcloth",
    "lumalive",
    "machine knitting",
    "mackinaw",
    "madapolam",
    "madras",
    "mesh",
    "microfiber",
    "milliskin",
    "mockado",
    "mohair",
    "moleskin",
    "moquette",
    "muslin",
    "nainsook",
    "nankeen",
    "needlerun net",
    "ninon",
    "nylon",
    "oilskin",
    "olefin",
    "organdy",
    "organza",
    "osnaburg",
    "ottoman",
    "oxford",
    "paduasoy",
    "paisley",
    "pashmina",
    "percale",
    "pin stripes",
    "piña",
    "plush",
    "polar fleece",
    "polyester",
    "pongee",
    "poplin",
    "rakematiz",
    "ramie",
    "rayadillo",
    "rayon",
    "rep",
    "rinzu",
    "ripstop",
    "russell cord",
    "saga nishiki",
    "samite",
    "sateen",
    "satin",
    "saye",
    "scarlet",
    "scrim",
    "sea silk",
    "seersucker",
    "serge",
    "shot silk",
    "shweshwe",
    "silk",
    "silnylon",
    "sisal",
    "songket",
    "spandex",
    "spider silk",
    "stub-tex",
    "stuff",
    "sympatex",
    "taffeta",
    "tais",
    "tartan",
    "tattersall",
    "terrycloth",
    "toile",
    "tucuyo",
    "tulle",
    "tweed",
    "twill",
    "ultrasuede",
    "vegetable flannel",
    "velour",
    "velours du kasaï",
    "velvet",
    "velveteen",
    "ventile",
    "vinyl coated polyester",
    "viyella",
    "voile",
    "wadmal",
    "whipcord",
    "wigan",
    "windstopper",
    "wool",
    "zephyr",
    "zibeline",
    "zorbeez"
  ]
}
"#;

/// Contains various gemstones
pub const DATA_GEMSTONE: &str = r#"
{
  "data":
    [
      "actinolite",
      "adamite",
      "aegerine",
      "afghanite",
      "agardite",
      "agate",
      "ajoite",
      "alabaster",
      "albite",
      "alexandrite",
      "almandine",
      "alunite",
      "amazonite",
      "amber",
      "amethyst",
      "ametrine",
      "ammolite",
      "analcime",
      "anatase",
      "andalusite",
      "andesine",
      "andradite",
      "anglesite",
      "anhydrite",
      "ankerite",
      "annabergite",
      "anthophyllite",
      "antigorite",
      "antlerite",
      "anyolite",
      "apache tears",
      "apophyllite",
      "aquamarine",
      "aragonite",
      "astrophyllite",
      "atacamite",
      "augite",
      "aurichalcite",
      "austinite",
      "aventurine",
      "axinite",
      "azurite",
      "barite",
      "baryte",
      "bauxite",
      "bayldonite",
      "benitoite",
      "beryl",
      "beudantite",
      "biotite",
      "bixbite",
      "blue amber",
      "boleite",
      "bone",
      "boracite",
      "bornite",
      "botallackite",
      "botryogen",
      "bowenite",
      "brazilianite",
      "brochantite",
      "bronzite",
      "brookite",
      "brucite",
      "bubblegram",
      "bytownite",
      "cacoxenite",
      "calcite",
      "caledonite",
      "californite",
      "carletonite",
      "carminite",
      "carnallite",
      "carnelian",
      "cassiterite",
      "castorite",
      "cavansite",
      "celestine",
      "celestite",
      "cerussite",
      "ceylonite",
      "chalcedony",
      "chalcopyrite",
      "chambersite",
      "charoite",
      "chlorastrolite",
      "chloromelanite",
      "chondrodite",
      "chrysoberyl",
      "chrysocolla",
      "chrysotile",
      "cinnabar",
      "citrine",
      "clinochlore",
      "clinohumite",
      "clinozoisite",
      "clintonite",
      "conichalcite",
      "copal",
      "coral",
      "cordierite",
      "corundum",
      "creedite",
      "crocidolite",
      "cummingtonite",
      "cuprite",
      "cymophane",
      "danburite",
      "datolite",
      "diaboleite",
      "diamond",
      "diaspore",
      "diopside",
      "dioptase",
      "dolomite",
      "dravite",
      "druzy",
      "dumortierite",
      "eilat stone",
      "ekanite",
      "elaeolite",
      "elbaite",
      "emerald",
      "enstatite",
      "epidosite",
      "epidote",
      "erythrite",
      "esperite",
      "fayalite",
      "feldspar",
      "ferroaxinite",
      "flint",
      "fluorapatite",
      "fluorapophyllite",
      "fluorite",
      "forsterite",
      "garnet",
      "garnierite",
      "gibbsite",
      "glaucophane",
      "goethite",
      "goshenite",
      "grandidierite",
      "grossular",
      "gypsum",
      "halite",
      "hambergite",
      "hanksite",
      "hardystonite",
      "hauyne",
      "helenite",
      "heliodor",
      "hematite",
      "hemimorphite",
      "hessonite",
      "hibonite",
      "hiddenite",
      "humite",
      "iddingsite",
      "idocrase",
      "iolite",
      "ivory",
      "jacinth",
      "jade",
      "jadeite",
      "jarosite",
      "jasper",
      "jeremejevite",
      "jet",
      "kainite",
      "kidney ore",
      "kimberlite",
      "kornerupine",
      "kunzite",
      "kutnohorite",
      "kyanite",
      "labradorite",
      "lammerite",
      "langbeinite",
      "langite",
      "lapis lazuli",
      "larimar",
      "lawsonite",
      "lazurite",
      "leadhillite",
      "lechatelierite",
      "legrandite",
      "lepidolite",
      "leucophanite",
      "linarite",
      "londonite",
      "magnesioaxinite",
      "magnesite",
      "malachite",
      "manganaxinite",
      "manganoan calcite",
      "maw sit sit",
      "melanterite",
      "mendipite",
      "metal-coated crystals",
      "milky quartz",
      "mimetite",
      "moissanite",
      "mookaite",
      "moonstone",
      "morganite",
      "muscovite",
      "musgravite",
      "nacre",
      "natrophilite",
      "nepheline",
      "nephrite",
      "nimite",
      "normandite",
      "obsidian",
      "olenite",
      "olivenite",
      "olivine",
      "olivinite",
      "onyx",
      "opal",
      "orthoclase",
      "pallasite",
      "pantellerite",
      "papagoite",
      "pargasite",
      "pearl",
      "pectolite",
      "peridot",
      "peridotite",
      "petalite",
      "petoskey stone",
      "pezzottaite",
      "pharmacosiderite",
      "phlogopite",
      "phosgenite",
      "pietersite",
      "pimelite",
      "plancheite",
      "plumbogummite",
      "pollucite",
      "polyhalite",
      "posnjakite",
      "poudretteite",
      "prasiolite",
      "prehnite",
      "proustite",
      "pumpellyite",
      "purpurite",
      "pyrite",
      "pyromorphite",
      "pyrope",
      "pyrrhotite",
      "quartz",
      "raspite",
      "rhodizite",
      "rhodochrosite",
      "riebeckite",
      "rosasite",
      "rose quartz",
      "rossmanite",
      "rubellite",
      "ruby",
      "rutile",
      "sapphire",
      "sardonyx",
      "scapolite",
      "scheelite",
      "schorlomite",
      "scolecite",
      "scorodite",
      "selenite",
      "seraphinite",
      "serendibite",
      "serpentite",
      "shattuckite",
      "shigaite",
      "siderite",
      "smithsonite",
      "smoky quartz",
      "soapstone",
      "sodalite",
      "spessartine",
      "spessartite",
      "sphene",
      "spherocobaltite",
      "spinel",
      "spodumene",
      "steatite",
      "stichtite",
      "stilbite",
      "stishovite",
      "stolzite",
      "strengite",
      "sugilite",
      "sunstone",
      "susannite",
      "sylvite",
      "synthetic alexandrite",
      "synthetic beryl",
      "synthetic corundum",
      "synthetic cubic zirconia",
      "synthetic diamond",
      "synthetic moissanite",
      "synthetic opal",
      "synthetic quartz",
      "synthetic spinel",
      "synthetic turquoise",
      "sérandite",
      "taaffeite",
      "tactite",
      "talc",
      "tantalite",
      "tanzanite",
      "thomsonite",
      "thulite",
      "tiger's-eye",
      "tinaksite",
      "tinzenite",
      "titanite",
      "topaz",
      "tourmaline",
      "tremolite",
      "trinitite",
      "tsavorite",
      "tschermakite",
      "tugtupite",
      "turquoise",
      "tusionite",
      "tyrolite",
      "unakite",
      "uvarovite",
      "vanadinite",
      "variscite",
      "vauxite",
      "vermiculite",
      "vesuvianite",
      "villiaumite",
      "wakefieldite",
      "wavellite",
      "weloganite",
      "wolfenite",
      "xenotime",
      "yttrium aluminium garnet",
      "zektzerite",
      "zeolite",
      "zincite",
      "zinnwaldite",
      "zircon",
      "zoisite"
    ]
}
"#;

/// Contains various moods
pub const DATA_MOOD: &str = r#"
{
	"data" :
	[
		"abandoned",
		"absent minded",
		"abused",
		"accepted",
		"accomplished",
		"accusatory",
		"accused",
		"admired",
		"adored",
		"adrift",
		"affectionate",
		"afraid",
		"aggravated",
		"aggressive",
		"agitated",
		"alarmed",
		"alert",
		"alienated",
		"alive",
		"alluring",
		"alone",
		"aloof",
		"amazed",
		"ambushed",
		"amused",
		"angry",
		"annoyed",
		"antagonistic",
		"anxious",
		"apathetic",
		"apologetic",
		"appalled",
		"appreciated",
		"appreciative",
		"apprehensive",
		"aroused",
		"ashamed",
		"astonished",
		"attacked",
		"attractive",
		"awake",
		"aware",
		"awe",
		"awed",
		"awestruck",
		"awkward",
		"bad",
		"baffled",
		"barren",
		"bashful",
		"beaten",
		"belittled",
		"benevolent",
		"berated",
		"betrayed",
		"bewildered",
		"bitchy",
		"bitter",
		"bittersweet",
		"blah",
		"blamed",
		"blank",
		"blissful",
		"blue",
		"bold",
		"bored",
		"bothered",
		"bouncy",
		"brave",
		"broken",
		"brooding",
		"bummed",
		"burdened",
		"burned-out",
		"callous",
		"calm",
		"capable",
		"carefree",
		"careless",
		"caring",
		"caustic",
		"cautious",
		"censored",
		"centered",
		"certain",
		"challenged",
		"charmed",
		"cheated",
		"cheerful",
		"cherished",
		"childish",
		"chipper",
		"choleric",
		"clean",
		"clear",
		"clever",
		"close",
		"closed",
		"clueless",
		"clumsy",
		"cold",
		"comfortable",
		"committed",
		"compassionate",
		"competent",
		"competitive",
		"complacent",
		"complete",
		"concerned",
		"condemned",
		"condescension",
		"confident",
		"confining",
		"confused",
		"considerate",
		"contemplative",
		"contempt",
		"contemptuous",
		"content",
		"controlled",
		"conventional",
		"convicted",
		"cornered",
		"courageous",
		"cowardly",
		"cranky",
		"crappy",
		"crazy",
		"critical",
		"cross",
		"crushed",
		"curious",
		"cynical",
		"daring",
		"dark",
		"dashed",
		"dazed",
		"dead",
		"deceived",
		"dedicated",
		"defeated",
		"defenseless",
		"defensive",
		"defiant",
		"degraded",
		"dejected",
		"delicate",
		"delighted",
		"demoralized",
		"dependent",
		"depressed",
		"deprived",
		"derisive",
		"deserted",
		"desired",
		"desolate",
		"despair",
		"desperate",
		"destroyed",
		"detached",
		"determined",
		"devastated",
		"devious",
		"devoted",
		"didactic",
		"different",
		"difficult",
		"dignified",
		"dirty",
		"disappointed",
		"disbelieving",
		"discarded",
		"disconnected",
		"discontent",
		"discontented",
		"discouraged",
		"disdainful",
		"disgraced",
		"disgusted",
		"disheartened",
		"dishonest",
		"disillusioned",
		"dismal",
		"dismayed",
		"disobedient",
		"disorganized",
		"disposable",
		"distant",
		"distracted",
		"distressed",
		"disturbed",
		"ditzy",
		"dorky",
		"doubtful",
		"down",
		"drained",
		"dreamy",
		"dreary",
		"dropped",
		"drunk",
		"dull",
		"dumb",
		"eager",
		"earnest",
		"ecstatic",
		"edgy",
		"effective",
		"elated",
		"embarassed",
		"embarrassed",
		"empathetic",
		"empowered",
		"empty",
		"enchanted",
		"encouraged",
		"energetic",
		"energized",
		"enlightened",
		"enraged",
		"enriched",
		"entertained",
		"enthralled",
		"enthusiastic",
		"envious",
		"erudite",
		"evasive",
		"evil",
		"exasperated",
		"excited",
		"excluded",
		"exhausted",
		"exhilarated",
		"expectant",
		"exploited",
		"exposed",
		"exuberant",
		"faithful",
		"fake",
		"fanciful",
		"fantastic",
		"fatalistic",
		"fatigued",
		"fearful",
		"fearless",
		"feisty",
		"fine",
		"flirty",
		"flustered",
		"foolish",
		"foreboding",
		"forgiven",
		"forgiving",
		"forgotten",
		"forthright",
		"fortunate",
		"framed",
		"frantic",
		"free",
		"friendly",
		"frightened",
		"frisky",
		"frustrated",
		"fulfilled",
		"full",
		"funny",
		"furious",
		"futile",
		"geeky",
		"generous",
		"gentle",
		"giddy",
		"giggly",
		"giving",
		"glad",
		"gloomy",
		"glorious",
		"good",
		"grateful",
		"great",
		"grieving",
		"groggy",
		"grouchy",
		"grumpy",
		"guarded",
		"guilty",
		"gullible",
		"handicapped",
		"happy",
		"harmonious",
		"hateful",
		"haughty",
		"haunted",
		"haunting",
		"healthy",
		"heard",
		"heartbroken",
		"heavy-hearted",
		"helpful",
		"helpless",
		"hesitant",
		"high",
		"honored",
		"hopeful",
		"hopeless",
		"horrible",
		"horrified",
		"hospitable",
		"hostile",
		"hot",
		"humble",
		"humiliated",
		"hungry",
		"hurt",
		"hyper",
		"hysterical",
		"idealistic",
		"idiotic",
		"idyllic",
		"ignorant",
		"ignored",
		"imaginative",
		"immune",
		"impatient",
		"impelled",
		"imperfect",
		"impertinent",
		"important",
		"impressed",
		"impulsive",
		"inadequate",
		"inattentive",
		"incensed",
		"inclusive",
		"incompetent",
		"incomplete",
		"incredulous",
		"indebted",
		"indecisive",
		"independent",
		"indescribable",
		"indifferent",
		"indignant",
		"industrious",
		"inept",
		"inferior",
		"inflated",
		"informed",
		"infuriated",
		"inhibited",
		"innocent",
		"innovative",
		"inquisitive",
		"insane",
		"insecure",
		"insensitive",
		"insidious",
		"insignificant",
		"insulted",
		"intense",
		"interested",
		"interrogated",
		"interrupted",
		"intimate",
		"intimidated",
		"intrigued",
		"invigorated",
		"invisible",
		"involved",
		"irate",
		"irked",
		"irrational",
		"irresponsible",
		"irritated",
		"isolated",
		"jaded",
		"jealous",
		"jinxed",
		"jolly",
		"jovial",
		"joyful",
		"joyous",
		"jubilant",
		"judged",
		"judgmental",
		"jumpy",
		"just",
		"justified",
		"kidded",
		"kind",
		"knowledgeable",
		"late",
		"lazy",
		"leery",
		"left",
		"let",
		"lethargic",
		"liable",
		"liberated",
		"liberating",
		"lifeless",
		"light-hearted",
		"liked",
		"listened",
		"listless",
		"logical",
		"lonely",
		"loose",
		"lost",
		"lousy",
		"lovable",
		"loved",
		"loving",
		"lucky",
		"lyrical",
		"mad",
		"malicious",
		"manipulated",
		"matter",
		"fact",
		"mean",
		"meditative",
		"melancholic",
		"melancholy",
		"mellow",
		"merciless",
		"merry",
		"mischievous",
		"miserable",
		"misinterpreted",
		"mistreated",
		"misunderstood",
		"mixed",
		"mocked",
		"mocking",
		"modest",
		"molested",
		"moody",
		"morose",
		"motivated",
		"mournful",
		"moved",
		"mystified",
		"naive",
		"nasty",
		"naughty",
		"nauseated",
		"needed",
		"needy",
		"negative",
		"neglected",
		"nerdy",
		"nervous",
		"neurotic",
		"nightmarish",
		"nonchalant",
		"nostalgic",
		"not",
		"specified",
		"noticed",
		"numb",
		"obeyed",
		"objective",
		"obligated",
		"obvious",
		"odd",
		"offended",
		"okay",
		"old",
		"open",
		"oppressed",
		"optimistic",
		"ornery",
		"control",
		"outraged",
		"overcome",
		"overjoyed",
		"overloaded",
		"overwhelmed",
		"overworked",
		"owned",
		"painful",
		"pampered",
		"panicky",
		"paralyzed",
		"passionate",
		"passive",
		"patient",
		"patronizing",
		"peaceful",
		"peeved",
		"pensive",
		"perky",
		"perplexed",
		"persecuted",
		"pessimistic",
		"pestered",
		"petrified",
		"petty",
		"phony",
		"pious",
		"pissed",
		"off",
		"playful",
		"pleased",
		"poor",
		"positive",
		"possessive",
		"powerful",
		"powerless",
		"practical",
		"predatory",
		"pressured",
		"private",
		"productive",
		"protected",
		"protective",
		"proud",
		"provoked",
		"prudish",
		"punished",
		"pushy",
		"puzzled",
		"questioned",
		"quiet",
		"quixotic",
		"quizzical",
		"rambunctious",
		"realistic",
		"reassured",
		"rebellious",
		"reborn",
		"receptive",
		"reckless",
		"recognized",
		"reconciled",
		"recumbent",
		"reflective",
		"refreshed",
		"regretful",
		"rejected",
		"rejuvenated",
		"relaxed",
		"released",
		"relieved",
		"reluctant",
		"reminiscent",
		"remorse",
		"renewed",
		"replaced",
		"replenished",
		"repressed",
		"rescued",
		"resentful",
		"reserved",
		"resistant",
		"resourceful",
		"respected",
		"responsible",
		"restless",
		"restricted",
		"revengeful",
		"reverent",
		"revitalized",
		"ribald",
		"rich",
		"ridicule",
		"ridiculous",
		"right",
		"rigid",
		"robbed",
		"romantic",
		"rotten",
		"rushed",
		"sabotaged",
		"sad",
		"safe",
		"sarcastic",
		"sardonic",
		"sassy",
		"satiated",
		"satiric",
		"satisfied",
		"saved",
		"scared",
		"scolded",
		"scorned",
		"secure",
		"seductive",
		"selfish",
		"self-assured",
		"self-centered",
		"self-confident",
		"self-conscious",
		"self-destructive",
		"self-reliant",
		"sensitive",
		"sentimental",
		"serene",
		"serious",
		"sexy",
		"shaken",
		"shamed",
		"sheepish",
		"shocked",
		"shunned",
		"shy",
		"sick",
		"silenced",
		"silly",
		"sincere",
		"sinful",
		"skeptical",
		"skillful",
		"slandered",
		"sleepy",
		"sluggish",
		"small",
		"smart",
		"smothered",
		"solemn",
		"somber",
		"soothed",
		"sorry",
		"special",
		"spiteful",
		"splendid",
		"spunky",
		"squashed",
		"stifled",
		"stimulated",
		"stingy",
		"strained",
		"stressed",
		"stretched",
		"strong",
		"stubborn",
		"stumped",
		"stunned",
		"stupid",
		"submissive",
		"successful",
		"suffocated",
		"suicidal",
		"sullen",
		"sunk",
		"super",
		"superior",
		"supported",
		"sure",
		"surly",
		"surprised",
		"suspenseful",
		"suspicious",
		"sympathetic",
		"tacky",
		"tactful",
		"talented",
		"talkative",
		"tame",
		"tarnished",
		"tasteful",
		"tearful",
		"teased",
		"tenacious",
		"tender",
		"tense",
		"tepid",
		"terrible",
		"terrific",
		"terrified",
		"terrifying",
		"tested",
		"testy",
		"thankful",
		"thoughtful",
		"threatened",
		"threatening",
		"thrifty",
		"thrilled",
		"tired",
		"tormented",
		"torn",
		"tortured",
		"touched",
		"tough",
		"tragic",
		"tranquil",
		"transformed",
		"trapped",
		"treasured",
		"trembly",
		"tremendous",
		"tricked",
		"troubled",
		"trusted",
		"trustful",
		"ugly",
		"unaccepted",
		"unappreciated",
		"unbalanced",
		"unburdened",
		"uncanny",
		"uncomfortable",
		"unconcerned",
		"uneven",
		"unfit",
		"unfriendly",
		"united",
		"unjust",
		"unknown",
		"unneeded",
		"unpleasant",
		"unreal",
		"unruly",
		"unwise",
		"up",
		"uplifted",
		"used",
		"useless",
		"vacant",
		"vague",
		"vain",
		"valid",
		"valued",
		"vengeful",
		"vexed",
		"vicious",
		"victimized",
		"victorious",
		"violated",
		"violent",
		"vivacious",
		"vivid",
		"void",
		"wacky",
		"warlike",
		"warm",
		"warmhearted",
		"warned",
		"wary",
		"wasted",
		"weak",
		"wealthy",
		"weary",
		"weird",
		"welcoming",
		"whimsical",
		"whole",
		"wild",
		"willful",
		"wishful",
		"witty",
		"worldly",
		"worried",
		"worse",
		"worthy",
		"wounded",
		"wrong",
		"yearning",
		"yellow",
		"yielding",
		"young",
		"youthful",
		"zany",
		"zealous"
	]
}
"#;

// pub const DATA_DONKEY: &str = r#""#;