# RFC <issue#> - <YYYY-MM-DD> - <title>

One paragraph description of the change.

## Scope

- What will this RFC cover, and what will it not cover?
- Link to any previous RFCs for additional context.

## Motivation

- What is the problem?
- What pain motivated this change?
- Do not cover benefits of your change, that should be covered in the "Rationale" section.

## Internal Proposal

- Describe your change as if you were presenting it to the Vector team.
- Use lists, examples, and code blocks for efficient reading.
- Be specific!

## Doc-level Proposal

- Optional. Only do this if your change is public facing.
- Demonstrate how your change will look in the form of Vector's public docs.

## Rationale

- Why is this change worth it?
- What is the impact of not doing this?
- How does this position us for success in the future?

## Prior Art

- List prior art, the good and bad.
- Why can't we simply use or copy them?

## Drawbacks

- Why should we not do this?
- What kind on ongoing burden does this place on the team?

## Alternatives

- What other approaches have been considered and why did you not choose them?
- How about not doing this at all?

## Outstanding Questions

- List any remaining questions that you have.
- These must be resolved before the RFC can be merged.

## Plan Of Attack

Incremental steps that execute this change. Generally this is in the form of:

- [ ] Submit a PR with spike-level code _roughly_ demonstrating the change.
- [ ] Incremental change #1
- [ ] Incremental change #2
- [ ] ...

Note: This can be filled out during the review process.
