# Tests

This directory contains all the behavior tests for Vector Remap Language.

The tests are split up into different categories.

## Expressions

Contains tests for all built-in expressions.

_See the [documentation](./expressions/README.md) inside the directory for more
details._

## Functions

Contains tests for individual functions.

_See the [documentation](./functions/README.md) inside the directory for more
details._

## Diagnostics

Contains tests that validate our diagnostic error messages.

_See the [documentation](./diagnostics/README.md) inside the directory for more
details._

## Examples

Contains a random set of more expansive test-cases that test a collection of
different features combined together.

_See the [documentation](./examples/README.md) inside the directory for more
details._

## Issues

Contains tests that validate a previous issue that has since been fixed.

_See the [documentation](./issues/README.md) inside the directory for more
details._

## Fix Me

Contains tests that demonstrate an open bug in VRL.

These tests are disabled by default, but are created to keep track of these bugs
in our test suite until they are fixed. Ideally this directory is empty.

_See the [documentation](./fixme/README.md) inside the directory for more
details._

## Internal

Contains a set of tests that validate internal workings of VRL not specific to
a specific expression, diagnostic, etc. New tests should only be added here if
they don't fit any other category.

_See the [documentation](./internal/README.md) inside the directory for more
details._
