package metadata

releases: "0.14.0": {
	date:     "2021-06-03"
	codename: ""

	description: """
		Warning: This release contains a bug with the checkpointing for the `file` source. If you are upgrading from
		`0.13.X` and are using the `file` source, please upgrade to `0.14.1` instead.

		The Vector team is pleased to announce version 0.14.0!

		This release includes a new `exec` source that can be used to execute arbitrary programs and use their output to
		generate events in Vector along with a number of enhancements.

		Check out the [highlights](#highlights) and [changelog](#changelog) for more details.
		"""

	whats_next: [
		{
			title: "End to end acknowledgements"
			description: """
				We've heard from a number of users that they'd like improved delivery guarantees for events flowing
				through Vector. We are working on a feature to allow, for components that are able to support it, to
				only acknowledging data flowing into source components after that data has been sent by any associated
				sinks. For example, this would avoid acknowledging messages in Kafka until the data in those messages
				has been sent via all associated sinks.

				This release includes the groundwork for this feature including support in a number of source and sink
				components that support acknowledgements, but it has not yet been fully documented. We expect to
				officially release this with 0.15.0.
				"""
		},
		{
			title:       "Kubernetes aggregator role"
			description: """
				We are hard at work at expanding the ability to run Vector as an [aggregator in
				Kubernetes](\(urls.vector_aggregator_role)). This will allow you to build end-to-end observability
				pipelines in Kubernetes with Vector. Distributing processing on the edge, centralizing it with an
				aggregator, or both. If you are interested in beta testing, please [join our chat](\(urls.vector_chat))
				and let us know.

				We do expect this to be released in the next few months.
				"""
		},
	]

	commits: [
		{sha: "07e63a9a4f78288495f67e4563ca2a2cbe56dfba", date: "2021-04-22 09:33:33 UTC", description: "Merge down of 0.13.0 release", pr_number:                                                                    7194, scopes: ["releasing"], type:                         "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      11, insertions_count:  440, deletions_count:  8},
		{sha: "69d64f58ca8903fa496838a3421e592b7650b230", date: "2021-04-22 10:38:46 UTC", description: "Bump to 0.14.0", pr_number:                                                                                  7205, scopes: ["dev"], type:                               "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      2, insertions_count:   2, deletions_count:    2},
		{sha: "345088a14fef62fe3976e11202fc67832e3bb311", date: "2021-04-23 05:13:25 UTC", description: "bump cidr-utils from 0.5.1 to 0.5.3", pr_number:                                                             7211, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   6, deletions_count:    6},
		{sha: "2a5e6a2b0eea725aec5c7261b2c0f78019a7ff69", date: "2021-04-22 23:55:15 UTC", description: "bump async-stream from 0.3.0 to 0.3.1", pr_number:                                                           7209, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   6, deletions_count:    6},
		{sha: "507e2c38645f4cf0d4e0d3598b06bb20e80e9600", date: "2021-04-22 23:55:39 UTC", description: "bump syn from 1.0.69 to 1.0.70", pr_number:                                                                  7210, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   57, deletions_count:   57},
		{sha: "2429b0b8583d3527b5e6842f397d4ec6411741c8", date: "2021-04-22 23:56:55 UTC", description: "bump hyper from 0.14.5 to 0.14.6", pr_number:                                                                7212, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   5, deletions_count:    5},
		{sha: "827101422eeee81a19e5d0483894cf681e27b995", date: "2021-04-23 00:57:22 UTC", description: "Remove RUSTSEC-2020-0146 from deny.toml", pr_number:                                                         7216, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   0, deletions_count:    4},
		{sha: "1af0551cea435e86e45da1a67c7c08c6be3687e0", date: "2021-04-22 18:13:07 UTC", description: "Escape quotes and backslashes when printing VRL strings", pr_number:                                         6739, scopes: ["remap"], type:                             "fix", breaking_change:         false, author: "Pablo Sichert", files_count:      3, insertions_count:   130, deletions_count:  2},
		{sha: "3979d3a1bf3ff4a31761f84c006147169b9e1072", date: "2021-04-23 02:10:08 UTC", description: "Consider dropping jemalloc", pr_number:                                                                      6781, scopes: ["performance"], type:                       "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      5, insertions_count:   1, deletions_count:    39},
		{sha: "ad4ddf9a84433ea5f4546cb4dab7131198488b3b", date: "2021-04-23 03:58:15 UTC", description: "bump actions/github-script from v3.1 to v4.0.1", pr_number:                                                  7213, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   4, deletions_count:    4},
		{sha: "5a384382beb94db0344f73ecf7fba801e19b8645", date: "2021-04-23 05:55:12 UTC", description: "Adjust import of `crate::Event` to `crate::event::Event`", pr_number:                                        7200, scopes: [], type:                                    "chore", breaking_change:       false, author: "Brian L. Troutwine", files_count: 86, insertions_count:  116, deletions_count:  116},
		{sha: "f49662a89503987d0aa81797fd48ef58590b6ffd", date: "2021-04-23 21:36:20 UTC", description: "bump hyper from 0.14.6 to 0.14.7", pr_number:                                                                7232, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "ddfcbdb35f07305ecb504e17d9ba7bfcd749fd24", date: "2021-04-23 21:37:06 UTC", description: "bump regex from 1.4.5 to 1.4.6", pr_number:                                                                  7233, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "2b434b73f1451ac4b3aefe25d904d882b12fcac1", date: "2021-04-24 07:44:49 UTC", description: "bump async-nats from 0.9.12 to 0.9.14", pr_number:                                                           7234, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   5, deletions_count:    5},
		{sha: "a6125ba9ef3fac942559e420f1d34134b3f49b9b", date: "2021-04-23 23:38:17 UTC", description: "Run cargo-hack on self-hosted machines", pr_number:                                                          7227, scopes: [], type:                                    "chore", breaking_change:       false, author: "Brian L. Troutwine", files_count: 1, insertions_count:   21, deletions_count:   17},
		{sha: "990ee46acd28e6ab6458e09c53799fa44e9b7b7b", date: "2021-04-26 01:40:39 UTC", description: "Upgrade DiskBuffer to futures 0.3", pr_number:                                                               7165, scopes: ["buffers"], type:                           "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count: 5, insertions_count:   174, deletions_count:  141},
		{sha: "e12ac0e502b86f7dd4e313dafa803f83a682ac90", date: "2021-04-26 01:40:55 UTC", description: "Update to `futures` 0.3", pr_number:                                                                         7225, scopes: ["splunk_hec source"], type:                 "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count: 1, insertions_count:   52, deletions_count:   59},
		{sha: "21ac520ebe6327494b10ca9a2aa2f1b2540e9c8b", date: "2021-04-26 07:28:13 UTC", description: "Expose `events_in` & `events_out` metrics", pr_number:                                                       6888, scopes: ["graphql api"], type:                       "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count: 25, insertions_count:  1643, deletions_count: 83},
		{sha: "109e1b5653cd64547652dc43a74c31a746fca9ff", date: "2021-04-26 23:30:04 UTC", description: "bump rust_decimal from 1.11.1 to 1.12.2", pr_number:                                                         7243, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   2, deletions_count:    2},
		{sha: "75db623323b0e56ce23d21b2be8862a26ee118ad", date: "2021-04-26 23:30:47 UTC", description: "bump tokio-postgres from 0.7.1 to 0.7.2", pr_number:                                                         7244, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "2b150a3e4feea493dde4cd85925458812208fd73", date: "2021-04-26 23:32:05 UTC", description: "bump actions/github-script from v4.0.1 to v4.0.2", pr_number:                                                7245, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   4, deletions_count:    4},
		{sha: "881f3221d3ab3c10f28a50b870ddc52bb09e18d8", date: "2021-04-28 03:46:32 UTC", description: "bump libc from 0.2.93 to 0.2.94", pr_number:                                                                 7254, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "276e755bf58ccf5cf54e16f08f79f586bb5b5af0", date: "2021-04-28 00:42:16 UTC", description: "Document VRL |= operator", pr_number:                                                                        7252, scopes: [], type:                                    "docs", breaking_change:        false, author: "Jesse Szwedko", files_count:      1, insertions_count:   23, deletions_count:   0},
		{sha: "45a209101679ec5e0842cc936f247f8f956ffcf2", date: "2021-04-28 02:10:27 UTC", description: "Allow configuration of max_line_bytes", pr_number:                                                           7226, scopes: ["kubernetes_logs source"], type:            "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:      2, insertions_count:   32, deletions_count:   8},
		{sha: "4792effede6202e7032ba2c98a6ce9185da76483", date: "2021-04-29 04:02:40 UTC", description: "bump tower from 0.4.6 to 0.4.7", pr_number:                                                                  7260, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "1102e5e8432fb93ebb93a7eab840b19ab1ff46fd", date: "2021-04-28 23:23:48 UTC", description: "bump syn from 1.0.70 to 1.0.71", pr_number:                                                                  7261, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   57, deletions_count:   57},
		{sha: "fb34ddc367a6a052ebac3482dfd8a6d7de54bc4e", date: "2021-04-29 14:48:07 UTC", description: "Fix typo", pr_number:                                                                                        7268, scopes: [], type:                                    "docs", breaking_change:        false, author: "Frank Murphy", files_count:       1, insertions_count:   1, deletions_count:    1},
		{sha: "c9cd09d5b4df758830217ce5557285cf7c6601a7", date: "2021-04-29 23:33:13 UTC", description: "bump openssl from 0.10.33 to 0.10.34", pr_number:                                                            7270, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   5, deletions_count:    5},
		{sha: "29736f34150da640175dae4aeb4ff8638cd1c441", date: "2021-04-29 23:41:09 UTC", description: "bump pulsar from 2.0.0 to 2.0.1", pr_number:                                                                 7271, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "b11ac642e88e963f57d348d5d2530ca5daffd895", date: "2021-04-30 01:54:39 UTC", description: "Update install script to 0.13.1", pr_number:                                                                 7275, scopes: ["releasing"], type:                         "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   1, deletions_count:    1},
		{sha: "ffaa9e4e97de41577f4922ddfd13467d537ec243", date: "2021-04-29 22:59:51 UTC", description: "New `exec` source", pr_number:                                                                               6876, scopes: ["new source"], type:                        "feat", breaking_change:        false, author: "moogstuart", files_count:         12, insertions_count:  1350, deletions_count: 0},
		{sha: "0240ae601884e9c1aa6758a67c4d517a525dc8f9", date: "2021-04-30 09:36:06 UTC", description: "created new lookup library", pr_number:                                                                      7087, scopes: ["dev"], type:                               "chore", breaking_change:       false, author: "Stephen Wakely", files_count:     59, insertions_count:  3698, deletions_count: 1200},
		{sha: "c889391f7a2d2bb968d15c1a111c7617bee6ebb7", date: "2021-05-01 05:31:37 UTC", description: "bump rust_decimal from 1.12.2 to 1.12.3", pr_number:                                                         7280, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   3, deletions_count:    3},
		{sha: "e9408ade7df745eae5431d926794717ed6cbaf09", date: "2021-04-30 23:54:13 UTC", description: "bump libz-sys from 1.1.2 to 1.1.3", pr_number:                                                               7278, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "df609c503d24e9d9b75b7b5f908151f6e74ba712", date: "2021-04-30 23:55:00 UTC", description: "bump async-nats from 0.9.14 to 0.9.16", pr_number:                                                           7279, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   5, deletions_count:    5},
		{sha: "beb0cf7b9f79a1961e65db589c17015d2a17cea0", date: "2021-05-01 09:16:08 UTC", description: "Update `top` to use more accurate `events_in_total` and `events_out_total` metrics", pr_number:              7286, scopes: ["cli"], type:                               "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count: 3, insertions_count:   121, deletions_count:  36},
		{sha: "b49d4339f8964072a527bf7cd82c97c63531010c", date: "2021-05-01 03:31:53 UTC", description: "Fix action-discord version for test workflow", pr_number:                                                    7285, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   1, deletions_count:    1},
		{sha: "eaaf15fb23187552b064be9857e6cc26021facd4", date: "2021-05-01 10:50:13 UTC", description: "`--no-default-features --features api` build failure", pr_number:                                            7284, scopes: ["graphql api"], type:                       "fix", breaking_change:         false, author: "Lee Benson", files_count:         2, insertions_count:   7, deletions_count:    4},
		{sha: "3c23de96b9bd7372716e2d9f7136ecdbb6e347a4", date: "2021-05-01 07:38:25 UTC", description: "Document scrape_interval_secs for `internal_metrics` source", pr_number:                                     7289, scopes: ["internal_metrics source"], type:           "docs", breaking_change:        false, author: "Jesse Szwedko", files_count:      1, insertions_count:   12, deletions_count:   0},
		{sha: "989368d3ec629ae3728ecb090cfbb7d2b747e245", date: "2021-05-01 10:42:16 UTC", description: "Simplify `cargo test` usage", pr_number:                                                                     7287, scopes: ["tests"], type:                             "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      8, insertions_count:   19, deletions_count:   7},
		{sha: "d8ff7901842cc2f5e276a175a3d5f2424b7871a2", date: "2021-05-04 00:26:49 UTC", description: "bump tracing-core from 0.1.17 to 0.1.18", pr_number:                                                         7294, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   10, deletions_count:   10},
		{sha: "6ab678213f6240159e10c7bfe540e6bb728975a3", date: "2021-05-04 00:27:49 UTC", description: "bump tui from 0.14.0 to 0.15.0", pr_number:                                                                  7295, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   6, deletions_count:    31},
		{sha: "78f0840849f64f2390efbb59d2b4c046e6c3626e", date: "2021-05-04 00:29:41 UTC", description: "bump built from 0.4.4 to 0.5.0", pr_number:                                                                  7297, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   6, deletions_count:    7},
		{sha: "3733bab738c0bfbd0c1e9026a946d5758f772c21", date: "2021-05-04 09:24:34 UTC", description: "Emit internal metrics provided by rdkafka", pr_number:                                                       5874, scopes: ["kafka source", "kafka sink"], type:        "enhancement", breaking_change: false, author: "Pablo Sichert", files_count:      9, insertions_count:   212, deletions_count:  12},
		{sha: "bafb47710a1cf19ee88bb6c9bed33ca79848f100", date: "2021-05-04 04:06:06 UTC", description: "bump rust_decimal from 1.12.3 to 1.12.4", pr_number:                                                         7301, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   2, deletions_count:    2},
		{sha: "a8ac2bf6ce0c0b2476f0158e6e16a7fd04c40678", date: "2021-05-04 04:06:24 UTC", description: "bump bstr from 0.2.15 to 0.2.16", pr_number:                                                                 7302, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   4, deletions_count:    4},
		{sha: "54f795ca537c13c18a8402f2ab4ac97fcbcaab3f", date: "2021-05-04 04:35:59 UTC", description: "Fix typo", pr_number:                                                                                        7304, scopes: [], type:                                    "docs", breaking_change:        false, author: "Jesse Szwedko", files_count:      1, insertions_count:   1, deletions_count:    1},
		{sha: "f8ac9bec17ef7b27609d9a2bdd9cb17b374369a7", date: "2021-05-04 05:35:54 UTC", description: "Make CI tests run a little more quiet", pr_number:                                                           7269, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Brian L. Troutwine", files_count: 4, insertions_count:   55, deletions_count:   19},
		{sha: "eac02c97bea04feb33ca778c1e6175bd0b007407", date: "2021-05-05 05:16:04 UTC", description: "Wdd `whitespace` option to `parse_key_value` function", pr_number:                                           7292, scopes: ["remap"], type:                             "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count: 3, insertions_count:   160, deletions_count:  19},
		{sha: "f39255be67dff9a59da932d5e6bc5464d047c118", date: "2021-05-04 23:56:43 UTC", description: "bump tracing-subscriber from 0.2.17 to 0.2.18", pr_number:                                                   7298, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "54f9d7349e5741f1e80490a2558d806a0859f973", date: "2021-05-04 23:57:28 UTC", description: "bump snap from 1.0.4 to 1.0.5", pr_number:                                                                   7300, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "6f11ab1de08d1fd78d1a13bb6ce7d0dada291b6f", date: "2021-05-05 00:26:26 UTC", description: "Run cargo-flake on the project", pr_number:                                                                  7307, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Brian L. Troutwine", files_count: 1, insertions_count:   36, deletions_count:   0},
		{sha: "d3017c9c9ce1dbe1b8f420c2cb9cdcb3f07f5b05", date: "2021-05-05 00:35:28 UTC", description: "Introduce more aggressive caching", pr_number:                                                               7306, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Brian L. Troutwine", files_count: 1, insertions_count:   15, deletions_count:   0},
		{sha: "4ec1700ae55f90bf0419a22ddca7eb0e2a97b8ff", date: "2021-05-05 01:01:21 UTC", description: "Extract `Event` into vector-core", pr_number:                                                                7240, scopes: ["dev"], type:                               "chore", breaking_change:       false, author: "Brian L. Troutwine", files_count: 110, insertions_count: 365, deletions_count:  298},
		{sha: "d5bec946241d188609fdb575f05ace349d4f897c", date: "2021-05-05 07:26:29 UTC", description: "bump rust_decimal from 1.12.4 to 1.13.0", pr_number:                                                         7320, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   2, deletions_count:    2},
		{sha: "7b9e38d67d201104edc7ad6c3ea0e80612e64b6e", date: "2021-05-05 07:26:59 UTC", description: "bump ordered-float from 2.1.1 to 2.2.0", pr_number:                                                          7321, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   2, deletions_count:    2},
		{sha: "7e3795d45d7ccd8e5e02fcf780cf4f17a782e5ce", date: "2021-05-05 09:32:26 UTC", description: "Flag benchmark runs that fail to actually execute", pr_number:                                               7330, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   0, deletions_count:    3},
		{sha: "ae027b0b13695180c26b0696c861f992424b7db6", date: "2021-05-06 03:53:59 UTC", description: "Default `host` to remote address", pr_number:                                                                7293, scopes: ["splunk_hec source"], type:                 "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count: 1, insertions_count:   39, deletions_count:   11},
		{sha: "66d090a2cbe071bdf01d9a9aaa44dc7dd12e3cdc", date: "2021-05-06 04:02:14 UTC", description: "Enable comma separated lists to be used in configuration environment variables that take a list", pr_number: 7316, scopes: ["cli"], type:                               "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count: 4, insertions_count:   37, deletions_count:   14},
		{sha: "db7b142ace79390561a8179d2d9c0ad7d4388593", date: "2021-05-06 04:05:46 UTC", description: "Generic site support", pr_number:                                                                            7281, scopes: ["datadog sinks"], type:                     "enhancement", breaking_change: false, author: "Pierre Rognant", files_count:     4, insertions_count:   72, deletions_count:   20},
		{sha: "54845846d15ddba1264dd658d1e3c766a1d12af1", date: "2021-05-06 07:09:19 UTC", description: "Reference RFC template in RFC readme", pr_number:                                                            7344, scopes: [], type:                                    "chore", breaking_change:       false, author: "Pablo Sichert", files_count:      1, insertions_count:   1, deletions_count:    1},
		{sha: "ca268085ca288bfa8e0bbae54f9d2658892bf058", date: "2021-05-05 22:53:57 UTC", description: "Use 'cargo hack' instead of check-component-features", pr_number:                                            7311, scopes: [], type:                                    "chore", breaking_change:       false, author: "Brian L. Troutwine", files_count: 7, insertions_count:   10, deletions_count:   114},
		{sha: "76cf717433cd8951f7b1403382db2c9508072bae", date: "2021-05-06 01:55:36 UTC", description: "bump syn from 1.0.71 to 1.0.72", pr_number:                                                                  7334, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   58, deletions_count:   58},
		{sha: "61624c4ccf2d38e8fabb13f545f722eed1ff5674", date: "2021-05-06 01:57:45 UTC", description: "bump regex from 1.4.6 to 1.5.3", pr_number:                                                                  7319, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    4, insertions_count:   9, deletions_count:    9},
		{sha: "ec5adc6ff16b2c219d3257406847d10871688bdd", date: "2021-05-06 02:07:48 UTC", description: "bump tracing from 0.1.25 to 0.1.26", pr_number:                                                              7296, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    6, insertions_count:   27, deletions_count:   27},
		{sha: "22a38c95e578a0b84d1f9e495ad4e74b2412c8fe", date: "2021-05-06 05:59:25 UTC", description: "Run tests for all targets on all platforms", pr_number:                                                      7323, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      8, insertions_count:   32, deletions_count:   61},
		{sha: "187bacd14e4d6c1fe77e0a3a7c01a0bff91a360a", date: "2021-05-06 05:55:37 UTC", description: "Drop unnecessary `Request` parameter from types", pr_number:                                                 7251, scopes: ["sinks"], type:                             "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      3, insertions_count:   35, deletions_count:   38},
		{sha: "7fd0a3daf8a323c51fa79597ffc94cc9b52f44f5", date: "2021-05-07 02:34:15 UTC", description: "Drop `futures01`", pr_number:                                                                                7343, scopes: [], type:                                    "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count: 4, insertions_count:   4, deletions_count:    68},
		{sha: "1f771cc2125b1b31fdc469c68ef507e313e68b2b", date: "2021-05-07 00:40:46 UTC", description: "bump sha-1 from 0.9.4 to 0.9.5", pr_number:                                                                  7357, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   13, deletions_count:   7},
		{sha: "6ccf01a1910baf51a97bf693eed9404610e669d1", date: "2021-05-07 01:58:10 UTC", description: "bump metrics from 0.14.2 to 0.15.1", pr_number:                                                              7313, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    5, insertions_count:   67, deletions_count:   32},
		{sha: "ccbca4801b5c468186aba6e688fd47aed916e72c", date: "2021-05-07 02:51:27 UTC", description: "Update grok and dependencies", pr_number:                                                                    7176, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      12, insertions_count:  98, deletions_count:   10},
		{sha: "96d6031859d6568a39fa5ef6212b11b815b0f894", date: "2021-05-07 02:28:39 UTC", description: "Drop redundant copy of built info", pr_number:                                                               7365, scopes: [], type:                                    "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      2, insertions_count:   2, deletions_count:    7},
		{sha: "7e90a2469f931ca601601221b9e6f35fe9350fa4", date: "2021-05-07 04:52:44 UTC", description: "RFC for emitting multiple log events from remap", pr_number:                                                 7038, scopes: [], type:                                    "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   263, deletions_count:  0},
		{sha: "2876dd98d64469c26f25c96f1cfa105b23f8cd42", date: "2021-05-07 05:00:51 UTC", description: "Enable stricter clippy lints in vector-core", pr_number:                                                     7341, scopes: [], type:                                    "chore", breaking_change:       false, author: "Brian L. Troutwine", files_count: 28, insertions_count:  490, deletions_count:  305},
		{sha: "125e3df559eb5f06cbe4eb1a424fcd980f6ddc15", date: "2021-05-07 23:46:22 UTC", description: "Remove emits & alias `processed_events_total` metric", pr_number:                                            7345, scopes: ["metrics"], type:                           "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count: 31, insertions_count:  25, deletions_count:   125},
		{sha: "847d211f1d6ac8cfcbb4ad8295457c631c3867a6", date: "2021-05-07 23:56:37 UTC", description: "bump regex from 1.5.3 to 1.5.4", pr_number:                                                                  7374, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    4, insertions_count:   5, deletions_count:    5},
		{sha: "5b2c2261d5b8cddbd83adda3c4e97fbfa99dbaf5", date: "2021-05-08 01:26:53 UTC", description: "Install llvm on Windows nightly and release bulids too", pr_number:                                          7377, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      2, insertions_count:   2, deletions_count:    0},
		{sha: "d95595555c958e3b8b11001e81d2ba24dee33c9b", date: "2021-05-08 01:44:26 UTC", description: "Fix alias for processed_events_total", pr_number:                                                            7378, scopes: ["metrics"], type:                           "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   1, deletions_count:    1},
		{sha: "f0c1cd24d0f0047bb6911a1c1002abfe06a27442", date: "2021-05-08 01:10:49 UTC", description: "Correct all `*_nanoseconds` metrics to `_seconds`", pr_number:                                               7373, scopes: ["observability"], type:                     "fix", breaking_change:         true, author:  "Bruce Guenter", files_count:      17, insertions_count:  73, deletions_count:   73},
		{sha: "24f1f8f3193d5e1eb5d60e3da7dbe0e075fbf9de", date: "2021-05-08 05:48:42 UTC", description: "Add metadata support for end-to-end acknowledgements", pr_number:                                            7141, scopes: ["data model"], type:                        "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      11, insertions_count:  452, deletions_count:  29},
		{sha: "6db09e1797f5d7ccb6a1abef89f3425229e18e8d", date: "2021-05-08 08:21:23 UTC", description: "Add support for end-to-end acknowledgements", pr_number:                                                     7265, scopes: ["http sink"], type:                         "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      52, insertions_count:  757, deletions_count:  450},
		{sha: "e69192831296cae17788df4cd48e1af2e825a5d3", date: "2021-05-09 12:46:44 UTC", description: "Fix deb verify steps", pr_number:                                                                            7385, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   1, deletions_count:    1},
		{sha: "4b5d6ce47a3deada860a1637b4575c1664be5ea7", date: "2021-05-11 01:13:02 UTC", description: "Allow emitting multiple events by assigning `.` to an array", pr_number:                                     7267, scopes: ["remap transform"], type:                   "feat", breaking_change:        false, author: "Jesse Szwedko", files_count:      11, insertions_count:  942, deletions_count:  671},
		{sha: "f0bb48c9b0836a77e5b0e0f8d67d4600854c3666", date: "2021-05-11 02:02:48 UTC", description: "Add parse_klog function", pr_number:                                                                         7349, scopes: ["remap"], type:                             "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:      6, insertions_count:   277, deletions_count:  1},
		{sha: "9b5d3b6efcf88c8dbe5901bee8ecb91149474096", date: "2021-05-11 02:03:05 UTC", description: "Fix rendering of buffers/batches sections", pr_number:                                                       7305, scopes: [], type:                                    "docs", breaking_change:        false, author: "Jesse Szwedko", files_count:      25, insertions_count:  18, deletions_count:   30},
		{sha: "ced2ca33a58157d83a31365fb1a31fec8290670b", date: "2021-05-11 07:29:09 UTC", description: "Distinguish end-to-end errors", pr_number:                                                                   7396, scopes: ["http sink"], type:                         "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      4, insertions_count:   135, deletions_count:  27},
		{sha: "848d9226138b7be6f592a22f35ccd1a51d545324", date: "2021-05-11 23:29:23 UTC", description: "Work around a LevelDB mechanism mismatch", pr_number:                                                        7398, scopes: ["buffers"], type:                           "fix", breaking_change:         false, author: "Brian L. Troutwine", files_count: 1, insertions_count:   28, deletions_count:   2},
		{sha: "5a58ec1e0226ede6e4f590d5722b9629b17d540c", date: "2021-05-12 03:53:15 UTC", description: "bump url from 2.2.1 to 2.2.2", pr_number:                                                                    7387, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    4, insertions_count:   5, deletions_count:    5},
		{sha: "3e87fcecefc6895c944223eddb9d723b957ac21c", date: "2021-05-12 04:05:56 UTC", description: "Migrate `buffers` into vector-core", pr_number:                                                              7400, scopes: [], type:                                    "chore", breaking_change:       false, author: "Brian L. Troutwine", files_count: 11, insertions_count:  432, deletions_count:  385},
		{sha: "42adcf12f4feebe42707e8e152642b9e18198337", date: "2021-05-12 05:38:04 UTC", description: "Add acknowledgements support", pr_number:                                                                    7354, scopes: ["datadog_logs sink"], type:                 "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      4, insertions_count:   104, deletions_count:  63},
		{sha: "838bdb227c42ee42aee5f70e45706d5f0ae6d29a", date: "2021-05-12 05:43:23 UTC", description: "Add acknowledgement support", pr_number:                                                                     7325, scopes: ["datadog source", "http source"], type:     "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      13, insertions_count:  413, deletions_count:  138},
		{sha: "151dacf5b8b50afd3686eb4022ee487d2521a474", date: "2021-05-13 00:47:31 UTC", description: "Initial `[provider]` implementation - `http`", pr_number:                                                    7166, scopes: ["config"], type:                            "feat", breaking_change:        false, author: "Lee Benson", files_count:         12, insertions_count:  489, deletions_count:  57},
		{sha: "4f077022f4de5d5d5f6b2d285b814860b612c75f", date: "2021-05-13 00:16:32 UTC", description: "Temporarily revert #7325", pr_number:                                                                        7426, scopes: [], type:                                    "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      13, insertions_count:  138, deletions_count:  413},
		{sha: "8e39114ad8fd2bb25b5f8d6122bc4d5ce9f63fbf", date: "2021-05-13 02:19:09 UTC", description: "bump docker/build-push-action from 2 to 2.4.0", pr_number:                                                   7422, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   1, deletions_count:    1},
		{sha: "ac512700e9d906c78f35cc2ba6a13f2197144766", date: "2021-05-13 02:23:38 UTC", description: "bump docker/setup-buildx-action from 1 to 1.3.0", pr_number:                                                 7418, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   3, deletions_count:    3},
		{sha: "d08eabe84913fd7f0effe86354c5360fa816f364", date: "2021-05-13 02:24:27 UTC", description: "bump EmbarkStudios/cargo-deny-action from 1 to 1.2.6", pr_number:                                            7419, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   2, deletions_count:    2},
		{sha: "2a5193bbf77972911efa9f59c2096f41931f5418", date: "2021-05-13 02:25:15 UTC", description: "bump actions/checkout from 2 to 2.3.4", pr_number:                                                           7420, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    10, insertions_count:  64, deletions_count:   64},
		{sha: "6b02996e07c4f843d9c77ae46fcdbe0f4c7e84e3", date: "2021-05-13 02:26:11 UTC", description: "bump docker/setup-qemu-action from 1 to 1.1.0", pr_number:                                                   7421, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   3, deletions_count:    3},
		{sha: "67c854fe1fee86c94a36665adcd607e942947505", date: "2021-05-13 02:37:46 UTC", description: "bump docker/login-action from 1 to 1.9.0", pr_number:                                                        7430, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   3, deletions_count:    3},
		{sha: "230a27e5b2c39862bf0d880052443b609d0ca29d", date: "2021-05-13 05:47:02 UTC", description: "Allowing setting command for vector-agent chart", pr_number:                                                 7107, scopes: ["helm platform"], type:                     "enhancement", breaking_change: false, author: "Martin Lévesque", files_count:    6, insertions_count:   13, deletions_count:   0},
		{sha: "7c2977e749414ce20573f988c56b359c6915487e", date: "2021-05-13 23:56:26 UTC", description: "bump serde from 1.0.125 to 1.0.126", pr_number:                                                              7440, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    6, insertions_count:   9, deletions_count:    9},
		{sha: "d990d68a54ad92ce44c869d9c8ab9d0c9142a842", date: "2021-05-14 01:24:37 UTC", description: "bump openssl-probe from 0.1.2 to 0.1.4", pr_number:                                                          7415, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "9f4da5bdc9a5857235a8b5650a5dc4af48554b18", date: "2021-05-14 01:25:06 UTC", description: "bump futures from 0.3.14 to 0.3.15", pr_number:                                                              7417, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   51, deletions_count:   49},
		{sha: "f53bf3d61530eee27b18313901d826a99d036a66", date: "2021-05-14 03:30:29 UTC", description: "bump assert_cmd from 1.0.3 to 1.0.4", pr_number:                                                             7439, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "2a5c7b60cae15ad92487e8647650874a35569425", date: "2021-05-14 04:34:49 UTC", description: "Ensure latest artifacts are also published with version number", pr_number:                                  7446, scopes: ["releasing"], type:                         "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   13, deletions_count:   20},
		{sha: "5a9df010ec0ca3c61444362702b24c41c37f0d79", date: "2021-05-14 11:34:07 UTC", description: "Add debhelper include tags to Debian scripts", pr_number:                                                    7363, scopes: ["debian platform"], type:                   "fix", breaking_change:         false, author: "Johann Queuniet", files_count:    3, insertions_count:   7, deletions_count:    0},
		{sha: "e6cb3e6ba3314b379c013ab236a83c49cdfaad73", date: "2021-05-14 07:00:19 UTC", description: "Add end-to-end acknowledgements", pr_number:                                                                 7431, scopes: ["heroku_logs source", "http source"], type: "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      13, insertions_count:  509, deletions_count:  157},
		{sha: "c2a406972ca3c2d5fff0974dff4e9caebb858117", date: "2021-05-14 08:10:42 UTC", description: "Add acknowledgements support to more HTTP logs sinks", pr_number:                                            7411, scopes: ["sinks"], type:                             "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      18, insertions_count:  297, deletions_count:  199},
		{sha: "4756e00e0294e9be99604a0b98720a5d2364a67b", date: "2021-05-15 04:41:25 UTC", description: "Document real behaviour of the timestamp field in Syslog source", pr_number:                                 7443, scopes: ["external docs"], type:                     "fix", breaking_change:         false, author: "Hugo Hromic", files_count:        1, insertions_count:   5, deletions_count:    1},
		{sha: "82a7f129b660f45d8085cefe053e6c4de4508a95", date: "2021-05-14 23:45:50 UTC", description: "bump notify from 4.0.16 to 4.0.17", pr_number:                                                               7450, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "b57d9f596ca25985dfc682cbb0928bd1658d4041", date: "2021-05-14 23:51:29 UTC", description: "bump sha-1 from 0.9.5 to 0.9.6", pr_number:                                                                  7416, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   11, deletions_count:   8},
		{sha: "c305c6290cbcdcde795367b12dd7b13c4e4bff7d", date: "2021-05-14 21:55:21 UTC", description: "Add missing `drop` in test", pr_number:                                                                      7451, scopes: ["influxdb_logs sink"], type:                "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      1, insertions_count:   2, deletions_count:    0},
		{sha: "65b41b4403d1bacbd8a58379bda9dc40f4ed7fdc", date: "2021-05-14 21:55:36 UTC", description: "Use correct batch status", pr_number:                                                                        7452, scopes: ["clickhouse sink"], type:                   "fix", breaking_change:         false, author: "Bruce Guenter", files_count:      1, insertions_count:   1, deletions_count:    1},
		{sha: "a211463d55e48aa4b67f05de99fb20e76835d65c", date: "2021-05-15 08:56:04 UTC", description: "Add `encode_logfmt` function", pr_number:                                                                    6985, scopes: ["remap"], type:                             "feat", breaking_change:        false, author: "Mathieu Stefani", files_count:    6, insertions_count:   399, deletions_count:  2},
		{sha: "ee128e60598250723655895ec893cdc4601efbd3", date: "2021-05-15 03:07:21 UTC", description: "Fix the API port in the docker docs", pr_number:                                                             7366, scopes: [], type:                                    "docs", breaking_change:        false, author: "Jesse Szwedko", files_count:      1, insertions_count:   1, deletions_count:    1},
		{sha: "8b889823b5a833fbfc32149992d5904c1190dc0e", date: "2021-05-15 03:09:45 UTC", description: "Expose data_dir configuration", pr_number:                                                                   7253, scopes: ["kubernetes_logs source"], type:            "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:      1, insertions_count:   4, deletions_count:    1},
		{sha: "b5f21c0d29e0af63d32e36f8f0c43fef29fcd79c", date: "2021-05-16 04:26:16 UTC", description: "Install git before checking out for verify jobs", pr_number:                                                 7473, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      2, insertions_count:   8, deletions_count:    8},
		{sha: "f6fef2ceb16076b907cc57ce969a22dcf202b814", date: "2021-05-17 23:21:42 UTC", description: "bump tokio-test from 0.4.1 to 0.4.2", pr_number:                                                             7475, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   4, deletions_count:    4},
		{sha: "3a06e73ac7532a3d4cef3a562766f1459c002668", date: "2021-05-17 23:24:06 UTC", description: "bump tokio-util from 0.6.6 to 0.6.7", pr_number:                                                             7478, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   4, deletions_count:    4},
		{sha: "1bbf3d2f5f31f0f349c46db7be74b1bd013677be", date: "2021-05-18 02:46:25 UTC", description: "Upgrade to Rust 1.52.0", pr_number:                                                                          7467, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      5, insertions_count:   10, deletions_count:   11},
		{sha: "33258142d3c3d4acfd0dda9144b72fbe1ad87388", date: "2021-05-18 04:36:46 UTC", description: "bump tokio-stream from 0.1.5 to 0.1.6", pr_number:                                                           7479, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   4, deletions_count:    4},
		{sha: "afefa8217473cb1dc77cbe1a4a57047e6b56081a", date: "2021-05-18 05:29:53 UTC", description: "Add kubeval checks to helm chart updates", pr_number:                                                        6649, scopes: ["kubernetes_logs source"], type:            "chore", breaking_change:       false, author: "Ian Henry", files_count:          2, insertions_count:   5, deletions_count:    0},
		{sha: "0af9a177312a8198c4d3ede06752daace4b0fa8f", date: "2021-05-18 05:58:40 UTC", description: "Rename to `route`", pr_number:                                                                               6193, scopes: ["swimlanes transform"], type:               "chore", breaking_change:       false, author: "GitHub", files_count:             1, insertions_count:   2, deletions_count:    1},
		{sha: "268aafb705ec6d8a5ff2b41d7b5b5586c01460c3", date: "2021-05-18 04:12:14 UTC", description: "Fix binfmt exclusion in Helm chart", pr_number:                                                              7332, scopes: ["kubernetes platform"], type:               "fix", breaking_change:         false, author: "Bruce Guenter", files_count:      6, insertions_count:   21, deletions_count:   0},
		{sha: "c25b5f4968d9418884bfea97a8237fa6421d14ca", date: "2021-05-18 05:12:59 UTC", description: "Bump Rust version to 1.52.1", pr_number:                                                                     7489, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      1, insertions_count:   1, deletions_count:    1},
		{sha: "45a09192b4c7e04c20887f9581cfaefb71ebc678", date: "2021-05-19 07:18:20 UTC", description: "bump mongodb from 2.0.0-alpha.1 to 2.0.0-beta", pr_number:                                                   7476, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   17, deletions_count:   13},
		{sha: "1595d3de04a3b860d9e43daf856357bd1c70011b", date: "2021-05-19 07:35:03 UTC", description: "Configure cross to run correctly in `make environment`", pr_number:                                          7466, scopes: ["dev"], type:                               "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      2, insertions_count:   6, deletions_count:    1},
		{sha: "4e2795c498cfd7fe29c647abf9fdd7baa517e8da", date: "2021-05-19 05:34:49 UTC", description: "Make vector-core buffers generic", pr_number:                                                                7471, scopes: ["buffers"], type:                           "chore", breaking_change:       false, author: "Brian L. Troutwine", files_count: 23, insertions_count:  1402, deletions_count: 597},
		{sha: "96d33b0174196f50a0832aa93cb844c67d2ed94b", date: "2021-05-19 08:43:27 UTC", description: "Properly handle urlencoded S3 object keys", pr_number:                                                       7470, scopes: ["aws_s3 source"], type:                     "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:      2, insertions_count:   40, deletions_count:   0},
		{sha: "17b2f46dba8b1b3343a20b7de8e832216826dad6", date: "2021-05-20 02:30:02 UTC", description: "Specify the namespace to run k8s test in", pr_number:                                                        7388, scopes: ["tests"], type:                             "chore", breaking_change:       false, author: "Stephen Wakely", files_count:     5, insertions_count:   266, deletions_count:  161},
		{sha: "07e6343b38eb0ab307927a3335c729e8102d2e90", date: "2021-05-19 23:59:54 UTC", description: "Fix configure command in installation instructions", pr_number:                                              7498, scopes: ["external docs"], type:                     "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:      9, insertions_count:   81, deletions_count:   98},
		{sha: "206876830474100d6f23a9c498bcf9deccccc104", date: "2021-05-20 00:05:01 UTC", description: "bump rustyline from 8.0.0 to 8.1.0", pr_number:                                                              7507, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   42, deletions_count:   13},
		{sha: "029a8c8a9dee51b97db257ffe87a78355b2e4e13", date: "2021-05-20 01:40:41 UTC", description: "Divvy up vector-core", pr_number:                                                                            7504, scopes: ["dev"], type:                               "chore", breaking_change:       false, author: "Brian L. Troutwine", files_count: 22, insertions_count:  131, deletions_count:  440},
		{sha: "440df5543c476f6ad24fd708d90d198d7ce6f093", date: "2021-05-20 05:52:22 UTC", description: "bump async-nats from 0.9.16 to 0.9.17", pr_number:                                                           7518, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   5, deletions_count:    5},
		{sha: "e2673967c06eab859246272ddf9d842ce8286f61", date: "2021-05-20 12:01:58 UTC", description: "Fix broken k8s tests", pr_number:                                                                            7517, scopes: ["tests"], type:                             "chore", breaking_change:       false, author: "Stephen Wakely", files_count:     2, insertions_count:   18, deletions_count:   8},
		{sha: "d56a2404ae443db46fb63d558791db6cdaa12b53", date: "2021-05-20 08:38:06 UTC", description: "Filter object and array fields with only_fields", pr_number:                                                 7468, scopes: ["codecs"], type:                            "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:      1, insertions_count:   16, deletions_count:   4},
		{sha: "9d2f10ab5244de9f32ac411ab1f16c6704c5d0f4", date: "2021-05-21 03:26:58 UTC", description: "Allow for global imagePullSecrets", pr_number:                                                               7500, scopes: ["helm platform"], type:                     "enhancement", breaking_change: false, author: "Spencer Gilbert", files_count:    13, insertions_count:  46, deletions_count:   16},
		{sha: "b819edbcaad868c8fae410768d17ff0c72fc7701", date: "2021-05-21 06:33:10 UTC", description: "Switch to upstream Registry impl for metrics", pr_number:                                                    7495, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "Toby Lawrence", files_count:      8, insertions_count:   65, deletions_count:   143},
		{sha: "1e54aca6970a3f141749bd56d8cd8c98ba6e3fab", date: "2021-05-21 03:38:09 UTC", description: "Avoid high memory usage from disk buffers at start-up due to scanning the entire buffer", pr_number:         7522, scopes: ["performance"], type:                       "fix", breaking_change:         false, author: "Brian L. Troutwine", files_count: 2, insertions_count:   14, deletions_count:   3},
		{sha: "05178483e3453418a929db28d51f5e902546bc41", date: "2021-05-21 23:13:19 UTC", description: "bump rustyline from 8.1.0 to 8.2.0", pr_number:                                                              7537, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   12, deletions_count:   7},
		{sha: "2b39438de923b725c89267e54ebce56a1bfaa031", date: "2021-05-22 00:14:01 UTC", description: "Pre-install cross in `make environment` image", pr_number:                                                   7456, scopes: ["dev"], type:                               "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   2, deletions_count:    1},
		{sha: "ab697bae210151ac3eb0be1de3e435f34dec6407", date: "2021-05-22 06:00:05 UTC", description: "Kubernetes stream errors should be recoverable", pr_number:                                                  7484, scopes: ["kubernetes_logs source"], type:            "fix", breaking_change:         false, author: "Stephen Wakely", files_count:     4, insertions_count:   37, deletions_count:   33},
		{sha: "1b0ac0e0ec161aaeb280a6480d3c8e41aa3d7773", date: "2021-05-22 06:17:00 UTC", description: "RFC for k8s aggregator load balancing", pr_number:                                                           7492, scopes: [], type:                                    "chore", breaking_change:       false, author: "Spencer Gilbert", files_count:    1, insertions_count:   111, deletions_count:  0},
		{sha: "40aebada20b004c396910ea96e8d729be596288b", date: "2021-05-23 15:32:18 UTC", description: "Add gRPC-based implementation", pr_number:                                                                   7197, scopes: ["vector sink", "vector source"], type:      "feat", breaking_change:        false, author: "Jean Mertz", files_count:         18, insertions_count:  837, deletions_count:  49},
		{sha: "ebec1a78b22f6cad7388cea2f19b27bb23b766aa", date: "2021-05-25 00:44:54 UTC", description: "Ignore RUSTSEC-2021-0067 while we try to fix it", pr_number:                                                 7559, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   4, deletions_count:    1},
		{sha: "7cbe9234ab751928e4831834570fd7fbe8827c2a", date: "2021-05-25 00:45:48 UTC", description: "bump thiserror from 1.0.24 to 1.0.25", pr_number:                                                            7554, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   4, deletions_count:    4},
		{sha: "b935662aba58c42c3efd125b0ee0a3c4ddd62743", date: "2021-05-25 00:46:21 UTC", description: "bump cidr-utils from 0.5.3 to 0.5.4", pr_number:                                                             7555, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "da47b3ea85ba150707781710345ce966f93af597", date: "2021-05-25 00:46:51 UTC", description: "bump rust_decimal from 1.13.0 to 1.14.0", pr_number:                                                         7556, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   2, deletions_count:    2},
		{sha: "9b9f1a67495e311995ac1b97b2265bc683872626", date: "2021-05-25 02:59:46 UTC", description: "bump async-stream from 0.3.1 to 0.3.2", pr_number:                                                           7560, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   6, deletions_count:    6},
		{sha: "01816b6302732af91c92fb0551f69b596450d958", date: "2021-05-25 03:00:41 UTC", description: "bump tonic from 0.4.2 to 0.4.3", pr_number:                                                                  7562, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   2, deletions_count:    2},
		{sha: "189b542c0ca1cf7f9e66b3c4185544897bfda4b7", date: "2021-05-25 09:16:51 UTC", description: "Try building release artifacts on self-hosted runners", pr_number:                                           7564, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      3, insertions_count:   51, deletions_count:   24},
		{sha: "79d558e7edf1df78d1898f6bc092f504b9186ad7", date: "2021-05-25 09:17:38 UTC", description: "fix bench-wasm target", pr_number:                                                                           7574, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Toby Lawrence", files_count:      1, insertions_count:   2, deletions_count:    2},
		{sha: "c2a225c13843eb7091a8ab38ea2a38f900b6f843", date: "2021-05-25 23:15:01 UTC", description: "bump metrics-util from 0.9.0 to 0.9.1", pr_number:                                                           7579, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   4, deletions_count:    4},
		{sha: "60eb2d7e37b6b9ba067e6a79492e0122b1b6ed47", date: "2021-05-25 23:21:13 UTC", description: "parallelize benchmarks", pr_number:                                                                          7573, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Toby Lawrence", files_count:      2, insertions_count:   27, deletions_count:   24},
		{sha: "76651b653249db2e95a251dc6959308817c7c154", date: "2021-05-26 00:28:27 UTC", description: "Replace incorrect invocation error with WatchStreamFailed", pr_number:                                       7534, scopes: ["kubernetes_logs source"], type:            "fix", breaking_change:         false, author: "Spencer Gilbert", files_count:    4, insertions_count:   81, deletions_count:   15},
		{sha: "ffedd55cafade69bfbbb69a5ed423026485da438", date: "2021-05-26 07:26:09 UTC", description: "Use per-API key partitions for datadog logs sink", pr_number:                                                7394, scopes: ["datadog_logs sink"], type:                 "enhancement", breaking_change: false, author: "Pierre Rognant", files_count:     5, insertions_count:   282, deletions_count:  56},
		{sha: "8780432367e7142b778acc73f16423fd23e15d2d", date: "2021-05-26 02:22:44 UTC", description: "Fix relevant_when for socket.path config", pr_number:                                                        7587, scopes: ["external docs"], type:                     "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:      1, insertions_count:   1, deletions_count:    1},
		{sha: "0343cc228a0387901e14c9a53759bdf11ee89496", date: "2021-05-26 02:52:43 UTC", description: "Upgrade cue to 0.4.0", pr_number:                                                                            7590, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "Ben Johnson", files_count:        2, insertions_count:   6, deletions_count:    6},
		{sha: "7b815b2b0283174181029c56bb44e3f19a7a137d", date: "2021-05-26 06:02:29 UTC", description: "Try running Linux unit tests with less parallel jobs", pr_number:                                            7584, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   2, deletions_count:    0},
		{sha: "5c5559ebba4c89846345cbd5a7bf6856f0e53117", date: "2021-05-26 05:23:32 UTC", description: "Reorganize event proto module", pr_number:                                                                   7593, scopes: ["dev"], type:                               "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      2, insertions_count:   287, deletions_count:  253},
		{sha: "2e3ed8f3368be13742f40d8feac2ee9097fbcb76", date: "2021-05-26 10:31:25 UTC", description: "Allow for opting out of acknowledgements", pr_number:                                                        7531, scopes: ["sources"], type:                           "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      18, insertions_count:  245, deletions_count:  116},
		{sha: "0548f4f3e9dbbade471ae497c4e0e506549a487c", date: "2021-05-26 21:51:58 UTC", description: "bump libc from 0.2.94 to 0.2.95", pr_number:                                                                 7595, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "c52c9dd9bebbf8c4d0331a4d592c46dda59e362f", date: "2021-05-26 21:55:02 UTC", description: "bump ordered-float from 2.2.0 to 2.5.0", pr_number:                                                          7596, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   3, deletions_count:    2},
		{sha: "d4e60834f529c8126941bec1bab76176fbe3b543", date: "2021-05-26 22:51:58 UTC", description: "bump hyper from 0.14.7 to 0.14.8", pr_number:                                                                7597, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   5, deletions_count:    5},
		{sha: "3ede61bd2719f0bc6d474f12fe7dc91b4733c502", date: "2021-05-26 23:52:28 UTC", description: "Optimistically add ubuntu to docker group", pr_number:                                                       7583, scopes: ["dev"], type:                               "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:      1, insertions_count:   2, deletions_count:    1},
		{sha: "b3a27d4b60f431fc7ce86937c99c83a9fac2eb09", date: "2021-05-27 00:07:03 UTC", description: "Drop events where `field` is null", pr_number:                                                               7487, scopes: ["log_to_metric transform"], type:           "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:      2, insertions_count:   89, deletions_count:   32},
		{sha: "9afb7d823cde07cb8d45ca126b262a9e7ffc78f5", date: "2021-05-27 04:02:09 UTC", description: "include error details in `vector vrl` output", pr_number:                                                    7581, scopes: ["cli"], type:                               "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:      2, insertions_count:   8, deletions_count:    9},
		{sha: "47c1e22e013bf45e74070a7bc59984946e4af1e5", date: "2021-05-28 05:27:27 UTC", description: "Improve disk buffer compaction performance", pr_number:                                                      7264, scopes: ["buffers"], type:                           "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count: 3, insertions_count:   79, deletions_count:   7},
		{sha: "ffe592a33b1696a8170824e90b56432512dc37e7", date: "2021-05-28 00:06:12 UTC", description: "Add `redact` function to VRL", pr_number:                                                                    7250, scopes: ["remap"], type:                             "feat", breaking_change:        false, author: "Jesse Szwedko", files_count:      17, insertions_count:  516, deletions_count:  201},
		{sha: "62b27680599a82e4d4299e52232e1f3084f0e622", date: "2021-05-28 00:17:17 UTC", description: "bump rust_decimal from 1.14.0 to 1.14.1", pr_number:                                                         7609, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   2, deletions_count:    2},
		{sha: "c0291a73d5f6f02561cc4feea115df45cbea1aac", date: "2021-05-28 00:37:34 UTC", description: "bump semver from 0.11.0 to 1.0.0", pr_number:                                                                7610, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   11, deletions_count:   2},
		{sha: "080005a4d4a3cd833c23ea8bf82b21ec0a9b6e4a", date: "2021-05-28 00:38:00 UTC", description: "bump docker/setup-qemu-action from 1.1.0 to 1.2.0", pr_number:                                               7611, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   3, deletions_count:    3},
		{sha: "7c16aa0057e41aa2ddba64489109e5c396d77549", date: "2021-05-28 00:38:26 UTC", description: "bump docker/build-push-action from 2.4.0 to 2.5.0", pr_number:                                               7612, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   1, deletions_count:    1},
		{sha: "a07b55cc1e10dd294c023a2c91b17ec29959c345", date: "2021-05-28 03:42:27 UTC", description: "remove 'built' dep and stop needlessly rebuilding on unrelated changes", pr_number:                          7602, scopes: ["dev"], type:                               "chore", breaking_change:       false, author: "Toby Lawrence", files_count:      8, insertions_count:   203, deletions_count:  65},
		{sha: "cb1fe3677cc065708bd6d9f45c018e4fba0b7a70", date: "2021-05-28 03:49:50 UTC", description: "bump actions/cache from 2.1.5 to 2.1.6", pr_number:                                                          7619, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    6, insertions_count:   25, deletions_count:   25},
		{sha: "16256f3fd7ea78e6521a8b9bd7a31d993309abad", date: "2021-05-28 04:59:41 UTC", description: "allow VECTOR_BUILD_DESC to be passed thru during packaging", pr_number:                                      7620, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "Toby Lawrence", files_count:      1, insertions_count:   1, deletions_count:    0},
		{sha: "7dec4bf51f5ba1221519c72441e3eb809cbb9286", date: "2021-05-28 04:49:58 UTC", description: "Add changes to `Cargo.lock`", pr_number:                                                                     7621, scopes: ["dev"], type:                               "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      1, insertions_count:   1, deletions_count:    20},
		{sha: "19fb08ab995991cdbc666a287cbee67a144fbbc9", date: "2021-05-28 04:23:07 UTC", description: "Move benchmarks into 'buffers' sub-crate", pr_number:                                                        7576, scopes: ["buffers"], type:                           "chore", breaking_change:       false, author: "Brian L. Troutwine", files_count: 22, insertions_count:  1123, deletions_count: 446},
		{sha: "56296e2d49137f5f28094470b2d967c8b847f525", date: "2021-05-29 00:54:04 UTC", description: "Add match_any function", pr_number:                                                                          7414, scopes: ["remap"], type:                             "enhancement", breaking_change: false, author: "Luke Steensen", files_count:      5, insertions_count:   174, deletions_count:  0},
		{sha: "65671bead5251d8c7be65427a01299ce3e3e4ac8", date: "2021-05-29 00:25:32 UTC", description: "Add acknowledgement support", pr_number:                                                                     7625, scopes: ["vector sink"], type:                       "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      6, insertions_count:   139, deletions_count:  31},
		{sha: "644ce1626ffcf2aa250ffe71b520dd475efeeaf1", date: "2021-05-29 08:35:01 UTC", description: "Avoid compacting small disk buffers", pr_number:                                                             7614, scopes: ["buffers"], type:                           "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count: 1, insertions_count:   11, deletions_count:   1},
		{sha: "7f1f5d57ee6b1da3f798d334cc6cad02200ae1ff", date: "2021-05-29 15:49:02 UTC", description: "Clarify ElasticSearch bulk actions #7616", pr_number:                                                        7617, scopes: [], type:                                    "docs", breaking_change:        false, author: "Shogo", files_count:              3, insertions_count:   6, deletions_count:    8},
		{sha: "cb8084b7196fe4c2d5f5dd17ea50f9416bb7e3b5", date: "2021-05-29 00:58:14 UTC", description: "Add acknowledgement support to v2 protocol", pr_number:                                                      7618, scopes: ["vector source"], type:                     "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      6, insertions_count:   58, deletions_count:   23},
		{sha: "d5c58c054aa4728663d9c889c39ee463a4824cd1", date: "2021-05-29 03:06:26 UTC", description: "Remove deprecation warnings for log_schema", pr_number:                                                      7603, scopes: [], type:                                    "docs", breaking_change:        false, author: "Jesse Szwedko", files_count:      1, insertions_count:   0, deletions_count:    4},
		{sha: "d9a47bfde4436828988e2ee3433147e8b36a0054", date: "2021-05-29 01:48:16 UTC", description: "Add acknowledgements support", pr_number:                                                                    7536, scopes: ["aws_s3 sink"], type:                       "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      1, insertions_count:   54, deletions_count:   14},
		{sha: "2446599bfc66eb7743bd9ad6fd22fa0806d7ed96", date: "2021-05-29 02:51:58 UTC", description: "Wrap and report batch status receive errors", pr_number:                                                     7635, scopes: [], type:                                    "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      3, insertions_count:   39, deletions_count:   8},
		{sha: "caa4fcc94bc2fcfc738ca484e462958727ac7c46", date: "2021-05-29 03:45:00 UTC", description: "Add acknowledgements support", pr_number:                                                                    7535, scopes: ["datadog_metrics sink"], type:              "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:      1, insertions_count:   15, deletions_count:   6},
		{sha: "498de2e79cdeab344830d92fcd48d37e1ae96368", date: "2021-05-29 07:22:51 UTC", description: "Fix healthcheck to allow for log group creation at runtime", pr_number:                                      7601, scopes: ["aws_cloudwatch_logs sink"], type:          "fix", breaking_change:         false, author: "Spencer Gilbert", files_count:    1, insertions_count:   11, deletions_count:   6},
		{sha: "9b4b77cb41355a89985a4b050ae4a557e53fd655", date: "2021-05-31 00:16:21 UTC", description: "Improve disk buffer performance by batching deletes", pr_number:                                             7615, scopes: ["buffers"], type:                           "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count: 2, insertions_count:   58, deletions_count:   34},
		{sha: "1e18f6926f59f6ef4e4261126ac89d0f3bd94ed7", date: "2021-06-01 08:18:26 UTC", description: "Add e2e k8s test for logs ingestion from Datadog agent to Vector", pr_number:                                7628, scopes: ["tests"], type:                             "chore", breaking_change:       false, author: "Pierre Rognant", files_count:     7, insertions_count:   308, deletions_count:  4},
		{sha: "fab4d3ce108fdab8a665b911516c38b07a29e7d2", date: "2021-06-02 01:47:51 UTC", description: "Document `disk` buffer behavior", pr_number:                                                                 7679, scopes: [], type:                                    "docs", breaking_change:        false, author: "Kruno Tomola Fabro", files_count: 1, insertions_count:   7, deletions_count:    1},
		{sha: "e96a409db2042462fab749e00674598ebf011035", date: "2021-06-02 06:15:34 UTC", description: "Accept quoted lists in `parse_aws_alb_log` function", pr_number:                                             7682, scopes: ["remap"], type:                             "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count: 1, insertions_count:   140, deletions_count:  16},
		{sha: "6764abab598c270bd3e7169db99152754b68a6a3", date: "2021-06-02 08:04:20 UTC", description: "additional labels for Prometheus Operator", pr_number:                                                       7474, scopes: ["helm platform"], type:                     "enhancement", breaking_change: false, author: "Nicolas Lamirault", files_count:  3, insertions_count:   7, deletions_count:    0},
		{sha: "3e715e0f61f08fcf19cbedf6530ab6ca63d4c39a", date: "2021-06-02 01:41:27 UTC", description: "bump tower from 0.4.7 to 0.4.8", pr_number:                                                                  7683, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   3, deletions_count:    3},
		{sha: "55a7b76eaa949b352e9d542cea461ac4ad48071a", date: "2021-06-02 01:42:35 UTC", description: "bump lannonbr/repo-permission-check-action", pr_number:                                                      7686, scopes: ["ci"], type:                                "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    1, insertions_count:   1, deletions_count:    1},
		{sha: "112b81f6741269ceda9185956a0a3afb05866062", date: "2021-06-02 07:09:29 UTC", description: "bump nix from 0.20.0 to 0.21.0", pr_number:                                                                  7696, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   15, deletions_count:   2},
		{sha: "a392e745a3314c1ad7b23888857b39d9897ae899", date: "2021-06-02 22:46:47 UTC", description: "bump async-nats from 0.9.17 to 0.9.18", pr_number:                                                           7702, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   5, deletions_count:    5},
		{sha: "1f5a18290c7be811c96712a5c11df30de2fa9371", date: "2021-06-02 22:49:29 UTC", description: "Add record compression support to aws_kinesis_firehose source", pr_number:                                   7700, scopes: ["aws_kinesis_firehose source"], type:       "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:      10, insertions_count:  305, deletions_count:  72},
		{sha: "727e2eeaf15972af3ee748c309e14552e72eea89", date: "2021-06-02 23:01:01 UTC", description: "bump semver from 1.0.0 to 1.0.1", pr_number:                                                                 7684, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    2, insertions_count:   4, deletions_count:    4},
		{sha: "85b3d5278abe76e1b092d9920784036de449964b", date: "2021-06-02 23:01:51 UTC", description: "bump crc from 1.8.1 to 2.0.0", pr_number:                                                                    7627, scopes: ["deps"], type:                              "chore", breaking_change:       false, author: "dependabot[bot]", files_count:    3, insertions_count:   24, deletions_count:   6},
		{sha: "0cf8941d83eac7588881aa87ee038e32754a6c12", date: "2021-06-03 03:58:50 UTC", description: "Add deprecation notice for rawConfig", pr_number:                                                            7671, scopes: ["helm platform"], type:                     "chore", breaking_change:       false, author: "Spencer Gilbert", files_count:    4, insertions_count:   66, deletions_count:   0},
		{sha: "bf8abcbfe3bb11d167213f83bbef628d82e43407", date: "2021-06-03 03:49:29 UTC", description: "Fix commit listing when generating release notes", pr_number:                                                7721, scopes: ["releasing"], type:                         "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   1, deletions_count:    1},
		{sha: "2d9224613926830cff7157e1d813b6618d012255", date: "2021-06-03 04:14:54 UTC", description: "Remove filters from changelog generation", pr_number:                                                        7722, scopes: ["releasing"], type:                         "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:      1, insertions_count:   1, deletions_count:    6},
		{sha: "6381332da484337faf6f0435bff771ad9c829b43", date: "2021-06-03 04:18:36 UTC", description: "Rename to `route`", pr_number:                                                                               6193, scopes: ["swimlanes transform"], type:               "chore", breaking_change:       false, author: "GitHub", files_count:             1, insertions_count:   1, deletions_count:    0},
		{sha: "6ae6ac994be3cb3bcbae7c4a96d15c7b92f24017", date: "2021-06-03 05:33:18 UTC", description: "Default end-to-end acknowledgements to off", pr_number:                                                      7720, scopes: ["config"], type:                            "chore", breaking_change:       false, author: "Bruce Guenter", files_count:      2, insertions_count:   2, deletions_count:    2},
	]
}
