package metadata

releases: "0.11.0": {
	date:     "2020-12-01"
	codename: "Kubernetes Pipes"
	description: """
		The Vector team is pleased to announce 0.11.0. This release
		is focused on Kubernetes. In addition to the new,
		first-class Kubernetes integration, we launched a number of
		complementary features that make Vector a prime candidate
		for collecting and processing your Kubernetes logs. Check
		out the [highlights](#highlights) and [changelog](#changelog)
		for more details.
		"""

	whats_next: [
		{
			title: "Vector's own observability"
			description: """
				We will be working to improve Vector's own observability with high-quality internal metrics, logs,
				CLI tools, and dashboards. This will likely be the focus of 0.13.
				"""
		},
		{
			title:       "Kubernetes aggregator role"
			description: """
				In addition to Vector's observability, 0.12 will include support for
				deploying Vector into the [aggregator role](\(urls.vector_aggregator_role))
				within Kubernetes. This will allow you to build end-to-end observability
				piplines in Kubernetes with Vector. Distributing processing on the edge,
				centralizing it with an aggregator, or both. If you are interested in
				beta testing, please [join our chat](\(urls.vector_chat)) and let us
				know.
				"""
		},
		{
			title:       "Vector Remap Language (VRL)"
			description: """
				Finally, 0.12 will introduce the new Vector Remap Language.	This is a
				Rust-native syntax designed for safe and efficient data mapping. It's an
				ultra-performant middle ground between fundamental transforms like
				`add_fields` and a full blown runtime like `lua`.

				If interested, you can beta test via the [`remap` transform](\(urls.vector_remap_transform))
				and use the [Vector Remap Language reference](\(urls.vrl_reference))
				to write scripts.
				"""
		},
	]

	commits: [
		{sha: "5308b865614987b50bbeecf2167d37ddfc326f55", date: "2020-07-22 11:15:07 -0400", description: "Initial `kubernetes_logs` implementation", pr_number:                                            2653, scopes: ["new source"], type:                                       "feat", breaking_change:        false, author: "MOZGIII", files_count:               60, insertions_count:  6078, deletions_count: 25},
		{sha: "ca69b000e00b5c3e668b3998a62bc7ecfbc1f51a", date: "2020-07-22 18:08:53 -0400", description: "Allow '=' in tag values", pr_number:                                                             3090, scopes: ["prometheus source"], type:                                "fix", breaking_change:         false, author: "Adam Casey", files_count:            1, insertions_count:   84, deletions_count:   18},
		{sha: "94f6db43db5f25b6c1fb005c8a5bd3a2a211a06b", date: "2020-07-26 17:03:42 -0400", description: "Cleanup `list` command", pr_number:                                                              3099, scopes: ["cli"], type:                                              "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    4, insertions_count:   43, deletions_count:   2},
		{sha: "622dbf78f3335ca275251f74c64c7a16a93ec9c2", date: "2020-07-28 09:18:12 -0400", description: "Upgrade all VecBuffer sinks to allow setting `max_bytes`", pr_number:                            3190, scopes: ["buffers", "sinks"], type:                                 "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         17, insertions_count:  529, deletions_count:  231},
		{sha: "6a6c390b7e7af2b977ff088245e94e31cefb7640", date: "2020-07-28 12:04:38 -0400", description: "Correctly assign capture group fields", pr_number:                                               3164, scopes: ["regex_parser transform"], type:                           "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:         3, insertions_count:   124, deletions_count:  69},
		{sha: "24da4475d798460df64d4c2728f9cde823b4d73b", date: "2020-07-28 21:02:57 -0400", description: "Add max_length to UDP", pr_number:                                                               3236, scopes: ["socket source"], type:                                    "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:       5, insertions_count:   26, deletions_count:   16},
		{sha: "7d0dbc9ba5497bae2a217f6bbd3a7fba744a832d", date: "2020-07-28 23:50:24 -0400", description: "Instrument \"stdin\" source", pr_number:                                                         3151, scopes: ["observability", "stdin source"], type:                    "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            3, insertions_count:   56, deletions_count:   3},
		{sha: "9745e9a3560570ba17afd5148e37e329affec9a2", date: "2020-07-28 16:14:56 -0400", description: "Add received and invalid line events", pr_number:                                                3241, scopes: ["observability", "journald source"], type:                 "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         3, insertions_count:   57, deletions_count:   1},
		{sha: "9aed5e08ede334dee921df7bd5aaa6ef2ecfd3c1", date: "2020-07-30 15:04:01 -0400", description: "Provide error context on parse error", pr_number:                                                3278, scopes: ["prometheus source"], type:                                "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         2, insertions_count:   11, deletions_count:   1},
		{sha: "0d497ec9f350f723172efab2ab2462c46de70c4b", date: "2020-07-31 21:44:10 -0400", description: "Correct an error with line aggregation in `continue_through` and `halt_before`", pr_number:      3262, scopes: ["file source"], type:                                      "fix", breaking_change:         false, author: "MOZGIII", files_count:               1, insertions_count:   140, deletions_count:  10},
		{sha: "9117c9dfbf44100d60b6c9c5fd824835650918ec", date: "2020-07-31 22:46:53 -0400", description: "Instrument \"kafka\" source", pr_number:                                                         3187, scopes: ["observability", "kafka source"], type:                    "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            3, insertions_count:   95, deletions_count:   17},
		{sha: "814102df3c8a98affbe15a7673a63d6668cc4170", date: "2020-08-03 14:05:38 -0400", description: "Make sourcetype explicit on Splunk sink", pr_number:                                             3297, scopes: ["splunk_hec sink"], type:                                  "fix", breaking_change:         true, author:  "Jesse Szwedko", files_count:         3, insertions_count:   17, deletions_count:   12},
		{sha: "dc3848d176f500588a7c0446aee731e0a6743f4c", date: "2020-08-03 14:07:34 -0400", description: "Allow configuration of type field", pr_number:                                                   3300, scopes: ["humio_logs sink"], type:                                  "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:         2, insertions_count:   70, deletions_count:   1},
		{sha: "67adfd6da35cd341b59200c8cf5d506ea6ab3835", date: "2020-08-04 11:07:48 -0400", description: "Update instrumentation", pr_number:                                                              3317, scopes: ["observability", "prometheus source"], type:               "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    2, insertions_count:   60, deletions_count:   9},
		{sha: "70b0b13d297fc34d446497729803ad885960e122", date: "2020-08-04 11:09:04 -0400", description: "Update instrumentation", pr_number:                                                              3315, scopes: ["observability", "syslog source"], type:                   "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    2, insertions_count:   36, deletions_count:   21},
		{sha: "059e160cb599ee007affa7f19223a10a40af222f", date: "2020-08-04 21:36:27 -0400", description: "Add internal events for `http` source", pr_number:                                               3264, scopes: ["observability", "http source"], type:                     "enhancement", breaking_change: false, author: "Do Duy", files_count:                3, insertions_count:   72, deletions_count:   3},
		{sha: "3c06a27444cccd530c4a1c5ed09f5c7054045d94", date: "2020-08-04 17:21:01 -0400", description: "Make sourcetype templatable", pr_number:                                                         3351, scopes: ["splunk_hec sink"], type:                                  "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:         3, insertions_count:   39, deletions_count:   4},
		{sha: "851d00114281791f29cc1c68f1b44aa201bb0ca4", date: "2020-08-05 09:47:23 -0400", description: "Add events", pr_number:                                                                          3254, scopes: ["observability", "statsd source"], type:                   "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:       3, insertions_count:   121, deletions_count:  8},
		{sha: "e7d3015bf548aa76a8b174576ded9b4932aace53", date: "2020-08-05 09:19:15 -0400", description: "Add instrumentation", pr_number:                                                                 3345, scopes: ["observability", "docker source"], type:                   "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    3, insertions_count:   311, deletions_count:  77},
		{sha: "1101f26457df26e4d12ede3c93a6d331ac82dd13", date: "2020-08-05 09:21:42 -0400", description: "Add instrumentation", pr_number:                                                                 3312, scopes: ["observability", "splunk_hec source"], type:               "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    3, insertions_count:   125, deletions_count:  13},
		{sha: "547c8ad6ac6ad4fa21dbf3a70f6b18570704bed6", date: "2020-08-05 15:24:05 -0400", description: "Add DataDog's `distribution` metric", pr_number:                                                 2913, scopes: ["data_dog_metrics sink"], type:                            "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    19, insertions_count:  204, deletions_count:  26},
		{sha: "bd26d0d7bc04652548dc45ee2f60b311027050ce", date: "2020-08-05 13:26:28 -0400", description: "Add configuration for source", pr_number:                                                        3327, scopes: ["splunk_hec sink"], type:                                  "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:         3, insertions_count:   74, deletions_count:   2},
		{sha: "7987c59ba587022bd5c9960618be4bd58636fb52", date: "2020-08-05 14:41:24 -0400", description: "Allow configuration of type field (#3300)", pr_number:                                           3337, scopes: ["humio_logs sink"], type:                                  "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:         2, insertions_count:   73, deletions_count:   1},
		{sha: "6d126e7656215640ce123dbc5ae6b00cd0a27ef3", date: "2020-08-05 16:11:33 -0400", description: "Add source configuration to Humio sink", pr_number:                                              3328, scopes: ["humio_logs sink"], type:                                  "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:         2, insertions_count:   44, deletions_count:   0},
		{sha: "6bac9f1c6bc74f2b775f5a18ea25b3796f58a555", date: "2020-08-09 18:14:42 -0400", description: "Add instrumentation", pr_number:                                                                 3356, scopes: ["observability", "logplex source"], type:                  "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    3, insertions_count:   64, deletions_count:   6},
		{sha: "0f1556702aa2d7b6901eb1d59164a858c7f79630", date: "2020-08-11 14:20:44 -0400", description: "Automatic concurrency management", pr_number:                                                    3094, scopes: ["sinks", "networking"], type:                              "feat", breaking_change:        false, author: "Bruce Guenter", files_count:         44, insertions_count:  2136, deletions_count: 176},
		{sha: "8d1995d0d6243624a540b8dfc824e51ae5d77044", date: "2020-08-12 15:18:24 -0400", description: "Remove forwarding to syslog from distributed systemd unit", pr_number:                           3427, scopes: ["debian platform"], type:                                  "fix", breaking_change:         true, author:  "Jesse Szwedko", files_count:         1, insertions_count:   0, deletions_count:    3},
		{sha: "3d434d190c5f6d454141f18922b59b1a5c6072c7", date: "2020-08-13 13:15:41 -0400", description: "Add more instrumentation", pr_number:                                                            3417, scopes: ["observability", "file source"], type:                     "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    10, insertions_count:  341, deletions_count:  41},
		{sha: "86ccdeabd20edc66ac5a19f04a618cfcedc180e1", date: "2020-08-13 14:57:54 -0400", description: "Add instrumentation", pr_number:                                                                 3421, scopes: ["observability", "ansi_stripper transform"], type:         "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    3, insertions_count:   101, deletions_count:  19},
		{sha: "b4048d9131fc764c6457463b5a9c1768c4b0ae24", date: "2020-08-13 14:58:13 -0400", description: "Add instrumentation", pr_number:                                                                 3419, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    3, insertions_count:   32, deletions_count:   0},
		{sha: "bb601f5fae5ad5a7cd05adafd2d6dc84f0b3e868", date: "2020-08-13 16:56:50 -0400", description: "Add instrumentation", pr_number:                                                                 3418, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    3, insertions_count:   70, deletions_count:   9},
		{sha: "3ffc3c30b42a482ce1e1dd4bb68faeac7b4d4b76", date: "2020-08-13 14:48:29 -0400", description: "Add additional canned ACLs", pr_number:                                                          3439, scopes: ["aws_s3 sink"], type:                                      "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:         1, insertions_count:   2, deletions_count:    0},
		{sha: "e4e597067bf001d96cf51a9259714debeeb7ca86", date: "2020-08-14 08:56:33 -0400", description: "Add \"text\" encoding for metrics", pr_number:                                                   3434, scopes: ["codecs", "console sink"], type:                           "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         2, insertions_count:   257, deletions_count:  10},
		{sha: "40d7dd936a4155409282b5f9e2a43b2989e739ae", date: "2020-08-15 16:59:21 -0400", description: "Even more instrumentation", pr_number:                                                           3436, scopes: ["observability", "file source"], type:                     "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    3, insertions_count:   35, deletions_count:   9},
		{sha: "a9f746c6f8b0666b5c3573e9e67c47632b00b149", date: "2020-08-19 11:21:36 -0400", description: "Rewrite parser, improve error handlings ", pr_number:                                            3286, scopes: ["prometheus source"], type:                                "enhancement", breaking_change: false, author: "Do Duy", files_count:                8, insertions_count:   1418, deletions_count: 478},
		{sha: "5f6ce7cfa5fea6e8a3078e63d2e04425b8c38c64", date: "2020-08-19 22:25:56 -0400", description: "Add events for starting, stopping, and reloading", pr_number:                                    3476, scopes: ["observability", "startup", "shutdown"], type:             "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    4, insertions_count:   86, deletions_count:   29},
		{sha: "db2e647ce4a08e2602606e036507f46614a2ec2c", date: "2020-08-20 14:39:42 -0400", description: "Add Heartbeat", pr_number:                                                                       3502, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    5, insertions_count:   36, deletions_count:   1},
		{sha: "61e806d01d4cc6d2a527b52aa9388d4547f1ebc2", date: "2020-08-21 20:42:14 -0400", description: "Allow configuring flags via env vars", pr_number:                                                2149, scopes: ["cli"], type:                                              "feat", breaking_change:        false, author: "MOZGIII", files_count:               2, insertions_count:   44, deletions_count:   6},
		{sha: "da07131539763df44b638780b7bde23764b0cd92", date: "2020-08-24 00:08:50 -0400", description: "Add support for gzip compression", pr_number:                                                    3373, scopes: ["file sink", "compression"], type:                         "enhancement", breaking_change: false, author: "Ayush Goyal", files_count:           6, insertions_count:   137, deletions_count:  6},
		{sha: "c6847c68da9ff175f2a62b285b63d119bf07331b", date: "2020-08-24 18:53:52 -0400", description: "Handle Absolute kind for values other than Gauge.", pr_number:                                   3510, scopes: ["statsd sink"], type:                                      "fix", breaking_change:         false, author: "FungusHumungus", files_count:        1, insertions_count:   88, deletions_count:   54},
		{sha: "b41b63ac723d2b0de3a52defa27cac10386f667c", date: "2020-08-25 06:29:39 -0400", description: "ASN/ISP database support", pr_number:                                                            3265, scopes: ["geoip transform"], type:                                  "feat", breaking_change:        false, author: "Marko Karppinen", files_count:       6, insertions_count:   243, deletions_count:  90},
		{sha: "a67d18cac8aad548887933ce9793708c61c23cc4", date: "2020-08-25 14:43:00 -0400", description: "Sync all data before finishing", pr_number:                                                      3475, scopes: ["file sink"], type:                                        "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    2, insertions_count:   24, deletions_count:   10},
		{sha: "cc284b4f35f1b482b9056a914222edf58bc5acc9", date: "2020-08-25 08:43:30 -0400", description: "Enhance instrumentation", pr_number:                                                             3521, scopes: ["observability", "json_parser transform"], type:           "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         4, insertions_count:   76, deletions_count:   47},
		{sha: "c6e660801a8bf091202bd511656434a5229d8767", date: "2020-08-25 08:51:16 -0400", description: "Add and unify events", pr_number:                                                                3486, scopes: ["observability", "socket source"], type:                   "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         8, insertions_count:   94, deletions_count:   113},
		{sha: "d11587489476c85f44fc9996e900535737a43922", date: "2020-08-25 12:01:48 -0400", description: "Enhance instrumentation", pr_number:                                                             3523, scopes: ["observability", "regex_parser transform"], type:          "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         4, insertions_count:   151, deletions_count:  102},
		{sha: "8b4ff32e23a16e44b0c88848c82e34b724730828", date: "2020-08-25 14:22:27 -0400", description: "Add internal events", pr_number:                                                                 3553, scopes: ["observability", "grok_parser transform"], type:           "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         4, insertions_count:   127, deletions_count:  39},
		{sha: "692e683646fb843633e158fe7cb25e5085dafff0", date: "2020-08-27 21:00:31 -0400", description: "Add the ability to store pod labels flat", pr_number:                                            3598, scopes: ["kubernetes_logs source"], type:                           "enhancement", breaking_change: false, author: "MOZGIII", files_count:               1, insertions_count:   97, deletions_count:   2},
		{sha: "1e180bff8f1635b7d24cd9f4838af63255ec5137", date: "2020-08-28 11:44:00 -0400", description: "Store pod labels flat by default, remove the switch", pr_number:                                 3602, scopes: ["kubernetes_logs source"], type:                           "enhancement", breaking_change: false, author: "MOZGIII", files_count:               1, insertions_count:   2, deletions_count:    59},
		{sha: "2e840a04a9dcd41637adb7b4dd50f5ed948a1e2a", date: "2020-08-28 13:20:18 -0400", description: "Add `file` label", pr_number:                                                                    3586, scopes: ["file source"], type:                                      "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    1, insertions_count:   10, deletions_count:   0},
		{sha: "f2301e2e583b227718b258e08eb580fe4989a586", date: "2020-08-28 13:36:40 -0400", description: "Add more `main` events", pr_number:                                                              3582, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    2, insertions_count:   79, deletions_count:   6},
		{sha: "680ab9bc3042ab281c76e11ae0251aeda1f97b6b", date: "2020-08-28 10:43:41 -0400", description: "Switch off of broadcast channel", pr_number:                                                     3611, scopes: ["file source"], type:                                      "fix", breaking_change:         false, author: "Luke Steensen", files_count:         1, insertions_count:   16, deletions_count:   90},
		{sha: "b96a04554c971e4a92c872527dc1765140e83d58", date: "2020-08-28 10:11:07 -0400", description: "Add internal events", pr_number:                                                                 3593, scopes: ["observability", "log_to_metric transform"], type:         "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         3, insertions_count:   100, deletions_count:  8},
		{sha: "4237b6fff0a333bdeb1623b21482168e827268b8", date: "2020-08-28 10:29:27 -0400", description: "Implement some UX improvements for WASM", pr_number:                                             3490, scopes: ["wasm transform"], type:                                   "enhancement", breaking_change: false, author: "Ana Hobden", files_count:            8, insertions_count:   150, deletions_count:  80},
		{sha: "9570f71c8c2a5c6410d928366e722b12fa1e8912", date: "2020-08-28 15:40:33 -0400", description: "Adds new Helm template variable for podsLabels.", pr_number:                                     3610, scopes: ["kuberentes platform"], type:                              "enhancement", breaking_change: false, author: "nkinkade", files_count:              2, insertions_count:   6, deletions_count:    0},
		{sha: "1a4359363c8e65a034e1e13d7b81dfbcb2342b97", date: "2020-08-31 18:51:32 -0400", description: "Multiline support", pr_number:                                                                   3607, scopes: ["docker source"], type:                                    "enhancement", breaking_change: false, author: "MOZGIII", files_count:               4, insertions_count:   194, deletions_count:  83},
		{sha: "9adebdef5b5a27567803a6b2d2967551935a689c", date: "2020-08-31 13:38:28 -0400", description: "Add internal events", pr_number:                                                                 3577, scopes: ["observability", "tag_cardinality_limit transform"], type: "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         3, insertions_count:   101, deletions_count:  17},
		{sha: "22dc55246ea82e51c85c1340cb7fe618c8ae40da", date: "2020-08-31 13:40:10 -0400", description: "Add internal events", pr_number:                                                                 3554, scopes: ["observability", "coercer transform"], type:               "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         3, insertions_count:   52, deletions_count:   19},
		{sha: "7e2ea2958ba2714b87abcf06ce245b71e48fb838", date: "2020-09-02 11:08:07 -0400", description: "Increase rate_limit_num to its maximum", pr_number:                                              3655, scopes: ["http sink"], type:                                        "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         2, insertions_count:   2, deletions_count:    2},
		{sha: "7eb1ea3f58727d06417c88d65da478dd004f121a", date: "2020-09-03 18:45:42 -0400", description: "Handle panic on HTTP request to HTTPS source", pr_number:                                        3693, scopes: ["http source"], type:                                      "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:       1, insertions_count:   6, deletions_count:    0},
		{sha: "2f373b470353f435572362f59b7f58c4ae337830", date: "2020-09-03 15:44:48 -0400", description: "Handle multiple (intermediate) certificates in PEM files", pr_number:                            3687, scopes: ["security"], type:                                         "fix", breaking_change:         false, author: "Ana Hobden", files_count:            30, insertions_count:  1169, deletions_count: 301},
		{sha: "2024ab6a9ecc5167e587e3dae8a864f03ff16a7d", date: "2020-09-04 09:10:09 -0400", description: "Add a new options to control the auto concurrency limiter", pr_number:                           3690, scopes: ["networking"], type:                                       "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         7, insertions_count:   135, deletions_count:  43},
		{sha: "b374fb6a7e2dfe58ffc18d53912748d287068ad8", date: "2020-09-04 15:22:49 -0400", description: "rate_limit_num for GCP pubsub and cloud_storage was wrong", pr_number:                           3656, scopes: ["gcp platform"], type:                                     "fix", breaking_change:         false, author: "Bruce Guenter", files_count:         2, insertions_count:   8, deletions_count:    1},
		{sha: "25602ee60359956bf1e5e152408ee252f24a3e57", date: "2020-09-04 17:44:22 -0400", description: "allow using excepted fields", pr_number:                                                         3716, scopes: ["elasticsearch sink"], type:                               "fix", breaking_change:         false, author: "Luke Steensen", files_count:         1, insertions_count:   28, deletions_count:   2},
		{sha: "d15ff9e125c672e1c4c4401f9ac040406917d53a", date: "2020-09-05 17:18:27 -0400", description: "Fix TcpEventSent", pr_number:                                                                    3720, scopes: ["observability", "socket sink"], type:                     "enhancement", breaking_change: false, author: "Do Duy", files_count:                1, insertions_count:   6, deletions_count:    4},
		{sha: "b692e3e67af92e4490682429b44235f74eca070d", date: "2020-09-07 19:31:03 -0400", description: "Add internal events", pr_number:                                                                 3730, scopes: ["observability", "swimlanes transform"], type:             "enhancement", breaking_change: false, author: "Do Duy", files_count:                3, insertions_count:   33, deletions_count:   0},
		{sha: "7e351a225ba8dbbeef9f8db35103a42f4ad5d461", date: "2020-09-08 20:33:05 -0400", description: "Apply encoding rules after key prefix", pr_number:                                               3770, scopes: ["gcp_cloud_storage sink"], type:                           "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:       1, insertions_count:   16, deletions_count:   1},
		{sha: "fe68891452955772e9a98fdf2565c6d762295e19", date: "2020-09-09 08:31:59 -0400", description: "Add IPv6 supports", pr_number:                                                                   3699, scopes: ["socket sink"], type:                                      "enhancement", breaking_change: false, author: "Do Duy", files_count:                4, insertions_count:   77, deletions_count:   47},
		{sha: "431bd8686b52eee95c59e4c68ea390395ad7ac48", date: "2020-09-09 15:50:54 -0400", description: "Apply encoding rules right before encoding", pr_number:                                          3775, scopes: ["loki sink"], type:                                        "fix", breaking_change:         false, author: "Hoàng Đức Hiếu", files_count:        1, insertions_count:   29, deletions_count:   1},
		{sha: "eb2426c271c90caa2e0ddec855eccc781f9dd86b", date: "2020-09-09 15:58:04 -0400", description: "Add retry delay", pr_number:                                                                     3732, scopes: ["docker source"], type:                                    "fix", breaking_change:         false, author: "Do Duy", files_count:                2, insertions_count:   37, deletions_count:   15},
		{sha: "7c5aecb9a7741a8816b4f087c920fbe802613862", date: "2020-09-09 15:36:20 -0400", description: "New `remap` transform", pr_number:                                                               3341, scopes: ["new transform"], type:                                    "feat", breaking_change:        false, author: "Ashley Jeffs", files_count:          21, insertions_count:  3164, deletions_count: 3},
		{sha: "6869120e280541add19777882f20e2ddb4ca9c3e", date: "2020-09-09 19:40:28 -0400", description: "Add support for `summary` metric", pr_number:                                                    3726, scopes: ["log_to_metric transform"], type:                          "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    1, insertions_count:   65, deletions_count:   0},
		{sha: "52cd9a777963154bf619975df72e3c52726a4228", date: "2020-09-09 13:23:24 -0400", description: "Enhance checkpoint errors with file name", pr_number:                                            3782, scopes: ["observability", "journald source"], type:                 "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         1, insertions_count:   14, deletions_count:   10},
		{sha: "94def0fb9ec971539984fdcf42dacdcfd0aa3200", date: "2020-09-10 16:17:03 -0400", description: "Add internal events", pr_number:                                                                 3812, scopes: ["observability", "reduce transform"], type:                "enhancement", breaking_change: false, author: "Luke Steensen", files_count:         3, insertions_count:   34, deletions_count:   0},
		{sha: "ff555aaed1208742ffb71be5242b52ed258eaa06", date: "2020-09-11 15:53:27 -0400", description: "add internal events", pr_number:                                                                 3809, scopes: ["observability", "dedupe transform"], type:                "enhancement", breaking_change: false, author: "Luke Steensen", files_count:         3, insertions_count:   43, deletions_count:   5},
		{sha: "f03898e1b6a9d78ce40c48b19675d8e7cb67f8c5", date: "2020-09-11 15:53:51 -0400", description: "add internal events", pr_number:                                                                 3807, scopes: ["observability", "tokenizer transform"], type:             "enhancement", breaking_change: false, author: "Luke Steensen", files_count:         3, insertions_count:   74, deletions_count:   12},
		{sha: "9c83300f005648d3a5292754b7127692b9e72e53", date: "2020-09-14 12:29:16 -0400", description: "apply encoding rules in sinks", pr_number:                                                       3766, scopes: ["sinks"], type:                                            "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:       10, insertions_count:  156, deletions_count:  29},
		{sha: "9df7255da7d7f602e62e0adf1205c417db83d287", date: "2020-09-15 18:50:03 -0400", description: "Support `summary` statistic", pr_number:                                                         3846, scopes: ["influxdb_metrics sink"], type:                            "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    1, insertions_count:   68, deletions_count:   9},
		{sha: "f8696563012d1840e9e6a52206b03634a6bfdb4c", date: "2020-09-15 18:58:20 -0400", description: "Support datadog `distribution` metric ", pr_number:                                              3725, scopes: ["datadog_metrics sink"], type:                             "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    2, insertions_count:   202, deletions_count:  51},
		{sha: "654bad152b4cd0931957c0710d861f215206e4f0", date: "2020-09-15 19:12:22 -0400", description: "Regularize internal event messages", pr_number:                                                  3850, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    29, insertions_count:  110, deletions_count:  73},
		{sha: "8f8084e8c3b6810dd095980c7d2a0c0e308a609f", date: "2020-09-15 20:43:19 -0400", description: "Recreate trigger", pr_number:                                                                    3855, scopes: ["reload"], type:                                           "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:    3, insertions_count:   70, deletions_count:   19},
		{sha: "85f8a6f4e622d26073485f156f904bdfeb49c6b2", date: "2020-09-15 20:49:29 -0400", description: "Enable tls by default  for `papertrail` and `datadog_logs` sinks", pr_number:                    3824, scopes: ["networking", "security"], type:                           "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    9, insertions_count:   38, deletions_count:   19},
		{sha: "823308f9bfdd061c62356bef6c77390f9a17cfce", date: "2020-09-17 09:35:24 -0400", description: "Improve retry error messages", pr_number:                                                        3861, scopes: ["observability", "elasticsearch sink"], type:              "enhancement", breaking_change: false, author: "Do Duy", files_count:                4, insertions_count:   30, deletions_count:   48},
		{sha: "39433cd073fcb349915d64b1b3890ed9def841f9", date: "2020-09-17 13:45:55 -0400", description: "Initial `apache_metrics` source implementation", pr_number:                                      3704, scopes: ["new source"], type:                                       "feat", breaking_change:        false, author: "Jesse Szwedko", files_count:         10, insertions_count:  1581, deletions_count: 0},
		{sha: "3e6dac044cbc3f8950cb91dac7a4f455bdc60189", date: "2020-09-17 21:40:21 -0400", description: "New GraphQL API", pr_number:                                                                     3708, scopes: ["observability"], type:                                    "feat", breaking_change:        false, author: "Lee Benson", files_count:            21, insertions_count:  789, deletions_count:  7},
		{sha: "0fc7c55feff53af813c2a2717f8e8ead986fb333", date: "2020-09-18 09:09:57 -0400", description: "Accept more timestamp patterns in `to_timestamp`", pr_number:                                    3989, scopes: ["remap transform"], type:                                  "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            1, insertions_count:   19, deletions_count:   9},
		{sha: "bb5993d349a14d50b8e7d47b9f609e1e30a89400", date: "2020-09-18 17:08:03 -0400", description: "Include container_name in kubernetes_logs", pr_number:                                           4018, scopes: ["kubernetes_logs source"], type:                           "enhancement", breaking_change: false, author: "Raphael Taylor-Davies", files_count: 3, insertions_count:   47, deletions_count:   3},
		{sha: "778081044b83058b4b555311fa8ae33e17853911", date: "2020-09-20 12:26:42 -0400", description: "instrument and guard against double poll", pr_number:                                            4024, scopes: ["sinks"], type:                                            "fix", breaking_change:         false, author: "Luke Steensen", files_count:         1, insertions_count:   90, deletions_count:   15},
		{sha: "e6a84eb6bd48281ebb53a1225f39099f533251a0", date: "2020-09-21 00:37:57 -0400", description: "Add reconnect loop to `TcpSink`", pr_number:                                                     4030, scopes: ["socket sink"], type:                                      "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:    2, insertions_count:   116, deletions_count:  51},
		{sha: "316ec957214dc10aed7a8288ebe521291c91a89a", date: "2020-09-21 22:57:13 -0400", description: "Insert timestamp into stackdriver message", pr_number:                                           3833, scopes: ["gcp_stackdriver sink"], type:                             "enhancement", breaking_change: false, author: "FungusHumungus", files_count:        1, insertions_count:   48, deletions_count:   6},
		{sha: "b995485d08988c37e8d35730b3fc0b0a9b017be8", date: "2020-09-24 05:41:32 -0400", description: "Start reading logs at checkpoint", pr_number:                                                    4043, scopes: ["kubernetes_logs source"], type:                           "fix", breaking_change:         false, author: "MOZGIII", files_count:               1, insertions_count:   37, deletions_count:   1},
		{sha: "ad77d20302cd77f5f00262a32d75d592a711fa86", date: "2020-09-25 08:31:03 -0400", description: "GraphQL client", pr_number:                                                                      3778, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Lee Benson", files_count:            13, insertions_count:  2113, deletions_count: 11},
		{sha: "cfa8e78193e4ec5f0c7132c6edda90ae68c2ca2d", date: "2020-09-25 16:55:15 -0400", description: "Avoid calling `peer_addr`", pr_number:                                                           3822, scopes: ["networking"], type:                                       "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:    5, insertions_count:   45, deletions_count:   39},
		{sha: "1ceb8fb7d290eedf80330065be102827628189fa", date: "2020-09-25 10:02:27 -0400", description: "Fix tokio signal behavior to handle a loop of signals", pr_number:                               4095, scopes: ["shutdown"], type:                                         "fix", breaking_change:         false, author: "Ana Hobden", files_count:            1, insertions_count:   9, deletions_count:    7},
		{sha: "fba1de4463b41a7fd42d626f3cb6b4971278c3ed", date: "2020-09-26 14:53:52 -0400", description: "add `format_timestamp` function", pr_number:                                                     4075, scopes: ["remap transform"], type:                                  "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            4, insertions_count:   151, deletions_count:  3},
		{sha: "c66a7307e92a327c1c046398b9a4fa495d028ee6", date: "2020-09-27 15:48:22 -0400", description: "add `contains` function", pr_number:                                                             4090, scopes: ["remap transform"], type:                                  "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            4, insertions_count:   247, deletions_count:  39},
		{sha: "f7858e83bbf1452afe5401cacbcb0dba44b2f1e1", date: "2020-09-27 17:40:09 -0400", description: "add `slice` function", pr_number:                                                                4092, scopes: ["remap transform"], type:                                  "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            4, insertions_count:   290, deletions_count:  4},
		{sha: "5bfaff9527d93158c8570532fd0ae4eba890658f", date: "2020-09-28 08:13:02 -0400", description: "add `tokenize` function", pr_number:                                                             4093, scopes: ["remap transform"], type:                                  "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            9, insertions_count:   261, deletions_count:  130},
		{sha: "c5ec225ac48bc0d1de08bf84b73569cb75a307b2", date: "2020-09-28 10:59:47 -0400", description: "more robust handling of split reads", pr_number:                                                 4089, scopes: ["file source"], type:                                      "fix", breaking_change:         false, author: "Luke Steensen", files_count:         4, insertions_count:   182, deletions_count:  91},
		{sha: "83f1887b77cd1986b777da167e575386e6b7327c", date: "2020-09-28 20:11:17 -0400", description: "Add container_image and pod_node_name annotations", pr_number:                                   4020, scopes: ["kubernetes_logs source"], type:                           "enhancement", breaking_change: false, author: "MOZGIII", files_count:               3, insertions_count:   162, deletions_count:  5},
		{sha: "2bef814916bc54db2da09cd5594d7c6939b017a4", date: "2020-09-28 16:46:18 -0400", description: "Emit overwrite logs as debug (#3803)", pr_number:                                                4088, scopes: ["observability", "add_fields transform"], type:            "feat", breaking_change:        false, author: "Spencer Gilbert", files_count:       1, insertions_count:   2, deletions_count:    2},
		{sha: "95df9244f7444cc52ec16c9aefd23c3e5f0310ff", date: "2020-09-29 09:33:25 -0400", description: "Emit warning on incomplete UDP sent", pr_number:                                                 4034, scopes: ["observability", "socket sink"], type:                     "enhancement", breaking_change: false, author: "Do Duy", files_count:                3, insertions_count:   37, deletions_count:   1},
		{sha: "8c9a72b87608abb782f6812bdf8e34b307efb6fa", date: "2020-09-29 13:05:59 -0400", description: "add `strip_ansi_escape_codes` function", pr_number:                                              4170, scopes: ["remap transform"], type:                                  "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            3, insertions_count:   100, deletions_count:  2},
		{sha: "2a1ef473e84138ea06d5ba82ba4ae1f6288a0378", date: "2020-09-29 18:00:19 -0400", description: "Recompute configuration paths", pr_number:                                                       4094, scopes: ["reload"], type:                                           "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:    4, insertions_count:   79, deletions_count:   17},
		{sha: "9f7cbad9d65f86c083165027b5745587fdc63305", date: "2020-09-29 18:19:31 -0400", description: "Wait on Windows after components shutdown", pr_number:                                           4102, scopes: ["reload", "windows platform"], type:                       "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:    1, insertions_count:   8, deletions_count:    3},
		{sha: "43329e8e7b5715d89d92b262d7b1bfee25e796a1", date: "2020-09-30 08:18:55 -0400", description: "Do not serialize None in in-flight config", pr_number:                                           4192, scopes: ["config"], type:                                           "fix", breaking_change:         false, author: "Do Duy", files_count:                1, insertions_count:   15, deletions_count:   1},
		{sha: "3a1e96892283e907a3eb1f031d94e3c29f9bf2a2", date: "2020-09-30 12:25:32 -0400", description: "add `sha2` function", pr_number:                                                                 4188, scopes: ["remap transform"], type:                                  "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            6, insertions_count:   202, deletions_count:  4},
		{sha: "5ad63f7d146727326300d96d6be5f8c0dbb747d1", date: "2020-09-30 13:38:09 -0400", description: "add `sha3` function", pr_number:                                                                 4198, scopes: ["remap transform"], type:                                  "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            7, insertions_count:   215, deletions_count:  10},
		{sha: "2b52002740b1f595e1eeac77ca8b0326a70fd9e5", date: "2020-09-30 21:44:42 -0400", description: "add field's value in warn message when failing to parse", pr_number:                             4215, scopes: ["observability", "json_parser transform"], type:           "enhancement", breaking_change: false, author: "Mathieu Stefani", files_count:       2, insertions_count:   8, deletions_count:    4},
		{sha: "d645cae992706340cd8abf84039c8a4c5b808499", date: "2020-09-30 22:25:14 -0400", description: "Added distroless-libc and distroless-static docker container bases", pr_number:                  4236, scopes: ["docker platform"], type:                                  "enhancement", breaking_change: false, author: "Rick Richardson", files_count:       4, insertions_count:   51, deletions_count:   0},
		{sha: "9fceb7ddf0504b475cc59f971d04d8905b241b23", date: "2020-10-01 15:07:51 -0400", description: "Add `parse_duration` function", pr_number:                                                       4186, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            7, insertions_count:   240, deletions_count:  4},
		{sha: "1e7abc23850f3cae83b4672698f89f34a594038c", date: "2020-10-01 15:47:22 -0400", description: "Add support for `summary` metric", pr_number:                                                    4032, scopes: ["prometheus sink"], type:                                  "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    4, insertions_count:   150, deletions_count:  62},
		{sha: "6b2e43cb29428ffa8a341e80a1efaf4bac589515", date: "2020-10-01 14:53:54 -0400", description: "Sink should emit event on invalid metric", pr_number:                                            3636, scopes: ["statsd sink"], type:                                      "fix", breaking_change:         false, author: "FungusHumungus", files_count:        4, insertions_count:   42, deletions_count:   6},
		{sha: "6d585c96c0ccbfbed02eb883d3a8cf16d33786e0", date: "2020-10-01 07:14:21 -0400", description: "Ensure server starts immediately", pr_number:                                                    4239, scopes: ["prometheus sink"], type:                                  "fix", breaking_change:         false, author: "Rick Richardson", files_count:       1, insertions_count:   1, deletions_count:    2},
		{sha: "24ff76f1899a36122ced0fc38846708a1bb2b807", date: "2020-10-01 16:33:11 -0400", description: "add a way to register and run vector as a service", pr_number:                                   2896, scopes: ["windows platform"], type:                                 "feat", breaking_change:        false, author: "Mathieu Stefani", files_count:       12, insertions_count:  938, deletions_count:  220},
		{sha: "57df969c7a2498d540946e73628f7d169c870914", date: "2020-10-01 22:44:53 -0400", description: "Fix 101 exit code on `api.enabled = true`", pr_number:                                           4254, scopes: ["startup"], type:                                          "fix", breaking_change:         false, author: "Lee Benson", files_count:            1, insertions_count:   16, deletions_count:   13},
		{sha: "a2cc2440307cd3fe34ba99d80445260286dace56", date: "2020-10-01 22:51:19 -0400", description: "Add EKS Web Identity Support", pr_number:                                                        4049, scopes: ["auth", "kubernetes platform", "aws service"], type:       "enhancement", breaking_change: false, author: "Raphael Taylor-Davies", files_count: 1, insertions_count:   44, deletions_count:   3},
		{sha: "d93dc92b964bc081ccc3303b35871ee256853bdd", date: "2020-10-02 14:46:12 -0400", description: "Initial GraphQL topology", pr_number:                                                            4191, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Lee Benson", files_count:            8, insertions_count:   138, deletions_count:  36},
		{sha: "f7a9b676c823ecfdda3ff14f268fd83d80056e17", date: "2020-10-02 13:23:25 -0400", description: "Set host key correctly", pr_number:                                                              4229, scopes: ["humio_logs sink"], type:                                  "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:         3, insertions_count:   31, deletions_count:   4},
		{sha: "f77faa5a31c6ce337604c3102fea6f89df816830", date: "2020-10-04 00:09:22 -0400", description: "Initial `azure_monitor_logs` sink", pr_number:                                                   2811, scopes: ["new sink"], type:                                         "feat", breaking_change:        false, author: "Nazar Mishturak", files_count:       6, insertions_count:   854, deletions_count:  0},
		{sha: "9c3f09c172d3ae7f35c0707a60ffe6a874501112", date: "2020-10-05 09:30:56 -0400", description: "Improve error handling", pr_number:                                                              4288, scopes: ["console sink"], type:                                     "enhancement", breaking_change: false, author: "Do Duy", files_count:                3, insertions_count:   62, deletions_count:   27},
		{sha: "51fd8679ac36b567c70b385e09b54b5bf59c5520", date: "2020-10-06 15:53:08 -0400", description: "add `format_number` function", pr_number:                                                        4220, scopes: ["remap transform"], type:                                  "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            3, insertions_count:   275, deletions_count:  0},
		{sha: "3e0eb97804874df96af548778db70b5d20418031", date: "2020-10-07 17:27:29 -0400", description: "Use configured namespace for `up` metric", pr_number:                                            4437, scopes: ["apache_metrics source"], type:                            "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:         2, insertions_count:   15, deletions_count:   14},
		{sha: "e83c4cc2d7d1e37c8a0d6769e799345bc85e5ff3", date: "2020-10-07 16:11:54 -0400", description: "Add `host_metrics` source", pr_number:                                                           4157, scopes: ["new source"], type:                                       "feat", breaking_change:        false, author: "Bruce Guenter", files_count:         11, insertions_count:  2101, deletions_count: 15},
		{sha: "a9b176b2f94df3a6996f2081c9a4bbc84c57e271", date: "2020-10-08 16:05:34 -0400", description: "Rename sink type and fallback on US region by default", pr_number:                               4447, scopes: ["sematext_logs sink"], type:                               "fix", breaking_change:         false, author: "Nedim Šabić²", files_count:          1, insertions_count:   7, deletions_count:    9},
		{sha: "b6a331bbdedd570ab7e8ffdbd4f10e48c0d9afe9", date: "2020-10-08 17:45:44 -0400", description: "Add `metric_to_log` transform", pr_number:                                                       3552, scopes: ["new transform"], type:                                    "feat", breaking_change:        false, author: "Daniel Jin", files_count:            8, insertions_count:   451, deletions_count:  2},
		{sha: "d3a5fe992e26d422e561b12cf294b748ea013d5d", date: "2020-10-09 00:39:45 -0400", description: "Merge `api::Options`", pr_number:                                                                4342, scopes: ["config"], type:                                           "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:    2, insertions_count:   98, deletions_count:   6},
		{sha: "a2723d7f2f162bdfb47473d6a3f0eb046dd1c87f", date: "2020-10-09 09:32:36 -0400", description: "Bidirectional source/transform/sink GraphQL types", pr_number:                                   4383, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Lee Benson", files_count:            2, insertions_count:   627, deletions_count:  16},
		{sha: "06da2aa13c3e24a36a4d735e494ef1730f4d76c9", date: "2020-10-09 19:48:52 -0400", description: "Improve error messages", pr_number:                                                              4429, scopes: ["observability", "log_to_metric transform"], type:         "enhancement", breaking_change: false, author: "Do Duy", files_count:                2, insertions_count:   112, deletions_count:  70},
		{sha: "d04df77033dd30a90b45733c989146e59db9da80", date: "2020-10-09 22:29:09 -0400", description: "Add alias to avoid breaking change", pr_number:                                                  4469, scopes: ["file source"], type:                                      "fix", breaking_change:         false, author: "Do Duy", files_count:                1, insertions_count:   2, deletions_count:    0},
		{sha: "178e5bed9509497dc73ecadda509b2e69f403b17", date: "2020-10-09 17:43:05 -0400", description: "Use temporary data directory during `validate` command", pr_number:                              4341, scopes: ["cli"], type:                                              "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:    4, insertions_count:   134, deletions_count:  37},
		{sha: "1c41985f35cbc702925b919c3d660673f3a9c2ec", date: "2020-10-09 14:39:39 -0400", description: "New `aws_firehose` source and `aws_cloudwatch_logs_subscription_parser` transform", pr_number:   4101, scopes: ["new source"], type:                                       "feat", breaking_change:        false, author: "Jesse Szwedko", files_count:         20, insertions_count:  1752, deletions_count: 339},
		{sha: "36dea21a558d706535c980930f3c7b750b93bbfc", date: "2020-10-11 10:05:17 -0400", description: "New `sematext_metrics` sink", pr_number:                                                         3501, scopes: ["new sink"], type:                                         "feat", breaking_change:        false, author: "FungusHumungus", files_count:        13, insertions_count:  614, deletions_count:  23},
		{sha: "2b3b98cea0844e254d65fcb3c674f93bbe6560b2", date: "2020-10-11 18:52:53 -0400", description: "Option to specify `quantiles`", pr_number:                                                       4412, scopes: ["metrics", "sinks"], type:                                 "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    7, insertions_count:   107, deletions_count:  28},
		{sha: "5ee768ac7fc31efbc80e9932b104d11c7272325f", date: "2020-10-11 19:54:04 -0400", description: "Allow inclusion of env field in request and default_env in config", pr_number:                   4077, scopes: ["logdna sink"], type:                                      "feat", breaking_change:        false, author: "Robin Mattheussen", files_count:     3, insertions_count:   36, deletions_count:   0},
		{sha: "48064d005664e772e5664645240d7a713d1364bd", date: "2020-10-11 14:05:32 -0400", description: "Update log levels for transforms", pr_number:                                                    4235, scopes: ["observability", "transforms"], type:                      "feat", breaking_change:        false, author: "Spencer Gilbert", files_count:       8, insertions_count:   15, deletions_count:   15},
		{sha: "7dd7e8125e33751b38013c810629e408afdddf2e", date: "2020-10-12 00:39:38 -0400", description: "add TLS settings to influxdb_logs and influxdb_metrics sinks", pr_number:                        4037, scopes: ["security", "networking", "influxdb_metrics sink"], type:  "enhancement", breaking_change: false, author: "Mathieu Stefani", files_count:       5, insertions_count:   161, deletions_count:  29},
		{sha: "19585c3a9dbfe82590d92d96fb72a606e0f4b255", date: "2020-10-12 23:37:26 -0400", description: "Propagate close for Fanout and buffers::disk::Writer", pr_number:                                4275, scopes: ["aws_s3 sink"], type:                                      "fix", breaking_change:         false, author: "Raphael Taylor-Davies", files_count: 3, insertions_count:   49, deletions_count:   26},
		{sha: "d4f9c0d33b03b7cf506d6dcb0cea41dcbabd7687", date: "2020-10-13 15:26:22 -0400", description: "Add a tags configuration options to add user-defined tags", pr_number:                           4068, scopes: ["influxdb_metrics sink"], type:                            "enhancement", breaking_change: false, author: "Mathieu Stefani", files_count:       2, insertions_count:   87, deletions_count:   15},
		{sha: "594242f7c2550458eaa34e021be28668cb1be946", date: "2020-10-13 16:36:46 -0400", description: "Add vector user to adm in debian packaging", pr_number:                                          4544, scopes: ["debian platform"], type:                                  "enhancement", breaking_change: false, author: "James Turnbull", files_count:        1, insertions_count:   6, deletions_count:    1},
		{sha: "1e95458540596b7e0058684afc8ac97caa84e992", date: "2020-10-14 17:21:43 -0400", description: "Support all socket types in statsd sink", pr_number:                                             3557, scopes: ["statsd sink"], type:                                      "enhancement", breaking_change: true, author:  "Do Duy", files_count:                9, insertions_count:   629, deletions_count:  365},
		{sha: "dae23aa69f2190aa9de46ad375531cf31d3fa470", date: "2020-10-14 09:39:32 -0400", description: "Do not automatically append /metrics", pr_number:                                                4276, scopes: ["prometheus_source"], type:                                "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:         2, insertions_count:   23, deletions_count:   9},
		{sha: "fe05027693a157269f089dbc3ebd5b9a251973b1", date: "2020-10-14 17:22:29 -0400", description: "Add support for dedicated Azure region", pr_number:                                              4507, scopes: ["azure_monitor_logs sink"], type:                          "feat", breaking_change:        false, author: "Nazar Mishturak", files_count:       2, insertions_count:   42, deletions_count:   2},
		{sha: "2f2583b59062e686c9458d10c2679060c4600e4c", date: "2020-10-14 13:51:30 -0400", description: "Don't dedot keys", pr_number:                                                                    4103, scopes: ["http source"], type:                                      "fix", breaking_change:         true, author:  "Daniel Jin", files_count:            1, insertions_count:   30, deletions_count:   2},
		{sha: "93dd72459df1bfdd6cd35499588d21859f15135c", date: "2020-10-15 18:47:13 -0400", description: "Add compression level", pr_number:                                                               3032, scopes: ["sinks", "networking", "compression"], type:               "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:       14, insertions_count:  221, deletions_count:  74},
		{sha: "b7ec1a94f4e6d59288519c0a085afed8cbc00ad9", date: "2020-10-16 01:22:03 -0400", description: "Allow using custom selectors", pr_number:                                                        4182, scopes: ["kubernetes_logs source"], type:                           "enhancement", breaking_change: false, author: "MOZGIII", files_count:               2, insertions_count:   304, deletions_count:  24},
		{sha: "73709ea6962d00e5424fb38fa4b05d0411e43a19", date: "2020-10-16 08:27:32 -0400", description: "`vector top`, v1", pr_number:                                                                    4431, scopes: ["observability"], type:                                    "feat", breaking_change:        false, author: "Lee Benson", files_count:            15, insertions_count:  393, deletions_count:  13},
		{sha: "f1b99881b5d1db81c52a487d390c888a6550859c", date: "2020-10-16 14:32:19 -0400", description: "Support assume_role with EKS web identity", pr_number:                                           4406, scopes: ["aws service", "kubernetes platform", "auth"], type:       "enhancement", breaking_change: false, author: "Raphael Taylor-Davies", files_count: 1, insertions_count:   11, deletions_count:   1},
		{sha: "20bc89ab8cf1979c35b15a98ebcf4e2ec51a758e", date: "2020-10-16 16:30:56 -0400", description: "Rename \"identifier_fields\" to \"group_by\"", pr_number:                                        4580, scopes: ["reduce transform"], type:                                 "enhancement", breaking_change: true, author:  "Jean Mertz", files_count:            4, insertions_count:   15, deletions_count:   15},
		{sha: "b99af35ef731f2070917715b1b8143cbe1523bc4", date: "2020-10-16 16:31:22 -0400", description: "\"concat_newline\" strategy merges using newline", pr_number:                                    4579, scopes: ["reduce transform"], type:                                 "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            4, insertions_count:   45, deletions_count:   10},
		{sha: "ea224e12940f3ad4cdc87f1077a813dadce777a0", date: "2020-10-16 17:19:41 -0400", description: "Sanitize URL when tagging metrics", pr_number:                                                   4410, scopes: ["apache_metrics source"], type:                            "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:         2, insertions_count:   72, deletions_count:   19},
		{sha: "986e62cb8d2565d7f230d9375439551325bb7596", date: "2020-10-16 23:35:15 -0400", description: "New `humio_metrics` sink.", pr_number:                                                           4531, scopes: ["new sink"], type:                                         "feat", breaking_change:        false, author: "FungusHumungus", files_count:        9, insertions_count:   304, deletions_count:  133},
		{sha: "12db2a2435c524c24e747b35a35b155c4360d877", date: "2020-10-16 21:05:12 -0400", description: "Treat all hyper::Error results as retriable", pr_number:                                         4575, scopes: ["sinks", "networking"], type:                              "fix", breaking_change:         false, author: "Bruce Guenter", files_count:         3, insertions_count:   6, deletions_count:    6},
		{sha: "16bed3642aff5851c41da67f37ba1e6d80276563", date: "2020-10-17 06:06:11 -0400", description: "Advanced container filtering", pr_number:                                                        4586, scopes: ["kubernetes_logs source"], type:                           "enhancement", breaking_change: false, author: "MOZGIII", files_count:               4, insertions_count:   649, deletions_count:  37},
		{sha: "fe965704308dc1f405bd38c0f098ef4118a8c0bc", date: "2020-10-17 05:06:33 -0400", description: "Add `parse_url` function", pr_number:                                                            4428, scopes: ["remap transform"], type:                                  "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            5, insertions_count:   174, deletions_count:  0},
		{sha: "1ec7a8ba70435e290326cad207009bbe61d71636", date: "2020-10-18 01:43:36 -0400", description: "Support datadog logs new HTTPS transport", pr_number:                                            4164, scopes: ["datadog_logs sink", "networking"], type:                  "enhancement", breaking_change: false, author: "FungusHumungus", files_count:        5, insertions_count:   328, deletions_count:  49},
		{sha: "4c67be50157cd651dc728f5bde0f22552cd0bd49", date: "2020-10-18 11:07:59 -0400", description: "Basic auth support", pr_number:                                                                  4385, scopes: ["logplex source", "auth"], type:                           "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:       6, insertions_count:   141, deletions_count:  43},
		{sha: "ba55fd0305af6d060c06c216a29310d1776c4e20", date: "2020-10-18 10:42:00 -0400", description: "Added region configuration parameter", pr_number:                                                4174, scopes: ["datadog service"], type:                                  "enhancement", breaking_change: false, author: "FungusHumungus", files_count:        4, insertions_count:   47, deletions_count:   13},
		{sha: "0e40d1fee9eb16d0c86957764debd172620407e9", date: "2020-10-18 08:14:33 -0400", description: "Handle non-ASCII data in all values", pr_number:                                                 4608, scopes: ["journald source"], type:                                  "fix", breaking_change:         false, author: "Bruce Guenter", files_count:         1, insertions_count:   23, deletions_count:   11},
		{sha: "e982c684d9a6e6bf97134a31a3162d3a04a2d4b2", date: "2020-10-18 10:14:59 -0400", description: "Send auth header for healthchecks", pr_number:                                                   4604, scopes: ["loki sink"], type:                                        "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:         1, insertions_count:   48, deletions_count:   2},
		{sha: "fe5beb3ca61b441271d15858eb244a22e5d9f82d", date: "2020-10-20 17:22:15 UTC", description:   "Initial `mongodb_metrics` implementation", pr_number:                                            4500, scopes: ["new source"], type:                                       "feat", breaking_change:        false, author: "Kirill Fomichev", files_count:       14, insertions_count:  2857, deletions_count: 22},
		{sha: "84e5986a4eff07536c7b2f688600d3a5aa5593ea", date: "2020-10-20 23:33:52 UTC", description:   "Correctly handle service restart", pr_number:                                                    4408, scopes: ["windows platform"], type:                                 "enhancement", breaking_change: false, author: "Mathieu Stefani", files_count:       3, insertions_count:   206, deletions_count:  34},
		{sha: "31ba36840fa55a8d1709a6a639d60b393b86d7b7", date: "2020-10-21 04:57:11 UTC", description:   "Add support for all socket types", pr_number:                                                    4557, scopes: ["statsd source"], type:                                    "enhancement", breaking_change: true, author:  "Do Duy", files_count:                6, insertions_count:   290, deletions_count:  86},
		{sha: "0e74a647c4c12c7a48ce6bd34d66c18c2356445a", date: "2020-10-20 18:22:08 UTC", description:   "Updated internal metrics names to match standards", pr_number:                                   4647, scopes: ["observability", "internal_metrics source"], type:         "enhancement", breaking_change: true, author:  "James Turnbull", files_count:        74, insertions_count:  284, deletions_count:  304},
		{sha: "716175c0575b05a725a9d8cd7d3f33d45f878df4", date: "2020-10-22 18:44:54 UTC", description:   "Fix flag for `usermod` in postinst deb script", pr_number:                                       4694, scopes: ["debian platform"], type:                                  "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:         1, insertions_count:   2, deletions_count:    2},
		{sha: "c447ecf1a6f5e39dd991177fd63ea00305559537", date: "2020-10-22 20:04:11 UTC", description:   "Add internal events", pr_number:                                                                 4481, scopes: ["observability", "logfmt_parser transform"], type:         "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:         3, insertions_count:   69, deletions_count:   11},
		{sha: "c4c8cb69971e3a57b36018507f719ddc9e96bc94", date: "2020-10-23 05:10:23 UTC", description:   "Only sleep when backing off", pr_number:                                                         4672, scopes: ["file source"], type:                                      "perf", breaking_change:        false, author: "Luke Steensen", files_count:         1, insertions_count:   91, deletions_count:   5},
		{sha: "b65f9f873903e22a42b35a6e3e580a1b6e0006c8", date: "2020-10-24 04:01:52 UTC", description:   "Add `namespace` to `Metric` ", pr_number:                                                        4701, scopes: ["data model", "metrics"], type:                            "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    29, insertions_count:  372, deletions_count:  2},
		{sha: "4c015a04cd1cca9128e446600c97f78dd582fa6e", date: "2020-10-23 22:41:57 UTC", description:   "Send batches of lines", pr_number:                                                               4719, scopes: ["file source"], type:                                      "perf", breaking_change:        false, author: "Luke Steensen", files_count:         5, insertions_count:   57, deletions_count:   45},
		{sha: "e17298d48c9940208e2412b143531f5cf4bda534", date: "2020-10-24 07:57:39 UTC", description:   "Fix API max payload size", pr_number:                                                            4707, scopes: ["new_relic_logs sink"], type:                              "fix", breaking_change:         false, author: "Matilda Smeds", files_count:         1, insertions_count:   37, deletions_count:   17},
		{sha: "176fdcfe689a85a1b756ef2866f6ef63ecac0705", date: "2020-10-26 18:31:03 UTC", description:   "Force daemonset to redeploy when configmap is updated", pr_number:                               4734, scopes: ["kubernetes platform"], type:                              "enhancement", breaking_change: false, author: "Spencer Gilbert", files_count:       2, insertions_count:   7, deletions_count:    4},
		{sha: "84dd243c0595196d8d6c61bb98c49067ad9eb3fb", date: "2020-07-30 01:13:41 UTC", description:   "Fix default-msvc feature", pr_number:                                                            3246, scopes: ["journald source"], type:                                  "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:       1, insertions_count:   2, deletions_count:    2},
		{sha: "d64c8b15c4627ddf7424e9ef303fbb3ebb6ab1aa", date: "2020-07-29 18:40:47 UTC", description:   "Fix typo in metrics name", pr_number:                                                            3252, scopes: ["journald source"], type:                                  "fix", breaking_change:         false, author: "Bruce Guenter", files_count:         1, insertions_count:   1, deletions_count:    1},
		{sha: "6dafbeb7c96a39779a65db923159626ffa107b96", date: "2020-07-30 03:59:18 UTC", description:   "Kubernetes E2E test framework", pr_number:                                                       2702, scopes: ["tests"], type:                                            "chore", breaking_change:       false, author: "MOZGIII", files_count:               32, insertions_count:  1855, deletions_count: 152},
		{sha: "cde9547e69f7808925408443c79f580bd7092d86", date: "2020-08-05 00:44:07 UTC", description:   "tcp merge_and_fork", pr_number:                                                                  3340, scopes: ["tests"], type:                                            "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:       1, insertions_count:   6, deletions_count:    4},
		{sha: "a391434e97a078f6ea92691bba76f9af91ad1866", date: "2020-08-07 00:47:32 UTC", description:   "Add build.rs to CI trigger paths", pr_number:                                                    3367, scopes: ["operations"], type:                                       "chore", breaking_change:       false, author: "MOZGIII", files_count:               1, insertions_count:   2, deletions_count:    0},
		{sha: "4cfc66ec32590810ca37d2fde9efdfdd383a0602", date: "2020-08-08 18:03:35 UTC", description:   "E2E CI flows optimization", pr_number:                                                           3353, scopes: ["ci"], type:                                               "chore", breaking_change:       false, author: "MOZGIII", files_count:               4, insertions_count:   188, deletions_count:  48},
		{sha: "c0b6662f8e7f406626102e416d89d8534485181c", date: "2020-08-18 04:58:57 UTC", description:   "Ship Helm Chart from release CI workflow", pr_number:                                            3459, scopes: ["ci"], type:                                               "chore", breaking_change:       false, author: "MOZGIII", files_count:               3, insertions_count:   39, deletions_count:   13},
		{sha: "2288fd237648529db57373eba09384f56c2f8093", date: "2020-08-20 07:07:05 UTC", description:   "Wrap StreamSink around TcpSink", pr_number:                                                      3495, scopes: ["sinks"], type:                                            "chore", breaking_change:       false, author: "Do Duy", files_count:                2, insertions_count:   6, deletions_count:    4},
		{sha: "931f6401702e690a4a513e18ae411c25e1a92b0a", date: "2020-08-26 18:52:05 UTC", description:   "Only update auto-concurrency RTT from OK responses", pr_number:                                  3493, scopes: ["performance"], type:                                      "chore", breaking_change:       false, author: "Bruce Guenter", files_count:         3, insertions_count:   155, deletions_count:  111},
		{sha: "7094f511b1bf1ea9e639320fe20199c7d50d3b28", date: "2020-09-02 00:04:23 UTC", description:   "Fix Splunk integration test", pr_number:                                                         3661, scopes: ["tests"], type:                                            "chore", breaking_change:       false, author: "Lee Benson", files_count:            3, insertions_count:   27, deletions_count:   3},
		{sha: "85eff5814997d07cd4a2d99cc17f34c694c32111", date: "2020-09-09 02:33:31 UTC", description:   "add deny.toml", pr_number:                                                                       3765, scopes: ["ci"], type:                                               "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:       1, insertions_count:   12, deletions_count:   0},
		{sha: "50a9c3af6779b887f9e72a313f7caee4c0d3c41c", date: "2020-09-10 07:20:34 UTC", description:   "update next_addr_v6", pr_number:                                                                 3785, scopes: ["ci"], type:                                               "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:       1, insertions_count:   3, deletions_count:    7},
		{sha: "439a9cfdb48d976f19a0d2e5b84fc268752d93ba", date: "2020-09-10 22:50:41 UTC", description:   "Fix journald tests", pr_number:                                                                  3794, scopes: ["tests"], type:                                            "chore", breaking_change:       false, author: "Do Duy", files_count:                1, insertions_count:   4, deletions_count:    3},
		{sha: "74b43b7ff208ae9531729acdd5331eb89a49851b", date: "2020-09-10 22:05:52 UTC", description:   "Rework auto concurrency backpressure logic", pr_number:                                          3804, scopes: ["networking"], type:                                       "chore", breaking_change:       false, author: "Bruce Guenter", files_count:         2, insertions_count:   12, deletions_count:   6},
		{sha: "e55ac69b6a51e4c81e04b643c838459ecee65fdf", date: "2020-09-16 03:04:16 UTC", description:   "expand macros before validation", pr_number:                                                     3894, scopes: ["config"], type:                                           "fix", breaking_change:         false, author: "Luke Steensen", files_count:         2, insertions_count:   42, deletions_count:   2},
		{sha: "04a569a4a418f36c9b7d017151c2edc34e10758b", date: "2020-09-17 17:51:26 UTC", description:   "Add new set of functions", pr_number:                                                            3767, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "Jean Mertz", files_count:            8, insertions_count:   1691, deletions_count: 49},
		{sha: "b40b7b661599982eaab5eb8ce3dfbbb0e14ca5b3", date: "2020-09-24 17:44:36 UTC", description:   "named function arguments", pr_number:                                                            3927, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "Jean Mertz", files_count:            8, insertions_count:   1163, deletions_count: 413},
		{sha: "ebacf5728c8e56d7cd2b2cb1bac8dbe1901e79a6", date: "2020-09-24 23:23:53 UTC", description:   "Update tokio signal to avoid unnecessary shutdowns.", pr_number:                                 4025, scopes: ["windows platform"], type:                                 "fix", breaking_change:         false, author: "Ana Hobden", files_count:            5, insertions_count:   36, deletions_count:   124},
		{sha: "cc324ca46ef1fe500802601efd04dc9844ab96c6", date: "2020-09-29 03:23:40 UTC", description:   "fix clippy warnings for integration tests", pr_number:                                           4171, scopes: ["ci"], type:                                               "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:       8, insertions_count:   44, deletions_count:   38},
		{sha: "d8b368b86f6736f21ec974c4aae0020df0a0ba0a", date: "2020-10-07 20:42:24 UTC", description:   "Add musl x86/aarch64 platforms", pr_number:                                                      3701, scopes: ["platforms"], type:                                        "feat", breaking_change:        false, author: "Ana Hobden", files_count:            19, insertions_count:  220, deletions_count:  58},
		{sha: "1dc820049d6ed9d2884c1d583e76d65cdc6eab21", date: "2020-10-09 21:38:40 UTC", description:   "Adjust auto concurrency tuning defaults", pr_number:                                             4476, scopes: ["networking"], type:                                       "chore", breaking_change:       false, author: "Bruce Guenter", files_count:         3, insertions_count:   16, deletions_count:   14},
		{sha: "2fa1480b3edac8457b5266d58a476daa895164ac", date: "2020-10-19 03:42:58 UTC", description:   "Use Signer::sign_to_vec to support older OpenSSL versions", pr_number:                           4623, scopes: ["azure_monitor_logs sink"], type:                          "fix", breaking_change:         false, author: "Nazar Mishturak", files_count:       1, insertions_count:   2, deletions_count:    1},
		{sha: "42a26f5eec2287012bc21b015d0bab43f818913b", date: "2020-10-20 00:14:40 UTC", description:   "Topology added/removed GraphQL subscriptions", pr_number:                                        4581, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Lee Benson", files_count:            8, insertions_count:   428, deletions_count:  8},
		{sha: "fb0191c52f78e903a107b702f7dacd52815b429f", date: "2020-10-21 02:00:47 UTC", description:   "add `floor`, `round` and `ceil` remap functions", pr_number:                                     4646, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "FungusHumungus", files_count:        6, insertions_count:   472, deletions_count:  0},
		{sha: "f51e4d6a63f157d31036d2234b5abc59b2509edf", date: "2020-10-21 03:03:39 UTC", description:   "add `parse_syslog` function", pr_number:                                                         4632, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "FungusHumungus", files_count:        4, insertions_count:   289, deletions_count:  2},
		{sha: "1c9c2f8fdf234a608f09ad5e7ca91fc65cdf6f08", date: "2020-10-21 23:57:54 UTC", description:   "add `split` function ", pr_number:                                                               4290, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "FungusHumungus", files_count:        43, insertions_count:  928, deletions_count:  361},
		{sha: "4ec28751c143ffa68a20cf38e6e0492adeb56121", date: "2020-10-22 06:32:25 UTC", description:   "Improve networking performance", pr_number:                                                      4668, scopes: ["statsd sink"], type:                                      "fix", breaking_change:         false, author: "Do Duy", files_count:                5, insertions_count:   181, deletions_count:  212},
		{sha: "30f23c7c6e154543492e40b2f978d7586451fc76", date: "2020-10-22 18:29:46 UTC", description:   "API host metrics", pr_number:                                                                    4652, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Lee Benson", files_count:            16, insertions_count:  1429, deletions_count: 195},
		{sha: "7762f6491530b6f10083dc71f2d9c3f99cdef299", date: "2020-10-23 22:26:33 UTC", description:   "syslog test should assume local time zone", pr_number:                                           4711, scopes: ["remap transform"], type:                                  "fix", breaking_change:         false, author: "FungusHumungus", files_count:        1, insertions_count:   10, deletions_count:   10},
		{sha: "f683f9350d45a3f80de09a65f5a14185f31e99af", date: "2020-10-24 03:36:13 UTC", description:   "add `log` function", pr_number:                                                                  4640, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "FungusHumungus", files_count:        4, insertions_count:   118, deletions_count:  2},
		{sha: "d1240a6dadd81d59eab5e179af68d8eb8fc1a97d", date: "2020-10-24 20:09:33 UTC", description:   "use application/json for json encoding to Datadog", pr_number:                                   4690, scopes: ["datadog_logs sink"], type:                                "fix", breaking_change:         false, author: "FungusHumungus", files_count:        1, insertions_count:   15, deletions_count:   4},
		{sha: "79d146eb849539335c3f06b8df073d71767052f6", date: "2020-10-26 22:00:29 UTC", description:   "add \"remap-lang\" crate", pr_number:                                                            4695, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "Jean Mertz", files_count:            25, insertions_count:  1838, deletions_count: 1},
		{sha: "10f2c4b06471bbc3149552f768263e84b484f30a", date: "2020-10-26 17:40:55 UTC", description:   "Add missing dependency to nightly docker-release", pr_number:                                    4747, scopes: ["ci"], type:                                               "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:         1, insertions_count:   2, deletions_count:    1},
		{sha: "d75a672342c3e7439591aa9c5d4cf669ced57bac", date: "2020-10-27 23:40:19 UTC", description:   "add `replace` and `flatten` remap functions", pr_number:                                         4703, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "FungusHumungus", files_count:        5, insertions_count:   592, deletions_count:  8},
		{sha: "e9440c8bd4a54cd893bb5e1fc097facd237cd8c1", date: "2020-10-27 18:24:04 UTC", description:   "Switch from topology to components terminology", pr_number:                                      4761, scopes: ["observability"], type:                                    "chore", breaking_change:       false, author: "Luc Perkins", files_count:           10, insertions_count:  1169, deletions_count: 1169},
		{sha: "38d9e1bf6b7431c30358afc3c428d1effe1ff0ca", date: "2020-10-28 02:05:28 UTC", description:   "annotate logs with query parameters", pr_number:                                                 4733, scopes: ["logplex source"], type:                                   "enhancement", breaking_change: false, author: "Christian Gregg", files_count:       6, insertions_count:   194, deletions_count:  70},
		{sha: "333f71832dd048a88a1395a6528e800e68dd4d31", date: "2020-10-28 00:27:08 UTC", description:   "Count total bytes for logs", pr_number:                                                          4705, scopes: ["blackhole sink"], type:                                   "chore", breaking_change:       false, author: "Jesse Szwedko", files_count:         1, insertions_count:   5, deletions_count:    8},
		{sha: "fe87d036f9b2b1f2235f4d193bf90c364d27fdb6", date: "2020-10-28 01:00:57 UTC", description:   "Make query_parameters optional", pr_number:                                                      4782, scopes: ["config"], type:                                           "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:         2, insertions_count:   2, deletions_count:    0},
		{sha: "068d158327d79d3c9730ffebd8fdb9c611c8124d", date: "2020-10-28 04:27:49 UTC", description:   "Updated remaining log messages to match standards", pr_number:                                   4737, scopes: ["logs"], type:                                             "chore", breaking_change:       false, author: "James Turnbull", files_count:        155, insertions_count: 572, deletions_count:  513},
		{sha: "07b9cbbe24ed1987edc134b989f29b7225acce23", date: "2020-10-28 18:22:25 UTC", description:   "`vector top` v1 dashboard", pr_number:                                                           4702, scopes: ["observability"], type:                                    "feat", breaking_change:        false, author: "Lee Benson", files_count:            9, insertions_count:   634, deletions_count:  186},
		{sha: "256d55c720ab8e8fade0d5d661eebdbdf0e58856", date: "2020-10-28 20:56:23 UTC", description:   "swap out remap impl with new remap-lang crate", pr_number:                                       4709, scopes: ["remap transform"], type:                                  "chore", breaking_change:       false, author: "Jean Mertz", files_count:            97, insertions_count:  5203, deletions_count: 4958},
		{sha: "faec21c15db467b3b03ffa0fc664ed235549414a", date: "2020-10-28 21:22:21 UTC", description:   "add \"remap\" condition type", pr_number:                                                        4743, scopes: ["processing"], type:                                       "feat", breaking_change:        false, author: "Jean Mertz", files_count:            49, insertions_count:  377, deletions_count:  91},
		{sha: "bda26823dfc5baa4fb5574c221693e33fcefe51f", date: "2020-10-28 21:24:26 UTC", description:   "add \"match\" remap function", pr_number:                                                        4770, scopes: ["remap"], type:                                            "feat", breaking_change:        false, author: "Jean Mertz", files_count:            9, insertions_count:   137, deletions_count:  6},
		{sha: "0ea323574d8b5fbf1dfdb835dd58242fe55bf48c", date: "2020-10-28 21:35:26 UTC", description:   "add \"starts_when\" option", pr_number:                                                          4771, scopes: ["reduce transform"], type:                                 "feat", breaking_change:        false, author: "Jean Mertz", files_count:            2, insertions_count:   329, deletions_count:  23},
		{sha: "3f11f7d29a738d0873b68d7c6e321bf9d9d8e29e", date: "2020-10-29 19:44:19 UTC", description:   "Uses IP address as source_ip instead of IP:Port in Syslog source UDP mode", pr_number:           4793, scopes: ["syslog"], type:                                           "fix", breaking_change:         false, author: "James Turnbull", files_count:        1, insertions_count:   1, deletions_count:    1},
		{sha: "9952546f5c64544055e320f2a57b5dc690872f86", date: "2020-10-30 01:38:49 UTC", description:   "support numbers in paths", pr_number:                                                            4800, scopes: ["config"], type:                                           "fix", breaking_change:         false, author: "Jean Mertz", files_count:            4, insertions_count:   18, deletions_count:   2},
		{sha: "32162bb9d4b72246d16bed87eec4d696bebd075d", date: "2020-10-30 10:55:24 UTC", description:   "Expose the performance related parameters", pr_number:                                           4751, scopes: ["kubernetes_logs source"], type:                           "enhancement", breaking_change: false, author: "MOZGIII", files_count:               1, insertions_count:   43, deletions_count:   7},
		{sha: "a5b9f6765f93a699c6bb37ab290bbb243a4525aa", date: "2020-11-02 03:57:20 UTC", description:   "Resolve port conflict in sinks", pr_number:                                                      4735, scopes: ["reload"], type:                                           "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    7, insertions_count:   264, deletions_count:  31},
		{sha: "d55bc0bde4d607e032dd7de4786438e7230fb933", date: "2020-11-02 01:30:09 UTC", description:   "Run tests in  on pull requests", pr_number:                                                      4736, scopes: ["ci"], type:                                               "chore", breaking_change:       false, author: "James Turnbull", files_count:        1, insertions_count:   1, deletions_count:    1},
		{sha: "1d290794f863668037fc6669adae46d4c650bc68", date: "2020-11-03 02:58:44 UTC", description:   "support else-if conditional expression", pr_number:                                              4814, scopes: ["remap"], type:                                            "feat", breaking_change:        false, author: "Jean Mertz", files_count:            3, insertions_count:   64, deletions_count:   3},
		{sha: "8bf81ed4cf2cbc33e8c18ca5cd60689cba795ce3", date: "2020-11-03 02:59:56 UTC", description:   "add variable support", pr_number:                                                                4802, scopes: ["remap"], type:                                            "feat", breaking_change:        false, author: "Jean Mertz", files_count:            7, insertions_count:   45, deletions_count:   13},
		{sha: "6ffdf722d1bc234e03da2d26db9e0b12ab5e9ca2", date: "2020-11-03 07:34:32 UTC", description:   "use custom retry logic", pr_number:                                                              4813, scopes: ["clickhouse sink"], type:                                  "fix", breaking_change:         false, author: "Kirill Fomichev", files_count:       3, insertions_count:   61, deletions_count:   5},
		{sha: "eac3dba119a61229d74c6868d1cc744e35f1411f", date: "2020-11-03 18:51:36 UTC", description:   "Add the ability to set conatiner ports at vector-agent Helm chart", pr_number:                   4835, scopes: ["kubernetes platform"], type:                              "enhancement", breaking_change: false, author: "MOZGIII", files_count:               3, insertions_count:   9, deletions_count:    0},
		{sha: "b04f4310116615dee6df12b7a42fdf626b2cec2f", date: "2020-11-03 20:54:17 UTC", description:   "Add internal events", pr_number:                                                                 4480, scopes: ["aws_ec2_metadata transform"], type:                       "enhancement", breaking_change: false, author: "Jesse Szwedko", files_count:         3, insertions_count:   200, deletions_count:  137},
		{sha: "497c76d54189953c62a959d9101453e613c932d2", date: "2020-11-04 02:35:31 UTC", description:   "Adds optional file output to generator", pr_number:                                              4819, scopes: ["cli"], type:                                              "enhancement", breaking_change: false, author: "Ian Henry", files_count:             1, insertions_count:   70, deletions_count:   12},
		{sha: "c2e71041f2e4aa80246b61d00d75426fa01a8251", date: "2020-11-04 23:48:25 UTC", description:   "Add `namespace` option", pr_number:                                                              4831, scopes: ["log_to_metric transform"], type:                          "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    4, insertions_count:   69, deletions_count:   18},
		{sha: "f6b443bcccb05ded4f3c2fdf422eda76b145591c", date: "2020-11-05 07:20:37 UTC", description:   "add `replace` function", pr_number:                                                              4861, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "Jean Mertz", files_count:            7, insertions_count:   299, deletions_count:  161},
		{sha: "e3327f47863e178c21fa9a3da45e446b850d5868", date: "2020-11-05 07:23:14 UTC", description:   "unescape forward slash in regex", pr_number:                                                     4864, scopes: ["remap"], type:                                            "fix", breaking_change:         false, author: "Jean Mertz", files_count:            2, insertions_count:   40, deletions_count:   3},
		{sha: "40c7e1248d54a8f1a54c2b976de9d4ca0448d575", date: "2020-11-05 07:49:22 UTC", description:   "display full error chain", pr_number:                                                            4859, scopes: ["remap"], type:                                            "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            5, insertions_count:   64, deletions_count:   20},
		{sha: "d52d3871880ca8e37b5b91428ffdfa703e705387", date: "2020-11-05 04:23:19 UTC", description:   "Add back armv7 support", pr_number:                                                              4871, scopes: ["platforms"], type:                                        "chore", breaking_change:       false, author: "James Turnbull", files_count:        13, insertions_count:  270, deletions_count:  42},
		{sha: "d1caa067ed0ea49853eebb847bf1b64209dbac01", date: "2020-11-05 21:54:37 UTC", description:   "Parse RFC3614 messages lacking an app name", pr_number:                                          4876, scopes: ["syslog source"], type:                                    "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:         2, insertions_count:   3, deletions_count:    3},
		{sha: "515f9626d313773cd36a555839c9a54e610393e8", date: "2020-11-05 20:37:35 UTC", description:   "Add Cue sources for the Vector CLI", pr_number:                                                  4880, scopes: ["config"], type:                                           "chore", breaking_change:       false, author: "Luc Perkins", files_count:           1, insertions_count:   243, deletions_count:  0},
		{sha: "38816fd245371717033e8b881dbd5e478267bb70", date: "2020-11-06 02:59:39 UTC", description:   "Make print_amount an optional option with a default of 1000", pr_number:                         4883, scopes: ["blackhole sink"], type:                                   "fix", breaking_change:         false, author: "James Turnbull", files_count:        2, insertions_count:   13, deletions_count:   3},
		{sha: "aade9e6e5c236f454c010e5e7366722ffa9b93b8", date: "2020-11-06 19:50:53 UTC", description:   "Support template syntax in hostname and tags field", pr_number:                                  4884, scopes: ["logdna sink"], type:                                      "enhancement", breaking_change: false, author: "Do Duy", files_count:                4, insertions_count:   247, deletions_count:  51},
		{sha: "94efee7c92b5fb208dbf39214ddd997b07226764", date: "2020-11-07 03:59:31 UTC", description:   "Fix passing --push arg at build-docker.sh", pr_number:                                           4900, scopes: ["ci"], type:                                               "chore", breaking_change:       false, author: "MOZGIII", files_count:               1, insertions_count:   6, deletions_count:    1},
		{sha: "f58ed206591544815ddf1416adcb0fa657a1d413", date: "2020-11-06 20:09:43 UTC", description:   "Add TLS and authentication options", pr_number:                                                  4881, scopes: ["prometheus source"], type:                                "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         2, insertions_count:   85, deletions_count:   4},
		{sha: "84010c6ff3595c932a622b76d2dfb006f7609c36", date: "2020-11-06 23:00:04 UTC", description:   "Add initial setup for metrics docs in Cue", pr_number:                                           4892, scopes: ["config"], type:                                           "chore", breaking_change:       false, author: "Luc Perkins", files_count:           4, insertions_count:   94, deletions_count:   2},
		{sha: "a58b8191f884051aa578761d90ff16c6385de505", date: "2020-11-10 01:56:26 UTC", description:   "dont use flatten for logs config fields", pr_number:                                             4924, scopes: ["humio_metrics sink"], type:                               "fix", breaking_change:         false, author: "FungusHumungus", files_count:        3, insertions_count:   110, deletions_count:  36},
		{sha: "ab520b1589e5100ae9aba1185e423bd8c03c5355", date: "2020-11-09 20:58:46 UTC", description:   "Prometheus remote_write", pr_number:                                                             4856, scopes: ["new sink"], type:                                         "feat", breaking_change:        false, author: "Bruce Guenter", files_count:         23, insertions_count:  1577, deletions_count: 746},
		{sha: "74067f309ddaec7dec8ae0c494cb000eadfd5439", date: "2020-11-10 00:24:28 UTC", description:   "Update WASM transform to implement TaskTransform", pr_number:                                    4934, scopes: ["wasm transform"], type:                                   "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:         1, insertions_count:   126, deletions_count:  122},
		{sha: "95ce5c05dac8bea5cfe0f8998fed80086557b079", date: "2020-11-10 06:02:48 UTC", description:   "`vector top`, release candidate", pr_number:                                                     4886, scopes: ["observability"], type:                                    "feat", breaking_change:        false, author: "Lee Benson", files_count:            29, insertions_count:  1590, deletions_count: 525},
		{sha: "a40a9529feec9bfccdd3391819adc3b20fb180d5", date: "2020-11-11 01:52:14 UTC", description:   "Add configurable endpoint", pr_number:                                                           4873, scopes: ["gcp_pubsub sink"], type:                                  "enhancement", breaking_change: false, author: "rpaaron", files_count:               2, insertions_count:   27, deletions_count:   9},
		{sha: "a228a28e4fb5cad26ad5165a6832e570d41a6a72", date: "2020-11-10 22:22:11 UTC", description:   "Kind/type for `vector top`", pr_number:                                                          4928, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Lee Benson", files_count:            7, insertions_count:   140, deletions_count:  42},
		{sha: "c45fa68f03082f1b4c3d33951b27d516d7a1e10c", date: "2020-11-11 07:28:11 UTC", description:   "Remove hardcoded configs in Helm chart", pr_number:                                              4938, scopes: ["kubernetes platform"], type:                              "chore", breaking_change:       false, author: "MOZGIII", files_count:               5, insertions_count:   22, deletions_count:   14},
		{sha: "30dc1b8176fec39626189a1552287875a7c099d7", date: "2020-11-11 03:43:43 UTC", description:   "`aws_s3` source", pr_number:                                                                     4779, scopes: ["new source"], type:                                       "feat", breaking_change:        false, author: "Jesse Szwedko", files_count:         15, insertions_count:  1628, deletions_count: 159},
		{sha: "ee6c24517b8dca2e664f20b42734b7fc368843fc", date: "2020-11-11 08:16:04 UTC", description:   "Fix markdown errors", pr_number:                                                                 4954, scopes: ["rfcs"], type:                                             "fix", breaking_change:         false, author: "James Turnbull", files_count:        1, insertions_count:   6, deletions_count:    4},
		{sha: "4b82090ce4900ecd837a2196c7527210a199fa46", date: "2020-11-11 20:21:00 UTC", description:   "Add span to future", pr_number:                                                                  4944, scopes: ["http source"], type:                                      "fix", breaking_change:         false, author: "Do Duy", files_count:                1, insertions_count:   78, deletions_count:   72},
		{sha: "45b744c2bb89ea7824be318ab680d784883aa5b1", date: "2020-11-11 20:21:36 UTC", description:   "Restart journalctl on errors, save checkpoint on shutdown", pr_number:                           4836, scopes: ["journald source"], type:                                  "enhancement", breaking_change: false, author: "Do Duy", files_count:                1, insertions_count:   270, deletions_count:  242},
		{sha: "0b2c8f48756c8ca07800821f3065618c0c9b173c", date: "2020-11-11 09:10:14 UTC", description:   "(key/value) kv parser", pr_number:                                                               3284, scopes: ["new transform"], type:                                    "feat", breaking_change:        false, author: "Nick Hagianis", files_count:         10, insertions_count:  727, deletions_count:  2},
		{sha: "ae42a8dd68c4afdbb30592bdb69781e8f51cf283", date: "2020-11-12 04:39:16 UTC", description:   "make scrape interval configurable", pr_number:                                                   4998, scopes: ["sources"], type:                                          "enhancement", breaking_change: false, author: "Daniel Jin", files_count:            1, insertions_count:   24, deletions_count:   5},
		{sha: "63ee6d486ab5db57548060eaacbed971fd9b7136", date: "2020-11-12 16:54:56 UTC", description:   "Humanized formatting for `vector top` metrics", pr_number:                                       4945, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Lee Benson", files_count:            6, insertions_count:   182, deletions_count:  50},
		{sha: "d0b414e7839524210e6c550dadd74323774008ec", date: "2020-11-12 16:55:46 UTC", description:   "Batch events processed total", pr_number:                                                        4958, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Lee Benson", files_count:            1, insertions_count:   48, deletions_count:   23},
		{sha: "63acc541c1b59bf46892517dcc0d5c6078ca2087", date: "2020-11-12 16:23:16 UTC", description:   "Added batch subscriptions for component bytes and errors", pr_number:                            5002, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Steve Hall", files_count:            2, insertions_count:   138, deletions_count:  0},
		{sha: "7c72f888871a808e1da01c3a67df1607434d1f82", date: "2020-11-12 19:28:34 UTC", description:   "Document `vector top` CLI", pr_number:                                                           4907, scopes: ["config"], type:                                           "chore", breaking_change:       false, author: "Luc Perkins", files_count:           1, insertions_count:   46, deletions_count:   2},
		{sha: "2dc1869a90036c076d6f7ffb9a15eb46180eed19", date: "2020-11-13 17:21:31 UTC", description:   "API batch support + tests", pr_number:                                                           5004, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Lee Benson", files_count:            4, insertions_count:   235, deletions_count:  4},
		{sha: "23d0702f529dfda66ba723a871272e6e2599a32d", date: "2020-11-14 01:09:02 UTC", description:   "API version + hostname queries", pr_number:                                                      5018, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Lee Benson", files_count:            3, insertions_count:   84, deletions_count:   0},
		{sha: "d06fae42d5f05faf7cc9717f93e9b860704ece1f", date: "2020-11-13 20:53:19 UTC", description:   "Add PodIPs into Pod Metadata events", pr_number:                                                 4887, scopes: ["kubernetes_logs source"], type:                           "enhancement", breaking_change: false, author: "Ian Henry", files_count:             8, insertions_count:   224, deletions_count:  6},
		{sha: "eaaab650d81999aeaf88b03891a83082b31a19ea", date: "2020-11-13 21:31:35 UTC", description:   "More debug info on more HTTP requests", pr_number:                                               4999, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Bruce Guenter", files_count:         26, insertions_count:  136, deletions_count:  84},
		{sha: "196aeec85cd9e703b2385b06344dfa74e180d6c4", date: "2020-11-14 04:40:29 UTC", description:   "add internal option to ignore missing files", pr_number:                                         5026, scopes: ["file source"], type:                                      "enhancement", breaking_change: false, author: "Luke Steensen", files_count:         4, insertions_count:   56, deletions_count:   29},
		{sha: "b5e2ceaa74f50d87f810ac02fd2295eb3b407150", date: "2020-11-15 11:59:41 UTC", description:   "Edited a few vector top error messages", pr_number:                                              5034, scopes: ["cli"], type:                                              "enhancement", breaking_change: false, author: "James Turnbull", files_count:        1, insertions_count:   3, deletions_count:    3},
		{sha: "b8f83d73bb088269c98525fdef28962b222da983", date: "2020-11-16 07:42:03 UTC", description:   "New `nats` sink", pr_number:                                                                     3605, scopes: ["new sink"], type:                                         "feat", breaking_change:        false, author: "Eric Lee", files_count:              10, insertions_count:  764, deletions_count:  7},
		{sha: "e2d01b83f92a50e7d0e9e48a9f235f1007a2b305", date: "2020-11-16 21:59:54 UTC", description:   "compile-time program result type checking", pr_number:                                           4902, scopes: ["remap"], type:                                            "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            65, insertions_count:  3822, deletions_count: 299},
		{sha: "f06c01f218f75ee1c7b610ac55523d5fcf823d8a", date: "2020-11-17 04:46:57 UTC", description:   "support enum variants for function arguments", pr_number:                                        5008, scopes: ["remap"], type:                                            "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            11, insertions_count:  431, deletions_count:  270},
		{sha: "f5f2031f9a51dd39291706b5b0e0982ed9e78191", date: "2020-11-16 21:51:33 UTC", description:   "Fix fanout remove-while-iterating bug", pr_number:                                               5027, scopes: ["topology"], type:                                         "fix", breaking_change:         false, author: "Bruce Guenter", files_count:         2, insertions_count:   172, deletions_count:  99},
		{sha: "5d06064413da748247bc6a92784125388c4089b7", date: "2020-11-17 08:51:17 UTC", description:   "use path arguments for `del` and `only_field` functions", pr_number:                             5015, scopes: ["remap"], type:                                            "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            9, insertions_count:   151, deletions_count:  170},
		{sha: "22ac9f9154b887e5c0587b41c836c1617a183684", date: "2020-11-17 05:00:04 UTC", description:   "Renamed docker source to docker_logs", pr_number:                                                5039, scopes: ["docker source"], type:                                    "enhancement", breaking_change: false, author: "James Turnbull", files_count:        10, insertions_count:  132, deletions_count:  101},
		{sha: "442615879c35d30a55d03e30160ecd5965bd4b4c", date: "2020-11-18 00:51:08 UTC", description:   "expressions no longer return an option", pr_number:                                              5053, scopes: ["remap"], type:                                            "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            52, insertions_count:  359, deletions_count:  609},
		{sha: "931d97dc7579aa2ba9198b91c121ac81df507cca", date: "2020-11-18 07:19:39 UTC", description:   "Fix JSON compression", pr_number:                                                                5050, scopes: ["http sink"], type:                                        "fix", breaking_change:         false, author: "Do Duy", files_count:                1, insertions_count:   67, deletions_count:   4},
		{sha: "06cf78868835c2c33e0d859402c5b2984d7e075b", date: "2020-11-18 02:24:35 UTC", description:   "Rename `version` -> `versionString` in GraphQL schema", pr_number:                               5074, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Lee Benson", files_count:            6, insertions_count:   53, deletions_count:   4},
		{sha: "6bce5ac9d79a7662e97adce386ea93c8888f3bcb", date: "2020-11-17 22:20:48 UTC", description:   "Flush messages", pr_number:                                                                      5069, scopes: ["splunk_hec source"], type:                                "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:         2, insertions_count:   38, deletions_count:   17},
		{sha: "c5fb3a1b12c9f51411784307f8c7ddd2649026c6", date: "2020-11-18 00:07:38 UTC", description:   "Initial `aws_ecs_metrics` source", pr_number:                                                    4698, scopes: ["new source"], type:                                       "feat", breaking_change:        false, author: "Daniel Jin", files_count:            9, insertions_count:   2017, deletions_count: 2},
		{sha: "287a4d8fddf6e60f922492e75060d5722c58fb8a", date: "2020-11-18 19:24:58 UTC", description:   "Initial `aws_sqs` sink", pr_number:                                                              4675, scopes: ["new sink"], type:                                         "feat", breaking_change:        false, author: "Kirill Fomichev", files_count:       9, insertions_count:   568, deletions_count:  1},
		{sha: "fcb6e39e2fc9686fdd25df212bb411f61b2533b4", date: "2020-11-18 17:55:26 UTC", description:   "undefined path or variable return null", pr_number:                                              5056, scopes: ["remap"], type:                                            "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            31, insertions_count:  46, deletions_count:   196},
		{sha: "a68ea1f4a0ffd6aba5abdc24a5237fd23dcea9c5", date: "2020-11-18 18:54:52 UTC", description:   "Add I/O (throughput) columns to `vector top`", pr_number:                                        5016, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Lee Benson", files_count:            21, insertions_count:  698, deletions_count:  371},
		{sha: "c357da46928b23db5016d6b5da17b44c49fb73e3", date: "2020-11-18 19:54:00 UTC", description:   "Flush sinks in a couple of more places", pr_number:                                              5082, scopes: ["topology"], type:                                         "fix", breaking_change:         false, author: "Jesse Szwedko", files_count:         2, insertions_count:   34, deletions_count:   24},
		{sha: "fcd26bd84484168000603bbfe0713614608653cd", date: "2020-11-19 19:30:17 UTC", description:   "Fix flaky `timely_shutdown_docker` test", pr_number:                                             5101, scopes: ["tests"], type:                                            "chore", breaking_change:       false, author: "Bruce Guenter", files_count:         1, insertions_count:   1, deletions_count:    1},
		{sha: "1e441e969dc8f63ae40216d0f2a2acc422076c56", date: "2020-11-20 05:32:21 UTC", description:   "add RUSTSEC-2020-0071 to deny.toml", pr_number:                                                  5117, scopes: ["ci"], type:                                               "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:       1, insertions_count:   8, deletions_count:    1},
		{sha: "80587a2956383582708344e70cc425f58f9c933b", date: "2020-11-20 00:41:39 UTC", description:   "Fix output timestamp", pr_number:                                                                5118, scopes: ["prometheus sink"], type:                                  "fix", breaking_change:         false, author: "Bruce Guenter", files_count:         3, insertions_count:   86, deletions_count:   18},
		{sha: "c909c42292db7804a55d2635825724d33f80314e", date: "2020-11-20 02:02:25 UTC", description:   "Fix flaky `configuration_path_recomputed` test", pr_number:                                      5128, scopes: ["tests"], type:                                            "chore", breaking_change:       false, author: "Bruce Guenter", files_count:         1, insertions_count:   8, deletions_count:    4},
		{sha: "c88040b9f6d29d83987fb0e536562b41888c8e96", date: "2020-11-20 04:47:35 UTC", description:   "clean up file format and fix features", pr_number:                                               5133, scopes: ["file source"], type:                                      "fix", breaking_change:         false, author: "Luke Steensen", files_count:         3, insertions_count:   3, deletions_count:    1},
		{sha: "37d5e73d9459eb6760ed0403c0df9b5fdc6c4555", date: "2020-11-20 07:49:27 UTC", description:   "Fix test failure for empty metrics", pr_number:                                                  5134, scopes: ["host_metrics source"], type:                              "chore", breaking_change:       false, author: "Bruce Guenter", files_count:         1, insertions_count:   44, deletions_count:   39},
		{sha: "f1d162d44f963fdb79602ef2167c2a3d6eceb234", date: "2020-11-21 04:03:15 UTC", description:   "Expire checkpoints", pr_number:                                                                  5146, scopes: ["file source"], type:                                      "enhancement", breaking_change: false, author: "Luke Steensen", files_count:         4, insertions_count:   91, deletions_count:   16},
		{sha: "31fb077080696539fab3fa7299a12e3a143e0aae", date: "2020-11-21 05:20:31 UTC", description:   "Include kafka metadata as optional keys", pr_number:                                             5153, scopes: ["kafka source"], type:                                     "enhancement", breaking_change: false, author: "Spencer Gilbert", files_count:       2, insertions_count:   66, deletions_count:   4},
		{sha: "68f5907fe78f1c77294dec53588ad2b53d05e536", date: "2020-11-22 03:05:32 UTC", description:   "Add ingestion timestamp", pr_number:                                                             4795, scopes: ["kubernetes_logs source"], type:                           "feat", breaking_change:        false, author: "MOZGIII", files_count:               1, insertions_count:   18, deletions_count:   2},
		{sha: "58d6e8ffa9f1fe7f5fdf31359435c8bc9f9e26c2", date: "2020-11-23 03:02:01 UTC", description:   "Add rating by `index`", pr_number:                                                               4918, scopes: ["sampler transform"], type:                                "enhancement", breaking_change: true, author:  "Kruno Tomola Fabro", files_count:    6, insertions_count:   178, deletions_count:  104},
		{sha: "ae7e0ce06af1b6a3165c7d5e5f4994055ac424ab", date: "2020-11-23 19:38:05 UTC", description:   "Support basic-auth credentials in endpoint configuation", pr_number:                             5095, scopes: ["elasticsearch sink"], type:                               "enhancement", breaking_change: false, author: "Do Duy", files_count:                5, insertions_count:   147, deletions_count:  36},
		{sha: "cf8dee9dbc65c0c2e3232b60d82788018268f932", date: "2020-11-23 19:01:21 UTC", description:   " Allow querying transform outputs on transform components", pr_number:                           5171, scopes: ["api"], type:                                              "enhancement", breaking_change: false, author: "Steve Hall", files_count:            2, insertions_count:   32, deletions_count:   0},
		{sha: "44d2945c9cdc03f8ee084e4228be42acfcd19096", date: "2020-11-24 06:41:50 UTC", description:   "Expose internal metrics cardinality as a internal metric counter", pr_number:                    4615, scopes: ["metrics"], type:                                          "enhancement", breaking_change: false, author: "MOZGIII", files_count:               1, insertions_count:   92, deletions_count:   10},
		{sha: "4ad53dd9a01a40aecfaddfc2c9e865e39d655fa8", date: "2020-11-24 02:32:45 UTC", description:   "Upgrade bollard to 0.9 to close#4169", pr_number:                                                5189, scopes: ["docker_logs source"], type:                               "chore", breaking_change:       false, author: "James Turnbull", files_count:        4, insertions_count:   30, deletions_count:   17},
		{sha: "18b9c0fade267e4833fa62067ba061ca84f35801", date: "2020-11-25 00:10:23 UTC", description:   "Handle config warnings for `validate` command ", pr_number:                                      5044, scopes: ["cli"], type:                                              "fix", breaking_change:         false, author: "Kruno Tomola Fabro", files_count:    11, insertions_count:  90, deletions_count:   64},
		{sha: "3cbb55bacc3f2df07e192a78fc44a62c8e2bf258", date: "2020-11-25 18:53:27 UTC", description:   "Add test for component links", pr_number:                                                        5218, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Steve Hall", files_count:            4, insertions_count:   138, deletions_count:  1},
		{sha: "0d4d66fedcc7eb13e0cfca773d30a91d34b25eb4", date: "2020-11-26 06:46:35 UTC", description:   "Initial `nginx_metrics` source implementation", pr_number:                                       5209, scopes: ["new source"], type:                                       "feat", breaking_change:        false, author: "Kirill Fomichev", files_count:       19, insertions_count:  736, deletions_count:  29},
		{sha: "89ae91c1da0cbb789c4ae429172632d66f7252d5", date: "2020-11-26 18:47:24 UTC", description:   "Allow tenant_id to be templatable on loki sink", pr_number:                                      5204, scopes: ["loki sink"], type:                                        "enhancement", breaking_change: false, author: "Do Duy", files_count:                2, insertions_count:   110, deletions_count:  20},
		{sha: "d9c1e6de6633b8d5d100bc839bf1d23ca26e8d28", date: "2020-11-26 21:31:44 UTC", description:   "Fix incorrect _IA storage class names", pr_number:                                               5245, scopes: ["aws_s3 sink"], type:                                      "fix", breaking_change:         false, author: "Bruce Guenter", files_count:         1, insertions_count:   23, deletions_count:   1},
		{sha: "fb4119e11999b1439669c6a43527200050dc57c6", date: "2020-11-27 05:36:15 UTC", description:   "improve arithmetic type checking", pr_number:                                                    5059, scopes: ["remap"], type:                                            "enhancement", breaking_change: false, author: "Jean Mertz", files_count:            4, insertions_count:   53, deletions_count:   38},
		{sha: "79020644871c64d6b48b4d01260fdabf260e264a", date: "2020-11-27 05:43:24 UTC", description:   "support resolving program to \"any\" value", pr_number:                                          5060, scopes: ["remap"], type:                                            "feat", breaking_change:        false, author: "Jean Mertz", files_count:            3, insertions_count:   129, deletions_count:  49},
		{sha: "41a9594c8e59dfb42a76b3c62d4a967b4ed00dfe", date: "2020-11-27 06:08:37 UTC", description:   "support query/assignment of object root", pr_number:                                             5064, scopes: ["remap"], type:                                            "feat", breaking_change:        false, author: "Jean Mertz", files_count:            7, insertions_count:   70, deletions_count:   15},
		{sha: "1abf8a4dbdd94eb3148f517d76bd7bc356faedd8", date: "2020-11-27 10:11:53 UTC", description:   "add parse_grok remap function", pr_number:                                                       4992, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "FungusHumungus", files_count:        7, insertions_count:   292, deletions_count:  16},
		{sha: "e15fb91771955896669f76c27fe7edafefb13dfe", date: "2020-08-01 06:25:15 UTC", description:   "pip3 installed binaries", pr_number:                                                             3287, scopes: ["ci"], type:                                               "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:       1, insertions_count:   1, deletions_count:    0},
		{sha: "26e302b7ff3b36edef565dd45a70de71f1b878b4", date: "2020-08-04 05:12:22 UTC", description:   "color in not tty for tests", pr_number:                                                          3324, scopes: ["tests"], type:                                            "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:       1, insertions_count:   9, deletions_count:    8},
		{sha: "9e5284a7de02f90374ddc44238484d123cac92c6", date: "2020-08-05 02:32:14 UTC", description:   "conditional compilation for unix source", pr_number:                                             3298, scopes: ["ci"], type:                                               "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:       3, insertions_count:   5, deletions_count:    5},
		{sha: "b8403c5eea29ff51df572f7a8c2085d682768744", date: "2020-08-15 07:27:52 UTC", description:   "doc test in event/metric", pr_number:                                                            3461, scopes: ["tests"], type:                                            "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:       1, insertions_count:   1, deletions_count:    1},
		{sha: "5213f38a70f093d6bb41711bc7da10423704bcf4", date: "2020-08-25 23:41:24 UTC", description:   "Fixed language on code fence in CONTRIBUTING.md", pr_number:                                     3560, scopes: ["external docs"], type:                                    "chore", breaking_change:       false, author: "James Turnbull", files_count:        1, insertions_count:   1, deletions_count:    1},
		{sha: "63bdb57cb11b1f71cb21d1e9d0f9f4087ed00003", date: "2020-08-26 02:29:19 UTC", description:   "Remove quiet verbose options as environment variables to stop test-shutdown failing", pr_number: 3559, scopes: ["ci"], type:                                               "chore", breaking_change:       false, author: "James Turnbull", files_count:        2, insertions_count:   2, deletions_count:    14},
		{sha: "aa5d9641f1f86308fbfdd6ff2c30b89a67c17e0e", date: "2020-08-28 04:37:39 UTC", description:   "Rewrite LineAgg to allow passing context data and be more memory efficient", pr_number:          3561, scopes: ["file source"], type:                                      "perf", breaking_change:        false, author: "MOZGIII", files_count:               2, insertions_count:   114, deletions_count:  64},
		{sha: "ef722c3e092537984675235af98c9f5f4558617c", date: "2020-09-10 01:55:16 UTC", description:   "remove unused imports", pr_number:                                                               3776, scopes: [], type:                                                   "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:       3, insertions_count:   4, deletions_count:    8},
		{sha: "5b48256ef5a3d9cfa831f0a205e9079b1f3c17f0", date: "2020-09-18 05:31:03 UTC", description:   "Add missing inventory::submit", pr_number:                                                       3988, scopes: ["sinks"], type:                                            "fix", breaking_change:         false, author: "Do Duy", files_count:                7, insertions_count:   33, deletions_count:   9},
		{sha: "b2125418b19c031e68ce0da804ff08ec24117f1c", date: "2020-09-18 05:27:22 UTC", description:   "remove failing remap behavior test", pr_number:                                                  4004, scopes: ["tests"], type:                                            "chore", breaking_change:       false, author: "Jean Mertz", files_count:            1, insertions_count:   0, deletions_count:    1},
		{sha: "5fbcc587f2cc60894357ee5e78ce62db58f0f1f5", date: "2020-09-22 05:27:13 UTC", description:   "Wrong inventory::submit", pr_number:                                                             4033, scopes: [], type:                                                   "chore", breaking_change:       false, author: "Do Duy", files_count:                1, insertions_count:   2, deletions_count:    2},
		{sha: "b031eadb3bebae98a418a11b245cd59a7f32c2ad", date: "2020-09-30 18:24:05 UTC", description:   "A new internal lookup", pr_number:                                                               4066, scopes: ["data model"], type:                                       "perf", breaking_change:        false, author: "Ana Hobden", files_count:            41, insertions_count:  983, deletions_count:  214},
		{sha: "50fe38019570b67362584abbe3342acc6bab0217", date: "2020-10-10 02:42:23 UTC", description:   "Add missing use", pr_number:                                                                     4475, scopes: ["tests"], type:                                            "chore", breaking_change:       false, author: "Kruno Tomola Fabro", files_count:    1, insertions_count:   1, deletions_count:    0},
		{sha: "75d2e3a5d42590a4d39606cf98acd07c8ea1d78c", date: "2020-10-12 06:25:25 UTC", description:   "logdna clippy and prometheus skipped field", pr_number:                                          4508, scopes: [], type:                                                   "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:       2, insertions_count:   5, deletions_count:    1},
		{sha: "07176dacb6a27bd97bd5f72216274bace64ffd69", date: "2020-10-14 23:40:52 UTC", description:   "Removed a stray Atom that snuck back in", pr_number:                                             4566, scopes: [], type:                                                   "chore", breaking_change:       false, author: "James Turnbull", files_count:        1, insertions_count:   1, deletions_count:    1},
		{sha: "d99813e90c9668d4cfcf8d25abc329ed8eff4fb0", date: "2020-10-22 16:02:35 UTC", description:   "Generate valid config for all components", pr_number:                                            4636, scopes: [], type:                                                   "chore", breaking_change:       false, author: "Do Duy", files_count:                52, insertions_count:  791, deletions_count:  102},
		{sha: "7e0c2664e32a2422b23eb854bb8373d963106450", date: "2020-10-22 23:49:34 UTC", description:   "Renamed mongo metrics to new naming standards", pr_number:                                       4699, scopes: ["mongodb_metrics source"], type:                           "enhancement", breaking_change: false, author: "James Turnbull", files_count:        1, insertions_count:   3, deletions_count:    9},
		{sha: "c3ed69f11520b32e8dd28fe875a6785a5826447b", date: "2020-10-25 23:21:59 UTC", description:   "Add `ConnectionOpen` gauge", pr_number:                                                          4681, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    6, insertions_count:   174, deletions_count:  15},
		{sha: "38f904ce0d08fad60c8297f74fe7890eed0d79f0", date: "2020-10-27 02:22:19 UTC", description:   "make instrumentation only on trace", pr_number:                                                  4765, scopes: ["observability"], type:                                    "fix", breaking_change:         false, author: "Ana Hobden", files_count:            2, insertions_count:   21, deletions_count:   21},
		{sha: "b46e281459607db52c4779c9362108ae717ff47c", date: "2020-11-05 01:10:54 UTC", description:   "Use `namespace` field in metric sinks", pr_number:                                               4806, scopes: ["data model"], type:                                       "enhancement", breaking_change: true, author:  "Kruno Tomola Fabro", files_count:    21, insertions_count:  396, deletions_count:  308},
		{sha: "a87b132e6c00c56467a261a42a52be564962dc54", date: "2020-11-05 02:01:22 UTC", description:   "Use `namespace` field in metric sources", pr_number:                                             4833, scopes: ["data model"], type:                                       "enhancement", breaking_change: true, author:  "Kruno Tomola Fabro", files_count:    8, insertions_count:   323, deletions_count:  321},
		{sha: "bc2533d07c6c2b5828040819f625289491205ac4", date: "2020-11-13 11:31:46 UTC", description:   "Prometheus uses cumulative histogram", pr_number:                                                5001, scopes: ["prometheus sink"], type:                                  "fix", breaking_change:         false, author: "Do Duy", files_count:                2, insertions_count:   23, deletions_count:   7},
		{sha: "6d90a084e978ffb638fb3d3cbc105f7e0c71f479", date: "2020-11-16 09:11:24 UTC", description:   "Extend `Resource` to sources ", pr_number:                                                       4996, scopes: ["shutdown"], type:                                         "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    16, insertions_count:  432, deletions_count:  121},
		{sha: "2d4fa207f460de5f1c6f08bad05bd0c3aa3a36d1", date: "2020-11-18 02:28:58 UTC", description:   "Beautify reports of conflicting `Resource` usage", pr_number:                                    5048, scopes: ["cli"], type:                                              "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    4, insertions_count:   54, deletions_count:   24},
		{sha: "e016c713b5c37f9ef5f22f498441c6e6e2827354", date: "2020-11-19 03:31:59 UTC", description:   "add _total suffix to events", pr_number:                                                         5098, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Kirill Fomichev", files_count:       5, insertions_count:   18, deletions_count:   18},
		{sha: "e769bccd78bbfa3098282b85567dad0e4f72763e", date: "2020-11-21 02:07:48 UTC", description:   "Emit `FileOpen` in `file` sink and source", pr_number:                                           4922, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Kruno Tomola Fabro", files_count:    7, insertions_count:   314, deletions_count:  259},
		{sha: "803c68c031e5872876e1167c428cd41358123d64", date: "2020-11-24 01:27:59 UTC", description:   "Incorrect Log Level Message", pr_number:                                                         5183, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Do Duy", files_count:                1, insertions_count:   13, deletions_count:   17},
		{sha: "8c8725c1e4c7c2a2e7b03ebf764e1112d9c63d7d", date: "2020-11-28 01:46:05 UTC", description:   "add ip address remap functions", pr_number:                                                      5145, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "FungusHumungus", files_count:        12, insertions_count:  868, deletions_count:  1},
		{sha: "24155d4450744b2b2110446163cbd050df08685e", date: "2020-11-28 02:07:03 UTC", description:   "Handle unexpected errors in ARC controller", pr_number:                                          5267, scopes: ["networking"], type:                                       "fix", breaking_change:         false, author: "Bruce Guenter", files_count:         1, insertions_count:   18, deletions_count:   7},
		{sha: "ba910afc6189d3d6e5c2a7844023ee53a64a624c", date: "2020-11-28 03:39:11 UTC", description:   "New prometheus_remote_write source", pr_number:                                                  5144, scopes: ["new source"], type:                                       "feat", breaking_change:        false, author: "Bruce Guenter", files_count:         26, insertions_count:  981, deletions_count:  504},
		{sha: "295a630b816aa19e996ac42bebeb93369adae4c2", date: "2020-11-28 16:55:20 UTC", description:   "Add `exists` remap function", pr_number:                                                         5195, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "FungusHumungus", files_count:        6, insertions_count:   162, deletions_count:  1},
		{sha: "9e51f2e3795d08598118c7bb6bf475b352b172b1", date: "2020-11-29 07:21:46 UTC", description:   "Allow JSON and YAML config formats in addition to TOML", pr_number:                              5005, scopes: ["config"], type:                                           "enhancement", breaking_change: false, author: "MOZGIII", files_count:               22, insertions_count:  792, deletions_count:  189},
		{sha: "9bddcb233a6ec7814e685d6060f7e0ffd37d71ad", date: "2020-11-30 01:35:51 UTC", description:   "Add compact remap function", pr_number:                                                          5231, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "FungusHumungus", files_count:        5, insertions_count:   525, deletions_count:  0},
		{sha: "84aebc078678549e1933d0c6c6505f3f464a6f40", date: "2020-12-01 04:44:31 UTC", description:   "fix integration tests list", pr_number:                                                          5293, scopes: ["ci", "tests"], type:                                      "chore", breaking_change:       false, author: "Kirill Fomichev", files_count:       2, insertions_count:   27, deletions_count:   9},
		{sha: "fdb77ff020c7f0487c7bd3d39d78c5f8a56ef2ac", date: "2020-11-30 22:36:19 UTC", description:   "Update release Windows task", pr_number:                                                         5295, scopes: ["ci"], type:                                               "fix", breaking_change:         false, author: "James Turnbull", files_count:        1, insertions_count:   39, deletions_count:   6},
		{sha: "dfc18c17c149a5e7b1a7cd0697ef2b7085d99272", date: "2020-12-01 00:01:49 UTC", description:   "Update release-docker task", pr_number:                                                          5299, scopes: ["ci"], type:                                               "fix", breaking_change:         false, author: "James Turnbull", files_count:        1, insertions_count:   3, deletions_count:    2},
		{sha: "018091fc4b7c569d8d9b32c3d3d06d279eca2f87", date: "2020-12-01 05:49:44 UTC", description:   "add assert remap function", pr_number:                                                           5073, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "FungusHumungus", files_count:        6, insertions_count:   199, deletions_count:  0},
		{sha: "529581de69d431c9d0cbc59d152b5858d479e68f", date: "2020-12-01 15:43:25 UTC", description:   "Enable TLS subscription connections in vector top", pr_number:                                   5296, scopes: ["observability"], type:                                    "enhancement", breaking_change: false, author: "Steve Hall", files_count:            3, insertions_count:   6, deletions_count:    3},
		{sha: "12a9cc325f1f6c86ab802f3f6deda29079c857bc", date: "2020-12-02 01:26:57 UTC", description:   "Add missing remap functions", pr_number:                                                         5312, scopes: ["remap transform"], type:                                  "feat", breaking_change:        false, author: "FungusHumungus", files_count:        9, insertions_count:   758, deletions_count:  22},
		{sha: "c8352140d597c6623b5c3486d39a27b9191c204e", date: "2020-12-01 20:57:20 UTC", description:   "Change packages to have full versions and architectures", pr_number:                             5303, scopes: ["ci"], type:                                               "fix", breaking_change:         false, author: "James Turnbull", files_count:        20, insertions_count:  274, deletions_count:  189},
		{sha: "10e42732a6f1b14d09208d5110634e9718d4cee9", date: "2020-12-02 03:28:19 UTC", description:   "introduce encoding schema and pulsar avro schema", pr_number:                                    5021, scopes: ["pulsar sink"], type:                                      "enhancement", breaking_change: false, author: "Alexandre DUVAL", files_count:       10, insertions_count:  284, deletions_count:  16},
	]
}
