<p align="center">
  <strong>
    <a href="https://vector.dev">Website<a/>&nbsp;&nbsp;&bull;&nbsp;&nbsp;<a href="https://vector.dev/docs/">Docs<a/>&nbsp;&nbsp;&bull;&nbsp;&nbsp;<a href="https://vector.dev/community/">Community<a/>&nbsp;&nbsp;&bull;&nbsp;&nbsp;<a href="https://github.com/timberio/vector">Github<a/>
  </strong>
</p>

---

<p align="center">
  <img src="https://res.cloudinary.com/timber/image/upload/v1561214425/vector_diagram_w26yw3.svg" alt="Vector">
</p>

Vector is an [open-source][urls.vector_repo] utility for building observability
pipelines. [Collect][docs.sources], [transform][docs.transforms], and
[route][docs.sinks] log, metrics and events with one simple tool.

Built in [Rust][urls.rust], Vector places high-value on
[performance][pages.index#performance], [correctness][pages.index#correctness],
and [operator friendliness][docs.administration]. It compiles to a single static
binary and is designed to be [deployed][docs.deployment] across your entire
infrastructure, serving as a light-weight [daemon][docs.strategies#daemon],
[sidecar][docs.strategies#sidecar], or highly efficient
[service][docs.strategies#service]. Take back ownership and control of your
observability data with Vector.

<!--
    THIS FILE IS AUTOGENERATED!

    To make changes please edit the template located at:

    distribution/docker/README.md.erb
-->

## Configuring

As shown above, you can pass a custom
[Vector configuration file][docs.setup.configuration] via the `-c` flag. You'll want
to do this since the
[default `/etc/vector/vector.toml` configuration file][urls.default_configuration]
doesn't do anything.

## Deploying

How you deploy Vector is largely dependent on your use case and environment.
Please see the [deployment section][docs.deployment] for more info on how to
deploy Vector.

## Updating

Simply run with newer version in the tag:

```bash
docker pull timberio/vector:X.X.X-alpine && \
  docker run timberio/vector:X.X.X-alpine
```

See the [variants](#variants) and [versions](#versions) sections to choose
the appropriate image for your use case.

## Images

### Variants

#### alpine

This image is based on the [`alpine` Docker image][urls.docker_alpine], which is
a Linux distribution built around musl libc and BusyBox. It is considerably
smaller in size than other Docker images and statically links libraries. This
is the image we recommend due to it's small size and reliability.

```bash
docker run timberio/vector:0.10.0-alpine
```

#### debian

This image is based on the [`debian-slim` image][urls.docker_debian],
which is a smaller, more compact variant of the [`debian` image][urls.docker_debian].

```bash
docker run timberio/vector:0.10.0-debian
```

#### distroless-*

[Distroless][urls.distroless] is a base docker image based on either stripping down an OS, or building
the key parts from scratch. It contains only the barest of essentials for running
a static or dynamically linked binary.

distroless-static uses the statically linked musl x86 build
distroless-libc uses a dynamically linked build which leverages
libc provided by distroless/base/cc

### Architectures

Vector's images are multi-arch and support the
x86_64, ARM64, and ARMv7 architectures.
Docker handles this transparently for you.

### Versions

Vector's Docker images can be downloaded with the following tags. Note that
Vector maintains special tags that are automatically updated whenever Vector is
[released][urls.vector_releases]:

| Version          | URL                                                      |
|:-----------------|:---------------------------------------------------------|
| Latest major     | `timberio/vector:latest-alpine`               |
| Latest minor     | `timberio/vector:<MAJOR>.X-alpine`            |
| Latest patch     | `timberio/vector:<MAJOR.MINOR>.X-alpine`      |
| Specific version | `timberio/vector:<MAJOR.MINOR.PATCH>-alpine`  |
| Latest nightly   | `timberio/vector:nightly-alpine`              |
| Specific nightly | `timberio/vector:nightly-<YYYY-MM-DD>-alpine` |

### Source Files

Vector's Docker source files are located
[in it's Github repo][urls.vector_docker_source_files].

[docs.administration]: https://vector.dev/docs/administration/
[docs.setup.configuration]: https://vector.dev/docs/setup/configuration/
[docs.deployment]: https://vector.dev/docs/setup/deployment/
[docs.sinks]: https://vector.dev/docs/reference/sinks/
[docs.sources]: https://vector.dev/docs/reference/sources/
[docs.strategies#daemon]: https://vector.dev/docs/setup/deployment/strategies/#daemon
[docs.strategies#service]: https://vector.dev/docs/setup/deployment/strategies/#service
[docs.strategies#sidecar]: https://vector.dev/docs/setup/deployment/strategies/#sidecar
[docs.transforms]: https://vector.dev/docs/reference/transforms/
[pages.index#correctness]: https://vector.dev/#correctness
[pages.index#performance]: https://vector.dev/#performance
[urls.default_configuration]: https://github.com/timberio/vector/blob/master/config/vector.toml
[urls.docker_alpine]: https://hub.docker.com/_/alpine
[urls.docker_debian]: https://hub.docker.com/_/debian
[urls.rust]: https://www.rust-lang.org/
[urls.vector_docker_source_files]: https://github.com/timberio/vector/tree/master/distribution/docker
[urls.vector_releases]: https://vector.dev/releases/latest/
[urls.vector_repo]: https://github.com/timberio/vector
[urls.distroless]: https://github.com/GoogleContainerTools/distroless
