#include "ruby.h"
#include "extconf.h"

#include "crc5.h"

VALUE Digest_CRC5_update(VALUE self, VALUE data)
{
	VALUE crc_ivar_name = rb_intern("@crc");
	VALUE crc_ivar = rb_ivar_get(self, crc_ivar_name);
	crc5_t crc = NUM2CHR(crc_ivar);

	const char *data_ptr = StringValuePtr(data);
	size_t length = RSTRING_LEN(data);

	crc = crc5_update(crc,data_ptr,length);

	rb_ivar_set(self, crc_ivar_name, UINT2NUM(crc));
	return self;
}

void Init_crc5_ext()
{
	VALUE mDigest = rb_const_get(rb_cObject, rb_intern("Digest"));
	VALUE cCRC5 = rb_const_get(mDigest, rb_intern("CRC5"));

	rb_undef_method(cCRC5, "update");
	rb_define_method(cCRC5, "update", Digest_CRC5_update, 1);
}
