/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SWIFTsGetter has a method to return a SWIFTInterface.
// A group's client should implement this interface.
type SWIFTsGetter interface {
	SWIFTs(namespace string) SWIFTInterface
}

// SWIFTInterface has methods to work with SWIFT resources.
type SWIFTInterface interface {
	Create(*v1.SWIFT) (*v1.SWIFT, error)
	Update(*v1.SWIFT) (*v1.SWIFT, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.SWIFT, error)
	List(opts metav1.ListOptions) (*v1.SWIFTList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.SWIFT, err error)
	SWIFTExpansion
}

// sWIFTs implements SWIFTInterface
type sWIFTs struct {
	client rest.Interface
	ns     string
}

// newSWIFTs returns a SWIFTs
func newSWIFTs(c *EdgefsV1Client, namespace string) *sWIFTs {
	return &sWIFTs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the sWIFT, and returns the corresponding sWIFT object, and an error if there is any.
func (c *sWIFTs) Get(name string, options metav1.GetOptions) (result *v1.SWIFT, err error) {
	result = &v1.SWIFT{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("swifts").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SWIFTs that match those selectors.
func (c *sWIFTs) List(opts metav1.ListOptions) (result *v1.SWIFTList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.SWIFTList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("swifts").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested sWIFTs.
func (c *sWIFTs) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("swifts").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a sWIFT and creates it.  Returns the server's representation of the sWIFT, and an error, if there is any.
func (c *sWIFTs) Create(sWIFT *v1.SWIFT) (result *v1.SWIFT, err error) {
	result = &v1.SWIFT{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("swifts").
		Body(sWIFT).
		Do().
		Into(result)
	return
}

// Update takes the representation of a sWIFT and updates it. Returns the server's representation of the sWIFT, and an error, if there is any.
func (c *sWIFTs) Update(sWIFT *v1.SWIFT) (result *v1.SWIFT, err error) {
	result = &v1.SWIFT{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("swifts").
		Name(sWIFT.Name).
		Body(sWIFT).
		Do().
		Into(result)
	return
}

// Delete takes name of the sWIFT and deletes it. Returns an error if one occurs.
func (c *sWIFTs) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("swifts").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *sWIFTs) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("swifts").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched sWIFT.
func (c *sWIFTs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.SWIFT, err error) {
	result = &v1.SWIFT{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("swifts").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
