"use strict";
/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var path = require("path");
var yargs = require("yargs");
var cdn_1 = require("./cdn");
var clean_1 = require("./clean");
var cli_error_1 = require("./cli-error");
var init_1 = require("./init");
var init_sources_1 = require("./init-sources");
var logger_1 = require("./logger");
var production_1 = require("./production");
var ASSSEMBLY_PATH = 'examples/assembly';
/**
 * Entry point of this helper script
 * @author Florent Benoit
 */
var commandArgs = yargs
    .usage('$0 <cmd> [args]')
    .command({
    command: 'init',
    describe: 'Initialize current theia to beahve like a Che/Theia',
    builder: init_sources_1.InitSources.argBuilder,
    handler: function (args) { return __awaiter(void 0, void 0, void 0, function () {
        var assemblyFolder, packagesFolder, pluginsFolder, cheFolder, init, version, initSources, err_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 7, , 8]);
                    assemblyFolder = path.resolve(process.cwd(), ASSSEMBLY_PATH);
                    packagesFolder = path.resolve(process.cwd(), 'packages');
                    pluginsFolder = path.resolve(process.cwd(), 'plugins');
                    cheFolder = path.resolve(process.cwd(), 'che');
                    init = new init_1.Init(process.cwd(), assemblyFolder, cheFolder, pluginsFolder);
                    return [4 /*yield*/, init.getCurrentVersion()];
                case 1:
                    version = _a.sent();
                    return [4 /*yield*/, init.generate()];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, init.updatePluginsConfigurtion()];
                case 3:
                    _a.sent();
                    initSources = new init_sources_1.InitSources(process.cwd(), packagesFolder, pluginsFolder, cheFolder, assemblyFolder, version);
                    return [4 /*yield*/, initSources.initSourceLocationAliases(args.alias)];
                case 4:
                    _a.sent();
                    return [4 /*yield*/, initSources.readConfigurationAndGenerate(args.config, args.dev)];
                case 5:
                    _a.sent();
                    return [4 /*yield*/, init.updadeBuildConfiguration(initSources.extensions)];
                case 6:
                    _a.sent();
                    return [3 /*break*/, 8];
                case 7:
                    err_1 = _a.sent();
                    handleError(err_1);
                    return [3 /*break*/, 8];
                case 8: return [2 /*return*/];
            }
        });
    }); },
})
    .command({
    command: 'production',
    describe: 'Copy Theia to a production directory',
    handler: function () { return __awaiter(void 0, void 0, void 0, function () {
        var assemblyFolder, production, err_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 3]);
                    assemblyFolder = path.resolve(process.cwd(), ASSSEMBLY_PATH);
                    production = new production_1.Production(process.cwd(), assemblyFolder, 'production');
                    return [4 /*yield*/, production.create()];
                case 1:
                    _a.sent();
                    return [3 /*break*/, 3];
                case 2:
                    err_2 = _a.sent();
                    handleError(err_2);
                    return [3 /*break*/, 3];
                case 3: return [2 /*return*/];
            }
        });
    }); },
})
    .command({
    command: 'cdn',
    describe: 'Add or update the CDN support configuration',
    builder: cdn_1.Cdn.argBuilder,
    handler: function (argv) { return __awaiter(void 0, void 0, void 0, function () {
        var assemblyFolder, cdn, err_3;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 3]);
                    assemblyFolder = path.resolve(process.cwd(), ASSSEMBLY_PATH);
                    cdn = new cdn_1.Cdn(assemblyFolder, argv.theia, argv.monaco);
                    return [4 /*yield*/, cdn.create()];
                case 1:
                    _a.sent();
                    return [3 /*break*/, 3];
                case 2:
                    err_3 = _a.sent();
                    handleError(err_3);
                    return [3 /*break*/, 3];
                case 3: return [2 /*return*/];
            }
        });
    }); },
})
    .command({
    command: 'clean',
    describe: 'Clean Theia repository',
    handler: function () { return __awaiter(void 0, void 0, void 0, function () {
        var assemblyFolder, packagesFolder, pluginsFolder, cheFolder, nodeModules, clean;
        return __generator(this, function (_a) {
            try {
                assemblyFolder = path.resolve(process.cwd(), ASSSEMBLY_PATH);
                packagesFolder = path.resolve(process.cwd(), 'packages');
                pluginsFolder = path.resolve(process.cwd(), 'plugins');
                cheFolder = path.resolve(process.cwd(), 'che');
                nodeModules = path.resolve(process.cwd(), 'node_modules');
                clean = new clean_1.Clean(assemblyFolder, cheFolder, packagesFolder, pluginsFolder, nodeModules);
                clean.cleanCheTheia();
            }
            catch (err) {
                handleError(err);
            }
            return [2 /*return*/];
        });
    }); },
})
    .help()
    .strict()
    .demandCommand().argv;
if (!commandArgs) {
    yargs.showHelp();
}
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function handleError(error) {
    if (error instanceof cli_error_1.CliError) {
        logger_1.Logger.error('=> 🚒 ' + error.message);
    }
    else {
        logger_1.Logger.error(error);
    }
    process.exit(1);
}
//# sourceMappingURL=yargs.js.map