#!/bin/sh
set -e

# show where we are on the machine
pwd

remote=$(git config remote.origin.url)
siteSource="website/public/"
GH_EMAIL="ci@cortexmetrics.io"
GH_NAME="ci"

# make a directory to put the gp-pages branch
mkdir gh-pages-branch
cd gh-pages-branch
# now lets setup a new repo so we can update the gh-pages branch
git config --global user.email "$GH_EMAIL" > /dev/null 2>&1
git config --global user.name "$GH_NAME" > /dev/null 2>&1
git init
git remote add --fetch origin "$remote"

# switch into the gh-pages branch
if git rev-parse --verify origin/gh-pages > /dev/null 2>&1
then
    git checkout gh-pages
    # delete any old site as we are going to replace it
    # Note: this explodes if there aren't any, so moving it here for now
    git rm -rf .
else
    git checkout --orphan gh-pages
fi

# copy over or recompile the new site
cp -a "../${siteSource}/." .
# set github CNAME file.
echo "cortexmetrics.io" > CNAME

# stage any changes and new files
git add -A
git commit --allow-empty -m "Deploy to GitHub pages"
echo "Changes committed"
# and push, but send any output to /dev/null to hide anything sensitive
git push --force --quiet origin gh-pages > /dev/null 2>&1
echo "Changes pushed"
# go back to where we started and remove the gh-pages git repo we made and used
# for deployment
cd ..
rm -rf gh-pages-branch

echo "Finished Deployment!"
