package logicapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/logic/mgmt/2015-02-01-preview/logic"
	"github.com/Azure/go-autorest/autorest"
)

// WorkflowsClientAPI contains the set of methods on the WorkflowsClient type.
type WorkflowsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, workflowName string, workflow logic.Workflow) (result logic.Workflow, err error)
	Delete(ctx context.Context, resourceGroupName string, workflowName string) (result autorest.Response, err error)
	Disable(ctx context.Context, resourceGroupName string, workflowName string) (result autorest.Response, err error)
	Enable(ctx context.Context, resourceGroupName string, workflowName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, workflowName string) (result logic.Workflow, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, top *int32, filter string) (result logic.WorkflowListResultPage, err error)
	ListBySubscription(ctx context.Context, top *int32, filter string) (result logic.WorkflowListResultPage, err error)
	Run(ctx context.Context, resourceGroupName string, workflowName string, parameters logic.RunWorkflowParameters) (result logic.WorkflowsRunFuture, err error)
	Update(ctx context.Context, resourceGroupName string, workflowName string, workflow logic.Workflow) (result logic.Workflow, err error)
	Validate(ctx context.Context, resourceGroupName string, workflowName string, workflow logic.Workflow) (result autorest.Response, err error)
}

var _ WorkflowsClientAPI = (*logic.WorkflowsClient)(nil)

// WorkflowVersionsClientAPI contains the set of methods on the WorkflowVersionsClient type.
type WorkflowVersionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, workflowName string, versionID string) (result logic.WorkflowVersion, err error)
}

var _ WorkflowVersionsClientAPI = (*logic.WorkflowVersionsClient)(nil)

// WorkflowAccessKeysClientAPI contains the set of methods on the WorkflowAccessKeysClient type.
type WorkflowAccessKeysClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, workflowName string, accessKeyName string, workflowAccesskey logic.WorkflowAccessKey) (result logic.WorkflowAccessKey, err error)
	Delete(ctx context.Context, resourceGroupName string, workflowName string, accessKeyName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, workflowName string, accessKeyName string) (result logic.WorkflowAccessKey, err error)
	List(ctx context.Context, resourceGroupName string, workflowName string, top *int32) (result logic.WorkflowAccessKeyListResultPage, err error)
	ListSecretKeys(ctx context.Context, resourceGroupName string, workflowName string, accessKeyName string) (result logic.WorkflowSecretKeys, err error)
	RegenerateSecretKey(ctx context.Context, resourceGroupName string, workflowName string, accessKeyName string, parameters logic.RegenerateSecretKeyParameters) (result logic.WorkflowSecretKeys, err error)
}

var _ WorkflowAccessKeysClientAPI = (*logic.WorkflowAccessKeysClient)(nil)

// WorkflowTriggersClientAPI contains the set of methods on the WorkflowTriggersClient type.
type WorkflowTriggersClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, workflowName string, triggerName string) (result logic.WorkflowTrigger, err error)
	List(ctx context.Context, resourceGroupName string, workflowName string, top *int32, filter string) (result logic.WorkflowTriggerListResultPage, err error)
	Run(ctx context.Context, resourceGroupName string, workflowName string, triggerName string) (result autorest.Response, err error)
}

var _ WorkflowTriggersClientAPI = (*logic.WorkflowTriggersClient)(nil)

// WorkflowTriggerHistoriesClientAPI contains the set of methods on the WorkflowTriggerHistoriesClient type.
type WorkflowTriggerHistoriesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, workflowName string, triggerName string, historyName string) (result logic.WorkflowTriggerHistory, err error)
	List(ctx context.Context, resourceGroupName string, workflowName string, triggerName string, top *int32, filter string) (result logic.WorkflowTriggerHistoryListResultPage, err error)
}

var _ WorkflowTriggerHistoriesClientAPI = (*logic.WorkflowTriggerHistoriesClient)(nil)

// WorkflowRunsClientAPI contains the set of methods on the WorkflowRunsClient type.
type WorkflowRunsClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, workflowName string, runName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, workflowName string, runName string) (result logic.WorkflowRun, err error)
	List(ctx context.Context, resourceGroupName string, workflowName string, top *int32, filter string) (result logic.WorkflowRunListResultPage, err error)
}

var _ WorkflowRunsClientAPI = (*logic.WorkflowRunsClient)(nil)

// WorkflowRunActionsClientAPI contains the set of methods on the WorkflowRunActionsClient type.
type WorkflowRunActionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, workflowName string, runName string, actionName string) (result logic.WorkflowRunAction, err error)
	List(ctx context.Context, resourceGroupName string, workflowName string, runName string, top *int32, filter string) (result logic.WorkflowRunActionListResultPage, err error)
}

var _ WorkflowRunActionsClientAPI = (*logic.WorkflowRunActionsClient)(nil)
