// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/resources/campaign_budget.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A campaign budget.
type CampaignBudget struct {
	// The resource name of the campaign budget.
	// Campaign budget resource names have the form:
	//
	// `customers/{customer_id}/campaignBudgets/{budget_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the campaign budget.
	//
	// A campaign budget is created using the CampaignBudgetService create
	// operation and is assigned a budget ID. A budget ID can be shared across
	// different campaigns; the system will then allocate the campaign budget
	// among different campaigns to get optimum results.
	Id *wrappers.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the campaign budget.
	//
	// When creating a campaign budget through CampaignBudgetService, every
	// explicitly shared campaign budget must have a non-null, non-empty name.
	// Campaign budgets that are not explicitly shared derive their name from the
	// attached campaign's name.
	//
	// The length of this string must be between 1 and 255, inclusive,
	// in UTF-8 bytes, (trimmed).
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The amount of the budget, in the local currency for the account.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit. Monthly spend is capped at 30.4 times this amount.
	AmountMicros *wrappers.Int64Value `protobuf:"bytes,5,opt,name=amount_micros,json=amountMicros,proto3" json:"amount_micros,omitempty"`
	// The lifetime amount of the budget, in the local currency for the account.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	TotalAmountMicros *wrappers.Int64Value `protobuf:"bytes,10,opt,name=total_amount_micros,json=totalAmountMicros,proto3" json:"total_amount_micros,omitempty"`
	// The status of this campaign budget. This field is read-only.
	Status enums.BudgetStatusEnum_BudgetStatus `protobuf:"varint,6,opt,name=status,proto3,enum=google.ads.googleads.v1.enums.BudgetStatusEnum_BudgetStatus" json:"status,omitempty"`
	// The delivery method that determines the rate at which the campaign budget
	// is spent.
	//
	// Defaults to STANDARD if unspecified in a create operation.
	DeliveryMethod enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod `protobuf:"varint,7,opt,name=delivery_method,json=deliveryMethod,proto3,enum=google.ads.googleads.v1.enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod" json:"delivery_method,omitempty"`
	// Specifies whether the budget is explicitly shared. Defaults to true if
	// unspecified in a create operation.
	//
	// If true, the budget was created with the purpose of sharing
	// across one or more campaigns.
	//
	// If false, the budget was created with the intention of only being used
	// with a single campaign. The budget's name and status will stay in sync
	// with the campaign's name and status. Attempting to share the budget with a
	// second campaign will result in an error.
	//
	// A non-shared budget can become an explicitly shared. The same operation
	// must also assign the budget a name.
	//
	// A shared campaign budget can never become non-shared.
	ExplicitlyShared *wrappers.BoolValue `protobuf:"bytes,8,opt,name=explicitly_shared,json=explicitlyShared,proto3" json:"explicitly_shared,omitempty"`
	// The number of campaigns actively using the budget.
	//
	// This field is read-only.
	ReferenceCount *wrappers.Int64Value `protobuf:"bytes,9,opt,name=reference_count,json=referenceCount,proto3" json:"reference_count,omitempty"`
	// Indicates whether there is a recommended budget for this campaign budget.
	//
	// This field is read-only.
	HasRecommendedBudget *wrappers.BoolValue `protobuf:"bytes,11,opt,name=has_recommended_budget,json=hasRecommendedBudget,proto3" json:"has_recommended_budget,omitempty"`
	// The recommended budget amount. If no recommendation is available, this will
	// be set to the budget amount.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	//
	// This field is read-only.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,12,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	// Period over which to spend the budget. Defaults to DAILY if not specified.
	Period enums.BudgetPeriodEnum_BudgetPeriod `protobuf:"varint,13,opt,name=period,proto3,enum=google.ads.googleads.v1.enums.BudgetPeriodEnum_BudgetPeriod" json:"period,omitempty"`
	// The estimated change in weekly clicks if the recommended budget is applied.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyClicks *wrappers.Int64Value `protobuf:"bytes,14,opt,name=recommended_budget_estimated_change_weekly_clicks,json=recommendedBudgetEstimatedChangeWeeklyClicks,proto3" json:"recommended_budget_estimated_change_weekly_clicks,omitempty"`
	// The estimated change in weekly cost in micros if the recommended budget is
	// applied. One million is equivalent to one currency unit.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyCostMicros *wrappers.Int64Value `protobuf:"bytes,15,opt,name=recommended_budget_estimated_change_weekly_cost_micros,json=recommendedBudgetEstimatedChangeWeeklyCostMicros,proto3" json:"recommended_budget_estimated_change_weekly_cost_micros,omitempty"`
	// The estimated change in weekly interactions if the recommended budget is
	// applied.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyInteractions *wrappers.Int64Value `protobuf:"bytes,16,opt,name=recommended_budget_estimated_change_weekly_interactions,json=recommendedBudgetEstimatedChangeWeeklyInteractions,proto3" json:"recommended_budget_estimated_change_weekly_interactions,omitempty"`
	// The estimated change in weekly views if the recommended budget is applied.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyViews *wrappers.Int64Value `protobuf:"bytes,17,opt,name=recommended_budget_estimated_change_weekly_views,json=recommendedBudgetEstimatedChangeWeeklyViews,proto3" json:"recommended_budget_estimated_change_weekly_views,omitempty"`
	// The type of the campaign budget.
	Type                 enums.BudgetTypeEnum_BudgetType `protobuf:"varint,18,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.BudgetTypeEnum_BudgetType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *CampaignBudget) Reset()         { *m = CampaignBudget{} }
func (m *CampaignBudget) String() string { return proto.CompactTextString(m) }
func (*CampaignBudget) ProtoMessage()    {}
func (*CampaignBudget) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed30a48e8c388be6, []int{0}
}

func (m *CampaignBudget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CampaignBudget.Unmarshal(m, b)
}
func (m *CampaignBudget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CampaignBudget.Marshal(b, m, deterministic)
}
func (m *CampaignBudget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CampaignBudget.Merge(m, src)
}
func (m *CampaignBudget) XXX_Size() int {
	return xxx_messageInfo_CampaignBudget.Size(m)
}
func (m *CampaignBudget) XXX_DiscardUnknown() {
	xxx_messageInfo_CampaignBudget.DiscardUnknown(m)
}

var xxx_messageInfo_CampaignBudget proto.InternalMessageInfo

func (m *CampaignBudget) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *CampaignBudget) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *CampaignBudget) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *CampaignBudget) GetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.AmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetTotalAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TotalAmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetStatus() enums.BudgetStatusEnum_BudgetStatus {
	if m != nil {
		return m.Status
	}
	return enums.BudgetStatusEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetDeliveryMethod() enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod {
	if m != nil {
		return m.DeliveryMethod
	}
	return enums.BudgetDeliveryMethodEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetExplicitlyShared() *wrappers.BoolValue {
	if m != nil {
		return m.ExplicitlyShared
	}
	return nil
}

func (m *CampaignBudget) GetReferenceCount() *wrappers.Int64Value {
	if m != nil {
		return m.ReferenceCount
	}
	return nil
}

func (m *CampaignBudget) GetHasRecommendedBudget() *wrappers.BoolValue {
	if m != nil {
		return m.HasRecommendedBudget
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetPeriod() enums.BudgetPeriodEnum_BudgetPeriod {
	if m != nil {
		return m.Period
	}
	return enums.BudgetPeriodEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyClicks() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyClicks
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyCostMicros
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyInteractions() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyInteractions
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyViews() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyViews
	}
	return nil
}

func (m *CampaignBudget) GetType() enums.BudgetTypeEnum_BudgetType {
	if m != nil {
		return m.Type
	}
	return enums.BudgetTypeEnum_UNSPECIFIED
}

func init() {
	proto.RegisterType((*CampaignBudget)(nil), "google.ads.googleads.v1.resources.CampaignBudget")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/resources/campaign_budget.proto", fileDescriptor_ed30a48e8c388be6)
}

var fileDescriptor_ed30a48e8c388be6 = []byte{
	// 753 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x95, 0x5f, 0x6f, 0xeb, 0x34,
	0x18, 0xc6, 0x95, 0x9e, 0x31, 0x38, 0x3e, 0x5d, 0x77, 0x96, 0x83, 0x50, 0x34, 0x0e, 0xa8, 0x03,
	0x4d, 0x9a, 0x34, 0x94, 0xac, 0x03, 0x6d, 0x28, 0x70, 0x41, 0xdb, 0x4d, 0xd3, 0x60, 0x43, 0x55,
	0x36, 0x15, 0x09, 0x55, 0x8a, 0xbc, 0xf8, 0x5d, 0x6a, 0x2d, 0xb1, 0x23, 0xdb, 0xe9, 0xe8, 0x1d,
	0x42, 0x5c, 0x21, 0x21, 0xf1, 0x19, 0xb8, 0xe4, 0xa3, 0xf0, 0x51, 0xf8, 0x14, 0x28, 0xce, 0x9f,
	0xf5, 0x0f, 0x23, 0xed, 0x9d, 0x63, 0xbf, 0xcf, 0xcf, 0x8f, 0x1f, 0xbf, 0xad, 0xd1, 0x69, 0xc8,
	0x79, 0x18, 0x81, 0x83, 0x89, 0x74, 0xf2, 0x61, 0x36, 0x9a, 0x74, 0x1c, 0x01, 0x92, 0xa7, 0x22,
	0x00, 0xe9, 0x04, 0x38, 0x4e, 0x30, 0x0d, 0x99, 0x7f, 0x97, 0x92, 0x10, 0x94, 0x9d, 0x08, 0xae,
	0xb8, 0xb9, 0x97, 0x57, 0xdb, 0x98, 0x48, 0xbb, 0x12, 0xda, 0x93, 0x8e, 0x5d, 0x09, 0x77, 0xdd,
	0xe7, 0xd8, 0xc0, 0xd2, 0x58, 0x3a, 0x39, 0xce, 0x27, 0x10, 0xd1, 0x09, 0x88, 0xa9, 0x1f, 0x83,
	0x1a, 0x73, 0x92, 0xe3, 0x77, 0x3b, 0x2b, 0x69, 0x13, 0x10, 0x74, 0x4d, 0x89, 0x54, 0x58, 0xa5,
	0xb2, 0x90, 0x38, 0x2b, 0x49, 0xd4, 0x34, 0x81, 0x42, 0xf0, 0xb6, 0x14, 0x24, 0xd4, 0xc1, 0x8c,
	0x71, 0x85, 0x15, 0xe5, 0xac, 0xc4, 0x7d, 0x5c, 0xac, 0xea, 0xaf, 0xbb, 0xf4, 0xde, 0x79, 0x14,
	0x38, 0x49, 0x40, 0x14, 0xeb, 0x9f, 0xfc, 0xd6, 0x44, 0xad, 0x7e, 0x91, 0x66, 0x4f, 0xb3, 0xcd,
	0x4f, 0xd1, 0x56, 0x19, 0x98, 0xcf, 0x70, 0x0c, 0x96, 0xd1, 0x36, 0x0e, 0x5e, 0x7a, 0xcd, 0x72,
	0xf2, 0x7b, 0x1c, 0x83, 0x79, 0x88, 0x1a, 0x94, 0x58, 0x2f, 0xda, 0xc6, 0xc1, 0xab, 0xe3, 0x0f,
	0x8b, 0xb4, 0xed, 0x72, 0x13, 0xfb, 0x92, 0xa9, 0x93, 0x2f, 0x86, 0x38, 0x4a, 0xc1, 0x6b, 0x50,
	0x62, 0x1e, 0xa1, 0x0d, 0x0d, 0xda, 0xd0, 0xe5, 0x6f, 0x97, 0xca, 0x6f, 0x94, 0xa0, 0x2c, 0xcc,
	0xeb, 0x75, 0xa5, 0xf9, 0x0d, 0xda, 0xc2, 0x31, 0x4f, 0x99, 0xf2, 0x63, 0x1a, 0x08, 0x2e, 0xad,
	0x77, 0xea, 0x77, 0x6a, 0xe6, 0x8a, 0x6b, 0x2d, 0x30, 0xbf, 0x43, 0x6f, 0x14, 0x57, 0x38, 0xf2,
	0xe7, 0x39, 0xa8, 0x9e, 0xb3, 0xa3, 0x75, 0xdd, 0x59, 0xd8, 0x2d, 0xda, 0xcc, 0x2f, 0xc9, 0xda,
	0x6c, 0x1b, 0x07, 0xad, 0xe3, 0xaf, 0xed, 0xe7, 0x5a, 0x4d, 0xdf, 0x92, 0x9d, 0x27, 0x79, 0xa3,
	0x25, 0xe7, 0x2c, 0x8d, 0xe7, 0x26, 0xbc, 0x82, 0x65, 0xa6, 0x68, 0x7b, 0xa1, 0xd3, 0xac, 0x77,
	0x35, 0xfe, 0x6a, 0x25, 0xfc, 0x59, 0xa1, 0xbd, 0xd6, 0xd2, 0x99, 0x6d, 0xe6, 0x17, 0xbc, 0x16,
	0x99, 0xfb, 0x36, 0x2f, 0xd0, 0x0e, 0xfc, 0x94, 0x44, 0x34, 0xa0, 0x2a, 0x9a, 0xfa, 0x72, 0x8c,
	0x05, 0x10, 0xeb, 0x3d, 0x9d, 0xcb, 0xee, 0x52, 0x2e, 0x3d, 0xce, 0xa3, 0x3c, 0x96, 0xd7, 0x4f,
	0xa2, 0x1b, 0xad, 0x31, 0xcf, 0xd0, 0xb6, 0x80, 0x7b, 0x10, 0xc0, 0x02, 0xf0, 0x83, 0x2c, 0x2e,
	0xeb, 0x65, 0x7d, 0xbc, 0xad, 0x4a, 0xd3, 0xcf, 0x24, 0xe6, 0x00, 0x7d, 0x30, 0xc6, 0xd2, 0x17,
	0x10, 0xf0, 0x38, 0x06, 0x46, 0x80, 0x14, 0xbf, 0x6a, 0xeb, 0x55, 0xad, 0xa7, 0xf7, 0xc7, 0x58,
	0x7a, 0x4f, 0xc2, 0xa2, 0x81, 0x09, 0x6a, 0x2f, 0xd3, 0x16, 0xfa, 0xa0, 0x59, 0x6f, 0xf4, 0x23,
	0xb1, 0x48, 0x5e, 0xec, 0x89, 0xfc, 0xb7, 0x6e, 0x6d, 0xad, 0xd1, 0x13, 0x03, 0x2d, 0x99, 0xb9,
	0xac, 0x7c, 0xc2, 0x2b, 0x58, 0xe6, 0xaf, 0x06, 0xea, 0xfc, 0x87, 0x79, 0x90, 0x8a, 0xc6, 0x58,
	0x01, 0xf1, 0x83, 0x31, 0x66, 0x21, 0xf8, 0x8f, 0x00, 0x0f, 0xd1, 0xd4, 0x0f, 0x22, 0x1a, 0x3c,
	0x48, 0xab, 0x55, 0x7f, 0x9a, 0xcf, 0x96, 0x4e, 0x73, 0x5e, 0x32, 0xfb, 0x1a, 0xf9, 0x83, 0x26,
	0xf6, 0x35, 0xd0, 0xfc, 0xdd, 0x40, 0x27, 0xeb, 0xd8, 0xe0, 0xb2, 0x4a, 0x76, 0xbb, 0xde, 0xcb,
	0xd1, 0x8a, 0x5e, 0xb8, 0x2c, 0xc3, 0xfe, 0xc3, 0x40, 0xa7, 0x6b, 0xf8, 0xa1, 0x4c, 0x81, 0xc0,
	0x81, 0xfe, 0x23, 0xb4, 0x5e, 0xd7, 0x1b, 0x3a, 0x5e, 0xcd, 0xd0, 0xe5, 0x0c, 0xd6, 0xfc, 0xc5,
	0x40, 0x47, 0x6b, 0x58, 0x9a, 0x50, 0x78, 0x94, 0xd6, 0x4e, 0xbd, 0x97, 0xc3, 0xd5, 0xbc, 0x0c,
	0x33, 0x9e, 0x79, 0x85, 0x36, 0xb2, 0xa7, 0xc0, 0x32, 0x75, 0x0b, 0x7e, 0xb9, 0x52, 0x0b, 0xde,
	0x4e, 0x13, 0x98, 0x69, 0xc0, 0xec, 0xd3, 0xd3, 0x94, 0xde, 0xcf, 0x0d, 0xb4, 0x1f, 0xf0, 0xd8,
	0xae, 0x7d, 0x47, 0x7b, 0x6f, 0xe6, 0xdf, 0x8c, 0x41, 0x76, 0x8e, 0x81, 0xf1, 0xe3, 0xb7, 0x85,
	0x32, 0xe4, 0x11, 0x66, 0xa1, 0xcd, 0x45, 0xe8, 0x84, 0xc0, 0xf4, 0x29, 0xcb, 0xc7, 0x2c, 0xa1,
	0xf2, 0x7f, 0x5e, 0xf6, 0xaf, 0xaa, 0xd1, 0x9f, 0x8d, 0x17, 0x17, 0xdd, 0xee, 0x5f, 0x8d, 0xbd,
	0x8b, 0x1c, 0xd9, 0x25, 0xd2, 0xce, 0x87, 0xd9, 0x68, 0xd8, 0xb1, 0xbd, 0xb2, 0xf2, 0xef, 0xb2,
	0x66, 0xd4, 0x25, 0x72, 0x54, 0xd5, 0x8c, 0x86, 0x9d, 0x51, 0x55, 0xf3, 0x4f, 0x63, 0x3f, 0x5f,
	0x70, 0xdd, 0x2e, 0x91, 0xae, 0x5b, 0x55, 0xb9, 0xee, 0xb0, 0xe3, 0xba, 0x55, 0xdd, 0xdd, 0xa6,
	0x36, 0xfb, 0xf9, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x87, 0x31, 0xda, 0x33, 0x85, 0x08, 0x00,
	0x00,
}
