/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/submariner-io/submariner/pkg/apis/submariner.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterGlobalEgressIPLister helps list ClusterGlobalEgressIPs.
// All objects returned here must be treated as read-only.
type ClusterGlobalEgressIPLister interface {
	// List lists all ClusterGlobalEgressIPs in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.ClusterGlobalEgressIP, err error)
	// ClusterGlobalEgressIPs returns an object that can list and get ClusterGlobalEgressIPs.
	ClusterGlobalEgressIPs(namespace string) ClusterGlobalEgressIPNamespaceLister
	ClusterGlobalEgressIPListerExpansion
}

// clusterGlobalEgressIPLister implements the ClusterGlobalEgressIPLister interface.
type clusterGlobalEgressIPLister struct {
	indexer cache.Indexer
}

// NewClusterGlobalEgressIPLister returns a new ClusterGlobalEgressIPLister.
func NewClusterGlobalEgressIPLister(indexer cache.Indexer) ClusterGlobalEgressIPLister {
	return &clusterGlobalEgressIPLister{indexer: indexer}
}

// List lists all ClusterGlobalEgressIPs in the indexer.
func (s *clusterGlobalEgressIPLister) List(selector labels.Selector) (ret []*v1.ClusterGlobalEgressIP, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterGlobalEgressIP))
	})
	return ret, err
}

// ClusterGlobalEgressIPs returns an object that can list and get ClusterGlobalEgressIPs.
func (s *clusterGlobalEgressIPLister) ClusterGlobalEgressIPs(namespace string) ClusterGlobalEgressIPNamespaceLister {
	return clusterGlobalEgressIPNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ClusterGlobalEgressIPNamespaceLister helps list and get ClusterGlobalEgressIPs.
// All objects returned here must be treated as read-only.
type ClusterGlobalEgressIPNamespaceLister interface {
	// List lists all ClusterGlobalEgressIPs in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.ClusterGlobalEgressIP, err error)
	// Get retrieves the ClusterGlobalEgressIP from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.ClusterGlobalEgressIP, error)
	ClusterGlobalEgressIPNamespaceListerExpansion
}

// clusterGlobalEgressIPNamespaceLister implements the ClusterGlobalEgressIPNamespaceLister
// interface.
type clusterGlobalEgressIPNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ClusterGlobalEgressIPs in the indexer for a given namespace.
func (s clusterGlobalEgressIPNamespaceLister) List(selector labels.Selector) (ret []*v1.ClusterGlobalEgressIP, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterGlobalEgressIP))
	})
	return ret, err
}

// Get retrieves the ClusterGlobalEgressIP from the indexer for a given namespace and name.
func (s clusterGlobalEgressIPNamespaceLister) Get(name string) (*v1.ClusterGlobalEgressIP, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("clusterglobalegressip"), name)
	}
	return obj.(*v1.ClusterGlobalEgressIP), nil
}
