import { GraphQLSchema, GraphQLFieldResolver } from 'graphql';
import { Transform, Request, ExecutionResult } from '@graphql-tools/utils';
interface WrapFieldsTransformationContext {
    nextIndex: number;
    paths: Record<string, {
        pathToField: Array<string>;
        alias: string;
    }>;
}
export default class WrapFields implements Transform<WrapFieldsTransformationContext> {
    private readonly outerTypeName;
    private readonly wrappingFieldNames;
    private readonly wrappingTypeNames;
    private readonly numWraps;
    private readonly fieldNames;
    private readonly wrappingResolver;
    private readonly transformer;
    constructor(outerTypeName: string, wrappingFieldNames: Array<string>, wrappingTypeNames: Array<string>, fieldNames?: Array<string>, wrappingResolver?: GraphQLFieldResolver<any, any>, prefix?: string);
    transformSchema(schema: GraphQLSchema): GraphQLSchema;
    transformRequest(originalRequest: Request, delegationContext?: Record<string, any>, transformationContext?: WrapFieldsTransformationContext): Request;
    transformResult(originalResult: ExecutionResult, delegationContext?: Record<string, any>, transformationContext?: WrapFieldsTransformationContext): ExecutionResult;
}
export declare function dehoistValue(originalValue: any, context: WrapFieldsTransformationContext): any;
export {};
