import { TypeNode, DefinitionNode, EnumTypeDefinitionNode, NamedTypeNode, ListTypeNode, NonNullTypeNode, ObjectTypeDefinitionNode, Source, UnionTypeDefinitionNode, ScalarTypeDefinitionNode, InputObjectTypeDefinitionNode, InterfaceTypeDefinitionNode, DirectiveDefinitionNode, SchemaDefinitionNode, ObjectTypeExtensionNode, InputObjectTypeExtensionNode, EnumTypeExtensionNode, UnionTypeExtensionNode, ScalarTypeExtensionNode, InterfaceTypeExtensionNode } from 'graphql';
export declare function isStringTypes(types: any): types is string;
export declare function isSourceTypes(types: any): types is Source;
export declare function isGraphQLType(definition: DefinitionNode): definition is ObjectTypeDefinitionNode;
export declare function isGraphQLTypeExtension(definition: DefinitionNode): definition is ObjectTypeExtensionNode;
export declare function isGraphQLEnum(definition: DefinitionNode): definition is EnumTypeDefinitionNode;
export declare function isGraphQLEnumExtension(definition: DefinitionNode): definition is EnumTypeExtensionNode;
export declare function isGraphQLUnion(definition: DefinitionNode): definition is UnionTypeDefinitionNode;
export declare function isGraphQLUnionExtension(definition: DefinitionNode): definition is UnionTypeExtensionNode;
export declare function isGraphQLScalar(definition: DefinitionNode): definition is ScalarTypeDefinitionNode;
export declare function isGraphQLScalarExtension(definition: DefinitionNode): definition is ScalarTypeExtensionNode;
export declare function isGraphQLInputType(definition: DefinitionNode): definition is InputObjectTypeDefinitionNode;
export declare function isGraphQLInputTypeExtension(definition: DefinitionNode): definition is InputObjectTypeExtensionNode;
export declare function isGraphQLInterface(definition: DefinitionNode): definition is InterfaceTypeDefinitionNode;
export declare function isGraphQLInterfaceExtension(definition: DefinitionNode): definition is InterfaceTypeExtensionNode;
export declare function isGraphQLDirective(definition: DefinitionNode): definition is DirectiveDefinitionNode;
export declare function extractType(type: TypeNode): NamedTypeNode;
export declare function isSchemaDefinition(node: DefinitionNode): node is SchemaDefinitionNode;
export declare function isWrappingTypeNode(type: TypeNode): type is ListTypeNode | NonNullTypeNode;
export declare function isListTypeNode(type: TypeNode): type is ListTypeNode;
export declare function isNonNullTypeNode(type: TypeNode): type is NonNullTypeNode;
export declare function printTypeNode(type: TypeNode): string;
