// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/documentai/v1beta2/document_understanding.proto

package documentai

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type OperationMetadata_State int32

const (
	// The default value. This value is used if the state is omitted.
	OperationMetadata_STATE_UNSPECIFIED OperationMetadata_State = 0
	// Request is received.
	OperationMetadata_ACCEPTED OperationMetadata_State = 1
	// Request operation is waiting for scheduling.
	OperationMetadata_WAITING OperationMetadata_State = 2
	// Request is being processed.
	OperationMetadata_RUNNING OperationMetadata_State = 3
	// The batch processing completed successfully.
	OperationMetadata_SUCCEEDED OperationMetadata_State = 4
	// The batch processing was cancelled.
	OperationMetadata_CANCELLED OperationMetadata_State = 5
	// The batch processing has failed.
	OperationMetadata_FAILED OperationMetadata_State = 6
)

// Enum value maps for OperationMetadata_State.
var (
	OperationMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACCEPTED",
		2: "WAITING",
		3: "RUNNING",
		4: "SUCCEEDED",
		5: "CANCELLED",
		6: "FAILED",
	}
	OperationMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACCEPTED":          1,
		"WAITING":           2,
		"RUNNING":           3,
		"SUCCEEDED":         4,
		"CANCELLED":         5,
		"FAILED":            6,
	}
)

func (x OperationMetadata_State) Enum() *OperationMetadata_State {
	p := new(OperationMetadata_State)
	*p = x
	return p
}

func (x OperationMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_enumTypes[0].Descriptor()
}

func (OperationMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1beta2_document_understanding_proto_enumTypes[0]
}

func (x OperationMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationMetadata_State.Descriptor instead.
func (OperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{15, 0}
}

// Request to batch process documents as an asynchronous operation. The output
// is written to Cloud Storage as JSON in the [Document] format.
type BatchProcessDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Individual requests for each document.
	Requests []*ProcessDocumentRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	// Target project and location to make a call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// If no location is specified, a region will be chosen automatically.
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *BatchProcessDocumentsRequest) Reset() {
	*x = BatchProcessDocumentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessDocumentsRequest) ProtoMessage() {}

func (x *BatchProcessDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessDocumentsRequest.ProtoReflect.Descriptor instead.
func (*BatchProcessDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{0}
}

func (x *BatchProcessDocumentsRequest) GetRequests() []*ProcessDocumentRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *BatchProcessDocumentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request to process one document.
type ProcessDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target project and location to make a call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// If no location is specified, a region will be chosen automatically.
	// This field is only populated when used in ProcessDocument method.
	Parent string `protobuf:"bytes,9,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Information about the input file.
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Optional. The desired output location. This field is only needed in
	// BatchProcessDocumentsRequest.
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Specifies a known document type for deeper structure detection. Valid
	// values are currently "general" and "invoice". If not provided, "general"\
	// is used as default. If any other value is given, the request is rejected.
	DocumentType string `protobuf:"bytes,3,opt,name=document_type,json=documentType,proto3" json:"document_type,omitempty"`
	// Controls table extraction behavior. If not specified, the system will
	// decide reasonable defaults.
	TableExtractionParams *TableExtractionParams `protobuf:"bytes,4,opt,name=table_extraction_params,json=tableExtractionParams,proto3" json:"table_extraction_params,omitempty"`
	// Controls form extraction behavior. If not specified, the system will
	// decide reasonable defaults.
	FormExtractionParams *FormExtractionParams `protobuf:"bytes,5,opt,name=form_extraction_params,json=formExtractionParams,proto3" json:"form_extraction_params,omitempty"`
	// Controls entity extraction behavior. If not specified, the system will
	// decide reasonable defaults.
	EntityExtractionParams *EntityExtractionParams `protobuf:"bytes,6,opt,name=entity_extraction_params,json=entityExtractionParams,proto3" json:"entity_extraction_params,omitempty"`
	// Controls OCR behavior. If not specified, the system will decide reasonable
	// defaults.
	OcrParams *OcrParams `protobuf:"bytes,7,opt,name=ocr_params,json=ocrParams,proto3" json:"ocr_params,omitempty"`
	// Controls AutoML model prediction behavior. AutoMlParams cannot be used
	// together with other Params.
	AutomlParams *AutoMlParams `protobuf:"bytes,8,opt,name=automl_params,json=automlParams,proto3" json:"automl_params,omitempty"`
}

func (x *ProcessDocumentRequest) Reset() {
	*x = ProcessDocumentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessDocumentRequest) ProtoMessage() {}

func (x *ProcessDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessDocumentRequest.ProtoReflect.Descriptor instead.
func (*ProcessDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{1}
}

func (x *ProcessDocumentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ProcessDocumentRequest) GetInputConfig() *InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *ProcessDocumentRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *ProcessDocumentRequest) GetDocumentType() string {
	if x != nil {
		return x.DocumentType
	}
	return ""
}

func (x *ProcessDocumentRequest) GetTableExtractionParams() *TableExtractionParams {
	if x != nil {
		return x.TableExtractionParams
	}
	return nil
}

func (x *ProcessDocumentRequest) GetFormExtractionParams() *FormExtractionParams {
	if x != nil {
		return x.FormExtractionParams
	}
	return nil
}

func (x *ProcessDocumentRequest) GetEntityExtractionParams() *EntityExtractionParams {
	if x != nil {
		return x.EntityExtractionParams
	}
	return nil
}

func (x *ProcessDocumentRequest) GetOcrParams() *OcrParams {
	if x != nil {
		return x.OcrParams
	}
	return nil
}

func (x *ProcessDocumentRequest) GetAutomlParams() *AutoMlParams {
	if x != nil {
		return x.AutomlParams
	}
	return nil
}

// Response to an batch document processing request. This is returned in
// the LRO Operation after the operation is complete.
type BatchProcessDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Responses for each individual document.
	Responses []*ProcessDocumentResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
}

func (x *BatchProcessDocumentsResponse) Reset() {
	*x = BatchProcessDocumentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessDocumentsResponse) ProtoMessage() {}

func (x *BatchProcessDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessDocumentsResponse.ProtoReflect.Descriptor instead.
func (*BatchProcessDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{2}
}

func (x *BatchProcessDocumentsResponse) GetResponses() []*ProcessDocumentResponse {
	if x != nil {
		return x.Responses
	}
	return nil
}

// Response to a single document processing request.
type ProcessDocumentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about the input file. This is the same as the corresponding
	// input config in the request.
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// The output location of the parsed responses. The responses are written to
	// this location as JSON-serialized `Document` objects.
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *ProcessDocumentResponse) Reset() {
	*x = ProcessDocumentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessDocumentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessDocumentResponse) ProtoMessage() {}

func (x *ProcessDocumentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessDocumentResponse.ProtoReflect.Descriptor instead.
func (*ProcessDocumentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{3}
}

func (x *ProcessDocumentResponse) GetInputConfig() *InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *ProcessDocumentResponse) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// Parameters to control Optical Character Recognition (OCR) behavior.
type OcrParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of languages to use for OCR. In most cases, an empty value
	// yields the best results since it enables automatic language detection. For
	// languages based on the Latin alphabet, setting `language_hints` is not
	// needed. In rare cases, when the language of the text in the image is known,
	// setting a hint will help get better results (although it will be a
	// significant hindrance if the hint is wrong). Document processing returns an
	// error if one or more of the specified languages is not one of the
	// supported languages.
	LanguageHints []string `protobuf:"bytes,1,rep,name=language_hints,json=languageHints,proto3" json:"language_hints,omitempty"`
}

func (x *OcrParams) Reset() {
	*x = OcrParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OcrParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OcrParams) ProtoMessage() {}

func (x *OcrParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OcrParams.ProtoReflect.Descriptor instead.
func (*OcrParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{4}
}

func (x *OcrParams) GetLanguageHints() []string {
	if x != nil {
		return x.LanguageHints
	}
	return nil
}

// Parameters to control table extraction behavior.
type TableExtractionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to enable table extraction.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Optional. Table bounding box hints that can be provided to complex cases
	// which our algorithm cannot locate the table(s) in.
	TableBoundHints []*TableBoundHint `protobuf:"bytes,2,rep,name=table_bound_hints,json=tableBoundHints,proto3" json:"table_bound_hints,omitempty"`
	// Optional. Table header hints. The extraction will bias towards producing
	// these terms as table headers, which may improve accuracy.
	HeaderHints []string `protobuf:"bytes,3,rep,name=header_hints,json=headerHints,proto3" json:"header_hints,omitempty"`
	// Model version of the table extraction system. Default is "builtin/stable".
	// Specify "builtin/latest" for the latest model.
	ModelVersion string `protobuf:"bytes,4,opt,name=model_version,json=modelVersion,proto3" json:"model_version,omitempty"`
}

func (x *TableExtractionParams) Reset() {
	*x = TableExtractionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableExtractionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableExtractionParams) ProtoMessage() {}

func (x *TableExtractionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableExtractionParams.ProtoReflect.Descriptor instead.
func (*TableExtractionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{5}
}

func (x *TableExtractionParams) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *TableExtractionParams) GetTableBoundHints() []*TableBoundHint {
	if x != nil {
		return x.TableBoundHints
	}
	return nil
}

func (x *TableExtractionParams) GetHeaderHints() []string {
	if x != nil {
		return x.HeaderHints
	}
	return nil
}

func (x *TableExtractionParams) GetModelVersion() string {
	if x != nil {
		return x.ModelVersion
	}
	return ""
}

// A hint for a table bounding box on the page for table parsing.
type TableBoundHint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Page number for multi-paged inputs this hint applies to. If not
	// provided, this hint will apply to all pages by default. This value is
	// 1-based.
	PageNumber int32 `protobuf:"varint,1,opt,name=page_number,json=pageNumber,proto3" json:"page_number,omitempty"`
	// Bounding box hint for a table on this page. The coordinates must be
	// normalized to [0,1] and the bounding box must be an axis-aligned rectangle.
	BoundingBox *BoundingPoly `protobuf:"bytes,2,opt,name=bounding_box,json=boundingBox,proto3" json:"bounding_box,omitempty"`
}

func (x *TableBoundHint) Reset() {
	*x = TableBoundHint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableBoundHint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableBoundHint) ProtoMessage() {}

func (x *TableBoundHint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableBoundHint.ProtoReflect.Descriptor instead.
func (*TableBoundHint) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{6}
}

func (x *TableBoundHint) GetPageNumber() int32 {
	if x != nil {
		return x.PageNumber
	}
	return 0
}

func (x *TableBoundHint) GetBoundingBox() *BoundingPoly {
	if x != nil {
		return x.BoundingBox
	}
	return nil
}

// Parameters to control form extraction behavior.
type FormExtractionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to enable form extraction.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// User can provide pairs of (key text, value type) to improve the parsing
	// result.
	//
	// For example, if a document has a field called "Date" that holds a date
	// value and a field called "Amount" that may hold either a currency value
	// (e.g., "$500.00") or a simple number value (e.g., "20"), you could use the
	// following hints: [ {"key": "Date", value_types: [ "DATE"]}, {"key":
	// "Amount", "value_types": [ "PRICE", "NUMBER" ]} ]
	//
	// If the value type is unknown, but you want to provide hints for the keys,
	// you can leave the value_types field blank. e.g. {"key": "Date",
	// "value_types": []}
	KeyValuePairHints []*KeyValuePairHint `protobuf:"bytes,2,rep,name=key_value_pair_hints,json=keyValuePairHints,proto3" json:"key_value_pair_hints,omitempty"`
	// Model version of the form extraction system. Default is
	// "builtin/stable". Specify "builtin/latest" for the latest model.
	// For custom form models, specify: “custom/{model_name}". Model name
	// format is "bucket_name/path/to/modeldir" corresponding to
	// "gs://bucket_name/path/to/modeldir" where annotated examples are stored.
	ModelVersion string `protobuf:"bytes,3,opt,name=model_version,json=modelVersion,proto3" json:"model_version,omitempty"`
}

func (x *FormExtractionParams) Reset() {
	*x = FormExtractionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FormExtractionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FormExtractionParams) ProtoMessage() {}

func (x *FormExtractionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FormExtractionParams.ProtoReflect.Descriptor instead.
func (*FormExtractionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{7}
}

func (x *FormExtractionParams) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *FormExtractionParams) GetKeyValuePairHints() []*KeyValuePairHint {
	if x != nil {
		return x.KeyValuePairHints
	}
	return nil
}

func (x *FormExtractionParams) GetModelVersion() string {
	if x != nil {
		return x.ModelVersion
	}
	return ""
}

// User-provided hint for key value pair.
type KeyValuePairHint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key text for the hint.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Type of the value. This is case-insensitive, and could be one of:
	// ADDRESS, LOCATION, ORGANIZATION, PERSON, PHONE_NUMBER,
	// ID, NUMBER, EMAIL, PRICE, TERMS, DATE, NAME. Types not in this list will
	// be ignored.
	ValueTypes []string `protobuf:"bytes,2,rep,name=value_types,json=valueTypes,proto3" json:"value_types,omitempty"`
}

func (x *KeyValuePairHint) Reset() {
	*x = KeyValuePairHint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyValuePairHint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyValuePairHint) ProtoMessage() {}

func (x *KeyValuePairHint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyValuePairHint.ProtoReflect.Descriptor instead.
func (*KeyValuePairHint) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{8}
}

func (x *KeyValuePairHint) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *KeyValuePairHint) GetValueTypes() []string {
	if x != nil {
		return x.ValueTypes
	}
	return nil
}

// Parameters to control entity extraction behavior.
type EntityExtractionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to enable entity extraction.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Model version of the entity extraction. Default is
	// "builtin/stable". Specify "builtin/latest" for the latest model.
	ModelVersion string `protobuf:"bytes,2,opt,name=model_version,json=modelVersion,proto3" json:"model_version,omitempty"`
}

func (x *EntityExtractionParams) Reset() {
	*x = EntityExtractionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityExtractionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityExtractionParams) ProtoMessage() {}

func (x *EntityExtractionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityExtractionParams.ProtoReflect.Descriptor instead.
func (*EntityExtractionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{9}
}

func (x *EntityExtractionParams) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *EntityExtractionParams) GetModelVersion() string {
	if x != nil {
		return x.ModelVersion
	}
	return ""
}

// Parameters to control AutoML model prediction behavior.
type AutoMlParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the AutoML model.
	//
	// Format: `projects/{project-id}/locations/{location-id}/models/{model-id}`.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *AutoMlParams) Reset() {
	*x = AutoMlParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoMlParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoMlParams) ProtoMessage() {}

func (x *AutoMlParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoMlParams.ProtoReflect.Descriptor instead.
func (*AutoMlParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{10}
}

func (x *AutoMlParams) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// The desired input location and metadata.
type InputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to Source:
	//	*InputConfig_GcsSource
	//	*InputConfig_Contents
	Source isInputConfig_Source `protobuf_oneof:"source"`
	// Required. Mimetype of the input. Current supported mimetypes are application/pdf,
	// image/tiff, and image/gif.
	// In addition, application/json type is supported for requests with
	// [ProcessDocumentRequest.automl_params][google.cloud.documentai.v1beta2.ProcessDocumentRequest.automl_params] field set. The JSON file needs to
	// be in [Document][google.cloud.documentai.v1beta2.Document] format.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *InputConfig) Reset() {
	*x = InputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputConfig) ProtoMessage() {}

func (x *InputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputConfig.ProtoReflect.Descriptor instead.
func (*InputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{11}
}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *InputConfig) GetContents() []byte {
	if x, ok := x.GetSource().(*InputConfig_Contents); ok {
		return x.Contents
	}
	return nil
}

func (x *InputConfig) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	// The Google Cloud Storage location to read the input from. This must be a
	// single file.
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type InputConfig_Contents struct {
	// Content in bytes, represented as a stream of bytes.
	// Note: As with all `bytes` fields, proto buffer messages use a pure binary
	// representation, whereas JSON representations use base64.
	//
	// This field only works for synchronous ProcessDocument method.
	Contents []byte `protobuf:"bytes,3,opt,name=contents,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

func (*InputConfig_Contents) isInputConfig_Source() {}

// The desired output location and metadata.
type OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to Destination:
	//	*OutputConfig_GcsDestination
	Destination isOutputConfig_Destination `protobuf_oneof:"destination"`
	// The max number of pages to include into each output Document shard JSON on
	// Google Cloud Storage.
	//
	// The valid range is [1, 100]. If not specified, the default value is 20.
	//
	// For example, for one pdf file with 100 pages, 100 parsed pages will be
	// produced. If `pages_per_shard` = 20, then 5 Document shard JSON files each
	// containing 20 parsed pages will be written under the prefix
	// [OutputConfig.gcs_destination.uri][] and suffix pages-x-to-y.json where
	// x and y are 1-indexed page numbers.
	//
	// Example GCS outputs with 157 pages and pages_per_shard = 50:
	//
	// <prefix>pages-001-to-050.json
	// <prefix>pages-051-to-100.json
	// <prefix>pages-101-to-150.json
	// <prefix>pages-151-to-157.json
	PagesPerShard int32 `protobuf:"varint,2,opt,name=pages_per_shard,json=pagesPerShard,proto3" json:"pages_per_shard,omitempty"`
}

func (x *OutputConfig) Reset() {
	*x = OutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig) ProtoMessage() {}

func (x *OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig.ProtoReflect.Descriptor instead.
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{12}
}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := x.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *OutputConfig) GetPagesPerShard() int32 {
	if x != nil {
		return x.PagesPerShard
	}
	return 0
}

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	// The Google Cloud Storage location to write the output to.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

// The Google Cloud Storage location where the input file will be read from.
type GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *GcsSource) Reset() {
	*x = GcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsSource) ProtoMessage() {}

func (x *GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsSource.ProtoReflect.Descriptor instead.
func (*GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{13}
}

func (x *GcsSource) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// The Google Cloud Storage location where the output file will be written to.
type GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *GcsDestination) Reset() {
	*x = GcsDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsDestination) ProtoMessage() {}

func (x *GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsDestination.ProtoReflect.Descriptor instead.
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{14}
}

func (x *GcsDestination) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Contains metadata for the BatchProcessDocuments operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the current batch processing.
	State OperationMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.documentai.v1beta2.OperationMetadata_State" json:"state,omitempty"`
	// A message providing more details about the current state of processing.
	StateMessage string `protobuf:"bytes,2,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// The creation time of the operation.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last update time of the operation.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP(), []int{15}
}

func (x *OperationMetadata) GetState() OperationMetadata_State {
	if x != nil {
		return x.State
	}
	return OperationMetadata_STATE_UNSPECIFIED
}

func (x *OperationMetadata) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

var File_google_cloud_documentai_v1beta2_document_understanding_proto protoreflect.FileDescriptor

var file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x6e, 0x64, 0x65, 0x72,
	0x73, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x67, 0x65, 0x6f, 0x6d, 0x65, 0x74, 0x72,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x90, 0x01,
	0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58,
	0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x22, 0xf3, 0x05, 0x0a, 0x16, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x0d, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x6e, 0x0a, 0x17, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x52, 0x15, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x6b, 0x0a, 0x16, 0x66, 0x6f, 0x72, 0x6d, 0x5f,
	0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x45, 0x78,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x14,
	0x66, 0x6f, 0x72, 0x6d, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x12, 0x71, 0x0a, 0x18, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x65,
	0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x45,
	0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52,
	0x16, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x49, 0x0a, 0x0a, 0x6f, 0x63, 0x72, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x4f, 0x63,
	0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x09, 0x6f, 0x63, 0x72, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x12, 0x52, 0x0a, 0x0d, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x4d, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0x77, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x22,
	0xbe, 0x01, 0x0a, 0x17, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0c, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x0d,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x32, 0x0a, 0x09, 0x4f, 0x63, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x25, 0x0a,
	0x0e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x48,
	0x69, 0x6e, 0x74, 0x73, 0x22, 0xe0, 0x01, 0x0a, 0x15, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x78,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x18,
	0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x60, 0x0a, 0x11, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64,
	0x48, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x48, 0x69, 0x6e,
	0x74, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x01, 0x0a, 0x0e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x48, 0x69, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x12, 0x50, 0x0a, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x78,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x79, 0x52, 0x0b, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42,
	0x6f, 0x78, 0x22, 0xb9, 0x01, 0x0a, 0x14, 0x46, 0x6f, 0x72, 0x6d, 0x45, 0x78, 0x74, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x62, 0x0a, 0x14, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x61,
	0x69, 0x72, 0x48, 0x69, 0x6e, 0x74, 0x52, 0x11, 0x6b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x50, 0x61, 0x69, 0x72, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x45,
	0x0a, 0x10, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x61, 0x69, 0x72, 0x48, 0x69,
	0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0x57, 0x0a, 0x16, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x45,
	0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x24,
	0x0a, 0x0c, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x14,
	0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x22, 0xa4, 0x01, 0x0a, 0x0b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x1c, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xa1, 0x01, 0x0a, 0x0c,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5a, 0x0a, 0x0f,
	0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0f, 0x70, 0x61, 0x67, 0x65,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0d, 0x70, 0x61, 0x67, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x68, 0x61, 0x72, 0x64,
	0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x22, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x15, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03,
	0x75, 0x72, 0x69, 0x22, 0x27, 0x0a, 0x0e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0xf4, 0x02, 0x0a,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x4e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x22, 0x70, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07,
	0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43,
	0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x06, 0x32, 0xa3, 0x05, 0x0a, 0x1c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x55, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xbc, 0x02, 0x0a, 0x15, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc4, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x7e, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x38, 0x22, 0x33, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0xca, 0x41,
	0x32, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0xf1, 0x01, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x7a, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x74, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x3a,
	0x01, 0x2a, 0x5a, 0x33, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x3a, 0x01, 0x2a, 0x1a, 0x50, 0xca, 0x41, 0x1c, 0x75, 0x73, 0x2d, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xec, 0x01, 0x0a, 0x23, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x42, 0x0f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x69, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x32, 0x3b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0xaa,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61,
	0x32, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x5c, 0x56, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescOnce sync.Once
	file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescData = file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDesc
)

func file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescGZIP() []byte {
	file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescOnce.Do(func() {
		file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescData)
	})
	return file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDescData
}

var file_google_cloud_documentai_v1beta2_document_understanding_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_cloud_documentai_v1beta2_document_understanding_proto_goTypes = []interface{}{
	(OperationMetadata_State)(0),          // 0: google.cloud.documentai.v1beta2.OperationMetadata.State
	(*BatchProcessDocumentsRequest)(nil),  // 1: google.cloud.documentai.v1beta2.BatchProcessDocumentsRequest
	(*ProcessDocumentRequest)(nil),        // 2: google.cloud.documentai.v1beta2.ProcessDocumentRequest
	(*BatchProcessDocumentsResponse)(nil), // 3: google.cloud.documentai.v1beta2.BatchProcessDocumentsResponse
	(*ProcessDocumentResponse)(nil),       // 4: google.cloud.documentai.v1beta2.ProcessDocumentResponse
	(*OcrParams)(nil),                     // 5: google.cloud.documentai.v1beta2.OcrParams
	(*TableExtractionParams)(nil),         // 6: google.cloud.documentai.v1beta2.TableExtractionParams
	(*TableBoundHint)(nil),                // 7: google.cloud.documentai.v1beta2.TableBoundHint
	(*FormExtractionParams)(nil),          // 8: google.cloud.documentai.v1beta2.FormExtractionParams
	(*KeyValuePairHint)(nil),              // 9: google.cloud.documentai.v1beta2.KeyValuePairHint
	(*EntityExtractionParams)(nil),        // 10: google.cloud.documentai.v1beta2.EntityExtractionParams
	(*AutoMlParams)(nil),                  // 11: google.cloud.documentai.v1beta2.AutoMlParams
	(*InputConfig)(nil),                   // 12: google.cloud.documentai.v1beta2.InputConfig
	(*OutputConfig)(nil),                  // 13: google.cloud.documentai.v1beta2.OutputConfig
	(*GcsSource)(nil),                     // 14: google.cloud.documentai.v1beta2.GcsSource
	(*GcsDestination)(nil),                // 15: google.cloud.documentai.v1beta2.GcsDestination
	(*OperationMetadata)(nil),             // 16: google.cloud.documentai.v1beta2.OperationMetadata
	(*BoundingPoly)(nil),                  // 17: google.cloud.documentai.v1beta2.BoundingPoly
	(*timestamppb.Timestamp)(nil),         // 18: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),         // 19: google.longrunning.Operation
	(*Document)(nil),                      // 20: google.cloud.documentai.v1beta2.Document
}
var file_google_cloud_documentai_v1beta2_document_understanding_proto_depIdxs = []int32{
	2,  // 0: google.cloud.documentai.v1beta2.BatchProcessDocumentsRequest.requests:type_name -> google.cloud.documentai.v1beta2.ProcessDocumentRequest
	12, // 1: google.cloud.documentai.v1beta2.ProcessDocumentRequest.input_config:type_name -> google.cloud.documentai.v1beta2.InputConfig
	13, // 2: google.cloud.documentai.v1beta2.ProcessDocumentRequest.output_config:type_name -> google.cloud.documentai.v1beta2.OutputConfig
	6,  // 3: google.cloud.documentai.v1beta2.ProcessDocumentRequest.table_extraction_params:type_name -> google.cloud.documentai.v1beta2.TableExtractionParams
	8,  // 4: google.cloud.documentai.v1beta2.ProcessDocumentRequest.form_extraction_params:type_name -> google.cloud.documentai.v1beta2.FormExtractionParams
	10, // 5: google.cloud.documentai.v1beta2.ProcessDocumentRequest.entity_extraction_params:type_name -> google.cloud.documentai.v1beta2.EntityExtractionParams
	5,  // 6: google.cloud.documentai.v1beta2.ProcessDocumentRequest.ocr_params:type_name -> google.cloud.documentai.v1beta2.OcrParams
	11, // 7: google.cloud.documentai.v1beta2.ProcessDocumentRequest.automl_params:type_name -> google.cloud.documentai.v1beta2.AutoMlParams
	4,  // 8: google.cloud.documentai.v1beta2.BatchProcessDocumentsResponse.responses:type_name -> google.cloud.documentai.v1beta2.ProcessDocumentResponse
	12, // 9: google.cloud.documentai.v1beta2.ProcessDocumentResponse.input_config:type_name -> google.cloud.documentai.v1beta2.InputConfig
	13, // 10: google.cloud.documentai.v1beta2.ProcessDocumentResponse.output_config:type_name -> google.cloud.documentai.v1beta2.OutputConfig
	7,  // 11: google.cloud.documentai.v1beta2.TableExtractionParams.table_bound_hints:type_name -> google.cloud.documentai.v1beta2.TableBoundHint
	17, // 12: google.cloud.documentai.v1beta2.TableBoundHint.bounding_box:type_name -> google.cloud.documentai.v1beta2.BoundingPoly
	9,  // 13: google.cloud.documentai.v1beta2.FormExtractionParams.key_value_pair_hints:type_name -> google.cloud.documentai.v1beta2.KeyValuePairHint
	14, // 14: google.cloud.documentai.v1beta2.InputConfig.gcs_source:type_name -> google.cloud.documentai.v1beta2.GcsSource
	15, // 15: google.cloud.documentai.v1beta2.OutputConfig.gcs_destination:type_name -> google.cloud.documentai.v1beta2.GcsDestination
	0,  // 16: google.cloud.documentai.v1beta2.OperationMetadata.state:type_name -> google.cloud.documentai.v1beta2.OperationMetadata.State
	18, // 17: google.cloud.documentai.v1beta2.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	18, // 18: google.cloud.documentai.v1beta2.OperationMetadata.update_time:type_name -> google.protobuf.Timestamp
	1,  // 19: google.cloud.documentai.v1beta2.DocumentUnderstandingService.BatchProcessDocuments:input_type -> google.cloud.documentai.v1beta2.BatchProcessDocumentsRequest
	2,  // 20: google.cloud.documentai.v1beta2.DocumentUnderstandingService.ProcessDocument:input_type -> google.cloud.documentai.v1beta2.ProcessDocumentRequest
	19, // 21: google.cloud.documentai.v1beta2.DocumentUnderstandingService.BatchProcessDocuments:output_type -> google.longrunning.Operation
	20, // 22: google.cloud.documentai.v1beta2.DocumentUnderstandingService.ProcessDocument:output_type -> google.cloud.documentai.v1beta2.Document
	21, // [21:23] is the sub-list for method output_type
	19, // [19:21] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_documentai_v1beta2_document_understanding_proto_init() }
func file_google_cloud_documentai_v1beta2_document_understanding_proto_init() {
	if File_google_cloud_documentai_v1beta2_document_understanding_proto != nil {
		return
	}
	file_google_cloud_documentai_v1beta2_document_proto_init()
	file_google_cloud_documentai_v1beta2_geometry_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessDocumentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessDocumentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessDocumentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessDocumentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OcrParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableExtractionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableBoundHint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FormExtractionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyValuePairHint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntityExtractionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutoMlParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*InputConfig_GcsSource)(nil),
		(*InputConfig_Contents)(nil),
	}
	file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*OutputConfig_GcsDestination)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_documentai_v1beta2_document_understanding_proto_goTypes,
		DependencyIndexes: file_google_cloud_documentai_v1beta2_document_understanding_proto_depIdxs,
		EnumInfos:         file_google_cloud_documentai_v1beta2_document_understanding_proto_enumTypes,
		MessageInfos:      file_google_cloud_documentai_v1beta2_document_understanding_proto_msgTypes,
	}.Build()
	File_google_cloud_documentai_v1beta2_document_understanding_proto = out.File
	file_google_cloud_documentai_v1beta2_document_understanding_proto_rawDesc = nil
	file_google_cloud_documentai_v1beta2_document_understanding_proto_goTypes = nil
	file_google_cloud_documentai_v1beta2_document_understanding_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DocumentUnderstandingServiceClient is the client API for DocumentUnderstandingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DocumentUnderstandingServiceClient interface {
	// LRO endpoint to batch process many documents. The output is written
	// to Cloud Storage as JSON in the [Document] format.
	BatchProcessDocuments(ctx context.Context, in *BatchProcessDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Processes a single document.
	ProcessDocument(ctx context.Context, in *ProcessDocumentRequest, opts ...grpc.CallOption) (*Document, error)
}

type documentUnderstandingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentUnderstandingServiceClient(cc grpc.ClientConnInterface) DocumentUnderstandingServiceClient {
	return &documentUnderstandingServiceClient{cc}
}

func (c *documentUnderstandingServiceClient) BatchProcessDocuments(ctx context.Context, in *BatchProcessDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta2.DocumentUnderstandingService/BatchProcessDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentUnderstandingServiceClient) ProcessDocument(ctx context.Context, in *ProcessDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1beta2.DocumentUnderstandingService/ProcessDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentUnderstandingServiceServer is the server API for DocumentUnderstandingService service.
type DocumentUnderstandingServiceServer interface {
	// LRO endpoint to batch process many documents. The output is written
	// to Cloud Storage as JSON in the [Document] format.
	BatchProcessDocuments(context.Context, *BatchProcessDocumentsRequest) (*longrunning.Operation, error)
	// Processes a single document.
	ProcessDocument(context.Context, *ProcessDocumentRequest) (*Document, error)
}

// UnimplementedDocumentUnderstandingServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDocumentUnderstandingServiceServer struct {
}

func (*UnimplementedDocumentUnderstandingServiceServer) BatchProcessDocuments(context.Context, *BatchProcessDocumentsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchProcessDocuments not implemented")
}
func (*UnimplementedDocumentUnderstandingServiceServer) ProcessDocument(context.Context, *ProcessDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProcessDocument not implemented")
}

func RegisterDocumentUnderstandingServiceServer(s *grpc.Server, srv DocumentUnderstandingServiceServer) {
	s.RegisterService(&_DocumentUnderstandingService_serviceDesc, srv)
}

func _DocumentUnderstandingService_BatchProcessDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchProcessDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentUnderstandingServiceServer).BatchProcessDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta2.DocumentUnderstandingService/BatchProcessDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentUnderstandingServiceServer).BatchProcessDocuments(ctx, req.(*BatchProcessDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentUnderstandingService_ProcessDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentUnderstandingServiceServer).ProcessDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1beta2.DocumentUnderstandingService/ProcessDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentUnderstandingServiceServer).ProcessDocument(ctx, req.(*ProcessDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DocumentUnderstandingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.documentai.v1beta2.DocumentUnderstandingService",
	HandlerType: (*DocumentUnderstandingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchProcessDocuments",
			Handler:    _DocumentUnderstandingService_BatchProcessDocuments_Handler,
		},
		{
			MethodName: "ProcessDocument",
			Handler:    _DocumentUnderstandingService_ProcessDocument_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/documentai/v1beta2/document_understanding.proto",
}
