// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/bigquery/storage/v1alpha2/storage.proto

package storage

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for `CreateWriteStream`.
type CreateWriteStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Reference to the table to which the stream belongs, in the format
	// of `projects/{project}/datasets/{dataset}/tables/{table}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Stream to be created.
	WriteStream *WriteStream `protobuf:"bytes,2,opt,name=write_stream,json=writeStream,proto3" json:"write_stream,omitempty"`
}

func (x *CreateWriteStreamRequest) Reset() {
	*x = CreateWriteStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWriteStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWriteStreamRequest) ProtoMessage() {}

func (x *CreateWriteStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWriteStreamRequest.ProtoReflect.Descriptor instead.
func (*CreateWriteStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescGZIP(), []int{0}
}

func (x *CreateWriteStreamRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWriteStreamRequest) GetWriteStream() *WriteStream {
	if x != nil {
		return x.WriteStream
	}
	return nil
}

// Request message for `AppendRows`.
type AppendRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The stream that is the target of the append operation. This value must be
	// specified for the initial request. If subsequent requests specify the
	// stream name, it must equal to the value provided in the first request.
	WriteStream string `protobuf:"bytes,1,opt,name=write_stream,json=writeStream,proto3" json:"write_stream,omitempty"`
	// Optional. If present, the write is only performed if the next append offset is same
	// as the provided value. If not present, the write is performed at the
	// current end of stream.
	Offset *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// Input rows. The `writer_schema` field must be specified at the initial
	// request and currently, it will be ignored if specified in following
	// requests. Following requests must have data in the same format as the
	// initial request.
	//
	// Types that are assignable to Rows:
	//	*AppendRowsRequest_ProtoRows
	Rows isAppendRowsRequest_Rows `protobuf_oneof:"rows"`
	// Only initial request setting is respected. If true, drop unknown input
	// fields. Otherwise, the extra fields will cause append to fail. Default
	// value is false.
	IgnoreUnknownFields bool `protobuf:"varint,5,opt,name=ignore_unknown_fields,json=ignoreUnknownFields,proto3" json:"ignore_unknown_fields,omitempty"`
}

func (x *AppendRowsRequest) Reset() {
	*x = AppendRowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppendRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppendRowsRequest) ProtoMessage() {}

func (x *AppendRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppendRowsRequest.ProtoReflect.Descriptor instead.
func (*AppendRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescGZIP(), []int{1}
}

func (x *AppendRowsRequest) GetWriteStream() string {
	if x != nil {
		return x.WriteStream
	}
	return ""
}

func (x *AppendRowsRequest) GetOffset() *wrapperspb.Int64Value {
	if x != nil {
		return x.Offset
	}
	return nil
}

func (m *AppendRowsRequest) GetRows() isAppendRowsRequest_Rows {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (x *AppendRowsRequest) GetProtoRows() *AppendRowsRequest_ProtoData {
	if x, ok := x.GetRows().(*AppendRowsRequest_ProtoRows); ok {
		return x.ProtoRows
	}
	return nil
}

func (x *AppendRowsRequest) GetIgnoreUnknownFields() bool {
	if x != nil {
		return x.IgnoreUnknownFields
	}
	return false
}

type isAppendRowsRequest_Rows interface {
	isAppendRowsRequest_Rows()
}

type AppendRowsRequest_ProtoRows struct {
	ProtoRows *AppendRowsRequest_ProtoData `protobuf:"bytes,4,opt,name=proto_rows,json=protoRows,proto3,oneof"`
}

func (*AppendRowsRequest_ProtoRows) isAppendRowsRequest_Rows() {}

// Response message for `AppendRows`.
type AppendRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Response:
	//	*AppendRowsResponse_Offset
	//	*AppendRowsResponse_Error
	Response isAppendRowsResponse_Response `protobuf_oneof:"response"`
	// If backend detects a schema update, pass it to user so that user can
	// use it to input new type of message. It will be empty when there is no
	// schema updates.
	UpdatedSchema *TableSchema `protobuf:"bytes,3,opt,name=updated_schema,json=updatedSchema,proto3" json:"updated_schema,omitempty"`
}

func (x *AppendRowsResponse) Reset() {
	*x = AppendRowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppendRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppendRowsResponse) ProtoMessage() {}

func (x *AppendRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppendRowsResponse.ProtoReflect.Descriptor instead.
func (*AppendRowsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescGZIP(), []int{2}
}

func (m *AppendRowsResponse) GetResponse() isAppendRowsResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *AppendRowsResponse) GetOffset() int64 {
	if x, ok := x.GetResponse().(*AppendRowsResponse_Offset); ok {
		return x.Offset
	}
	return 0
}

func (x *AppendRowsResponse) GetError() *status.Status {
	if x, ok := x.GetResponse().(*AppendRowsResponse_Error); ok {
		return x.Error
	}
	return nil
}

func (x *AppendRowsResponse) GetUpdatedSchema() *TableSchema {
	if x != nil {
		return x.UpdatedSchema
	}
	return nil
}

type isAppendRowsResponse_Response interface {
	isAppendRowsResponse_Response()
}

type AppendRowsResponse_Offset struct {
	// The row offset at which the last append occurred.
	Offset int64 `protobuf:"varint,1,opt,name=offset,proto3,oneof"`
}

type AppendRowsResponse_Error struct {
	// Error in case of append failure. If set, it means rows are not accepted
	// into the system. Users can retry within the same connection.
	Error *status.Status `protobuf:"bytes,2,opt,name=error,proto3,oneof"`
}

func (*AppendRowsResponse_Offset) isAppendRowsResponse_Response() {}

func (*AppendRowsResponse_Error) isAppendRowsResponse_Response() {}

// Request message for `GetWriteStreamRequest`.
type GetWriteStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the stream to get, in the form of
	// `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWriteStreamRequest) Reset() {
	*x = GetWriteStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWriteStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWriteStreamRequest) ProtoMessage() {}

func (x *GetWriteStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWriteStreamRequest.ProtoReflect.Descriptor instead.
func (*GetWriteStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescGZIP(), []int{3}
}

func (x *GetWriteStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `BatchCommitWriteStreams`.
type BatchCommitWriteStreamsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent table that all the streams should belong to, in the form of
	// `projects/{project}/datasets/{dataset}/tables/{table}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The group of streams that will be committed atomically.
	WriteStreams []string `protobuf:"bytes,2,rep,name=write_streams,json=writeStreams,proto3" json:"write_streams,omitempty"`
}

func (x *BatchCommitWriteStreamsRequest) Reset() {
	*x = BatchCommitWriteStreamsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCommitWriteStreamsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCommitWriteStreamsRequest) ProtoMessage() {}

func (x *BatchCommitWriteStreamsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCommitWriteStreamsRequest.ProtoReflect.Descriptor instead.
func (*BatchCommitWriteStreamsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescGZIP(), []int{4}
}

func (x *BatchCommitWriteStreamsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCommitWriteStreamsRequest) GetWriteStreams() []string {
	if x != nil {
		return x.WriteStreams
	}
	return nil
}

// Response message for `BatchCommitWriteStreams`.
type BatchCommitWriteStreamsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time at which streams were committed in microseconds granularity.
	CommitTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=commit_time,json=commitTime,proto3" json:"commit_time,omitempty"`
}

func (x *BatchCommitWriteStreamsResponse) Reset() {
	*x = BatchCommitWriteStreamsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCommitWriteStreamsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCommitWriteStreamsResponse) ProtoMessage() {}

func (x *BatchCommitWriteStreamsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCommitWriteStreamsResponse.ProtoReflect.Descriptor instead.
func (*BatchCommitWriteStreamsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescGZIP(), []int{5}
}

func (x *BatchCommitWriteStreamsResponse) GetCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTime
	}
	return nil
}

// Request message for invoking `FinalizeWriteStream`.
type FinalizeWriteStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the stream to finalize, in the form of
	// `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *FinalizeWriteStreamRequest) Reset() {
	*x = FinalizeWriteStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeWriteStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeWriteStreamRequest) ProtoMessage() {}

func (x *FinalizeWriteStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeWriteStreamRequest.ProtoReflect.Descriptor instead.
func (*FinalizeWriteStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescGZIP(), []int{6}
}

func (x *FinalizeWriteStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for `FinalizeWriteStream`.
type FinalizeWriteStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of rows in the finalized stream.
	RowCount int64 `protobuf:"varint,1,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
}

func (x *FinalizeWriteStreamResponse) Reset() {
	*x = FinalizeWriteStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeWriteStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeWriteStreamResponse) ProtoMessage() {}

func (x *FinalizeWriteStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeWriteStreamResponse.ProtoReflect.Descriptor instead.
func (*FinalizeWriteStreamResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescGZIP(), []int{7}
}

func (x *FinalizeWriteStreamResponse) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

// Request message for `FlushRows`.
type FlushRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The stream that is the target of the flush operation.
	WriteStream string `protobuf:"bytes,1,opt,name=write_stream,json=writeStream,proto3" json:"write_stream,omitempty"`
	// Ending offset of the flush operation. Rows before this offset(including
	// this offset) will be flushed.
	Offset int64 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *FlushRowsRequest) Reset() {
	*x = FlushRowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FlushRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlushRowsRequest) ProtoMessage() {}

func (x *FlushRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlushRowsRequest.ProtoReflect.Descriptor instead.
func (*FlushRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescGZIP(), []int{8}
}

func (x *FlushRowsRequest) GetWriteStream() string {
	if x != nil {
		return x.WriteStream
	}
	return ""
}

func (x *FlushRowsRequest) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// Respond message for `FlushRows`.
type FlushRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rows before this offset (including this offset) are flushed.
	Offset int64 `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *FlushRowsResponse) Reset() {
	*x = FlushRowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FlushRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlushRowsResponse) ProtoMessage() {}

func (x *FlushRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlushRowsResponse.ProtoReflect.Descriptor instead.
func (*FlushRowsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescGZIP(), []int{9}
}

func (x *FlushRowsResponse) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

type AppendRowsRequest_ProtoData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Proto schema used to serialize the data.
	WriterSchema *ProtoSchema `protobuf:"bytes,1,opt,name=writer_schema,json=writerSchema,proto3" json:"writer_schema,omitempty"`
	// Serialized row data in protobuf message format.
	Rows *ProtoRows `protobuf:"bytes,2,opt,name=rows,proto3" json:"rows,omitempty"`
}

func (x *AppendRowsRequest_ProtoData) Reset() {
	*x = AppendRowsRequest_ProtoData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppendRowsRequest_ProtoData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppendRowsRequest_ProtoData) ProtoMessage() {}

func (x *AppendRowsRequest_ProtoData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppendRowsRequest_ProtoData.ProtoReflect.Descriptor instead.
func (*AppendRowsRequest_ProtoData) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescGZIP(), []int{1, 0}
}

func (x *AppendRowsRequest_ProtoData) GetWriterSchema() *ProtoSchema {
	if x != nil {
		return x.WriterSchema
	}
	return nil
}

func (x *AppendRowsRequest_ProtoData) GetRows() *ProtoRows {
	if x != nil {
		return x.Rows
	}
	return nil
}

var File_google_cloud_bigquery_storage_v1alpha2_storage_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbd, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x0c, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0xf5, 0x03, 0x0a, 0x11, 0x41, 0x70, 0x70,
	0x65, 0x6e, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55,
	0x0a, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0b, 0x77, 0x72, 0x69, 0x74, 0x65, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x38, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12,
	0x64, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x70, 0x70,
	0x65, 0x6e, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f,
	0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x55, 0x6e, 0x6b, 0x6e,
	0x6f, 0x77, 0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x1a, 0xac, 0x01, 0x0a, 0x09, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x44, 0x61, 0x74, 0x61, 0x12, 0x58, 0x0a, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x52, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x45, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x6f,
	0x77, 0x73, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73,
	0x22, 0xc2, 0x01, 0x0a, 0x12, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x5a, 0x0a,
	0x0e, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x0d, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5f, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x0a, 0x24, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x28, 0x0a, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x22, 0x5e, 0x0a, 0x1f, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x1a, 0x46, 0x69, 0x6e,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x3a, 0x0a, 0x1b, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x81, 0x01, 0x0a, 0x10,
	0x46, 0x6c, 0x75, 0x73, 0x68, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x55, 0x0a, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0b, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22,
	0x2b, 0x0a, 0x11, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x32, 0xa8, 0x0c, 0x0a,
	0x0d, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0xe9,
	0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x5d, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x41, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0xe4, 0x01, 0x0a, 0x0a, 0x41,
	0x70, 0x70, 0x65, 0x6e, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x70,
	0x70, 0x65, 0x6e, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x5b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2f, 0x7b, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x28, 0x01, 0x30,
	0x01, 0x12, 0xd1, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x47, 0x65,
	0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e,
	0x22, 0x39, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xeb, 0x01, 0x0a, 0x13, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x39,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xee, 0x01, 0x0a, 0x17, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12,
	0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0xdd, 0x01, 0x0a, 0x09, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x52, 0x6f,
	0x77, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x46, 0x6c, 0x75, 0x73,
	0x68, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x52, 0x6f, 0x77, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x22,
	0x41, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x1a, 0xb0, 0x01, 0xca, 0x41, 0x1e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x8b, 0x01, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x69, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x64, 0x61, 0x74, 0x61, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x7b, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x5a, 0x4d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x3b, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescData = file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDesc
)

func file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescData)
	})
	return file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDescData
}

var file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_bigquery_storage_v1alpha2_storage_proto_goTypes = []interface{}{
	(*CreateWriteStreamRequest)(nil),        // 0: google.cloud.bigquery.storage.v1alpha2.CreateWriteStreamRequest
	(*AppendRowsRequest)(nil),               // 1: google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest
	(*AppendRowsResponse)(nil),              // 2: google.cloud.bigquery.storage.v1alpha2.AppendRowsResponse
	(*GetWriteStreamRequest)(nil),           // 3: google.cloud.bigquery.storage.v1alpha2.GetWriteStreamRequest
	(*BatchCommitWriteStreamsRequest)(nil),  // 4: google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsRequest
	(*BatchCommitWriteStreamsResponse)(nil), // 5: google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsResponse
	(*FinalizeWriteStreamRequest)(nil),      // 6: google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamRequest
	(*FinalizeWriteStreamResponse)(nil),     // 7: google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamResponse
	(*FlushRowsRequest)(nil),                // 8: google.cloud.bigquery.storage.v1alpha2.FlushRowsRequest
	(*FlushRowsResponse)(nil),               // 9: google.cloud.bigquery.storage.v1alpha2.FlushRowsResponse
	(*AppendRowsRequest_ProtoData)(nil),     // 10: google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData
	(*WriteStream)(nil),                     // 11: google.cloud.bigquery.storage.v1alpha2.WriteStream
	(*wrapperspb.Int64Value)(nil),           // 12: google.protobuf.Int64Value
	(*status.Status)(nil),                   // 13: google.rpc.Status
	(*TableSchema)(nil),                     // 14: google.cloud.bigquery.storage.v1alpha2.TableSchema
	(*timestamppb.Timestamp)(nil),           // 15: google.protobuf.Timestamp
	(*ProtoSchema)(nil),                     // 16: google.cloud.bigquery.storage.v1alpha2.ProtoSchema
	(*ProtoRows)(nil),                       // 17: google.cloud.bigquery.storage.v1alpha2.ProtoRows
}
var file_google_cloud_bigquery_storage_v1alpha2_storage_proto_depIdxs = []int32{
	11, // 0: google.cloud.bigquery.storage.v1alpha2.CreateWriteStreamRequest.write_stream:type_name -> google.cloud.bigquery.storage.v1alpha2.WriteStream
	12, // 1: google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.offset:type_name -> google.protobuf.Int64Value
	10, // 2: google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.proto_rows:type_name -> google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData
	13, // 3: google.cloud.bigquery.storage.v1alpha2.AppendRowsResponse.error:type_name -> google.rpc.Status
	14, // 4: google.cloud.bigquery.storage.v1alpha2.AppendRowsResponse.updated_schema:type_name -> google.cloud.bigquery.storage.v1alpha2.TableSchema
	15, // 5: google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsResponse.commit_time:type_name -> google.protobuf.Timestamp
	16, // 6: google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData.writer_schema:type_name -> google.cloud.bigquery.storage.v1alpha2.ProtoSchema
	17, // 7: google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest.ProtoData.rows:type_name -> google.cloud.bigquery.storage.v1alpha2.ProtoRows
	0,  // 8: google.cloud.bigquery.storage.v1alpha2.BigQueryWrite.CreateWriteStream:input_type -> google.cloud.bigquery.storage.v1alpha2.CreateWriteStreamRequest
	1,  // 9: google.cloud.bigquery.storage.v1alpha2.BigQueryWrite.AppendRows:input_type -> google.cloud.bigquery.storage.v1alpha2.AppendRowsRequest
	3,  // 10: google.cloud.bigquery.storage.v1alpha2.BigQueryWrite.GetWriteStream:input_type -> google.cloud.bigquery.storage.v1alpha2.GetWriteStreamRequest
	6,  // 11: google.cloud.bigquery.storage.v1alpha2.BigQueryWrite.FinalizeWriteStream:input_type -> google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamRequest
	4,  // 12: google.cloud.bigquery.storage.v1alpha2.BigQueryWrite.BatchCommitWriteStreams:input_type -> google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsRequest
	8,  // 13: google.cloud.bigquery.storage.v1alpha2.BigQueryWrite.FlushRows:input_type -> google.cloud.bigquery.storage.v1alpha2.FlushRowsRequest
	11, // 14: google.cloud.bigquery.storage.v1alpha2.BigQueryWrite.CreateWriteStream:output_type -> google.cloud.bigquery.storage.v1alpha2.WriteStream
	2,  // 15: google.cloud.bigquery.storage.v1alpha2.BigQueryWrite.AppendRows:output_type -> google.cloud.bigquery.storage.v1alpha2.AppendRowsResponse
	11, // 16: google.cloud.bigquery.storage.v1alpha2.BigQueryWrite.GetWriteStream:output_type -> google.cloud.bigquery.storage.v1alpha2.WriteStream
	7,  // 17: google.cloud.bigquery.storage.v1alpha2.BigQueryWrite.FinalizeWriteStream:output_type -> google.cloud.bigquery.storage.v1alpha2.FinalizeWriteStreamResponse
	5,  // 18: google.cloud.bigquery.storage.v1alpha2.BigQueryWrite.BatchCommitWriteStreams:output_type -> google.cloud.bigquery.storage.v1alpha2.BatchCommitWriteStreamsResponse
	9,  // 19: google.cloud.bigquery.storage.v1alpha2.BigQueryWrite.FlushRows:output_type -> google.cloud.bigquery.storage.v1alpha2.FlushRowsResponse
	14, // [14:20] is the sub-list for method output_type
	8,  // [8:14] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_storage_v1alpha2_storage_proto_init() }
func file_google_cloud_bigquery_storage_v1alpha2_storage_proto_init() {
	if File_google_cloud_bigquery_storage_v1alpha2_storage_proto != nil {
		return
	}
	file_google_cloud_bigquery_storage_v1alpha2_protobuf_proto_init()
	file_google_cloud_bigquery_storage_v1alpha2_stream_proto_init()
	file_google_cloud_bigquery_storage_v1alpha2_table_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWriteStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppendRowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppendRowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWriteStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCommitWriteStreamsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCommitWriteStreamsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeWriteStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeWriteStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FlushRowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FlushRowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppendRowsRequest_ProtoData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*AppendRowsRequest_ProtoRows)(nil),
	}
	file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*AppendRowsResponse_Offset)(nil),
		(*AppendRowsResponse_Error)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_bigquery_storage_v1alpha2_storage_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_storage_v1alpha2_storage_proto_depIdxs,
		MessageInfos:      file_google_cloud_bigquery_storage_v1alpha2_storage_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_storage_v1alpha2_storage_proto = out.File
	file_google_cloud_bigquery_storage_v1alpha2_storage_proto_rawDesc = nil
	file_google_cloud_bigquery_storage_v1alpha2_storage_proto_goTypes = nil
	file_google_cloud_bigquery_storage_v1alpha2_storage_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BigQueryWriteClient is the client API for BigQueryWrite service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BigQueryWriteClient interface {
	// Creates a write stream to the given table.
	CreateWriteStream(ctx context.Context, in *CreateWriteStreamRequest, opts ...grpc.CallOption) (*WriteStream, error)
	// Appends data to the given stream.
	//
	// If `offset` is specified, the `offset` is checked against the end of
	// stream. The server returns `OUT_OF_RANGE` in `AppendRowsResponse` if an
	// attempt is made to append to an offset beyond the current end of the stream
	// or `ALREADY_EXISTS` if user provids an `offset` that has already been
	// written to. User can retry with adjusted offset within the same RPC
	// stream. If `offset` is not specified, append happens at the end of the
	// stream.
	//
	// The response contains the offset at which the append happened. Responses
	// are received in the same order in which requests are sent. There will be
	// one response for each successful request. If the `offset` is not set in
	// response, it means append didn't happen due to some errors. If one request
	// fails, all the subsequent requests will also fail until a success request
	// is made again.
	//
	// If the stream is of `PENDING` type, data will only be available for read
	// operations after the stream is committed.
	AppendRows(ctx context.Context, opts ...grpc.CallOption) (BigQueryWrite_AppendRowsClient, error)
	// Gets a write stream.
	GetWriteStream(ctx context.Context, in *GetWriteStreamRequest, opts ...grpc.CallOption) (*WriteStream, error)
	// Finalize a write stream so that no new data can be appended to the
	// stream.
	FinalizeWriteStream(ctx context.Context, in *FinalizeWriteStreamRequest, opts ...grpc.CallOption) (*FinalizeWriteStreamResponse, error)
	// Atomically commits a group of `PENDING` streams that belong to the same
	// `parent` table.
	// Streams must be finalized before commit and cannot be committed multiple
	// times. Once a stream is committed, data in the stream becomes available
	// for read operations.
	BatchCommitWriteStreams(ctx context.Context, in *BatchCommitWriteStreamsRequest, opts ...grpc.CallOption) (*BatchCommitWriteStreamsResponse, error)
	// Flushes rows to a BUFFERED stream.
	// If users are appending rows to BUFFERED stream, flush operation is
	// required in order for the rows to become available for reading. A
	// Flush operation flushes up to any previously flushed offset in a BUFFERED
	// stream, to the offset specified in the request.
	FlushRows(ctx context.Context, in *FlushRowsRequest, opts ...grpc.CallOption) (*FlushRowsResponse, error)
}

type bigQueryWriteClient struct {
	cc grpc.ClientConnInterface
}

func NewBigQueryWriteClient(cc grpc.ClientConnInterface) BigQueryWriteClient {
	return &bigQueryWriteClient{cc}
}

func (c *bigQueryWriteClient) CreateWriteStream(ctx context.Context, in *CreateWriteStreamRequest, opts ...grpc.CallOption) (*WriteStream, error) {
	out := new(WriteStream)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/CreateWriteStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryWriteClient) AppendRows(ctx context.Context, opts ...grpc.CallOption) (BigQueryWrite_AppendRowsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BigQueryWrite_serviceDesc.Streams[0], "/google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/AppendRows", opts...)
	if err != nil {
		return nil, err
	}
	x := &bigQueryWriteAppendRowsClient{stream}
	return x, nil
}

type BigQueryWrite_AppendRowsClient interface {
	Send(*AppendRowsRequest) error
	Recv() (*AppendRowsResponse, error)
	grpc.ClientStream
}

type bigQueryWriteAppendRowsClient struct {
	grpc.ClientStream
}

func (x *bigQueryWriteAppendRowsClient) Send(m *AppendRowsRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *bigQueryWriteAppendRowsClient) Recv() (*AppendRowsResponse, error) {
	m := new(AppendRowsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigQueryWriteClient) GetWriteStream(ctx context.Context, in *GetWriteStreamRequest, opts ...grpc.CallOption) (*WriteStream, error) {
	out := new(WriteStream)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/GetWriteStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryWriteClient) FinalizeWriteStream(ctx context.Context, in *FinalizeWriteStreamRequest, opts ...grpc.CallOption) (*FinalizeWriteStreamResponse, error) {
	out := new(FinalizeWriteStreamResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/FinalizeWriteStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryWriteClient) BatchCommitWriteStreams(ctx context.Context, in *BatchCommitWriteStreamsRequest, opts ...grpc.CallOption) (*BatchCommitWriteStreamsResponse, error) {
	out := new(BatchCommitWriteStreamsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/BatchCommitWriteStreams", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryWriteClient) FlushRows(ctx context.Context, in *FlushRowsRequest, opts ...grpc.CallOption) (*FlushRowsResponse, error) {
	out := new(FlushRowsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/FlushRows", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigQueryWriteServer is the server API for BigQueryWrite service.
type BigQueryWriteServer interface {
	// Creates a write stream to the given table.
	CreateWriteStream(context.Context, *CreateWriteStreamRequest) (*WriteStream, error)
	// Appends data to the given stream.
	//
	// If `offset` is specified, the `offset` is checked against the end of
	// stream. The server returns `OUT_OF_RANGE` in `AppendRowsResponse` if an
	// attempt is made to append to an offset beyond the current end of the stream
	// or `ALREADY_EXISTS` if user provids an `offset` that has already been
	// written to. User can retry with adjusted offset within the same RPC
	// stream. If `offset` is not specified, append happens at the end of the
	// stream.
	//
	// The response contains the offset at which the append happened. Responses
	// are received in the same order in which requests are sent. There will be
	// one response for each successful request. If the `offset` is not set in
	// response, it means append didn't happen due to some errors. If one request
	// fails, all the subsequent requests will also fail until a success request
	// is made again.
	//
	// If the stream is of `PENDING` type, data will only be available for read
	// operations after the stream is committed.
	AppendRows(BigQueryWrite_AppendRowsServer) error
	// Gets a write stream.
	GetWriteStream(context.Context, *GetWriteStreamRequest) (*WriteStream, error)
	// Finalize a write stream so that no new data can be appended to the
	// stream.
	FinalizeWriteStream(context.Context, *FinalizeWriteStreamRequest) (*FinalizeWriteStreamResponse, error)
	// Atomically commits a group of `PENDING` streams that belong to the same
	// `parent` table.
	// Streams must be finalized before commit and cannot be committed multiple
	// times. Once a stream is committed, data in the stream becomes available
	// for read operations.
	BatchCommitWriteStreams(context.Context, *BatchCommitWriteStreamsRequest) (*BatchCommitWriteStreamsResponse, error)
	// Flushes rows to a BUFFERED stream.
	// If users are appending rows to BUFFERED stream, flush operation is
	// required in order for the rows to become available for reading. A
	// Flush operation flushes up to any previously flushed offset in a BUFFERED
	// stream, to the offset specified in the request.
	FlushRows(context.Context, *FlushRowsRequest) (*FlushRowsResponse, error)
}

// UnimplementedBigQueryWriteServer can be embedded to have forward compatible implementations.
type UnimplementedBigQueryWriteServer struct {
}

func (*UnimplementedBigQueryWriteServer) CreateWriteStream(context.Context, *CreateWriteStreamRequest) (*WriteStream, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateWriteStream not implemented")
}
func (*UnimplementedBigQueryWriteServer) AppendRows(BigQueryWrite_AppendRowsServer) error {
	return status1.Errorf(codes.Unimplemented, "method AppendRows not implemented")
}
func (*UnimplementedBigQueryWriteServer) GetWriteStream(context.Context, *GetWriteStreamRequest) (*WriteStream, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetWriteStream not implemented")
}
func (*UnimplementedBigQueryWriteServer) FinalizeWriteStream(context.Context, *FinalizeWriteStreamRequest) (*FinalizeWriteStreamResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FinalizeWriteStream not implemented")
}
func (*UnimplementedBigQueryWriteServer) BatchCommitWriteStreams(context.Context, *BatchCommitWriteStreamsRequest) (*BatchCommitWriteStreamsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchCommitWriteStreams not implemented")
}
func (*UnimplementedBigQueryWriteServer) FlushRows(context.Context, *FlushRowsRequest) (*FlushRowsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FlushRows not implemented")
}

func RegisterBigQueryWriteServer(s *grpc.Server, srv BigQueryWriteServer) {
	s.RegisterService(&_BigQueryWrite_serviceDesc, srv)
}

func _BigQueryWrite_CreateWriteStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWriteStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).CreateWriteStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/CreateWriteStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).CreateWriteStream(ctx, req.(*CreateWriteStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryWrite_AppendRows_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BigQueryWriteServer).AppendRows(&bigQueryWriteAppendRowsServer{stream})
}

type BigQueryWrite_AppendRowsServer interface {
	Send(*AppendRowsResponse) error
	Recv() (*AppendRowsRequest, error)
	grpc.ServerStream
}

type bigQueryWriteAppendRowsServer struct {
	grpc.ServerStream
}

func (x *bigQueryWriteAppendRowsServer) Send(m *AppendRowsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *bigQueryWriteAppendRowsServer) Recv() (*AppendRowsRequest, error) {
	m := new(AppendRowsRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _BigQueryWrite_GetWriteStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWriteStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).GetWriteStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/GetWriteStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).GetWriteStream(ctx, req.(*GetWriteStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryWrite_FinalizeWriteStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeWriteStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).FinalizeWriteStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/FinalizeWriteStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).FinalizeWriteStream(ctx, req.(*FinalizeWriteStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryWrite_BatchCommitWriteStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCommitWriteStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).BatchCommitWriteStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/BatchCommitWriteStreams",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).BatchCommitWriteStreams(ctx, req.(*BatchCommitWriteStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryWrite_FlushRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FlushRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).FlushRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1alpha2.BigQueryWrite/FlushRows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).FlushRows(ctx, req.(*FlushRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigQueryWrite_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.storage.v1alpha2.BigQueryWrite",
	HandlerType: (*BigQueryWriteServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateWriteStream",
			Handler:    _BigQueryWrite_CreateWriteStream_Handler,
		},
		{
			MethodName: "GetWriteStream",
			Handler:    _BigQueryWrite_GetWriteStream_Handler,
		},
		{
			MethodName: "FinalizeWriteStream",
			Handler:    _BigQueryWrite_FinalizeWriteStream_Handler,
		},
		{
			MethodName: "BatchCommitWriteStreams",
			Handler:    _BigQueryWrite_BatchCommitWriteStreams_Handler,
		},
		{
			MethodName: "FlushRows",
			Handler:    _BigQueryWrite_FlushRows_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "AppendRows",
			Handler:       _BigQueryWrite_AppendRows_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/bigquery/storage/v1alpha2/storage.proto",
}
