// Copyright 2016 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/genomics/v1/reads.proto

package genomics

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type ImportReadGroupSetsRequest_PartitionStrategy int32

const (
	ImportReadGroupSetsRequest_PARTITION_STRATEGY_UNSPECIFIED ImportReadGroupSetsRequest_PartitionStrategy = 0
	// In most cases, this strategy yields one read group set per file. This is
	// the default behavior.
	//
	// Allocate one read group set per file per sample. For BAM files, read
	// groups are considered to share a sample if they have identical sample
	// names. Furthermore, all reads for each file which do not belong to a read
	// group, if any, will be grouped into a single read group set per-file.
	ImportReadGroupSetsRequest_PER_FILE_PER_SAMPLE ImportReadGroupSetsRequest_PartitionStrategy = 1
	// Includes all read groups in all imported files into a single read group
	// set. Requires that the headers for all imported files are equivalent. All
	// reads which do not belong to a read group, if any, will be grouped into a
	// separate read group set.
	ImportReadGroupSetsRequest_MERGE_ALL ImportReadGroupSetsRequest_PartitionStrategy = 2
)

// Enum value maps for ImportReadGroupSetsRequest_PartitionStrategy.
var (
	ImportReadGroupSetsRequest_PartitionStrategy_name = map[int32]string{
		0: "PARTITION_STRATEGY_UNSPECIFIED",
		1: "PER_FILE_PER_SAMPLE",
		2: "MERGE_ALL",
	}
	ImportReadGroupSetsRequest_PartitionStrategy_value = map[string]int32{
		"PARTITION_STRATEGY_UNSPECIFIED": 0,
		"PER_FILE_PER_SAMPLE":            1,
		"MERGE_ALL":                      2,
	}
)

func (x ImportReadGroupSetsRequest_PartitionStrategy) Enum() *ImportReadGroupSetsRequest_PartitionStrategy {
	p := new(ImportReadGroupSetsRequest_PartitionStrategy)
	*p = x
	return p
}

func (x ImportReadGroupSetsRequest_PartitionStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportReadGroupSetsRequest_PartitionStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_genomics_v1_reads_proto_enumTypes[0].Descriptor()
}

func (ImportReadGroupSetsRequest_PartitionStrategy) Type() protoreflect.EnumType {
	return &file_google_genomics_v1_reads_proto_enumTypes[0]
}

func (x ImportReadGroupSetsRequest_PartitionStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportReadGroupSetsRequest_PartitionStrategy.Descriptor instead.
func (ImportReadGroupSetsRequest_PartitionStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{2, 0}
}

// The read group set search request.
type SearchReadGroupSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Restricts this query to read group sets within the given datasets. At least
	// one ID must be provided.
	DatasetIds []string `protobuf:"bytes,1,rep,name=dataset_ids,json=datasetIds,proto3" json:"dataset_ids,omitempty"`
	// Only return read group sets for which a substring of the name matches this
	// string.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 256. The maximum value is 1024.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *SearchReadGroupSetsRequest) Reset() {
	*x = SearchReadGroupSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchReadGroupSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchReadGroupSetsRequest) ProtoMessage() {}

func (x *SearchReadGroupSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchReadGroupSetsRequest.ProtoReflect.Descriptor instead.
func (*SearchReadGroupSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{0}
}

func (x *SearchReadGroupSetsRequest) GetDatasetIds() []string {
	if x != nil {
		return x.DatasetIds
	}
	return nil
}

func (x *SearchReadGroupSetsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchReadGroupSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchReadGroupSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// The read group set search response.
type SearchReadGroupSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching read group sets.
	ReadGroupSets []*ReadGroupSet `protobuf:"bytes,1,rep,name=read_group_sets,json=readGroupSets,proto3" json:"read_group_sets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchReadGroupSetsResponse) Reset() {
	*x = SearchReadGroupSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchReadGroupSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchReadGroupSetsResponse) ProtoMessage() {}

func (x *SearchReadGroupSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchReadGroupSetsResponse.ProtoReflect.Descriptor instead.
func (*SearchReadGroupSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{1}
}

func (x *SearchReadGroupSetsResponse) GetReadGroupSets() []*ReadGroupSet {
	if x != nil {
		return x.ReadGroupSets
	}
	return nil
}

func (x *SearchReadGroupSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The read group set import request.
type ImportReadGroupSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the dataset these read group sets will belong to. The
	// caller must have WRITE permissions to this dataset.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The reference set to which the imported read group sets are aligned to, if
	// any. The reference names of this reference set must be a superset of those
	// found in the imported file headers. If no reference set id is provided, a
	// best effort is made to associate with a matching reference set.
	ReferenceSetId string `protobuf:"bytes,4,opt,name=reference_set_id,json=referenceSetId,proto3" json:"reference_set_id,omitempty"`
	// A list of URIs pointing at [BAM
	// files](https://samtools.github.io/hts-specs/SAMv1.pdf)
	// in Google Cloud Storage.
	// Those URIs can include wildcards (*), but do not add or remove
	// matching files before import has completed.
	//
	// Note that Google Cloud Storage object listing is only eventually
	// consistent: files added may be not be immediately visible to
	// everyone. Thus, if using a wildcard it is preferable not to start
	// the import immediately after the files are created.
	SourceUris []string `protobuf:"bytes,2,rep,name=source_uris,json=sourceUris,proto3" json:"source_uris,omitempty"`
	// The partition strategy describes how read groups are partitioned into read
	// group sets.
	PartitionStrategy ImportReadGroupSetsRequest_PartitionStrategy `protobuf:"varint,5,opt,name=partition_strategy,json=partitionStrategy,proto3,enum=google.genomics.v1.ImportReadGroupSetsRequest_PartitionStrategy" json:"partition_strategy,omitempty"`
}

func (x *ImportReadGroupSetsRequest) Reset() {
	*x = ImportReadGroupSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportReadGroupSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportReadGroupSetsRequest) ProtoMessage() {}

func (x *ImportReadGroupSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportReadGroupSetsRequest.ProtoReflect.Descriptor instead.
func (*ImportReadGroupSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{2}
}

func (x *ImportReadGroupSetsRequest) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *ImportReadGroupSetsRequest) GetReferenceSetId() string {
	if x != nil {
		return x.ReferenceSetId
	}
	return ""
}

func (x *ImportReadGroupSetsRequest) GetSourceUris() []string {
	if x != nil {
		return x.SourceUris
	}
	return nil
}

func (x *ImportReadGroupSetsRequest) GetPartitionStrategy() ImportReadGroupSetsRequest_PartitionStrategy {
	if x != nil {
		return x.PartitionStrategy
	}
	return ImportReadGroupSetsRequest_PARTITION_STRATEGY_UNSPECIFIED
}

// The read group set import response.
type ImportReadGroupSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IDs of the read group sets that were created.
	ReadGroupSetIds []string `protobuf:"bytes,1,rep,name=read_group_set_ids,json=readGroupSetIds,proto3" json:"read_group_set_ids,omitempty"`
}

func (x *ImportReadGroupSetsResponse) Reset() {
	*x = ImportReadGroupSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportReadGroupSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportReadGroupSetsResponse) ProtoMessage() {}

func (x *ImportReadGroupSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportReadGroupSetsResponse.ProtoReflect.Descriptor instead.
func (*ImportReadGroupSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{3}
}

func (x *ImportReadGroupSetsResponse) GetReadGroupSetIds() []string {
	if x != nil {
		return x.ReadGroupSetIds
	}
	return nil
}

// The read group set export request.
type ExportReadGroupSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Google Cloud project ID that owns this
	// export. The caller must have WRITE access to this project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. A Google Cloud Storage URI for the exported BAM file.
	// The currently authenticated user must have write access to the new file.
	// An error will be returned if the URI already contains data.
	ExportUri string `protobuf:"bytes,2,opt,name=export_uri,json=exportUri,proto3" json:"export_uri,omitempty"`
	// Required. The ID of the read group set to export. The caller must have
	// READ access to this read group set.
	ReadGroupSetId string `protobuf:"bytes,3,opt,name=read_group_set_id,json=readGroupSetId,proto3" json:"read_group_set_id,omitempty"`
	// The reference names to export. If this is not specified, all reference
	// sequences, including unmapped reads, are exported.
	// Use `*` to export only unmapped reads.
	ReferenceNames []string `protobuf:"bytes,4,rep,name=reference_names,json=referenceNames,proto3" json:"reference_names,omitempty"`
}

func (x *ExportReadGroupSetRequest) Reset() {
	*x = ExportReadGroupSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportReadGroupSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportReadGroupSetRequest) ProtoMessage() {}

func (x *ExportReadGroupSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportReadGroupSetRequest.ProtoReflect.Descriptor instead.
func (*ExportReadGroupSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{4}
}

func (x *ExportReadGroupSetRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ExportReadGroupSetRequest) GetExportUri() string {
	if x != nil {
		return x.ExportUri
	}
	return ""
}

func (x *ExportReadGroupSetRequest) GetReadGroupSetId() string {
	if x != nil {
		return x.ReadGroupSetId
	}
	return ""
}

func (x *ExportReadGroupSetRequest) GetReferenceNames() []string {
	if x != nil {
		return x.ReferenceNames
	}
	return nil
}

type UpdateReadGroupSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the read group set to be updated. The caller must have WRITE
	// permissions to the dataset associated with this read group set.
	ReadGroupSetId string `protobuf:"bytes,1,opt,name=read_group_set_id,json=readGroupSetId,proto3" json:"read_group_set_id,omitempty"`
	// The new read group set data. See `updateMask` for details on mutability of
	// fields.
	ReadGroupSet *ReadGroupSet `protobuf:"bytes,2,opt,name=read_group_set,json=readGroupSet,proto3" json:"read_group_set,omitempty"`
	// An optional mask specifying which fields to update. Supported fields:
	//
	// * [name][google.genomics.v1.ReadGroupSet.name].
	// * [referenceSetId][google.genomics.v1.ReadGroupSet.reference_set_id].
	//
	// Leaving `updateMask` unset is equivalent to specifying all mutable
	// fields.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateReadGroupSetRequest) Reset() {
	*x = UpdateReadGroupSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateReadGroupSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateReadGroupSetRequest) ProtoMessage() {}

func (x *UpdateReadGroupSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateReadGroupSetRequest.ProtoReflect.Descriptor instead.
func (*UpdateReadGroupSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateReadGroupSetRequest) GetReadGroupSetId() string {
	if x != nil {
		return x.ReadGroupSetId
	}
	return ""
}

func (x *UpdateReadGroupSetRequest) GetReadGroupSet() *ReadGroupSet {
	if x != nil {
		return x.ReadGroupSet
	}
	return nil
}

func (x *UpdateReadGroupSetRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

type DeleteReadGroupSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the read group set to be deleted. The caller must have WRITE
	// permissions to the dataset associated with this read group set.
	ReadGroupSetId string `protobuf:"bytes,1,opt,name=read_group_set_id,json=readGroupSetId,proto3" json:"read_group_set_id,omitempty"`
}

func (x *DeleteReadGroupSetRequest) Reset() {
	*x = DeleteReadGroupSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteReadGroupSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteReadGroupSetRequest) ProtoMessage() {}

func (x *DeleteReadGroupSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteReadGroupSetRequest.ProtoReflect.Descriptor instead.
func (*DeleteReadGroupSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteReadGroupSetRequest) GetReadGroupSetId() string {
	if x != nil {
		return x.ReadGroupSetId
	}
	return ""
}

type GetReadGroupSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the read group set.
	ReadGroupSetId string `protobuf:"bytes,1,opt,name=read_group_set_id,json=readGroupSetId,proto3" json:"read_group_set_id,omitempty"`
}

func (x *GetReadGroupSetRequest) Reset() {
	*x = GetReadGroupSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReadGroupSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReadGroupSetRequest) ProtoMessage() {}

func (x *GetReadGroupSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReadGroupSetRequest.ProtoReflect.Descriptor instead.
func (*GetReadGroupSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{7}
}

func (x *GetReadGroupSetRequest) GetReadGroupSetId() string {
	if x != nil {
		return x.ReadGroupSetId
	}
	return ""
}

type ListCoverageBucketsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the read group set over which coverage is requested.
	ReadGroupSetId string `protobuf:"bytes,1,opt,name=read_group_set_id,json=readGroupSetId,proto3" json:"read_group_set_id,omitempty"`
	// The name of the reference to query, within the reference set associated
	// with this query. Optional.
	ReferenceName string `protobuf:"bytes,3,opt,name=reference_name,json=referenceName,proto3" json:"reference_name,omitempty"`
	// The start position of the range on the reference, 0-based inclusive. If
	// specified, `referenceName` must also be specified. Defaults to 0.
	Start int64 `protobuf:"varint,4,opt,name=start,proto3" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive. If
	// specified, `referenceName` must also be specified. If unset or 0, defaults
	// to the length of the reference.
	End int64 `protobuf:"varint,5,opt,name=end,proto3" json:"end,omitempty"`
	// The desired width of each reported coverage bucket in base pairs. This
	// will be rounded down to the nearest precomputed bucket width; the value
	// of which is returned as `bucketWidth` in the response. Defaults
	// to infinity (each bucket spans an entire reference sequence) or the length
	// of the target range, if specified. The smallest precomputed
	// `bucketWidth` is currently 2048 base pairs; this is subject to
	// change.
	TargetBucketWidth int64 `protobuf:"varint,6,opt,name=target_bucket_width,json=targetBucketWidth,proto3" json:"target_bucket_width,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 1024. The maximum value is 2048.
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListCoverageBucketsRequest) Reset() {
	*x = ListCoverageBucketsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCoverageBucketsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCoverageBucketsRequest) ProtoMessage() {}

func (x *ListCoverageBucketsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCoverageBucketsRequest.ProtoReflect.Descriptor instead.
func (*ListCoverageBucketsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{8}
}

func (x *ListCoverageBucketsRequest) GetReadGroupSetId() string {
	if x != nil {
		return x.ReadGroupSetId
	}
	return ""
}

func (x *ListCoverageBucketsRequest) GetReferenceName() string {
	if x != nil {
		return x.ReferenceName
	}
	return ""
}

func (x *ListCoverageBucketsRequest) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *ListCoverageBucketsRequest) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *ListCoverageBucketsRequest) GetTargetBucketWidth() int64 {
	if x != nil {
		return x.TargetBucketWidth
	}
	return 0
}

func (x *ListCoverageBucketsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCoverageBucketsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// A bucket over which read coverage has been precomputed. A bucket corresponds
// to a specific range of the reference sequence.
type CoverageBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The genomic coordinate range spanned by this bucket.
	Range *Range `protobuf:"bytes,1,opt,name=range,proto3" json:"range,omitempty"`
	// The average number of reads which are aligned to each individual
	// reference base in this bucket.
	MeanCoverage float32 `protobuf:"fixed32,2,opt,name=mean_coverage,json=meanCoverage,proto3" json:"mean_coverage,omitempty"`
}

func (x *CoverageBucket) Reset() {
	*x = CoverageBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CoverageBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CoverageBucket) ProtoMessage() {}

func (x *CoverageBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CoverageBucket.ProtoReflect.Descriptor instead.
func (*CoverageBucket) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{9}
}

func (x *CoverageBucket) GetRange() *Range {
	if x != nil {
		return x.Range
	}
	return nil
}

func (x *CoverageBucket) GetMeanCoverage() float32 {
	if x != nil {
		return x.MeanCoverage
	}
	return 0
}

type ListCoverageBucketsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The length of each coverage bucket in base pairs. Note that buckets at the
	// end of a reference sequence may be shorter. This value is omitted if the
	// bucket width is infinity (the default behaviour, with no range or
	// `targetBucketWidth`).
	BucketWidth int64 `protobuf:"varint,1,opt,name=bucket_width,json=bucketWidth,proto3" json:"bucket_width,omitempty"`
	// The coverage buckets. The list of buckets is sparse; a bucket with 0
	// overlapping reads is not returned. A bucket never crosses more than one
	// reference sequence. Each bucket has width `bucketWidth`, unless
	// its end is the end of the reference sequence.
	CoverageBuckets []*CoverageBucket `protobuf:"bytes,2,rep,name=coverage_buckets,json=coverageBuckets,proto3" json:"coverage_buckets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCoverageBucketsResponse) Reset() {
	*x = ListCoverageBucketsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCoverageBucketsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCoverageBucketsResponse) ProtoMessage() {}

func (x *ListCoverageBucketsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCoverageBucketsResponse.ProtoReflect.Descriptor instead.
func (*ListCoverageBucketsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{10}
}

func (x *ListCoverageBucketsResponse) GetBucketWidth() int64 {
	if x != nil {
		return x.BucketWidth
	}
	return 0
}

func (x *ListCoverageBucketsResponse) GetCoverageBuckets() []*CoverageBucket {
	if x != nil {
		return x.CoverageBuckets
	}
	return nil
}

func (x *ListCoverageBucketsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The read search request.
type SearchReadsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IDs of the read groups sets within which to search for reads. All
	// specified read group sets must be aligned against a common set of reference
	// sequences; this defines the genomic coordinates for the query. Must specify
	// one of `readGroupSetIds` or `readGroupIds`.
	ReadGroupSetIds []string `protobuf:"bytes,1,rep,name=read_group_set_ids,json=readGroupSetIds,proto3" json:"read_group_set_ids,omitempty"`
	// The IDs of the read groups within which to search for reads. All specified
	// read groups must belong to the same read group sets. Must specify one of
	// `readGroupSetIds` or `readGroupIds`.
	ReadGroupIds []string `protobuf:"bytes,5,rep,name=read_group_ids,json=readGroupIds,proto3" json:"read_group_ids,omitempty"`
	// The reference sequence name, for example `chr1`, `1`, or `chrX`. If set to
	// `*`, only unmapped reads are returned. If unspecified, all reads (mapped
	// and unmapped) are returned.
	ReferenceName string `protobuf:"bytes,7,opt,name=reference_name,json=referenceName,proto3" json:"reference_name,omitempty"`
	// The start position of the range on the reference, 0-based inclusive. If
	// specified, `referenceName` must also be specified.
	Start int64 `protobuf:"varint,8,opt,name=start,proto3" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive. If
	// specified, `referenceName` must also be specified.
	End int64 `protobuf:"varint,9,opt,name=end,proto3" json:"end,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 256. The maximum value is 2048.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *SearchReadsRequest) Reset() {
	*x = SearchReadsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchReadsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchReadsRequest) ProtoMessage() {}

func (x *SearchReadsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchReadsRequest.ProtoReflect.Descriptor instead.
func (*SearchReadsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{11}
}

func (x *SearchReadsRequest) GetReadGroupSetIds() []string {
	if x != nil {
		return x.ReadGroupSetIds
	}
	return nil
}

func (x *SearchReadsRequest) GetReadGroupIds() []string {
	if x != nil {
		return x.ReadGroupIds
	}
	return nil
}

func (x *SearchReadsRequest) GetReferenceName() string {
	if x != nil {
		return x.ReferenceName
	}
	return ""
}

func (x *SearchReadsRequest) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *SearchReadsRequest) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *SearchReadsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchReadsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// The read search response.
type SearchReadsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching alignments sorted by mapped genomic coordinate,
	// if any, ascending in position within the same reference. Unmapped reads,
	// which have no position, are returned contiguously and are sorted in
	// ascending lexicographic order by fragment name.
	Alignments []*Read `protobuf:"bytes,1,rep,name=alignments,proto3" json:"alignments,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchReadsResponse) Reset() {
	*x = SearchReadsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchReadsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchReadsResponse) ProtoMessage() {}

func (x *SearchReadsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchReadsResponse.ProtoReflect.Descriptor instead.
func (*SearchReadsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{12}
}

func (x *SearchReadsResponse) GetAlignments() []*Read {
	if x != nil {
		return x.Alignments
	}
	return nil
}

func (x *SearchReadsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The stream reads request.
type StreamReadsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google Cloud project ID which will be billed
	// for this access. The caller must have WRITE access to this project.
	// Required.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The ID of the read group set from which to stream reads.
	ReadGroupSetId string `protobuf:"bytes,2,opt,name=read_group_set_id,json=readGroupSetId,proto3" json:"read_group_set_id,omitempty"`
	// The reference sequence name, for example `chr1`,
	// `1`, or `chrX`. If set to *, only unmapped reads are
	// returned.
	ReferenceName string `protobuf:"bytes,3,opt,name=reference_name,json=referenceName,proto3" json:"reference_name,omitempty"`
	// The start position of the range on the reference, 0-based inclusive. If
	// specified, `referenceName` must also be specified.
	Start int64 `protobuf:"varint,4,opt,name=start,proto3" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive. If
	// specified, `referenceName` must also be specified.
	End int64 `protobuf:"varint,5,opt,name=end,proto3" json:"end,omitempty"`
	// Restricts results to a shard containing approximately `1/totalShards`
	// of the normal response payload for this query. Results from a sharded
	// request are disjoint from those returned by all queries which differ only
	// in their shard parameter. A shard may yield 0 results; this is especially
	// likely for large values of `totalShards`.
	//
	// Valid values are `[0, totalShards)`.
	Shard int32 `protobuf:"varint,6,opt,name=shard,proto3" json:"shard,omitempty"`
	// Specifying `totalShards` causes a disjoint subset of the normal response
	// payload to be returned for each query with a unique `shard` parameter
	// specified. A best effort is made to yield equally sized shards. Sharding
	// can be used to distribute processing amongst workers, where each worker is
	// assigned a unique `shard` number and all workers specify the same
	// `totalShards` number. The union of reads returned for all sharded queries
	// `[0, totalShards)` is equal to those returned by a single unsharded query.
	//
	// Queries for different values of `totalShards` with common divisors will
	// share shard boundaries. For example, streaming `shard` 2 of 5
	// `totalShards` yields the same results as streaming `shard`s 4 and 5 of 10
	// `totalShards`. This property can be leveraged for adaptive retries.
	TotalShards int32 `protobuf:"varint,7,opt,name=total_shards,json=totalShards,proto3" json:"total_shards,omitempty"`
}

func (x *StreamReadsRequest) Reset() {
	*x = StreamReadsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamReadsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamReadsRequest) ProtoMessage() {}

func (x *StreamReadsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamReadsRequest.ProtoReflect.Descriptor instead.
func (*StreamReadsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{13}
}

func (x *StreamReadsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *StreamReadsRequest) GetReadGroupSetId() string {
	if x != nil {
		return x.ReadGroupSetId
	}
	return ""
}

func (x *StreamReadsRequest) GetReferenceName() string {
	if x != nil {
		return x.ReferenceName
	}
	return ""
}

func (x *StreamReadsRequest) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *StreamReadsRequest) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *StreamReadsRequest) GetShard() int32 {
	if x != nil {
		return x.Shard
	}
	return 0
}

func (x *StreamReadsRequest) GetTotalShards() int32 {
	if x != nil {
		return x.TotalShards
	}
	return 0
}

type StreamReadsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Alignments []*Read `protobuf:"bytes,1,rep,name=alignments,proto3" json:"alignments,omitempty"`
}

func (x *StreamReadsResponse) Reset() {
	*x = StreamReadsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_reads_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamReadsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamReadsResponse) ProtoMessage() {}

func (x *StreamReadsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_reads_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamReadsResponse.ProtoReflect.Descriptor instead.
func (*StreamReadsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_reads_proto_rawDescGZIP(), []int{14}
}

func (x *StreamReadsResponse) GetAlignments() []*Read {
	if x != nil {
		return x.Alignments
	}
	return nil
}

var File_google_genomics_v1_reads_proto protoreflect.FileDescriptor

var file_google_genomics_v1_reads_proto_rawDesc = []byte{
	0x0a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x61, 0x64, 0x61, 0x6c, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72,
	0x65, 0x61, 0x64, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8d, 0x01, 0x0a, 0x1a, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x8f, 0x01, 0x0a, 0x1b, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74,
	0x52, 0x0d, 0x72, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd8, 0x02, 0x0a, 0x1a, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12,
	0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x73,
	0x12, 0x6f, 0x0a, 0x12, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x11,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67,
	0x79, 0x22, 0x5f, 0x0a, 0x11, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x22, 0x0a, 0x1e, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x45,
	0x52, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x5f, 0x53, 0x41, 0x4d, 0x50, 0x4c,
	0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x5f, 0x41, 0x4c, 0x4c,
	0x10, 0x02, 0x22, 0x4a, 0x0a, 0x1b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x61, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x2b, 0x0a, 0x12, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x72,
	0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x49, 0x64, 0x73, 0x22, 0xad,
	0x01, 0x0a, 0x19, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x72, 0x69, 0x12, 0x29, 0x0a, 0x11, 0x72, 0x65,
	0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0xcb,
	0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x11,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65,
	0x74, 0x52, 0x0c, 0x72, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x46, 0x0a, 0x19,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x11, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53,
	0x65, 0x74, 0x49, 0x64, 0x22, 0x43, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x52, 0x65, 0x61, 0x64, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29,
	0x0a, 0x11, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x49, 0x64, 0x22, 0x82, 0x02, 0x0a, 0x1a, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x11, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65,
	0x74, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65,
	0x6e, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x57, 0x69, 0x64,
	0x74, 0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x66,
	0x0a, 0x0e, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x2f, 0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x05, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x65, 0x61, 0x6e, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0c, 0x6d, 0x65, 0x61, 0x6e, 0x43, 0x6f,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x22, 0xb7, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x57, 0x69, 0x64, 0x74, 0x68, 0x12, 0x4d, 0x0a, 0x10, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x0f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xf2, 0x01, 0x0a, 0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x12, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65,
	0x74, 0x49, 0x64, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65,
	0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x77, 0x0a, 0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x61, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x0a,
	0x61, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x0a, 0x61, 0x6c, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe6,
	0x01, 0x0a, 0x12, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x61, 0x64, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x11, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x72, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12,
	0x25, 0x0a, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03,
	0x65, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x12, 0x14,
	0x0a, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x68,
	0x61, 0x72, 0x64, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x22, 0x4f, 0x0a, 0x13, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x61, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38,
	0x0a, 0x0a, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x0a, 0x61, 0x6c,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x32, 0x95, 0x01, 0x0a, 0x14, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x7d, 0x0a, 0x0b, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x61, 0x64, 0x73,
	0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x61, 0x64,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x61, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x1b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15, 0x22, 0x10, 0x2f, 0x76, 0x31, 0x2f, 0x72,
	0x65, 0x61, 0x64, 0x73, 0x3a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x3a, 0x01, 0x2a, 0x30, 0x01,
	0x32, 0xd1, 0x09, 0x0a, 0x0d, 0x52, 0x65, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x56, 0x31, 0x12, 0x89, 0x01, 0x0a, 0x13, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x61,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x1d, 0x22, 0x18, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x61, 0x64, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x65, 0x74, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0x9b,
	0x01, 0x0a, 0x12, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x53, 0x65, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x22, 0x2c, 0x2f, 0x76, 0x31,
	0x2f, 0x72, 0x65, 0x61, 0x64, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0x9b, 0x01, 0x0a,
	0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x53, 0x65, 0x74, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65,
	0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65,
	0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x22, 0x18, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x65, 0x61, 0x64, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x65, 0x74, 0x73,
	0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x3a, 0x01, 0x2a, 0x12, 0xa4, 0x01, 0x0a, 0x12, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65,
	0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53,
	0x65, 0x74, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x32, 0x25, 0x2f, 0x76, 0x31, 0x2f,
	0x72, 0x65, 0x61, 0x64, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x7d, 0x3a, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65,
	0x74, 0x12, 0x8a, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x61, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x2d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x27, 0x2a, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x61,
	0x64, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x8e,
	0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53,
	0x65, 0x74, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x61, 0x64, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x74,
	0x22, 0x2d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x27, 0x12, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65,
	0x61, 0x64, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x12,
	0xb5, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37,
	0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x61, 0x64, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x7b, 0x0a, 0x0b, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x61, 0x64, 0x73, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15, 0x22,
	0x10, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x3a, 0x01, 0x2a, 0x42, 0x65, 0x0a, 0x16, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0a,
	0x52, 0x65, 0x61, 0x64, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2f, 0x76, 0x31, 0x3b,
	0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_genomics_v1_reads_proto_rawDescOnce sync.Once
	file_google_genomics_v1_reads_proto_rawDescData = file_google_genomics_v1_reads_proto_rawDesc
)

func file_google_genomics_v1_reads_proto_rawDescGZIP() []byte {
	file_google_genomics_v1_reads_proto_rawDescOnce.Do(func() {
		file_google_genomics_v1_reads_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_genomics_v1_reads_proto_rawDescData)
	})
	return file_google_genomics_v1_reads_proto_rawDescData
}

var file_google_genomics_v1_reads_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_genomics_v1_reads_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_genomics_v1_reads_proto_goTypes = []interface{}{
	(ImportReadGroupSetsRequest_PartitionStrategy)(0), // 0: google.genomics.v1.ImportReadGroupSetsRequest.PartitionStrategy
	(*SearchReadGroupSetsRequest)(nil),                // 1: google.genomics.v1.SearchReadGroupSetsRequest
	(*SearchReadGroupSetsResponse)(nil),               // 2: google.genomics.v1.SearchReadGroupSetsResponse
	(*ImportReadGroupSetsRequest)(nil),                // 3: google.genomics.v1.ImportReadGroupSetsRequest
	(*ImportReadGroupSetsResponse)(nil),               // 4: google.genomics.v1.ImportReadGroupSetsResponse
	(*ExportReadGroupSetRequest)(nil),                 // 5: google.genomics.v1.ExportReadGroupSetRequest
	(*UpdateReadGroupSetRequest)(nil),                 // 6: google.genomics.v1.UpdateReadGroupSetRequest
	(*DeleteReadGroupSetRequest)(nil),                 // 7: google.genomics.v1.DeleteReadGroupSetRequest
	(*GetReadGroupSetRequest)(nil),                    // 8: google.genomics.v1.GetReadGroupSetRequest
	(*ListCoverageBucketsRequest)(nil),                // 9: google.genomics.v1.ListCoverageBucketsRequest
	(*CoverageBucket)(nil),                            // 10: google.genomics.v1.CoverageBucket
	(*ListCoverageBucketsResponse)(nil),               // 11: google.genomics.v1.ListCoverageBucketsResponse
	(*SearchReadsRequest)(nil),                        // 12: google.genomics.v1.SearchReadsRequest
	(*SearchReadsResponse)(nil),                       // 13: google.genomics.v1.SearchReadsResponse
	(*StreamReadsRequest)(nil),                        // 14: google.genomics.v1.StreamReadsRequest
	(*StreamReadsResponse)(nil),                       // 15: google.genomics.v1.StreamReadsResponse
	(*ReadGroupSet)(nil),                              // 16: google.genomics.v1.ReadGroupSet
	(*field_mask.FieldMask)(nil),                      // 17: google.protobuf.FieldMask
	(*Range)(nil),                                     // 18: google.genomics.v1.Range
	(*Read)(nil),                                      // 19: google.genomics.v1.Read
	(*longrunning.Operation)(nil),                     // 20: google.longrunning.Operation
	(*empty.Empty)(nil),                               // 21: google.protobuf.Empty
}
var file_google_genomics_v1_reads_proto_depIdxs = []int32{
	16, // 0: google.genomics.v1.SearchReadGroupSetsResponse.read_group_sets:type_name -> google.genomics.v1.ReadGroupSet
	0,  // 1: google.genomics.v1.ImportReadGroupSetsRequest.partition_strategy:type_name -> google.genomics.v1.ImportReadGroupSetsRequest.PartitionStrategy
	16, // 2: google.genomics.v1.UpdateReadGroupSetRequest.read_group_set:type_name -> google.genomics.v1.ReadGroupSet
	17, // 3: google.genomics.v1.UpdateReadGroupSetRequest.update_mask:type_name -> google.protobuf.FieldMask
	18, // 4: google.genomics.v1.CoverageBucket.range:type_name -> google.genomics.v1.Range
	10, // 5: google.genomics.v1.ListCoverageBucketsResponse.coverage_buckets:type_name -> google.genomics.v1.CoverageBucket
	19, // 6: google.genomics.v1.SearchReadsResponse.alignments:type_name -> google.genomics.v1.Read
	19, // 7: google.genomics.v1.StreamReadsResponse.alignments:type_name -> google.genomics.v1.Read
	14, // 8: google.genomics.v1.StreamingReadService.StreamReads:input_type -> google.genomics.v1.StreamReadsRequest
	3,  // 9: google.genomics.v1.ReadServiceV1.ImportReadGroupSets:input_type -> google.genomics.v1.ImportReadGroupSetsRequest
	5,  // 10: google.genomics.v1.ReadServiceV1.ExportReadGroupSet:input_type -> google.genomics.v1.ExportReadGroupSetRequest
	1,  // 11: google.genomics.v1.ReadServiceV1.SearchReadGroupSets:input_type -> google.genomics.v1.SearchReadGroupSetsRequest
	6,  // 12: google.genomics.v1.ReadServiceV1.UpdateReadGroupSet:input_type -> google.genomics.v1.UpdateReadGroupSetRequest
	7,  // 13: google.genomics.v1.ReadServiceV1.DeleteReadGroupSet:input_type -> google.genomics.v1.DeleteReadGroupSetRequest
	8,  // 14: google.genomics.v1.ReadServiceV1.GetReadGroupSet:input_type -> google.genomics.v1.GetReadGroupSetRequest
	9,  // 15: google.genomics.v1.ReadServiceV1.ListCoverageBuckets:input_type -> google.genomics.v1.ListCoverageBucketsRequest
	12, // 16: google.genomics.v1.ReadServiceV1.SearchReads:input_type -> google.genomics.v1.SearchReadsRequest
	15, // 17: google.genomics.v1.StreamingReadService.StreamReads:output_type -> google.genomics.v1.StreamReadsResponse
	20, // 18: google.genomics.v1.ReadServiceV1.ImportReadGroupSets:output_type -> google.longrunning.Operation
	20, // 19: google.genomics.v1.ReadServiceV1.ExportReadGroupSet:output_type -> google.longrunning.Operation
	2,  // 20: google.genomics.v1.ReadServiceV1.SearchReadGroupSets:output_type -> google.genomics.v1.SearchReadGroupSetsResponse
	16, // 21: google.genomics.v1.ReadServiceV1.UpdateReadGroupSet:output_type -> google.genomics.v1.ReadGroupSet
	21, // 22: google.genomics.v1.ReadServiceV1.DeleteReadGroupSet:output_type -> google.protobuf.Empty
	16, // 23: google.genomics.v1.ReadServiceV1.GetReadGroupSet:output_type -> google.genomics.v1.ReadGroupSet
	11, // 24: google.genomics.v1.ReadServiceV1.ListCoverageBuckets:output_type -> google.genomics.v1.ListCoverageBucketsResponse
	13, // 25: google.genomics.v1.ReadServiceV1.SearchReads:output_type -> google.genomics.v1.SearchReadsResponse
	17, // [17:26] is the sub-list for method output_type
	8,  // [8:17] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_genomics_v1_reads_proto_init() }
func file_google_genomics_v1_reads_proto_init() {
	if File_google_genomics_v1_reads_proto != nil {
		return
	}
	file_google_genomics_v1_range_proto_init()
	file_google_genomics_v1_readalignment_proto_init()
	file_google_genomics_v1_readgroupset_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_genomics_v1_reads_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchReadGroupSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchReadGroupSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportReadGroupSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportReadGroupSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportReadGroupSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateReadGroupSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteReadGroupSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReadGroupSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCoverageBucketsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CoverageBucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCoverageBucketsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchReadsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchReadsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamReadsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_reads_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamReadsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_genomics_v1_reads_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_google_genomics_v1_reads_proto_goTypes,
		DependencyIndexes: file_google_genomics_v1_reads_proto_depIdxs,
		EnumInfos:         file_google_genomics_v1_reads_proto_enumTypes,
		MessageInfos:      file_google_genomics_v1_reads_proto_msgTypes,
	}.Build()
	File_google_genomics_v1_reads_proto = out.File
	file_google_genomics_v1_reads_proto_rawDesc = nil
	file_google_genomics_v1_reads_proto_goTypes = nil
	file_google_genomics_v1_reads_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// StreamingReadServiceClient is the client API for StreamingReadService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StreamingReadServiceClient interface {
	// Returns a stream of all the reads matching the search request, ordered
	// by reference name, position, and ID.
	StreamReads(ctx context.Context, in *StreamReadsRequest, opts ...grpc.CallOption) (StreamingReadService_StreamReadsClient, error)
}

type streamingReadServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewStreamingReadServiceClient(cc grpc.ClientConnInterface) StreamingReadServiceClient {
	return &streamingReadServiceClient{cc}
}

func (c *streamingReadServiceClient) StreamReads(ctx context.Context, in *StreamReadsRequest, opts ...grpc.CallOption) (StreamingReadService_StreamReadsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_StreamingReadService_serviceDesc.Streams[0], "/google.genomics.v1.StreamingReadService/StreamReads", opts...)
	if err != nil {
		return nil, err
	}
	x := &streamingReadServiceStreamReadsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type StreamingReadService_StreamReadsClient interface {
	Recv() (*StreamReadsResponse, error)
	grpc.ClientStream
}

type streamingReadServiceStreamReadsClient struct {
	grpc.ClientStream
}

func (x *streamingReadServiceStreamReadsClient) Recv() (*StreamReadsResponse, error) {
	m := new(StreamReadsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// StreamingReadServiceServer is the server API for StreamingReadService service.
type StreamingReadServiceServer interface {
	// Returns a stream of all the reads matching the search request, ordered
	// by reference name, position, and ID.
	StreamReads(*StreamReadsRequest, StreamingReadService_StreamReadsServer) error
}

// UnimplementedStreamingReadServiceServer can be embedded to have forward compatible implementations.
type UnimplementedStreamingReadServiceServer struct {
}

func (*UnimplementedStreamingReadServiceServer) StreamReads(*StreamReadsRequest, StreamingReadService_StreamReadsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamReads not implemented")
}

func RegisterStreamingReadServiceServer(s *grpc.Server, srv StreamingReadServiceServer) {
	s.RegisterService(&_StreamingReadService_serviceDesc, srv)
}

func _StreamingReadService_StreamReads_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamReadsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StreamingReadServiceServer).StreamReads(m, &streamingReadServiceStreamReadsServer{stream})
}

type StreamingReadService_StreamReadsServer interface {
	Send(*StreamReadsResponse) error
	grpc.ServerStream
}

type streamingReadServiceStreamReadsServer struct {
	grpc.ServerStream
}

func (x *streamingReadServiceStreamReadsServer) Send(m *StreamReadsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _StreamingReadService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.StreamingReadService",
	HandlerType: (*StreamingReadServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamReads",
			Handler:       _StreamingReadService_StreamReads_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/genomics/v1/reads.proto",
}

// ReadServiceV1Client is the client API for ReadServiceV1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReadServiceV1Client interface {
	// Creates read group sets by asynchronously importing the provided
	// information.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The caller must have WRITE permissions to the dataset.
	//
	// ## Notes on [BAM](https://samtools.github.io/hts-specs/SAMv1.pdf) import
	//
	// - Tags will be converted to strings - tag types are not preserved
	// - Comments (`@CO`) in the input file header will not be preserved
	// - Original header order of references (`@SQ`) will not be preserved
	// - Any reverse stranded unmapped reads will be reverse complemented, and
	// their qualities (also the "BQ" and "OQ" tags, if any) will be reversed
	// - Unmapped reads will be stripped of positional information (reference name
	// and position)
	ImportReadGroupSets(ctx context.Context, in *ImportReadGroupSetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports a read group set to a BAM file in Google Cloud Storage.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Note that currently there may be some differences between exported BAM
	// files and the original BAM file at the time of import. See
	// [ImportReadGroupSets][google.genomics.v1.ReadServiceV1.ImportReadGroupSets]
	// for caveats.
	ExportReadGroupSet(ctx context.Context, in *ExportReadGroupSetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Searches for read group sets matching the criteria.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchReadGroupSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L135).
	SearchReadGroupSets(ctx context.Context, in *SearchReadGroupSetsRequest, opts ...grpc.CallOption) (*SearchReadGroupSetsResponse, error)
	// Updates a read group set.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics.
	UpdateReadGroupSet(ctx context.Context, in *UpdateReadGroupSetRequest, opts ...grpc.CallOption) (*ReadGroupSet, error)
	// Deletes a read group set.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteReadGroupSet(ctx context.Context, in *DeleteReadGroupSetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets a read group set by ID.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetReadGroupSet(ctx context.Context, in *GetReadGroupSetRequest, opts ...grpc.CallOption) (*ReadGroupSet, error)
	// Lists fixed width coverage buckets for a read group set, each of which
	// correspond to a range of a reference sequence. Each bucket summarizes
	// coverage information across its corresponding genomic range.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Coverage is defined as the number of reads which are aligned to a given
	// base in the reference sequence. Coverage buckets are available at several
	// precomputed bucket widths, enabling retrieval of various coverage 'zoom
	// levels'. The caller must have READ permissions for the target read group
	// set.
	ListCoverageBuckets(ctx context.Context, in *ListCoverageBucketsRequest, opts ...grpc.CallOption) (*ListCoverageBucketsResponse, error)
	// Gets a list of reads for one or more read group sets.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Reads search operates over a genomic coordinate space of reference sequence
	// & position defined over the reference sequences to which the requested
	// read group sets are aligned.
	//
	// If a target positional range is specified, search returns all reads whose
	// alignment to the reference genome overlap the range. A query which
	// specifies only read group set IDs yields all reads in those read group
	// sets, including unmapped reads.
	//
	// All reads returned (including reads on subsequent pages) are ordered by
	// genomic coordinate (by reference sequence, then position). Reads with
	// equivalent genomic coordinates are returned in an unspecified order. This
	// order is consistent, such that two queries for the same content (regardless
	// of page size) yield reads in the same order across their respective streams
	// of paginated responses.
	//
	// Implements
	// [GlobalAllianceApi.searchReads](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L85).
	SearchReads(ctx context.Context, in *SearchReadsRequest, opts ...grpc.CallOption) (*SearchReadsResponse, error)
}

type readServiceV1Client struct {
	cc grpc.ClientConnInterface
}

func NewReadServiceV1Client(cc grpc.ClientConnInterface) ReadServiceV1Client {
	return &readServiceV1Client{cc}
}

func (c *readServiceV1Client) ImportReadGroupSets(ctx context.Context, in *ImportReadGroupSetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/ImportReadGroupSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) ExportReadGroupSet(ctx context.Context, in *ExportReadGroupSetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/ExportReadGroupSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) SearchReadGroupSets(ctx context.Context, in *SearchReadGroupSetsRequest, opts ...grpc.CallOption) (*SearchReadGroupSetsResponse, error) {
	out := new(SearchReadGroupSetsResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/SearchReadGroupSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) UpdateReadGroupSet(ctx context.Context, in *UpdateReadGroupSetRequest, opts ...grpc.CallOption) (*ReadGroupSet, error) {
	out := new(ReadGroupSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/UpdateReadGroupSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) DeleteReadGroupSet(ctx context.Context, in *DeleteReadGroupSetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/DeleteReadGroupSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) GetReadGroupSet(ctx context.Context, in *GetReadGroupSetRequest, opts ...grpc.CallOption) (*ReadGroupSet, error) {
	out := new(ReadGroupSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/GetReadGroupSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) ListCoverageBuckets(ctx context.Context, in *ListCoverageBucketsRequest, opts ...grpc.CallOption) (*ListCoverageBucketsResponse, error) {
	out := new(ListCoverageBucketsResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/ListCoverageBuckets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) SearchReads(ctx context.Context, in *SearchReadsRequest, opts ...grpc.CallOption) (*SearchReadsResponse, error) {
	out := new(SearchReadsResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/SearchReads", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReadServiceV1Server is the server API for ReadServiceV1 service.
type ReadServiceV1Server interface {
	// Creates read group sets by asynchronously importing the provided
	// information.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The caller must have WRITE permissions to the dataset.
	//
	// ## Notes on [BAM](https://samtools.github.io/hts-specs/SAMv1.pdf) import
	//
	// - Tags will be converted to strings - tag types are not preserved
	// - Comments (`@CO`) in the input file header will not be preserved
	// - Original header order of references (`@SQ`) will not be preserved
	// - Any reverse stranded unmapped reads will be reverse complemented, and
	// their qualities (also the "BQ" and "OQ" tags, if any) will be reversed
	// - Unmapped reads will be stripped of positional information (reference name
	// and position)
	ImportReadGroupSets(context.Context, *ImportReadGroupSetsRequest) (*longrunning.Operation, error)
	// Exports a read group set to a BAM file in Google Cloud Storage.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Note that currently there may be some differences between exported BAM
	// files and the original BAM file at the time of import. See
	// [ImportReadGroupSets][google.genomics.v1.ReadServiceV1.ImportReadGroupSets]
	// for caveats.
	ExportReadGroupSet(context.Context, *ExportReadGroupSetRequest) (*longrunning.Operation, error)
	// Searches for read group sets matching the criteria.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchReadGroupSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L135).
	SearchReadGroupSets(context.Context, *SearchReadGroupSetsRequest) (*SearchReadGroupSetsResponse, error)
	// Updates a read group set.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics.
	UpdateReadGroupSet(context.Context, *UpdateReadGroupSetRequest) (*ReadGroupSet, error)
	// Deletes a read group set.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteReadGroupSet(context.Context, *DeleteReadGroupSetRequest) (*empty.Empty, error)
	// Gets a read group set by ID.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetReadGroupSet(context.Context, *GetReadGroupSetRequest) (*ReadGroupSet, error)
	// Lists fixed width coverage buckets for a read group set, each of which
	// correspond to a range of a reference sequence. Each bucket summarizes
	// coverage information across its corresponding genomic range.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Coverage is defined as the number of reads which are aligned to a given
	// base in the reference sequence. Coverage buckets are available at several
	// precomputed bucket widths, enabling retrieval of various coverage 'zoom
	// levels'. The caller must have READ permissions for the target read group
	// set.
	ListCoverageBuckets(context.Context, *ListCoverageBucketsRequest) (*ListCoverageBucketsResponse, error)
	// Gets a list of reads for one or more read group sets.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Reads search operates over a genomic coordinate space of reference sequence
	// & position defined over the reference sequences to which the requested
	// read group sets are aligned.
	//
	// If a target positional range is specified, search returns all reads whose
	// alignment to the reference genome overlap the range. A query which
	// specifies only read group set IDs yields all reads in those read group
	// sets, including unmapped reads.
	//
	// All reads returned (including reads on subsequent pages) are ordered by
	// genomic coordinate (by reference sequence, then position). Reads with
	// equivalent genomic coordinates are returned in an unspecified order. This
	// order is consistent, such that two queries for the same content (regardless
	// of page size) yield reads in the same order across their respective streams
	// of paginated responses.
	//
	// Implements
	// [GlobalAllianceApi.searchReads](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L85).
	SearchReads(context.Context, *SearchReadsRequest) (*SearchReadsResponse, error)
}

// UnimplementedReadServiceV1Server can be embedded to have forward compatible implementations.
type UnimplementedReadServiceV1Server struct {
}

func (*UnimplementedReadServiceV1Server) ImportReadGroupSets(context.Context, *ImportReadGroupSetsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportReadGroupSets not implemented")
}
func (*UnimplementedReadServiceV1Server) ExportReadGroupSet(context.Context, *ExportReadGroupSetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportReadGroupSet not implemented")
}
func (*UnimplementedReadServiceV1Server) SearchReadGroupSets(context.Context, *SearchReadGroupSetsRequest) (*SearchReadGroupSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchReadGroupSets not implemented")
}
func (*UnimplementedReadServiceV1Server) UpdateReadGroupSet(context.Context, *UpdateReadGroupSetRequest) (*ReadGroupSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateReadGroupSet not implemented")
}
func (*UnimplementedReadServiceV1Server) DeleteReadGroupSet(context.Context, *DeleteReadGroupSetRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReadGroupSet not implemented")
}
func (*UnimplementedReadServiceV1Server) GetReadGroupSet(context.Context, *GetReadGroupSetRequest) (*ReadGroupSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReadGroupSet not implemented")
}
func (*UnimplementedReadServiceV1Server) ListCoverageBuckets(context.Context, *ListCoverageBucketsRequest) (*ListCoverageBucketsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCoverageBuckets not implemented")
}
func (*UnimplementedReadServiceV1Server) SearchReads(context.Context, *SearchReadsRequest) (*SearchReadsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchReads not implemented")
}

func RegisterReadServiceV1Server(s *grpc.Server, srv ReadServiceV1Server) {
	s.RegisterService(&_ReadServiceV1_serviceDesc, srv)
}

func _ReadServiceV1_ImportReadGroupSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportReadGroupSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).ImportReadGroupSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/ImportReadGroupSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).ImportReadGroupSets(ctx, req.(*ImportReadGroupSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_ExportReadGroupSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportReadGroupSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).ExportReadGroupSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/ExportReadGroupSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).ExportReadGroupSet(ctx, req.(*ExportReadGroupSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_SearchReadGroupSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchReadGroupSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).SearchReadGroupSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/SearchReadGroupSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).SearchReadGroupSets(ctx, req.(*SearchReadGroupSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_UpdateReadGroupSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReadGroupSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).UpdateReadGroupSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/UpdateReadGroupSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).UpdateReadGroupSet(ctx, req.(*UpdateReadGroupSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_DeleteReadGroupSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReadGroupSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).DeleteReadGroupSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/DeleteReadGroupSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).DeleteReadGroupSet(ctx, req.(*DeleteReadGroupSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_GetReadGroupSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReadGroupSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).GetReadGroupSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/GetReadGroupSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).GetReadGroupSet(ctx, req.(*GetReadGroupSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_ListCoverageBuckets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCoverageBucketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).ListCoverageBuckets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/ListCoverageBuckets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).ListCoverageBuckets(ctx, req.(*ListCoverageBucketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_SearchReads_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchReadsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).SearchReads(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/SearchReads",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).SearchReads(ctx, req.(*SearchReadsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReadServiceV1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.ReadServiceV1",
	HandlerType: (*ReadServiceV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ImportReadGroupSets",
			Handler:    _ReadServiceV1_ImportReadGroupSets_Handler,
		},
		{
			MethodName: "ExportReadGroupSet",
			Handler:    _ReadServiceV1_ExportReadGroupSet_Handler,
		},
		{
			MethodName: "SearchReadGroupSets",
			Handler:    _ReadServiceV1_SearchReadGroupSets_Handler,
		},
		{
			MethodName: "UpdateReadGroupSet",
			Handler:    _ReadServiceV1_UpdateReadGroupSet_Handler,
		},
		{
			MethodName: "DeleteReadGroupSet",
			Handler:    _ReadServiceV1_DeleteReadGroupSet_Handler,
		},
		{
			MethodName: "GetReadGroupSet",
			Handler:    _ReadServiceV1_GetReadGroupSet_Handler,
		},
		{
			MethodName: "ListCoverageBuckets",
			Handler:    _ReadServiceV1_ListCoverageBuckets_Handler,
		},
		{
			MethodName: "SearchReads",
			Handler:    _ReadServiceV1_SearchReads_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/genomics/v1/reads.proto",
}
