// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/cloud/resourcemanager/v2/folders.proto

package resourcemanager

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Folder lifecycle states.
type Folder_LifecycleState int32

const (
	// Unspecified state.
	Folder_LIFECYCLE_STATE_UNSPECIFIED Folder_LifecycleState = 0
	// The normal and active state.
	Folder_ACTIVE Folder_LifecycleState = 1
	// The folder has been marked for deletion by the user.
	Folder_DELETE_REQUESTED Folder_LifecycleState = 2
)

// Enum value maps for Folder_LifecycleState.
var (
	Folder_LifecycleState_name = map[int32]string{
		0: "LIFECYCLE_STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "DELETE_REQUESTED",
	}
	Folder_LifecycleState_value = map[string]int32{
		"LIFECYCLE_STATE_UNSPECIFIED": 0,
		"ACTIVE":                      1,
		"DELETE_REQUESTED":            2,
	}
)

func (x Folder_LifecycleState) Enum() *Folder_LifecycleState {
	p := new(Folder_LifecycleState)
	*p = x
	return p
}

func (x Folder_LifecycleState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Folder_LifecycleState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_resourcemanager_v2_folders_proto_enumTypes[0].Descriptor()
}

func (Folder_LifecycleState) Type() protoreflect.EnumType {
	return &file_google_cloud_resourcemanager_v2_folders_proto_enumTypes[0]
}

func (x Folder_LifecycleState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Folder_LifecycleState.Descriptor instead.
func (Folder_LifecycleState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{0, 0}
}

// The type of operation that failed.
type FolderOperation_OperationType int32

const (
	// Operation type not specified.
	FolderOperation_OPERATION_TYPE_UNSPECIFIED FolderOperation_OperationType = 0
	// A create folder operation.
	FolderOperation_CREATE FolderOperation_OperationType = 1
	// A move folder operation.
	FolderOperation_MOVE FolderOperation_OperationType = 2
)

// Enum value maps for FolderOperation_OperationType.
var (
	FolderOperation_OperationType_name = map[int32]string{
		0: "OPERATION_TYPE_UNSPECIFIED",
		1: "CREATE",
		2: "MOVE",
	}
	FolderOperation_OperationType_value = map[string]int32{
		"OPERATION_TYPE_UNSPECIFIED": 0,
		"CREATE":                     1,
		"MOVE":                       2,
	}
)

func (x FolderOperation_OperationType) Enum() *FolderOperation_OperationType {
	p := new(FolderOperation_OperationType)
	*p = x
	return p
}

func (x FolderOperation_OperationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FolderOperation_OperationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_resourcemanager_v2_folders_proto_enumTypes[1].Descriptor()
}

func (FolderOperation_OperationType) Type() protoreflect.EnumType {
	return &file_google_cloud_resourcemanager_v2_folders_proto_enumTypes[1]
}

func (x FolderOperation_OperationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FolderOperation_OperationType.Descriptor instead.
func (FolderOperation_OperationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{11, 0}
}

// A Folder in an Organization's resource hierarchy, used to
// organize that Organization's resources.
type Folder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the Folder.
	// Its format is `folders/{folder_id}`, for example: "folders/1234".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The Folder’s parent's resource name.
	// Updates to the folder's parent must be performed via
	// [MoveFolder][google.cloud.resourcemanager.v2.Folders.MoveFolder].
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The folder’s display name.
	// A folder’s display name must be unique amongst its siblings, e.g.
	// no two folders with the same parent can share the same display name.
	// The display name must start and end with a letter or digit, may contain
	// letters, digits, spaces, hyphens and underscores and can be no longer
	// than 30 characters. This is captured by the regular expression:
	// [\p{L}\p{N}]([\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The lifecycle state of the folder.
	// Updates to the lifecycle_state must be performed via
	// [DeleteFolder][google.cloud.resourcemanager.v2.Folders.DeleteFolder] and
	// [UndeleteFolder][google.cloud.resourcemanager.v2.Folders.UndeleteFolder].
	LifecycleState Folder_LifecycleState `protobuf:"varint,4,opt,name=lifecycle_state,json=lifecycleState,proto3,enum=google.cloud.resourcemanager.v2.Folder_LifecycleState" json:"lifecycle_state,omitempty"`
	// Output only. Timestamp when the Folder was created. Assigned by the server.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when the Folder was last modified.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Folder) Reset() {
	*x = Folder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Folder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Folder) ProtoMessage() {}

func (x *Folder) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Folder.ProtoReflect.Descriptor instead.
func (*Folder) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{0}
}

func (x *Folder) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Folder) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *Folder) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Folder) GetLifecycleState() Folder_LifecycleState {
	if x != nil {
		return x.LifecycleState
	}
	return Folder_LIFECYCLE_STATE_UNSPECIFIED
}

func (x *Folder) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Folder) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// The ListFolders request message.
type ListFoldersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Organization or Folder whose Folders are
	// being listed.
	// Must be of the form `folders/{folder_id}` or `organizations/{org_id}`.
	// Access to this method is controlled by checking the
	// `resourcemanager.folders.list` permission on the `parent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of Folders to return in the response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A pagination token returned from a previous call to `ListFolders`
	// that indicates where this listing should continue from.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Controls whether Folders in the
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v2.Folder.LifecycleState.DELETE_REQUESTED]
	// state should be returned. Defaults to false.
	ShowDeleted bool `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListFoldersRequest) Reset() {
	*x = ListFoldersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFoldersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFoldersRequest) ProtoMessage() {}

func (x *ListFoldersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFoldersRequest.ProtoReflect.Descriptor instead.
func (*ListFoldersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{1}
}

func (x *ListFoldersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFoldersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFoldersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFoldersRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// The ListFolders response message.
type ListFoldersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A possibly paginated list of Folders that are direct descendants of
	// the specified parent resource.
	Folders []*Folder `protobuf:"bytes,1,rep,name=folders,proto3" json:"folders,omitempty"`
	// A pagination token returned from a previous call to `ListFolders`
	// that indicates from where listing should continue.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFoldersResponse) Reset() {
	*x = ListFoldersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFoldersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFoldersResponse) ProtoMessage() {}

func (x *ListFoldersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFoldersResponse.ProtoReflect.Descriptor instead.
func (*ListFoldersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{2}
}

func (x *ListFoldersResponse) GetFolders() []*Folder {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *ListFoldersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for searching folders.
type SearchFoldersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The maximum number of folders to return in the response.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A pagination token returned from a previous call to `SearchFolders`
	// that indicates from where search should continue.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Search criteria used to select the Folders to return.
	// If no search criteria is specified then all accessible folders will be
	// returned.
	//
	// Query expressions can be used to restrict results based upon displayName,
	// lifecycleState and parent, where the operators `=`, `NOT`, `AND` and `OR`
	// can be used along with the suffix wildcard symbol `*`.
	//
	// The displayName field in a query expression should use escaped quotes
	// for values that include whitespace to prevent unexpected behavior.
	//
	// Some example queries are:
	//
	// * Query `displayName=Test*` returns Folder resources whose display name
	// starts with "Test".
	// * Query `lifecycleState=ACTIVE` returns Folder resources with
	// `lifecycleState` set to `ACTIVE`.
	// * Query `parent=folders/123` returns Folder resources that have
	// `folders/123` as a parent resource.
	// * Query `parent=folders/123 AND lifecycleState=ACTIVE` returns active
	// Folder resources that have `folders/123` as a parent resource.
	// * Query `displayName=\\"Test String\\"` returns Folder resources with
	// display names that include both "Test" and "String".
	Query string `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
}

func (x *SearchFoldersRequest) Reset() {
	*x = SearchFoldersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchFoldersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchFoldersRequest) ProtoMessage() {}

func (x *SearchFoldersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchFoldersRequest.ProtoReflect.Descriptor instead.
func (*SearchFoldersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{3}
}

func (x *SearchFoldersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchFoldersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchFoldersRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

// The response message for searching folders.
type SearchFoldersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A possibly paginated folder search results.
	// the specified parent resource.
	Folders []*Folder `protobuf:"bytes,1,rep,name=folders,proto3" json:"folders,omitempty"`
	// A pagination token returned from a previous call to `SearchFolders`
	// that indicates from where searching should continue.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchFoldersResponse) Reset() {
	*x = SearchFoldersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchFoldersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchFoldersResponse) ProtoMessage() {}

func (x *SearchFoldersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchFoldersResponse.ProtoReflect.Descriptor instead.
func (*SearchFoldersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{4}
}

func (x *SearchFoldersResponse) GetFolders() []*Folder {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *SearchFoldersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The GetFolder request message.
type GetFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Folder to retrieve.
	// Must be of the form `folders/{folder_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFolderRequest) Reset() {
	*x = GetFolderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFolderRequest) ProtoMessage() {}

func (x *GetFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFolderRequest.ProtoReflect.Descriptor instead.
func (*GetFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{5}
}

func (x *GetFolderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The CreateFolder request message.
type CreateFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the new Folder's parent.
	// Must be of the form `folders/{folder_id}` or `organizations/{org_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Folder being created, only the display name will be consulted.
	// All other fields will be ignored.
	Folder *Folder `protobuf:"bytes,2,opt,name=folder,proto3" json:"folder,omitempty"`
}

func (x *CreateFolderRequest) Reset() {
	*x = CreateFolderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFolderRequest) ProtoMessage() {}

func (x *CreateFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFolderRequest.ProtoReflect.Descriptor instead.
func (*CreateFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{6}
}

func (x *CreateFolderRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFolderRequest) GetFolder() *Folder {
	if x != nil {
		return x.Folder
	}
	return nil
}

// The MoveFolder request message.
type MoveFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Folder to move.
	// Must be of the form folders/{folder_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The resource name of the Folder or Organization to reparent
	// the folder under.
	// Must be of the form `folders/{folder_id}` or `organizations/{org_id}`.
	DestinationParent string `protobuf:"bytes,2,opt,name=destination_parent,json=destinationParent,proto3" json:"destination_parent,omitempty"`
}

func (x *MoveFolderRequest) Reset() {
	*x = MoveFolderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveFolderRequest) ProtoMessage() {}

func (x *MoveFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveFolderRequest.ProtoReflect.Descriptor instead.
func (*MoveFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{7}
}

func (x *MoveFolderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MoveFolderRequest) GetDestinationParent() string {
	if x != nil {
		return x.DestinationParent
	}
	return ""
}

// The request message for updating a folder's display name.
type UpdateFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new definition of the Folder. It must include a
	// a `name` and `display_name` field. The other fields
	// will be ignored.
	Folder *Folder `protobuf:"bytes,1,opt,name=folder,proto3" json:"folder,omitempty"`
	// Required. Fields to be updated.
	// Only the `display_name` can be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFolderRequest) Reset() {
	*x = UpdateFolderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFolderRequest) ProtoMessage() {}

func (x *UpdateFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFolderRequest.ProtoReflect.Descriptor instead.
func (*UpdateFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateFolderRequest) GetFolder() *Folder {
	if x != nil {
		return x.Folder
	}
	return nil
}

func (x *UpdateFolderRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The DeleteFolder request message.
type DeleteFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Folder to be deleted.
	// Must be of the form `folders/{folder_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Instructs DeleteFolderAction to delete a folder even when the folder is not
	// empty.
	RecursiveDelete bool `protobuf:"varint,2,opt,name=recursive_delete,json=recursiveDelete,proto3" json:"recursive_delete,omitempty"`
}

func (x *DeleteFolderRequest) Reset() {
	*x = DeleteFolderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFolderRequest) ProtoMessage() {}

func (x *DeleteFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFolderRequest.ProtoReflect.Descriptor instead.
func (*DeleteFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteFolderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteFolderRequest) GetRecursiveDelete() bool {
	if x != nil {
		return x.RecursiveDelete
	}
	return false
}

// The UndeleteFolder request message.
type UndeleteFolderRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Folder to undelete.
	// Must be of the form `folders/{folder_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UndeleteFolderRequest) Reset() {
	*x = UndeleteFolderRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeleteFolderRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeleteFolderRequest) ProtoMessage() {}

func (x *UndeleteFolderRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeleteFolderRequest.ProtoReflect.Descriptor instead.
func (*UndeleteFolderRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{10}
}

func (x *UndeleteFolderRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metadata describing a long running folder operation
type FolderOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The display name of the folder.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The type of this operation.
	OperationType FolderOperation_OperationType `protobuf:"varint,2,opt,name=operation_type,json=operationType,proto3,enum=google.cloud.resourcemanager.v2.FolderOperation_OperationType" json:"operation_type,omitempty"`
	// The resource name of the folder's parent.
	// Only applicable when the operation_type is MOVE.
	SourceParent string `protobuf:"bytes,3,opt,name=source_parent,json=sourceParent,proto3" json:"source_parent,omitempty"`
	// The resource name of the folder or organization we are either creating
	// the folder under or moving the folder to.
	DestinationParent string `protobuf:"bytes,4,opt,name=destination_parent,json=destinationParent,proto3" json:"destination_parent,omitempty"`
}

func (x *FolderOperation) Reset() {
	*x = FolderOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FolderOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FolderOperation) ProtoMessage() {}

func (x *FolderOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FolderOperation.ProtoReflect.Descriptor instead.
func (*FolderOperation) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP(), []int{11}
}

func (x *FolderOperation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *FolderOperation) GetOperationType() FolderOperation_OperationType {
	if x != nil {
		return x.OperationType
	}
	return FolderOperation_OPERATION_TYPE_UNSPECIFIED
}

func (x *FolderOperation) GetSourceParent() string {
	if x != nil {
		return x.SourceParent
	}
	return ""
}

func (x *FolderOperation) GetDestinationParent() string {
	if x != nil {
		return x.DestinationParent
	}
	return ""
}

var File_google_cloud_resourcemanager_v2_folders_proto protoreflect.FileDescriptor

var file_google_cloud_resourcemanager_v2_folders_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76,
	0x32, 0x2f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe3, 0x03, 0x0a, 0x06, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x64, 0x0a, 0x0f, 0x6c,
	0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x4c, 0x69,
	0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x53, 0x0a, 0x0e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63,
	0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x4c, 0x49, 0x46, 0x45, 0x43,
	0x59, 0x43, 0x4c, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x52,
	0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x45, 0x44, 0x10, 0x02, 0x3a, 0x41, 0xea, 0x41, 0x3e, 0x0a,
	0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x10, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x22, 0xa5, 0x01,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03, 0x12, 0x01, 0x2a, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x26, 0x0a,
	0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x80, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a,
	0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x72, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x22, 0x82, 0x01, 0x0a,
	0x15, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x52, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x5a, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7e, 0x0a,
	0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03, 0x12, 0x01, 0x2a, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x22, 0x95, 0x01,
	0x0a, 0x11, 0x4d, 0x6f, 0x76, 0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x12, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03, 0x12,
	0x01, 0x2a, 0x52, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x9d, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a,
	0x06, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x88, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69,
	0x76, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x22, 0x5f, 0x0a, 0x15, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xb6, 0x02, 0x0a, 0x0f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x22, 0x45, 0x0a, 0x0d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x4d, 0x4f, 0x56, 0x45, 0x10, 0x02, 0x32, 0xbe, 0x0f, 0x0a, 0x07, 0x46,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x12, 0xa3, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x46,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x0d, 0x12, 0x0b, 0x2f, 0x76, 0x32, 0x2f, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0xa5, 0x01, 0x0a,
	0x0d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x25, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x17, 0x22, 0x12, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x05, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x8c, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x22, 0x23,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x16, 0x12, 0x14, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xac, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x15, 0x22, 0x0b, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x3a, 0x06,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0xca, 0x41, 0x19, 0x0a, 0x06, 0x46, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x12, 0x0f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0xaf, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x32, 0x1b, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x06, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0xda,
	0x41, 0x12, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x12, 0xbb, 0x01, 0x0a, 0x0a, 0x4d, 0x6f, 0x76, 0x65, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x22, 0x19,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x6f, 0x76, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x17, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0xca, 0x41, 0x19, 0x0a, 0x06, 0x46, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x12, 0x0f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0xaa, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x16, 0x2a, 0x14, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xda, 0x41, 0x15, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x72,
	0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12,
	0xa2, 0x01, 0x0a, 0x0e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x22, 0x2f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x22, 0x1d, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x86, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x22, 0x25, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x8d, 0x01,
	0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2a, 0x22, 0x25, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xb8, 0x01,
	0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x30, 0x22, 0x2b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x90, 0x01, 0xca, 0x41, 0x23, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x67, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0xc9, 0x01, 0x0a, 0x23,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x42, 0x0c, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x4e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2f, 0x76, 0x32, 0x3b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x5c, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_resourcemanager_v2_folders_proto_rawDescOnce sync.Once
	file_google_cloud_resourcemanager_v2_folders_proto_rawDescData = file_google_cloud_resourcemanager_v2_folders_proto_rawDesc
)

func file_google_cloud_resourcemanager_v2_folders_proto_rawDescGZIP() []byte {
	file_google_cloud_resourcemanager_v2_folders_proto_rawDescOnce.Do(func() {
		file_google_cloud_resourcemanager_v2_folders_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_resourcemanager_v2_folders_proto_rawDescData)
	})
	return file_google_cloud_resourcemanager_v2_folders_proto_rawDescData
}

var file_google_cloud_resourcemanager_v2_folders_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_resourcemanager_v2_folders_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_resourcemanager_v2_folders_proto_goTypes = []interface{}{
	(Folder_LifecycleState)(0),            // 0: google.cloud.resourcemanager.v2.Folder.LifecycleState
	(FolderOperation_OperationType)(0),    // 1: google.cloud.resourcemanager.v2.FolderOperation.OperationType
	(*Folder)(nil),                        // 2: google.cloud.resourcemanager.v2.Folder
	(*ListFoldersRequest)(nil),            // 3: google.cloud.resourcemanager.v2.ListFoldersRequest
	(*ListFoldersResponse)(nil),           // 4: google.cloud.resourcemanager.v2.ListFoldersResponse
	(*SearchFoldersRequest)(nil),          // 5: google.cloud.resourcemanager.v2.SearchFoldersRequest
	(*SearchFoldersResponse)(nil),         // 6: google.cloud.resourcemanager.v2.SearchFoldersResponse
	(*GetFolderRequest)(nil),              // 7: google.cloud.resourcemanager.v2.GetFolderRequest
	(*CreateFolderRequest)(nil),           // 8: google.cloud.resourcemanager.v2.CreateFolderRequest
	(*MoveFolderRequest)(nil),             // 9: google.cloud.resourcemanager.v2.MoveFolderRequest
	(*UpdateFolderRequest)(nil),           // 10: google.cloud.resourcemanager.v2.UpdateFolderRequest
	(*DeleteFolderRequest)(nil),           // 11: google.cloud.resourcemanager.v2.DeleteFolderRequest
	(*UndeleteFolderRequest)(nil),         // 12: google.cloud.resourcemanager.v2.UndeleteFolderRequest
	(*FolderOperation)(nil),               // 13: google.cloud.resourcemanager.v2.FolderOperation
	(*timestamp.Timestamp)(nil),           // 14: google.protobuf.Timestamp
	(*field_mask.FieldMask)(nil),          // 15: google.protobuf.FieldMask
	(*v1.GetIamPolicyRequest)(nil),        // 16: google.iam.v1.GetIamPolicyRequest
	(*v1.SetIamPolicyRequest)(nil),        // 17: google.iam.v1.SetIamPolicyRequest
	(*v1.TestIamPermissionsRequest)(nil),  // 18: google.iam.v1.TestIamPermissionsRequest
	(*longrunning.Operation)(nil),         // 19: google.longrunning.Operation
	(*v1.Policy)(nil),                     // 20: google.iam.v1.Policy
	(*v1.TestIamPermissionsResponse)(nil), // 21: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_resourcemanager_v2_folders_proto_depIdxs = []int32{
	0,  // 0: google.cloud.resourcemanager.v2.Folder.lifecycle_state:type_name -> google.cloud.resourcemanager.v2.Folder.LifecycleState
	14, // 1: google.cloud.resourcemanager.v2.Folder.create_time:type_name -> google.protobuf.Timestamp
	14, // 2: google.cloud.resourcemanager.v2.Folder.update_time:type_name -> google.protobuf.Timestamp
	2,  // 3: google.cloud.resourcemanager.v2.ListFoldersResponse.folders:type_name -> google.cloud.resourcemanager.v2.Folder
	2,  // 4: google.cloud.resourcemanager.v2.SearchFoldersResponse.folders:type_name -> google.cloud.resourcemanager.v2.Folder
	2,  // 5: google.cloud.resourcemanager.v2.CreateFolderRequest.folder:type_name -> google.cloud.resourcemanager.v2.Folder
	2,  // 6: google.cloud.resourcemanager.v2.UpdateFolderRequest.folder:type_name -> google.cloud.resourcemanager.v2.Folder
	15, // 7: google.cloud.resourcemanager.v2.UpdateFolderRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 8: google.cloud.resourcemanager.v2.FolderOperation.operation_type:type_name -> google.cloud.resourcemanager.v2.FolderOperation.OperationType
	3,  // 9: google.cloud.resourcemanager.v2.Folders.ListFolders:input_type -> google.cloud.resourcemanager.v2.ListFoldersRequest
	5,  // 10: google.cloud.resourcemanager.v2.Folders.SearchFolders:input_type -> google.cloud.resourcemanager.v2.SearchFoldersRequest
	7,  // 11: google.cloud.resourcemanager.v2.Folders.GetFolder:input_type -> google.cloud.resourcemanager.v2.GetFolderRequest
	8,  // 12: google.cloud.resourcemanager.v2.Folders.CreateFolder:input_type -> google.cloud.resourcemanager.v2.CreateFolderRequest
	10, // 13: google.cloud.resourcemanager.v2.Folders.UpdateFolder:input_type -> google.cloud.resourcemanager.v2.UpdateFolderRequest
	9,  // 14: google.cloud.resourcemanager.v2.Folders.MoveFolder:input_type -> google.cloud.resourcemanager.v2.MoveFolderRequest
	11, // 15: google.cloud.resourcemanager.v2.Folders.DeleteFolder:input_type -> google.cloud.resourcemanager.v2.DeleteFolderRequest
	12, // 16: google.cloud.resourcemanager.v2.Folders.UndeleteFolder:input_type -> google.cloud.resourcemanager.v2.UndeleteFolderRequest
	16, // 17: google.cloud.resourcemanager.v2.Folders.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	17, // 18: google.cloud.resourcemanager.v2.Folders.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	18, // 19: google.cloud.resourcemanager.v2.Folders.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	4,  // 20: google.cloud.resourcemanager.v2.Folders.ListFolders:output_type -> google.cloud.resourcemanager.v2.ListFoldersResponse
	6,  // 21: google.cloud.resourcemanager.v2.Folders.SearchFolders:output_type -> google.cloud.resourcemanager.v2.SearchFoldersResponse
	2,  // 22: google.cloud.resourcemanager.v2.Folders.GetFolder:output_type -> google.cloud.resourcemanager.v2.Folder
	19, // 23: google.cloud.resourcemanager.v2.Folders.CreateFolder:output_type -> google.longrunning.Operation
	2,  // 24: google.cloud.resourcemanager.v2.Folders.UpdateFolder:output_type -> google.cloud.resourcemanager.v2.Folder
	19, // 25: google.cloud.resourcemanager.v2.Folders.MoveFolder:output_type -> google.longrunning.Operation
	2,  // 26: google.cloud.resourcemanager.v2.Folders.DeleteFolder:output_type -> google.cloud.resourcemanager.v2.Folder
	2,  // 27: google.cloud.resourcemanager.v2.Folders.UndeleteFolder:output_type -> google.cloud.resourcemanager.v2.Folder
	20, // 28: google.cloud.resourcemanager.v2.Folders.GetIamPolicy:output_type -> google.iam.v1.Policy
	20, // 29: google.cloud.resourcemanager.v2.Folders.SetIamPolicy:output_type -> google.iam.v1.Policy
	21, // 30: google.cloud.resourcemanager.v2.Folders.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	20, // [20:31] is the sub-list for method output_type
	9,  // [9:20] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_resourcemanager_v2_folders_proto_init() }
func file_google_cloud_resourcemanager_v2_folders_proto_init() {
	if File_google_cloud_resourcemanager_v2_folders_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Folder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFoldersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFoldersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchFoldersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchFoldersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFolderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFolderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveFolderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateFolderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteFolderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeleteFolderRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcemanager_v2_folders_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FolderOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_resourcemanager_v2_folders_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_resourcemanager_v2_folders_proto_goTypes,
		DependencyIndexes: file_google_cloud_resourcemanager_v2_folders_proto_depIdxs,
		EnumInfos:         file_google_cloud_resourcemanager_v2_folders_proto_enumTypes,
		MessageInfos:      file_google_cloud_resourcemanager_v2_folders_proto_msgTypes,
	}.Build()
	File_google_cloud_resourcemanager_v2_folders_proto = out.File
	file_google_cloud_resourcemanager_v2_folders_proto_rawDesc = nil
	file_google_cloud_resourcemanager_v2_folders_proto_goTypes = nil
	file_google_cloud_resourcemanager_v2_folders_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FoldersClient is the client API for Folders service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FoldersClient interface {
	// Lists the Folders that are direct descendants of supplied parent resource.
	// List provides a strongly consistent view of the Folders underneath
	// the specified parent resource.
	// List returns Folders sorted based upon the (ascending) lexical ordering
	// of their display_name.
	// The caller must have `resourcemanager.folders.list` permission on the
	// identified parent.
	ListFolders(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error)
	// Search for folders that match specific filter criteria.
	// Search provides an eventually consistent view of the folders a user has
	// access to which meet the specified filter criteria.
	//
	// This will only return folders on which the caller has the
	// permission `resourcemanager.folders.get`.
	SearchFolders(ctx context.Context, in *SearchFoldersRequest, opts ...grpc.CallOption) (*SearchFoldersResponse, error)
	// Retrieves a Folder identified by the supplied resource name.
	// Valid Folder resource names have the format `folders/{folder_id}`
	// (for example, `folders/1234`).
	// The caller must have `resourcemanager.folders.get` permission on the
	// identified folder.
	GetFolder(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Creates a Folder in the resource hierarchy.
	// Returns an Operation which can be used to track the progress of the
	// folder creation workflow.
	// Upon success the Operation.response field will be populated with the
	// created Folder.
	//
	// In order to succeed, the addition of this new Folder must not violate
	// the Folder naming, height or fanout constraints.
	//
	// + The Folder's display_name must be distinct from all other Folder's that
	// share its parent.
	// + The addition of the Folder must not cause the active Folder hierarchy
	// to exceed a height of 4. Note, the full active + deleted Folder hierarchy
	// is allowed to reach a height of 8; this provides additional headroom when
	// moving folders that contain deleted folders.
	// + The addition of the Folder must not cause the total number of Folders
	// under its parent to exceed 100.
	//
	// If the operation fails due to a folder constraint violation, some errors
	// may be returned by the CreateFolder request, with status code
	// FAILED_PRECONDITION and an error description. Other folder constraint
	// violations will be communicated in the Operation, with the specific
	// PreconditionFailure returned via the details list in the Operation.error
	// field.
	//
	// The caller must have `resourcemanager.folders.create` permission on the
	// identified parent.
	CreateFolder(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a Folder, changing its display_name.
	// Changes to the folder display_name will be rejected if they violate either
	// the display_name formatting rules or naming constraints described in
	// the [CreateFolder][google.cloud.resourcemanager.v2.Folders.CreateFolder] documentation.
	//
	// The Folder's display name must start and end with a letter or digit,
	// may contain letters, digits, spaces, hyphens and underscores and can be
	// no longer than 30 characters. This is captured by the regular expression:
	// [\p{L}\p{N}]([\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?.
	// The caller must have `resourcemanager.folders.update` permission on the
	// identified folder.
	//
	// If the update fails due to the unique name constraint then a
	// PreconditionFailure explaining this violation will be returned
	// in the Status.details field.
	UpdateFolder(ctx context.Context, in *UpdateFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Moves a Folder under a new resource parent.
	// Returns an Operation which can be used to track the progress of the
	// folder move workflow.
	// Upon success the Operation.response field will be populated with the
	// moved Folder.
	// Upon failure, a FolderOperationError categorizing the failure cause will
	// be returned - if the failure occurs synchronously then the
	// FolderOperationError will be returned via the Status.details field
	// and if it occurs asynchronously then the FolderOperation will be returned
	// via the Operation.error field.
	// In addition, the Operation.metadata field will be populated with a
	// FolderOperation message as an aid to stateless clients.
	// Folder moves will be rejected if they violate either the naming, height
	// or fanout constraints described in the
	// [CreateFolder][google.cloud.resourcemanager.v2.Folders.CreateFolder] documentation.
	// The caller must have `resourcemanager.folders.move` permission on the
	// folder's current and proposed new parent.
	MoveFolder(ctx context.Context, in *MoveFolderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Requests deletion of a Folder. The Folder is moved into the
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v2.Folder.LifecycleState.DELETE_REQUESTED] state
	// immediately, and is deleted approximately 30 days later. This method may
	// only be called on an empty Folder in the
	// [ACTIVE][google.cloud.resourcemanager.v2.Folder.LifecycleState.ACTIVE] state, where a Folder is empty if
	// it doesn't contain any Folders or Projects in the
	// [ACTIVE][google.cloud.resourcemanager.v2.Folder.LifecycleState.ACTIVE] state.
	// The caller must have `resourcemanager.folders.delete` permission on the
	// identified folder.
	DeleteFolder(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Cancels the deletion request for a Folder. This method may only be
	// called on a Folder in the
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v2.Folder.LifecycleState.DELETE_REQUESTED] state.
	// In order to succeed, the Folder's parent must be in the
	// [ACTIVE][google.cloud.resourcemanager.v2.Folder.LifecycleState.ACTIVE] state.
	// In addition, reintroducing the folder into the tree must not violate
	// folder naming, height and fanout constraints described in the
	// [CreateFolder][google.cloud.resourcemanager.v2.Folders.CreateFolder] documentation.
	// The caller must have `resourcemanager.folders.undelete` permission on the
	// identified folder.
	UndeleteFolder(ctx context.Context, in *UndeleteFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Gets the access control policy for a Folder. The returned policy may be
	// empty if no such policy or resource exists. The `resource` field should
	// be the Folder's resource name, e.g. "folders/1234".
	// The caller must have `resourcemanager.folders.getIamPolicy` permission
	// on the identified folder.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the access control policy on a Folder, replacing any existing policy.
	// The `resource` field should be the Folder's resource name, e.g.
	// "folders/1234".
	// The caller must have `resourcemanager.folders.setIamPolicy` permission
	// on the identified folder.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified Folder.
	// The `resource` field should be the Folder's resource name,
	// e.g. "folders/1234".
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type foldersClient struct {
	cc grpc.ClientConnInterface
}

func NewFoldersClient(cc grpc.ClientConnInterface) FoldersClient {
	return &foldersClient{cc}
}

func (c *foldersClient) ListFolders(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error) {
	out := new(ListFoldersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/ListFolders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) SearchFolders(ctx context.Context, in *SearchFoldersRequest, opts ...grpc.CallOption) (*SearchFoldersResponse, error) {
	out := new(SearchFoldersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/SearchFolders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) GetFolder(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/GetFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) CreateFolder(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/CreateFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) UpdateFolder(ctx context.Context, in *UpdateFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/UpdateFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) MoveFolder(ctx context.Context, in *MoveFolderRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/MoveFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) DeleteFolder(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/DeleteFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) UndeleteFolder(ctx context.Context, in *UndeleteFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/UndeleteFolder", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcemanager.v2.Folders/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FoldersServer is the server API for Folders service.
type FoldersServer interface {
	// Lists the Folders that are direct descendants of supplied parent resource.
	// List provides a strongly consistent view of the Folders underneath
	// the specified parent resource.
	// List returns Folders sorted based upon the (ascending) lexical ordering
	// of their display_name.
	// The caller must have `resourcemanager.folders.list` permission on the
	// identified parent.
	ListFolders(context.Context, *ListFoldersRequest) (*ListFoldersResponse, error)
	// Search for folders that match specific filter criteria.
	// Search provides an eventually consistent view of the folders a user has
	// access to which meet the specified filter criteria.
	//
	// This will only return folders on which the caller has the
	// permission `resourcemanager.folders.get`.
	SearchFolders(context.Context, *SearchFoldersRequest) (*SearchFoldersResponse, error)
	// Retrieves a Folder identified by the supplied resource name.
	// Valid Folder resource names have the format `folders/{folder_id}`
	// (for example, `folders/1234`).
	// The caller must have `resourcemanager.folders.get` permission on the
	// identified folder.
	GetFolder(context.Context, *GetFolderRequest) (*Folder, error)
	// Creates a Folder in the resource hierarchy.
	// Returns an Operation which can be used to track the progress of the
	// folder creation workflow.
	// Upon success the Operation.response field will be populated with the
	// created Folder.
	//
	// In order to succeed, the addition of this new Folder must not violate
	// the Folder naming, height or fanout constraints.
	//
	// + The Folder's display_name must be distinct from all other Folder's that
	// share its parent.
	// + The addition of the Folder must not cause the active Folder hierarchy
	// to exceed a height of 4. Note, the full active + deleted Folder hierarchy
	// is allowed to reach a height of 8; this provides additional headroom when
	// moving folders that contain deleted folders.
	// + The addition of the Folder must not cause the total number of Folders
	// under its parent to exceed 100.
	//
	// If the operation fails due to a folder constraint violation, some errors
	// may be returned by the CreateFolder request, with status code
	// FAILED_PRECONDITION and an error description. Other folder constraint
	// violations will be communicated in the Operation, with the specific
	// PreconditionFailure returned via the details list in the Operation.error
	// field.
	//
	// The caller must have `resourcemanager.folders.create` permission on the
	// identified parent.
	CreateFolder(context.Context, *CreateFolderRequest) (*longrunning.Operation, error)
	// Updates a Folder, changing its display_name.
	// Changes to the folder display_name will be rejected if they violate either
	// the display_name formatting rules or naming constraints described in
	// the [CreateFolder][google.cloud.resourcemanager.v2.Folders.CreateFolder] documentation.
	//
	// The Folder's display name must start and end with a letter or digit,
	// may contain letters, digits, spaces, hyphens and underscores and can be
	// no longer than 30 characters. This is captured by the regular expression:
	// [\p{L}\p{N}]([\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?.
	// The caller must have `resourcemanager.folders.update` permission on the
	// identified folder.
	//
	// If the update fails due to the unique name constraint then a
	// PreconditionFailure explaining this violation will be returned
	// in the Status.details field.
	UpdateFolder(context.Context, *UpdateFolderRequest) (*Folder, error)
	// Moves a Folder under a new resource parent.
	// Returns an Operation which can be used to track the progress of the
	// folder move workflow.
	// Upon success the Operation.response field will be populated with the
	// moved Folder.
	// Upon failure, a FolderOperationError categorizing the failure cause will
	// be returned - if the failure occurs synchronously then the
	// FolderOperationError will be returned via the Status.details field
	// and if it occurs asynchronously then the FolderOperation will be returned
	// via the Operation.error field.
	// In addition, the Operation.metadata field will be populated with a
	// FolderOperation message as an aid to stateless clients.
	// Folder moves will be rejected if they violate either the naming, height
	// or fanout constraints described in the
	// [CreateFolder][google.cloud.resourcemanager.v2.Folders.CreateFolder] documentation.
	// The caller must have `resourcemanager.folders.move` permission on the
	// folder's current and proposed new parent.
	MoveFolder(context.Context, *MoveFolderRequest) (*longrunning.Operation, error)
	// Requests deletion of a Folder. The Folder is moved into the
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v2.Folder.LifecycleState.DELETE_REQUESTED] state
	// immediately, and is deleted approximately 30 days later. This method may
	// only be called on an empty Folder in the
	// [ACTIVE][google.cloud.resourcemanager.v2.Folder.LifecycleState.ACTIVE] state, where a Folder is empty if
	// it doesn't contain any Folders or Projects in the
	// [ACTIVE][google.cloud.resourcemanager.v2.Folder.LifecycleState.ACTIVE] state.
	// The caller must have `resourcemanager.folders.delete` permission on the
	// identified folder.
	DeleteFolder(context.Context, *DeleteFolderRequest) (*Folder, error)
	// Cancels the deletion request for a Folder. This method may only be
	// called on a Folder in the
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v2.Folder.LifecycleState.DELETE_REQUESTED] state.
	// In order to succeed, the Folder's parent must be in the
	// [ACTIVE][google.cloud.resourcemanager.v2.Folder.LifecycleState.ACTIVE] state.
	// In addition, reintroducing the folder into the tree must not violate
	// folder naming, height and fanout constraints described in the
	// [CreateFolder][google.cloud.resourcemanager.v2.Folders.CreateFolder] documentation.
	// The caller must have `resourcemanager.folders.undelete` permission on the
	// identified folder.
	UndeleteFolder(context.Context, *UndeleteFolderRequest) (*Folder, error)
	// Gets the access control policy for a Folder. The returned policy may be
	// empty if no such policy or resource exists. The `resource` field should
	// be the Folder's resource name, e.g. "folders/1234".
	// The caller must have `resourcemanager.folders.getIamPolicy` permission
	// on the identified folder.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the access control policy on a Folder, replacing any existing policy.
	// The `resource` field should be the Folder's resource name, e.g.
	// "folders/1234".
	// The caller must have `resourcemanager.folders.setIamPolicy` permission
	// on the identified folder.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified Folder.
	// The `resource` field should be the Folder's resource name,
	// e.g. "folders/1234".
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedFoldersServer can be embedded to have forward compatible implementations.
type UnimplementedFoldersServer struct {
}

func (*UnimplementedFoldersServer) ListFolders(context.Context, *ListFoldersRequest) (*ListFoldersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFolders not implemented")
}
func (*UnimplementedFoldersServer) SearchFolders(context.Context, *SearchFoldersRequest) (*SearchFoldersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchFolders not implemented")
}
func (*UnimplementedFoldersServer) GetFolder(context.Context, *GetFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFolder not implemented")
}
func (*UnimplementedFoldersServer) CreateFolder(context.Context, *CreateFolderRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFolder not implemented")
}
func (*UnimplementedFoldersServer) UpdateFolder(context.Context, *UpdateFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFolder not implemented")
}
func (*UnimplementedFoldersServer) MoveFolder(context.Context, *MoveFolderRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveFolder not implemented")
}
func (*UnimplementedFoldersServer) DeleteFolder(context.Context, *DeleteFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFolder not implemented")
}
func (*UnimplementedFoldersServer) UndeleteFolder(context.Context, *UndeleteFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteFolder not implemented")
}
func (*UnimplementedFoldersServer) GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedFoldersServer) SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedFoldersServer) TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterFoldersServer(s *grpc.Server, srv FoldersServer) {
	s.RegisterService(&_Folders_serviceDesc, srv)
}

func _Folders_ListFolders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).ListFolders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/ListFolders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).ListFolders(ctx, req.(*ListFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_SearchFolders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).SearchFolders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/SearchFolders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).SearchFolders(ctx, req.(*SearchFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_GetFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).GetFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/GetFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).GetFolder(ctx, req.(*GetFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_CreateFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).CreateFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/CreateFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).CreateFolder(ctx, req.(*CreateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_UpdateFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).UpdateFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/UpdateFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).UpdateFolder(ctx, req.(*UpdateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_MoveFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).MoveFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/MoveFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).MoveFolder(ctx, req.(*MoveFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_DeleteFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).DeleteFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/DeleteFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).DeleteFolder(ctx, req.(*DeleteFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_UndeleteFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).UndeleteFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/UndeleteFolder",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).UndeleteFolder(ctx, req.(*UndeleteFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcemanager.v2.Folders/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Folders_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.resourcemanager.v2.Folders",
	HandlerType: (*FoldersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListFolders",
			Handler:    _Folders_ListFolders_Handler,
		},
		{
			MethodName: "SearchFolders",
			Handler:    _Folders_SearchFolders_Handler,
		},
		{
			MethodName: "GetFolder",
			Handler:    _Folders_GetFolder_Handler,
		},
		{
			MethodName: "CreateFolder",
			Handler:    _Folders_CreateFolder_Handler,
		},
		{
			MethodName: "UpdateFolder",
			Handler:    _Folders_UpdateFolder_Handler,
		},
		{
			MethodName: "MoveFolder",
			Handler:    _Folders_MoveFolder_Handler,
		},
		{
			MethodName: "DeleteFolder",
			Handler:    _Folders_DeleteFolder_Handler,
		},
		{
			MethodName: "UndeleteFolder",
			Handler:    _Folders_UndeleteFolder_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _Folders_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _Folders_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Folders_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/resourcemanager/v2/folders.proto",
}
