// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/iot/v1/resources.proto

package iot

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Indicates whether an MQTT connection is enabled or disabled. See the field
// description for details.
type MqttState int32

const (
	// No MQTT state specified. If not specified, MQTT will be enabled by default.
	MqttState_MQTT_STATE_UNSPECIFIED MqttState = 0
	// Enables a MQTT connection.
	MqttState_MQTT_ENABLED MqttState = 1
	// Disables a MQTT connection.
	MqttState_MQTT_DISABLED MqttState = 2
)

// Enum value maps for MqttState.
var (
	MqttState_name = map[int32]string{
		0: "MQTT_STATE_UNSPECIFIED",
		1: "MQTT_ENABLED",
		2: "MQTT_DISABLED",
	}
	MqttState_value = map[string]int32{
		"MQTT_STATE_UNSPECIFIED": 0,
		"MQTT_ENABLED":           1,
		"MQTT_DISABLED":          2,
	}
)

func (x MqttState) Enum() *MqttState {
	p := new(MqttState)
	*p = x
	return p
}

func (x MqttState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MqttState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_iot_v1_resources_proto_enumTypes[0].Descriptor()
}

func (MqttState) Type() protoreflect.EnumType {
	return &file_google_cloud_iot_v1_resources_proto_enumTypes[0]
}

func (x MqttState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MqttState.Descriptor instead.
func (MqttState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{0}
}

// Indicates whether DeviceService (HTTP) is enabled or disabled for the
// registry. See the field description for details.
type HttpState int32

const (
	// No HTTP state specified. If not specified, DeviceService will be
	// enabled by default.
	HttpState_HTTP_STATE_UNSPECIFIED HttpState = 0
	// Enables DeviceService (HTTP) service for the registry.
	HttpState_HTTP_ENABLED HttpState = 1
	// Disables DeviceService (HTTP) service for the registry.
	HttpState_HTTP_DISABLED HttpState = 2
)

// Enum value maps for HttpState.
var (
	HttpState_name = map[int32]string{
		0: "HTTP_STATE_UNSPECIFIED",
		1: "HTTP_ENABLED",
		2: "HTTP_DISABLED",
	}
	HttpState_value = map[string]int32{
		"HTTP_STATE_UNSPECIFIED": 0,
		"HTTP_ENABLED":           1,
		"HTTP_DISABLED":          2,
	}
)

func (x HttpState) Enum() *HttpState {
	p := new(HttpState)
	*p = x
	return p
}

func (x HttpState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_iot_v1_resources_proto_enumTypes[1].Descriptor()
}

func (HttpState) Type() protoreflect.EnumType {
	return &file_google_cloud_iot_v1_resources_proto_enumTypes[1]
}

func (x HttpState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpState.Descriptor instead.
func (HttpState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{1}
}

// **Beta Feature**
//
// The logging verbosity for device activity. Specifies which events should be
// written to logs. For example, if the LogLevel is ERROR, only events that
// terminate in errors will be logged. LogLevel is inclusive; enabling INFO
// logging will also enable ERROR logging.
type LogLevel int32

const (
	// No logging specified. If not specified, logging will be disabled.
	LogLevel_LOG_LEVEL_UNSPECIFIED LogLevel = 0
	// Disables logging.
	LogLevel_NONE LogLevel = 10
	// Error events will be logged.
	LogLevel_ERROR LogLevel = 20
	// Informational events will be logged, such as connections and
	// disconnections.
	LogLevel_INFO LogLevel = 30
	// All events will be logged.
	LogLevel_DEBUG LogLevel = 40
)

// Enum value maps for LogLevel.
var (
	LogLevel_name = map[int32]string{
		0:  "LOG_LEVEL_UNSPECIFIED",
		10: "NONE",
		20: "ERROR",
		30: "INFO",
		40: "DEBUG",
	}
	LogLevel_value = map[string]int32{
		"LOG_LEVEL_UNSPECIFIED": 0,
		"NONE":                  10,
		"ERROR":                 20,
		"INFO":                  30,
		"DEBUG":                 40,
	}
)

func (x LogLevel) Enum() *LogLevel {
	p := new(LogLevel)
	*p = x
	return p
}

func (x LogLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_iot_v1_resources_proto_enumTypes[2].Descriptor()
}

func (LogLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_iot_v1_resources_proto_enumTypes[2]
}

func (x LogLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogLevel.Descriptor instead.
func (LogLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{2}
}

// Gateway type.
type GatewayType int32

const (
	// If unspecified, the device is considered a non-gateway device.
	GatewayType_GATEWAY_TYPE_UNSPECIFIED GatewayType = 0
	// The device is a gateway.
	GatewayType_GATEWAY GatewayType = 1
	// The device is not a gateway.
	GatewayType_NON_GATEWAY GatewayType = 2
)

// Enum value maps for GatewayType.
var (
	GatewayType_name = map[int32]string{
		0: "GATEWAY_TYPE_UNSPECIFIED",
		1: "GATEWAY",
		2: "NON_GATEWAY",
	}
	GatewayType_value = map[string]int32{
		"GATEWAY_TYPE_UNSPECIFIED": 0,
		"GATEWAY":                  1,
		"NON_GATEWAY":              2,
	}
)

func (x GatewayType) Enum() *GatewayType {
	p := new(GatewayType)
	*p = x
	return p
}

func (x GatewayType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GatewayType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_iot_v1_resources_proto_enumTypes[3].Descriptor()
}

func (GatewayType) Type() protoreflect.EnumType {
	return &file_google_cloud_iot_v1_resources_proto_enumTypes[3]
}

func (x GatewayType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GatewayType.Descriptor instead.
func (GatewayType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{3}
}

// The gateway authorization/authentication method. This setting determines how
// Cloud IoT Core authorizes/authenticate devices to access the gateway.
type GatewayAuthMethod int32

const (
	// No authentication/authorization method specified. No devices are allowed to
	// access the gateway.
	GatewayAuthMethod_GATEWAY_AUTH_METHOD_UNSPECIFIED GatewayAuthMethod = 0
	// The device is authenticated through the gateway association only. Device
	// credentials are ignored even if provided.
	GatewayAuthMethod_ASSOCIATION_ONLY GatewayAuthMethod = 1
	// The device is authenticated through its own credentials. Gateway
	// association is not checked.
	GatewayAuthMethod_DEVICE_AUTH_TOKEN_ONLY GatewayAuthMethod = 2
	// The device is authenticated through both device credentials and gateway
	// association. The device must be bound to the gateway and must provide its
	// own credentials.
	GatewayAuthMethod_ASSOCIATION_AND_DEVICE_AUTH_TOKEN GatewayAuthMethod = 3
)

// Enum value maps for GatewayAuthMethod.
var (
	GatewayAuthMethod_name = map[int32]string{
		0: "GATEWAY_AUTH_METHOD_UNSPECIFIED",
		1: "ASSOCIATION_ONLY",
		2: "DEVICE_AUTH_TOKEN_ONLY",
		3: "ASSOCIATION_AND_DEVICE_AUTH_TOKEN",
	}
	GatewayAuthMethod_value = map[string]int32{
		"GATEWAY_AUTH_METHOD_UNSPECIFIED":   0,
		"ASSOCIATION_ONLY":                  1,
		"DEVICE_AUTH_TOKEN_ONLY":            2,
		"ASSOCIATION_AND_DEVICE_AUTH_TOKEN": 3,
	}
)

func (x GatewayAuthMethod) Enum() *GatewayAuthMethod {
	p := new(GatewayAuthMethod)
	*p = x
	return p
}

func (x GatewayAuthMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GatewayAuthMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_iot_v1_resources_proto_enumTypes[4].Descriptor()
}

func (GatewayAuthMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_iot_v1_resources_proto_enumTypes[4]
}

func (x GatewayAuthMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GatewayAuthMethod.Descriptor instead.
func (GatewayAuthMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{4}
}

// The supported formats for the public key.
type PublicKeyCertificateFormat int32

const (
	// The format has not been specified. This is an invalid default value and
	// must not be used.
	PublicKeyCertificateFormat_UNSPECIFIED_PUBLIC_KEY_CERTIFICATE_FORMAT PublicKeyCertificateFormat = 0
	// An X.509v3 certificate ([RFC5280](https://www.ietf.org/rfc/rfc5280.txt)),
	// encoded in base64, and wrapped by `-----BEGIN CERTIFICATE-----` and
	// `-----END CERTIFICATE-----`.
	PublicKeyCertificateFormat_X509_CERTIFICATE_PEM PublicKeyCertificateFormat = 1
)

// Enum value maps for PublicKeyCertificateFormat.
var (
	PublicKeyCertificateFormat_name = map[int32]string{
		0: "UNSPECIFIED_PUBLIC_KEY_CERTIFICATE_FORMAT",
		1: "X509_CERTIFICATE_PEM",
	}
	PublicKeyCertificateFormat_value = map[string]int32{
		"UNSPECIFIED_PUBLIC_KEY_CERTIFICATE_FORMAT": 0,
		"X509_CERTIFICATE_PEM":                      1,
	}
)

func (x PublicKeyCertificateFormat) Enum() *PublicKeyCertificateFormat {
	p := new(PublicKeyCertificateFormat)
	*p = x
	return p
}

func (x PublicKeyCertificateFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicKeyCertificateFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_iot_v1_resources_proto_enumTypes[5].Descriptor()
}

func (PublicKeyCertificateFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_iot_v1_resources_proto_enumTypes[5]
}

func (x PublicKeyCertificateFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicKeyCertificateFormat.Descriptor instead.
func (PublicKeyCertificateFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{5}
}

// The supported formats for the public key.
type PublicKeyFormat int32

const (
	// The format has not been specified. This is an invalid default value and
	// must not be used.
	PublicKeyFormat_UNSPECIFIED_PUBLIC_KEY_FORMAT PublicKeyFormat = 0
	// An RSA public key encoded in base64, and wrapped by
	// `-----BEGIN PUBLIC KEY-----` and `-----END PUBLIC KEY-----`. This can be
	// used to verify `RS256` signatures in JWT tokens ([RFC7518](
	// https://www.ietf.org/rfc/rfc7518.txt)).
	PublicKeyFormat_RSA_PEM PublicKeyFormat = 3
	// As RSA_PEM, but wrapped in an X.509v3 certificate ([RFC5280](
	// https://www.ietf.org/rfc/rfc5280.txt)), encoded in base64, and wrapped by
	// `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`.
	PublicKeyFormat_RSA_X509_PEM PublicKeyFormat = 1
	// Public key for the ECDSA algorithm using P-256 and SHA-256, encoded in
	// base64, and wrapped by `-----BEGIN PUBLIC KEY-----` and `-----END
	// PUBLIC KEY-----`. This can be used to verify JWT tokens with the `ES256`
	// algorithm ([RFC7518](https://www.ietf.org/rfc/rfc7518.txt)). This curve is
	// defined in [OpenSSL](https://www.openssl.org/) as the `prime256v1` curve.
	PublicKeyFormat_ES256_PEM PublicKeyFormat = 2
	// As ES256_PEM, but wrapped in an X.509v3 certificate ([RFC5280](
	// https://www.ietf.org/rfc/rfc5280.txt)), encoded in base64, and wrapped by
	// `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`.
	PublicKeyFormat_ES256_X509_PEM PublicKeyFormat = 4
)

// Enum value maps for PublicKeyFormat.
var (
	PublicKeyFormat_name = map[int32]string{
		0: "UNSPECIFIED_PUBLIC_KEY_FORMAT",
		3: "RSA_PEM",
		1: "RSA_X509_PEM",
		2: "ES256_PEM",
		4: "ES256_X509_PEM",
	}
	PublicKeyFormat_value = map[string]int32{
		"UNSPECIFIED_PUBLIC_KEY_FORMAT": 0,
		"RSA_PEM":                       3,
		"RSA_X509_PEM":                  1,
		"ES256_PEM":                     2,
		"ES256_X509_PEM":                4,
	}
)

func (x PublicKeyFormat) Enum() *PublicKeyFormat {
	p := new(PublicKeyFormat)
	*p = x
	return p
}

func (x PublicKeyFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicKeyFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_iot_v1_resources_proto_enumTypes[6].Descriptor()
}

func (PublicKeyFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_iot_v1_resources_proto_enumTypes[6]
}

func (x PublicKeyFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicKeyFormat.Descriptor instead.
func (PublicKeyFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{6}
}

// The device resource.
type Device struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user-defined device identifier. The device ID must be unique
	// within a device registry.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The resource path name. For example,
	// `projects/p1/locations/us-central1/registries/registry0/devices/dev0` or
	// `projects/p1/locations/us-central1/registries/registry0/devices/{num_id}`.
	// When `name` is populated as a response from the service, it always ends
	// in the device numeric ID.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// [Output only] A server-defined unique numeric ID for the device. This is a
	// more compact way to identify devices, and it is globally unique.
	NumId uint64 `protobuf:"varint,3,opt,name=num_id,json=numId,proto3" json:"num_id,omitempty"`
	// The credentials used to authenticate this device. To allow credential
	// rotation without interruption, multiple device credentials can be bound to
	// this device. No more than 3 credentials can be bound to a single device at
	// a time. When new credentials are added to a device, they are verified
	// against the registry credentials. For details, see the description of the
	// `DeviceRegistry.credentials` field.
	Credentials []*DeviceCredential `protobuf:"bytes,12,rep,name=credentials,proto3" json:"credentials,omitempty"`
	// [Output only] The last time an MQTT `PINGREQ` was received. This field
	// applies only to devices connecting through MQTT. MQTT clients usually only
	// send `PINGREQ` messages if the connection is idle, and no other messages
	// have been sent. Timestamps are periodically collected and written to
	// storage; they may be stale by a few minutes.
	LastHeartbeatTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=last_heartbeat_time,json=lastHeartbeatTime,proto3" json:"last_heartbeat_time,omitempty"`
	// [Output only] The last time a telemetry event was received. Timestamps are
	// periodically collected and written to storage; they may be stale by a few
	// minutes.
	LastEventTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=last_event_time,json=lastEventTime,proto3" json:"last_event_time,omitempty"`
	// [Output only] The last time a state event was received. Timestamps are
	// periodically collected and written to storage; they may be stale by a few
	// minutes.
	LastStateTime *timestamppb.Timestamp `protobuf:"bytes,20,opt,name=last_state_time,json=lastStateTime,proto3" json:"last_state_time,omitempty"`
	// [Output only] The last time a cloud-to-device config version acknowledgment
	// was received from the device. This field is only for configurations
	// sent through MQTT.
	LastConfigAckTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=last_config_ack_time,json=lastConfigAckTime,proto3" json:"last_config_ack_time,omitempty"`
	// [Output only] The last time a cloud-to-device config version was sent to
	// the device.
	LastConfigSendTime *timestamppb.Timestamp `protobuf:"bytes,18,opt,name=last_config_send_time,json=lastConfigSendTime,proto3" json:"last_config_send_time,omitempty"`
	// If a device is blocked, connections or requests from this device will fail.
	// Can be used to temporarily prevent the device from connecting if, for
	// example, the sensor is generating bad data and needs maintenance.
	Blocked bool `protobuf:"varint,19,opt,name=blocked,proto3" json:"blocked,omitempty"`
	// [Output only] The time the most recent error occurred, such as a failure to
	// publish to Cloud Pub/Sub. This field is the timestamp of
	// 'last_error_status'.
	LastErrorTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=last_error_time,json=lastErrorTime,proto3" json:"last_error_time,omitempty"`
	// [Output only] The error message of the most recent error, such as a failure
	// to publish to Cloud Pub/Sub. 'last_error_time' is the timestamp of this
	// field. If no errors have occurred, this field has an empty message
	// and the status code 0 == OK. Otherwise, this field is expected to have a
	// status code other than OK.
	LastErrorStatus *status.Status `protobuf:"bytes,11,opt,name=last_error_status,json=lastErrorStatus,proto3" json:"last_error_status,omitempty"`
	// The most recent device configuration, which is eventually sent from
	// Cloud IoT Core to the device. If not present on creation, the
	// configuration will be initialized with an empty payload and version value
	// of `1`. To update this field after creation, use the
	// `DeviceManager.ModifyCloudToDeviceConfig` method.
	Config *DeviceConfig `protobuf:"bytes,13,opt,name=config,proto3" json:"config,omitempty"`
	// [Output only] The state most recently received from the device. If no state
	// has been reported, this field is not present.
	State *DeviceState `protobuf:"bytes,16,opt,name=state,proto3" json:"state,omitempty"`
	// **Beta Feature**
	//
	// The logging verbosity for device activity. If unspecified,
	// DeviceRegistry.log_level will be used.
	LogLevel LogLevel `protobuf:"varint,21,opt,name=log_level,json=logLevel,proto3,enum=google.cloud.iot.v1.LogLevel" json:"log_level,omitempty"`
	// The metadata key-value pairs assigned to the device. This metadata is not
	// interpreted or indexed by Cloud IoT Core. It can be used to add contextual
	// information for the device.
	//
	// Keys must conform to the regular expression [a-zA-Z][a-zA-Z0-9-_.+~%]+ and
	// be less than 128 bytes in length.
	//
	// Values are free-form strings. Each value must be less than or equal to 32
	// KB in size.
	//
	// The total size of all keys and values must be less than 256 KB, and the
	// maximum number of key-value pairs is 500.
	Metadata map[string]string `protobuf:"bytes,17,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Gateway-related configuration and state.
	GatewayConfig *GatewayConfig `protobuf:"bytes,24,opt,name=gateway_config,json=gatewayConfig,proto3" json:"gateway_config,omitempty"`
}

func (x *Device) Reset() {
	*x = Device{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Device) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Device) ProtoMessage() {}

func (x *Device) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Device.ProtoReflect.Descriptor instead.
func (*Device) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Device) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Device) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Device) GetNumId() uint64 {
	if x != nil {
		return x.NumId
	}
	return 0
}

func (x *Device) GetCredentials() []*DeviceCredential {
	if x != nil {
		return x.Credentials
	}
	return nil
}

func (x *Device) GetLastHeartbeatTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastHeartbeatTime
	}
	return nil
}

func (x *Device) GetLastEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastEventTime
	}
	return nil
}

func (x *Device) GetLastStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastStateTime
	}
	return nil
}

func (x *Device) GetLastConfigAckTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastConfigAckTime
	}
	return nil
}

func (x *Device) GetLastConfigSendTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastConfigSendTime
	}
	return nil
}

func (x *Device) GetBlocked() bool {
	if x != nil {
		return x.Blocked
	}
	return false
}

func (x *Device) GetLastErrorTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastErrorTime
	}
	return nil
}

func (x *Device) GetLastErrorStatus() *status.Status {
	if x != nil {
		return x.LastErrorStatus
	}
	return nil
}

func (x *Device) GetConfig() *DeviceConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Device) GetState() *DeviceState {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *Device) GetLogLevel() LogLevel {
	if x != nil {
		return x.LogLevel
	}
	return LogLevel_LOG_LEVEL_UNSPECIFIED
}

func (x *Device) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Device) GetGatewayConfig() *GatewayConfig {
	if x != nil {
		return x.GatewayConfig
	}
	return nil
}

// Gateway-related configuration and state.
type GatewayConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether the device is a gateway.
	GatewayType GatewayType `protobuf:"varint,1,opt,name=gateway_type,json=gatewayType,proto3,enum=google.cloud.iot.v1.GatewayType" json:"gateway_type,omitempty"`
	// Indicates how to authorize and/or authenticate devices to access the
	// gateway.
	GatewayAuthMethod GatewayAuthMethod `protobuf:"varint,2,opt,name=gateway_auth_method,json=gatewayAuthMethod,proto3,enum=google.cloud.iot.v1.GatewayAuthMethod" json:"gateway_auth_method,omitempty"`
	// [Output only] The ID of the gateway the device accessed most recently.
	LastAccessedGatewayId string `protobuf:"bytes,3,opt,name=last_accessed_gateway_id,json=lastAccessedGatewayId,proto3" json:"last_accessed_gateway_id,omitempty"`
	// [Output only] The most recent time at which the device accessed the gateway
	// specified in `last_accessed_gateway`.
	LastAccessedGatewayTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=last_accessed_gateway_time,json=lastAccessedGatewayTime,proto3" json:"last_accessed_gateway_time,omitempty"`
}

func (x *GatewayConfig) Reset() {
	*x = GatewayConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayConfig) ProtoMessage() {}

func (x *GatewayConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayConfig.ProtoReflect.Descriptor instead.
func (*GatewayConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *GatewayConfig) GetGatewayType() GatewayType {
	if x != nil {
		return x.GatewayType
	}
	return GatewayType_GATEWAY_TYPE_UNSPECIFIED
}

func (x *GatewayConfig) GetGatewayAuthMethod() GatewayAuthMethod {
	if x != nil {
		return x.GatewayAuthMethod
	}
	return GatewayAuthMethod_GATEWAY_AUTH_METHOD_UNSPECIFIED
}

func (x *GatewayConfig) GetLastAccessedGatewayId() string {
	if x != nil {
		return x.LastAccessedGatewayId
	}
	return ""
}

func (x *GatewayConfig) GetLastAccessedGatewayTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastAccessedGatewayTime
	}
	return nil
}

// A container for a group of devices.
type DeviceRegistry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier of this device registry. For example, `myRegistry`.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The resource path name. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The configuration for notification of telemetry events received from the
	// device. All telemetry events that were successfully published by the
	// device and acknowledged by Cloud IoT Core are guaranteed to be
	// delivered to Cloud Pub/Sub. If multiple configurations match a message,
	// only the first matching configuration is used. If you try to publish a
	// device telemetry event using MQTT without specifying a Cloud Pub/Sub topic
	// for the device's registry, the connection closes automatically. If you try
	// to do so using an HTTP connection, an error is returned. Up to 10
	// configurations may be provided.
	EventNotificationConfigs []*EventNotificationConfig `protobuf:"bytes,10,rep,name=event_notification_configs,json=eventNotificationConfigs,proto3" json:"event_notification_configs,omitempty"`
	// The configuration for notification of new states received from the device.
	// State updates are guaranteed to be stored in the state history, but
	// notifications to Cloud Pub/Sub are not guaranteed. For example, if
	// permissions are misconfigured or the specified topic doesn't exist, no
	// notification will be published but the state will still be stored in Cloud
	// IoT Core.
	StateNotificationConfig *StateNotificationConfig `protobuf:"bytes,7,opt,name=state_notification_config,json=stateNotificationConfig,proto3" json:"state_notification_config,omitempty"`
	// The MQTT configuration for this device registry.
	MqttConfig *MqttConfig `protobuf:"bytes,4,opt,name=mqtt_config,json=mqttConfig,proto3" json:"mqtt_config,omitempty"`
	// The DeviceService (HTTP) configuration for this device registry.
	HttpConfig *HttpConfig `protobuf:"bytes,9,opt,name=http_config,json=httpConfig,proto3" json:"http_config,omitempty"`
	// **Beta Feature**
	//
	// The default logging verbosity for activity from devices in this registry.
	// The verbosity level can be overridden by Device.log_level.
	LogLevel LogLevel `protobuf:"varint,11,opt,name=log_level,json=logLevel,proto3,enum=google.cloud.iot.v1.LogLevel" json:"log_level,omitempty"`
	// The credentials used to verify the device credentials. No more than 10
	// credentials can be bound to a single registry at a time. The verification
	// process occurs at the time of device creation or update. If this field is
	// empty, no verification is performed. Otherwise, the credentials of a newly
	// created device or added credentials of an updated device should be signed
	// with one of these registry credentials.
	//
	// Note, however, that existing devices will never be affected by
	// modifications to this list of credentials: after a device has been
	// successfully created in a registry, it should be able to connect even if
	// its registry credentials are revoked, deleted, or modified.
	Credentials []*RegistryCredential `protobuf:"bytes,8,rep,name=credentials,proto3" json:"credentials,omitempty"`
}

func (x *DeviceRegistry) Reset() {
	*x = DeviceRegistry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceRegistry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceRegistry) ProtoMessage() {}

func (x *DeviceRegistry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceRegistry.ProtoReflect.Descriptor instead.
func (*DeviceRegistry) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *DeviceRegistry) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DeviceRegistry) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeviceRegistry) GetEventNotificationConfigs() []*EventNotificationConfig {
	if x != nil {
		return x.EventNotificationConfigs
	}
	return nil
}

func (x *DeviceRegistry) GetStateNotificationConfig() *StateNotificationConfig {
	if x != nil {
		return x.StateNotificationConfig
	}
	return nil
}

func (x *DeviceRegistry) GetMqttConfig() *MqttConfig {
	if x != nil {
		return x.MqttConfig
	}
	return nil
}

func (x *DeviceRegistry) GetHttpConfig() *HttpConfig {
	if x != nil {
		return x.HttpConfig
	}
	return nil
}

func (x *DeviceRegistry) GetLogLevel() LogLevel {
	if x != nil {
		return x.LogLevel
	}
	return LogLevel_LOG_LEVEL_UNSPECIFIED
}

func (x *DeviceRegistry) GetCredentials() []*RegistryCredential {
	if x != nil {
		return x.Credentials
	}
	return nil
}

// The configuration of MQTT for a device registry.
type MqttConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If enabled, allows connections using the MQTT protocol. Otherwise, MQTT
	// connections to this registry will fail.
	MqttEnabledState MqttState `protobuf:"varint,1,opt,name=mqtt_enabled_state,json=mqttEnabledState,proto3,enum=google.cloud.iot.v1.MqttState" json:"mqtt_enabled_state,omitempty"`
}

func (x *MqttConfig) Reset() {
	*x = MqttConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MqttConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MqttConfig) ProtoMessage() {}

func (x *MqttConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MqttConfig.ProtoReflect.Descriptor instead.
func (*MqttConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *MqttConfig) GetMqttEnabledState() MqttState {
	if x != nil {
		return x.MqttEnabledState
	}
	return MqttState_MQTT_STATE_UNSPECIFIED
}

// The configuration of the HTTP bridge for a device registry.
type HttpConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If enabled, allows devices to use DeviceService via the HTTP protocol.
	// Otherwise, any requests to DeviceService will fail for this registry.
	HttpEnabledState HttpState `protobuf:"varint,1,opt,name=http_enabled_state,json=httpEnabledState,proto3,enum=google.cloud.iot.v1.HttpState" json:"http_enabled_state,omitempty"`
}

func (x *HttpConfig) Reset() {
	*x = HttpConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpConfig) ProtoMessage() {}

func (x *HttpConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpConfig.ProtoReflect.Descriptor instead.
func (*HttpConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *HttpConfig) GetHttpEnabledState() HttpState {
	if x != nil {
		return x.HttpEnabledState
	}
	return HttpState_HTTP_STATE_UNSPECIFIED
}

// The configuration for forwarding telemetry events.
type EventNotificationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If the subfolder name matches this string exactly, this configuration will
	// be used. The string must not include the leading '/' character. If empty,
	// all strings are matched. This field is used only for telemetry events;
	// subfolders are not supported for state changes.
	SubfolderMatches string `protobuf:"bytes,2,opt,name=subfolder_matches,json=subfolderMatches,proto3" json:"subfolder_matches,omitempty"`
	// A Cloud Pub/Sub topic name. For example,
	// `projects/myProject/topics/deviceEvents`.
	PubsubTopicName string `protobuf:"bytes,1,opt,name=pubsub_topic_name,json=pubsubTopicName,proto3" json:"pubsub_topic_name,omitempty"`
}

func (x *EventNotificationConfig) Reset() {
	*x = EventNotificationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventNotificationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventNotificationConfig) ProtoMessage() {}

func (x *EventNotificationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventNotificationConfig.ProtoReflect.Descriptor instead.
func (*EventNotificationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *EventNotificationConfig) GetSubfolderMatches() string {
	if x != nil {
		return x.SubfolderMatches
	}
	return ""
}

func (x *EventNotificationConfig) GetPubsubTopicName() string {
	if x != nil {
		return x.PubsubTopicName
	}
	return ""
}

// The configuration for notification of new states received from the device.
type StateNotificationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A Cloud Pub/Sub topic name. For example,
	// `projects/myProject/topics/deviceEvents`.
	PubsubTopicName string `protobuf:"bytes,1,opt,name=pubsub_topic_name,json=pubsubTopicName,proto3" json:"pubsub_topic_name,omitempty"`
}

func (x *StateNotificationConfig) Reset() {
	*x = StateNotificationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StateNotificationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateNotificationConfig) ProtoMessage() {}

func (x *StateNotificationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateNotificationConfig.ProtoReflect.Descriptor instead.
func (*StateNotificationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *StateNotificationConfig) GetPubsubTopicName() string {
	if x != nil {
		return x.PubsubTopicName
	}
	return ""
}

// A server-stored registry credential used to validate device credentials.
type RegistryCredential struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The credential data. Reserved for expansion in the future.
	//
	// Types that are assignable to Credential:
	//	*RegistryCredential_PublicKeyCertificate
	Credential isRegistryCredential_Credential `protobuf_oneof:"credential"`
}

func (x *RegistryCredential) Reset() {
	*x = RegistryCredential{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegistryCredential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegistryCredential) ProtoMessage() {}

func (x *RegistryCredential) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegistryCredential.ProtoReflect.Descriptor instead.
func (*RegistryCredential) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{7}
}

func (m *RegistryCredential) GetCredential() isRegistryCredential_Credential {
	if m != nil {
		return m.Credential
	}
	return nil
}

func (x *RegistryCredential) GetPublicKeyCertificate() *PublicKeyCertificate {
	if x, ok := x.GetCredential().(*RegistryCredential_PublicKeyCertificate); ok {
		return x.PublicKeyCertificate
	}
	return nil
}

type isRegistryCredential_Credential interface {
	isRegistryCredential_Credential()
}

type RegistryCredential_PublicKeyCertificate struct {
	// A public key certificate used to verify the device credentials.
	PublicKeyCertificate *PublicKeyCertificate `protobuf:"bytes,1,opt,name=public_key_certificate,json=publicKeyCertificate,proto3,oneof"`
}

func (*RegistryCredential_PublicKeyCertificate) isRegistryCredential_Credential() {}

// Details of an X.509 certificate. For informational purposes only.
type X509CertificateDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The entity that signed the certificate.
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// The entity the certificate and public key belong to.
	Subject string `protobuf:"bytes,2,opt,name=subject,proto3" json:"subject,omitempty"`
	// The time the certificate becomes valid.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the certificate becomes invalid.
	ExpiryTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=expiry_time,json=expiryTime,proto3" json:"expiry_time,omitempty"`
	// The algorithm used to sign the certificate.
	SignatureAlgorithm string `protobuf:"bytes,5,opt,name=signature_algorithm,json=signatureAlgorithm,proto3" json:"signature_algorithm,omitempty"`
	// The type of public key in the certificate.
	PublicKeyType string `protobuf:"bytes,6,opt,name=public_key_type,json=publicKeyType,proto3" json:"public_key_type,omitempty"`
}

func (x *X509CertificateDetails) Reset() {
	*x = X509CertificateDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *X509CertificateDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*X509CertificateDetails) ProtoMessage() {}

func (x *X509CertificateDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use X509CertificateDetails.ProtoReflect.Descriptor instead.
func (*X509CertificateDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *X509CertificateDetails) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *X509CertificateDetails) GetSubject() string {
	if x != nil {
		return x.Subject
	}
	return ""
}

func (x *X509CertificateDetails) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *X509CertificateDetails) GetExpiryTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpiryTime
	}
	return nil
}

func (x *X509CertificateDetails) GetSignatureAlgorithm() string {
	if x != nil {
		return x.SignatureAlgorithm
	}
	return ""
}

func (x *X509CertificateDetails) GetPublicKeyType() string {
	if x != nil {
		return x.PublicKeyType
	}
	return ""
}

// A public key certificate format and data.
type PublicKeyCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The certificate format.
	Format PublicKeyCertificateFormat `protobuf:"varint,1,opt,name=format,proto3,enum=google.cloud.iot.v1.PublicKeyCertificateFormat" json:"format,omitempty"`
	// The certificate data.
	Certificate string `protobuf:"bytes,2,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// [Output only] The certificate details. Used only for X.509 certificates.
	X509Details *X509CertificateDetails `protobuf:"bytes,3,opt,name=x509_details,json=x509Details,proto3" json:"x509_details,omitempty"`
}

func (x *PublicKeyCertificate) Reset() {
	*x = PublicKeyCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublicKeyCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicKeyCertificate) ProtoMessage() {}

func (x *PublicKeyCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicKeyCertificate.ProtoReflect.Descriptor instead.
func (*PublicKeyCertificate) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{9}
}

func (x *PublicKeyCertificate) GetFormat() PublicKeyCertificateFormat {
	if x != nil {
		return x.Format
	}
	return PublicKeyCertificateFormat_UNSPECIFIED_PUBLIC_KEY_CERTIFICATE_FORMAT
}

func (x *PublicKeyCertificate) GetCertificate() string {
	if x != nil {
		return x.Certificate
	}
	return ""
}

func (x *PublicKeyCertificate) GetX509Details() *X509CertificateDetails {
	if x != nil {
		return x.X509Details
	}
	return nil
}

// A server-stored device credential used for authentication.
type DeviceCredential struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The credential data. Reserved for expansion in the future.
	//
	// Types that are assignable to Credential:
	//	*DeviceCredential_PublicKey
	Credential isDeviceCredential_Credential `protobuf_oneof:"credential"`
	// [Optional] The time at which this credential becomes invalid. This
	// credential will be ignored for new client authentication requests after
	// this timestamp; however, it will not be automatically deleted.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
}

func (x *DeviceCredential) Reset() {
	*x = DeviceCredential{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceCredential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceCredential) ProtoMessage() {}

func (x *DeviceCredential) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceCredential.ProtoReflect.Descriptor instead.
func (*DeviceCredential) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{10}
}

func (m *DeviceCredential) GetCredential() isDeviceCredential_Credential {
	if m != nil {
		return m.Credential
	}
	return nil
}

func (x *DeviceCredential) GetPublicKey() *PublicKeyCredential {
	if x, ok := x.GetCredential().(*DeviceCredential_PublicKey); ok {
		return x.PublicKey
	}
	return nil
}

func (x *DeviceCredential) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

type isDeviceCredential_Credential interface {
	isDeviceCredential_Credential()
}

type DeviceCredential_PublicKey struct {
	// A public key used to verify the signature of JSON Web Tokens (JWTs).
	// When adding a new device credential, either via device creation or via
	// modifications, this public key credential may be required to be signed by
	// one of the registry level certificates. More specifically, if the
	// registry contains at least one certificate, any new device credential
	// must be signed by one of the registry certificates. As a result,
	// when the registry contains certificates, only X.509 certificates are
	// accepted as device credentials. However, if the registry does
	// not contain a certificate, self-signed certificates and public keys will
	// be accepted. New device credentials must be different from every
	// registry-level certificate.
	PublicKey *PublicKeyCredential `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3,oneof"`
}

func (*DeviceCredential_PublicKey) isDeviceCredential_Credential() {}

// A public key format and data.
type PublicKeyCredential struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The format of the key.
	Format PublicKeyFormat `protobuf:"varint,1,opt,name=format,proto3,enum=google.cloud.iot.v1.PublicKeyFormat" json:"format,omitempty"`
	// The key data.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *PublicKeyCredential) Reset() {
	*x = PublicKeyCredential{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublicKeyCredential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicKeyCredential) ProtoMessage() {}

func (x *PublicKeyCredential) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicKeyCredential.ProtoReflect.Descriptor instead.
func (*PublicKeyCredential) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{11}
}

func (x *PublicKeyCredential) GetFormat() PublicKeyFormat {
	if x != nil {
		return x.Format
	}
	return PublicKeyFormat_UNSPECIFIED_PUBLIC_KEY_FORMAT
}

func (x *PublicKeyCredential) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

// The device configuration. Eventually delivered to devices.
type DeviceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output only] The version of this update. The version number is assigned by
	// the server, and is always greater than 0 after device creation. The
	// version must be 0 on the `CreateDevice` request if a `config` is
	// specified; the response of `CreateDevice` will always have a value of 1.
	Version int64 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// [Output only] The time at which this configuration version was updated in
	// Cloud IoT Core. This timestamp is set by the server.
	CloudUpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=cloud_update_time,json=cloudUpdateTime,proto3" json:"cloud_update_time,omitempty"`
	// [Output only] The time at which Cloud IoT Core received the
	// acknowledgment from the device, indicating that the device has received
	// this configuration version. If this field is not present, the device has
	// not yet acknowledged that it received this version. Note that when
	// the config was sent to the device, many config versions may have been
	// available in Cloud IoT Core while the device was disconnected, and on
	// connection, only the latest version is sent to the device. Some
	// versions may never be sent to the device, and therefore are never
	// acknowledged. This timestamp is set by Cloud IoT Core.
	DeviceAckTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=device_ack_time,json=deviceAckTime,proto3" json:"device_ack_time,omitempty"`
	// The device configuration data.
	BinaryData []byte `protobuf:"bytes,4,opt,name=binary_data,json=binaryData,proto3" json:"binary_data,omitempty"`
}

func (x *DeviceConfig) Reset() {
	*x = DeviceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceConfig) ProtoMessage() {}

func (x *DeviceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceConfig.ProtoReflect.Descriptor instead.
func (*DeviceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{12}
}

func (x *DeviceConfig) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *DeviceConfig) GetCloudUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CloudUpdateTime
	}
	return nil
}

func (x *DeviceConfig) GetDeviceAckTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeviceAckTime
	}
	return nil
}

func (x *DeviceConfig) GetBinaryData() []byte {
	if x != nil {
		return x.BinaryData
	}
	return nil
}

// The device state, as reported by the device.
type DeviceState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output only] The time at which this state version was updated in Cloud
	// IoT Core.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The device state data.
	BinaryData []byte `protobuf:"bytes,2,opt,name=binary_data,json=binaryData,proto3" json:"binary_data,omitempty"`
}

func (x *DeviceState) Reset() {
	*x = DeviceState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceState) ProtoMessage() {}

func (x *DeviceState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iot_v1_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceState.ProtoReflect.Descriptor instead.
func (*DeviceState) Descriptor() ([]byte, []int) {
	return file_google_cloud_iot_v1_resources_proto_rawDescGZIP(), []int{13}
}

func (x *DeviceState) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DeviceState) GetBinaryData() []byte {
	if x != nil {
		return x.BinaryData
	}
	return nil
}

var File_google_cloud_iot_v1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_iot_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x69,
	0x6f, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72,
	0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x8d, 0x09, 0x0a, 0x06, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15,
	0x0a, 0x06, 0x6e, 0x75, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05,
	0x6e, 0x75, 0x6d, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x52, 0x0b, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x4a,
	0x0a, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x48, 0x65, 0x61,
	0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0f, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0d, 0x6c, 0x61, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42,
	0x0a, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x14, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x11, 0x6c, 0x61,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x41, 0x63, 0x6b, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4d, 0x0a, 0x15, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x73,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x12, 0x6c, 0x61, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x12, 0x42, 0x0a, 0x0f, 0x6c, 0x61, 0x73, 0x74,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x6c,
	0x61, 0x73, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x11,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0f, 0x6c, 0x61, 0x73,
	0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x39, 0x0a, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x3a, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x45, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x49, 0x0a, 0x0e, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3b, 0x0a,
	0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x73, 0xea, 0x41, 0x70, 0x0a,
	0x1e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x69, 0x6f, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x4e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x7d, 0x2f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x22,
	0xbe, 0x02, 0x0a, 0x0d, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x43, 0x0a, 0x0c, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x56, 0x0a, 0x13, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x11, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x37,
	0x0a, 0x18, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x5f,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x15, 0x6c, 0x61, 0x73, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0x57, 0x0a, 0x1a, 0x6c, 0x61, 0x73, 0x74, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x17, 0x6c, 0x61, 0x73, 0x74, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0xfb, 0x04, 0x0a, 0x0e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x6a, 0x0a, 0x1a, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x18, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0x68, 0x0a, 0x19, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x17, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a,
	0x0b, 0x6d, 0x71, 0x74, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x71, 0x74, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0a, 0x6d, 0x71, 0x74, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x40, 0x0a, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x68, 0x74, 0x74, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x3a, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x49, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x0b, 0x63, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x3a, 0x64, 0xea, 0x41, 0x61, 0x0a, 0x20, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x69, 0x6f, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x12,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x7d, 0x22, 0x5a,
	0x0a, 0x0a, 0x4d, 0x71, 0x74, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x12,
	0x6d, 0x71, 0x74, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x71, 0x74, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x10, 0x6d, 0x71, 0x74, 0x74, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x5a, 0x0a, 0x0a, 0x48, 0x74,
	0x74, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x12, 0x68, 0x74, 0x74, 0x70,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x10, 0x68, 0x74, 0x74, 0x70, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x72, 0x0a, 0x17, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x75, 0x62, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x75,
	0x62, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x2a,
	0x0a, 0x11, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x45, 0x0a, 0x17, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x11, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d,
	0x65, 0x22, 0x85, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x43, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x61, 0x0a, 0x16, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x14, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x63,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x22, 0x9b, 0x02, 0x0a, 0x16, 0x58, 0x35,
	0x30, 0x39, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07,
	0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73,
	0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2f,
	0x0a, 0x13, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x61, 0x6c, 0x67, 0x6f,
	0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x69, 0x67,
	0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12,
	0x26, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x22, 0xd1, 0x01, 0x0a, 0x14, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x4b, 0x65, 0x79, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x12, 0x47, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x4e, 0x0a, 0x0c, 0x78,
	0x35, 0x30, 0x39, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x58, 0x35, 0x30, 0x39, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x0b,
	0x78, 0x35, 0x30, 0x39, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xb0, 0x01, 0x0a, 0x10,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x12, 0x49, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x48, 0x00,
	0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x43, 0x0a, 0x0f, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x42, 0x0c, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x22, 0x65,
	0x0a, 0x13, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x43, 0x72, 0x65, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x3c, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x4b, 0x65, 0x79, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x06, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0xd5, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x46, 0x0a, 0x11, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0f, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x6b, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0a, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x22, 0x6b, 0x0a,
	0x0b, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a,
	0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x2a, 0x4c, 0x0a, 0x09, 0x4d, 0x71,
	0x74, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x51, 0x54, 0x54, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x51, 0x54, 0x54, 0x5f, 0x45, 0x4e, 0x41, 0x42,
	0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x51, 0x54, 0x54, 0x5f, 0x44, 0x49,
	0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x2a, 0x4c, 0x0a, 0x09, 0x48, 0x74, 0x74, 0x70,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x2a, 0x4f, 0x0a, 0x08, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x12, 0x19, 0x0a, 0x15, 0x4c, 0x4f, 0x47, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x0a, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x14, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x1e, 0x12, 0x09, 0x0a, 0x05,
	0x44, 0x45, 0x42, 0x55, 0x47, 0x10, 0x28, 0x2a, 0x49, 0x0a, 0x0b, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41,
	0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59, 0x10,
	0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x4e, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59,
	0x10, 0x02, 0x2a, 0x91, 0x01, 0x0a, 0x11, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x75,
	0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x23, 0x0a, 0x1f, 0x47, 0x41, 0x54, 0x45,
	0x57, 0x41, 0x59, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a,
	0x10, 0x41, 0x53, 0x53, 0x4f, 0x43, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x4e, 0x4c,
	0x59, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x55,
	0x54, 0x48, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x12,
	0x25, 0x0a, 0x21, 0x41, 0x53, 0x53, 0x4f, 0x43, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41,
	0x4e, 0x44, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x54,
	0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x03, 0x2a, 0x65, 0x0a, 0x1a, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x4b, 0x65, 0x79, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x12, 0x2d, 0x0a, 0x29, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x43,
	0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41,
	0x54, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x58, 0x35, 0x30, 0x39, 0x5f, 0x43, 0x45, 0x52, 0x54,
	0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x45, 0x4d, 0x10, 0x01, 0x2a, 0x76, 0x0a,
	0x0f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x12, 0x21, 0x0a, 0x1d, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f,
	0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41,
	0x54, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x53, 0x41, 0x5f, 0x50, 0x45, 0x4d, 0x10, 0x03,
	0x12, 0x10, 0x0a, 0x0c, 0x52, 0x53, 0x41, 0x5f, 0x58, 0x35, 0x30, 0x39, 0x5f, 0x50, 0x45, 0x4d,
	0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x53, 0x32, 0x35, 0x36, 0x5f, 0x50, 0x45, 0x4d, 0x10,
	0x02, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x53, 0x32, 0x35, 0x36, 0x5f, 0x58, 0x35, 0x30, 0x39, 0x5f,
	0x50, 0x45, 0x4d, 0x10, 0x04, 0x42, 0x66, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6f, 0x74, 0x2e, 0x76, 0x31,
	0x42, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x69, 0x6f, 0x74, 0x2f, 0x76, 0x31, 0x3b, 0x69, 0x6f, 0x74, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_iot_v1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_iot_v1_resources_proto_rawDescData = file_google_cloud_iot_v1_resources_proto_rawDesc
)

func file_google_cloud_iot_v1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_iot_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_iot_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_iot_v1_resources_proto_rawDescData)
	})
	return file_google_cloud_iot_v1_resources_proto_rawDescData
}

var file_google_cloud_iot_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_iot_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_iot_v1_resources_proto_goTypes = []interface{}{
	(MqttState)(0),                  // 0: google.cloud.iot.v1.MqttState
	(HttpState)(0),                  // 1: google.cloud.iot.v1.HttpState
	(LogLevel)(0),                   // 2: google.cloud.iot.v1.LogLevel
	(GatewayType)(0),                // 3: google.cloud.iot.v1.GatewayType
	(GatewayAuthMethod)(0),          // 4: google.cloud.iot.v1.GatewayAuthMethod
	(PublicKeyCertificateFormat)(0), // 5: google.cloud.iot.v1.PublicKeyCertificateFormat
	(PublicKeyFormat)(0),            // 6: google.cloud.iot.v1.PublicKeyFormat
	(*Device)(nil),                  // 7: google.cloud.iot.v1.Device
	(*GatewayConfig)(nil),           // 8: google.cloud.iot.v1.GatewayConfig
	(*DeviceRegistry)(nil),          // 9: google.cloud.iot.v1.DeviceRegistry
	(*MqttConfig)(nil),              // 10: google.cloud.iot.v1.MqttConfig
	(*HttpConfig)(nil),              // 11: google.cloud.iot.v1.HttpConfig
	(*EventNotificationConfig)(nil), // 12: google.cloud.iot.v1.EventNotificationConfig
	(*StateNotificationConfig)(nil), // 13: google.cloud.iot.v1.StateNotificationConfig
	(*RegistryCredential)(nil),      // 14: google.cloud.iot.v1.RegistryCredential
	(*X509CertificateDetails)(nil),  // 15: google.cloud.iot.v1.X509CertificateDetails
	(*PublicKeyCertificate)(nil),    // 16: google.cloud.iot.v1.PublicKeyCertificate
	(*DeviceCredential)(nil),        // 17: google.cloud.iot.v1.DeviceCredential
	(*PublicKeyCredential)(nil),     // 18: google.cloud.iot.v1.PublicKeyCredential
	(*DeviceConfig)(nil),            // 19: google.cloud.iot.v1.DeviceConfig
	(*DeviceState)(nil),             // 20: google.cloud.iot.v1.DeviceState
	nil,                             // 21: google.cloud.iot.v1.Device.MetadataEntry
	(*timestamppb.Timestamp)(nil),   // 22: google.protobuf.Timestamp
	(*status.Status)(nil),           // 23: google.rpc.Status
}
var file_google_cloud_iot_v1_resources_proto_depIdxs = []int32{
	17, // 0: google.cloud.iot.v1.Device.credentials:type_name -> google.cloud.iot.v1.DeviceCredential
	22, // 1: google.cloud.iot.v1.Device.last_heartbeat_time:type_name -> google.protobuf.Timestamp
	22, // 2: google.cloud.iot.v1.Device.last_event_time:type_name -> google.protobuf.Timestamp
	22, // 3: google.cloud.iot.v1.Device.last_state_time:type_name -> google.protobuf.Timestamp
	22, // 4: google.cloud.iot.v1.Device.last_config_ack_time:type_name -> google.protobuf.Timestamp
	22, // 5: google.cloud.iot.v1.Device.last_config_send_time:type_name -> google.protobuf.Timestamp
	22, // 6: google.cloud.iot.v1.Device.last_error_time:type_name -> google.protobuf.Timestamp
	23, // 7: google.cloud.iot.v1.Device.last_error_status:type_name -> google.rpc.Status
	19, // 8: google.cloud.iot.v1.Device.config:type_name -> google.cloud.iot.v1.DeviceConfig
	20, // 9: google.cloud.iot.v1.Device.state:type_name -> google.cloud.iot.v1.DeviceState
	2,  // 10: google.cloud.iot.v1.Device.log_level:type_name -> google.cloud.iot.v1.LogLevel
	21, // 11: google.cloud.iot.v1.Device.metadata:type_name -> google.cloud.iot.v1.Device.MetadataEntry
	8,  // 12: google.cloud.iot.v1.Device.gateway_config:type_name -> google.cloud.iot.v1.GatewayConfig
	3,  // 13: google.cloud.iot.v1.GatewayConfig.gateway_type:type_name -> google.cloud.iot.v1.GatewayType
	4,  // 14: google.cloud.iot.v1.GatewayConfig.gateway_auth_method:type_name -> google.cloud.iot.v1.GatewayAuthMethod
	22, // 15: google.cloud.iot.v1.GatewayConfig.last_accessed_gateway_time:type_name -> google.protobuf.Timestamp
	12, // 16: google.cloud.iot.v1.DeviceRegistry.event_notification_configs:type_name -> google.cloud.iot.v1.EventNotificationConfig
	13, // 17: google.cloud.iot.v1.DeviceRegistry.state_notification_config:type_name -> google.cloud.iot.v1.StateNotificationConfig
	10, // 18: google.cloud.iot.v1.DeviceRegistry.mqtt_config:type_name -> google.cloud.iot.v1.MqttConfig
	11, // 19: google.cloud.iot.v1.DeviceRegistry.http_config:type_name -> google.cloud.iot.v1.HttpConfig
	2,  // 20: google.cloud.iot.v1.DeviceRegistry.log_level:type_name -> google.cloud.iot.v1.LogLevel
	14, // 21: google.cloud.iot.v1.DeviceRegistry.credentials:type_name -> google.cloud.iot.v1.RegistryCredential
	0,  // 22: google.cloud.iot.v1.MqttConfig.mqtt_enabled_state:type_name -> google.cloud.iot.v1.MqttState
	1,  // 23: google.cloud.iot.v1.HttpConfig.http_enabled_state:type_name -> google.cloud.iot.v1.HttpState
	16, // 24: google.cloud.iot.v1.RegistryCredential.public_key_certificate:type_name -> google.cloud.iot.v1.PublicKeyCertificate
	22, // 25: google.cloud.iot.v1.X509CertificateDetails.start_time:type_name -> google.protobuf.Timestamp
	22, // 26: google.cloud.iot.v1.X509CertificateDetails.expiry_time:type_name -> google.protobuf.Timestamp
	5,  // 27: google.cloud.iot.v1.PublicKeyCertificate.format:type_name -> google.cloud.iot.v1.PublicKeyCertificateFormat
	15, // 28: google.cloud.iot.v1.PublicKeyCertificate.x509_details:type_name -> google.cloud.iot.v1.X509CertificateDetails
	18, // 29: google.cloud.iot.v1.DeviceCredential.public_key:type_name -> google.cloud.iot.v1.PublicKeyCredential
	22, // 30: google.cloud.iot.v1.DeviceCredential.expiration_time:type_name -> google.protobuf.Timestamp
	6,  // 31: google.cloud.iot.v1.PublicKeyCredential.format:type_name -> google.cloud.iot.v1.PublicKeyFormat
	22, // 32: google.cloud.iot.v1.DeviceConfig.cloud_update_time:type_name -> google.protobuf.Timestamp
	22, // 33: google.cloud.iot.v1.DeviceConfig.device_ack_time:type_name -> google.protobuf.Timestamp
	22, // 34: google.cloud.iot.v1.DeviceState.update_time:type_name -> google.protobuf.Timestamp
	35, // [35:35] is the sub-list for method output_type
	35, // [35:35] is the sub-list for method input_type
	35, // [35:35] is the sub-list for extension type_name
	35, // [35:35] is the sub-list for extension extendee
	0,  // [0:35] is the sub-list for field type_name
}

func init() { file_google_cloud_iot_v1_resources_proto_init() }
func file_google_cloud_iot_v1_resources_proto_init() {
	if File_google_cloud_iot_v1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_iot_v1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Device); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceRegistry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MqttConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventNotificationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StateNotificationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegistryCredential); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*X509CertificateDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublicKeyCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceCredential); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublicKeyCredential); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iot_v1_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_iot_v1_resources_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*RegistryCredential_PublicKeyCertificate)(nil),
	}
	file_google_cloud_iot_v1_resources_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*DeviceCredential_PublicKey)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_iot_v1_resources_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_iot_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_iot_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_iot_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_iot_v1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_iot_v1_resources_proto = out.File
	file_google_cloud_iot_v1_resources_proto_rawDesc = nil
	file_google_cloud_iot_v1_resources_proto_goTypes = nil
	file_google_cloud_iot_v1_resources_proto_depIdxs = nil
}
