// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateMultiplexInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`

	// Contains configuration for a Multiplex event
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure"`

	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UpdateMultiplexInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMultiplexInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateMultiplexInput"}

	if s.MultiplexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexSettings != nil {
		if err := s.MultiplexSettings.Validate(); err != nil {
			invalidParams.AddNested("MultiplexSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateMultiplexInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MultiplexSettings != nil {
		v := s.MultiplexSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "multiplexSettings", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MultiplexId != nil {
		v := *s.MultiplexId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "multiplexId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateMultiplexOutput struct {
	_ struct{} `type:"structure"`

	// The multiplex object.
	Multiplex *Multiplex `locationName:"multiplex" type:"structure"`
}

// String returns the string representation
func (s UpdateMultiplexOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateMultiplexOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Multiplex != nil {
		v := s.Multiplex

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "multiplex", v, metadata)
	}
	return nil
}

const opUpdateMultiplex = "UpdateMultiplex"

// UpdateMultiplexRequest returns a request value for making API operation for
// AWS Elemental MediaLive.
//
// Updates a multiplex.
//
//    // Example sending a request using UpdateMultiplexRequest.
//    req := client.UpdateMultiplexRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex
func (c *Client) UpdateMultiplexRequest(input *UpdateMultiplexInput) UpdateMultiplexRequest {
	op := &aws.Operation{
		Name:       opUpdateMultiplex,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/multiplexes/{multiplexId}",
	}

	if input == nil {
		input = &UpdateMultiplexInput{}
	}

	req := c.newRequest(op, input, &UpdateMultiplexOutput{})
	return UpdateMultiplexRequest{Request: req, Input: input, Copy: c.UpdateMultiplexRequest}
}

// UpdateMultiplexRequest is the request type for the
// UpdateMultiplex API operation.
type UpdateMultiplexRequest struct {
	*aws.Request
	Input *UpdateMultiplexInput
	Copy  func(*UpdateMultiplexInput) UpdateMultiplexRequest
}

// Send marshals and sends the UpdateMultiplex API request.
func (r UpdateMultiplexRequest) Send(ctx context.Context) (*UpdateMultiplexResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateMultiplexResponse{
		UpdateMultiplexOutput: r.Request.Data.(*UpdateMultiplexOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateMultiplexResponse is the response type for the
// UpdateMultiplex API operation.
type UpdateMultiplexResponse struct {
	*UpdateMultiplexOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateMultiplex request.
func (r *UpdateMultiplexResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
