// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestarnotifications

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteTargetInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value that can be used to delete all associations with this SNS
	// topic. The default value is FALSE. If set to TRUE, all associations between
	// that target and every notification rule in your AWS account are deleted.
	ForceUnsubscribeAll *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the SNS topic to delete.
	//
	// TargetAddress is a required field
	TargetAddress *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s DeleteTargetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTargetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTargetInput"}

	if s.TargetAddress == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetAddress"))
	}
	if s.TargetAddress != nil && len(*s.TargetAddress) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteTargetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ForceUnsubscribeAll != nil {
		v := *s.ForceUnsubscribeAll

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ForceUnsubscribeAll", protocol.BoolValue(v), metadata)
	}
	if s.TargetAddress != nil {
		v := *s.TargetAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteTargetOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteTarget = "DeleteTarget"

// DeleteTargetRequest returns a request value for making API operation for
// AWS CodeStar Notifications.
//
// Deletes a specified target for notifications.
//
//    // Example sending a request using DeleteTargetRequest.
//    req := client.DeleteTargetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-notifications-2019-10-15/DeleteTarget
func (c *Client) DeleteTargetRequest(input *DeleteTargetInput) DeleteTargetRequest {
	op := &aws.Operation{
		Name:       opDeleteTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteTarget",
	}

	if input == nil {
		input = &DeleteTargetInput{}
	}

	req := c.newRequest(op, input, &DeleteTargetOutput{})
	return DeleteTargetRequest{Request: req, Input: input, Copy: c.DeleteTargetRequest}
}

// DeleteTargetRequest is the request type for the
// DeleteTarget API operation.
type DeleteTargetRequest struct {
	*aws.Request
	Input *DeleteTargetInput
	Copy  func(*DeleteTargetInput) DeleteTargetRequest
}

// Send marshals and sends the DeleteTarget API request.
func (r DeleteTargetRequest) Send(ctx context.Context) (*DeleteTargetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTargetResponse{
		DeleteTargetOutput: r.Request.Data.(*DeleteTargetOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTargetResponse is the response type for the
// DeleteTarget API operation.
type DeleteTargetResponse struct {
	*DeleteTargetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTarget request.
func (r *DeleteTargetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
