// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Access log settings, including the access log format and access log destination
// ARN.
type AccessLogSettings struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch Logs log group to receive access logs.
	DestinationArn *string `locationName:"destinationArn" type:"string"`

	// A single line format of the access logs of data, as specified by selected
	// $context variables (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference).
	// The format must include at least $context.requestId.
	Format *string `locationName:"format" type:"string"`
}

// String returns the string representation
func (s AccessLogSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessLogSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationArn != nil {
		v := *s.DestinationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "destinationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Format != nil {
		v := *s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "format", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A resource that can be distributed to callers for executing Method resources
// that require an API key. API keys can be mapped to any Stage on any RestApi,
// which indicates that the callers with the API key can make requests to that
// stage.
//
// Use API Keys (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html)
type ApiKey struct {
	_ struct{} `type:"structure"`

	// The timestamp when the API Key was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// An AWS Marketplace customer identifier , when integrating with the AWS SaaS
	// Marketplace.
	CustomerId *string `locationName:"customerId" type:"string"`

	// The description of the API Key.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether the API Key can be used by callers.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The identifier of the API Key.
	Id *string `locationName:"id" type:"string"`

	// The timestamp when the API Key was last updated.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the API Key.
	Name *string `locationName:"name" type:"string"`

	// A list of Stage resources that are associated with the ApiKey resource.
	StageKeys []string `locationName:"stageKeys" type:"list"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The value of the API Key.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s ApiKey) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApiKey) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.CustomerId != nil {
		v := *s.CustomerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "customerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enabled", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedDate != nil {
		v := *s.LastUpdatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StageKeys != nil {
		v := s.StageKeys

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "stageKeys", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// API stage name of the associated API stage in a usage plan.
type ApiStage struct {
	_ struct{} `type:"structure"`

	// API Id of the associated API stage in a usage plan.
	ApiId *string `locationName:"apiId" type:"string"`

	// API stage name of the associated API stage in a usage plan.
	Stage *string `locationName:"stage" type:"string"`

	// Map containing method level throttling information for API stage in a usage
	// plan.
	Throttle map[string]ThrottleSettings `locationName:"throttle" type:"map"`
}

// String returns the string representation
func (s ApiStage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApiStage) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Stage != nil {
		v := *s.Stage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Throttle != nil {
		v := s.Throttle

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "throttle", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Represents an authorization layer for methods. If enabled on a method, API
// Gateway will activate the authorizer when a client calls the method.
//
// Use Lambda Function as Authorizer (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html)
// Use Cognito User Pool as Authorizer (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html)
type Authorizer struct {
	_ struct{} `type:"structure"`

	// Optional customer-defined field, used in OpenAPI imports and exports without
	// functional impact.
	AuthType *string `locationName:"authType" type:"string"`

	// Specifies the required credentials as an IAM role for API Gateway to invoke
	// the authorizer. To specify an IAM role for API Gateway to assume, use the
	// role's Amazon Resource Name (ARN). To use resource-based permissions on the
	// Lambda function, specify null.
	AuthorizerCredentials *string `locationName:"authorizerCredentials" type:"string"`

	// The TTL in seconds of cached authorizer results. If it equals 0, authorization
	// caching is disabled. If it is greater than 0, API Gateway will cache authorizer
	// responses. If this field is not set, the default value is 300. The maximum
	// value is 3600, or 1 hour.
	AuthorizerResultTtlInSeconds *int64 `locationName:"authorizerResultTtlInSeconds" type:"integer"`

	// Specifies the authorizer's Uniform Resource Identifier (URI). For TOKEN or
	// REQUEST authorizers, this must be a well-formed Lambda function URI, for
	// example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations.
	// In general, the URI has this form arn:aws:apigateway:{region}:lambda:path/{service_api},
	// where {region} is the same as the region hosting the Lambda function, path
	// indicates that the remaining substring in the URI should be treated as the
	// path to the resource, including the initial /. For Lambda functions, this
	// is usually of the form /2015-03-31/functions/[FunctionARN]/invocations.
	AuthorizerUri *string `locationName:"authorizerUri" type:"string"`

	// The identifier for the authorizer resource.
	Id *string `locationName:"id" type:"string"`

	// The identity source for which authorization is requested.
	//    * For a TOKEN or COGNITO_USER_POOLS authorizer, this is required and specifies
	//    the request header mapping expression for the custom header holding the
	//    authorization token submitted by the client. For example, if the token
	//    header name is Auth, the header mapping expression is method.request.header.Auth.
	//
	//    * For the REQUEST authorizer, this is required when authorization caching
	//    is enabled. The value is a comma-separated string of one or more mapping
	//    expressions of the specified request parameters. For example, if an Auth
	//    header, a Name query string parameter are defined as identity sources,
	//    this value is method.request.header.Auth, method.request.querystring.Name.
	//    These parameters will be used to derive the authorization caching key
	//    and to perform runtime validation of the REQUEST authorizer by verifying
	//    all of the identity-related request parameters are present, not null and
	//    non-empty. Only when this is true does the authorizer invoke the authorizer
	//    Lambda function, otherwise, it returns a 401 Unauthorized response without
	//    calling the Lambda function. The valid value is a string of comma-separated
	//    mapping expressions of the specified request parameters. When the authorization
	//    caching is not enabled, this property is optional.
	IdentitySource *string `locationName:"identitySource" type:"string"`

	// A validation expression for the incoming identity token. For TOKEN authorizers,
	// this value is a regular expression. For COGNITO_USER_POOLS authorizers, API
	// Gateway will match the aud field of the incoming token from the client against
	// the specified regular expression. It will invoke the authorizer's Lambda
	// function when there is a match. Otherwise, it will return a 401 Unauthorized
	// response without calling the Lambda function. The validation expression does
	// not apply to the REQUEST authorizer.
	IdentityValidationExpression *string `locationName:"identityValidationExpression" type:"string"`

	// [Required] The name of the authorizer.
	Name *string `locationName:"name" type:"string"`

	// A list of the Amazon Cognito user pool ARNs for the COGNITO_USER_POOLS authorizer.
	// Each element is of this format: arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}.
	// For a TOKEN or REQUEST authorizer, this is not defined.
	ProviderARNs []string `locationName:"providerARNs" type:"list"`

	// The authorizer type. Valid values are TOKEN for a Lambda function using a
	// single authorization token submitted in a custom header, REQUEST for a Lambda
	// function using incoming request parameters, and COGNITO_USER_POOLS for using
	// an Amazon Cognito user pool.
	Type AuthorizerType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s Authorizer) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Authorizer) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuthType != nil {
		v := *s.AuthType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthorizerCredentials != nil {
		v := *s.AuthorizerCredentials

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerCredentials", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthorizerResultTtlInSeconds != nil {
		v := *s.AuthorizerResultTtlInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerResultTtlInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.AuthorizerUri != nil {
		v := *s.AuthorizerUri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerUri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdentitySource != nil {
		v := *s.IdentitySource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "identitySource", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdentityValidationExpression != nil {
		v := *s.IdentityValidationExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "identityValidationExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProviderARNs != nil {
		v := s.ProviderARNs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "providerARNs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Represents the base path that callers of the API must provide as part of
// the URL after the domain name.
//
// A custom domain name plus a BasePathMapping specification identifies a deployed
// RestApi in a given stage of the owner Account.
//
// Use Custom Domain Names (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html)
type BasePathMapping struct {
	_ struct{} `type:"structure"`

	// The base path name that callers of the API must provide as part of the URL
	// after the domain name.
	BasePath *string `locationName:"basePath" type:"string"`

	// The string identifier of the associated RestApi.
	RestApiId *string `locationName:"restApiId" type:"string"`

	// The name of the associated stage.
	Stage *string `locationName:"stage" type:"string"`
}

// String returns the string representation
func (s BasePathMapping) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BasePathMapping) MarshalFields(e protocol.FieldEncoder) error {
	if s.BasePath != nil {
		v := *s.BasePath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "basePath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "restApiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Stage != nil {
		v := *s.Stage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Configuration settings of a canary deployment.
type CanarySettings struct {
	_ struct{} `type:"structure"`

	// The ID of the canary deployment.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The percent (0-100) of traffic diverted to a canary deployment.
	PercentTraffic *float64 `locationName:"percentTraffic" type:"double"`

	// Stage variables overridden for a canary release deployment, including new
	// stage variables introduced in the canary. These stage variables are represented
	// as a string-to-string map between stage variable names and their values.
	StageVariableOverrides map[string]string `locationName:"stageVariableOverrides" type:"map"`

	// A Boolean flag to indicate whether the canary deployment uses the stage cache
	// or not.
	UseStageCache *bool `locationName:"useStageCache" type:"boolean"`
}

// String returns the string representation
func (s CanarySettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CanarySettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PercentTraffic != nil {
		v := *s.PercentTraffic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "percentTraffic", protocol.Float64Value(v), metadata)
	}
	if s.StageVariableOverrides != nil {
		v := s.StageVariableOverrides

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "stageVariableOverrides", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UseStageCache != nil {
		v := *s.UseStageCache

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "useStageCache", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Represents a client certificate used to configure client-side SSL authentication
// while sending requests to the integration endpoint.
//
// Client certificates are used to authenticate an API by the backend server.
// To authenticate an API client (or user), use IAM roles and policies, a custom
// Authorizer or an Amazon Cognito user pool.
//
// Use Client-Side Certificate (https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-client-side-ssl-authentication.html)
type Certificate struct {
	_ struct{} `type:"structure"`

	// The identifier of the client certificate.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// The timestamp when the client certificate was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// The description of the client certificate.
	Description *string `locationName:"description" type:"string"`

	// The timestamp when the client certificate will expire.
	ExpirationDate *time.Time `locationName:"expirationDate" type:"timestamp"`

	// The PEM-encoded public key of the client certificate, which can be used to
	// configure certificate authentication in the integration endpoint .
	PemEncodedCertificate *string `locationName:"pemEncodedCertificate" type:"string"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Certificate) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClientCertificateId != nil {
		v := *s.ClientCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExpirationDate != nil {
		v := *s.ExpirationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "expirationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.PemEncodedCertificate != nil {
		v := *s.PemEncodedCertificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pemEncodedCertificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// An immutable representation of a RestApi resource that can be called by users
// using Stages. A deployment must be associated with a Stage for it to be callable
// over the Internet.
//
// To create a deployment, call POST on the Deployments resource of a RestApi.
// To view, update, or delete a deployment, call GET, PATCH, or DELETE on the
// specified deployment resource (/restapis/{restapi_id}/deployments/{deployment_id}).
//
// RestApi, Deployments, Stage, AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html),
// AWS SDKs (https://aws.amazon.com/tools/)
type Deployment struct {
	_ struct{} `type:"structure"`

	// A summary of the RestApi at the date and time that the deployment resource
	// was created.
	ApiSummary map[string]map[string]MethodSnapshot `locationName:"apiSummary" type:"map"`

	// The date and time that the deployment resource was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// The description for the deployment resource.
	Description *string `locationName:"description" type:"string"`

	// The identifier for the deployment resource.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Deployment) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiSummary != nil {
		v := s.ApiSummary

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "apiSummary", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms1 := ms0.Map(k1)
			ms1.Start()
			for k2, v2 := range v1 {
				ms1.MapSetFields(k2, v2)
			}
			ms1.End()
		}
		ms0.End()

	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The input configuration for a canary deployment.
type DeploymentCanarySettings struct {
	_ struct{} `type:"structure"`

	// The percentage (0.0-100.0) of traffic routed to the canary deployment.
	PercentTraffic *float64 `locationName:"percentTraffic" type:"double"`

	// A stage variable overrides used for the canary release deployment. They can
	// override existing stage variables or add new stage variables for the canary
	// release deployment. These stage variables are represented as a string-to-string
	// map between stage variable names and their values.
	StageVariableOverrides map[string]string `locationName:"stageVariableOverrides" type:"map"`

	// A Boolean flag to indicate whether the canary release deployment uses the
	// stage cache or not.
	UseStageCache *bool `locationName:"useStageCache" type:"boolean"`
}

// String returns the string representation
func (s DeploymentCanarySettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeploymentCanarySettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.PercentTraffic != nil {
		v := *s.PercentTraffic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "percentTraffic", protocol.Float64Value(v), metadata)
	}
	if s.StageVariableOverrides != nil {
		v := s.StageVariableOverrides

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "stageVariableOverrides", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UseStageCache != nil {
		v := *s.UseStageCache

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "useStageCache", protocol.BoolValue(v), metadata)
	}
	return nil
}

// A documentation part for a targeted API entity.
//
// A documentation part consists of a content map (properties) and a target
// (location). The target specifies an API entity to which the documentation
// content applies. The supported API entity types are API, AUTHORIZER, MODEL,
// RESOURCE, METHOD, PATH_PARAMETER, QUERY_PARAMETER, REQUEST_HEADER, REQUEST_BODY,
// RESPONSE, RESPONSE_HEADER, and RESPONSE_BODY. Valid location fields depend
// on the API entity type. All valid fields are not required.
//
// The content map is a JSON string of API-specific key-value pairs. Although
// an API can use any shape for the content map, only the OpenAPI-compliant
// documentation fields will be injected into the associated API entity definition
// in the exported OpenAPI definition file.
//
// Documenting an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html),
// DocumentationParts
type DocumentationPart struct {
	_ struct{} `type:"structure"`

	// The DocumentationPart identifier, generated by API Gateway when the DocumentationPart
	// is created.
	Id *string `locationName:"id" type:"string"`

	// The location of the API entity to which the documentation applies. Valid
	// fields depend on the targeted API entity type. All the valid location fields
	// are not required. If not explicitly specified, a valid location field is
	// treated as a wildcard and associated documentation content may be inherited
	// by matching entities, unless overridden.
	Location *DocumentationPartLocation `locationName:"location" type:"structure"`

	// A content map of API-specific key-value pairs describing the targeted API
	// entity. The map must be encoded as a JSON string, e.g., "{ \"description\":
	// \"The API does ...\" }". Only OpenAPI-compliant documentation-related fields
	// from the properties map are exported and, hence, published as part of the
	// API entity definitions, while the original documentation parts are exported
	// in a OpenAPI extension of x-amazon-apigateway-documentation.
	Properties *string `locationName:"properties" type:"string"`
}

// String returns the string representation
func (s DocumentationPart) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DocumentationPart) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "location", v, metadata)
	}
	if s.Properties != nil {
		v := *s.Properties

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "properties", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the target API entity to which the documentation applies.
type DocumentationPartLocation struct {
	_ struct{} `type:"structure"`

	// The HTTP verb of a method. It is a valid field for the API entity types of
	// METHOD, PATH_PARAMETER, QUERY_PARAMETER, REQUEST_HEADER, REQUEST_BODY, RESPONSE,
	// RESPONSE_HEADER, and RESPONSE_BODY. The default value is * for any method.
	// When an applicable child entity inherits the content of an entity of the
	// same type with more general specifications of the other location attributes,
	// the child entity's method attribute must match that of the parent entity
	// exactly.
	Method *string `locationName:"method" type:"string"`

	// The name of the targeted API entity. It is a valid and required field for
	// the API entity types of AUTHORIZER, MODEL, PATH_PARAMETER, QUERY_PARAMETER,
	// REQUEST_HEADER, REQUEST_BODY and RESPONSE_HEADER. It is an invalid field
	// for any other entity type.
	Name *string `locationName:"name" type:"string"`

	// The URL path of the target. It is a valid field for the API entity types
	// of RESOURCE, METHOD, PATH_PARAMETER, QUERY_PARAMETER, REQUEST_HEADER, REQUEST_BODY,
	// RESPONSE, RESPONSE_HEADER, and RESPONSE_BODY. The default value is / for
	// the root resource. When an applicable child entity inherits the content of
	// another entity of the same type with more general specifications of the other
	// location attributes, the child entity's path attribute must match that of
	// the parent entity as a prefix.
	Path *string `locationName:"path" type:"string"`

	// The HTTP status code of a response. It is a valid field for the API entity
	// types of RESPONSE, RESPONSE_HEADER, and RESPONSE_BODY. The default value
	// is * for any status code. When an applicable child entity inherits the content
	// of an entity of the same type with more general specifications of the other
	// location attributes, the child entity's statusCode attribute must match that
	// of the parent entity exactly.
	StatusCode *string `locationName:"statusCode" type:"string"`

	// [Required] The type of API entity to which the documentation content applies.
	// Valid values are API, AUTHORIZER, MODEL, RESOURCE, METHOD, PATH_PARAMETER,
	// QUERY_PARAMETER, REQUEST_HEADER, REQUEST_BODY, RESPONSE, RESPONSE_HEADER,
	// and RESPONSE_BODY. Content inheritance does not apply to any entity of the
	// API, AUTHORIZER, METHOD, MODEL, REQUEST_BODY, or RESOURCE type.
	//
	// Type is a required field
	Type DocumentationPartType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DocumentationPartLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentationPartLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentationPartLocation"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DocumentationPartLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Method != nil {
		v := *s.Method

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "method", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statusCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A snapshot of the documentation of an API.
//
// Publishing API documentation involves creating a documentation version associated
// with an API stage and exporting the versioned documentation to an external
// (e.g., OpenAPI) file.
//
// Documenting an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html),
// DocumentationPart, DocumentationVersions
type DocumentationVersion struct {
	_ struct{} `type:"structure"`

	// The date when the API documentation snapshot is created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// The description of the API documentation snapshot.
	Description *string `locationName:"description" type:"string"`

	// The version identifier of the API documentation snapshot.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s DocumentationVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DocumentationVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a custom domain name as a user-friendly host name of an API (RestApi).
//
// When you deploy an API, API Gateway creates a default host name for the API.
// This default API host name is of the {restapi-id}.execute-api.{region}.amazonaws.com
// format. With the default host name, you can access the API's root resource
// with the URL of https://{restapi-id}.execute-api.{region}.amazonaws.com/{stage}/.
// When you set up a custom domain name of apis.example.com for this API, you
// can then access the same resource using the URL of the https://apis.examples.com/myApi,
// where myApi is the base path mapping (BasePathMapping) of your API under
// the custom domain name.
//
// Set a Custom Host Name for an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html)
type DomainName struct {
	_ struct{} `type:"structure"`

	// The reference to an AWS-managed certificate that will be used by edge-optimized
	// endpoint for this domain name. AWS Certificate Manager is the only supported
	// source.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The name of the certificate that will be used by edge-optimized endpoint
	// for this domain name.
	CertificateName *string `locationName:"certificateName" type:"string"`

	// The timestamp when the certificate that was used by edge-optimized endpoint
	// for this domain name was uploaded.
	CertificateUploadDate *time.Time `locationName:"certificateUploadDate" type:"timestamp"`

	// The domain name of the Amazon CloudFront distribution associated with this
	// custom domain name for an edge-optimized endpoint. You set up this association
	// when adding a DNS record pointing the custom domain name to this distribution
	// name. For more information about CloudFront distributions, see the Amazon
	// CloudFront documentation (https://aws.amazon.com/documentation/cloudfront/).
	DistributionDomainName *string `locationName:"distributionDomainName" type:"string"`

	// The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized
	// endpoint. The valid value is Z2FDTNDATAQYW2 for all the regions. For more
	// information, see Set up a Regional Custom Domain Name (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html)
	// and AWS Regions and Endpoints for API Gateway (https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region).
	DistributionHostedZoneId *string `locationName:"distributionHostedZoneId" type:"string"`

	// The custom domain name as an API host name, for example, my-api.example.com.
	DomainName *string `locationName:"domainName" type:"string"`

	// The status of the DomainName migration. The valid values are AVAILABLE and
	// UPDATING. If the status is UPDATING, the domain cannot be modified further
	// until the existing operation is complete. If it is AVAILABLE, the domain
	// can be updated.
	DomainNameStatus DomainNameStatus `locationName:"domainNameStatus" type:"string" enum:"true"`

	// An optional text message containing detailed information about status of
	// the DomainName migration.
	DomainNameStatusMessage *string `locationName:"domainNameStatusMessage" type:"string"`

	// The endpoint configuration of this DomainName showing the endpoint types
	// of the domain name.
	EndpointConfiguration *EndpointConfiguration `locationName:"endpointConfiguration" type:"structure"`

	// The reference to an AWS-managed certificate that will be used for validating
	// the regional domain name. AWS Certificate Manager is the only supported source.
	RegionalCertificateArn *string `locationName:"regionalCertificateArn" type:"string"`

	// The name of the certificate that will be used for validating the regional
	// domain name.
	RegionalCertificateName *string `locationName:"regionalCertificateName" type:"string"`

	// The domain name associated with the regional endpoint for this custom domain
	// name. You set up this association by adding a DNS record that points the
	// custom domain name to this regional domain name. The regional domain name
	// is returned by API Gateway when you create a regional endpoint.
	RegionalDomainName *string `locationName:"regionalDomainName" type:"string"`

	// The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
	// For more information, see Set up a Regional Custom Domain Name (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html)
	// and AWS Regions and Endpoints for API Gateway (https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region).
	RegionalHostedZoneId *string `locationName:"regionalHostedZoneId" type:"string"`

	// The Transport Layer Security (TLS) version + cipher suite for this DomainName.
	// The valid values are TLS_1_0 and TLS_1_2.
	SecurityPolicy SecurityPolicy `locationName:"securityPolicy" type:"string" enum:"true"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DomainName) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainName) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateName != nil {
		v := *s.CertificateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateUploadDate != nil {
		v := *s.CertificateUploadDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateUploadDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DistributionDomainName != nil {
		v := *s.DistributionDomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "distributionDomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DistributionHostedZoneId != nil {
		v := *s.DistributionHostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "distributionHostedZoneId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DomainNameStatus) > 0 {
		v := s.DomainNameStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainNameStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DomainNameStatusMessage != nil {
		v := *s.DomainNameStatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainNameStatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointConfiguration != nil {
		v := s.EndpointConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "endpointConfiguration", v, metadata)
	}
	if s.RegionalCertificateArn != nil {
		v := *s.RegionalCertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "regionalCertificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RegionalCertificateName != nil {
		v := *s.RegionalCertificateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "regionalCertificateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RegionalDomainName != nil {
		v := *s.RegionalDomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "regionalDomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RegionalHostedZoneId != nil {
		v := *s.RegionalHostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "regionalHostedZoneId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SecurityPolicy) > 0 {
		v := s.SecurityPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "securityPolicy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// The endpoint configuration to indicate the types of endpoints an API (RestApi)
// or its custom domain name (DomainName) has.
type EndpointConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of endpoint types of an API (RestApi) or its custom domain name (DomainName).
	// For an edge-optimized API and its custom domain name, the endpoint type is
	// "EDGE". For a regional API and its custom domain name, the endpoint type
	// is REGIONAL. For a private API, the endpoint type is PRIVATE.
	Types []EndpointType `locationName:"types" type:"list"`

	// A list of VpcEndpointIds of an API (RestApi) against which to create Route53
	// ALIASes. It is only supported for PRIVATE endpoint type.
	VpcEndpointIds []string `locationName:"vpcEndpointIds" type:"list"`
}

// String returns the string representation
func (s EndpointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EndpointConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Types != nil {
		v := s.Types

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "types", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VpcEndpointIds != nil {
		v := s.VpcEndpointIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "vpcEndpointIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// A gateway response of a given response type and status code, with optional
// response parameters and mapping templates.
//
// For more information about valid gateway response types, see Gateway Response
// Types Supported by API Gateway (https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html)
//
// Example: Get a Gateway Response of a given response type
//
// Request
//
// This example shows how to get a gateway response of the MISSING_AUTHENTICATION_TOKEN
// type.
//  GET /restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN HTTP/1.1
//  Host: beta-apigateway.us-east-1.amazonaws.com Content-Type: application/json
//  X-Amz-Date: 20170503T202516Z Authorization: AWS4-HMAC-SHA256 Credential={access-key-id}/20170503/us-east-1/apigateway/aws4_request,
//  SignedHeaders=content-type;host;x-amz-date, Signature=1b52460e3159c1a26cff29093855d50ea141c1c5b937528fecaf60f51129697a
//  Cache-Control: no-cache Postman-Token: 3b2a1ce9-c848-2e26-2e2f-9c2caefbed45
// The response type is specified as a URL path.
//
// Response
//
// The successful operation returns the 200 OK status code and a payload similar
// to the following:
//  { "_links": { "curies": { "href": "http://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-gatewayresponse-{rel}.html",
//  "name": "gatewayresponse", "templated": true }, "self": { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
//  }, "gatewayresponse:delete": { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
//  }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
//  "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
//  } }, "defaultResponse": false, "responseParameters": { "gatewayresponse.header.x-request-path":
//  "method.request.path.petId", "gatewayresponse.header.Access-Control-Allow-Origin":
//  "'a.b.c'", "gatewayresponse.header.x-request-query": "method.request.querystring.q",
//  "gatewayresponse.header.x-request-header": "method.request.header.Accept"
//  }, "responseTemplates": { "application/json": "{\n \"message\": $context.error.messageString,\n
//  \"type\": \"$context.error.responseType\",\n \"stage\": \"$context.stage\",\n
//  \"resourcePath\": \"$context.resourcePath\",\n \"stageVariables.a\": \"$stageVariables.a\",\n
//  \"statusCode\": \"'404'\"\n}" }, "responseType": "MISSING_AUTHENTICATION_TOKEN",
//  "statusCode": "404" }
//
// Customize Gateway Responses (https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html)
type GatewayResponse struct {
	_ struct{} `type:"structure"`

	// A Boolean flag to indicate whether this GatewayResponse is the default gateway
	// response (true) or not (false). A default gateway response is one generated
	// by API Gateway without any customization by an API developer.
	DefaultResponse *bool `locationName:"defaultResponse" type:"boolean"`

	// Response parameters (paths, query strings and headers) of the GatewayResponse
	// as a string-to-string map of key-value pairs.
	ResponseParameters map[string]string `locationName:"responseParameters" type:"map"`

	// Response templates of the GatewayResponse as a string-to-string map of key-value
	// pairs.
	ResponseTemplates map[string]string `locationName:"responseTemplates" type:"map"`

	// The response type of the associated GatewayResponse. Valid values are
	//    * ACCESS_DENIED
	//
	//    * API_CONFIGURATION_ERROR
	//
	//    * AUTHORIZER_FAILURE
	//
	//    * AUTHORIZER_CONFIGURATION_ERROR
	//
	//    * BAD_REQUEST_PARAMETERS
	//
	//    * BAD_REQUEST_BODY
	//
	//    * DEFAULT_4XX
	//
	//    * DEFAULT_5XX
	//
	//    * EXPIRED_TOKEN
	//
	//    * INVALID_SIGNATURE
	//
	//    * INTEGRATION_FAILURE
	//
	//    * INTEGRATION_TIMEOUT
	//
	//    * INVALID_API_KEY
	//
	//    * MISSING_AUTHENTICATION_TOKEN
	//
	//    * QUOTA_EXCEEDED
	//
	//    * REQUEST_TOO_LARGE
	//
	//    * RESOURCE_NOT_FOUND
	//
	//    * THROTTLED
	//
	//    * UNAUTHORIZED
	//
	//    * UNSUPPORTED_MEDIA_TYPE
	ResponseType GatewayResponseType `locationName:"responseType" type:"string" enum:"true"`

	// The HTTP status code for this GatewayResponse.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s GatewayResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GatewayResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefaultResponse != nil {
		v := *s.DefaultResponse

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "defaultResponse", protocol.BoolValue(v), metadata)
	}
	if s.ResponseParameters != nil {
		v := s.ResponseParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ResponseTemplates != nil {
		v := s.ResponseTemplates

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseTemplates", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.ResponseType) > 0 {
		v := s.ResponseType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "responseType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statusCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents an HTTP, HTTP_PROXY, AWS, AWS_PROXY, or Mock integration.
//
// In the API Gateway console, the built-in Lambda integration is an AWS integration.
//
// Creating an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
type Integration struct {
	_ struct{} `type:"structure"`

	// A list of request parameters whose values API Gateway caches. To be valid
	// values for cacheKeyParameters, these parameters must also be specified for
	// Method requestParameters.
	CacheKeyParameters []string `locationName:"cacheKeyParameters" type:"list"`

	// An API-specific tag group of related cached parameters. To be valid values
	// for cacheKeyParameters, these parameters must also be specified for Method
	// requestParameters.
	CacheNamespace *string `locationName:"cacheNamespace" type:"string"`

	// The (id (https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id))
	// of the VpcLink used for the integration when connectionType=VPC_LINK and
	// undefined, otherwise.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The type of the network connection to the integration endpoint. The valid
	// value is INTERNET for connections through the public routable internet or
	// VPC_LINK for private connections between API Gateway and a network load balancer
	// in a VPC. The default value is INTERNET.
	ConnectionType ConnectionType `locationName:"connectionType" type:"string" enum:"true"`

	// Specifies how to handle request payload content type conversions. Supported
	// values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
	//
	//    * CONVERT_TO_BINARY: Converts a request payload from a Base64-encoded
	//    string to the corresponding binary blob.
	//
	//    * CONVERT_TO_TEXT: Converts a request payload from a binary blob to a
	//    Base64-encoded string.
	//
	// If this property is not defined, the request payload will be passed through
	// from the method request to integration request without modification, provided
	// that the passthroughBehavior is configured to support payload pass-through.
	ContentHandling ContentHandlingStrategy `locationName:"contentHandling" type:"string" enum:"true"`

	// Specifies the credentials required for the integration, if any. For AWS integrations,
	// three options are available. To specify an IAM Role for API Gateway to assume,
	// use the role's Amazon Resource Name (ARN). To require that the caller's identity
	// be passed through from the request, specify the string arn:aws:iam::\*:user/\*.
	// To use resource-based permissions on supported AWS services, specify null.
	Credentials *string `locationName:"credentials" type:"string"`

	// Specifies the integration's HTTP method type.
	HttpMethod *string `locationName:"httpMethod" type:"string"`

	// Specifies the integration's responses.
	//
	// Example: Get integration responses of a method
	//
	// Request
	//   GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200
	//   HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com
	//   X-Amz-Date: 20160607T191449Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request,
	//   SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
	// Response
	//
	// The successful response returns 200 OK status and a payload as follows:
	//  { "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
	//  "name": "integrationresponse", "templated": true }, "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
	//  "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
	//  }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
	//  } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'"
	//  }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream
	//  in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
	//  }, "statusCode": "200" }
	//
	// Creating an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
	IntegrationResponses map[string]IntegrationResponse `locationName:"integrationResponses" type:"map"`

	// Specifies how the method request body of an unmapped content type will be
	// passed through the integration request to the back end without transformation.
	// A content type is unmapped if no mapping template is defined in the integration
	// or the content type does not match any of the mapped content types, as specified
	// in requestTemplates. The valid value is one of the following:
	//
	//    * WHEN_NO_MATCH: passes the method request body through the integration
	//    request to the back end without transformation when the method request
	//    content type does not match any content type associated with the mapping
	//    templates defined in the integration request.
	//
	//    * WHEN_NO_TEMPLATES: passes the method request body through the integration
	//    request to the back end without transformation when no mapping template
	//    is defined in the integration request. If a template is defined when this
	//    option is selected, the method request of an unmapped content-type will
	//    be rejected with an HTTP 415 Unsupported Media Type response.
	//
	//    * NEVER: rejects the method request with an HTTP 415 Unsupported Media
	//    Type response when either the method request content type does not match
	//    any content type associated with the mapping templates defined in the
	//    integration request or no mapping template is defined in the integration
	//    request.
	PassthroughBehavior *string `locationName:"passthroughBehavior" type:"string"`

	// A key-value map specifying request parameters that are passed from the method
	// request to the back end. The key is an integration request parameter name
	// and the associated value is a method request parameter value or static value
	// that must be enclosed within single quotes and pre-encoded as required by
	// the back end. The method request parameter value must match the pattern of
	// method.request.{location}.{name}, where location is querystring, path, or
	// header and name must be a valid and unique method request parameter name.
	RequestParameters map[string]string `locationName:"requestParameters" type:"map"`

	// Represents a map of Velocity templates that are applied on the request payload
	// based on the value of the Content-Type header sent by the client. The content
	// type value is the key in this map, and the template (as a String) is the
	// value.
	RequestTemplates map[string]string `locationName:"requestTemplates" type:"map"`

	// Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000
	// milliseconds or 29 seconds.
	TimeoutInMillis *int64 `locationName:"timeoutInMillis" type:"integer"`

	// Specifies an API method integration type. The valid value is one of the following:
	//
	//    * AWS: for integrating the API method request with an AWS service action,
	//    including the Lambda function-invoking action. With the Lambda function-invoking
	//    action, this is referred to as the Lambda custom integration. With any
	//    other AWS service action, this is known as AWS integration.
	//
	//    * AWS_PROXY: for integrating the API method request with the Lambda function-invoking
	//    action with the client request passed through as-is. This integration
	//    is also referred to as the Lambda proxy integration.
	//
	//    * HTTP: for integrating the API method request with an HTTP endpoint,
	//    including a private HTTP endpoint within a VPC. This integration is also
	//    referred to as the HTTP custom integration.
	//
	//    * HTTP_PROXY: for integrating the API method request with an HTTP endpoint,
	//    including a private HTTP endpoint within a VPC, with the client request
	//    passed through as-is. This is also referred to as the HTTP proxy integration.
	//
	//    * MOCK: for integrating the API method request with API Gateway as a "loop-back"
	//    endpoint without invoking any backend.
	//
	// For the HTTP and HTTP proxy integrations, each integration can specify a
	// protocol (http/https), port and path. Standard 80 and 443 ports are supported
	// as well as custom ports above 1024. An HTTP or HTTP proxy integration with
	// a connectionType of VPC_LINK is referred to as a private integration and
	// uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
	Type IntegrationType `locationName:"type" type:"string" enum:"true"`

	// Specifies Uniform Resource Identifier (URI) of the integration endpoint.
	//
	//    * For HTTP or HTTP_PROXY integrations, the URI must be a fully formed,
	//    encoded HTTP(S) URL according to the RFC-3986 specification (https://en.wikipedia.org/wiki/Uniform_Resource_Identifier),
	//    for either standard integration, where connectionType is not VPC_LINK,
	//    or private integration, where connectionType is VPC_LINK. For a private
	//    HTTP integration, the URI is not used for routing.
	//
	//    * For AWS or AWS_PROXY integrations, the URI is of the form arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}.
	//    Here, {Region} is the API Gateway region (e.g., us-east-1); {service}
	//    is the name of the integrated AWS service (e.g., s3); and {subdomain}
	//    is a designated subdomain supported by certain AWS service for fast host-name
	//    lookup. action can be used for an AWS service action-based API, using
	//    an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api}
	//    refers to a supported action {name} plus any required input parameters.
	//    Alternatively, path can be used for an AWS service path-based API. The
	//    ensuing service_api refers to the path to an AWS service resource, including
	//    the region of the integrated AWS service, if applicable. For example,
	//    for integration with the S3 API of GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html),
	//    the uri can be either arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}
	//    or arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
	Uri *string `locationName:"uri" type:"string"`
}

// String returns the string representation
func (s Integration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Integration) MarshalFields(e protocol.FieldEncoder) error {
	if s.CacheKeyParameters != nil {
		v := s.CacheKeyParameters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "cacheKeyParameters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.CacheNamespace != nil {
		v := *s.CacheNamespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cacheNamespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConnectionId != nil {
		v := *s.ConnectionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ConnectionType) > 0 {
		v := s.ConnectionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ContentHandling) > 0 {
		v := s.ContentHandling

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentHandling", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Credentials != nil {
		v := *s.Credentials

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "credentials", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HttpMethod != nil {
		v := *s.HttpMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "httpMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationResponses != nil {
		v := s.IntegrationResponses

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "integrationResponses", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.PassthroughBehavior != nil {
		v := *s.PassthroughBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "passthroughBehavior", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestParameters != nil {
		v := s.RequestParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "requestParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RequestTemplates != nil {
		v := s.RequestTemplates

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "requestTemplates", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TimeoutInMillis != nil {
		v := *s.TimeoutInMillis

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timeoutInMillis", protocol.Int64Value(v), metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Uri != nil {
		v := *s.Uri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "uri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents an integration response. The status code must map to an existing
// MethodResponse, and parameters and templates can be used to transform the
// back-end response.
//
// Creating an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
type IntegrationResponse struct {
	_ struct{} `type:"structure"`

	// Specifies how to handle response payload content type conversions. Supported
	// values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
	//
	//    * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded
	//    string to the corresponding binary blob.
	//
	//    * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a
	//    Base64-encoded string.
	//
	// If this property is not defined, the response payload will be passed through
	// from the integration response to the method response without modification.
	ContentHandling ContentHandlingStrategy `locationName:"contentHandling" type:"string" enum:"true"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the back end. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	ResponseParameters map[string]string `locationName:"responseParameters" type:"map"`

	// Specifies the templates used to transform the integration response body.
	// Response templates are represented as a key/value map, with a content-type
	// as the key and a template as the value.
	ResponseTemplates map[string]string `locationName:"responseTemplates" type:"map"`

	// Specifies the regular expression (regex) pattern used to choose an integration
	// response based on the response from the back end. For example, if the success
	// response returns nothing and the error response returns some string, you
	// could use the .+ regex to match error response. However, make sure that the
	// error response does not contain any newline (\n) character in such cases.
	// If the back end is an AWS Lambda function, the AWS Lambda function error
	// header is matched. For all other HTTP and AWS back ends, the HTTP status
	// code is matched.
	SelectionPattern *string `locationName:"selectionPattern" type:"string"`

	// Specifies the status code that is used to map the integration response to
	// an existing MethodResponse.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s IntegrationResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IntegrationResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ContentHandling) > 0 {
		v := s.ContentHandling

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentHandling", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ResponseParameters != nil {
		v := s.ResponseParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ResponseTemplates != nil {
		v := s.ResponseTemplates

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseTemplates", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.SelectionPattern != nil {
		v := *s.SelectionPattern

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "selectionPattern", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statusCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a client-facing interface by which the client calls the API to
// access back-end resources. A Method resource is integrated with an Integration
// resource. Both consist of a request and one or more responses. The method
// request takes the client input that is passed to the back end through the
// integration request. A method response returns the output from the back end
// to the client through an integration response. A method request is embodied
// in a Method resource, whereas an integration request is embodied in an Integration
// resource. On the other hand, a method response is represented by a MethodResponse
// resource, whereas an integration response is represented by an IntegrationResponse
// resource.
//
// Example: Retrive the GET method on a specified resource
//
// Request
//
// The following example request retrieves the information about the GET method
// on an API resource (3kzxbg5sa2) of an API (fugvjdxtri).
//  GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1 Content-Type:
//  application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160603T210259Z
//  Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request,
//  SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
// Response
//
// The successful response returns a 200 OK status code and a payload similar
// to the following:
//  { "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
//  "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
//  "name": "integrationresponse", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
//  "name": "method", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
//  "name": "methodresponse", "templated": true } ], "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
//  "name": "GET", "title": "GET" }, "integration:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
//  }, "method:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
//  }, "method:integration": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
//  }, "method:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
//  "name": "200", "title": "200" }, "method:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
//  }, "methodresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
//  "templated": true } }, "apiKeyRequired": true, "authorizationType": "NONE",
//  "httpMethod": "GET", "_embedded": { "method:integration": { "_links": {
//  "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
//  }, "integration:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
//  }, "integration:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
//  "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
//  }, "integrationresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
//  "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "3kzxbg5sa2",
//  "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod":
//  "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestParameters": { "integration.request.header.Content-Type":
//  "'application/x-amz-json-1.1'" }, "requestTemplates": { "application/json":
//  "{\n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
//  "_embedded": { "integration:responses": { "_links": { "self": { "href":
//  "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
//  "name": "200", "title": "200" }, "integrationresponse:delete": { "href":
//  "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
//  }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
//  } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'"
//  }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E\")"
//  }, "statusCode": "200" } } }, "method:responses": { "_links": { "self":
//  { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
//  "name": "200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
//  }, "methodresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
//  } }, "responseModels": { "application/json": "Empty" }, "responseParameters":
//  { "method.response.header.Content-Type": false }, "statusCode": "200" }
//  } }
// In the example above, the response template for the 200 OK response maps
// the JSON output from the ListStreams action in the back end to an XML output.
// The mapping template is URL-encoded as %3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E
// and the output is decoded using the $util.urlDecode() (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#util-templat-reference)
// helper function.
//
// MethodResponse, Integration, IntegrationResponse, Resource, Set up an API's
// method (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-method-settings.html)
type Method struct {
	_ struct{} `type:"structure"`

	// A boolean flag specifying whether a valid ApiKey is required to invoke this
	// method.
	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// A list of authorization scopes configured on the method. The scopes are used
	// with a COGNITO_USER_POOLS authorizer to authorize the method invocation.
	// The authorization works by matching the method scopes against the scopes
	// parsed from the access token in the incoming request. The method invocation
	// is authorized if any method scopes matches a claimed scope in the access
	// token. Otherwise, the invocation is not authorized. When the method scope
	// is configured, the client must provide an access token instead of an identity
	// token for authorization purposes.
	AuthorizationScopes []string `locationName:"authorizationScopes" type:"list"`

	// The method's authorization type. Valid values are NONE for open access, AWS_IAM
	// for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS
	// for using a Cognito user pool.
	AuthorizationType *string `locationName:"authorizationType" type:"string"`

	// The identifier of an Authorizer to use on this method. The authorizationType
	// must be CUSTOM.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// The method's HTTP verb.
	HttpMethod *string `locationName:"httpMethod" type:"string"`

	// Gets the method's integration responsible for passing the client-submitted
	// request to the back end and performing necessary transformations to make
	// the request compliant with the back end.
	//
	// Example:
	//
	// Request
	//   GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
	//   Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com
	//   Content-Length: 117 X-Amz-Date: 20160613T213210Z Authorization: AWS4-HMAC-SHA256
	//   Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request,
	//   SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
	// Response
	//
	// The successful response returns a 200 OK status code and a payload similar
	// to the following:
	//  { "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
	//  "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
	//  "name": "integrationresponse", "templated": true } ], "self": { "href":
	//  "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integration:delete":
	//  { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
	//  }, "integration:responses": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
	//  "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
	//  }, "integrationresponse:put": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
	//  "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "0cjtch",
	//  "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod":
	//  "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestTemplates": { "application/json":
	//  "{\n \"a\": \"$input.params('operand1')\",\n \"b\": \"$input.params('operand2')\",
	//  \n \"op\": \"$input.params('operator')\" \n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
	//  "_embedded": { "integration:responses": { "_links": { "self": { "href":
	//  "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
	//  "name": "200", "title": "200" }, "integrationresponse:delete": { "href":
	//  "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
	//  }, "integrationresponse:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
	//  } }, "responseParameters": { "method.response.header.operator": "integration.response.body.op",
	//  "method.response.header.operand_2": "integration.response.body.b", "method.response.header.operand_1":
	//  "integration.response.body.a" }, "responseTemplates": { "application/json":
	//  "#set($res = $input.path('$'))\n{\n \"result\": \"$res.a, $res.b, $res.op
	//  => $res.c\",\n \"a\" : \"$res.a\",\n \"b\" : \"$res.b\",\n \"op\" : \"$res.op\",\n
	//  \"c\" : \"$res.c\"\n}" }, "selectionPattern": "", "statusCode": "200" }
	//  } }
	//
	// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html)
	MethodIntegration *Integration `locationName:"methodIntegration" type:"structure"`

	// Gets a method response associated with a given HTTP status code.
	//
	// The collection of method responses are encapsulated in a key-value map, where
	// the key is a response's HTTP status code and the value is a MethodResponse
	// resource that specifies the response returned to the caller from the back
	// end through the integration response.
	//
	// Example: Get a 200 OK response of a GET method
	//
	// Request
	//   GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
	//   Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com
	//   Content-Length: 117 X-Amz-Date: 20160613T215008Z Authorization: AWS4-HMAC-SHA256
	//   Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request,
	//   SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
	// Response
	//
	// The successful response returns a 200 OK status code and a payload similar
	// to the following:
	//  { "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
	//  "name": "methodresponse", "templated": true }, "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
	//  "title": "200" }, "methodresponse:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
	//  }, "methodresponse:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
	//  } }, "responseModels": { "application/json": "Empty" }, "responseParameters":
	//  { "method.response.header.operator": false, "method.response.header.operand_2":
	//  false, "method.response.header.operand_1": false }, "statusCode": "200"
	//  }
	//
	// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html)
	MethodResponses map[string]MethodResponse `locationName:"methodResponses" type:"map"`

	// A human-friendly operation identifier for the method. For example, you can
	// assign the operationName of ListPets for the GET /pets method in the PetStore
	// example.
	OperationName *string `locationName:"operationName" type:"string"`

	// A key-value map specifying data schemas, represented by Model resources,
	// (as the mapped value) of the request payloads of given content types (as
	// the mapping key).
	RequestModels map[string]string `locationName:"requestModels" type:"map"`

	// A key-value map defining required or optional method request parameters that
	// can be accepted by API Gateway. A key is a method request parameter name
	// matching the pattern of method.request.{location}.{name}, where location
	// is querystring, path, or header and name is a valid and unique parameter
	// name. The value associated with the key is a Boolean flag indicating whether
	// the parameter is required (true) or optional (false). The method request
	// parameter names defined here are available in Integration to be mapped to
	// integration request parameters or templates.
	RequestParameters map[string]bool `locationName:"requestParameters" type:"map"`

	// The identifier of a RequestValidator for request validation.
	RequestValidatorId *string `locationName:"requestValidatorId" type:"string"`
}

// String returns the string representation
func (s Method) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Method) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiKeyRequired != nil {
		v := *s.ApiKeyRequired

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiKeyRequired", protocol.BoolValue(v), metadata)
	}
	if s.AuthorizationScopes != nil {
		v := s.AuthorizationScopes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "authorizationScopes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.AuthorizationType != nil {
		v := *s.AuthorizationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizationType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthorizerId != nil {
		v := *s.AuthorizerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HttpMethod != nil {
		v := *s.HttpMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "httpMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MethodIntegration != nil {
		v := s.MethodIntegration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "methodIntegration", v, metadata)
	}
	if s.MethodResponses != nil {
		v := s.MethodResponses

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "methodResponses", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.OperationName != nil {
		v := *s.OperationName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "operationName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestModels != nil {
		v := s.RequestModels

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "requestModels", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RequestParameters != nil {
		v := s.RequestParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "requestParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.BoolValue(v1))
		}
		ms0.End()

	}
	if s.RequestValidatorId != nil {
		v := *s.RequestValidatorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestValidatorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a method response of a given HTTP status code returned to the
// client. The method response is passed from the back end through the associated
// integration response that can be transformed using a mapping template.
//
// Example: A MethodResponse instance of an API
//
// Request
//
// The example request retrieves a MethodResponse of the 200 status code.
//  GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200
//  HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com
//  X-Amz-Date: 20160603T222952Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request,
//  SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
// Response
//
// The successful response returns 200 OK status and a payload as follows:
//  { "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
//  "name": "methodresponse", "templated": true }, "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
//  "title": "200" }, "methodresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
//  }, "methodresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
//  } }, "responseModels": { "application/json": "Empty" }, "responseParameters":
//  { "method.response.header.Content-Type": false }, "statusCode": "200" }
//
// Method, IntegrationResponse, Integration Creating an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
type MethodResponse struct {
	_ struct{} `type:"structure"`

	// Specifies the Model resources used for the response's content-type. Response
	// models are represented as a key/value map, with a content-type as the key
	// and a Model name as the value.
	ResponseModels map[string]string `locationName:"responseModels" type:"map"`

	// A key-value map specifying required or optional response parameters that
	// API Gateway can send back to the caller. A key defines a method response
	// header and the value specifies whether the associated method response header
	// is required or not. The expression of the key must match the pattern method.response.header.{name},
	// where name is a valid and unique header name. API Gateway passes certain
	// integration response data to the method response headers specified here according
	// to the mapping you prescribe in the API's IntegrationResponse. The integration
	// response data that can be mapped include an integration response header expressed
	// in integration.response.header.{name}, a static value enclosed within a pair
	// of single quotes (e.g., 'application/json'), or a JSON expression from the
	// back-end response payload in the form of integration.response.body.{JSON-expression},
	// where JSON-expression is a valid JSON expression without the $ prefix.)
	ResponseParameters map[string]bool `locationName:"responseParameters" type:"map"`

	// The method response's status code.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s MethodResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MethodResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ResponseModels != nil {
		v := s.ResponseModels

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseModels", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ResponseParameters != nil {
		v := s.ResponseParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.BoolValue(v1))
		}
		ms0.End()

	}
	if s.StatusCode != nil {
		v := *s.StatusCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statusCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Specifies the method setting properties.
type MethodSetting struct {
	_ struct{} `type:"structure"`

	// Specifies whether the cached responses are encrypted. The PATCH path for
	// this setting is /{method_setting_key}/caching/dataEncrypted, and the value
	// is a Boolean.
	CacheDataEncrypted *bool `locationName:"cacheDataEncrypted" type:"boolean"`

	// Specifies the time to live (TTL), in seconds, for cached responses. The higher
	// the TTL, the longer the response will be cached. The PATCH path for this
	// setting is /{method_setting_key}/caching/ttlInSeconds, and the value is an
	// integer.
	CacheTtlInSeconds *int64 `locationName:"cacheTtlInSeconds" type:"integer"`

	// Specifies whether responses should be cached and returned for requests. A
	// cache cluster must be enabled on the stage for responses to be cached. The
	// PATCH path for this setting is /{method_setting_key}/caching/enabled, and
	// the value is a Boolean.
	CachingEnabled *bool `locationName:"cachingEnabled" type:"boolean"`

	// Specifies whether data trace logging is enabled for this method, which affects
	// the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this
	// setting is /{method_setting_key}/logging/dataTrace, and the value is a Boolean.
	DataTraceEnabled *bool `locationName:"dataTraceEnabled" type:"boolean"`

	// Specifies the logging level for this method, which affects the log entries
	// pushed to Amazon CloudWatch Logs. The PATCH path for this setting is /{method_setting_key}/logging/loglevel,
	// and the available levels are OFF, ERROR, and INFO.
	LoggingLevel *string `locationName:"loggingLevel" type:"string"`

	// Specifies whether Amazon CloudWatch metrics are enabled for this method.
	// The PATCH path for this setting is /{method_setting_key}/metrics/enabled,
	// and the value is a Boolean.
	MetricsEnabled *bool `locationName:"metricsEnabled" type:"boolean"`

	// Specifies whether authorization is required for a cache invalidation request.
	// The PATCH path for this setting is /{method_setting_key}/caching/requireAuthorizationForCacheControl,
	// and the value is a Boolean.
	RequireAuthorizationForCacheControl *bool `locationName:"requireAuthorizationForCacheControl" type:"boolean"`

	// Specifies the throttling burst limit. The PATCH path for this setting is
	// /{method_setting_key}/throttling/burstLimit, and the value is an integer.
	ThrottlingBurstLimit *int64 `locationName:"throttlingBurstLimit" type:"integer"`

	// Specifies the throttling rate limit. The PATCH path for this setting is /{method_setting_key}/throttling/rateLimit,
	// and the value is a double.
	ThrottlingRateLimit *float64 `locationName:"throttlingRateLimit" type:"double"`

	// Specifies how to handle unauthorized requests for cache invalidation. The
	// PATCH path for this setting is /{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy,
	// and the available values are FAIL_WITH_403, SUCCEED_WITH_RESPONSE_HEADER,
	// SUCCEED_WITHOUT_RESPONSE_HEADER.
	UnauthorizedCacheControlHeaderStrategy UnauthorizedCacheControlHeaderStrategy `locationName:"unauthorizedCacheControlHeaderStrategy" type:"string" enum:"true"`
}

// String returns the string representation
func (s MethodSetting) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MethodSetting) MarshalFields(e protocol.FieldEncoder) error {
	if s.CacheDataEncrypted != nil {
		v := *s.CacheDataEncrypted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cacheDataEncrypted", protocol.BoolValue(v), metadata)
	}
	if s.CacheTtlInSeconds != nil {
		v := *s.CacheTtlInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cacheTtlInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.CachingEnabled != nil {
		v := *s.CachingEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cachingEnabled", protocol.BoolValue(v), metadata)
	}
	if s.DataTraceEnabled != nil {
		v := *s.DataTraceEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataTraceEnabled", protocol.BoolValue(v), metadata)
	}
	if s.LoggingLevel != nil {
		v := *s.LoggingLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "loggingLevel", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MetricsEnabled != nil {
		v := *s.MetricsEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "metricsEnabled", protocol.BoolValue(v), metadata)
	}
	if s.RequireAuthorizationForCacheControl != nil {
		v := *s.RequireAuthorizationForCacheControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requireAuthorizationForCacheControl", protocol.BoolValue(v), metadata)
	}
	if s.ThrottlingBurstLimit != nil {
		v := *s.ThrottlingBurstLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "throttlingBurstLimit", protocol.Int64Value(v), metadata)
	}
	if s.ThrottlingRateLimit != nil {
		v := *s.ThrottlingRateLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "throttlingRateLimit", protocol.Float64Value(v), metadata)
	}
	if len(s.UnauthorizedCacheControlHeaderStrategy) > 0 {
		v := s.UnauthorizedCacheControlHeaderStrategy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unauthorizedCacheControlHeaderStrategy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Represents a summary of a Method resource, given a particular date and time.
type MethodSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies whether the method requires a valid ApiKey.
	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// The method's authorization type. Valid values are NONE for open access, AWS_IAM
	// for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS
	// for using a Cognito user pool.
	AuthorizationType *string `locationName:"authorizationType" type:"string"`
}

// String returns the string representation
func (s MethodSnapshot) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MethodSnapshot) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiKeyRequired != nil {
		v := *s.ApiKeyRequired

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiKeyRequired", protocol.BoolValue(v), metadata)
	}
	if s.AuthorizationType != nil {
		v := *s.AuthorizationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizationType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the data structure of a method's request or response payload.
//
// A request model defines the data structure of the client-supplied request
// payload. A response model defines the data structure of the response payload
// returned by the back end. Although not required, models are useful for mapping
// payloads between the front end and back end.
//
// A model is used for generating an API's SDK, validating the input request
// body, and creating a skeletal mapping template.
//
// Method, MethodResponse, Models and Mappings (https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html)
type Model struct {
	_ struct{} `type:"structure"`

	// The content-type for the model.
	ContentType *string `locationName:"contentType" type:"string"`

	// The description of the model.
	Description *string `locationName:"description" type:"string"`

	// The identifier for the model resource.
	Id *string `locationName:"id" type:"string"`

	// The name of the model. Must be an alphanumeric string.
	Name *string `locationName:"name" type:"string"`

	// The schema for the model. For application/json models, this should be JSON
	// schema draft 4 (https://tools.ietf.org/html/draft-zyp-json-schema-04) model.
	// Do not include "\*/" characters in the description of any properties because
	// such "\*/" characters may be interpreted as the closing marker for comments
	// in some languages, such as Java or JavaScript, causing the installation of
	// your API's SDK generated by API Gateway to fail.
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s Model) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Model) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schema != nil {
		v := *s.Schema

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schema", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A single patch operation to apply to the specified resource. Please refer
// to http://tools.ietf.org/html/rfc6902#section-4 for an explanation of how
// each operation is used.
type PatchOperation struct {
	_ struct{} `type:"structure"`

	// The copy update operation's source as identified by a JSON-Pointer value
	// referencing the location within the targeted resource to copy the value from.
	// For example, to promote a canary deployment, you copy the canary deployment
	// ID to the affiliated deployment ID by calling a PATCH request on a Stage
	// resource with "op":"copy", "from":"/canarySettings/deploymentId" and "path":"/deploymentId".
	From *string `locationName:"from" type:"string"`

	// An update operation to be performed with this PATCH request. The valid value
	// can be add, remove, replace or copy. Not all valid operations are supported
	// for a given resource. Support of the operations depends on specific operational
	// contexts. Attempts to apply an unsupported operation on a resource will return
	// an error message.
	Op Op `locationName:"op" type:"string" enum:"true"`

	// The op operation's target, as identified by a JSON Pointer (https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08)
	// value that references a location within the targeted resource. For example,
	// if the target resource has an updateable property of {"name":"value"}, the
	// path for this property is /name. If the name property value is a JSON object
	// (e.g., {"name": {"child/name": "child-value"}}), the path for the child/name
	// property will be /name/child~1name. Any slash ("/") character appearing in
	// path names must be escaped with "~1", as shown in the example above. Each
	// op operation can have only one path associated with it.
	Path *string `locationName:"path" type:"string"`

	// The new target value of the update operation. It is applicable for the add
	// or replace operation. When using AWS CLI to update a property of a JSON value,
	// enclose the JSON object with a pair of single quotes in a Linux shell, e.g.,
	// '{"a": ...}'. In a Windows shell, see Using JSON for Parameters (https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json).
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s PatchOperation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PatchOperation) MarshalFields(e protocol.FieldEncoder) error {
	if s.From != nil {
		v := *s.From

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "from", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Op) > 0 {
		v := s.Op

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "op", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Quotas configured for a usage plan.
type QuotaSettings struct {
	_ struct{} `type:"structure"`

	// The maximum number of requests that can be made in a given time period.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The number of requests subtracted from the given limit in the initial time
	// period.
	Offset *int64 `locationName:"offset" type:"integer"`

	// The time period in which the limit applies. Valid values are "DAY", "WEEK"
	// or "MONTH".
	Period QuotaPeriodType `locationName:"period" type:"string" enum:"true"`
}

// String returns the string representation
func (s QuotaSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QuotaSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if s.Offset != nil {
		v := *s.Offset

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "offset", protocol.Int64Value(v), metadata)
	}
	if len(s.Period) > 0 {
		v := s.Period

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "period", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A set of validation rules for incoming Method requests.
//
// In OpenAPI, a RequestValidator of an API is defined by the x-amazon-apigateway-request-validators.requestValidator
// (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.requestValidator.html)
// object. It the referenced using the x-amazon-apigateway-request-validator
// (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validator)
// property.
//
// Enable Basic Request Validation in API Gateway (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html)
type RequestValidator struct {
	_ struct{} `type:"structure"`

	// The identifier of this RequestValidator.
	Id *string `locationName:"id" type:"string"`

	// The name of this RequestValidator
	Name *string `locationName:"name" type:"string"`

	// A Boolean flag to indicate whether to validate a request body according to
	// the configured Model schema.
	ValidateRequestBody *bool `locationName:"validateRequestBody" type:"boolean"`

	// A Boolean flag to indicate whether to validate request parameters (true)
	// or not (false).
	ValidateRequestParameters *bool `locationName:"validateRequestParameters" type:"boolean"`
}

// String returns the string representation
func (s RequestValidator) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RequestValidator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ValidateRequestBody != nil {
		v := *s.ValidateRequestBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "validateRequestBody", protocol.BoolValue(v), metadata)
	}
	if s.ValidateRequestParameters != nil {
		v := *s.ValidateRequestParameters

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "validateRequestParameters", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Represents an API resource.
//
// Create an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
type Resource struct {
	_ struct{} `type:"structure"`

	// The resource's identifier.
	Id *string `locationName:"id" type:"string"`

	// The parent resource's identifier.
	ParentId *string `locationName:"parentId" type:"string"`

	// The full path for this resource.
	Path *string `locationName:"path" type:"string"`

	// The last path segment for this resource.
	PathPart *string `locationName:"pathPart" type:"string"`

	// Gets an API resource's method of a given HTTP verb.
	//
	// The resource methods are a map of methods indexed by methods' HTTP verbs
	// enabled on the resource. This method map is included in the 200 OK response
	// of the GET /restapis/{restapi_id}/resources/{resource_id} or GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods
	// request.
	//
	// Example: Get the GET method of an API resource
	//
	// Request
	//  GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1 Content-Type:
	//  application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20170223T031827Z
	//  Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request,
	//  SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
	// Response
	//  { "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
	//  "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
	//  "name": "integrationresponse", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
	//  "name": "method", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
	//  "name": "methodresponse", "templated": true } ], "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
	//  "name": "GET", "title": "GET" }, "integration:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
	//  }, "method:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
	//  }, "method:integration": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
	//  }, "method:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
	//  "name": "200", "title": "200" }, "method:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
	//  }, "methodresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
	//  "templated": true } }, "apiKeyRequired": false, "authorizationType": "NONE",
	//  "httpMethod": "GET", "_embedded": { "method:integration": { "_links": {
	//  "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
	//  }, "integration:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
	//  }, "integration:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
	//  "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
	//  }, "integrationresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
	//  "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "3kzxbg5sa2",
	//  "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod":
	//  "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestParameters": { "integration.request.header.Content-Type":
	//  "'application/x-amz-json-1.1'" }, "requestTemplates": { "application/json":
	//  "{\n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
	//  "_embedded": { "integration:responses": { "_links": { "self": { "href":
	//  "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
	//  "name": "200", "title": "200" }, "integrationresponse:delete": { "href":
	//  "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
	//  }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
	//  } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'"
	//  }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream
	//  in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
	//  }, "statusCode": "200" } } }, "method:responses": { "_links": { "self":
	//  { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
	//  "name": "200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
	//  }, "methodresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
	//  } }, "responseModels": { "application/json": "Empty" }, "responseParameters":
	//  { "method.response.header.Content-Type": false }, "statusCode": "200" }
	//  } }
	// If the OPTIONS is enabled on the resource, you can follow the example here
	// to get that method. Just replace the GET of the last path segment in the
	// request URL with OPTIONS.
	ResourceMethods map[string]Method `locationName:"resourceMethods" type:"map"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Resource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentId != nil {
		v := *s.ParentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "parentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PathPart != nil {
		v := *s.PathPart

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pathPart", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceMethods != nil {
		v := s.ResourceMethods

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "resourceMethods", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Represents a REST API.
//
// Create an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
type RestApi struct {
	_ struct{} `type:"structure"`

	// The source of the API key for metering requests according to a usage plan.
	// Valid values are:
	//    * HEADER to read the API key from the X-API-Key header of a request.
	//
	//    * AUTHORIZER to read the API key from the UsageIdentifierKey from a custom
	//    authorizer.
	ApiKeySource ApiKeySourceType `locationName:"apiKeySource" type:"string" enum:"true"`

	// The list of binary media types supported by the RestApi. By default, the
	// RestApi supports only UTF-8-encoded text payloads.
	BinaryMediaTypes []string `locationName:"binaryMediaTypes" type:"list"`

	// The timestamp when the API was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// The API's description.
	Description *string `locationName:"description" type:"string"`

	// The endpoint configuration of this RestApi showing the endpoint types of
	// the API.
	EndpointConfiguration *EndpointConfiguration `locationName:"endpointConfiguration" type:"structure"`

	// The API's identifier. This identifier is unique across all of your APIs in
	// API Gateway.
	Id *string `locationName:"id" type:"string"`

	// A nullable integer that is used to enable compression (with non-negative
	// between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with
	// a null value) on an API. When compression is enabled, compression or decompression
	// is not applied on the payload if the payload size is smaller than this value.
	// Setting it to zero allows compression for any payload size.
	MinimumCompressionSize *int64 `locationName:"minimumCompressionSize" type:"integer"`

	// The API's name.
	Name *string `locationName:"name" type:"string"`

	// A stringified JSON policy document that applies to this RestApi regardless
	// of the caller and Method configuration.
	Policy *string `locationName:"policy" type:"string"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string `locationName:"tags" type:"map"`

	// A version identifier for the API.
	Version *string `locationName:"version" type:"string"`

	// The warning messages reported when failonwarnings is turned on during API
	// import.
	Warnings []string `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s RestApi) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestApi) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ApiKeySource) > 0 {
		v := s.ApiKeySource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiKeySource", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.BinaryMediaTypes != nil {
		v := s.BinaryMediaTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "binaryMediaTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointConfiguration != nil {
		v := s.EndpointConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "endpointConfiguration", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MinimumCompressionSize != nil {
		v := *s.MinimumCompressionSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "minimumCompressionSize", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Warnings != nil {
		v := s.Warnings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "warnings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// A configuration property of an SDK type.
type SdkConfigurationProperty struct {
	_ struct{} `type:"structure"`

	// The default value of an SdkType configuration property.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The description of an SdkType configuration property.
	Description *string `locationName:"description" type:"string"`

	// The user-friendly name of an SdkType configuration property.
	FriendlyName *string `locationName:"friendlyName" type:"string"`

	// The name of a an SdkType configuration property.
	Name *string `locationName:"name" type:"string"`

	// A boolean flag of an SdkType configuration property to indicate if the associated
	// SDK configuration property is required (true) or not (false).
	Required *bool `locationName:"required" type:"boolean"`
}

// String returns the string representation
func (s SdkConfigurationProperty) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SdkConfigurationProperty) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefaultValue != nil {
		v := *s.DefaultValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "defaultValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FriendlyName != nil {
		v := *s.FriendlyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "friendlyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Required != nil {
		v := *s.Required

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "required", protocol.BoolValue(v), metadata)
	}
	return nil
}

// A type of SDK that API Gateway can generate.
type SdkType struct {
	_ struct{} `type:"structure"`

	// A list of configuration properties of an SdkType.
	ConfigurationProperties []SdkConfigurationProperty `locationName:"configurationProperties" type:"list"`

	// The description of an SdkType.
	Description *string `locationName:"description" type:"string"`

	// The user-friendly name of an SdkType instance.
	FriendlyName *string `locationName:"friendlyName" type:"string"`

	// The identifier of an SdkType instance.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s SdkType) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SdkType) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConfigurationProperties != nil {
		v := s.ConfigurationProperties

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "configurationProperties", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FriendlyName != nil {
		v := *s.FriendlyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "friendlyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a unique identifier for a version of a deployed RestApi that is
// callable by users.
//
// Deploy an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html)
type Stage struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in this stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	// Specifies whether a cache cluster is enabled for the stage.
	CacheClusterEnabled *bool `locationName:"cacheClusterEnabled" type:"boolean"`

	// The size of the cache cluster for the stage, if enabled.
	CacheClusterSize CacheClusterSize `locationName:"cacheClusterSize" type:"string" enum:"true"`

	// The status of the cache cluster for the stage, if enabled.
	CacheClusterStatus CacheClusterStatus `locationName:"cacheClusterStatus" type:"string" enum:"true"`

	// Settings for the canary deployment in this stage.
	CanarySettings *CanarySettings `locationName:"canarySettings" type:"structure"`

	// The identifier of a client certificate for an API stage.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// The timestamp when the stage was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// The identifier of the Deployment that the stage points to.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The stage's description.
	Description *string `locationName:"description" type:"string"`

	// The version of the associated API documentation.
	DocumentationVersion *string `locationName:"documentationVersion" type:"string"`

	// The timestamp when the stage last updated.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// A map that defines the method settings for a Stage resource. Keys (designated
	// as /{method_setting_key below) are method paths defined as {resource_path}/{http_method}
	// for an individual method override, or /\*/\* for overriding all methods in
	// the stage.
	MethodSettings map[string]MethodSetting `locationName:"methodSettings" type:"map"`

	// The name of the stage is the first path segment in the Uniform Resource Identifier
	// (URI) of a call to API Gateway. Stage names can only contain alphanumeric
	// characters, hyphens, and underscores. Maximum length is 128 characters.
	StageName *string `locationName:"stageName" type:"string"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string `locationName:"tags" type:"map"`

	// Specifies whether active tracing with X-ray is enabled for the Stage.
	TracingEnabled *bool `locationName:"tracingEnabled" type:"boolean"`

	// A map that defines the stage variables for a Stage resource. Variable names
	// can have alphanumeric and underscore characters, and the values must match
	// [A-Za-z0-9-._~:/?#&=,]+.
	Variables map[string]string `locationName:"variables" type:"map"`

	// The ARN of the WebAcl associated with the Stage.
	WebAclArn *string `locationName:"webAclArn" type:"string"`
}

// String returns the string representation
func (s Stage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Stage) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessLogSettings != nil {
		v := s.AccessLogSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessLogSettings", v, metadata)
	}
	if s.CacheClusterEnabled != nil {
		v := *s.CacheClusterEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cacheClusterEnabled", protocol.BoolValue(v), metadata)
	}
	if len(s.CacheClusterSize) > 0 {
		v := s.CacheClusterSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cacheClusterSize", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.CacheClusterStatus) > 0 {
		v := s.CacheClusterStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cacheClusterStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CanarySettings != nil {
		v := s.CanarySettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "canarySettings", v, metadata)
	}
	if s.ClientCertificateId != nil {
		v := *s.ClientCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DocumentationVersion != nil {
		v := *s.DocumentationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "documentationVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedDate != nil {
		v := *s.LastUpdatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.MethodSettings != nil {
		v := s.MethodSettings

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "methodSettings", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.StageName != nil {
		v := *s.StageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TracingEnabled != nil {
		v := *s.TracingEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "tracingEnabled", protocol.BoolValue(v), metadata)
	}
	if s.Variables != nil {
		v := s.Variables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "variables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.WebAclArn != nil {
		v := *s.WebAclArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "webAclArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A reference to a unique stage identified in the format {restApiId}/{stage}.
type StageKey struct {
	_ struct{} `type:"structure"`

	// The string identifier of the associated RestApi.
	RestApiId *string `locationName:"restApiId" type:"string"`

	// The stage name associated with the stage key.
	StageName *string `locationName:"stageName" type:"string"`
}

// String returns the string representation
func (s StageKey) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StageKey) MarshalFields(e protocol.FieldEncoder) error {
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "restApiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StageName != nil {
		v := *s.StageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The API request rate limits.
type ThrottleSettings struct {
	_ struct{} `type:"structure"`

	// The API request burst limit, the maximum rate limit over a time ranging from
	// one to a few seconds, depending upon whether the underlying token bucket
	// is at its full capacity.
	BurstLimit *int64 `locationName:"burstLimit" type:"integer"`

	// The API request steady-state rate limit.
	RateLimit *float64 `locationName:"rateLimit" type:"double"`
}

// String returns the string representation
func (s ThrottleSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThrottleSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.BurstLimit != nil {
		v := *s.BurstLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "burstLimit", protocol.Int64Value(v), metadata)
	}
	if s.RateLimit != nil {
		v := *s.RateLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rateLimit", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Represents a usage plan than can specify who can assess associated API stages
// with specified request limits and quotas.
//
// In a usage plan, you associate an API by specifying the API's Id and a stage
// name of the specified API. You add plan customers by adding API keys to the
// plan.
//
// Create and Use Usage Plans (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html)
type UsagePlan struct {
	_ struct{} `type:"structure"`

	// The associated API stages of a usage plan.
	ApiStages []ApiStage `locationName:"apiStages" type:"list"`

	// The description of a usage plan.
	Description *string `locationName:"description" type:"string"`

	// The identifier of a UsagePlan resource.
	Id *string `locationName:"id" type:"string"`

	// The name of a usage plan.
	Name *string `locationName:"name" type:"string"`

	// The AWS Markeplace product identifier to associate with the usage plan as
	// a SaaS product on AWS Marketplace.
	ProductCode *string `locationName:"productCode" type:"string"`

	// The maximum number of permitted requests per a given unit time interval.
	Quota *QuotaSettings `locationName:"quota" type:"structure"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The request throttle limits of a usage plan.
	Throttle *ThrottleSettings `locationName:"throttle" type:"structure"`
}

// String returns the string representation
func (s UsagePlan) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UsagePlan) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiStages != nil {
		v := s.ApiStages

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "apiStages", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProductCode != nil {
		v := *s.ProductCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "productCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Quota != nil {
		v := s.Quota

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "quota", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Throttle != nil {
		v := s.Throttle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "throttle", v, metadata)
	}
	return nil
}

// Represents a usage plan key to identify a plan customer.
//
// To associate an API stage with a selected API key in a usage plan, you must
// create a UsagePlanKey resource to represent the selected ApiKey.
//
// "
// Create and Use Usage Plans (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html)
type UsagePlanKey struct {
	_ struct{} `type:"structure"`

	// The Id of a usage plan key.
	Id *string `locationName:"id" type:"string"`

	// The name of a usage plan key.
	Name *string `locationName:"name" type:"string"`

	// The type of a usage plan key. Currently, the valid key type is API_KEY.
	Type *string `locationName:"type" type:"string"`

	// The value of a usage plan key.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s UsagePlanKey) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UsagePlanKey) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A API Gateway VPC link for a RestApi to access resources in an Amazon Virtual
// Private Cloud (VPC).
//
// To enable access to a resource in an Amazon Virtual Private Cloud through
// Amazon API Gateway, you, as an API developer, create a VpcLink resource targeted
// for one or more network load balancers of the VPC and then integrate an API
// method with a private integration that uses the VpcLink. The private integration
// has an integration type of HTTP or HTTP_PROXY and has a connection type of
// VPC_LINK. The integration uses the connectionId property to identify the
// VpcLink used.
type VpcLink struct {
	_ struct{} `type:"structure"`

	// The description of the VPC link.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the VpcLink. It is used in an Integration to reference
	// this VpcLink.
	Id *string `locationName:"id" type:"string"`

	// The name used to label and identify the VPC link.
	Name *string `locationName:"name" type:"string"`

	// The status of the VPC link. The valid values are AVAILABLE, PENDING, DELETING,
	// or FAILED. Deploying an API will wait if the status is PENDING and will fail
	// if the status is DELETING.
	Status VpcLinkStatus `locationName:"status" type:"string" enum:"true"`

	// A description about the VPC link status.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The ARNs of network load balancers of the VPC targeted by the VPC link. The
	// network load balancers must be owned by the same AWS account of the API owner.
	TargetArns []string `locationName:"targetArns" type:"list"`
}

// String returns the string representation
func (s VpcLink) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcLink) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusMessage != nil {
		v := *s.StatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TargetArns != nil {
		v := s.TargetArns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "targetArns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}
