// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListAssociatedStacksInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedStacksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedStacksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAssociatedStacksInput"}

	if s.FleetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FleetName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAssociatedStacksOutput struct {
	_ struct{} `type:"structure"`

	// The name of the stack.
	Names []string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedStacksOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAssociatedStacks = "ListAssociatedStacks"

// ListAssociatedStacksRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Retrieves the name of the stack with which the specified fleet is associated.
//
//    // Example sending a request using ListAssociatedStacksRequest.
//    req := client.ListAssociatedStacksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks
func (c *Client) ListAssociatedStacksRequest(input *ListAssociatedStacksInput) ListAssociatedStacksRequest {
	op := &aws.Operation{
		Name:       opListAssociatedStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssociatedStacksInput{}
	}

	req := c.newRequest(op, input, &ListAssociatedStacksOutput{})
	return ListAssociatedStacksRequest{Request: req, Input: input, Copy: c.ListAssociatedStacksRequest}
}

// ListAssociatedStacksRequest is the request type for the
// ListAssociatedStacks API operation.
type ListAssociatedStacksRequest struct {
	*aws.Request
	Input *ListAssociatedStacksInput
	Copy  func(*ListAssociatedStacksInput) ListAssociatedStacksRequest
}

// Send marshals and sends the ListAssociatedStacks API request.
func (r ListAssociatedStacksRequest) Send(ctx context.Context) (*ListAssociatedStacksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAssociatedStacksResponse{
		ListAssociatedStacksOutput: r.Request.Data.(*ListAssociatedStacksOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListAssociatedStacksResponse is the response type for the
// ListAssociatedStacks API operation.
type ListAssociatedStacksResponse struct {
	*ListAssociatedStacksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAssociatedStacks request.
func (r *ListAssociatedStacksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
