// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/memcache/v1beta2/cloud_memcache.proto

package memcache

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Memcached versions supported by our service.
type MemcacheVersion int32

const (
	MemcacheVersion_MEMCACHE_VERSION_UNSPECIFIED MemcacheVersion = 0
	// Memcached 1.5 version.
	MemcacheVersion_MEMCACHE_1_5 MemcacheVersion = 1
)

var MemcacheVersion_name = map[int32]string{
	0: "MEMCACHE_VERSION_UNSPECIFIED",
	1: "MEMCACHE_1_5",
}

var MemcacheVersion_value = map[string]int32{
	"MEMCACHE_VERSION_UNSPECIFIED": 0,
	"MEMCACHE_1_5":                 1,
}

func (x MemcacheVersion) String() string {
	return proto.EnumName(MemcacheVersion_name, int32(x))
}

func (MemcacheVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{0}
}

// Different states of a Memcached instance.
// LINT.IfChange
type Instance_State int32

const (
	// State not set.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// Memcached instance is being created.
	Instance_CREATING Instance_State = 1
	// Memcached instance has been created and ready to be used.
	Instance_READY Instance_State = 2
	// Memcached instance is being deleted.
	Instance_DELETING Instance_State = 4
	// Memcached instance is going through maintenance, e.g. data plane rollout.
	Instance_PERFORMING_MAINTENANCE Instance_State = 5
)

var Instance_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
	4: "DELETING",
	5: "PERFORMING_MAINTENANCE",
}

var Instance_State_value = map[string]int32{
	"STATE_UNSPECIFIED":      0,
	"CREATING":               1,
	"READY":                  2,
	"DELETING":               4,
	"PERFORMING_MAINTENANCE": 5,
}

func (x Instance_State) String() string {
	return proto.EnumName(Instance_State_name, int32(x))
}

func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{0, 0}
}

// Different states of a Memcached node.
// LINT.IfChange
type Instance_Node_State int32

const (
	// Node state is not set.
	Instance_Node_STATE_UNSPECIFIED Instance_Node_State = 0
	// Node is being created.
	Instance_Node_CREATING Instance_Node_State = 1
	// Node has been created and ready to be used.
	Instance_Node_READY Instance_Node_State = 2
	// Node is being deleted.
	Instance_Node_DELETING Instance_Node_State = 3
	// Node is being updated.
	Instance_Node_UPDATING Instance_Node_State = 4
)

var Instance_Node_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
	3: "DELETING",
	4: "UPDATING",
}

var Instance_Node_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
	"DELETING":          3,
	"UPDATING":          4,
}

func (x Instance_Node_State) String() string {
	return proto.EnumName(Instance_Node_State_name, int32(x))
}

func (Instance_Node_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{0, 1, 0}
}

type Instance_InstanceMessage_Code int32

const (
	// Message Code not set.
	Instance_InstanceMessage_CODE_UNSPECIFIED Instance_InstanceMessage_Code = 0
	// Memcached nodes are distributed unevenly.
	Instance_InstanceMessage_ZONE_DISTRIBUTION_UNBALANCED Instance_InstanceMessage_Code = 1
)

var Instance_InstanceMessage_Code_name = map[int32]string{
	0: "CODE_UNSPECIFIED",
	1: "ZONE_DISTRIBUTION_UNBALANCED",
}

var Instance_InstanceMessage_Code_value = map[string]int32{
	"CODE_UNSPECIFIED":             0,
	"ZONE_DISTRIBUTION_UNBALANCED": 1,
}

func (x Instance_InstanceMessage_Code) String() string {
	return proto.EnumName(Instance_InstanceMessage_Code_name, int32(x))
}

func (Instance_InstanceMessage_Code) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{0, 2, 0}
}

type Instance struct {
	// Required. Unique name of the resource in this scope including project and
	// location using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	//
	// Note: Memcached instances are managed and addressed at regional level so
	// location_id here refers to a GCP region; however, users may choose which
	// zones Memcached nodes within an instances should be provisioned in.
	// Refer to [zones] field for more details.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. User provided name for the instance only used for display
	// purposes. Cannot be more than 80 characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Resource labels to represent user-provided metadata.
	// Refer to cloud documentation on labels for more details.
	// https://cloud.google.com/compute/docs/labeling-resources
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The full name of the Google Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// instance is connected. If left unspecified, the `default` network
	// will be used.
	AuthorizedNetwork string `protobuf:"bytes,4,opt,name=authorized_network,json=authorizedNetwork,proto3" json:"authorized_network,omitempty"`
	// Optional. Zones where Memcached nodes should be provisioned in.
	// Memcached nodes will be equally distributed across these zones. If not
	// provided, the service will by default create nodes in all zones in the
	// region for the instance.
	Zones []string `protobuf:"bytes,5,rep,name=zones,proto3" json:"zones,omitempty"`
	// Required. Number of nodes in the Memcached instance.
	NodeCount int32 `protobuf:"varint,6,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Required. Configuration for Memcached nodes.
	NodeConfig *Instance_NodeConfig `protobuf:"bytes,7,opt,name=node_config,json=nodeConfig,proto3" json:"node_config,omitempty"`
	// Optional. The major version of Memcached software.
	// If not provided, latest supported version will be used. Currently the
	// latest supported major version is MEMCACHE_1_5.
	// The minor version will be automatically determined by our system based on
	// the latest supported minor version.
	MemcacheVersion MemcacheVersion `protobuf:"varint,9,opt,name=memcache_version,json=memcacheVersion,proto3,enum=google.cloud.memcache.v1beta2.MemcacheVersion" json:"memcache_version,omitempty"`
	// Optional: User defined parameters to apply to the memcached process
	// on each node.
	Parameters *MemcacheParameters `protobuf:"bytes,11,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Output only. List of Memcached nodes.
	// Refer to [Node] message for more details.
	MemcacheNodes []*Instance_Node `protobuf:"bytes,12,rep,name=memcache_nodes,json=memcacheNodes,proto3" json:"memcache_nodes,omitempty"`
	// Output only. The time the instance was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the instance was updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,14,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The state of this Memcached instance.
	State Instance_State `protobuf:"varint,15,opt,name=state,proto3,enum=google.cloud.memcache.v1beta2.Instance_State" json:"state,omitempty"`
	// Output only. The full version of memcached server running on this instance.
	// System automatically determines the full memcached version for an instance
	// based on the input MemcacheVersion.
	// The full version format will be "memcached-1.5.16".
	MemcacheFullVersion string `protobuf:"bytes,18,opt,name=memcache_full_version,json=memcacheFullVersion,proto3" json:"memcache_full_version,omitempty"`
	// List of messages that describe current statuses of memcached instance.
	InstanceMessages []*Instance_InstanceMessage `protobuf:"bytes,19,rep,name=instance_messages,json=instanceMessages,proto3" json:"instance_messages,omitempty"`
	// Output only. Endpoint for Discovery API
	DiscoveryEndpoint    string   `protobuf:"bytes,20,opt,name=discovery_endpoint,json=discoveryEndpoint,proto3" json:"discovery_endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Instance) Reset()         { *m = Instance{} }
func (m *Instance) String() string { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()    {}
func (*Instance) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{0}
}

func (m *Instance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance.Unmarshal(m, b)
}
func (m *Instance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance.Marshal(b, m, deterministic)
}
func (m *Instance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance.Merge(m, src)
}
func (m *Instance) XXX_Size() int {
	return xxx_messageInfo_Instance.Size(m)
}
func (m *Instance) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance.DiscardUnknown(m)
}

var xxx_messageInfo_Instance proto.InternalMessageInfo

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Instance) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Instance) GetAuthorizedNetwork() string {
	if m != nil {
		return m.AuthorizedNetwork
	}
	return ""
}

func (m *Instance) GetZones() []string {
	if m != nil {
		return m.Zones
	}
	return nil
}

func (m *Instance) GetNodeCount() int32 {
	if m != nil {
		return m.NodeCount
	}
	return 0
}

func (m *Instance) GetNodeConfig() *Instance_NodeConfig {
	if m != nil {
		return m.NodeConfig
	}
	return nil
}

func (m *Instance) GetMemcacheVersion() MemcacheVersion {
	if m != nil {
		return m.MemcacheVersion
	}
	return MemcacheVersion_MEMCACHE_VERSION_UNSPECIFIED
}

func (m *Instance) GetParameters() *MemcacheParameters {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *Instance) GetMemcacheNodes() []*Instance_Node {
	if m != nil {
		return m.MemcacheNodes
	}
	return nil
}

func (m *Instance) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Instance) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Instance) GetState() Instance_State {
	if m != nil {
		return m.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (m *Instance) GetMemcacheFullVersion() string {
	if m != nil {
		return m.MemcacheFullVersion
	}
	return ""
}

func (m *Instance) GetInstanceMessages() []*Instance_InstanceMessage {
	if m != nil {
		return m.InstanceMessages
	}
	return nil
}

func (m *Instance) GetDiscoveryEndpoint() string {
	if m != nil {
		return m.DiscoveryEndpoint
	}
	return ""
}

// Configuration for a Memcached Node.
type Instance_NodeConfig struct {
	// Required. Number of cpus per Memcached node.
	CpuCount int32 `protobuf:"varint,1,opt,name=cpu_count,json=cpuCount,proto3" json:"cpu_count,omitempty"`
	// Required. Memory size in MiB for each Memcached node.
	MemorySizeMb         int32    `protobuf:"varint,2,opt,name=memory_size_mb,json=memorySizeMb,proto3" json:"memory_size_mb,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Instance_NodeConfig) Reset()         { *m = Instance_NodeConfig{} }
func (m *Instance_NodeConfig) String() string { return proto.CompactTextString(m) }
func (*Instance_NodeConfig) ProtoMessage()    {}
func (*Instance_NodeConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{0, 0}
}

func (m *Instance_NodeConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance_NodeConfig.Unmarshal(m, b)
}
func (m *Instance_NodeConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance_NodeConfig.Marshal(b, m, deterministic)
}
func (m *Instance_NodeConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance_NodeConfig.Merge(m, src)
}
func (m *Instance_NodeConfig) XXX_Size() int {
	return xxx_messageInfo_Instance_NodeConfig.Size(m)
}
func (m *Instance_NodeConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance_NodeConfig.DiscardUnknown(m)
}

var xxx_messageInfo_Instance_NodeConfig proto.InternalMessageInfo

func (m *Instance_NodeConfig) GetCpuCount() int32 {
	if m != nil {
		return m.CpuCount
	}
	return 0
}

func (m *Instance_NodeConfig) GetMemorySizeMb() int32 {
	if m != nil {
		return m.MemorySizeMb
	}
	return 0
}

type Instance_Node struct {
	// Output only. Identifier of the Memcached node. The node id does not
	// include project or location like the Memcached instance name.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// Output only. Location (GCP Zone) for the Memcached node.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Output only. Current state of the Memcached node.
	State Instance_Node_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.memcache.v1beta2.Instance_Node_State" json:"state,omitempty"`
	// Output only. Hostname or IP address of the Memcached node used by the
	// clients to connect to the Memcached server on this node.
	Host string `protobuf:"bytes,4,opt,name=host,proto3" json:"host,omitempty"`
	// Output only. The port number of the Memcached server on this node.
	Port int32 `protobuf:"varint,5,opt,name=port,proto3" json:"port,omitempty"`
	// User defined parameters currently applied to the node.
	Parameters           *MemcacheParameters `protobuf:"bytes,6,opt,name=parameters,proto3" json:"parameters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Instance_Node) Reset()         { *m = Instance_Node{} }
func (m *Instance_Node) String() string { return proto.CompactTextString(m) }
func (*Instance_Node) ProtoMessage()    {}
func (*Instance_Node) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{0, 1}
}

func (m *Instance_Node) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance_Node.Unmarshal(m, b)
}
func (m *Instance_Node) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance_Node.Marshal(b, m, deterministic)
}
func (m *Instance_Node) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance_Node.Merge(m, src)
}
func (m *Instance_Node) XXX_Size() int {
	return xxx_messageInfo_Instance_Node.Size(m)
}
func (m *Instance_Node) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance_Node.DiscardUnknown(m)
}

var xxx_messageInfo_Instance_Node proto.InternalMessageInfo

func (m *Instance_Node) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *Instance_Node) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Instance_Node) GetState() Instance_Node_State {
	if m != nil {
		return m.State
	}
	return Instance_Node_STATE_UNSPECIFIED
}

func (m *Instance_Node) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Instance_Node) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Instance_Node) GetParameters() *MemcacheParameters {
	if m != nil {
		return m.Parameters
	}
	return nil
}

type Instance_InstanceMessage struct {
	// A code that correspond to one type of user-facing message.
	Code Instance_InstanceMessage_Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.memcache.v1beta2.Instance_InstanceMessage_Code" json:"code,omitempty"`
	// Message on memcached instance which will be exposed to users.
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Instance_InstanceMessage) Reset()         { *m = Instance_InstanceMessage{} }
func (m *Instance_InstanceMessage) String() string { return proto.CompactTextString(m) }
func (*Instance_InstanceMessage) ProtoMessage()    {}
func (*Instance_InstanceMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{0, 2}
}

func (m *Instance_InstanceMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance_InstanceMessage.Unmarshal(m, b)
}
func (m *Instance_InstanceMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance_InstanceMessage.Marshal(b, m, deterministic)
}
func (m *Instance_InstanceMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance_InstanceMessage.Merge(m, src)
}
func (m *Instance_InstanceMessage) XXX_Size() int {
	return xxx_messageInfo_Instance_InstanceMessage.Size(m)
}
func (m *Instance_InstanceMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance_InstanceMessage.DiscardUnknown(m)
}

var xxx_messageInfo_Instance_InstanceMessage proto.InternalMessageInfo

func (m *Instance_InstanceMessage) GetCode() Instance_InstanceMessage_Code {
	if m != nil {
		return m.Code
	}
	return Instance_InstanceMessage_CODE_UNSPECIFIED
}

func (m *Instance_InstanceMessage) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// Request for [ListInstances][google.cloud.memcache.v1beta2.CloudMemcache.ListInstances].
type ListInstancesRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 1000 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [next_page_token][CloudMemcache.ListInstancesResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request,
	// if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// List filter. For example, exclude all Memcached instances with name as
	// my-instance by specifying "name != my-instance".
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort results. Supported values are "name", "name desc" or "" (unsorted).
	OrderBy              string   `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesRequest) Reset()         { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()    {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{1}
}

func (m *ListInstancesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesRequest.Unmarshal(m, b)
}
func (m *ListInstancesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesRequest.Marshal(b, m, deterministic)
}
func (m *ListInstancesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesRequest.Merge(m, src)
}
func (m *ListInstancesRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstancesRequest.Size(m)
}
func (m *ListInstancesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesRequest proto.InternalMessageInfo

func (m *ListInstancesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstancesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListInstancesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListInstancesRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// Response for [ListInstances][google.cloud.memcache.v1beta2.CloudMemcache.ListInstances].
type ListInstancesResponse struct {
	// A list of Memcached instances in the project in the specified location,
	// or across all locations.
	//
	// If the `location_id` in the parent field of the request is "-", all regions
	// available to the project are queried, and the results aggregated.
	Resources []*Instance `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable          []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesResponse) Reset()         { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()    {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{2}
}

func (m *ListInstancesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesResponse.Unmarshal(m, b)
}
func (m *ListInstancesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesResponse.Marshal(b, m, deterministic)
}
func (m *ListInstancesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesResponse.Merge(m, src)
}
func (m *ListInstancesResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstancesResponse.Size(m)
}
func (m *ListInstancesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesResponse proto.InternalMessageInfo

func (m *ListInstancesResponse) GetResources() []*Instance {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListInstancesResponse) GetUnreachable() []string {
	if m != nil {
		return m.Unreachable
	}
	return nil
}

// Request for [GetInstance][google.cloud.memcache.v1beta2.CloudMemcache.GetInstance].
type GetInstanceRequest struct {
	// Required. Memcached instance resource name in the format:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstanceRequest) Reset()         { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()    {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{3}
}

func (m *GetInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceRequest.Unmarshal(m, b)
}
func (m *GetInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceRequest.Marshal(b, m, deterministic)
}
func (m *GetInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceRequest.Merge(m, src)
}
func (m *GetInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceRequest.Size(m)
}
func (m *GetInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceRequest proto.InternalMessageInfo

func (m *GetInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for [CreateInstance][google.cloud.memcache.v1beta2.CloudMemcache.CreateInstance].
type CreateInstanceRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The logical name of the Memcached instance in the user
	// project with the following restrictions:
	//
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-40 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the user project / location
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. A Memcached [Instance] resource
	Resource             *Instance `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateInstanceRequest) Reset()         { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()    {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{4}
}

func (m *CreateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceRequest.Unmarshal(m, b)
}
func (m *CreateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceRequest.Marshal(b, m, deterministic)
}
func (m *CreateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceRequest.Merge(m, src)
}
func (m *CreateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceRequest.Size(m)
}
func (m *CreateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceRequest proto.InternalMessageInfo

func (m *CreateInstanceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CreateInstanceRequest) GetResource() *Instance {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Request for [UpdateInstance][google.cloud.memcache.v1beta2.CloudMemcache.UpdateInstance].
type UpdateInstanceRequest struct {
	// Required. Mask of fields to update.
	//  *   `displayName`
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. A Memcached [Instance] resource.
	// Only fields specified in update_mask are updated.
	Resource             *Instance `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UpdateInstanceRequest) Reset()         { *m = UpdateInstanceRequest{} }
func (m *UpdateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceRequest) ProtoMessage()    {}
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{5}
}

func (m *UpdateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceRequest.Unmarshal(m, b)
}
func (m *UpdateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceRequest.Merge(m, src)
}
func (m *UpdateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceRequest.Size(m)
}
func (m *UpdateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceRequest proto.InternalMessageInfo

func (m *UpdateInstanceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateInstanceRequest) GetResource() *Instance {
	if m != nil {
		return m.Resource
	}
	return nil
}

// Request for [DeleteInstance][google.cloud.memcache.v1beta2.CloudMemcache.DeleteInstance].
type DeleteInstanceRequest struct {
	// Memcached instance resource name in the format:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceRequest) Reset()         { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()    {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{6}
}

func (m *DeleteInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceRequest.Unmarshal(m, b)
}
func (m *DeleteInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceRequest.Merge(m, src)
}
func (m *DeleteInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceRequest.Size(m)
}
func (m *DeleteInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceRequest proto.InternalMessageInfo

func (m *DeleteInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for [ApplyParameters][google.cloud.memcache.v1beta2.CloudMemcache.ApplyParameters].
type ApplyParametersRequest struct {
	// Required. Resource name of the Memcached instance for which parameter group updates
	// should be applied.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Nodes to which we should apply the instance-level parameter group.
	NodeIds []string `protobuf:"bytes,2,rep,name=node_ids,json=nodeIds,proto3" json:"node_ids,omitempty"`
	// Whether to apply instance-level parameter group to all nodes. If set to
	// true, will explicitly restrict users from specifying any nodes, and apply
	// parameter group updates to all nodes within the instance.
	ApplyAll             bool     `protobuf:"varint,3,opt,name=apply_all,json=applyAll,proto3" json:"apply_all,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplyParametersRequest) Reset()         { *m = ApplyParametersRequest{} }
func (m *ApplyParametersRequest) String() string { return proto.CompactTextString(m) }
func (*ApplyParametersRequest) ProtoMessage()    {}
func (*ApplyParametersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{7}
}

func (m *ApplyParametersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyParametersRequest.Unmarshal(m, b)
}
func (m *ApplyParametersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyParametersRequest.Marshal(b, m, deterministic)
}
func (m *ApplyParametersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyParametersRequest.Merge(m, src)
}
func (m *ApplyParametersRequest) XXX_Size() int {
	return xxx_messageInfo_ApplyParametersRequest.Size(m)
}
func (m *ApplyParametersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyParametersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyParametersRequest proto.InternalMessageInfo

func (m *ApplyParametersRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ApplyParametersRequest) GetNodeIds() []string {
	if m != nil {
		return m.NodeIds
	}
	return nil
}

func (m *ApplyParametersRequest) GetApplyAll() bool {
	if m != nil {
		return m.ApplyAll
	}
	return false
}

// Request for [UpdateParameters][google.cloud.memcache.v1beta2.CloudMemcache.UpdateParameters].
type UpdateParametersRequest struct {
	// Required. Resource name of the Memcached instance for which the parameters should be
	// updated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Mask of fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The parameters to apply to the instance.
	Parameters           *MemcacheParameters `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *UpdateParametersRequest) Reset()         { *m = UpdateParametersRequest{} }
func (m *UpdateParametersRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateParametersRequest) ProtoMessage()    {}
func (*UpdateParametersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{8}
}

func (m *UpdateParametersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateParametersRequest.Unmarshal(m, b)
}
func (m *UpdateParametersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateParametersRequest.Marshal(b, m, deterministic)
}
func (m *UpdateParametersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateParametersRequest.Merge(m, src)
}
func (m *UpdateParametersRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateParametersRequest.Size(m)
}
func (m *UpdateParametersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateParametersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateParametersRequest proto.InternalMessageInfo

func (m *UpdateParametersRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateParametersRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateParametersRequest) GetParameters() *MemcacheParameters {
	if m != nil {
		return m.Parameters
	}
	return nil
}

type MemcacheParameters struct {
	// Output only. The unique ID associated with this set of parameters. Users
	// can use this id to determine if the parameters associated with the instance
	// differ from the parameters associated with the nodes and any action needs
	// to be taken to apply parameters on nodes.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// User defined set of parameters to use in the memcached process.
	Params               map[string]string `protobuf:"bytes,3,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MemcacheParameters) Reset()         { *m = MemcacheParameters{} }
func (m *MemcacheParameters) String() string { return proto.CompactTextString(m) }
func (*MemcacheParameters) ProtoMessage()    {}
func (*MemcacheParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{9}
}

func (m *MemcacheParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MemcacheParameters.Unmarshal(m, b)
}
func (m *MemcacheParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MemcacheParameters.Marshal(b, m, deterministic)
}
func (m *MemcacheParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemcacheParameters.Merge(m, src)
}
func (m *MemcacheParameters) XXX_Size() int {
	return xxx_messageInfo_MemcacheParameters.Size(m)
}
func (m *MemcacheParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_MemcacheParameters.DiscardUnknown(m)
}

var xxx_messageInfo_MemcacheParameters proto.InternalMessageInfo

func (m *MemcacheParameters) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *MemcacheParameters) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

// Represents the metadata of a long-running operation.
type OperationMetadata struct {
	// Time when the operation was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when the operation finished running.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Human-readable status of the operation, if any.
	StatusDetail string `protobuf:"bytes,5,opt,name=status_detail,json=statusDetail,proto3" json:"status_detail,omitempty"`
	// Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	CancelRequested bool `protobuf:"varint,6,opt,name=cancel_requested,json=cancelRequested,proto3" json:"cancel_requested,omitempty"`
	// API version used to start the operation.
	ApiVersion           string   `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OperationMetadata) Reset()         { *m = OperationMetadata{} }
func (m *OperationMetadata) String() string { return proto.CompactTextString(m) }
func (*OperationMetadata) ProtoMessage()    {}
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{10}
}

func (m *OperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationMetadata.Unmarshal(m, b)
}
func (m *OperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationMetadata.Marshal(b, m, deterministic)
}
func (m *OperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationMetadata.Merge(m, src)
}
func (m *OperationMetadata) XXX_Size() int {
	return xxx_messageInfo_OperationMetadata.Size(m)
}
func (m *OperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_OperationMetadata proto.InternalMessageInfo

func (m *OperationMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *OperationMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *OperationMetadata) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

func (m *OperationMetadata) GetVerb() string {
	if m != nil {
		return m.Verb
	}
	return ""
}

func (m *OperationMetadata) GetStatusDetail() string {
	if m != nil {
		return m.StatusDetail
	}
	return ""
}

func (m *OperationMetadata) GetCancelRequested() bool {
	if m != nil {
		return m.CancelRequested
	}
	return false
}

func (m *OperationMetadata) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

// Metadata for the given [google.cloud.location.Location][google.cloud.location.Location].
type LocationMetadata struct {
	// Output only. The set of available zones in the location. The map is keyed
	// by the lowercase ID of each zone, as defined by GCE. These keys can be
	// specified in the `zones` field when creating a Memcached instance.
	AvailableZones       map[string]*ZoneMetadata `protobuf:"bytes,1,rep,name=available_zones,json=availableZones,proto3" json:"available_zones,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *LocationMetadata) Reset()         { *m = LocationMetadata{} }
func (m *LocationMetadata) String() string { return proto.CompactTextString(m) }
func (*LocationMetadata) ProtoMessage()    {}
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{11}
}

func (m *LocationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationMetadata.Unmarshal(m, b)
}
func (m *LocationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationMetadata.Marshal(b, m, deterministic)
}
func (m *LocationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationMetadata.Merge(m, src)
}
func (m *LocationMetadata) XXX_Size() int {
	return xxx_messageInfo_LocationMetadata.Size(m)
}
func (m *LocationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LocationMetadata proto.InternalMessageInfo

func (m *LocationMetadata) GetAvailableZones() map[string]*ZoneMetadata {
	if m != nil {
		return m.AvailableZones
	}
	return nil
}

type ZoneMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ZoneMetadata) Reset()         { *m = ZoneMetadata{} }
func (m *ZoneMetadata) String() string { return proto.CompactTextString(m) }
func (*ZoneMetadata) ProtoMessage()    {}
func (*ZoneMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_f170fe0dfb840f0d, []int{12}
}

func (m *ZoneMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ZoneMetadata.Unmarshal(m, b)
}
func (m *ZoneMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ZoneMetadata.Marshal(b, m, deterministic)
}
func (m *ZoneMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZoneMetadata.Merge(m, src)
}
func (m *ZoneMetadata) XXX_Size() int {
	return xxx_messageInfo_ZoneMetadata.Size(m)
}
func (m *ZoneMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ZoneMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ZoneMetadata proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("google.cloud.memcache.v1beta2.MemcacheVersion", MemcacheVersion_name, MemcacheVersion_value)
	proto.RegisterEnum("google.cloud.memcache.v1beta2.Instance_State", Instance_State_name, Instance_State_value)
	proto.RegisterEnum("google.cloud.memcache.v1beta2.Instance_Node_State", Instance_Node_State_name, Instance_Node_State_value)
	proto.RegisterEnum("google.cloud.memcache.v1beta2.Instance_InstanceMessage_Code", Instance_InstanceMessage_Code_name, Instance_InstanceMessage_Code_value)
	proto.RegisterType((*Instance)(nil), "google.cloud.memcache.v1beta2.Instance")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.memcache.v1beta2.Instance.LabelsEntry")
	proto.RegisterType((*Instance_NodeConfig)(nil), "google.cloud.memcache.v1beta2.Instance.NodeConfig")
	proto.RegisterType((*Instance_Node)(nil), "google.cloud.memcache.v1beta2.Instance.Node")
	proto.RegisterType((*Instance_InstanceMessage)(nil), "google.cloud.memcache.v1beta2.Instance.InstanceMessage")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.cloud.memcache.v1beta2.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.cloud.memcache.v1beta2.ListInstancesResponse")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.cloud.memcache.v1beta2.GetInstanceRequest")
	proto.RegisterType((*CreateInstanceRequest)(nil), "google.cloud.memcache.v1beta2.CreateInstanceRequest")
	proto.RegisterType((*UpdateInstanceRequest)(nil), "google.cloud.memcache.v1beta2.UpdateInstanceRequest")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.cloud.memcache.v1beta2.DeleteInstanceRequest")
	proto.RegisterType((*ApplyParametersRequest)(nil), "google.cloud.memcache.v1beta2.ApplyParametersRequest")
	proto.RegisterType((*UpdateParametersRequest)(nil), "google.cloud.memcache.v1beta2.UpdateParametersRequest")
	proto.RegisterType((*MemcacheParameters)(nil), "google.cloud.memcache.v1beta2.MemcacheParameters")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.memcache.v1beta2.MemcacheParameters.ParamsEntry")
	proto.RegisterType((*OperationMetadata)(nil), "google.cloud.memcache.v1beta2.OperationMetadata")
	proto.RegisterType((*LocationMetadata)(nil), "google.cloud.memcache.v1beta2.LocationMetadata")
	proto.RegisterMapType((map[string]*ZoneMetadata)(nil), "google.cloud.memcache.v1beta2.LocationMetadata.AvailableZonesEntry")
	proto.RegisterType((*ZoneMetadata)(nil), "google.cloud.memcache.v1beta2.ZoneMetadata")
}

func init() {
	proto.RegisterFile("google/cloud/memcache/v1beta2/cloud_memcache.proto", fileDescriptor_f170fe0dfb840f0d)
}

var fileDescriptor_f170fe0dfb840f0d = []byte{
	// 2019 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x59, 0xcb, 0x6f, 0xdb, 0xc8,
	0x19, 0x2f, 0x29, 0x3f, 0xa4, 0x4f, 0xb6, 0x2c, 0x4f, 0xec, 0x58, 0xab, 0x4d, 0xb0, 0x8a, 0x52,
	0x6c, 0x1d, 0xaf, 0x23, 0x21, 0xda, 0x4d, 0xb7, 0x75, 0xb2, 0x8b, 0xd2, 0x32, 0x13, 0x0b, 0x6b,
	0xc9, 0x2e, 0x6d, 0x2f, 0x36, 0xb9, 0xb0, 0x23, 0x72, 0x2c, 0xb3, 0xa6, 0x48, 0x2e, 0x49, 0x39,
	0x75, 0x82, 0x00, 0x45, 0x0f, 0x3d, 0x15, 0xbd, 0xf4, 0x4f, 0x68, 0x51, 0xec, 0xa1, 0xbd, 0xf5,
	0x56, 0xf4, 0x01, 0xf4, 0xb2, 0xc8, 0xb1, 0xbd, 0xe5, 0xb4, 0x87, 0xa2, 0x87, 0xa2, 0xc7, 0xf6,
	0xd2, 0x4b, 0x8b, 0x99, 0xe1, 0x50, 0x94, 0xec, 0x44, 0xb2, 0xd7, 0xb9, 0x91, 0xdf, 0x6b, 0xbe,
	0xf9, 0x9e, 0x3f, 0x4a, 0x50, 0xeb, 0xb8, 0x6e, 0xc7, 0x26, 0x55, 0xc3, 0x76, 0x7b, 0x66, 0xb5,
	0x4b, 0xba, 0x06, 0x36, 0x0e, 0x49, 0xf5, 0xf8, 0x4e, 0x9b, 0x84, 0xb8, 0xc6, 0xc9, 0xba, 0x20,
	0x57, 0x3c, 0xdf, 0x0d, 0x5d, 0x74, 0x9d, 0xeb, 0x54, 0x18, 0xb3, 0x12, 0x33, 0x23, 0x9d, 0xe2,
	0xb5, 0xc8, 0x24, 0xf6, 0xac, 0x2a, 0x76, 0x1c, 0x37, 0xc4, 0xa1, 0xe5, 0x3a, 0x01, 0x57, 0x2e,
	0x2e, 0x25, 0xb8, 0x86, 0x6d, 0x11, 0x27, 0x8c, 0x18, 0xef, 0x24, 0x18, 0x07, 0x16, 0xb1, 0x4d,
	0xbd, 0x4d, 0x0e, 0xf1, 0xb1, 0xe5, 0xfa, 0x91, 0xc0, 0x5b, 0x09, 0x01, 0x9f, 0x04, 0x6e, 0xcf,
	0x37, 0x22, 0x8f, 0x8a, 0x37, 0x23, 0x96, 0xed, 0x3a, 0x1d, 0xbf, 0xe7, 0x38, 0x96, 0xd3, 0xa9,
	0xba, 0x1e, 0xf1, 0x07, 0x4e, 0x2e, 0x45, 0x42, 0xec, 0xad, 0xdd, 0x3b, 0x88, 0x4e, 0xe9, 0xe2,
	0xe0, 0x68, 0xc8, 0x85, 0x58, 0x22, 0xb4, 0xba, 0x24, 0x08, 0x71, 0xd7, 0xe3, 0x02, 0xe5, 0x9f,
	0xce, 0x41, 0xba, 0xe1, 0x04, 0x21, 0x76, 0x0c, 0x82, 0x96, 0x60, 0xc2, 0xc1, 0x5d, 0x52, 0x90,
	0x4a, 0xd2, 0x72, 0x66, 0x3d, 0xf5, 0x95, 0x22, 0x6b, 0x8c, 0x80, 0x6e, 0xc0, 0x8c, 0x69, 0x05,
	0x9e, 0x8d, 0x4f, 0x74, 0x26, 0x20, 0x53, 0x01, 0x2d, 0x1b, 0xd1, 0x5a, 0x54, 0xe4, 0x13, 0x98,
	0xb2, 0x71, 0x9b, 0xd8, 0x41, 0x21, 0x55, 0x4a, 0x2d, 0x67, 0x6b, 0xef, 0x57, 0x5e, 0x1b, 0xd3,
	0x8a, 0x38, 0xb4, 0xb2, 0xc5, 0xb4, 0x54, 0x27, 0xf4, 0x4f, 0xb4, 0xc8, 0x04, 0xba, 0x0d, 0x08,
	0xf7, 0xc2, 0x43, 0xd7, 0xb7, 0x9e, 0x12, 0x53, 0x77, 0x48, 0xf8, 0xc4, 0xf5, 0x8f, 0x0a, 0x13,
	0xec, 0xd4, 0xf9, 0x3e, 0xa7, 0xc5, 0x19, 0x68, 0x01, 0x26, 0x9f, 0xba, 0x0e, 0x09, 0x0a, 0x93,
	0xa5, 0xd4, 0x72, 0x46, 0xe3, 0x2f, 0xa8, 0x0c, 0xe0, 0xb8, 0x26, 0xd1, 0x0d, 0xb7, 0xe7, 0x84,
	0x85, 0xa9, 0x92, 0xb4, 0x3c, 0xc9, 0xef, 0x94, 0xa1, 0xe4, 0x3a, 0xa5, 0xa2, 0xcf, 0x20, 0x1b,
	0xc9, 0x38, 0x07, 0x56, 0xa7, 0x30, 0x5d, 0x92, 0x96, 0xb3, 0xb5, 0xda, 0xb8, 0xae, 0xb7, 0x98,
	0x1d, 0xaa, 0xc9, 0x0d, 0x83, 0x13, 0x13, 0xd0, 0x23, 0xc8, 0x0b, 0x45, 0xfd, 0x98, 0xf8, 0x81,
	0xe5, 0x3a, 0x85, 0x4c, 0x49, 0x5a, 0xce, 0xd5, 0x2a, 0x23, 0xcc, 0x37, 0x23, 0xc2, 0xa7, 0x5c,
	0x4b, 0x9b, 0xeb, 0x0e, 0x12, 0xd0, 0xf7, 0x01, 0x3c, 0xec, 0xe3, 0x2e, 0x09, 0x89, 0x1f, 0x14,
	0xb2, 0xcc, 0xe7, 0x3b, 0x63, 0x1a, 0xdd, 0x89, 0x15, 0xb5, 0x84, 0x11, 0xf4, 0x19, 0xe4, 0x62,
	0x6f, 0xe9, 0x25, 0x82, 0xc2, 0x0c, 0xcb, 0xe2, 0xea, 0x79, 0x42, 0x41, 0x83, 0x90, 0xd2, 0x66,
	0x85, 0x10, 0x25, 0x05, 0xe8, 0x7b, 0x90, 0x35, 0x7c, 0x82, 0x43, 0xa2, 0xd3, 0xd2, 0x2b, 0xcc,
	0x32, 0x6f, 0x8b, 0xc2, 0xac, 0xa8, 0xcb, 0xca, 0x9e, 0xa8, 0x4b, 0x6e, 0x04, 0xb8, 0x0e, 0xa5,
	0x52, 0x0b, 0x3d, 0xcf, 0x8c, 0x2d, 0xe4, 0xc6, 0xb4, 0xc0, 0x75, 0x98, 0x85, 0x4d, 0x98, 0x0c,
	0x42, 0x1c, 0x92, 0xc2, 0x1c, 0x4b, 0xc0, 0xed, 0x71, 0x2f, 0xb5, 0x4b, 0x95, 0xb8, 0x39, 0x6e,
	0x00, 0x7d, 0x08, 0x8b, 0x71, 0x9c, 0x0e, 0x7a, 0xb6, 0x1d, 0xa7, 0x16, 0x89, 0x96, 0x49, 0x69,
	0x57, 0x84, 0xc4, 0x83, 0x9e, 0x6d, 0x8b, 0x9c, 0x99, 0x30, 0x6f, 0x45, 0x66, 0xf5, 0x2e, 0x09,
	0x02, 0xdc, 0x21, 0x41, 0xe1, 0x0a, 0x8b, 0xf1, 0x87, 0xe3, 0xba, 0x23, 0x1e, 0x9a, 0x5c, 0x5f,
	0xcb, 0x5b, 0x83, 0x84, 0x00, 0xd5, 0x00, 0x99, 0x56, 0x60, 0xb8, 0xc7, 0xc4, 0x3f, 0xd1, 0x89,
	0x63, 0x7a, 0xae, 0xe5, 0x84, 0x85, 0x85, 0xbe, 0x6f, 0xf3, 0x31, 0x5b, 0x8d, 0xb8, 0xc5, 0x47,
	0x00, 0xfd, 0x3a, 0x46, 0x25, 0xc8, 0x18, 0x5e, 0x2f, 0xea, 0x19, 0xa9, 0xdf, 0x33, 0x69, 0xc3,
	0xeb, 0xf1, 0x96, 0xb9, 0xc5, 0x4a, 0xc5, 0xf5, 0x4f, 0xf4, 0xc0, 0x7a, 0x4a, 0xf4, 0x6e, 0x9b,
	0x4d, 0x83, 0x48, 0x6c, 0x86, 0xb3, 0x76, 0xad, 0xa7, 0xa4, 0xd9, 0x2e, 0xfe, 0x43, 0x86, 0x09,
	0x6a, 0x1b, 0x5d, 0x83, 0x69, 0xd6, 0x66, 0x96, 0xd9, 0x9f, 0x2d, 0x29, 0x6d, 0x8a, 0xd2, 0x1a,
	0x26, 0x1d, 0x3b, 0xb4, 0x63, 0xf9, 0x54, 0xe1, 0x2c, 0x46, 0x40, 0x4d, 0x91, 0xb7, 0x14, 0xcb,
	0xdb, 0xb9, 0xfa, 0xf2, 0x8c, 0xe4, 0x2d, 0xc1, 0xc4, 0xa1, 0x1b, 0x84, 0x7c, 0x8e, 0x44, 0xe7,
	0x50, 0x02, 0x65, 0x78, 0xae, 0x1f, 0x16, 0x26, 0xc5, 0x45, 0x52, 0x1a, 0x23, 0x0c, 0x75, 0xda,
	0xd4, 0x25, 0x74, 0x5a, 0x79, 0x17, 0x26, 0x99, 0x67, 0x68, 0x11, 0xe6, 0x77, 0xf7, 0x94, 0x3d,
	0x55, 0xdf, 0x6f, 0xed, 0xee, 0xa8, 0xf5, 0xc6, 0x83, 0x86, 0xba, 0x91, 0xff, 0x06, 0x9a, 0x81,
	0x74, 0x5d, 0x53, 0x95, 0xbd, 0x46, 0xeb, 0x61, 0x5e, 0x42, 0x19, 0x98, 0xd4, 0x54, 0x65, 0xe3,
	0x51, 0x5e, 0xa6, 0x8c, 0x0d, 0x75, 0x4b, 0x65, 0x8c, 0x14, 0x7d, 0xdb, 0xdf, 0xd9, 0xe0, 0x62,
	0x13, 0xc5, 0x3f, 0x48, 0x30, 0x37, 0x54, 0x1d, 0x68, 0x07, 0x26, 0x0c, 0xd7, 0xe4, 0xc3, 0x3c,
	0x57, 0xbb, 0x7f, 0xc1, 0x22, 0xab, 0xd4, 0x5d, 0x93, 0x68, 0xcc, 0x12, 0x2a, 0xc0, 0x74, 0x54,
	0xba, 0xd1, 0x02, 0x10, 0xaf, 0xe5, 0x8f, 0x61, 0x82, 0xca, 0xa1, 0x05, 0xc8, 0xd7, 0xb7, 0x37,
	0x86, 0xaf, 0x54, 0x82, 0x6b, 0x8f, 0xb7, 0x5b, 0xaa, 0xbe, 0xd1, 0xd8, 0xdd, 0xd3, 0x1a, 0xeb,
	0xfb, 0x7b, 0x8d, 0xed, 0x96, 0xbe, 0xdf, 0x5a, 0x57, 0xb6, 0x94, 0x56, 0x5d, 0xdd, 0xc8, 0x4b,
	0xc5, 0xef, 0x42, 0x36, 0xb1, 0x06, 0x50, 0x1e, 0x52, 0x47, 0xe4, 0x84, 0x97, 0x8a, 0x46, 0x1f,
	0xe9, 0x84, 0x3f, 0xc6, 0x76, 0x4f, 0x1c, 0xcc, 0x5f, 0xd6, 0xe4, 0xef, 0x48, 0x65, 0x7c, 0x19,
	0xf1, 0x9c, 0x40, 0x45, 0xb8, 0xba, 0xa3, 0x6a, 0x0f, 0xb6, 0xb5, 0x66, 0xa3, 0xf5, 0x50, 0x6f,
	0x2a, 0x8d, 0xd6, 0x9e, 0xda, 0xa2, 0xee, 0xe5, 0x27, 0xd7, 0x8c, 0x7f, 0x2a, 0x3f, 0x80, 0x52,
	0x1c, 0x32, 0x1e, 0x48, 0xec, 0x59, 0x41, 0xc5, 0x70, 0xbb, 0xd5, 0x78, 0x7b, 0xde, 0xf7, 0x7c,
	0xf7, 0x87, 0xc4, 0x08, 0x83, 0xea, 0xb3, 0xe8, 0xe9, 0x79, 0xd5, 0x76, 0x0d, 0xbe, 0xb1, 0xab,
	0xcf, 0xc4, 0xe3, 0xf3, 0xaa, 0x68, 0xdb, 0xa0, 0xfa, 0x4c, 0x3c, 0x3e, 0x2f, 0x7f, 0x29, 0xc1,
	0xc2, 0x96, 0x15, 0x84, 0xc2, 0x5c, 0xa0, 0x91, 0xcf, 0x7b, 0x24, 0x08, 0x91, 0x02, 0x53, 0x1e,
	0xf6, 0x49, 0xd4, 0x8e, 0x99, 0xf5, 0x5b, 0x5f, 0x29, 0xf2, 0x7f, 0x95, 0x9b, 0x70, 0x23, 0xb6,
	0x3d, 0xec, 0xd1, 0x56, 0xc4, 0xd0, 0x22, 0x45, 0xf4, 0x36, 0x64, 0x3c, 0xdc, 0x21, 0xac, 0x61,
	0x79, 0xb7, 0x6a, 0x69, 0x4a, 0xa0, 0x6d, 0x8a, 0xae, 0xd3, 0x1a, 0xef, 0x10, 0x3d, 0x74, 0x8f,
	0x88, 0xc3, 0x3a, 0x2d, 0xa3, 0x31, 0xf1, 0x3d, 0x4a, 0x40, 0x57, 0x61, 0xea, 0xc0, 0xb2, 0x43,
	0xe2, 0x47, 0xeb, 0x37, 0x7a, 0x43, 0x6f, 0x41, 0xda, 0xf5, 0x4d, 0xe2, 0xeb, 0xed, 0x13, 0xd6,
	0x37, 0x19, 0x6d, 0x9a, 0xbd, 0xaf, 0x9f, 0x94, 0xbf, 0x90, 0x60, 0x71, 0xe8, 0x2a, 0x81, 0xe7,
	0x3a, 0x01, 0x41, 0x2a, 0x64, 0x04, 0xce, 0x09, 0x0a, 0x12, 0x9b, 0x7e, 0xdf, 0x1a, 0xb3, 0x30,
	0xb5, 0xbe, 0x26, 0x7a, 0x17, 0xe6, 0x1c, 0xf2, 0xa3, 0x50, 0x4f, 0xf8, 0xcd, 0xeb, 0x62, 0x96,
	0x92, 0x77, 0x62, 0xdf, 0x4b, 0x90, 0xed, 0x39, 0x3e, 0xc1, 0xc6, 0x21, 0x6e, 0xdb, 0x84, 0x01,
	0x93, 0x8c, 0x96, 0x24, 0x95, 0x35, 0x40, 0x0f, 0x49, 0xec, 0xa8, 0x08, 0xf9, 0xfd, 0x01, 0x1c,
	0xb4, 0xcc, 0x02, 0x5e, 0x1e, 0x5d, 0x01, 0x1c, 0x2c, 0x95, 0x5f, 0x48, 0xb0, 0x58, 0x67, 0xeb,
	0x6b, 0xd8, 0xee, 0x25, 0xa4, 0xf2, 0x9b, 0x90, 0x8d, 0xf7, 0x88, 0x65, 0xf6, 0x47, 0xa6, 0xac,
	0x81, 0xa0, 0x37, 0x4c, 0xb4, 0x09, 0x69, 0x11, 0x2d, 0x96, 0xd1, 0xf1, 0xc3, 0x1c, 0x4d, 0x7b,
	0xa1, 0x5d, 0xfe, 0xa5, 0x04, 0x8b, 0xfb, 0x6c, 0x93, 0x0e, 0x5f, 0xa6, 0xbf, 0x96, 0x29, 0xde,
	0x64, 0x37, 0x3a, 0x6b, 0x2d, 0x3f, 0xa0, 0x90, 0xb4, 0x89, 0x83, 0xa3, 0xc8, 0x4b, 0xae, 0x43,
	0x09, 0x03, 0x5e, 0xca, 0x5f, 0xcb, 0xcb, 0xf7, 0x60, 0x71, 0x83, 0xd8, 0xe4, 0xb4, 0x93, 0x28,
	0x99, 0xc9, 0x28, 0x3f, 0x3f, 0x97, 0xe0, 0xaa, 0xe2, 0x79, 0xf6, 0x49, 0x62, 0x42, 0x5f, 0x46,
	0xe2, 0x69, 0x4b, 0x44, 0x5b, 0x2e, 0x28, 0xc8, 0xac, 0xd6, 0xa6, 0xf9, 0x86, 0x0b, 0x68, 0x07,
	0x62, 0x7a, 0xa4, 0x8e, 0x6d, 0x9b, 0x65, 0x24, 0xad, 0xa5, 0x19, 0x41, 0xb1, 0xed, 0xf2, 0xbf,
	0x24, 0x58, 0xe2, 0x31, 0xbe, 0x6c, 0x8f, 0x86, 0x72, 0x24, 0x9f, 0x3f, 0x47, 0x83, 0x1b, 0x30,
	0x75, 0x19, 0x1b, 0xf0, 0xf7, 0x12, 0xa0, 0xd3, 0x22, 0xe8, 0x0a, 0xc8, 0x83, 0xf0, 0x40, 0xb6,
	0x4c, 0xb4, 0xcf, 0x3a, 0x06, 0x77, 0xc5, 0x57, 0xc5, 0x47, 0xe7, 0x3e, 0xba, 0xc2, 0x1e, 0xc5,
	0xf7, 0x05, 0x37, 0x46, 0xf7, 0x4d, 0x82, 0x7c, 0xae, 0x7d, 0xf3, 0x2b, 0x19, 0xe6, 0xb7, 0xc5,
	0x87, 0x58, 0x93, 0x84, 0xd8, 0xc4, 0x21, 0x46, 0xf7, 0x06, 0x51, 0xae, 0x34, 0x0a, 0xa3, 0x0e,
	0x00, 0xdc, 0xbb, 0x90, 0x26, 0x8e, 0xc9, 0x35, 0xe5, 0x91, 0x9a, 0xd3, 0xc4, 0x31, 0x99, 0xda,
	0x55, 0x98, 0x0a, 0xb1, 0xdf, 0x21, 0x61, 0x34, 0xb4, 0xa3, 0x37, 0x5a, 0xf3, 0xc7, 0xc4, 0x6f,
	0x47, 0xf3, 0x9a, 0x3d, 0xa3, 0x9b, 0x30, 0x4b, 0x31, 0x50, 0x2f, 0xd0, 0x4d, 0x12, 0x62, 0xcb,
	0x8e, 0x46, 0xf6, 0x0c, 0x27, 0x6e, 0x30, 0x1a, 0xba, 0x05, 0x79, 0x83, 0x16, 0x8f, 0xad, 0xfb,
	0xbc, 0xfa, 0x88, 0xc9, 0x30, 0x4f, 0x5a, 0x9b, 0xe3, 0x74, 0x4d, 0x90, 0xd1, 0x3b, 0x90, 0xc5,
	0x9e, 0x15, 0xa3, 0xdf, 0x69, 0x66, 0x0d, 0xb0, 0x67, 0x45, 0x78, 0xb7, 0xfc, 0x1f, 0x09, 0xf2,
	0x62, 0x78, 0xc5, 0x51, 0xfa, 0x1c, 0xe6, 0xf0, 0x31, 0xb6, 0x6c, 0x3a, 0x7a, 0x75, 0xfe, 0xc5,
	0xc6, 0x97, 0x40, 0x7d, 0x44, 0x5a, 0x87, 0x2d, 0x55, 0x14, 0x61, 0xe6, 0x31, 0xb5, 0xc2, 0xb2,
	0xc8, 0x8b, 0x26, 0x87, 0x07, 0x38, 0x45, 0x07, 0xae, 0x9c, 0x21, 0x7b, 0x46, 0xc6, 0x95, 0x64,
	0xc6, 0xb3, 0xb5, 0xf7, 0x46, 0x78, 0x44, 0x6d, 0x09, 0x6f, 0x92, 0xe5, 0x91, 0x83, 0x99, 0x24,
	0x6b, 0x45, 0x85, 0xb9, 0xa1, 0xef, 0x39, 0x0a, 0x87, 0x9a, 0x6a, 0xb3, 0xae, 0xd4, 0x37, 0x55,
	0xfd, 0x53, 0x55, 0xdb, 0xe5, 0x68, 0x28, 0x89, 0x59, 0xf2, 0x30, 0x13, 0x4b, 0xdc, 0xd1, 0xef,
	0xe6, 0xa5, 0xda, 0xff, 0x72, 0x30, 0x5b, 0xa7, 0x9e, 0x08, 0x63, 0xe8, 0x4f, 0x12, 0xcc, 0x0e,
	0x2c, 0x59, 0x34, 0xea, 0x8b, 0xfb, 0x2c, 0x74, 0x51, 0xfc, 0xe0, 0x7c, 0x4a, 0x7c, 0x8f, 0x97,
	0xeb, 0x2f, 0x95, 0x68, 0x21, 0xfd, 0xe4, 0x6f, 0x7f, 0xff, 0x85, 0xfc, 0x01, 0xaa, 0xc5, 0xbf,
	0xaf, 0x3c, 0xe3, 0xf4, 0x8f, 0x62, 0x30, 0xb4, 0x92, 0x00, 0x41, 0x2b, 0x09, 0xf0, 0x83, 0x7e,
	0x23, 0x41, 0x36, 0xb1, 0x7c, 0xd1, 0xa8, 0xb1, 0x72, 0x7a, 0x51, 0x17, 0xc7, 0xdd, 0x17, 0x65,
	0xe5, 0xa5, 0xc2, 0x26, 0xe2, 0x69, 0x77, 0x29, 0xf5, 0x15, 0xce, 0x26, 0x80, 0xda, 0xca, 0x73,
	0xf4, 0x6b, 0x19, 0x72, 0x83, 0x6b, 0x1d, 0x8d, 0x0a, 0xde, 0x99, 0x28, 0xa0, 0x78, 0x5d, 0x68,
	0x25, 0x7e, 0xdb, 0xa9, 0xc4, 0x23, 0xa5, 0xfc, 0x47, 0xe9, 0x85, 0xf2, 0x08, 0xde, 0x1d, 0xef,
	0x62, 0xa8, 0xfa, 0x7a, 0xb9, 0x53, 0x93, 0xea, 0xa5, 0xf2, 0x36, 0x4f, 0xd0, 0x6a, 0x02, 0x46,
	0xac, 0x8a, 0x45, 0xca, 0xc2, 0xf3, 0x71, 0xf9, 0x02, 0xd9, 0x5c, 0x8b, 0x97, 0x31, 0xfa, 0x42,
	0x86, 0xdc, 0x20, 0x64, 0x18, 0x19, 0xa8, 0x33, 0x11, 0xc6, 0xa8, 0x40, 0xfd, 0xf9, 0x0d, 0x07,
	0x6a, 0x21, 0xb1, 0x3a, 0x07, 0x23, 0xf4, 0xb0, 0x76, 0xaf, 0x1f, 0xa1, 0xf8, 0x87, 0xbb, 0x71,
	0x2b, 0x29, 0x11, 0xaa, 0xdf, 0xc9, 0x90, 0x1f, 0xde, 0xfc, 0xe8, 0xdb, 0x63, 0x05, 0xeb, 0x14,
	0x54, 0x18, 0x15, 0xae, 0x2f, 0xdf, 0x74, 0x5d, 0xd1, 0xfb, 0xaf, 0x26, 0x63, 0xd6, 0xdf, 0xf9,
	0x2c, 0x6a, 0x9b, 0xb5, 0xfa, 0xf9, 0xdb, 0x6e, 0xad, 0x37, 0x74, 0xdb, 0x35, 0x69, 0x05, 0xfd,
	0x5b, 0x82, 0xdc, 0x20, 0xde, 0x1b, 0x59, 0x61, 0x67, 0xc2, 0xc3, 0x51, 0x21, 0xfb, 0x99, 0xf4,
	0x42, 0xd9, 0x84, 0xc5, 0xe1, 0x5d, 0xac, 0x76, 0xbd, 0xf0, 0xe4, 0x02, 0x11, 0x4a, 0x4c, 0xa0,
	0x95, 0x8b, 0x4c, 0xa0, 0xdf, 0xca, 0x30, 0x37, 0x04, 0x5c, 0xd1, 0xdd, 0x11, 0xf7, 0x3e, 0x1b,
	0xe8, 0x8e, 0xba, 0xf8, 0x5f, 0xde, 0x70, 0xad, 0x2c, 0xb1, 0x5a, 0x11, 0x60, 0x79, 0x35, 0x86,
	0xc6, 0xbc, 0xbb, 0xca, 0xeb, 0x17, 0xa8, 0x13, 0x3c, 0x78, 0xd1, 0x35, 0x69, 0xa5, 0xf8, 0xc9,
	0x0b, 0x65, 0xe9, 0x15, 0x40, 0xf9, 0xaf, 0x4a, 0xe5, 0x30, 0x0c, 0xbd, 0x60, 0xad, 0x5a, 0x7d,
	0xf2, 0xe4, 0xc9, 0x30, 0x8a, 0xc6, 0xbd, 0xf0, 0x90, 0xff, 0x51, 0x70, 0xdb, 0xb3, 0x71, 0x78,
	0xe0, 0xfa, 0xdd, 0xf5, 0x1f, 0x4b, 0x70, 0xc3, 0x70, 0xbb, 0xaf, 0x0f, 0xf7, 0x3a, 0x1a, 0x58,
	0xd2, 0x3b, 0xb4, 0x62, 0x76, 0xa4, 0xc7, 0x6a, 0xa4, 0xd4, 0x71, 0x6d, 0xec, 0x74, 0x2a, 0xae,
	0xdf, 0xa9, 0x76, 0x88, 0xc3, 0xea, 0xa9, 0xda, 0x3f, 0xfa, 0x15, 0xff, 0x58, 0xdc, 0x13, 0x84,
	0xf6, 0x14, 0xd3, 0x78, 0xff, 0xff, 0x01, 0x00, 0x00, 0xff, 0xff, 0xfb, 0x30, 0x60, 0x87, 0xe2,
	0x18, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudMemcacheClient is the client API for CloudMemcache service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudMemcacheClient interface {
	// Lists Instances in a given project and location.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets details of a single Instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates a new Instance in a given project and location.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates an existing Instance in a given project and location.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the defined Memcached Parameters for an existing Instance.
	// This method only stages the parameters, it must be followed by
	// ApplyParameters to apply the parameters to nodes of the Memcached Instance.
	UpdateParameters(ctx context.Context, in *UpdateParametersRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single Instance.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// ApplyParameters will update current set of Parameters to the set of
	// specified nodes of the Memcached Instance.
	ApplyParameters(ctx context.Context, in *ApplyParametersRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type cloudMemcacheClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudMemcacheClient(cc grpc.ClientConnInterface) CloudMemcacheClient {
	return &cloudMemcacheClient{cc}
}

func (c *cloudMemcacheClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.memcache.v1beta2.CloudMemcache/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.cloud.memcache.v1beta2.CloudMemcache/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.memcache.v1beta2.CloudMemcache/CreateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.memcache.v1beta2.CloudMemcache/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) UpdateParameters(ctx context.Context, in *UpdateParametersRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.memcache.v1beta2.CloudMemcache/UpdateParameters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.memcache.v1beta2.CloudMemcache/DeleteInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) ApplyParameters(ctx context.Context, in *ApplyParametersRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.memcache.v1beta2.CloudMemcache/ApplyParameters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudMemcacheServer is the server API for CloudMemcache service.
type CloudMemcacheServer interface {
	// Lists Instances in a given project and location.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets details of a single Instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates a new Instance in a given project and location.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunning.Operation, error)
	// Updates an existing Instance in a given project and location.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunning.Operation, error)
	// Updates the defined Memcached Parameters for an existing Instance.
	// This method only stages the parameters, it must be followed by
	// ApplyParameters to apply the parameters to nodes of the Memcached Instance.
	UpdateParameters(context.Context, *UpdateParametersRequest) (*longrunning.Operation, error)
	// Deletes a single Instance.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunning.Operation, error)
	// ApplyParameters will update current set of Parameters to the set of
	// specified nodes of the Memcached Instance.
	ApplyParameters(context.Context, *ApplyParametersRequest) (*longrunning.Operation, error)
}

// UnimplementedCloudMemcacheServer can be embedded to have forward compatible implementations.
type UnimplementedCloudMemcacheServer struct {
}

func (*UnimplementedCloudMemcacheServer) ListInstances(ctx context.Context, req *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (*UnimplementedCloudMemcacheServer) GetInstance(ctx context.Context, req *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (*UnimplementedCloudMemcacheServer) CreateInstance(ctx context.Context, req *CreateInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (*UnimplementedCloudMemcacheServer) UpdateInstance(ctx context.Context, req *UpdateInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (*UnimplementedCloudMemcacheServer) UpdateParameters(ctx context.Context, req *UpdateParametersRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateParameters not implemented")
}
func (*UnimplementedCloudMemcacheServer) DeleteInstance(ctx context.Context, req *DeleteInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (*UnimplementedCloudMemcacheServer) ApplyParameters(ctx context.Context, req *ApplyParametersRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyParameters not implemented")
}

func RegisterCloudMemcacheServer(s *grpc.Server, srv CloudMemcacheServer) {
	s.RegisterService(&_CloudMemcache_serviceDesc, srv)
}

func _CloudMemcache_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memcache.v1beta2.CloudMemcache/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memcache.v1beta2.CloudMemcache/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memcache.v1beta2.CloudMemcache/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memcache.v1beta2.CloudMemcache/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_UpdateParameters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateParametersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).UpdateParameters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memcache.v1beta2.CloudMemcache/UpdateParameters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).UpdateParameters(ctx, req.(*UpdateParametersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memcache.v1beta2.CloudMemcache/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_ApplyParameters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyParametersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).ApplyParameters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memcache.v1beta2.CloudMemcache/ApplyParameters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).ApplyParameters(ctx, req.(*ApplyParametersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudMemcache_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.memcache.v1beta2.CloudMemcache",
	HandlerType: (*CloudMemcacheServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _CloudMemcache_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _CloudMemcache_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _CloudMemcache_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _CloudMemcache_UpdateInstance_Handler,
		},
		{
			MethodName: "UpdateParameters",
			Handler:    _CloudMemcache_UpdateParameters_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _CloudMemcache_DeleteInstance_Handler,
		},
		{
			MethodName: "ApplyParameters",
			Handler:    _CloudMemcache_ApplyParameters_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/memcache/v1beta2/cloud_memcache.proto",
}
