package bootkube

import (
	"os"
	"path/filepath"

	"github.com/openshift/installer/pkg/asset"
	"github.com/openshift/installer/pkg/asset/templates/content"
)

const (
	kubevirtInfraNamespaceFileName = "openshift-kubevirt-infra-namespace.yaml"
)

var _ asset.WritableAsset = (*KubevirtInfraNamespace)(nil)

// KubevirtInfraNamespace is an asset for the openshift-kubevirt-infra namespace
type KubevirtInfraNamespace struct {
	FileList []*asset.File
}

// Dependencies returns all of the dependencies directly needed by the asset
func (t *KubevirtInfraNamespace) Dependencies() []asset.Asset {
	return []asset.Asset{}
}

// Name returns the human-friendly name of the asset.
func (t *KubevirtInfraNamespace) Name() string {
	return "KubevirtInfraNamespace"
}

// Generate generates the actual files by this asset
func (t *KubevirtInfraNamespace) Generate(parents asset.Parents) error {
	fileName := kubevirtInfraNamespaceFileName
	data, err := content.GetBootkubeTemplate(fileName)
	if err != nil {
		return err
	}
	t.FileList = []*asset.File{
		{
			Filename: filepath.Join(content.TemplateDir, fileName),
			Data:     []byte(data),
		},
	}
	return nil
}

// Files returns the files generated by the asset.
func (t *KubevirtInfraNamespace) Files() []*asset.File {
	return t.FileList
}

// Load returns the asset from disk.
func (t *KubevirtInfraNamespace) Load(f asset.FileFetcher) (bool, error) {
	file, err := f.FetchByName(filepath.Join(content.TemplateDir, kubevirtInfraNamespaceFileName))
	if err != nil {
		if os.IsNotExist(err) {
			return false, nil
		}
		return false, err
	}
	t.FileList = []*asset.File{file}
	return true, nil
}
