// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RebootReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// If this parameter is true, the reboot is conducted through a Multi-AZ failover.
	// (If the instance isn't configured for Multi-AZ, then you can't specify true.)
	ForceFailover *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebootReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootReplicationInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RebootReplicationInstanceInput"}

	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RebootReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The replication instance that is being rebooted.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation
func (s RebootReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opRebootReplicationInstance = "RebootReplicationInstance"

// RebootReplicationInstanceRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Reboots a replication instance. Rebooting results in a momentary outage,
// until the replication instance becomes available again.
//
//    // Example sending a request using RebootReplicationInstanceRequest.
//    req := client.RebootReplicationInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RebootReplicationInstance
func (c *Client) RebootReplicationInstanceRequest(input *RebootReplicationInstanceInput) RebootReplicationInstanceRequest {
	op := &aws.Operation{
		Name:       opRebootReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootReplicationInstanceInput{}
	}

	req := c.newRequest(op, input, &RebootReplicationInstanceOutput{})
	return RebootReplicationInstanceRequest{Request: req, Input: input, Copy: c.RebootReplicationInstanceRequest}
}

// RebootReplicationInstanceRequest is the request type for the
// RebootReplicationInstance API operation.
type RebootReplicationInstanceRequest struct {
	*aws.Request
	Input *RebootReplicationInstanceInput
	Copy  func(*RebootReplicationInstanceInput) RebootReplicationInstanceRequest
}

// Send marshals and sends the RebootReplicationInstance API request.
func (r RebootReplicationInstanceRequest) Send(ctx context.Context) (*RebootReplicationInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RebootReplicationInstanceResponse{
		RebootReplicationInstanceOutput: r.Request.Data.(*RebootReplicationInstanceOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RebootReplicationInstanceResponse is the response type for the
// RebootReplicationInstance API operation.
type RebootReplicationInstanceResponse struct {
	*RebootReplicationInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RebootReplicationInstance request.
func (r *RebootReplicationInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
