// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/datacatalog/v1beta1/policytagmanager.proto

package datacatalog

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Defines policy types where policy tag can be used for.
type Taxonomy_PolicyType int32

const (
	// Unspecified policy type.
	Taxonomy_POLICY_TYPE_UNSPECIFIED Taxonomy_PolicyType = 0
	// Fine grained access control policy, which enables access control on
	// tagged resources.
	Taxonomy_FINE_GRAINED_ACCESS_CONTROL Taxonomy_PolicyType = 1
)

var Taxonomy_PolicyType_name = map[int32]string{
	0: "POLICY_TYPE_UNSPECIFIED",
	1: "FINE_GRAINED_ACCESS_CONTROL",
}

var Taxonomy_PolicyType_value = map[string]int32{
	"POLICY_TYPE_UNSPECIFIED":     0,
	"FINE_GRAINED_ACCESS_CONTROL": 1,
}

func (x Taxonomy_PolicyType) String() string {
	return proto.EnumName(Taxonomy_PolicyType_name, int32(x))
}

func (Taxonomy_PolicyType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{0, 0}
}

// A taxonomy is a collection of policy tags that classify data along a common
// axis. For instance a data *sensitivity* taxonomy could contain policy tags
// denoting PII such as age, zipcode, and SSN. A data *origin* taxonomy could
// contain policy tags to distinguish user data, employee data, partner data,
// public data.
type Taxonomy struct {
	// Output only. Resource name of this taxonomy, whose format is:
	// "projects/{project_number}/locations/{location_id}/taxonomies/{id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. User defined name of this taxonomy. It must: contain only unicode letters,
	// numbers, underscores, dashes and spaces; not start or end with spaces; and
	// be at most 200 bytes long when encoded in UTF-8.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Description of this taxonomy. It must: contain only unicode characters,
	// tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
	// long when encoded in UTF-8. If not set, defaults to an empty description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. A list of policy types that are activated for this taxonomy. If not set,
	// defaults to an empty list.
	ActivatedPolicyTypes []Taxonomy_PolicyType `protobuf:"varint,6,rep,packed,name=activated_policy_types,json=activatedPolicyTypes,proto3,enum=google.cloud.datacatalog.v1beta1.Taxonomy_PolicyType" json:"activated_policy_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Taxonomy) Reset()         { *m = Taxonomy{} }
func (m *Taxonomy) String() string { return proto.CompactTextString(m) }
func (*Taxonomy) ProtoMessage()    {}
func (*Taxonomy) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{0}
}

func (m *Taxonomy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Taxonomy.Unmarshal(m, b)
}
func (m *Taxonomy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Taxonomy.Marshal(b, m, deterministic)
}
func (m *Taxonomy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Taxonomy.Merge(m, src)
}
func (m *Taxonomy) XXX_Size() int {
	return xxx_messageInfo_Taxonomy.Size(m)
}
func (m *Taxonomy) XXX_DiscardUnknown() {
	xxx_messageInfo_Taxonomy.DiscardUnknown(m)
}

var xxx_messageInfo_Taxonomy proto.InternalMessageInfo

func (m *Taxonomy) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Taxonomy) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Taxonomy) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Taxonomy) GetActivatedPolicyTypes() []Taxonomy_PolicyType {
	if m != nil {
		return m.ActivatedPolicyTypes
	}
	return nil
}

// Denotes one policy tag in a taxonomy (e.g. ssn). Policy Tags can be defined
// in a hierarchy. For example, consider the following hierarchy:
// Geolocation -&gt; (LatLong, City, ZipCode). PolicyTag "Geolocation"
// contains three child policy tags: "LatLong", "City", and "ZipCode".
type PolicyTag struct {
	// Output only. Resource name of this policy tag, whose format is:
	// "projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. User defined name of this policy tag. It must: be unique within the parent
	// taxonomy; contain only unicode letters, numbers, underscores, dashes and
	// spaces; not start or end with spaces; and be at most 200 bytes long when
	// encoded in UTF-8.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Description of this policy tag. It must: contain only unicode characters,
	// tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
	// long when encoded in UTF-8. If not set, defaults to an empty description.
	// If not set, defaults to an empty description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource name of this policy tag's parent policy tag (e.g. for the
	// "LatLong" policy tag in the example above, this field contains the
	// resource name of the "Geolocation" policy tag). If empty, it means this
	// policy tag is a top level policy tag (e.g. this field is empty for the
	// "Geolocation" policy tag in the example above). If not set, defaults to an
	// empty string.
	ParentPolicyTag string `protobuf:"bytes,4,opt,name=parent_policy_tag,json=parentPolicyTag,proto3" json:"parent_policy_tag,omitempty"`
	// Output only. Resource names of child policy tags of this policy tag.
	ChildPolicyTags      []string `protobuf:"bytes,5,rep,name=child_policy_tags,json=childPolicyTags,proto3" json:"child_policy_tags,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PolicyTag) Reset()         { *m = PolicyTag{} }
func (m *PolicyTag) String() string { return proto.CompactTextString(m) }
func (*PolicyTag) ProtoMessage()    {}
func (*PolicyTag) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{1}
}

func (m *PolicyTag) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTag.Unmarshal(m, b)
}
func (m *PolicyTag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTag.Marshal(b, m, deterministic)
}
func (m *PolicyTag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTag.Merge(m, src)
}
func (m *PolicyTag) XXX_Size() int {
	return xxx_messageInfo_PolicyTag.Size(m)
}
func (m *PolicyTag) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTag.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTag proto.InternalMessageInfo

func (m *PolicyTag) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PolicyTag) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *PolicyTag) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *PolicyTag) GetParentPolicyTag() string {
	if m != nil {
		return m.ParentPolicyTag
	}
	return ""
}

func (m *PolicyTag) GetChildPolicyTags() []string {
	if m != nil {
		return m.ChildPolicyTags
	}
	return nil
}

// Request message for
// [CreateTaxonomy][google.cloud.datacatalog.v1beta1.PolicyTagManager.CreateTaxonomy].
type CreateTaxonomyRequest struct {
	// Required. Resource name of the project that the taxonomy will belong to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The taxonomy to be created.
	Taxonomy             *Taxonomy `protobuf:"bytes,2,opt,name=taxonomy,proto3" json:"taxonomy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateTaxonomyRequest) Reset()         { *m = CreateTaxonomyRequest{} }
func (m *CreateTaxonomyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTaxonomyRequest) ProtoMessage()    {}
func (*CreateTaxonomyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{2}
}

func (m *CreateTaxonomyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTaxonomyRequest.Unmarshal(m, b)
}
func (m *CreateTaxonomyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTaxonomyRequest.Marshal(b, m, deterministic)
}
func (m *CreateTaxonomyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTaxonomyRequest.Merge(m, src)
}
func (m *CreateTaxonomyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTaxonomyRequest.Size(m)
}
func (m *CreateTaxonomyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTaxonomyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTaxonomyRequest proto.InternalMessageInfo

func (m *CreateTaxonomyRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTaxonomyRequest) GetTaxonomy() *Taxonomy {
	if m != nil {
		return m.Taxonomy
	}
	return nil
}

// Request message for
// [DeleteTaxonomy][google.cloud.datacatalog.v1beta1.PolicyTagManager.DeleteTaxonomy].
type DeleteTaxonomyRequest struct {
	// Required. Resource name of the taxonomy to be deleted. All policy tags in
	// this taxonomy will also be deleted.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTaxonomyRequest) Reset()         { *m = DeleteTaxonomyRequest{} }
func (m *DeleteTaxonomyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTaxonomyRequest) ProtoMessage()    {}
func (*DeleteTaxonomyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{3}
}

func (m *DeleteTaxonomyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTaxonomyRequest.Unmarshal(m, b)
}
func (m *DeleteTaxonomyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTaxonomyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTaxonomyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTaxonomyRequest.Merge(m, src)
}
func (m *DeleteTaxonomyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTaxonomyRequest.Size(m)
}
func (m *DeleteTaxonomyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTaxonomyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTaxonomyRequest proto.InternalMessageInfo

func (m *DeleteTaxonomyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [UpdateTaxonomy][google.cloud.datacatalog.v1beta1.PolicyTagManager.UpdateTaxonomy].
type UpdateTaxonomyRequest struct {
	// The taxonomy to update. Only description, display_name, and activated
	// policy types can be updated.
	Taxonomy *Taxonomy `protobuf:"bytes,1,opt,name=taxonomy,proto3" json:"taxonomy,omitempty"`
	// The update mask applies to the resource. For the `FieldMask` definition,
	// see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	// If not set, defaults to all of the fields that are allowed to update.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTaxonomyRequest) Reset()         { *m = UpdateTaxonomyRequest{} }
func (m *UpdateTaxonomyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTaxonomyRequest) ProtoMessage()    {}
func (*UpdateTaxonomyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{4}
}

func (m *UpdateTaxonomyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTaxonomyRequest.Unmarshal(m, b)
}
func (m *UpdateTaxonomyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTaxonomyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTaxonomyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTaxonomyRequest.Merge(m, src)
}
func (m *UpdateTaxonomyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTaxonomyRequest.Size(m)
}
func (m *UpdateTaxonomyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTaxonomyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTaxonomyRequest proto.InternalMessageInfo

func (m *UpdateTaxonomyRequest) GetTaxonomy() *Taxonomy {
	if m != nil {
		return m.Taxonomy
	}
	return nil
}

func (m *UpdateTaxonomyRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [ListTaxonomies][google.cloud.datacatalog.v1beta1.PolicyTagManager.ListTaxonomies].
type ListTaxonomiesRequest struct {
	// Required. Resource name of the project to list the taxonomies of.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Must be a value between 1 and 1000.
	// If not set, defaults to 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request, if any. If
	// not set, defaults to an empty string.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTaxonomiesRequest) Reset()         { *m = ListTaxonomiesRequest{} }
func (m *ListTaxonomiesRequest) String() string { return proto.CompactTextString(m) }
func (*ListTaxonomiesRequest) ProtoMessage()    {}
func (*ListTaxonomiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{5}
}

func (m *ListTaxonomiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTaxonomiesRequest.Unmarshal(m, b)
}
func (m *ListTaxonomiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTaxonomiesRequest.Marshal(b, m, deterministic)
}
func (m *ListTaxonomiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTaxonomiesRequest.Merge(m, src)
}
func (m *ListTaxonomiesRequest) XXX_Size() int {
	return xxx_messageInfo_ListTaxonomiesRequest.Size(m)
}
func (m *ListTaxonomiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTaxonomiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTaxonomiesRequest proto.InternalMessageInfo

func (m *ListTaxonomiesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTaxonomiesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTaxonomiesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [ListTaxonomies][google.cloud.datacatalog.v1beta1.PolicyTagManager.ListTaxonomies].
type ListTaxonomiesResponse struct {
	// Taxonomies that the project contains.
	Taxonomies []*Taxonomy `protobuf:"bytes,1,rep,name=taxonomies,proto3" json:"taxonomies,omitempty"`
	// Token used to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTaxonomiesResponse) Reset()         { *m = ListTaxonomiesResponse{} }
func (m *ListTaxonomiesResponse) String() string { return proto.CompactTextString(m) }
func (*ListTaxonomiesResponse) ProtoMessage()    {}
func (*ListTaxonomiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{6}
}

func (m *ListTaxonomiesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTaxonomiesResponse.Unmarshal(m, b)
}
func (m *ListTaxonomiesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTaxonomiesResponse.Marshal(b, m, deterministic)
}
func (m *ListTaxonomiesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTaxonomiesResponse.Merge(m, src)
}
func (m *ListTaxonomiesResponse) XXX_Size() int {
	return xxx_messageInfo_ListTaxonomiesResponse.Size(m)
}
func (m *ListTaxonomiesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTaxonomiesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTaxonomiesResponse proto.InternalMessageInfo

func (m *ListTaxonomiesResponse) GetTaxonomies() []*Taxonomy {
	if m != nil {
		return m.Taxonomies
	}
	return nil
}

func (m *ListTaxonomiesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [GetTaxonomy][google.cloud.datacatalog.v1beta1.PolicyTagManager.GetTaxonomy].
type GetTaxonomyRequest struct {
	// Required. Resource name of the requested taxonomy.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTaxonomyRequest) Reset()         { *m = GetTaxonomyRequest{} }
func (m *GetTaxonomyRequest) String() string { return proto.CompactTextString(m) }
func (*GetTaxonomyRequest) ProtoMessage()    {}
func (*GetTaxonomyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{7}
}

func (m *GetTaxonomyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTaxonomyRequest.Unmarshal(m, b)
}
func (m *GetTaxonomyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTaxonomyRequest.Marshal(b, m, deterministic)
}
func (m *GetTaxonomyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTaxonomyRequest.Merge(m, src)
}
func (m *GetTaxonomyRequest) XXX_Size() int {
	return xxx_messageInfo_GetTaxonomyRequest.Size(m)
}
func (m *GetTaxonomyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTaxonomyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTaxonomyRequest proto.InternalMessageInfo

func (m *GetTaxonomyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [CreatePolicyTag][google.cloud.datacatalog.v1beta1.PolicyTagManager.CreatePolicyTag].
type CreatePolicyTagRequest struct {
	// Required. Resource name of the taxonomy that the policy tag will belong to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The policy tag to be created.
	PolicyTag            *PolicyTag `protobuf:"bytes,2,opt,name=policy_tag,json=policyTag,proto3" json:"policy_tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *CreatePolicyTagRequest) Reset()         { *m = CreatePolicyTagRequest{} }
func (m *CreatePolicyTagRequest) String() string { return proto.CompactTextString(m) }
func (*CreatePolicyTagRequest) ProtoMessage()    {}
func (*CreatePolicyTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{8}
}

func (m *CreatePolicyTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreatePolicyTagRequest.Unmarshal(m, b)
}
func (m *CreatePolicyTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreatePolicyTagRequest.Marshal(b, m, deterministic)
}
func (m *CreatePolicyTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreatePolicyTagRequest.Merge(m, src)
}
func (m *CreatePolicyTagRequest) XXX_Size() int {
	return xxx_messageInfo_CreatePolicyTagRequest.Size(m)
}
func (m *CreatePolicyTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreatePolicyTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreatePolicyTagRequest proto.InternalMessageInfo

func (m *CreatePolicyTagRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreatePolicyTagRequest) GetPolicyTag() *PolicyTag {
	if m != nil {
		return m.PolicyTag
	}
	return nil
}

// Request message for
// [DeletePolicyTag][google.cloud.datacatalog.v1beta1.PolicyTagManager.DeletePolicyTag].
type DeletePolicyTagRequest struct {
	// Required. Resource name of the policy tag to be deleted. All of its descendant
	// policy tags will also be deleted.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeletePolicyTagRequest) Reset()         { *m = DeletePolicyTagRequest{} }
func (m *DeletePolicyTagRequest) String() string { return proto.CompactTextString(m) }
func (*DeletePolicyTagRequest) ProtoMessage()    {}
func (*DeletePolicyTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{9}
}

func (m *DeletePolicyTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeletePolicyTagRequest.Unmarshal(m, b)
}
func (m *DeletePolicyTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeletePolicyTagRequest.Marshal(b, m, deterministic)
}
func (m *DeletePolicyTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeletePolicyTagRequest.Merge(m, src)
}
func (m *DeletePolicyTagRequest) XXX_Size() int {
	return xxx_messageInfo_DeletePolicyTagRequest.Size(m)
}
func (m *DeletePolicyTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeletePolicyTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeletePolicyTagRequest proto.InternalMessageInfo

func (m *DeletePolicyTagRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [UpdatePolicyTag][google.cloud.datacatalog.v1beta1.PolicyTagManager.UpdatePolicyTag].
type UpdatePolicyTagRequest struct {
	// The policy tag to update. Only the description, display_name, and
	// parent_policy_tag fields can be updated.
	PolicyTag *PolicyTag `protobuf:"bytes,1,opt,name=policy_tag,json=policyTag,proto3" json:"policy_tag,omitempty"`
	// The update mask applies to the resource. Only display_name, description and
	// parent_policy_tag can be updated and thus can be listed in the mask. If
	// update_mask is not provided, all allowed fields (i.e. display_name,
	// description and parent) will be updated. For more information including the
	// `FieldMask` definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	// If not set, defaults to all of the fields that are allowed to update.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdatePolicyTagRequest) Reset()         { *m = UpdatePolicyTagRequest{} }
func (m *UpdatePolicyTagRequest) String() string { return proto.CompactTextString(m) }
func (*UpdatePolicyTagRequest) ProtoMessage()    {}
func (*UpdatePolicyTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{10}
}

func (m *UpdatePolicyTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdatePolicyTagRequest.Unmarshal(m, b)
}
func (m *UpdatePolicyTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdatePolicyTagRequest.Marshal(b, m, deterministic)
}
func (m *UpdatePolicyTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdatePolicyTagRequest.Merge(m, src)
}
func (m *UpdatePolicyTagRequest) XXX_Size() int {
	return xxx_messageInfo_UpdatePolicyTagRequest.Size(m)
}
func (m *UpdatePolicyTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdatePolicyTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdatePolicyTagRequest proto.InternalMessageInfo

func (m *UpdatePolicyTagRequest) GetPolicyTag() *PolicyTag {
	if m != nil {
		return m.PolicyTag
	}
	return nil
}

func (m *UpdatePolicyTagRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [ListPolicyTags][google.cloud.datacatalog.v1beta1.PolicyTagManager.ListPolicyTags].
type ListPolicyTagsRequest struct {
	// Required. Resource name of the taxonomy to list the policy tags of.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Must be a value between 1 and 1000.
	// If not set, defaults to 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any. If
	// not set, defaults to an empty string.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPolicyTagsRequest) Reset()         { *m = ListPolicyTagsRequest{} }
func (m *ListPolicyTagsRequest) String() string { return proto.CompactTextString(m) }
func (*ListPolicyTagsRequest) ProtoMessage()    {}
func (*ListPolicyTagsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{11}
}

func (m *ListPolicyTagsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPolicyTagsRequest.Unmarshal(m, b)
}
func (m *ListPolicyTagsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPolicyTagsRequest.Marshal(b, m, deterministic)
}
func (m *ListPolicyTagsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPolicyTagsRequest.Merge(m, src)
}
func (m *ListPolicyTagsRequest) XXX_Size() int {
	return xxx_messageInfo_ListPolicyTagsRequest.Size(m)
}
func (m *ListPolicyTagsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPolicyTagsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPolicyTagsRequest proto.InternalMessageInfo

func (m *ListPolicyTagsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListPolicyTagsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListPolicyTagsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [ListPolicyTags][google.cloud.datacatalog.v1beta1.PolicyTagManager.ListPolicyTags].
type ListPolicyTagsResponse struct {
	// The policy tags that are in the requested taxonomy.
	PolicyTags []*PolicyTag `protobuf:"bytes,1,rep,name=policy_tags,json=policyTags,proto3" json:"policy_tags,omitempty"`
	// Token used to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPolicyTagsResponse) Reset()         { *m = ListPolicyTagsResponse{} }
func (m *ListPolicyTagsResponse) String() string { return proto.CompactTextString(m) }
func (*ListPolicyTagsResponse) ProtoMessage()    {}
func (*ListPolicyTagsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{12}
}

func (m *ListPolicyTagsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPolicyTagsResponse.Unmarshal(m, b)
}
func (m *ListPolicyTagsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPolicyTagsResponse.Marshal(b, m, deterministic)
}
func (m *ListPolicyTagsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPolicyTagsResponse.Merge(m, src)
}
func (m *ListPolicyTagsResponse) XXX_Size() int {
	return xxx_messageInfo_ListPolicyTagsResponse.Size(m)
}
func (m *ListPolicyTagsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPolicyTagsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPolicyTagsResponse proto.InternalMessageInfo

func (m *ListPolicyTagsResponse) GetPolicyTags() []*PolicyTag {
	if m != nil {
		return m.PolicyTags
	}
	return nil
}

func (m *ListPolicyTagsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [GetPolicyTag][google.cloud.datacatalog.v1beta1.PolicyTagManager.GetPolicyTag].
type GetPolicyTagRequest struct {
	// Required. Resource name of the requested policy tag.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetPolicyTagRequest) Reset()         { *m = GetPolicyTagRequest{} }
func (m *GetPolicyTagRequest) String() string { return proto.CompactTextString(m) }
func (*GetPolicyTagRequest) ProtoMessage()    {}
func (*GetPolicyTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_059587cf652b217c, []int{13}
}

func (m *GetPolicyTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetPolicyTagRequest.Unmarshal(m, b)
}
func (m *GetPolicyTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetPolicyTagRequest.Marshal(b, m, deterministic)
}
func (m *GetPolicyTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPolicyTagRequest.Merge(m, src)
}
func (m *GetPolicyTagRequest) XXX_Size() int {
	return xxx_messageInfo_GetPolicyTagRequest.Size(m)
}
func (m *GetPolicyTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPolicyTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetPolicyTagRequest proto.InternalMessageInfo

func (m *GetPolicyTagRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.datacatalog.v1beta1.Taxonomy_PolicyType", Taxonomy_PolicyType_name, Taxonomy_PolicyType_value)
	proto.RegisterType((*Taxonomy)(nil), "google.cloud.datacatalog.v1beta1.Taxonomy")
	proto.RegisterType((*PolicyTag)(nil), "google.cloud.datacatalog.v1beta1.PolicyTag")
	proto.RegisterType((*CreateTaxonomyRequest)(nil), "google.cloud.datacatalog.v1beta1.CreateTaxonomyRequest")
	proto.RegisterType((*DeleteTaxonomyRequest)(nil), "google.cloud.datacatalog.v1beta1.DeleteTaxonomyRequest")
	proto.RegisterType((*UpdateTaxonomyRequest)(nil), "google.cloud.datacatalog.v1beta1.UpdateTaxonomyRequest")
	proto.RegisterType((*ListTaxonomiesRequest)(nil), "google.cloud.datacatalog.v1beta1.ListTaxonomiesRequest")
	proto.RegisterType((*ListTaxonomiesResponse)(nil), "google.cloud.datacatalog.v1beta1.ListTaxonomiesResponse")
	proto.RegisterType((*GetTaxonomyRequest)(nil), "google.cloud.datacatalog.v1beta1.GetTaxonomyRequest")
	proto.RegisterType((*CreatePolicyTagRequest)(nil), "google.cloud.datacatalog.v1beta1.CreatePolicyTagRequest")
	proto.RegisterType((*DeletePolicyTagRequest)(nil), "google.cloud.datacatalog.v1beta1.DeletePolicyTagRequest")
	proto.RegisterType((*UpdatePolicyTagRequest)(nil), "google.cloud.datacatalog.v1beta1.UpdatePolicyTagRequest")
	proto.RegisterType((*ListPolicyTagsRequest)(nil), "google.cloud.datacatalog.v1beta1.ListPolicyTagsRequest")
	proto.RegisterType((*ListPolicyTagsResponse)(nil), "google.cloud.datacatalog.v1beta1.ListPolicyTagsResponse")
	proto.RegisterType((*GetPolicyTagRequest)(nil), "google.cloud.datacatalog.v1beta1.GetPolicyTagRequest")
}

func init() {
	proto.RegisterFile("google/cloud/datacatalog/v1beta1/policytagmanager.proto", fileDescriptor_059587cf652b217c)
}

var fileDescriptor_059587cf652b217c = []byte{
	// 1454 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xcf, 0x6f, 0xdb, 0x54,
	0x1c, 0xe7, 0x35, 0xdb, 0xd4, 0xbe, 0x8e, 0x76, 0x7b, 0xd0, 0xac, 0xa4, 0xc0, 0x22, 0xb3, 0x4d,
	0x23, 0x1b, 0xb6, 0xda, 0x31, 0x6d, 0xea, 0x40, 0x9b, 0x9b, 0xa6, 0xa3, 0x5d, 0x97, 0x66, 0x69,
	0xca, 0xe8, 0x84, 0x14, 0xbd, 0x26, 0x6f, 0xae, 0x99, 0x1d, 0x9b, 0xf8, 0xb5, 0x5d, 0x57, 0x45,
	0x42, 0x9c, 0x11, 0x1c, 0xb8, 0x30, 0x89, 0x03, 0x93, 0x40, 0x42, 0x48, 0x9c, 0xd8, 0x7f, 0xc0,
	0x09, 0x0e, 0x13, 0x02, 0x89, 0x43, 0x4f, 0x13, 0x02, 0x0e, 0x3b, 0x73, 0x40, 0x9c, 0x90, 0xfd,
	0x9e, 0xed, 0x67, 0x27, 0x5d, 0x9d, 0xa6, 0x70, 0xaa, 0xfb, 0xbe, 0x3f, 0xde, 0xe7, 0xfb, 0xf3,
	0xf3, 0x14, 0x78, 0x41, 0xb3, 0x2c, 0xcd, 0x20, 0x4a, 0xcd, 0xb0, 0xd6, 0xea, 0x4a, 0x1d, 0x53,
	0x5c, 0xc3, 0x14, 0x1b, 0x96, 0xa6, 0xac, 0x8f, 0xaf, 0x10, 0x8a, 0xc7, 0x15, 0xdb, 0x32, 0xf4,
	0xda, 0x26, 0xc5, 0x9a, 0x89, 0x1b, 0x58, 0x23, 0x4d, 0xd9, 0x6e, 0x5a, 0xd4, 0x42, 0x59, 0x66,
	0x28, 0x7b, 0x86, 0xb2, 0x60, 0x28, 0x73, 0xc3, 0xcc, 0x8b, 0xdc, 0x35, 0xb6, 0x75, 0x05, 0x37,
	0x1a, 0x16, 0xc5, 0x54, 0xb7, 0x1a, 0x0e, 0xb3, 0xcf, 0x1c, 0x13, 0xa4, 0x35, 0x43, 0x27, 0x0d,
	0xca, 0x05, 0xc7, 0x05, 0xc1, 0x6d, 0x9d, 0x18, 0xf5, 0xea, 0x0a, 0x59, 0xc5, 0xeb, 0xba, 0xc5,
	0x6f, 0xce, 0xbc, 0x20, 0x28, 0x34, 0x89, 0x63, 0xad, 0x35, 0x6b, 0x84, 0x8b, 0xc6, 0x77, 0x8d,
	0x86, 0xea, 0x26, 0x71, 0x28, 0x36, 0x6d, 0x1f, 0xc7, 0xcb, 0xdc, 0x44, 0xc7, 0xa6, 0xb2, 0x3e,
	0xee, 0xfe, 0xa9, 0xb2, 0x88, 0xb9, 0x3c, 0x13, 0x95, 0x47, 0x64, 0x63, 0x5c, 0xe6, 0xfd, 0xb7,
	0xb2, 0x76, 0x5b, 0x21, 0xa6, 0x4d, 0x7d, 0x61, 0x36, 0x2e, 0x64, 0xc1, 0x98, 0xd8, 0xb9, 0xc3,
	0x34, 0xa4, 0xfb, 0x29, 0xd8, 0x5f, 0xc1, 0x77, 0xad, 0x86, 0x65, 0x6e, 0xa2, 0x63, 0xf0, 0x40,
	0x03, 0x9b, 0x64, 0x14, 0x64, 0xc1, 0xe9, 0x81, 0xa9, 0xd4, 0x63, 0x35, 0x55, 0xf6, 0x0e, 0xd0,
	0x29, 0x78, 0xb8, 0xae, 0x3b, 0xb6, 0x81, 0x37, 0xab, 0x9e, 0x42, 0x9f, 0xaf, 0xd0, 0x57, 0x1e,
	0xe4, 0x82, 0xa2, 0xab, 0x77, 0x12, 0x0e, 0xd6, 0x89, 0x53, 0x6b, 0xea, 0xb6, 0x9b, 0xe6, 0xd1,
	0x94, 0xaf, 0x06, 0xca, 0xe2, 0x39, 0xb2, 0x61, 0x1a, 0xd7, 0xa8, 0xbe, 0x8e, 0x29, 0xa9, 0xf3,
	0x48, 0xab, 0x74, 0xd3, 0x26, 0xce, 0xe8, 0xa1, 0x6c, 0xea, 0xf4, 0xd0, 0xc4, 0x79, 0x79, 0xb7,
	0xc2, 0xca, 0x3e, 0x66, 0xb9, 0xe4, 0x99, 0x57, 0x36, 0x6d, 0xc2, 0x2e, 0x7a, 0x3e, 0xf0, 0x1c,
	0x4a, 0x1c, 0x69, 0x0e, 0xc2, 0xf0, 0x5f, 0x34, 0x06, 0x8f, 0x95, 0x16, 0xe6, 0x67, 0xf3, 0xcb,
	0xd5, 0xca, 0x72, 0xa9, 0x50, 0x5d, 0x2a, 0x2e, 0x96, 0x0a, 0xf9, 0xd9, 0x99, 0xd9, 0xc2, 0xf4,
	0x91, 0x67, 0xd0, 0x71, 0x38, 0x36, 0x33, 0x5b, 0x2c, 0x54, 0xaf, 0x96, 0xd5, 0xd9, 0x62, 0x61,
	0xba, 0xaa, 0xe6, 0xf3, 0x85, 0xc5, 0xc5, 0x6a, 0x7e, 0xa1, 0x58, 0x29, 0x2f, 0xcc, 0x1f, 0x01,
	0x93, 0xda, 0x13, 0xb5, 0x0e, 0x5f, 0x11, 0x41, 0x31, 0xb4, 0xd8, 0xd6, 0x1d, 0xb9, 0x66, 0x99,
	0x4a, 0x90, 0xcf, 0x37, 0xed, 0xa6, 0xf5, 0x1e, 0xa9, 0x51, 0x47, 0xd9, 0xe2, 0x5f, 0x2d, 0xc5,
	0xb0, 0x6a, 0xac, 0x07, 0x95, 0x2d, 0xff, 0xb3, 0xa5, 0x50, 0x66, 0xa1, 0x13, 0x47, 0xd9, 0xe2,
	0xdf, 0x9b, 0x2d, 0xe9, 0x51, 0x1f, 0x1c, 0xe0, 0xa8, 0xb1, 0xd6, 0x7b, 0x71, 0xb2, 0x1d, 0x8a,
	0x13, 0xad, 0x4b, 0x0e, 0x1e, 0xb5, 0x71, 0x93, 0x34, 0x68, 0x50, 0x14, 0xac, 0x8d, 0x1e, 0xf0,
	0xf4, 0x86, 0x99, 0x20, 0x84, 0xa3, 0xc0, 0xa3, 0xb5, 0x55, 0xdd, 0xa8, 0x0b, 0xaa, 0xce, 0xe8,
	0xc1, 0x6c, 0xca, 0xc7, 0x36, 0xec, 0x49, 0x03, 0x7d, 0x67, 0xf2, 0x03, 0xf0, 0x44, 0x6d, 0xc1,
	0x13, 0x4f, 0xc9, 0x5b, 0xe8, 0x7c, 0xa9, 0xa7, 0xc4, 0xf1, 0x01, 0x71, 0x6f, 0x55, 0xb6, 0x42,
	0x78, 0x2d, 0xe9, 0x4b, 0x00, 0x47, 0xf2, 0x4d, 0x82, 0x29, 0xf1, 0x4b, 0x54, 0x26, 0xef, 0xaf,
	0x11, 0x87, 0xa2, 0x3c, 0x3c, 0xc4, 0x02, 0xe4, 0xe9, 0x3d, 0xf3, 0x58, 0xed, 0xfb, 0x47, 0x3d,
	0x89, 0x92, 0x94, 0xb9, 0xcc, 0x4d, 0xd1, 0x0c, 0xec, 0xf7, 0x31, 0x78, 0x45, 0x18, 0x9c, 0xc8,
	0x25, 0x6f, 0xe4, 0x72, 0x60, 0x2b, 0xbd, 0x03, 0x47, 0xa6, 0x89, 0x41, 0xda, 0x51, 0x5e, 0x8e,
	0xb4, 0x00, 0xc7, 0x98, 0xa8, 0x15, 0x59, 0xab, 0x48, 0x9f, 0x03, 0x38, 0xb2, 0x64, 0xd7, 0x3b,
	0x24, 0x40, 0xc4, 0x0e, 0xf6, 0x8e, 0x1d, 0x5d, 0x82, 0x83, 0x6b, 0xde, 0x05, 0xde, 0x92, 0xe1,
	0x69, 0xc8, 0xf8, 0xae, 0xfc, 0x3d, 0x24, 0xcf, 0xb8, 0x7b, 0xe8, 0x3a, 0x76, 0xee, 0x94, 0x21,
	0x53, 0x77, 0xbf, 0xa5, 0xcf, 0x00, 0x1c, 0x99, 0xd7, 0x1d, 0x5a, 0x09, 0xaa, 0xba, 0xaf, 0xf5,
	0x19, 0x83, 0x03, 0x36, 0xd6, 0x48, 0xd5, 0xd1, 0xef, 0xb1, 0x29, 0x39, 0x58, 0xee, 0x77, 0x0f,
	0x16, 0xf5, 0x7b, 0x04, 0xbd, 0x04, 0xa1, 0x27, 0xa4, 0xd6, 0x1d, 0xe2, 0x0f, 0x87, 0xa7, 0x5e,
	0x71, 0x0f, 0xa4, 0x8f, 0x00, 0x4c, 0xc7, 0xa1, 0x39, 0xb6, 0xd5, 0x70, 0x08, 0x9a, 0x83, 0x30,
	0x6c, 0xc3, 0x51, 0x90, 0x4d, 0x75, 0x99, 0x3c, 0xc1, 0x1a, 0x9d, 0x82, 0xc3, 0x0d, 0x72, 0x97,
	0x56, 0x05, 0x28, 0xde, 0x38, 0x97, 0x9f, 0x75, 0x8f, 0x4b, 0x01, 0x9c, 0x25, 0x88, 0xae, 0x12,
	0xba, 0xef, 0xfd, 0xf1, 0x0d, 0x80, 0x69, 0x36, 0x20, 0xc1, 0x2c, 0xfa, 0xbe, 0xa7, 0x63, 0x15,
	0x38, 0xeb, 0x79, 0x3f, 0x85, 0x12, 0x0d, 0x74, 0x50, 0x82, 0x39, 0x08, 0x85, 0xd5, 0xc2, 0xba,
	0xe3, 0xcc, 0xee, 0xb9, 0x0a, 0x1d, 0x0d, 0x04, 0xb3, 0x2d, 0xdd, 0x82, 0x69, 0x36, 0x26, 0x6d,
	0x58, 0xaf, 0x44, 0xf2, 0xc0, 0x91, 0x26, 0x5b, 0x3d, 0x3c, 0x11, 0x0f, 0x00, 0x4c, 0xb3, 0x41,
	0x69, 0x73, 0x1e, 0x0d, 0x01, 0xf4, 0x12, 0x42, 0x6f, 0xd3, 0x72, 0x9f, 0x4f, 0x4b, 0xb8, 0x63,
	0xf7, 0xb7, 0x56, 0xbd, 0x8c, 0xcb, 0xc7, 0x7c, 0x5c, 0x44, 0x6c, 0x7c, 0x5c, 0xe6, 0xe1, 0xa0,
	0x48, 0x19, 0x6c, 0x5e, 0xba, 0x4a, 0x20, 0x0c, 0xf7, 0x7b, 0xe2, 0x81, 0xb9, 0x09, 0x9f, 0xbb,
	0x4a, 0xe8, 0xfe, 0x77, 0xca, 0xc4, 0x1f, 0x69, 0x78, 0x24, 0x38, 0xbb, 0xce, 0x9e, 0xa7, 0xe8,
	0x11, 0x80, 0x43, 0x51, 0xa2, 0x41, 0x17, 0x76, 0x8f, 0xb0, 0x23, 0x35, 0x65, 0xba, 0x58, 0x25,
	0xd2, 0xcd, 0x6d, 0x95, 0x13, 0xf5, 0x59, 0x7f, 0x23, 0x7f, 0xf8, 0xcb, 0xef, 0x9f, 0xf6, 0x5d,
	0x96, 0xce, 0x05, 0xaf, 0xcf, 0x2d, 0xa6, 0x10, 0xbe, 0x4d, 0x72, 0x02, 0xb5, 0xe6, 0x44, 0x4a,
	0x9d, 0x0c, 0xd7, 0xfa, 0x57, 0x00, 0x0e, 0x45, 0x39, 0x29, 0x49, 0x40, 0x1d, 0x59, 0x2c, 0x93,
	0x6e, 0xeb, 0xef, 0x82, 0xfb, 0x64, 0x95, 0xa6, 0xb6, 0x55, 0x2f, 0xa5, 0x1e, 0xe2, 0xf3, 0x39,
	0x01, 0xb1, 0x7b, 0xba, 0x03, 0x5e, 0xf1, 0x05, 0x90, 0x6b, 0xa1, 0x9f, 0x00, 0x1c, 0x8a, 0x12,
	0x5c, 0x12, 0x9c, 0x1d, 0x29, 0xb1, 0xab, 0xc4, 0x2f, 0x6f, 0xab, 0xfd, 0x91, 0x8c, 0xbf, 0x35,
	0xf1, 0x46, 0x88, 0xdf, 0x97, 0xc8, 0x89, 0x03, 0x11, 0x52, 0xff, 0x03, 0x80, 0x43, 0x51, 0xe6,
	0x49, 0x12, 0x52, 0x47, 0x1a, 0xcd, 0x5c, 0xec, 0xde, 0x90, 0x4d, 0xad, 0x34, 0xbd, 0xad, 0xf2,
	0xbd, 0xc0, 0xca, 0x83, 0xf6, 0xd2, 0x50, 0xe8, 0x3b, 0x00, 0x07, 0x05, 0xde, 0x42, 0xaf, 0xef,
	0x8e, 0xa7, 0x9d, 0xe6, 0xba, 0x2a, 0x4c, 0xb4, 0xa9, 0xd0, 0x9e, 0x9a, 0xea, 0x37, 0x00, 0x87,
	0x63, 0xac, 0x88, 0x2e, 0x26, 0x1d, 0xe7, 0xf8, 0xca, 0xc9, 0x74, 0xb3, 0xea, 0xa4, 0xd5, 0x6d,
	0x95, 0x3f, 0xc9, 0xcf, 0x86, 0x4b, 0xd3, 0x8b, 0xa5, 0x28, 0x5d, 0x49, 0x58, 0x81, 0x68, 0x34,
	0xc2, 0xe3, 0x78, 0x52, 0x20, 0x32, 0xf4, 0x10, 0xc0, 0xe1, 0x18, 0x9d, 0x26, 0x09, 0xb2, 0x33,
	0x03, 0xef, 0x38, 0xe3, 0x0b, 0x62, 0x39, 0xa6, 0x72, 0x57, 0xba, 0x2f, 0x87, 0xf8, 0xb8, 0xcf,
	0xb5, 0xd0, 0x9f, 0x00, 0x0e, 0xc7, 0x88, 0x3a, 0x09, 0xec, 0xce, 0xdc, 0xde, 0x5d, 0x6d, 0x8c,
	0x6d, 0x15, 0xc6, 0x8a, 0xb2, 0x3c, 0x71, 0x4d, 0x28, 0x4a, 0x20, 0x93, 0xf7, 0x16, 0x5c, 0xa4,
	0x3e, 0xbf, 0xf2, 0x35, 0x10, 0x32, 0x6a, 0xd2, 0x35, 0xd0, 0xf6, 0x3e, 0x48, 0xba, 0x06, 0xda,
	0xc9, 0x5b, 0xba, 0x11, 0x5d, 0x03, 0x53, 0xa8, 0xe7, 0x26, 0x44, 0xdf, 0x03, 0x78, 0x58, 0xa4,
	0x66, 0x74, 0x3e, 0xd1, 0x52, 0xe8, 0xad, 0x76, 0xd1, 0x3e, 0x44, 0xbd, 0xf7, 0xe1, 0x5f, 0x2c,
	0x8a, 0x59, 0x6c, 0xb2, 0x4b, 0x90, 0xe4, 0xc3, 0xd1, 0xb1, 0x29, 0xaf, 0x7b, 0x90, 0x03, 0xa1,
	0x0f, 0x79, 0x24, 0xa6, 0xc3, 0xa4, 0xd2, 0xd7, 0xc0, 0x83, 0xf5, 0x00, 0x48, 0xd3, 0x21, 0x2e,
	0xff, 0x57, 0xa6, 0x64, 0xf4, 0xa1, 0x09, 0xb7, 0x4d, 0x82, 0xdc, 0xad, 0xb7, 0xa5, 0x1b, 0x7b,
	0x73, 0x15, 0xeb, 0xc8, 0x98, 0x5f, 0x2f, 0xec, 0xc5, 0xa7, 0x85, 0xbd, 0xf8, 0xbf, 0x86, 0xed,
	0xfc, 0x47, 0x61, 0xc7, 0xfc, 0xa2, 0x2f, 0xfa, 0x20, 0xaa, 0x10, 0xc7, 0x3b, 0x24, 0x4d, 0x53,
	0x77, 0x1c, 0xd7, 0x07, 0x3a, 0x1d, 0x0b, 0xac, 0x5d, 0xc5, 0x4f, 0xc1, 0xab, 0x09, 0x34, 0xf9,
	0xc8, 0x3d, 0x64, 0x69, 0xf9, 0x16, 0x48, 0x73, 0x7b, 0x4d, 0x0b, 0x6d, 0xf3, 0xee, 0x26, 0xe7,
	0x5d, 0xe9, 0xe6, 0xbe, 0x24, 0xa7, 0xa3, 0xf7, 0x4c, 0xf1, 0x47, 0x35, 0xb3, 0xf3, 0x33, 0xfa,
	0x67, 0x55, 0x5e, 0xa5, 0xd4, 0x76, 0x26, 0x15, 0x65, 0x63, 0x63, 0x23, 0xfe, 0xc6, 0xc6, 0x6b,
	0x74, 0x95, 0xfd, 0x7e, 0xfa, 0x9a, 0x6d, 0x60, 0x7a, 0xdb, 0x6a, 0x9a, 0x53, 0x9f, 0x00, 0x78,
	0xa2, 0x66, 0x99, 0xbb, 0x0e, 0xf9, 0xd4, 0x48, 0xfc, 0x35, 0x5e, 0x72, 0x29, 0xa8, 0x04, 0x6e,
	0x5d, 0xe3, 0xa6, 0x9a, 0x65, 0xe0, 0x86, 0x26, 0x5b, 0x4d, 0x4d, 0xd1, 0x48, 0xc3, 0x23, 0x28,
	0x25, 0x04, 0xb0, 0xf3, 0xef, 0xb6, 0x97, 0x84, 0xb3, 0xbf, 0x01, 0x58, 0x39, 0xe4, 0x99, 0x9e,
	0xfb, 0x37, 0x00, 0x00, 0xff, 0xff, 0x42, 0xc0, 0xa8, 0x30, 0xbf, 0x16, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PolicyTagManagerClient is the client API for PolicyTagManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PolicyTagManagerClient interface {
	// Creates a taxonomy in the specified project.
	CreateTaxonomy(ctx context.Context, in *CreateTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error)
	// Deletes a taxonomy. This operation will also delete all
	// policy tags in this taxonomy along with their associated policies.
	DeleteTaxonomy(ctx context.Context, in *DeleteTaxonomyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates a taxonomy.
	UpdateTaxonomy(ctx context.Context, in *UpdateTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error)
	// Lists all taxonomies in a project in a particular location that the caller
	// has permission to view.
	ListTaxonomies(ctx context.Context, in *ListTaxonomiesRequest, opts ...grpc.CallOption) (*ListTaxonomiesResponse, error)
	// Gets a taxonomy.
	GetTaxonomy(ctx context.Context, in *GetTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error)
	// Creates a policy tag in the specified taxonomy.
	CreatePolicyTag(ctx context.Context, in *CreatePolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error)
	// Deletes a policy tag. Also deletes all of its descendant policy tags.
	DeletePolicyTag(ctx context.Context, in *DeletePolicyTagRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates a policy tag.
	UpdatePolicyTag(ctx context.Context, in *UpdatePolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error)
	// Lists all policy tags in a taxonomy.
	ListPolicyTags(ctx context.Context, in *ListPolicyTagsRequest, opts ...grpc.CallOption) (*ListPolicyTagsResponse, error)
	// Gets a policy tag.
	GetPolicyTag(ctx context.Context, in *GetPolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error)
	// Gets the IAM policy for a taxonomy or a policy tag.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the IAM policy for a taxonomy or a policy tag.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns the permissions that a caller has on the specified taxonomy or
	// policy tag.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type policyTagManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewPolicyTagManagerClient(cc grpc.ClientConnInterface) PolicyTagManagerClient {
	return &policyTagManagerClient{cc}
}

func (c *policyTagManagerClient) CreateTaxonomy(ctx context.Context, in *CreateTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error) {
	out := new(Taxonomy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/CreateTaxonomy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) DeleteTaxonomy(ctx context.Context, in *DeleteTaxonomyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/DeleteTaxonomy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) UpdateTaxonomy(ctx context.Context, in *UpdateTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error) {
	out := new(Taxonomy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/UpdateTaxonomy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) ListTaxonomies(ctx context.Context, in *ListTaxonomiesRequest, opts ...grpc.CallOption) (*ListTaxonomiesResponse, error) {
	out := new(ListTaxonomiesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/ListTaxonomies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) GetTaxonomy(ctx context.Context, in *GetTaxonomyRequest, opts ...grpc.CallOption) (*Taxonomy, error) {
	out := new(Taxonomy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/GetTaxonomy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) CreatePolicyTag(ctx context.Context, in *CreatePolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error) {
	out := new(PolicyTag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/CreatePolicyTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) DeletePolicyTag(ctx context.Context, in *DeletePolicyTagRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/DeletePolicyTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) UpdatePolicyTag(ctx context.Context, in *UpdatePolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error) {
	out := new(PolicyTag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/UpdatePolicyTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) ListPolicyTags(ctx context.Context, in *ListPolicyTagsRequest, opts ...grpc.CallOption) (*ListPolicyTagsResponse, error) {
	out := new(ListPolicyTagsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/ListPolicyTags", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) GetPolicyTag(ctx context.Context, in *GetPolicyTagRequest, opts ...grpc.CallOption) (*PolicyTag, error) {
	out := new(PolicyTag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/GetPolicyTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyTagManagerClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1beta1.PolicyTagManager/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PolicyTagManagerServer is the server API for PolicyTagManager service.
type PolicyTagManagerServer interface {
	// Creates a taxonomy in the specified project.
	CreateTaxonomy(context.Context, *CreateTaxonomyRequest) (*Taxonomy, error)
	// Deletes a taxonomy. This operation will also delete all
	// policy tags in this taxonomy along with their associated policies.
	DeleteTaxonomy(context.Context, *DeleteTaxonomyRequest) (*empty.Empty, error)
	// Updates a taxonomy.
	UpdateTaxonomy(context.Context, *UpdateTaxonomyRequest) (*Taxonomy, error)
	// Lists all taxonomies in a project in a particular location that the caller
	// has permission to view.
	ListTaxonomies(context.Context, *ListTaxonomiesRequest) (*ListTaxonomiesResponse, error)
	// Gets a taxonomy.
	GetTaxonomy(context.Context, *GetTaxonomyRequest) (*Taxonomy, error)
	// Creates a policy tag in the specified taxonomy.
	CreatePolicyTag(context.Context, *CreatePolicyTagRequest) (*PolicyTag, error)
	// Deletes a policy tag. Also deletes all of its descendant policy tags.
	DeletePolicyTag(context.Context, *DeletePolicyTagRequest) (*empty.Empty, error)
	// Updates a policy tag.
	UpdatePolicyTag(context.Context, *UpdatePolicyTagRequest) (*PolicyTag, error)
	// Lists all policy tags in a taxonomy.
	ListPolicyTags(context.Context, *ListPolicyTagsRequest) (*ListPolicyTagsResponse, error)
	// Gets a policy tag.
	GetPolicyTag(context.Context, *GetPolicyTagRequest) (*PolicyTag, error)
	// Gets the IAM policy for a taxonomy or a policy tag.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the IAM policy for a taxonomy or a policy tag.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns the permissions that a caller has on the specified taxonomy or
	// policy tag.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedPolicyTagManagerServer can be embedded to have forward compatible implementations.
type UnimplementedPolicyTagManagerServer struct {
}

func (*UnimplementedPolicyTagManagerServer) CreateTaxonomy(ctx context.Context, req *CreateTaxonomyRequest) (*Taxonomy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTaxonomy not implemented")
}
func (*UnimplementedPolicyTagManagerServer) DeleteTaxonomy(ctx context.Context, req *DeleteTaxonomyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTaxonomy not implemented")
}
func (*UnimplementedPolicyTagManagerServer) UpdateTaxonomy(ctx context.Context, req *UpdateTaxonomyRequest) (*Taxonomy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTaxonomy not implemented")
}
func (*UnimplementedPolicyTagManagerServer) ListTaxonomies(ctx context.Context, req *ListTaxonomiesRequest) (*ListTaxonomiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTaxonomies not implemented")
}
func (*UnimplementedPolicyTagManagerServer) GetTaxonomy(ctx context.Context, req *GetTaxonomyRequest) (*Taxonomy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTaxonomy not implemented")
}
func (*UnimplementedPolicyTagManagerServer) CreatePolicyTag(ctx context.Context, req *CreatePolicyTagRequest) (*PolicyTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePolicyTag not implemented")
}
func (*UnimplementedPolicyTagManagerServer) DeletePolicyTag(ctx context.Context, req *DeletePolicyTagRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePolicyTag not implemented")
}
func (*UnimplementedPolicyTagManagerServer) UpdatePolicyTag(ctx context.Context, req *UpdatePolicyTagRequest) (*PolicyTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePolicyTag not implemented")
}
func (*UnimplementedPolicyTagManagerServer) ListPolicyTags(ctx context.Context, req *ListPolicyTagsRequest) (*ListPolicyTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPolicyTags not implemented")
}
func (*UnimplementedPolicyTagManagerServer) GetPolicyTag(ctx context.Context, req *GetPolicyTagRequest) (*PolicyTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPolicyTag not implemented")
}
func (*UnimplementedPolicyTagManagerServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedPolicyTagManagerServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedPolicyTagManagerServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterPolicyTagManagerServer(s *grpc.Server, srv PolicyTagManagerServer) {
	s.RegisterService(&_PolicyTagManager_serviceDesc, srv)
}

func _PolicyTagManager_CreateTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).CreateTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/CreateTaxonomy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).CreateTaxonomy(ctx, req.(*CreateTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_DeleteTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).DeleteTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/DeleteTaxonomy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).DeleteTaxonomy(ctx, req.(*DeleteTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_UpdateTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).UpdateTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/UpdateTaxonomy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).UpdateTaxonomy(ctx, req.(*UpdateTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_ListTaxonomies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTaxonomiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).ListTaxonomies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/ListTaxonomies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).ListTaxonomies(ctx, req.(*ListTaxonomiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_GetTaxonomy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaxonomyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).GetTaxonomy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/GetTaxonomy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).GetTaxonomy(ctx, req.(*GetTaxonomyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_CreatePolicyTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePolicyTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).CreatePolicyTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/CreatePolicyTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).CreatePolicyTag(ctx, req.(*CreatePolicyTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_DeletePolicyTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePolicyTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).DeletePolicyTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/DeletePolicyTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).DeletePolicyTag(ctx, req.(*DeletePolicyTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_UpdatePolicyTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePolicyTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).UpdatePolicyTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/UpdatePolicyTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).UpdatePolicyTag(ctx, req.(*UpdatePolicyTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_ListPolicyTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPolicyTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).ListPolicyTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/ListPolicyTags",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).ListPolicyTags(ctx, req.(*ListPolicyTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_GetPolicyTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPolicyTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).GetPolicyTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/GetPolicyTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).GetPolicyTag(ctx, req.(*GetPolicyTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PolicyTagManager_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTagManagerServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1beta1.PolicyTagManager/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTagManagerServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PolicyTagManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1beta1.PolicyTagManager",
	HandlerType: (*PolicyTagManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTaxonomy",
			Handler:    _PolicyTagManager_CreateTaxonomy_Handler,
		},
		{
			MethodName: "DeleteTaxonomy",
			Handler:    _PolicyTagManager_DeleteTaxonomy_Handler,
		},
		{
			MethodName: "UpdateTaxonomy",
			Handler:    _PolicyTagManager_UpdateTaxonomy_Handler,
		},
		{
			MethodName: "ListTaxonomies",
			Handler:    _PolicyTagManager_ListTaxonomies_Handler,
		},
		{
			MethodName: "GetTaxonomy",
			Handler:    _PolicyTagManager_GetTaxonomy_Handler,
		},
		{
			MethodName: "CreatePolicyTag",
			Handler:    _PolicyTagManager_CreatePolicyTag_Handler,
		},
		{
			MethodName: "DeletePolicyTag",
			Handler:    _PolicyTagManager_DeletePolicyTag_Handler,
		},
		{
			MethodName: "UpdatePolicyTag",
			Handler:    _PolicyTagManager_UpdatePolicyTag_Handler,
		},
		{
			MethodName: "ListPolicyTags",
			Handler:    _PolicyTagManager_ListPolicyTags_Handler,
		},
		{
			MethodName: "GetPolicyTag",
			Handler:    _PolicyTagManager_GetPolicyTag_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _PolicyTagManager_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _PolicyTagManager_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _PolicyTagManager_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1beta1/policytagmanager.proto",
}
