// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package swf

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow execution.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The workflow execution to describe.
	//
	// Execution is a required field
	Execution *WorkflowExecution `locationName:"execution" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkflowExecutionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeWorkflowExecutionInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 1))
	}

	if s.Execution == nil {
		invalidParams.Add(aws.NewErrParamRequired("Execution"))
	}
	if s.Execution != nil {
		if err := s.Execution.Validate(); err != nil {
			invalidParams.AddNested("Execution", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains details about a workflow execution.
type DescribeWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The configuration settings for this workflow execution including timeout
	// values, tasklist etc.
	//
	// ExecutionConfiguration is a required field
	ExecutionConfiguration *WorkflowExecutionConfiguration `locationName:"executionConfiguration" type:"structure" required:"true"`

	// Information about the workflow execution.
	//
	// ExecutionInfo is a required field
	ExecutionInfo *WorkflowExecutionInfo `locationName:"executionInfo" type:"structure" required:"true"`

	// The time when the last activity task was scheduled for this workflow execution.
	// You can use this information to determine if the workflow has not made progress
	// for an unusually long period of time and might require a corrective action.
	LatestActivityTaskTimestamp *time.Time `locationName:"latestActivityTaskTimestamp" type:"timestamp"`

	// The latest executionContext provided by the decider for this workflow execution.
	// A decider can provide an executionContext (a free-form string) when closing
	// a decision task using RespondDecisionTaskCompleted.
	LatestExecutionContext *string `locationName:"latestExecutionContext" type:"string"`

	// The number of tasks for this workflow execution. This includes open and closed
	// tasks of all types.
	//
	// OpenCounts is a required field
	OpenCounts *WorkflowExecutionOpenCounts `locationName:"openCounts" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeWorkflowExecution = "DescribeWorkflowExecution"

// DescribeWorkflowExecutionRequest returns a request value for making API operation for
// Amazon Simple Workflow Service.
//
// Returns information about the specified workflow execution including its
// type and some statistics.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
//    // Example sending a request using DescribeWorkflowExecutionRequest.
//    req := client.DescribeWorkflowExecutionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeWorkflowExecutionRequest(input *DescribeWorkflowExecutionInput) DescribeWorkflowExecutionRequest {
	op := &aws.Operation{
		Name:       opDescribeWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkflowExecutionInput{}
	}

	req := c.newRequest(op, input, &DescribeWorkflowExecutionOutput{})
	return DescribeWorkflowExecutionRequest{Request: req, Input: input, Copy: c.DescribeWorkflowExecutionRequest}
}

// DescribeWorkflowExecutionRequest is the request type for the
// DescribeWorkflowExecution API operation.
type DescribeWorkflowExecutionRequest struct {
	*aws.Request
	Input *DescribeWorkflowExecutionInput
	Copy  func(*DescribeWorkflowExecutionInput) DescribeWorkflowExecutionRequest
}

// Send marshals and sends the DescribeWorkflowExecution API request.
func (r DescribeWorkflowExecutionRequest) Send(ctx context.Context) (*DescribeWorkflowExecutionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeWorkflowExecutionResponse{
		DescribeWorkflowExecutionOutput: r.Request.Data.(*DescribeWorkflowExecutionOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeWorkflowExecutionResponse is the response type for the
// DescribeWorkflowExecution API operation.
type DescribeWorkflowExecutionResponse struct {
	*DescribeWorkflowExecutionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeWorkflowExecution request.
func (r *DescribeWorkflowExecutionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
