// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListAssignmentsForHITInput struct {
	_ struct{} `type:"structure"`

	// The status of the assignments to return: Submitted | Approved | Rejected
	AssignmentStatuses []AssignmentStatus `type:"list"`

	// The ID of the HIT.
	//
	// HITId is a required field
	HITId *string `min:"1" type:"string" required:"true"`

	MaxResults *int64 `min:"1" type:"integer"`

	// Pagination token
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssignmentsForHITInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssignmentsForHITInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAssignmentsForHITInput"}

	if s.HITId == nil {
		invalidParams.Add(aws.NewErrParamRequired("HITId"))
	}
	if s.HITId != nil && len(*s.HITId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HITId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAssignmentsForHITOutput struct {
	_ struct{} `type:"structure"`

	// The collection of Assignment data structures returned by this call.
	Assignments []Assignment `type:"list"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of assignments on the page in the filtered results list, equivalent
	// to the number of assignments returned by this call.
	NumResults *int64 `type:"integer"`
}

// String returns the string representation
func (s ListAssignmentsForHITOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAssignmentsForHIT = "ListAssignmentsForHIT"

// ListAssignmentsForHITRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The ListAssignmentsForHIT operation retrieves completed assignments for a
// HIT. You can use this operation to retrieve the results for a HIT.
//
// You can get assignments for a HIT at any time, even if the HIT is not yet
// Reviewable. If a HIT requested multiple assignments, and has received some
// results but has not yet become Reviewable, you can still retrieve the partial
// results with this operation.
//
// Use the AssignmentStatus parameter to control which set of assignments for
// a HIT are returned. The ListAssignmentsForHIT operation can return submitted
// assignments awaiting approval, or it can return assignments that have already
// been approved or rejected. You can set AssignmentStatus=Approved,Rejected
// to get assignments that have already been approved and rejected together
// in one result set.
//
// Only the Requester who created the HIT can retrieve the assignments for that
// HIT.
//
// Results are sorted and divided into numbered pages and the operation returns
// a single page of results. You can use the parameters of the operation to
// control sorting and pagination.
//
//    // Example sending a request using ListAssignmentsForHITRequest.
//    req := client.ListAssignmentsForHITRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListAssignmentsForHIT
func (c *Client) ListAssignmentsForHITRequest(input *ListAssignmentsForHITInput) ListAssignmentsForHITRequest {
	op := &aws.Operation{
		Name:       opListAssignmentsForHIT,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssignmentsForHITInput{}
	}

	req := c.newRequest(op, input, &ListAssignmentsForHITOutput{})
	return ListAssignmentsForHITRequest{Request: req, Input: input, Copy: c.ListAssignmentsForHITRequest}
}

// ListAssignmentsForHITRequest is the request type for the
// ListAssignmentsForHIT API operation.
type ListAssignmentsForHITRequest struct {
	*aws.Request
	Input *ListAssignmentsForHITInput
	Copy  func(*ListAssignmentsForHITInput) ListAssignmentsForHITRequest
}

// Send marshals and sends the ListAssignmentsForHIT API request.
func (r ListAssignmentsForHITRequest) Send(ctx context.Context) (*ListAssignmentsForHITResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAssignmentsForHITResponse{
		ListAssignmentsForHITOutput: r.Request.Data.(*ListAssignmentsForHITOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAssignmentsForHITRequestPaginator returns a paginator for ListAssignmentsForHIT.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAssignmentsForHITRequest(input)
//   p := mturk.NewListAssignmentsForHITRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAssignmentsForHITPaginator(req ListAssignmentsForHITRequest) ListAssignmentsForHITPaginator {
	return ListAssignmentsForHITPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAssignmentsForHITInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAssignmentsForHITPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAssignmentsForHITPaginator struct {
	aws.Pager
}

func (p *ListAssignmentsForHITPaginator) CurrentPage() *ListAssignmentsForHITOutput {
	return p.Pager.CurrentPage().(*ListAssignmentsForHITOutput)
}

// ListAssignmentsForHITResponse is the response type for the
// ListAssignmentsForHIT API operation.
type ListAssignmentsForHITResponse struct {
	*ListAssignmentsForHITOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAssignmentsForHIT request.
func (r *ListAssignmentsForHITResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
