// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StopMultiplexInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopMultiplexInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopMultiplexInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopMultiplexInput"}

	if s.MultiplexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MultiplexId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StopMultiplexInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MultiplexId != nil {
		v := *s.MultiplexId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "multiplexId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StopMultiplexOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	AvailabilityZones []string `locationName:"availabilityZones" type:"list"`

	Destinations []MultiplexOutputDestination `locationName:"destinations" type:"list"`

	Id *string `locationName:"id" type:"string"`

	// Contains configuration for a Multiplex event
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	ProgramCount *int64 `locationName:"programCount" type:"integer"`

	// The current state of the multiplex.
	State MultiplexState `locationName:"state" type:"string" enum:"true"`

	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s StopMultiplexOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StopMultiplexOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AvailabilityZones != nil {
		v := s.AvailabilityZones

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "availabilityZones", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Destinations != nil {
		v := s.Destinations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "destinations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MultiplexSettings != nil {
		v := s.MultiplexSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "multiplexSettings", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PipelinesRunningCount != nil {
		v := *s.PipelinesRunningCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pipelinesRunningCount", protocol.Int64Value(v), metadata)
	}
	if s.ProgramCount != nil {
		v := *s.ProgramCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "programCount", protocol.Int64Value(v), metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opStopMultiplex = "StopMultiplex"

// StopMultiplexRequest returns a request value for making API operation for
// AWS Elemental MediaLive.
//
// Stops a running multiplex. If the multiplex isn't running, this action has
// no effect.
//
//    // Example sending a request using StopMultiplexRequest.
//    req := client.StopMultiplexRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex
func (c *Client) StopMultiplexRequest(input *StopMultiplexInput) StopMultiplexRequest {
	op := &aws.Operation{
		Name:       opStopMultiplex,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/stop",
	}

	if input == nil {
		input = &StopMultiplexInput{}
	}

	req := c.newRequest(op, input, &StopMultiplexOutput{})
	return StopMultiplexRequest{Request: req, Input: input, Copy: c.StopMultiplexRequest}
}

// StopMultiplexRequest is the request type for the
// StopMultiplex API operation.
type StopMultiplexRequest struct {
	*aws.Request
	Input *StopMultiplexInput
	Copy  func(*StopMultiplexInput) StopMultiplexRequest
}

// Send marshals and sends the StopMultiplex API request.
func (r StopMultiplexRequest) Send(ctx context.Context) (*StopMultiplexResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopMultiplexResponse{
		StopMultiplexOutput: r.Request.Data.(*StopMultiplexOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopMultiplexResponse is the response type for the
// StopMultiplex API operation.
type StopMultiplexResponse struct {
	*StopMultiplexOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopMultiplex request.
func (r *StopMultiplexResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
